open Dash.NET
open Dash.NET.Giraffe
open Dash.NET.DCC

let layout =
    Checklist.checklist "checklist" [
        Checklist.Attr.options [
            ChecklistOption.init("New York City", "NYC")
            ChecklistOption.init("Montréal", "MTL")
            ChecklistOption.init("San Francisco", "SF")
        ]
        Checklist.Attr.value ["NYC"; "MTL"]
    ]


[<EntryPoint>]
let main argv =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.run argv (DashGiraffeConfig.initDefault "localhost")
