open Dash.NET

let out_all_types = "out-all-types"
let outputTarget = out_all_types @. Children

let ALLOWED_TYPES = [
    InputType.Text
    InputType.Number
    InputType.Password
    InputType.Email
    InputType.Search
    InputType.Tel
    InputType.Url
    InputType.Range
    InputType.Hidden
]

let layout =
    Html.div [
        Attr.children [
            for t in ALLOWED_TYPES ->
                Input.input (sprintf "input_%s" (InputType.toString t)) [
                    Input.Attr.inputType t
                    Input.Attr.placeholder (sprintf "input type %s" (InputType.toString t))
                    Input.Attr.value ""
                ]
            yield Html.div [ Attr.id out_all_types ]
        ]
    ]

let callback =
    Callback.singleOut (
        [ for t in ALLOWED_TYPES -> ((sprintf "input_%s" (InputType.toString t)) @. Value) ],
        outputTarget,
        (fun textInput
             numberInput
             passwordInput
             emailInput
             searchInput
             telInput
             urlInput
             rangeInput
             hiddenInput ->
            outputTarget => 
                System.String.Join(
                    " | ",
                    [ textInput
                      numberInput
                      passwordInput
                      emailInput
                      searchInput
                      telInput
                      urlInput
                      rangeInput
                      hiddenInput ]
                )
        ),
        PreventInitialCall = true
    )

[<EntryPoint>]
let main args =
    DashApp.initDefault()
    |> DashApp.withLayout layout
    |> DashApp.addCallback callback
    |> DashApp.run args
