---
url: /layout
name: Part 1. Layout
description:
    "The Dash `layout` describes what your app will look like and is composed
    of a set of declarative Dash components."
icon: layout.svg
languages:
  - python
  - julia
  - r
  - fsharp
  - matlab
---

# ![](/assets/images/language_icons/f-sharp_50px.svg) Dash Layout

<blockquote>
This is the 1st chapter of the <dccLink children="Dash Fundamentals" href="/"/>.
The <dccLink href="/basic-callbacks" children="next chapter"/> covers Dash callbacks.
</blockquote>

This tutorial will walk you through a fundamental aspect of Dash apps, the
app `layout`, through self-contained apps.

For production Dash apps, we recommend styling the app `layout` with
{{de Dash Enterprise <dccLink href="/dash-design-kit" children="Design Kit"/>.||oss Dash Enterprise [Design Kit](https://plotly.com/dash/design-kit/).}}

***

Dash apps are composed of two parts. The first part is the "`layout`", which describes what the app looks like.
The second part describes the interactivity of the app and will be
covered in the <dccLink href="/basic-callbacks" children="next chapter"/>.

Note: Throughout this documentation,
F#
code examples are meant to be saved as files and executed
using `dotnet fsi app.fsx`.
You can also use Jupyter with the [JupyterDash](https://github.com/plotly/jupyter-dash) library.

{{oss
> If you're using Dash Enterprise's [Data Science Workspaces](https://plotly.com/dash/workspaces/),
> copy & paste the below code into your Workspace ([see video](https://plotly.com/dash/workspaces/#screencast)).

> _[Find out if your company is using Dash Enterprise](https://plotly.com/company-lookup/)_
}}

To get started, create a file named
`app.fsx`
, copy the code below into it, and then run it
 with `dotnet fsi app.fsx`.

{{example getting_started_layout_1}}

```bash
c:\dash_net_app>dotnet fsi app.fsx
[20:42:13 INF] Smooth! Sauve listener started in 26.671ms with binding 127.0.0.1:8080
```

Visit [http://127.0.0.1:8050/](http://127.0.0.1:8050/)
 in your web browser. You should see an app that looks like the one above.

Note:

1. The `layout` is composed of a tree of "components" such as
   `Html.div`
    and `Graph`.
2. The `Dash.NET.Html`
   module
    has a component for every HTML tag.
   The `Html.h1 [ Attr.value "Hello Dash" ]`
    component generates a `<h1>Hello Dash</h1>` HTML element in your app.
3. Not all components are pure HTML.
   `Dash.NET.DCC`
   describe higher-level components that are interactive and are generated with
    JavaScript, HTML, and CSS through the React.js library.
    `Dash.NET.DCC` also has the `AutoOpen` attribute and do not require `open Dash.NET.DCC`.
4. Each component is described entirely through keyword attributes.
    Dash is _declarative_: you will primarily describe your app
    through these attributes.
5. The `children` property is special. By convention, it's always the first attribute.
   It  can contain a string, a number, a single component, or a list of components.
6. The fonts in your app will look a little bit different than what is displayed here.
   This app is using a custom CSS stylesheet and {{de Dash Enterprise <dccLink href="/dash-design-kit" children="Design Kit"/>||oss Dash Enterprise [Design Kit](https://plotly.com/dash/design-kit/)}}
    to modify the default styles of the elements. You can learn more about custom CSS in the
    <dccLink href="/external-resources" children="CSS tutorial"/>.
7. `Dash.NET.Html` does not have to be opened using `open Dash.NET.Html` for you to access their components. It is always available.

### Making Your First Change

You can change the title "Hello Dash" in your app or change the
`x` or `y` data. Save the file and restart the app to see your changes.

> You can learn about tools to make debugging and developing Dash apps more productive and pleasant in [Dash Dev Tools documentation](/devtools)

{{oss {{dash-club}} }}
### More about HTML Components

`Dash.NET.Html`
contains a component class for every HTML tag as well as keyword arguments for all of the HTML arguments.

Let's customize the text in our app by modifying the inline styles of the components.
 Create a file named `app.fsx` with the following code:

{{example getting_started_layout_2}}

In this example, we modified the inline styles of the
`Html.div`
and `Html.h1` components with the `Attr. style` property.

```fsharp
Html.h1 [
    Attr.children "Hello Dash"
    Attr.style [
        StyleProperty ("textAlign", "center")
        StyleProperty ("color", "#7FDBFF")
    ]
]
```

The above code is rendered in the Dash app as
`<h1 style="text-align: center; color: #7FDBFF">Hello Dash</h1>`.

There are a few important differences between the `Dash.NET.Html`
and the HTML attributes:

1. The `style` property in HTML is a semicolon-separated string. In Dash,
   you can just supply a list.
2. The  keys in the `style` list are [camelCased](https://en.wikipedia.org/wiki/Camel_case).
   So, instead of `text-align`, it's `textAlign`.
3. The HTML `class` attribute is `className` in Dash.
4. The children of the HTML tag is specified through the `children` keyword
   argument. By convention, this is always the _first_ argument.

Besides that, all of the available HTML attributes and tags are available
to you within your F# context.


***

### Reusable Components

By writing our markup in F#, we can create complex reusable components like tables without switching contexts or languages.

Here's a quick example that generates a `Table` from a
FSharp.Data CSV. Create a file named `app.fsx` with the following code:

{{example getting_started_table}}

### More about Visualization

The `Dash.NET.DCC`
module includes a component called
`Graph`.

`Graph Graph`
 renders interactive data visualizations using the open source
[plotly.js](https://github.com/plotly/plotly.js) JavaScript graphing
library. Plotly.js supports over 35 chart types and renders charts in
both vector-quality SVG and high-performance WebGL.

 component is the same `figure` argument that is used by `plotly.py`, Plotly's
open source graphing library.
Check out the [plotly.py documentation and gallery](https://plotly.com/python)
to learn more.

Here's an example that creates a scatter plot from a
 FSharp.Data CSV. Create a file named `app.fsx` with the following code:

{{example getting_started_viz}}

*These graphs are interactive and responsive.
 **Hover** over points to see their values,
 **click** on legend items to toggle traces,
 **click and drag** to zoom,
 **hold down shift, and click and drag** to pan.*


### Markdown

While Dash exposes HTML through `Dash.NET.Html`, it can be tedious to write your copy in HTML.  For writing blocks of text, you can use the
`Markdown` component in
`Dash.NET.DCC`. Create a file named `app.fsx` with the following code:

{{example getting_started_markdown}}

### Core Components

`Dash.NET.DCC`
 includes a set of higher-level components like dropdowns, graphs, markdown blocks, and more.

Like all Dash components, they are described entirely declaratively.
Every option that is configurable is available as a keyword argument
of the component.

We'll see many of these components throughout the tutorial.
You can view all of the available components in the
<dccLink href="/dash-core-components" children="Dash Core Components overview"/>.

Here are a few of the available components.
Create a file named `app.fsx` with the following code:

{{example getting_started_core_components}}

### Help

Dash components are declarative: every configurable aspect of these
components is set during instantiation as a keyword argument.

On any component you can hover over the function in your IDE to
learn more about a component and its available arguments.

E.g. hovering over `dropdown` function in `Dropdown.dropdown`:
![dropdown](/assets/images/layout/vs_hover_help.png)

### Summary

The `layout` of a Dash app describes what the app looks like.
The `layout` is a hierarchical tree of components, or a list of components (in Dash 2.17 and later).

The `Dash.NET.Html`
 module
 provides classes for all of the HTML
tags and the keyword arguments describe the HTML attributes like `style`, `class`, and `id`.
The  `Dash.NET.DCC` module
 generates higher-level components like controls and graphs.

For reference, see:

* <dccLink href="/dash-core-components" children="Dash Core Components overview"/>
* <dccLink href="/dash-html-components" children="Dash HTML Components overview"/>

The next part of the Dash Fundamentals covers how to make these apps interactive.
<dccLink href="/basic-callbacks" children="Dash Fundamentals Part 2: Basic Callbacks"/>
