HTML Renderer [![Build status](https://ci.appveyor.com/api/projects/status/cm8xpf8ebt3hyi3e)](https://ci.appveyor.com/project/ArthurHub/html-renderer)
=============

#### Documentation, Discussion and Issue tracking is on [CodePlex](https://htmlrenderer.codeplex.com/).

The rich formatting power of *HTML* in your *.NET applications* using simple controls or static rendering code.
The library is *100% managed C# code* without any external dependencies (no WebBrowser control, ActiveX / COM or MSHTML dll), the only requirement is *.NET 2.0 or higher*.

[Download](https://htmlrenderer.codeplex.com/releases/) the [Demo application](https://htmlrenderer.codeplex.com/wikipage?title=Demo%20application&referringTitle=Home) to explore HTML Renderer capabilities.

![Renderer1.png](http://download-codeplex.sec.s-msft.com/Download?ProjectName=HtmlRenderer&DownloadId=731219)

### Features and Benefits
* Extensive HTML 4.01 and CSS level 2 specifications support.
* Support separating CSS from HTML by loading stylesheet code separately.
* Support text selection, copy-paste and context menu.
* WinForms controls: HtmlPanel, HtmlLabel and HtmlToolTip.
* Create images from HTML snippets.
* Handles "real world" malformed HTML, it doesn't have to be XHTML.
* 100% managed code and no external dependencies.
* Supports .NET 2.0 or higher including Client Profile.
* Lightweight single dll (~250K).
* High performance and low memory footprint.
* Extendable and configurable.
* Powerful [Demo application] to explore and learn the library.

### WinForms controls
* *HtmlPanel* - The full power of HTML control build to replace WinForms WebBrowser control, accepts HTML, text selection, scrollbars, link click intercept, image load intercept and much more.
* *HtmlLabel* - As WinForms label but accepts HTML, text selection, auto-size capabilities, transparent background and more.
* *HtmlToolTip* - As WinForms ToolTip control but accepts HTML and ability to handle links.

### Sample application
* Render HTML content generated by rich web editors like forums, blogs, etc.
* Render Office documents converted to HTML.
* Create complex WinForms UI with HTML instead of numerous WinForms controls with complex layout logic.
* Create WinForms UI that requires text selection with clipboard support.
* Create images from HTML code snippets.

### NuGet package install
[![NuGet package](http://download-codeplex.sec.s-msft.com/Download?ProjectName=HtmlRenderer&DownloadId=731229)](https://www.nuget.org/packages/HtmlRenderer.WinForms)

#### HTML Renderer on my blog
[TheArtOfDev / HTML Renderer](http://theartofdev.com/html-renderer/)
