#####################################################################
# This files has been automatically generated from:
#   ../async/test_embedding_async.py
#
# DO NOT EDIT THIS FILE! Edit the async test case listed above,
# and regenerate the synchronous test cases with async2sync.py
#####################################################################
"""Test embedding strings with the API."""

import logging
from contextlib import nullcontext

import pytest
from pytest import LogCaptureFixture as LogCap

from lmstudio import Client, LMStudioModelNotFoundError

from ..support import (
    EXPECTED_EMBEDDING,
    EXPECTED_EMBEDDING_CONTEXT_LENGTH,
    EXPECTED_EMBEDDING_ID,
    EXPECTED_EMBEDDING_LENGTH,
    check_sdk_error,
)


@pytest.mark.lmstudio
@pytest.mark.parametrize("model_id", (EXPECTED_EMBEDDING, EXPECTED_EMBEDDING_ID))
def test_embedding_sync(model_id: str, caplog: LogCap) -> None:
    text = "Hello, world!"

    caplog.set_level(logging.DEBUG)
    with Client() as client:
        session = client.embedding
        response = session._embed(model_id, input=text)
    logging.info(f"Embedding response: {response}")
    assert response
    assert isinstance(response, list)
    assert len(response) == EXPECTED_EMBEDDING_LENGTH
    # the response should be deterministic if we set constant seed
    # so we can also check the value if desired


@pytest.mark.lmstudio
@pytest.mark.parametrize("model_id", (EXPECTED_EMBEDDING, EXPECTED_EMBEDDING_ID))
def test_embedding_list_sync(model_id: str, caplog: LogCap) -> None:
    text = ["Hello, world!", "Goodbye, world!"]

    caplog.set_level(logging.DEBUG)
    with Client() as client:
        session = client.embedding
        response = session._embed(model_id, input=text)
    logging.info(f"Embedding response: {response}")
    assert response
    assert isinstance(response, list)
    assert len(response) == len(text)
    assert all(isinstance(embed, list) for embed in response)
    assert all(len(embed) == EXPECTED_EMBEDDING_LENGTH for embed in response)
    # the response should be deterministic if we set constant seed
    # so we can also check the value if desired


@pytest.mark.lmstudio
@pytest.mark.parametrize("model_id", (EXPECTED_EMBEDDING, EXPECTED_EMBEDDING_ID))
def test_tokenize_sync(model_id: str, caplog: LogCap) -> None:
    text = "Hello, world!"

    caplog.set_level(logging.DEBUG)
    with Client() as client:
        session = client.embedding
        response = session._tokenize(model_id, input=text)
    logging.info(f"Tokenization response: {response}")
    assert response
    assert isinstance(response, list)
    # the response should be deterministic if we set constant seed
    # so we can also check the value if desired


@pytest.mark.lmstudio
@pytest.mark.parametrize("model_id", (EXPECTED_EMBEDDING, EXPECTED_EMBEDDING_ID))
def test_tokenize_list_sync(model_id: str, caplog: LogCap) -> None:
    text = ["Hello, world!", "Goodbye, world!"]

    caplog.set_level(logging.DEBUG)
    with Client() as client:
        session = client.embedding
        response = session._tokenize(model_id, input=text)
    logging.info(f"Tokenization response: {response}")
    assert response
    assert isinstance(response, list)
    assert len(response) == len(text)
    assert all(isinstance(tokens, list) for tokens in response)
    # the response should be deterministic if we set constant seed
    # so we can also check the value if desired


@pytest.mark.lmstudio
@pytest.mark.parametrize("model_id", (EXPECTED_EMBEDDING, EXPECTED_EMBEDDING_ID))
def test_context_length_sync(model_id: str, caplog: LogCap) -> None:
    caplog.set_level(logging.DEBUG)
    with Client() as client:
        session = client.embedding
        response = session._get_context_length(model_id)
    logging.info(f"Context length response: {response}")
    assert response
    assert isinstance(response, int)
    assert response == EXPECTED_EMBEDDING_CONTEXT_LENGTH


@pytest.mark.lmstudio
@pytest.mark.parametrize("model_id", (EXPECTED_EMBEDDING, EXPECTED_EMBEDDING_ID))
def test_get_load_config_sync(model_id: str, caplog: LogCap) -> None:
    caplog.set_level(logging.DEBUG)
    with Client() as client:
        response = client.embedding._get_load_config(model_id)
    logging.info(f"Load config response: {response}")
    assert response
    assert isinstance(response, dict)


@pytest.mark.lmstudio
@pytest.mark.parametrize("model_id", (EXPECTED_EMBEDDING, EXPECTED_EMBEDDING_ID))
def test_get_model_info_sync(model_id: str, caplog: LogCap) -> None:
    caplog.set_level(logging.DEBUG)
    with Client() as client:
        response = client.embedding.get_model_info(model_id)
    logging.info(f"Model config response: {response}")
    assert response


@pytest.mark.lmstudio
def test_invalid_model_request_sync(caplog: LogCap) -> None:
    caplog.set_level(logging.DEBUG)
    with Client() as client:
        # Deliberately create an invalid model handle
        model = client.embedding._create_handle("No such model")
        # This should error rather than timing out,
        # but avoid any risk of the client hanging...
        with nullcontext():
            with pytest.raises(LMStudioModelNotFoundError) as exc_info:
                model.embed("Some text")
            check_sdk_error(exc_info, __file__)
        with nullcontext():
            with pytest.raises(LMStudioModelNotFoundError) as exc_info:
                model.tokenize("Some text")
            check_sdk_error(exc_info, __file__)
        with nullcontext():
            with pytest.raises(LMStudioModelNotFoundError) as exc_info:
                model.get_context_length()
            check_sdk_error(exc_info, __file__)
