# Copyright 2015 Google Inc. All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import unittest


class Test_topic_name_from_path(unittest.TestCase):

    def _callFUT(self, path, project):
        from google.cloud.pubsub._helpers import topic_name_from_path
        return topic_name_from_path(path, project)

    def test_w_simple_name(self):
        TOPIC_NAME = 'TOPIC_NAME'
        PROJECT = 'my-project-1234'
        PATH = 'projects/%s/topics/%s' % (PROJECT, TOPIC_NAME)
        topic_name = self._callFUT(PATH, PROJECT)
        self.assertEqual(topic_name, TOPIC_NAME)

    def test_w_name_w_all_extras(self):
        TOPIC_NAME = 'TOPIC_NAME-part.one~part.two%part-three'
        PROJECT = 'my-project-1234'
        PATH = 'projects/%s/topics/%s' % (PROJECT, TOPIC_NAME)
        topic_name = self._callFUT(PATH, PROJECT)
        self.assertEqual(topic_name, TOPIC_NAME)


class Test_subscription_name_from_path(unittest.TestCase):

    def _callFUT(self, path, project):
        from google.cloud.pubsub._helpers import subscription_name_from_path
        return subscription_name_from_path(path, project)

    def test_w_simple_name(self):
        SUBSCRIPTION_NAME = 'SUBSCRIPTION_NAME'
        PROJECT = 'my-project-1234'
        PATH = 'projects/%s/subscriptions/%s' % (PROJECT, SUBSCRIPTION_NAME)
        subscription_name = self._callFUT(PATH, PROJECT)
        self.assertEqual(subscription_name, SUBSCRIPTION_NAME)

    def test_w_name_w_all_extras(self):
        SUBSCRIPTION_NAME = 'SUBSCRIPTION_NAME-part.one~part.two%part-three'
        PROJECT = 'my-project-1234'
        PATH = 'projects/%s/subscriptions/%s' % (PROJECT, SUBSCRIPTION_NAME)
        topic_name = self._callFUT(PATH, PROJECT)
        self.assertEqual(topic_name, SUBSCRIPTION_NAME)
