import wfdb
import numpy

class test_processing():

    def test_1(self):
        sig, fields = wfdb.srdsamp('sampledata/100')
        ann = wfdb.rdann('sampledata/100', 'atr')

        fs = fields['fs']
        fs_target = 50

        new_sig, new_ann = wfdb.processing.resample_singlechan(sig[:, 0], ann, fs, fs_target)

        expected_length = int(sig.shape[0]*fs_target/fs)

        assert new_sig.shape[0] == expected_length

    def test_2(self):
        sig, fields = wfdb.srdsamp('sampledata/100')
        ann = wfdb.rdann('sampledata/100', 'atr')

        fs = fields['fs']
        fs_target = 50

        new_sig, new_ann = wfdb.processing.resample_multichan(sig, ann, fs, fs_target)

        expected_length = int(sig.shape[0]*fs_target/fs)

        assert new_sig.shape[0] == expected_length
        assert new_sig.shape[1] == sig.shape[1]

    def test_3(self):
        sig, _ = wfdb.srdsamp('sampledata/100')
        lb = -5
        ub = 15

        x = wfdb.processing.normalize(sig[:, 0], lb, ub)
        assert x.shape[0] == sig.shape[0]
        assert numpy.min(x) >= lb
        assert numpy.max(x) <= ub

    def test_4(self):
        x = []
        hp, sp = wfdb.processing.find_peaks(x)
        assert hp.shape == (0,)
        assert sp.shape == (0,)

    def test_5(self):
        x = [0, 2, 1, 0, -10, -15, -15, -15, 9, 8, 0, 0, 1, 2, 10]
        hp, sp = wfdb.processing.find_peaks(x)
        assert numpy.array_equal(hp, [1, 8])
        assert numpy.array_equal(sp, [6, 10])

    def test_6(self):
        x = [1183,1168,1111,1037,974,935,917,914,922,928,934,934,935,936,933,934,934,936,936,935,934,933,935,937,938,936,933,935,935,936,937,932,932,933,931,934,935,930,927,931,932,932,934,934,930,932,933,936,937,935,934,937,936,935,935,934,934,936,937,936,935,933,929,932,934,937,936,935,933,934,937,937,934,934,932,933,936,938,939,937,932,931,935,936,936,930,928,926,928,929,927,926,925,926,926,926,925,925,922,925,925,929,929,931,929,931,938,942,943,945,943,945,950,953,951,950,950,948,950,953,952,950,950,953,956,959,959,956,955,952,955,955,953,953,951,950,951,950,950,949,949,951,952,953,953,953,949,948,947,951,951,949,948,947,947,950,948,944,942,944,947,949,948,946,942,944,945,946,946,946,944,944,946,947,946,945,945,944,944,947,946,944,944,946,948,950,950,948,943,946,946,948,948,948,946,948,948,949,948,946,942,943,945,945,947,943,943,947,950,957,959,959,955,957,959,960,960,962,962,964,966,968,967,965,963,965,966,967,966,964,961,962,962,966,969,968,964,960,956,956,950,945,940,941,939,941,942,940,939,939,938,941,942,939,936,935,937,940,942,940,937,939,939,941,940,938,937,934,930,926,920,917,913,906,901,900,913,935,959,989,1029,1077,1132,1171,1194,1195,1160,1089,1007,946,920,913,918,926,933,933,931,931,934,936,934,935,931,936,934,937,936,934,932,930,933,933,932,929,927,929,931,933,932,932,932,932,931,934,933,932,928,930,932,931,933,932,930,933,934,933,933,933,930,928,930,933,932,930,928,930,931,933,932,932,931,930,933,935,935,934,933,934,936,939,937,936,934,933,933,934,935,932,932,930,931,932,932,929,926,928,928,929,927,926,924,926,927,926,926,928,924,924,922,928,926,926,927,929,931,935,937,939,939,940,946,948,949,950,950,950,954,957,954,954,953,957,960,960,961,959,957,958,960,960,962,958,954,955,958,958,956,956,953,953,955,957,955,954,952,954,952,954,954,954,951,950,955,958,955,954,953,953,953,956,957,951,947,947,951,951,951,951,947,945,947,949,951,948,946,949,948,951,950,950,948,948,953,951,951,950,948,949,951,951,950,950,946,947,951,952,951,949,947,946,948,950,949,946,947,947,949,950,949,947,943,947,950,950,952,949,950,949,953,956,955,956,955,959,962,963,963,964,963,964,967,971,971,970,968,969,969,971,971,969,965,966,966,970,969,967,964,965,970,976,975,972,965,962,961,959,954,951,947,948,946,950,950,949,948,946,947,946,948,946,944,943,946,947,947,945,941,943,944,947,944,944,940,940,937,934,925,920,914,913,911,908,899,892,902,923,945,976,1007,1047,1101,1156,1197,1215,1206,1156,1078,996,939,920,921,926,931,935,938,937,937,934,933,934,934,936,935,933,932,932,934,934,935,934,931,933,936,937,937,936,932,933,937,936,933,934,932,932,934,935,936,933,931,933,935,936,937,935,933,936,939,938,938,935,934,938,937,939,938,937,934,934,934,937,934,936,933,935,936,937,934,933,933,936,936,940,940,938,935,935,939,939,940,940,936,937,938,939,937,935,932,933,935,937,937,934,933,933,935,937,934,933,935,933,936,938,941,939,938,942,945,948,951,951,950,950,954,956,957,955,953,955,956,958,956,957,953,956,957,960,959,957,953,958,959,959,959,959,954,957,959,960,959,957,957,956,959,959,958,957,955,953,956,955,956,953,952,951,952,953,953,951,950,951,951,953,953,952,950,950,950,952,951,951,947,947,947,949,948,946,944,944,947,947,947,946,944,943,946,948,948,946,943,945,946,947,948,948,946,949,951,951,949,949,947,947,947,951,949,948,946,947,949,952,950,948,946,946,949,951,949,952,950,953,960,962,964,964,962,962,967,970,973,969,969,970,969,970,968,965,962,963,965,967,967,965,961,961,962,964,966,965,967,971,971,966,963,959,953,951,949,948,947,947,943,944,947,947,945,944,940,942,943,944,943,942,939,940,940,944,943,941,938,938,937,933,925,916,912,906,898,898,911,935,959,986,1024,1073,1128,1168,1191,1195,1172,1122,1049,986,939,917,907,907,914,923,928,932,934,936,936,937,934,934,934,935,937,934,933,932,931,937,935,934,934,932,933,935,935,931,930,934,933,939,938,938,933,936,937,939,937,937,935,934,936,936,937,936,936,935,939,940,941,939,935,934,937,939,938,934,934,936,934,939,937,935,934,935,936,939,938,934,934,935,938,938,937,937,935,935,938,939,938,935,937,938,938,939,940,939,936,936,937,937,937,936,933,933,937,939,938,938,936,938,938,940,940,938,939,941,947,949,951,951,950,953,951,954,956,955,955,954,953,955,957,957,955,955,956,958,957,953,952,952,953,955,956,955,954,953,956,956,956,954,949,952,953,956,955,952,947,949,951,952,951,947,945,945,948,948,949,948,944,945,949,949,947,945,944,942,946,947,948,946,941,942,944,945,947,944,940,939,941,942,942,938,938,938,940,940,941,940,940,941,941,944,946,944,942,941,943,944,944,942,940,940,942,944,941,940,938,939,942,945,948,949,950,953,955,957,957,957,957,962,964,963,965,966,964,964,965,965,963,961,958,959,959,960,961,958,953,955,960,965,963,959,949,948,947,945,943,940,937,938,940,943,944,941,937,936,934,938,936,935,934,933,934,937,936,934,932,935,936,937,938,937,932,926,922,919,914,905,895,895,913,937,963,997,1045,1104,1155,1183,1182,1144,1070,995,944,920,912,914,923,931,932,933,933,934,931,932,931,930,930,930,926,927,930,931,932,931,930,928,929,931,933,929,928,932,934,936,935,935,932,933,933,931,933,928,931,931,933,933,932,929,928,930,931,933,931,934,933,934,937,938,936,935,933,933,934,936,937,933,931,933,936,936,936,936,932,933,934,938,937,933,929,929,930,932,930,931,927,926,931,932,932,929,926,924,925,927,930,927,924,924,926,929,929,931,928,933,935,939,942,943,940,940,944,949,952,952,949,952,955,959,959,956,955,952,953,953,953,951,952,953,958,957,954,955,952,953,950,956,957,957,955,954,954,956,955,952,951,952,954,954,954,951,948,949,950,950,951,951,949,948,949,950,949,946,942,944,946,951,950,949,946,947,949,951,949,945,943,943,945,946,944,944,944,943,943,946,946,945,944,942,944,947,949,945,945,945,947,948,947,948,948,948,950,948,950,948,947,944,949,951,955,953,954,954,958,961,962,963,961,961,964,969,968,967,966,967,970,970,969,969,967,966,965,967,967,967,964,964,965,966,970,970,967,964,961,960,958,952,946,945,941,945,944,945,943,941,944,943,944,943,943,942,943,944,942,940,938,939,940,943,940,941,937,935,930,924,920,915,905,899,906,926,956,985,1021,1073,1128,1173,1201,1200,1160,1089,1008,953,924,914,917,927,933,936,935,936,935,936,938,939,941,937,934,935,938,939,938,936,932,933,932,933,936,934,933,932,934,937,938,936,932,932,934,936,937,937,936,936,939,939,938,937,935,935,936,937,933,936,933,935,934,936,936,935,934,935,937,938,939,938,936,937,939,938,941,937,934,936,938,939,940,937,935,936,937,938,936,933,932,930,933,933,931,930,927,927,929,929,929,930,928,929,929,932,931,930,931,931,934,935,938,937,937,939,944,948,951,951,946,951,951,956,955,958,954,957,960,959,960,961,957,958,960,961,962,961,959,958,961,960,960,960,957,955,958,958,959,957,955,957,959,959,957,957,955,955,955,958,959,956,957,957,959,961,961,957,956,956,958,956,959,957,953,954,956,957,956,956,952,951,953,954,955,955,953,949,955,956,953,954,951,954,953,956,954,954,954,953,958,957,957,956,952,954,956,957,955,955,952,952,953,955,954,949,947,952,953,956,955,954,951,952,955,956,956,956,955,957,959,966,968,967,965,966,969,969,972,974,972,975,978,978,976,976,974,971,974,975,977,974,968,970,976,980,982,977,967,966,961,962,962,956,952,955,955,956,951,953,948,951,953,952,953,952,949,948,950,951,952,952,949,949,949,953,951,951,946,941,938,930,924,919,908,904,912,935,963,992,1023,1070,1131,1183,1221,1234,1219,1167,1078,995,942,920,924,937,946,946,944,942,940,941,943,942,941,940,937,937,939,940,939,938,937,938,939,942,941,940,938,937,938,939,938,936,936,936,938,940,939,939,937,938,937,938,939,938,937,939,940,940,940,940,936,937,938,939,937,936,935,937,937,939,939,937,935,937,935,940,939,938,936,937,940,940,940,941,938,938,938,941,939,937,934,935,936,937,936,937,935,936,936,939,939,939,938,937,942,945,945,946,947,946,948,953,956,954,955,956,960,962,964,963,958,959,960,960,963,959,959,961,960,961,961,960,958,959,960,961,962,961,958,960,958,960,960,956,954,955,957,957,956,957,955,952,955,957,955,953,950,952,953,955,953,953,951,953,953,954,953,952,948,950,951,952,951,948,948,947,950,951,952,951,949,949,950,952,953,951,950,950,952,953,954,953,949,953,953,956,956,953,951,951,954,954,954,953,951,950,954,955,955,954,952,954,959,960,965,965,962,967,968,971,974,972,971,973,976,979,978,975,971,971,971,970,973,972,969,967,969,972,979,978,974,967,964,967,964,959,955,955,957,959,960,958,954,953,952,953,952,951,949,948,949,950,950,950,945,945,947,946,946,948,946,948,947,950,948,944,939,932,924,923,916,905,901,917,946,979,1019,1071,1126,1173,1194,1176,1114,1028,954,918,919,932,941,945,941,941,942,946,947,944,939,939,941,941,943,939,939,940,940,940,942,940,939,939,942,944,945,944,942,941,943,945,947,943,942,944,943,946,946,946,944,943,945,944,944,944,940,941,944,945,944,942,942,944,944,947,945,943,941,942,943,947,946,945,943,946,947,946,945,942,941,940,943,945,944,941,938,938,940,942,940,937,939,938,939,941,941,939,939,940,943,945,944,943,939,942,945,946,947,948,949,950,953,954,955,954,952,954,958,958,961,956,953,955,958,959,959,959,955,956,959,959,959,956,951,954,954,953,951,948,948,949,952,954,953,949,948,951,949,952,951,950,950,949,951,952,952,949,950,948,948,948,949,943,944,945,947,950,948,947,943,943,945,944,943,942,943,943,944,946,947,945,942,941,944,944,946,945,941,944,944,944,944,944,940,942,941,943,947,946,945,946,949,949,948,946,945,948,948,955,957,955,957,955,959,960,960,957,955,958,962,962,964,962,961,964,966,966,963,963,962,961,963,964,960,960,961,964,967,965,958,955,948,945,944,945,940,937,935,935,936,938,939,937,935,937,939,941,939,936,935,934,937,938,939,939,935,934,935,936,930,923,915,910,905,895,890,896,910,930,950,966,986,1010,1041,1084,1127,1164,1188,1192,1162,1091,1016,957,920,906,908,918,926,929,930,927,926,928,929,930,929,928,924,923,923,927,929,927,924,924,927,930,927,925,925,925,928,928,932,932,930,929,928,929,926,926,923,924,927,928,927,928,924,925,928,929,929,930,926,929,928,930,927,928,926,927,926,926,925,924,921,921,925,927,931,929,926,925,924,925,924,922,923,922,924,923,922,919,915,916,918,918,917,914,912,915,916,917,918,916,915,914,918,919,921,924,922,926,931,933,936,936,934,939,942,944,943,942,943,944,947,947,948,946,943,944,947,948,948,948,944,945,948,951,952,947,944,944,945,948,947,946,945,945,946,948,947,945,943,944,943,945,943,943,940,942,943,944,943,940,937,939,939,942,940,939,938,938,939,944,941,939,938,937,940,941,940,939,938,937,939,939,938,937,935,935,937,939,939,936,935,936,938,939,941,937,936,937,939,940,941,937,938,937,940,941,939,939,938,937,940,940,941,940,937,938,941,946,948,947,947,949,948,954,957,957,958,957,960,963,966,964,959,959,959,960,957,958,955,955,956,955,957,959,959,960,956,955,952,948,942,940,941,942,941,938,937,937,937,937,938,937,934,932,934,937,936,935,933,933,934,934,935,935,930,931,933,935,934,935,932,930,926,920,916,911,902,896,896,911,935,961,992,1036,1092,1144,1181,1194,1172,1115,1040,972,927,910,908,913,923,925,929,927,927,926,927,930,929,926,925,924,923,926,925,924,925,925,925,929,929,926,925,926,928,928,928,926,924,924,928,929,927,928,923,927,928,931,928,926,925,926,927,927,929,926,925,924,926,928,927,925,924,927,927,929,928,927,925,924,926,927,927,925,924,925,927,929,930,927,926,928,924,927,929,926,923,925,924,925,924,920,918,919,921,923,921,921,918,919,922,923,923,923,918,920,921,926,926,925,923,926,932,935,938,938,938,943,942,946,944,945,944,946,947,949,949,948,949,949,951,951,951,951,946,949,950,951,951,950,946,948,951,951,950,946,946,946,948,950,948,947,944,945,946,947,946,945,943,942,945,946,944,943,945,943,946,948,948,947,945,945,945,945,946,944,943,944,944,945,945,944,940,943,941,946,943,943,941,941,943,945,945,943,940,942,944,947,947,945,941,942,944,947,946,946,942,942,945,943,945,942,941,942,943,944,945,944,941,942,945,946,945,947,948,951,955,960,961,961,956,956,961,962,962,960,961,961,965,966,966,967,963,963,964,964,962,959,957,959,960,962,961,961,962,968,970,967,961,956,951,951,949,947,946,939,937,939,941,942,943,941,938,938,940,941,942,941,936,938,941,942,940,939,937,938,937,939,936,931,921,914,913,910,903,896,894,905,930,959,988,1023,1070,1127,1175,1201,1210,1191,1137,1056,984,941,917,912,912,920,927,935,937,936,935,933,933,934,933,930,927,927,928,929,928,928,926,926,926,928,930,928,925,926,928,932,932,933,928,928,932,933,933,932,926,929,929,931,934,931,929,930,931,933,934,933,930,929,933,935,935,934,930,931,933,934,935,932,929,929,931,934,934,929,930,930,930,932,934,930,930,929,931,934,935,931,930,930,933,931,934,932,931,929,932,933,932,930,928,928,929,931,931,929,929,927,930,933,932,931,930,929,934,936,938,938,937,940,945,947,949,950,950,951,953,956,954,952,949,952,954,955,955,952,951,951,953,953,953,952,949,951,951,953,954,952,952,953,953,957,955,954,950,950,950,952,951,948,947,947,951,951,952,951,948,948,950,953,953,951,950,949,951,954,953,948,947,948,951,950,948,949,944,946,946,949,949,946,944,943,945,945,945,944,944,943,946,949,949,946,945,947,947,947,948,948,944,946,946,949,948,946,944,946,946,947,947,946,945,946,946,949,948,949,947,947,948,949,950,948,949,948,951,955,956,954,955,959,961,961,963,961,961,963,966,968,970,970,967,968,968,969,969,966,964,966,967,969,969,966,967,971,974,972,966,961,956,950,949,950,950,946,944,944,946,947,946,943,941,943,943,944,947,945,941,942,944,945,943,940,940,939,941,942,941,936,927,920,916,914,908,898,888,885,890,895,905,919,931,946,958,979,1014,1061,1112,1158,1186,1189,1156,1095,1017,954,924,918,923,930,933,934,934,937,938,936,934,933,933,936,937,936,934,934,936,939,939,939,933,933,938,939,936,936,934,935,937,939,940,938,937,938,937,938,938,935,934,934,937,938,939,939,937,937,941,940,938,937,935,935,936,936,936,936,936,934,937,938,939,940,936,935,940,940,940,939,937,939,942,942,940,938,936,937,935,941,938,940,937,937,938,939,939,938,935,936,936,939,936,935,932,932,935,935,937,935,933,932,937,938,937,936,935,936,941,942,946,945,945,945,948,952,951,949,946,947,953,955,955,956,952,952,952,957,956,955,952,952,953,954,954,951,950,948,949,953,952,951,950,951,953,955,954,953,949,948,951,954,953,951,949,950,951,950,950,949,947,946,948,948,949,948,946,945,946,948,949,947,943,946,945,949,946,946,942,943,944,947,946,943,943,944,945,948,948,947,946,946,947,948,945,944,943,941,945,946,946,949,946,946,948,948,947,946,942,944,946,948,947,946,948,952,954,959,958,958,958,955,962,965,967,968,968,969,971,969,970,969,964,965,967,965,964,959,959,963,967,967,962,956,950,948,946,948,948,947,942,943,945,946,946,942,938,941,940,943,943,943,943,942,943,942,941,939,939,941,941,943,943,942,939,937,935,927,920,915,908,901,903,919,948,978,1014,1065,1124,1170,1191,1175,1120,1039,969,930,915,915,923,930,933,936,936,935,935,934,935,934,936,934,932,931,935,935,934,933,931,930,932,934,933,933,931,932,936,937,936,934,933,934,935,935,935,933,933,935,936,936,933,929,931,931,933,936,936,935,935,936,936,937,936,933,931,930,929,934,935,936,934,932,934,937,937,933,932,931,932,934,933,933,931,933,933,935,931,930,928,927,926,927,928,925,921,921,923,927,928,925,923,925,925,929,932,931,931,935,938,942,941,942,942,943,948,951,951,950,950,952,953,955,955,958,955,955,957,956,957,958,955,956,957,960,958,957,954,955,958,960,958,956,955,954,957,959,956,955,952,950,956,958,956,956,953,954,952,956,957,954,952,950,952,953,954,951,949,952,950,952,952,950,948,948,950,954,954,953,952,954,954,956,955,953,951,951,952,954,952,951,949,948,949,952,953,950,948,951,954,953,953,953,950,952,954,957,955,954,953,955,959,962,962,963,963,963,967,969,971,971,972,975,976,979,976,977,975,972,976,978,975,973,974,973,972,972,976,976,975,974,970,967,963,958,955,955,953,953,952,951,951,950,954,954,953,951,949,949,952,953,953,952,948,947,949,950,947,942,935,926,923,919,908,905,915,942,972,1007,1048,1102,1151,1193,1210,1196,1139,1056,981,933,918,916,917,914,917,922,932,942,942,939,938,938,939,942,942,939,938,939,940,943,942,942,942,940,943,945,945,942,941,940,942,944,942,940,940,939,941,941,943,941,940,938,939,943,942,942,940,941,944,947,945,945,943,943,944,946,945,943,940,940,943,946,944,942,940,939,942,944,945,943,942,940,944,943,943,942,939,941,941,944,943,941,938,940,942,940,939,940,936,938,937,938,938,937,936,938,940,942,942,945,947,948,952,956,958,957,957,958,960,960,960,960,962,961,964,965,965,963,963,963,965,967,964,965,965,964,966,968,965,963,962,960,964,964,962,963,960,959,959,961,963,961,960,958,959,963,959,960,959,957,961,960,960,958,956,955,955,959,959,955,954,954,955,959,958,956,956,957,957,960,959,960,956,957,958,956,957,956,955,953,956,958,956,956,955,954,957,955,957,956,957,955,958,960,959,960,957,954,956,959,960,957,955,958,958,963,963,967,967,969,968,971,972,973,974,975,979,982,986,980,980,978,978,980,977,975,972,974,976,978,978,975,970,967,973,978,981,982,979,972,967,968,963,961,957,955,957,957,956,956,953,953,953,955,951,947,948,947,949,951,950,949,948,948,949,950,949,946,939,933,927,927,920,913,907,918,947,977,1005,1047,1097,1151,1192,1209,1196,1143,1063,980,935,923,928,937,941,943,946,946,945,944,942,941,944,945,943,943,943,943,945,948,946,943,943,942,943,945,945,943,942,943,943,946,944,943,940,939,943,944,945,945,944,944,944,947,946,945,945,944,947,947,945,945,944,944,945,946,945,944,942,942,943,946,947,945,943,942,944,948,947,946,945,945,947,947,946,944,945,944,946,947,945,943,943,940,942,945,943,942,939,940,939,944,943,943,945,943,945,947,945,944,945,945,948,951,949,950,950,949,953,958,957,955,954,957,960,963,962,961,960,960,962,963,962,965,963,964,966,967,966,965,964,963,962,962,963,964,961,958,960,963,962,960,961,956,960,961,959,958,958,957,961,961,962,960,960,960,958,960,960,958,956,958,957,957,958,956,955,954,955,958,957,955,954,954,954,957,956,956,952,953,952,955,956,954,953,954,955,957,958,955,954,953,954,957,957,957,955,953,953,954,957,956,954,952,955,959,957,955,954,956,959,963,966,971,973,969,972,974,971,971,973,974,974,979,979,976,974,974,974,975,975,974,975,973,974,975,971,971,969,969,975,982,983,977,969,964,966,964,958,955,954,951,953,956,954,952,949,950,950,952,951,949,948,947,952,952,952,952,948,946,945,949,943,934,926,920,915,910,904,911,928,957,990,1032,1087,1138,1170,1178,1155,1100,1024,962,927,920,929,940,942,939,939,938,938,942,940,936,937,935,936,939,941,939,936,933,934,938,939,938,935,936,938,941,941,938,936,935,937,941,940,936,937,935,939,940,938,938,936,937,937,939,938,936,936,935,936,939,938,938,937,937,937,938,937,937,938,939,940,943,940,938,937,935,939,942,940,937,936,935,937,938,938,936,932,929,934,936,936,936,929,932,934,936,936,934,932,930,931,934,934,931,933,932,934,937,937,938,937,938,943,943,947,947,947,946,948,950,949,950,952,951,952,955,952,954,954,953,954,954,956,953,949,948,951,954,952,950,950,948,947,950,949,946,944,945,947,952,951,949,949,947,948,947,947,946,945,944,946,948,949,947,945,941,943,946,946,943,942,941,943,944,942,946,944,943,945,945,944,943,942,942,945,945,945,944,941,941,943,946,946,944,945,943,945,945,944,941,940,938,940,941,942,942,941,943,946,949,947,946,946,946,947,948,951,950,950,950,955,957,956,956,956,957,960,963,963,964,962,959,961,962,960,959,961,960,959,960,959,958,960,963,963,960,952,945,946,941,942,943,940,937,935,933,937,939,940,937,938,933,935,938,938,937,933,934,936,938,941,935,931,934,935,934,925,917,913,909,903,896,898,909,932,959,994,1041,1094,1141,1171,1178,1150,1092,1015,952,920,910,913,922,925,926,924,926,929,928,930,928,927,928,927,930,929,930,928,927,932,933,930,930,929,927,931,933,934,932,932,931,930,932,930,927,923,924,927,928,927,928,928,927,929,931,931,930,930,929,930,930,929,929,926,928,927,929,929,926,925,925,927,928,930,926,926,926,927,930,929,927,927,924,928,929,929,928,924,923,925,927,926,920,919,918,919,921,920,916,917,916,917,919,918,918,920,922,924,929,928,929,929,931,934,936,938,940,940,939,944,947,947,947,946,949,949,950,952,950,949,950,953,955,954,954,951,951,952,953,952,950,949,949,949,952,950,948,944,944,946,948,948,949,947,947,949,951,952,950,946,947,948,949,950,946,944,943,945,948,947,946,945,943,946,946,943,944,944,943,944,945,945,943,941,942,942,944,944,944,941,942,944,947,945,944,941,943,944,947,947,946,945,944,946,947,947,945,944,944,945,944,944,942,943,943,946,946,947,947,944,948,948,955,956,958,959,960,961,962,962,962,961,963,969,968,969,970,967,965,965,967,966,962,960,962,964,967,964,961,962,966,969,972,968,960,958,954,954,953,949,947,944,938,941,945,947,943,941,942,942,944,944,942,943,941,944,945,944,943,942,943,945,945,944,943,942,940,940,941,928,920,916,915,914,905,901,906,926,955,986,1026,1074,1127,1169,1194,1199,1162,1088,1002,943,918,921,933,938,940,940,936,938,938,939,938,935,934,936,940,939,937,938,935,938,941,939,940,936,935,938,940,940,939,938,935,940,943,940,938,936,935,938,941,938,936,936,936,938,938,940,938,936,934,936,940,939,940,938,936,939,940,944,942,940,938,940,943,942,938,936,937,940,941,938,938,937,937,937,939,937,937,936,936,937,939,939,935,936,933,935,936,936,934,937,935,937,938,938,938,936,936,938,940,941,941,942,943,947,950,951,951,951,954,955,959,959,959,956,957,961,964,964,961,964,963,963,965,962,962,961,959,961,964,962,963,960,960,962,962,962,962,960,959,960,964,966,962,960,959,964,964,964,963,959,957,959,962,959,958,958,956,958,961,960,958,956,956,957,959,960,957,957,956,956,959,957,956,954,952,953,957,957,953,953,952,954,954,955,954,952,954,956,957,956,956,955,954,955,959,959,961,956,956,959,958,958,957,957,955,956,958,958,955,954,956,961,963,967,967,968,967,970,975,973,968,967,966,970,973,975,976,972,974,977,978,979,975,975,973,974,973,976,974,973,969,973,976,979,980,978,972,967,966,965,960,955,954,955,956,955,951,950,949,951,951,951,952,950,949,949,949,951,949,949,947,950,952,953,950,949,944,940,935,928,923,916,909,905,907,920,943,967,995,1034,1087,1141,1178,1194,1187,1144,1080,1004,950,925,924,933,943,946,944,942,942,946,949,947,945,941,942,944,945,947,946,943,942,946,945,946,944,939,942,945,946,944,944,943,942,945,945,946,943,944,945,945,947,946,945,943,944,947,949,947,946,943,944,946,944,943,942,944,941,943,946,947,944,942,942,946,948,950,947,945,946,949,947,946,946,945,942,945,948,944,944,944,942,942,944,942,944,941,939,941,944,943,943,941,940,943,945,946,944,941,944,946,948,949,947,948,947,951,952,955,955,955,956,958,962,962,961,959,960,963,965,965,965,964,962,965,967,967,965,962,963,963,965,966,966,963,963,965,966,963,962,960,959,960,964,961,961,959,959,960,962,961,958,956,957,959,961,960,959,958,956,959,962,961,959,958,957,955,957,957,956,955,955,955,957,957,956,953,955,954,957,958,957,956,954,957,958,957,956,955,953,955,958,957,956,954,952,953,955,956,954,955,953,955,958,959,957,957,955,958,959,959,958,958,962,966,970,971,968,964,965,970,976,977,977,977,977,978,981,980,978,978,973,975,977,976,975,970,969,970,972,975,978,979,979,984,984,978,971,965,963,962,962,960,956,955,952,953,956,956,954,952,952,951,952,949,948,947,948,949,950,949,950,949,947,951,950,947,944,936,932,929,929,920,908,903,915,935,961,988,1024,1071,1123,1163,1182,1176,1136,1073,1002,952,929,922,926,931,936,937,941,939,941,939,937,945,947,947,944,942,940,942,943,942,944,940,937,940,943,943,941,941,940,940,944,942,941,939,938,941,941,942,941,940,940,941,945,944,943,941,941,940,941,939,939,937,937,939,941,941,940,939,938,940,942,942,942,941,939,943,944,944,942,941,941,943,945,947,945,945,941,945,946,945,943,941,939,941,941,941,939,937,935,935,935,935,936,934,937,938,939,937,935,935,938,939,940,939,941,941,942,943,949,950,951,951,952,955,956,958,957,957,958,958,961,961,961,961,959,960,960,964,960,958,957,960,963,961,959,957,956,956,960,957,957,955,954,958,958,958,957,957,955,955,959,955,958,956,955,956,954,956,956,954,950,953,956,955,954,951,950,950,953,952,953,952,949,950,953,955,953,951,952,952,952,951,949,948,950,952,956,958,956,956,951,953,954,952,950,949,950,951,952,953,952,953,950,953,956,955,953,952,951,953,958,958,960,963,964,969,970,967,965,967,970,972,974,975,975,973,971,974,975,971,971,969,966,967,967,967,966,968,969,967,967,964,958,954,949,952,954,953,952,949,951,952,951,948,948,946,944,946,948,948,948,944,944,946,948,948,948,946,946,947,949,945,938,930,926,923,917,908,906,921,947,979,1012,1055,1107,1151,1179,1188,1166,1099,1022,964,932,922,925,933,939,942,938,942,945,946,944,942,939,941,942,942,941,940,939,941,942,942,942,941,938,938,939,940,939,938,937,939,939,939,937,936,937,939,940,940,941,939,938,940,941,938,940,937,937,939,939,938,938,934,936,938,943,940,937,938,937,937,940,939,937,939,940,941,942,942,938,938,936,937,939,938,933,933,930,931,931,931,930,926,927,930,931,931,931,929,929,932,931,931,929,931,929,931,934,936,937,938,941,945,946,947,951,951,952,957,959,958,955,958,959,960,962,961,960,960,957,960,961,962,960,961,960,959,960,960,959,958,957,958,963,961,958,957,956,954,958,959,959,954,954,955,958,960,955,956,954,956,959,958,956,954,952,953,955,954,953,952,950,952,956,955,953,953,953,954,956,955,953,953,953,951,953,953,952,949,951,953,954,954,953,951,950,952,953,953,953,952,952,952,957,957,953,952,951,955,957,955,952,952,952,955,963,965,967,967,967,969,971,972,976,975,973,978,978,975,973,972,973,972,973,973,971,970,968,967,969,975,977,977,970,966,966,962,958,954,953,953,953,952,950,947,947,950,950,950,949,947,945,950,952,951,950,949,949,950,951,950,943,933,924,922,920,910,905,913,935,969,1003,1044,1096,1150,1190,1221,1228,1205,1155,1098,1045,1008,980,956,937,922,910,908,920,932,941,941,939,941,943,941,940,937,937,938,940,939,939,937,937,941,943,942,941,942,942,941,944,943,940,938,937,940,943,939,938,938,939,941,942,943,940,939,938,941,943,943,942,940,939,942,944,941,944,942,942,944,946,946,943,942,939,941,943,944,942,939,940,941,943,942,944,940,941,939,943,940,939,938,936,941,940,939,940,936,939,939,939,939,938,937,935,939,941,941,941,942,944,945,950,952,952,955,955,955,958,961,959,958,957,960,963,963,962,959,958,961,960,962,960,961,959,960,962,962,961,961,959,962,963,962,960,959,959,960,961,959,959,956,956,957,957,958,956,954,955,956,957,958,957,955,955,955,957,956,955,953,954,954,956,955,952,951,950,953,953,952,951,950,949,953,954,952,951,951,951,954,955,954,955,951,952,952,953,951,952,952,951,951,954,955,953,953,952,954,957,956,957,957,957,962,966,970,968,965,965,967,970,972,973,973,972,974,973,975,976,974,972,972,973,972,971,970,969,971,972,974,976,978,971,967,965,957,958,954,950,952,953,952,951,949,948,952,952,951,951,949,948,950,948,949,949,946,947,949,948,947,941,930,923,920,917,909,905,918,941,974,1011,1057,1112,1158,1192,1211,1222,1206,1162,1100,1024,963,929,921,923,930,935,941,941,940,940,939,937,941,942,942,941,941,940,942,942,944,942,939,937,940,941,943,942,938,939,939,944,941,942,941,939,941,943,943,942,942,942,942,946,947,946,943,942,945,946,945,943,944,943,942,945,946,945,944,943,944,946,946,943,943,941,944,946,945,944,941,942,946,947,944,944,940,943,944,944,945,944,940,937,941,945,944,940,939,940,941,944,943,941,940,940,943,943,945,945,945,945,947,949,950,953,950,952,955,957,960,957,957,956,959,960,961,959,957,957,961,959,960,958,958,957,958,960,958,960,959,959,958,960,960,959,957,956,958,960,958,953,952,952,953,954,953,954,951,952,950,953,951,951,951,947,949,950,952,951,949,946,947,948,949,947,945,946,945,949,946,947,944,946,948,951,951,949,949,947,947,951,951,949,944,946,948,950,949,947,945,946,946,947,946,947,947,946,946,951,953,951,950,949,949,951,950,953,955,958,960,964,964,960,959,962,963,966,969,969,966,967,969,968,967,964,964,965,969,969,966,964,965,966,971,968,962,957,953,948,945,948,944,942,941,941,943,947,944,943,939,942,945,949,947,945,944,944,946,946,946,944,942,942,942,939,939,940,936,935,933,928,923,918,911,900,898,907,926,950,974,1008,1060,1115,1154,1177,1171,1132,1063,997,947,919,911,918,926,931,933,932,930,931,932,935,937,936,936,934,933,935,933,932,933,932,935,937,936,934,933,934,932,935,934,934,933,930,932,933,935,932,933,933,933,932,931,931,929,931,934,935,935,933,932,933,933,936,936,934,933,932,935,937,935,933,931,927,929,933,935,935,934,933,934,937,935,934,934,932,934,936,935,932,929,929,931,932,930,928,924,924,927,927,927,926,925,923,926,924,923,923,922,921,923,924,925,923,924,924,928,933,939,939,941,943,945,948,947,948,947,945,947,950,953,953,950,950,953,955,956,955,956,955,956,957,954,954,954,953,956,957,955,957,957,957,959,961,960,956,954,954,954,957,954,951,951,950,950,953,953,952,950,950,950,953,953,953,948,950,951,954,954,951,952,949,951,952,952,948,946,947,948,949,949,947,945,943,947,951,948,947,949,949,950,952,952,950,948,948,950,953,951,950,948,948,949,951,950,947,944,946,947,951,951,947,948,947,947,951,952,953,954,954,960,962,964,963,963,963,966,969,967,969,970,970,971,973,971,967,967,964,965,968,969,966,963,962,968,975,974,969,964,959,957,955,952,952,950,947,946,947,947,947,946,944,943,945,947,945,944,942,942,946,945,945,944,944,946,950,950,948,948,945,947,948,944,939,932,925,921,920,912,905,911,931,962,991,1030,1083,1134,1175,1196,1187,1139,1065,988,936,919,920,929,936,938,936,938,941,943,940,939,937,939,941,941,940,940,939,941,944,942,944,940,941,941,944,942,942,939,937,940,942,943,940,937,939,941,940,941,942,938,938,940,943,944,942,941,941,943,944,944,942,943,941,944,944,941,940,943,940,941,942,942,940,939,941,941,942,943,942,938,939,942,943,943,942,940,939,939,941,939,938,937,935,936,934,934,932,931,931,932,933,933,934,932,932,935,938,938,935,937,939,944,947,949,949,948,950,954,958,959,959,960,961,961,965,964,965,962,964,966,968,967,967,966,964,967,968,967,968,965,963,966,969,966,965,964,961,963,966,964,963,962,962,962,964,965,963,960,961,962,964,966,964,960,960,964,965,965,962,960,961,963,962,960,959,962,959,962,962,962,959,958,958,960,964,962,964,961,959,962,965,964,962,960,958,961,964,962,959,958,956,959,960,960,958,957,958,957,961,961,960,960,958,959,959,959,960,957,958,962,965,965,962,962,962,966,967,970,972,974,972,971,974,975,974,975,975,979,985,984,983,980,979,980,981,977,980,978,977,978,978,979,980,985,988,987,982,976,973,971,967,964,964,964,961,957,956,956,961,959,958,956,954,958,960,957,958,956,955,957,956,958,956,954,954,953,954,953,945,938,929,927,925,914,910,915,936,964,997,1032,1081,1137,1185,1213,1214,1172,1092,1009,950,928,931,943,950,951,948,949,952,953,950,949,949,951,952,952,949,946,946,947,949,948,950,947,948,948,950,950,947,945,944,947,951,949,947,947,946,947,949,948,948,946,947,948,949,946,946,948,948,951,954,951,951,951,949,951,950,949,949,948,947,948,951,952,952,950,949,951,953,953,951,951,951,950,953,951,952,951,950,952,955,956,952,951,949,951,952,951,950,946,946,947,951,951,950,948,948,949,952,953,953,950,949,953,957,958,960,959,960,963,965,966,966,964,965,968,969,970,971,969,968,970,972,970,971,968,966,968,971,971,971,970,967,971,973,973,970,970,968,971,972,971,969,967,966,968,968,967,966,965,964,965,967,967,965,964,963,963,964,966,966,961,962,966,968,968,966,963,965,965,966,963,963,960,962,961,964,962,962,959,960,960,963,961,962,959,957,963,962,964,962,962,962,962,965,967,965,963,962,962,964,967,965,963,963,964,965,965,963,962,960,961,964,965,964,965,964,968,972,974,976,975,976,978,980,982,985,983,985,987,988,989,987,983,981,983,983,984,983,979,978,979,985,990,989,981,975,974,976,972,968,963,961,961,962,963,962,960,957,960,963,962,962,958,956,958,962,959,957,956,955,957,959,959,956,956,955,951,947,940,935,930,922,917,925,945,969,994,1030,1080,1132,1174,1202,1218,1228,1223,1198,1157,1101,1042,988,950,931,929,933,936,945,950,952,954,953,953,952,953,953,954,954,951,951,952,953,953,950,949,948,950,950,952,951,947,946,951,952,952,953,951,949,951,952,952,952,950,950,952,954,953,952,951,948,952,954,952,954,948,947,950,953,953,953,949,950,955,955,954,953,951,953,956,958,956,953,951,952,957,956,954,951,950,950,950,951,952,953,949,948,950,952,951,948,947,947,946,948,947,946,943,945,948,952,954,952,952,952,956,959,960,962,960,957,961,963,961,963,961,962,968,966,967,965,964,967,967,966,966,965,964,961,964,966,968,965,963,964,964,966,964,962,961,960,962,960,961,959,958,957,958,959,962,960,958,956,955,957,958,957,955,957,958,959,959,957,957,957,956,958,957,955,954,952,953,955,957,956,953,953,955,957,956,954,953,953,953,955,955,954,953,953,955,954,957,957,953,953,954,954,956,953,949,951,953,955,952,954,953,955,957,961,965,965,963,963,966,968,971,971,971,971,976,978,977,974,974,973,973,972,971,970,970,971,972,969,970,972,974,972,969,966,965,960,956,950,952,950,947,946,944,947,947,948,950,948,947,948,949,949,948,945,944,945,948,950,950,949,945,944,947,947,947,944,938,935,931,929,922,909,903,911,934,963,996,1036,1084,1134,1172,1186,1167,1108,1031,964,931,920,926,934,939,935,937,937,936,938,939,938,942,941,941,940,935,933,937,939,940,938,937,937,937,939,938,938,935,934,935,938,937,938,937,938,939,940,941,941,936,935,937,939,938,936,931,932,934,935,934,933,935,934,936,938,941,939,939,935,938,938,935,935,933,935,934,936,937,936,934,932,934,936,936,934,933,930,930,929,927,929,929,927,928,929,927,926,923,922,921,923,928,925,927,927,932,936,937,940,941,940,944,948,952,952,950,950,953,956,958,959,957,954,955,957,957,957,953,954,954,956,957,956,954,953,955,958,957,956,954,954,955,956,954,953,952,949,950,952,953,950,950,948,948,951,949,948,946,946,946,950,950,949,945,948,949,953,952,950,948,947,948,949,948,948,945,946,947,949,948,948,947,945,946,945,950,948,949,948,950,952,949,947,947,946,946,949,949,949,947,945,944,948,949,949,946,947,951,957,957,961,959,960,963,963,965,966,966,966,967,969,967,965,961,963,964,967,967,966,963,962,963,963,968,967,966,961,957,955,955,949,949,948,947,946,947,946,946,944,940,943,943,943,941,940,940,940,944,941,940,939,941,943,943,942,939,934,928,922,919,914,902,895,898,911,927,945,962,978,1005,1038,1084,1133,1169,1187,1186,1150,1078,996,943,921,917,927,937,938,938,937,940,939,941,940,936,935,938,937,939,938,936,935,938,938,936,936,935,933,937,937,939,939,937,934,938,940,940,939,935,936,937,939,938,937,937,938,942,940,941,940,936,938,940,940,941,938,936,937,939,939,939,942,939,938,939,943,941,941,940,938,940,940,939,938,937,935,935,936,936,934,932,931,933,934,935,931,931,930,928,932,934,932,930,929,933,936,935,937,934,935,943,945,947,948,949,949,952,955,956,959,958,958,959,962,962,963,960,960,961,964,962,960,958,958,960,960,961,960,959,958,958,959,959,958,954,956,957,957,958,958,957,955,957,960,960,957,957,953,956,957,955,954,952,952,951,953,956,953,949,951,951,953,952,954,952,949,951,952,951,952,951,953,953,955,956,954,952,951,953,955,951,952,950,951,949,952,950,951,949,948,950,951,951,952,950,950,950,950,952,952,950,951,954,955,956,957,956,961,964,967,967,966,964,964,967,969,972,972,971,970,971,973,972,971,968,965,969,968,970,966,967,969,974,979,973,967,963,960,956,956,951,949,944,944,946,946,948,947,945,944,943,945,946,947,943,942,944,944,945,945,943,944,945,946,943,940,937,933,927,924,923,920,917,913,907,908,918,941,967,1000,1040,1088,1139,1175,1185,1168,1118,1048,982,939,927,929,937,942,943,937,939,938,940,941,939,937,935,935,935,936,939,938,936,937,937,936,936,936,934,932,936,939,939,939,938,936,937,939,940,936,937,936,935,937,937,936,934,933,936,937,938,937,937,936,936,936,935,937,937,935,936,938,939,938,936,935,937,938,940,938,937,933,936,936,936,936,935,935,937,937,939,939,936,936,934,937,936,933,933,931,934,934,935,933,933,933,933,937,937,937,938,939,942,947,949,948,948,948,953,953,953,953,951,956,958,958,957,954,955,956,956,958,958,957,955,954,955,956,956,957,953,953,955,956,954,953,953,953,952,953,952,951,950,949,951,951,951,950,947,946,946,950,950,949,947,945,945,951,950,946,946,945,947,946,946,948,946,943,946,945,944,944,941,942,943,946,947,945,942,943,948,949,947,949,948,947,950,950,950,950,948,948,947,949,948,948,947,946,951,951,953,949,952,953,957,961,963,964,962,961,966,970,970,970,966,967,969,971,970,967,964,962,965,967,967,965,962,961,967,972,971,964,955,954,954,955,950,945,946,944,946,945,944,944,941,938,939,943,940,938,939,940,942,943,944,943,939,939,941,941,940,938,929,923,917,917,907,896,894,907,928,946,956,971,989,1016,1054,1099,1136,1165,1178,1169,1122,1052,978,928,911,916,928,934,936,934,934,934,935,938,938,934,932,931,932,933,934,934,933,932,934,935,934,933,931,930,933,935,933,933,933,933,937,937,939,935,936,934,934,933,934,933,931,932,932,935,935,932,930,931,933,937,936,934,933,931,931,931,934,935,935,935,935,938,938,937,932,934,936,939,936,933,932,929,930,933,933,930,927,927,930,930,930,928,926,926,929,932,931,929,927,927,929,928,930,929,928,928,935,936,941,941,942,942,946,948,948,947,946,948,951,952,953,951,951,951,954,954,955,953,949,947,949,953,953,954,953,950,953,953,953,949,948,948,950,952,952,950,945,945,948,951,953,949,948,949,950,950,950,945,943,943,945,944,944,942,943,942,942,944,944,942,940,941,942,945,946,945,943,943,946,946,945,943,943,941,941,940,943,943,943,938,942,942,943,942,940,940,941,944,943,943,940,943,941,944,946,945,945,945,946,948,951,955,954,955,957,956,956,955,955,957,961,966,969,969,967,964,965,964,962,963,963,962,962,960,965,965,965,962,958,957,956,951,949,944,943,944,941,941,939,939,938,943,944,944,940,939,938,941,941,938,937,938,939,940,939,939,938,939,939,939,938,935,929,919,916,917,910,903,900,913,940,967,998,1043,1095,1144,1179,1190,1161,1096,1018,955,925,917,918,926,929,928,931,930,931,933,931,928,928,934,933,932,930,929,932,934,935,931,930,931,935,935,935,934,933,931,934,934,935,933,931,931,931,935,935,934,931,930,931,933,933,932,933,932,932,935,935,935,934,932,936,937,938,936,934,934,936,937,938,936,933,932,937,936,937,936,935,933,932,936,935,933,932,932,934,933,934,932,931,929,931,930,931,929,924,921,925,926,925,923,923,922,925,926,927,927,925,926,928,932,934,934,935,937,940,941,944,944,946,948,950,952,955,954,955,955,956,959,960,957,958,958,959,962,963,962,958,960,961,963,961,962,957,957,959,959,959,957,953,955,959,959,958,958,956,954,958,959,957,957,958,955,956,958,959,956,956,955,958,960,958,960,958,957,953,957,957,956,954,953,954,955,957,954,954,953,952,954,956,953,951,950,952,956,957,955,955,953,954,957,957,958,956,956,958,960,959,957,954,955,955,956,954,957,956,953,956,958,958,955,955,955,958,963,965,967,969,970,971,975,975,974,972,972,973,977,978,977,978,978,979,981,981,977,974,973,973,977,976,976,973,971,976,983,988,982,976,971,969,967,964,959,956,956,954,956,955,955,954,954,956,958,958,958,955,954,957,957,961,957,956,955,956,958,959,956,957,955,956,958,957,953,947,939,932,931,926,919,910,910,927,948,979,1011,1046,1096,1152,1192,1216,1218,1182,1112,1029,967,939,932,937,945,951,953,950,950,950,949,948,949,951,949,946,947,948,948,952,950,948,946,950,952,952,949,947,946,947,949,951,948,946,948,949,951,951,949,948,947,950,951,953,952,949,946,949,952,953,949,948,950,952,952,952,951,949,950,951,952,951,951,949,950,949,951,951,951,950,946,949,951,950,950,949,950,951,951,952,952,948,949,953,954,954,951,949,949,950,951,950,947,946,944,946,948,949,948,948,946,949,952,951,950,954,953,957,960,962,961,963,964,966,967,971,971,967,970,973,976,978,975,975,973,975,978,976,975,976,972,976,976,975,974,975,973,975,975,977,974,973,971,973,975,975,974,972,972,974,974,975,970,971,969,969,971,970,968,969,968,967,971,970,969,967,967,969,969,970,969,966,965,968,970,969,967,964,963,966,966,966,965,966,963,963,966,966,964,960,963,965,968,967,964,966,966,965,968,970,969,966,964,966,968,969,967,964,964,966,967,969,967,966,965,968,968,970,970,974,975,979,981,983,983,981,982,985,988,989,988,987,986,988,991,992,988,988,984,985,987,986,986,987,984,985,985,982,984,986,988,993,988,982,977,975,973,972,970,970,966,963,962,964,969,966,966,965,964,961,963,964,962,964,962,964,963,966,964,963,961,964,963,959,952,941,934,933,926,918,923,938,963,988,1012,1040,1081,1121,1162,1197,1215,1223,1200,1141,1051,982,944,939,943,952,957,957,956,957,956,954,953,954,954,954,953,950,950,953,954,953,956,954,951,953,955,955,955,954,954,956,958,959,958,955,954,957,959,958,959,956,956,957,958,958,958,955,956,957,955,957,957,954,955,957,957,957,956,955,955,955,957,956,957,953,953,955,957,957,956,954,954,955,958,957,954,954,952,954,958,956,956,955,954,957,955,957,955,953,953,957,956,956,953,952,952,954,956,958,956,956,957,963,964,965,964,966,966,970,973,971,971,972,973,975,976,976,974,974,974,977,977,978,974,974,974,975,978,977,975,973,973,974,975,975,974,973,972,972,974,974,974,971,970,969,971,972,972,970,968,970,972,973,970,970,968,970,971,970,972,969,969,971,970,970,970,969,969,970,972,970,968,967,966,966,967,970,967,963,963,966,966,968,967,967,966,965,969,969,967,966,966,968,971,972,970,970,968,970,971,971,970,967,968,969,970,969,971,969,969,970,972,971,971,972,973,975,981,984,982,980,982,985,989,989,992,989,991,992,993,993,990,987,986,989,990,990,989,985,983,987,993,997,992,985,980,981,981,975,970,966,962,965,967,967,967,965,963,965,965,965,964,963,963,965,966,965,964,961,960,962,963,964,964,963,961,957,950,943,938,933,922,917,921,936,960,983,1014,1065,1122,1167,1190,1187,1148,1078,1004,953,933,933,944]
        expecting = [271, 580, 884, 1181, 1469, 1770, 2055, 2339, 2634, 2939, 3255, 3551, 3831, 4120, 4412, 4700, 5000, 5299, 5596, 5889, 6172, 6454, 6744, 7047, 7347, 7646, 7936, 8216, 8503, 8785, 9070, 9377, 9682]
        frequency = 360.0
        adcgain = 200.0
        adczero = 1024
        peaks = wfdb.processing.gqrs_detect(x, frequency, adcgain, adczero, threshold=1.0)
        print(peaks)
        print(expecting)
        assert numpy.array_equal(peaks, expecting)

    def test_7(self):
        sig, fields = wfdb.srdsamp('sampledata/100', channels = [0, 1])
        ann = wfdb.rdann('sampledata/100', 'atr')
        fs = fields['fs']
        min_bpm = 10
        max_bpm = 350
        min_gap = fs*60/min_bpm
        max_gap = fs*60/max_bpm

        y_idxs = wfdb.processing.correct_peaks(sig[:,0], ann.sample, min_gap, max_gap, smooth_window=150)

        yz = numpy.zeros(sig.shape[0])
        yz[y_idxs] = 1
        yz = numpy.where(yz[:10000]==1)[0]

        assert numpy.array_equal(yz, [77, 370, 663, 947, 1231, 1515, 1809, 2045, 2403, 2706, 2998, 3283, 3560, 3863, 4171, 4466, 4765, 5061, 5347, 5634, 5919, 6215, 6527, 6824, 7106, 7393, 7670, 7953, 8246, 8539, 8837, 9142, 9432, 9710, 9998])
