---
permalink: docs/
---

# Documentation

### Getting Started

* [Getting Setup](./getting-setup.md)
* [Terminology](./terminology.md)
* [Debugging the debugger](./debugging-the-debugger.md)

### Development

* [Local Development](./local-development.md)
* [Debugging](./debugging.md)
* [DBG helper](./dbg.md)
* [Lerna](./lerna.md)
* [Flow types](./flow.md)
* [Issues](./issues.md)
* [Pull requests](./pull-requests.md)
* [Maintainer information](./maintainer.md)
* [Frequently Asked Questions & Issues](./most-common-issues.md)
* [Fix Performance bugs](./performance.md)
* [Bundling and Releasing](./bundling.md)

### Testing

* [Mochitests](./mochitests.md)

### Architecture

* [React / Redux Architecture overview](./debugger-html-react-redux-overview.md)
* [Debugger Server Architecture](./client.md)
* [Debugger Client](../src/client/README.md)

### Firefox panel

* [Debugging Firefox](./debugging-firefox.md)
* [Remotely debuggable browsers](./remotely-debuggable-browsers.md)

### Learning

* [Conference Talks](./talks.md)
* [Screencasts](./videos.md)
* [When the world stops](./updates/when-the-world-stops.md)

### Updates

* [Weekly updates](./updates/README.md)
