## January 16th

This update spans (11/23) thanksgiving to January 16th. It is a GIF overload of awesome polish.

During this time we improved the debugger speed and stability tremendously. The UI received tons of UI tweaks in almost every area: editor, search, preview. We could not have done all this without the help from lots of great folks!

[@DavideDeCenzo], [@Fischer-L], [@zaggy], [@khal0988], [@James300], [@borian], [@GarethSharpe], [@AnshulMalik], [@jasonLaster], [@guywarburg], [@assafdd], [@cristidrg], [@codehag], [@fivepointseven], [@lukaszsobek], [@nyrosmith], [@sharathnarayanph], [@darkwing], [@Zacqary], [@yurydelendik], [@CharlesStocky], [@samuel-peers], [@arthur801031], [@juliandescottes], [@http-request], [@Securter], [@ryanjduffy], [@umohm1], [@pradeepgangwar], [@kootoopas], [@aagandhi1], [@MikeRatcliffe], [@bomsy], [@sotayamashita], [@Storm-Engineering], [@tbroadley], [@joshunger], [@wldcordeiro], [@sam-clulow], [@Vasusena], [@nchevobbe]

### UI

* [[Preview] Tooltip position][4605] [@DavideDeCenzo]
* [Fix weird position of 'X' close button][4752] [@guywarburg]
* [#4756 Remove stray line][4762] [@cristidrg]
* [Ensure no whitespace breakage in outline items][4803] [@darkwing]
* [Ensure the 'jump to' context menu label cases are consistent][4806] [@darkwing]
* [Conditional breakpoint panel responsiveness and visual fixes][4808] [@Zacqary]
* [Fixed whitespace at the bottom of center pane after searching files][4818] [@CharlesStocky]
* [Adds file, prettyPrint and blackBox icons to dropdown][4830] [@lukaszsobek]
* [Outline - Style list][4851] [@arthur801031]
* [DebugLine - Fix editor jumping when debug line is set][4874] [@jasonLaster]
* [Show source text when devtools opens][4875] [@jasonLaster]
* [Scopes - don't expand on pause][4876] [@jasonLaster]
* [Maintain [QuickOpenModal] width for all heights][4903] [@kootoopas]
* [Changed background hover][4905] [@aagandhi1]
* [Parser - detect if files use JSX][4911] [@DavideDeCenzo]
* [Do not select the frame if the frame is already selected][4921] [@bomsy]
* [Refactor common button code into CommandBarButton][4922] [@ryanjduffy]
* [Makes search modal results scroll][4926] [@lukaszsobek]
* [Fix right sidebar footer height][4931] [@pradeepgangwar]
* [fix quick open][4959] [@jasonLaster]
* [🌟 Fix highlightLine][4968] [@jasonLaster]
* [toggle-button-end is not displayed when displaying welcomebox in portrait mode][4997] [@DavideDeCenzo]
* [Quickopen '?' shows different options.][5000] [@pradeepgangwar]
* [Cleanup preview selection][5011] [@jasonLaster]
* [Fix destructuring][5020] [@jasonLaster]
* [Dropdown styling][5026] [@sam-clulow]
* [Icons are made Brighter][5038] [@aagandhi1]
* [Changed error to 'No results found'][5051] [@Vasusena]
* [Resolves styling issues][5052] [@lukaszsobek]
* [Show vertical mode on open][5055] [@jasonLaster]
* [Fix pane ordering][5058] [@jasonLaster]
* [Refresh search results on modifier change][5092] [@AnshulMalik]

| Fix tooltip position |
| -------------------- |
| ![4605-0]            |

| Fix Outline view layout |
| ----------------------- |
| ![4803-0]               |

| Make the conditional breakpoint responsive! |
| ------------------------------------------- |
| ![4808-0]                                   |

| Fixed Project Search vertical whitespace |
| ---------------------------------------- |
| ![4818-0]                                |

| Adds file, prettyPrint and blackBox icons to dropdown |
| ----------------------------------------------------- |
| ![4830-0]                                             |

| Fix Quick Open scrolling |
| ------------------------ |
| ![4926-0]                |

| Show toggle button in vertical mode |
| ----------------------------------- |
| ![4997-0]                           |

| Quickopen '?' shows different options |
| ------------------------------------- |
| ![5000-0]                             |

| Show icons in more tabs dropown |
| ------------------------------- |
| ![5026-0]                       |

| Brighten source tree icons in dark mode! |
| ---------------------------------------- |
| ![5038-0]                                |

| Show "no results found" |
| ----------------------- |
| ![5051-0]               |

| Fix file search modifier toggling and iterating |
| ----------------------------------------------- |
| ![5092-0]                                       |

### Features

* [Improved in scope inner locations for previewing][4699] [@Fischer-L]
* [Add syntax highlight for non-js languages][4704] [@zaggy]
* [Watch Expressions Shouldn't Be Allowed with Syntax Errors][4734] [@khal0988]
* [Improve isReactComponent][4737] [@James300]
* [Toggle Command Bar Buttons][4741] [@GarethSharpe]
* [Sources better display data uri][4742] [@AnshulMalik]
* [Pause - Locations should be symmetric for original and generated files (#4715)][4758] [@assafdd]
* [Enable auto prettyprint pref][4770] [@AnshulMalik]
* [Add lambda icon for function outlines][4774] [@jasonLaster]
* [Improve destructed symbol extraction][4786] [@AnshulMalik]
* [Permits backslash in expressions][4790] [@lukaszsobek]
* [Editor: close ConditionalPanel before adding breakpoint][4793] [@nyrosmith]
* [Remove breakpoint in codemirror commented line][4795] [@sharathnarayanph]
* [Set symbols for pretty-printed tabs so that functions display in the …][4805] [@darkwing]
* [Open worker in toolbox][4945] [@bomsy]
* [Tabs - Display pretty source after reload][4963] [@AnshulMalik]
* [Hide Call Stack and Scopes panes when the debuggee is active][4974] [@GarethSharpe]
* [Editor - Use hasJsx][4991] [@jasonLaster]

| Improved in scope inner locations for previewing |
| ------------------------------------------------ |
| ![4699-0]                                        |

| Add syntax highlight for non-js languages |
| ----------------------------------------- |
| ![4704-0]                                 |
| ![4704-1]                                 |

| Disable invalid watch expression |
| -------------------------------- |
| ![4734-0]                        |

| Fix data:text URIs in the source tree |
| ------------------------------------- |
| ![4742-0]                             |

| Show debug line & call stack locations in both contexts! |
| -------------------------------------------------------- |
| ![4758-0]                                                |

| Auto Pretty Print |
| ----------------- |
| ![4770-0]         |

| Add lambdas in the function outline view |
| ---------------------------------------- |
| ![4774-0]                                |
| ![4774-1]                                |

| Improve destructed symbol extraction |
| ------------------------------------ |
| ![4786-0]                            |

| Permits backslash in expressions |
| -------------------------------- |
| ![4790-0]                        |

| Display pretty source after reload |
| ---------------------------------- |
| ![4963-0]                          |

| Hide Call Stack and Scopes panes when the debuggee is active |
| ------------------------------------------------------------ |
| ![4974-0]                                                    |

### Workers!

* [Support workerChange events][5027] [@jasonLaster]
* [Fix old debugger workers pref][5036] [@jasonLaster]
* [Add the services argument][5060] [@bomsy]

| Show Workers in the right sidebar |
| --------------------------------- |
| ![5027-0]                         |

### Bugs

* [Clicking a console link should navigate to the correct line][4747] [@jasonLaster]
* [Don't parse symbols for WASM][4817] [@yurydelendik]
* [Prevent flashing preview][4820] [@jasonLaster]
* [fix selectLocation action][4845] [@codehag]
* [Loads non-loaded source before trying to prettyPrint][4858] [@lukaszsobek]
* [Address memory leak introduced by parse-script-tags][4882] [@ryanjduffy]
* [Fix #4924 - Prevent NaN result count][4925] [@darkwing]
* [Suppress interrupt resumed events][4972] [@jasonLaster]
* [Fix preview for original sources][4975] [@jasonLaster]
* [Fix clearing debug line][4988] [@jasonLaster]
* [Fixes loadSourceText async loading for wasm.][5017] [@yurydelendik]
* [fix to return null instead of undefined][5062] [@bomsy]
* [fix Unable to remove pending breakpoint that was created on a non exe…][5063] [@codehag]
* [Fix timing connect issue][5066] [@jasonLaster]
* [Support pausing immediately][5076] [@jasonLaster]
* [Fixes loading error][5090] [@yurydelendik]
* [[SourceTree] show loading sources][5094] [@jasonLaster]

### Performance

* [Throttle new sources][4749] [@jasonLaster]
* [only load sources once][4753] [@jasonLaster]
* [use newSources for sourcemapped sources][4769] [@codehag]
* [Do work in the background][4802] [@jasonLaster]
* [Call prettyprint only once][4850] [@AnshulMalik]
* [Check for larger bundle sizes][4880] [@jasonLaster]
* [Remove tojs calls for some source methods][4890] [@codehag]
* [Source queue][4948] [@codehag]
* [🌲 Fix Throttling and revert HighlightLine][4965] [@jasonLaster]
* [Speed up generated source parsing][5101] [@jasonLaster]

### Code Health

* [ Switch TextSearch from PropTypes to Flow props #4739 ][4764] [@jasonLaster]
* [Reformat some files][4771] [@jasonLaster]
* [Replaces selectSource with selectLocation][4789] [@lukaszsobek]
* [4532 - Part 3: Update mapDispatchToProps for EditorMenu.js and EmptyLines.js][4814] [@Fischer-L]
* [Extracts isMinified][4821] [@jasonLaster]
* [Add setInScopeLines][4822] [@jasonLaster]
* [Removed PropTypes for Frames/index.js][4826] [@zaggy]
* [Bug 1416928 - Test content script debugging on the new debugger UI.][4860] [@codehag]
* [Refactor updateScopeBindings][4866] [@jasonLaster]
* [Switch ProjectSearch PropTypes to Props][4892] [@umohm1]
* [Cleanup AST tests][4893] [@jasonLaster]
* [Update CallSites flag][4898] [@jasonLaster]
* [Fix name collisions: getOutOfScopeLocations][4900] [@pradeepgangwar]
* [Upgrade devtools-splitter, fuzzaldrin-plus, immutable, react-inlinesvg, react-transition-group, redux-saga][4909] [@MikeRatcliffe]
* [Upgrade svg-inline-react to v3.0.0][4912] [@MikeRatcliffe]
* [Synchronize test changes to getSplitConsole from bug 1408949][4914] [@juliandescottes]
* [Cleans up EditorMenu.js][4938] [@lukaszsobek]
* [Revert "Throttle new sources (#4749)"][4947] [@jasonLaster]
* [Revert Parse Script Tags][4952] [@jasonLaster]
* [Update wasmparser to the latest version 🚀][4961]
* [Synchronize wasmparser with m-c.][4966] [@yurydelendik]
* [Update mochii to the latest version 🚀][4967]
* [Prettify types][4973] [@jasonLaster]
* [⬆️: Upgrading Flow to 0.61][4983] [@wldcordeiro]
* [update yarn.lock file after mochii upgrade; it was missing the caret][4984] [@joshunger]
* [Update mochii to the latest version 🚀][4986]
* [Refactor pause (2/2)][4989] [@jasonLaster]
* [Refactor Pause state (1/2)][4990] [@jasonLaster]
* [Setup worker feature flag][4992] [@jasonLaster]
* [Update mochii to the latest version 🚀][4998]
* [Refactor source actions (1/x)][4999] [@jasonLaster]
* [Refactor sources (2/x)][5009] [@jasonLaster]
* [Export source utils][5012] [@jasonLaster]
* [Protect getSymbols][5013] [@jasonLaster]
* [🔨: Cleaning up some quick open code and adding tests.][5015] [@wldcordeiro]
* [🔨: Consolidate the project text search components][5016] [@wldcordeiro]
* [Use Prefs for feature flags][5039] [@jasonLaster]
* [Refactor Editor utils][5041] [@jasonLaster]
* [4597 - [Breakpoints] Extract Context menu][5049] [@Fischer-L]
* [fix logging][5067] [@jasonLaster]
* [Add babel-eslint as a dependency.][5071] [@nchevobbe]
* [Update Enzyme to 3.3.0 first with the React 15 adapter][5073] [@MikeRatcliffe]
* [Upgrade flow to 63.1][5075] [@AnshulMalik]
* [Feature flag some things off][5077] [@jasonLaster]
* [Fix codefolding][5088] [@jasonLaster]
* [Update mock-require to the latest version 🚀][5093]
* [Make loading source maps safer][5095] [@jasonLaster]
* [Refactor newSource][5099] [@jasonLaster]

### Infrastructure

...

* [bump pad][4775] [@jasonLaster]
* [Specifies the location where to run firefox setup][4801] [@lukaszsobek]
* [Release 11 22][4840] [@codehag]
* [Add license headers to all image files][4873] [@http-request]
* [Added license header to all examples in mochitest directory][4877] [@Securter]
* [add .vscode folder so we can share settings with everyone that is contributing][4987] [@joshunger]
* [Add eslint jest plugin][5010] [@jasonLaster]
* [Licenses][5032] [@jasonLaster]
* [async-await refactor][5054] [@jasonLaster]

### Frameworks

* [Display React logo only on active tab][4779] [@fivepointseven]
* [immutable variable hover][4829] [@samuel-peers]
* [Support parsing JSX][4891] [@jasonLaster]
* [[Preview] Separate out functions for react and immutable][5014] [@bomsy]
* [added angular icon in the source pane for angular projects][4738] [@borian]

| Preview Immutable objects |
| ------------------------- |
| ![5014-0]                 |

| Show Angular icon in source tree |
| -------------------------------- |
| ![4738-0]                        |

### Testing

* [Synchronize browser_dbg-chrome-debugging.js from m-c][4861] [@juliandescottes]
* [Add longer timeout for browser_dbg-iframes.js][4918] [@juliandescottes]
* [Fis CI intermittent and maxListeners][4941] [@jasonLaster]
* [Skip preview test on windows][5001] [@jasonLaster]
* [Re-enable wasm test][5018] [@jasonLaster]
* [Shared tests][5097] [@wldcordeiro]

### Docs

* [Fix some misspell][4937] [@sotayamashita]
* [Add Lukas to the Core Team][4944] [@codehag]
* [Updated Documentation][4955] [@Storm-Engineering]
* [docs: fix typos][4956] [@tbroadley]
* [Cleanup the documentation ][4978] [@bomsy]
* [Fix spelling of "new comers" to "newcomers"][4981] [@joshunger]
* [Add hyperlink to flow and clean up flow.md paths][4982] [@joshunger]
* [talos documentation][5037] [@codehag]
* [[Docs] Adds docs as possible issue title start tag][5045] [@lukaszsobek]
* [Synchronize localization note fixes from Bug 1425280][5048] [@juliandescottes]

[4605-0]: https://user-images.githubusercontent.com/18034739/32466986-3e83d45a-c349-11e7-8afa-89e34c4336e7.jpg
[4699-0]: https://user-images.githubusercontent.com/5627487/32841446-49f5e978-ca55-11e7-8653-029690e062c5.gif
[4704-0]: https://user-images.githubusercontent.com/69977/32892873-bf2fd2fe-cb2b-11e7-96e5-761d2bef139d.png
[4704-1]: https://user-images.githubusercontent.com/69977/32893035-47da8338-cb2c-11e7-9042-2848050fd55e.png
[4734-0]: https://user-images.githubusercontent.com/17691158/34181102-f4ecb322-e4de-11e7-8981-b1b131557fd8.png
[4738-0]: https://user-images.githubusercontent.com/1525694/32992085-ae98ed28-cd46-11e7-9322-6a17fd220d74.png
[4738-1]: https://user-images.githubusercontent.com/1525694/32992086-b12a40c8-cd46-11e7-82f5-9c6db84bd648.png
[4741-0]: https://user-images.githubusercontent.com/22062107/32996510-a30822d4-cd51-11e7-88c7-f82be622a251.gif
[4742-0]: https://user-images.githubusercontent.com/7821757/33005867-ed63aee2-cded-11e7-9f75-c82540286ad5.png
[4749-0]: https://user-images.githubusercontent.com/254562/33030313-012c8098-cde9-11e7-8d0b-41027a0eaa7b.png
[4749-1]: https://user-images.githubusercontent.com/254562/33030451-55745ea0-cde9-11e7-9907-1a91bcb38e55.png
[4749-2]: https://user-images.githubusercontent.com/254562/33030462-5cff6908-cde9-11e7-81b4-5a4e345cdfb6.png
[4758-0]: https://user-images.githubusercontent.com/1753718/33079702-f1801f82-cede-11e7-991c-547eb04ecdca.gif
[4762-0]: https://user-images.githubusercontent.com/13036803/33093741-c2bb3eea-cef5-11e7-8fb7-0af2f6bdbc19.png
[4770-0]: https://user-images.githubusercontent.com/7821757/33130719-439dfc04-cfba-11e7-90e5-7f6121972a7a.gif
[4774-0]: https://user-images.githubusercontent.com/254562/33157155-f267e4e4-cfcd-11e7-815a-6aaaa9793235.png
[4774-1]: https://user-images.githubusercontent.com/254562/33157156-f278978a-cfcd-11e7-8d1a-9b09606fc5d9.png
[4774-2]: https://user-images.githubusercontent.com/254562/33157162-017b743c-cfce-11e7-9d6e-e9da13c5f1db.png
[4774-3]: https://user-images.githubusercontent.com/254562/33157159-f5ecdbb0-cfcd-11e7-99cb-67bc4a768fbe.png
[4786-0]: https://user-images.githubusercontent.com/7821757/33213659-74fbc976-d14e-11e7-9dfc-325481973c32.gif
[4790-0]: https://user-images.githubusercontent.com/23530054/33229641-b60e31b8-d1d2-11e7-9a94-5f17fc408046.png
[4803-0]: https://user-images.githubusercontent.com/46655/33280435-a9175340-d367-11e7-91c4-8bb27a223727.png
[4808-0]: https://user-images.githubusercontent.com/1445834/33291844-d474db50-d38c-11e7-8cfe-e6d3676c1e47.gif
[4808-1]: https://user-images.githubusercontent.com/1445834/33383800-d9258c0e-d4e9-11e7-9cef-3e266ac2450c.gif
[4808-2]: https://user-images.githubusercontent.com/1445834/33383806-dcfd2a94-d4e9-11e7-96ed-24633243ebdf.gif
[4808-3]: https://user-images.githubusercontent.com/1445834/33383943-4d12a214-d4ea-11e7-8ea1-78e01e4fe5ee.gif
[4818-0]: https://user-images.githubusercontent.com/24966772/33341714-6e1326e6-d445-11e7-96c4-003d314bf7e2.png
[4818-1]: https://user-images.githubusercontent.com/24966772/33341718-70252664-d445-11e7-80de-6da7b5234991.png
[4818-2]: https://user-images.githubusercontent.com/24966772/33342287-398e26a8-d447-11e7-87d1-b6d84767bf49.png
[4818-3]: https://user-images.githubusercontent.com/24966772/33342288-3b37667c-d447-11e7-8b58-6e14a1a0e862.png
[4826-0]: https://user-images.githubusercontent.com/69977/33373710-3c5a7d58-d557-11e7-8e8f-d7fb50939dd3.png
[4829-0]: https://user-images.githubusercontent.com/16711897/33380134-a8a7943c-d4df-11e7-8d44-8b3dc87c9c78.png
[4829-1]: https://user-images.githubusercontent.com/16711897/33380140-aee42694-d4df-11e7-9d3e-d429dc5439af.png
[4829-2]: https://user-images.githubusercontent.com/16711897/33380143-b12c5570-d4df-11e7-8f6c-a16880c4d73f.png
[4830-0]: https://user-images.githubusercontent.com/23530054/33395873-26301930-d547-11e7-9fb4-b60019a9cc6e.gif
[4858-0]: https://user-images.githubusercontent.com/23530054/33592123-96048476-d989-11e7-880e-88fc3c943808.gif
[4898-0]: https://user-images.githubusercontent.com/254562/33797313-c1579878-dcd3-11e7-9c55-dd32303936ca.png
[4898-1]: https://user-images.githubusercontent.com/254562/33797314-c161d3e2-dcd3-11e7-9d39-9b943282a346.png
[4898-2]: https://user-images.githubusercontent.com/254562/33797387-d0082e2c-dcd4-11e7-9fc3-087e5bd0c706.png
[4898-3]: https://user-images.githubusercontent.com/254562/33797395-f240096a-dcd4-11e7-8924-31bf4f856b45.png
[4898-4]: https://user-images.githubusercontent.com/254562/33797396-f24a8868-dcd4-11e7-84a0-3213b7e5351e.png
[4922-0]: https://user-images.githubusercontent.com/788456/34009434-cd067106-e0bd-11e7-8c17-0bb4cd144392.png
[4926-0]: https://user-images.githubusercontent.com/23530054/34036497-b1777f20-e185-11e7-9953-b46f5dfcddd0.gif
[4931-0]: https://user-images.githubusercontent.com/21259802/34069517-2779dd8c-e279-11e7-9745-d6cc42455ae5.png
[4963-0]: https://user-images.githubusercontent.com/7821757/34258735-54824214-e685-11e7-98ce-51c223dbe9e5.gif
[4974-0]: https://user-images.githubusercontent.com/22062107/34057511-3eaf1f64-e1a5-11e7-824b-7058aee9b6ec.gif
[4997-0]: https://user-images.githubusercontent.com/18034739/34437988-747fc4f0-eca3-11e7-943b-4510061adc3a.png
[4997-1]: https://user-images.githubusercontent.com/18034739/34437993-782720bc-eca3-11e7-8846-2bb3f13b62b4.png
[5000-0]: https://user-images.githubusercontent.com/21259802/34451868-626c3008-ed59-11e7-8251-a73d7115190a.gif
[5014-0]: https://user-images.githubusercontent.com/792924/34506225-ca77d3ac-f022-11e7-857c-99ec473d6d56.png
[5026-0]: https://user-images.githubusercontent.com/20771538/34583873-b6181138-f199-11e7-9373-4e7712a18a40.png
[5026-1]: https://user-images.githubusercontent.com/23530054/34588030-2d84a9b4-f1ab-11e7-8021-373f0d0ad38c.gif
[5027-0]: https://user-images.githubusercontent.com/254562/34584850-5772caf2-f16b-11e7-8099-119201862803.png
[5038-0]: https://user-images.githubusercontent.com/28971657/34630361-c3fd0268-f239-11e7-8921-84d9cb560853.jpg
[5038-1]: https://user-images.githubusercontent.com/28971657/34630372-d2c9220e-f239-11e7-88a5-b17af1ca39ac.jpg
[5038-2]: https://user-images.githubusercontent.com/28971657/34630375-d84acb92-f239-11e7-992e-5c3aac103b75.jpg
[5049-0]: https://user-images.githubusercontent.com/5627487/34648599-f5c6fe68-f3d6-11e7-88b8-bdf8a711492b.gif
[5051-0]: https://user-images.githubusercontent.com/10929019/34659702-df53b436-f409-11e7-826d-202b0d9e9548.JPG
[5062-0]: https://user-images.githubusercontent.com/792924/34731958-b8a74bd8-f55b-11e7-867e-091183a46887.png
[5067-0]: https://user-images.githubusercontent.com/254562/34749182-06a03766-f56e-11e7-997e-08d8851df21f.png
[5076-0]: https://user-images.githubusercontent.com/254562/34797795-97a8bbe8-f627-11e7-83d9-92519b673696.png
[5076-1]: https://user-images.githubusercontent.com/254562/34797796-97b52748-f627-11e7-97a1-53ec01d44faa.png
[5088-0]: https://user-images.githubusercontent.com/254562/34850467-f6feb684-f6f3-11e7-9dcb-ffde64e6ab7f.png
[5088-1]: https://user-images.githubusercontent.com/254562/34850468-f70974de-f6f3-11e7-99ed-4e77fd8d01c7.png
[5092-0]: https://user-images.githubusercontent.com/7821757/34869996-c4571c10-f7ae-11e7-9792-c91a208a1736.gif
[4605]: https://github.com/devtools-html/debugger.html/pull/4605
[4699]: https://github.com/devtools-html/debugger.html/pull/4699
[4704]: https://github.com/devtools-html/debugger.html/pull/4704
[4734]: https://github.com/devtools-html/debugger.html/pull/4734
[4737]: https://github.com/devtools-html/debugger.html/pull/4737
[4738]: https://github.com/devtools-html/debugger.html/pull/4738
[4741]: https://github.com/devtools-html/debugger.html/pull/4741
[4742]: https://github.com/devtools-html/debugger.html/pull/4742
[4747]: https://github.com/devtools-html/debugger.html/pull/4747
[4749]: https://github.com/devtools-html/debugger.html/pull/4749
[4752]: https://github.com/devtools-html/debugger.html/pull/4752
[4753]: https://github.com/devtools-html/debugger.html/pull/4753
[4758]: https://github.com/devtools-html/debugger.html/pull/4758
[4762]: https://github.com/devtools-html/debugger.html/pull/4762
[4769]: https://github.com/devtools-html/debugger.html/pull/4769
[4770]: https://github.com/devtools-html/debugger.html/pull/4770
[4764]: https://github.com/devtools-html/debugger.html/pull/4764
[4771]: https://github.com/devtools-html/debugger.html/pull/4771
[4774]: https://github.com/devtools-html/debugger.html/pull/4774
[4775]: https://github.com/devtools-html/debugger.html/pull/4775
[4779]: https://github.com/devtools-html/debugger.html/pull/4779
[4786]: https://github.com/devtools-html/debugger.html/pull/4786
[4789]: https://github.com/devtools-html/debugger.html/pull/4789
[4790]: https://github.com/devtools-html/debugger.html/pull/4790
[4793]: https://github.com/devtools-html/debugger.html/pull/4793
[4795]: https://github.com/devtools-html/debugger.html/pull/4795
[4801]: https://github.com/devtools-html/debugger.html/pull/4801
[4802]: https://github.com/devtools-html/debugger.html/pull/4802
[4803]: https://github.com/devtools-html/debugger.html/pull/4803
[4805]: https://github.com/devtools-html/debugger.html/pull/4805
[4806]: https://github.com/devtools-html/debugger.html/pull/4806
[4808]: https://github.com/devtools-html/debugger.html/pull/4808
[4814]: https://github.com/devtools-html/debugger.html/pull/4814
[4817]: https://github.com/devtools-html/debugger.html/pull/4817
[4818]: https://github.com/devtools-html/debugger.html/pull/4818
[4820]: https://github.com/devtools-html/debugger.html/pull/4820
[4821]: https://github.com/devtools-html/debugger.html/pull/4821
[4822]: https://github.com/devtools-html/debugger.html/pull/4822
[4826]: https://github.com/devtools-html/debugger.html/pull/4826
[4829]: https://github.com/devtools-html/debugger.html/pull/4829
[4830]: https://github.com/devtools-html/debugger.html/pull/4830
[4840]: https://github.com/devtools-html/debugger.html/pull/4840
[4845]: https://github.com/devtools-html/debugger.html/pull/4845
[4850]: https://github.com/devtools-html/debugger.html/pull/4850
[4851]: https://github.com/devtools-html/debugger.html/pull/4851
[4858]: https://github.com/devtools-html/debugger.html/pull/4858
[4860]: https://github.com/devtools-html/debugger.html/pull/4860
[4861]: https://github.com/devtools-html/debugger.html/pull/4861
[4866]: https://github.com/devtools-html/debugger.html/pull/4866
[4873]: https://github.com/devtools-html/debugger.html/pull/4873
[4874]: https://github.com/devtools-html/debugger.html/pull/4874
[4875]: https://github.com/devtools-html/debugger.html/pull/4875
[4876]: https://github.com/devtools-html/debugger.html/pull/4876
[4877]: https://github.com/devtools-html/debugger.html/pull/4877
[4880]: https://github.com/devtools-html/debugger.html/pull/4880
[4882]: https://github.com/devtools-html/debugger.html/pull/4882
[4890]: https://github.com/devtools-html/debugger.html/pull/4890
[4891]: https://github.com/devtools-html/debugger.html/pull/4891
[4892]: https://github.com/devtools-html/debugger.html/pull/4892
[4893]: https://github.com/devtools-html/debugger.html/pull/4893
[4898]: https://github.com/devtools-html/debugger.html/pull/4898
[4900]: https://github.com/devtools-html/debugger.html/pull/4900
[4903]: https://github.com/devtools-html/debugger.html/pull/4903
[4905]: https://github.com/devtools-html/debugger.html/pull/4905
[4909]: https://github.com/devtools-html/debugger.html/pull/4909
[4911]: https://github.com/devtools-html/debugger.html/pull/4911
[4912]: https://github.com/devtools-html/debugger.html/pull/4912
[4914]: https://github.com/devtools-html/debugger.html/pull/4914
[4918]: https://github.com/devtools-html/debugger.html/pull/4918
[4921]: https://github.com/devtools-html/debugger.html/pull/4921
[4922]: https://github.com/devtools-html/debugger.html/pull/4922
[4925]: https://github.com/devtools-html/debugger.html/pull/4925
[4926]: https://github.com/devtools-html/debugger.html/pull/4926
[4931]: https://github.com/devtools-html/debugger.html/pull/4931
[4937]: https://github.com/devtools-html/debugger.html/pull/4937
[4938]: https://github.com/devtools-html/debugger.html/pull/4938
[4941]: https://github.com/devtools-html/debugger.html/pull/4941
[4944]: https://github.com/devtools-html/debugger.html/pull/4944
[4945]: https://github.com/devtools-html/debugger.html/pull/4945
[4947]: https://github.com/devtools-html/debugger.html/pull/4947
[4948]: https://github.com/devtools-html/debugger.html/pull/4948
[4952]: https://github.com/devtools-html/debugger.html/pull/4952
[4955]: https://github.com/devtools-html/debugger.html/pull/4955
[4956]: https://github.com/devtools-html/debugger.html/pull/4956
[4959]: https://github.com/devtools-html/debugger.html/pull/4959
[4961]: https://github.com/devtools-html/debugger.html/pull/4961
[4963]: https://github.com/devtools-html/debugger.html/pull/4963
[4965]: https://github.com/devtools-html/debugger.html/pull/4965
[4966]: https://github.com/devtools-html/debugger.html/pull/4966
[4967]: https://github.com/devtools-html/debugger.html/pull/4967
[4968]: https://github.com/devtools-html/debugger.html/pull/4968
[4972]: https://github.com/devtools-html/debugger.html/pull/4972
[4973]: https://github.com/devtools-html/debugger.html/pull/4973
[4974]: https://github.com/devtools-html/debugger.html/pull/4974
[4975]: https://github.com/devtools-html/debugger.html/pull/4975
[4978]: https://github.com/devtools-html/debugger.html/pull/4978
[4981]: https://github.com/devtools-html/debugger.html/pull/4981
[4982]: https://github.com/devtools-html/debugger.html/pull/4982
[4983]: https://github.com/devtools-html/debugger.html/pull/4983
[4984]: https://github.com/devtools-html/debugger.html/pull/4984
[4986]: https://github.com/devtools-html/debugger.html/pull/4986
[4987]: https://github.com/devtools-html/debugger.html/pull/4987
[4988]: https://github.com/devtools-html/debugger.html/pull/4988
[4989]: https://github.com/devtools-html/debugger.html/pull/4989
[4990]: https://github.com/devtools-html/debugger.html/pull/4990
[4991]: https://github.com/devtools-html/debugger.html/pull/4991
[4992]: https://github.com/devtools-html/debugger.html/pull/4992
[4997]: https://github.com/devtools-html/debugger.html/pull/4997
[4998]: https://github.com/devtools-html/debugger.html/pull/4998
[4999]: https://github.com/devtools-html/debugger.html/pull/4999
[5000]: https://github.com/devtools-html/debugger.html/pull/5000
[5001]: https://github.com/devtools-html/debugger.html/pull/5001
[5009]: https://github.com/devtools-html/debugger.html/pull/5009
[5010]: https://github.com/devtools-html/debugger.html/pull/5010
[5011]: https://github.com/devtools-html/debugger.html/pull/5011
[5012]: https://github.com/devtools-html/debugger.html/pull/5012
[5013]: https://github.com/devtools-html/debugger.html/pull/5013
[5014]: https://github.com/devtools-html/debugger.html/pull/5014
[5015]: https://github.com/devtools-html/debugger.html/pull/5015
[5016]: https://github.com/devtools-html/debugger.html/pull/5016
[5017]: https://github.com/devtools-html/debugger.html/pull/5017
[5018]: https://github.com/devtools-html/debugger.html/pull/5018
[5020]: https://github.com/devtools-html/debugger.html/pull/5020
[5026]: https://github.com/devtools-html/debugger.html/pull/5026
[5027]: https://github.com/devtools-html/debugger.html/pull/5027
[5032]: https://github.com/devtools-html/debugger.html/pull/5032
[5036]: https://github.com/devtools-html/debugger.html/pull/5036
[5037]: https://github.com/devtools-html/debugger.html/pull/5037
[5038]: https://github.com/devtools-html/debugger.html/pull/5038
[5039]: https://github.com/devtools-html/debugger.html/pull/5039
[5041]: https://github.com/devtools-html/debugger.html/pull/5041
[5045]: https://github.com/devtools-html/debugger.html/pull/5045
[5048]: https://github.com/devtools-html/debugger.html/pull/5048
[5049]: https://github.com/devtools-html/debugger.html/pull/5049
[5051]: https://github.com/devtools-html/debugger.html/pull/5051
[5052]: https://github.com/devtools-html/debugger.html/pull/5052
[5054]: https://github.com/devtools-html/debugger.html/pull/5054
[5055]: https://github.com/devtools-html/debugger.html/pull/5055
[5058]: https://github.com/devtools-html/debugger.html/pull/5058
[5060]: https://github.com/devtools-html/debugger.html/pull/5060
[5062]: https://github.com/devtools-html/debugger.html/pull/5062
[5063]: https://github.com/devtools-html/debugger.html/pull/5063
[5066]: https://github.com/devtools-html/debugger.html/pull/5066
[5067]: https://github.com/devtools-html/debugger.html/pull/5067
[5071]: https://github.com/devtools-html/debugger.html/pull/5071
[5073]: https://github.com/devtools-html/debugger.html/pull/5073
[5075]: https://github.com/devtools-html/debugger.html/pull/5075
[5076]: https://github.com/devtools-html/debugger.html/pull/5076
[5077]: https://github.com/devtools-html/debugger.html/pull/5077
[5088]: https://github.com/devtools-html/debugger.html/pull/5088
[5090]: https://github.com/devtools-html/debugger.html/pull/5090
[5092]: https://github.com/devtools-html/debugger.html/pull/5092
[5093]: https://github.com/devtools-html/debugger.html/pull/5093
[5094]: https://github.com/devtools-html/debugger.html/pull/5094
[5095]: https://github.com/devtools-html/debugger.html/pull/5095
[5097]: https://github.com/devtools-html/debugger.html/pull/5097
[5099]: https://github.com/devtools-html/debugger.html/pull/5099
[5101]: https://github.com/devtools-html/debugger.html/pull/5101
[@davidedecenzo]: https://github.com/DavideDeCenzo
[@fischer-l]: https://github.com/Fischer-L
[@zaggy]: https://github.com/zaggy
[@khal0988]: https://github.com/khal0988
[@james300]: https://github.com/James300
[@borian]: https://github.com/borian
[@garethsharpe]: https://github.com/GarethSharpe
[@anshulmalik]: https://github.com/AnshulMalik
[@jasonlaster]: https://github.com/jasonLaster
[@guywarburg]: https://github.com/guywarburg
[@assafdd]: https://github.com/assafdd
[@cristidrg]: https://github.com/cristidrg
[@codehag]: https://github.com/codehag
[@fivepointseven]: https://github.com/fivepointseven
[@lukaszsobek]: https://github.com/lukaszsobek
[@nyrosmith]: https://github.com/nyrosmith
[@sharathnarayanph]: https://github.com/sharathnarayanph
[@darkwing]: https://github.com/darkwing
[@zacqary]: https://github.com/Zacqary
[@yurydelendik]: https://github.com/yurydelendik
[@charlesstocky]: https://github.com/CharlesStocky
[@samuel-peers]: https://github.com/samuel-peers
[@arthur801031]: https://github.com/arthur801031
[@juliandescottes]: https://github.com/juliandescottes
[@http-request]: https://github.com/http-request
[@securter]: https://github.com/Securter
[@ryanjduffy]: https://github.com/ryanjduffy
[@umohm1]: https://github.com/umohm1
[@pradeepgangwar]: https://github.com/pradeepgangwar
[@kootoopas]: https://github.com/kootoopas
[@aagandhi1]: https://github.com/aagandhi1
[@mikeratcliffe]: https://github.com/MikeRatcliffe
[@bomsy]: https://github.com/bomsy
[@sotayamashita]: https://github.com/sotayamashita
[@storm-engineering]: https://github.com/Storm-Engineering
[@tbroadley]: https://github.com/tbroadley
[@joshunger]: https://github.com/joshunger
[@wldcordeiro]: https://github.com/wldcordeiro
[@sam-clulow]: https://github.com/sam-clulow
[@vasusena]: https://github.com/Vasusena
[@nchevobbe]: https://github.com/nchevobbe
