
### April 18th

* We shared our [plans][post] for an improved call stack and landed key features like collapsing framework frames, highlighting libraries, and describing framework names. [1][pr-24], [2][pr-12] Big thanks to [@jbhoosreddy]!
* [@samjwalker] fixed an embarrassing Editor layout issue which caused the debugger to have gaps in the UI!
* Have you ever hunted through the window object to find a global variable? [@bomsy] made previewing Window objects a joy, by highlighting application globals and hiding native properties! [1][pr-1]
* We emphasized testing last week and dramatically improved our integration tests and added our first Jest component tests. Thanks [@AnshulMalik] for adding our first component unit test!

Thanks everyone who helped make this a great week! [@mquander], [@AnshulMalik], [@arthur801031], [@samjwalker], [@jbhoosreddy], [@tommai78101], [@irfanhudda], [@nchevobbe], [@AlfonsoML], [@jasonLaster], [@bomsy]

#### UI

* [Default props bucket][pr-1] - [@bomsy]
* [formatting functions][pr-6] - [@jasonLaster]
* ['Reveal in tree' should also work for tabs with pretty printed source ][pr-8] - [@arthur801031]
* [Don't push bottom scroll bar off screen when search is opened for files that don't need to be prettified][pr-10] - [@samjwalker]
* [Hidden tab shown when clicked from tree node][pr-15] - [@AnshulMalik]
* [Added F3 hotkey for searching.][pr-16] - [@tommai78101]

#### Framework Call Stacks

* [collapse react frames][pr-12] - [@jbhoosreddy]
* [Map Display Names][pr-24] - [@jasonLaster]

#### Bug Fixes

* [basic fix for broken function preview][pr-2] - [@bomsy]
* [Only parse js][pr-5] - [@jasonLaster]
* [Fix call stack test][pr-9] - [@jasonLaster]
* [Fix isDirectory function][pr-20] - [@irfanhudda]


#### Infrastructure

* [Fix breakage in Chrome initialization logic][pr-3] - [@mquander]
* [Resolve svg src warning in jest tests][pr-13] - [@AnshulMalik]


#### Testing

* [Add jest test for CloseButton][pr-11] - [@AnshulMalik]
* [Fix WTR tests - expressions, call stack][pr-14] - [@jasonLaster]
* [Add a test for tabs][pr-17] - [@jasonLaster]
* [Fix up remaining WTR tests][pr-22] - [@jasonLaster]
* [Add scopes mutation integration tests][pr-23] - [@nchevobbe]
* [Move parser fixtures to files][pr-26] - [@jasonLaster]


#### ES6
* [Convert Editor/shared/ to es6 module][pr-4] - [@AnshulMalik]



----

#### Window Previewing

|Before|After|
|---|---|
|![window-before]|![window-after]|

#### Debugger UI Gap

|Before|After|
|---|---|
|![gap-before]|![gap-after]|


#### Jest Unit Tests
Here's our first component unit test:

```js
describe("CloseButton", () => {
  it("should call handleClick function", () => {
    const onClick = jest.genMockFunction();
    const wrapper = shallow(new CloseButton({ handleClick: onClick }));

    wrapper.simulate("click");
    expect(onClick).toBeCalled();
  });

  it("should render a button", () => {
    const onClick = jest.genMockFunction();
    const buttonClass = "class";
    const wrapper = shallow(
      new CloseButton({
        handleClick: onClick,
        buttonClass: buttonClass,
        tooltip: "Close button"
      })
    );

    expect(wrapper).toMatchSnapshot();
  });
});
```


[gap-before]: https://cloud.githubusercontent.com/assets/2481105/24934571/57da2a70-1eea-11e7-86ba-f71f53df37fb.png
[gap-after]: https://cloud.githubusercontent.com/assets/2481105/24934569/51875a9e-1eea-11e7-854e-232802f60c3d.png
[window-after]: https://cloud.githubusercontent.com/assets/792924/24918230/9867b87c-1ed7-11e7-9167-36b127ff95ea.png
[window-before]: https://cloud.githubusercontent.com/assets/792924/24918083/fe5ceac2-1ed6-11e7-83fa-6d6ca1f12ad3.png

[post]: https://devtools-html.github.io/debugger.html/docs/updates/call-stack-4-10-2017.html
[pr-0]:https://github.com/devtools-html/debugger.html/pull/2593
[pr-1]:https://github.com/devtools-html/debugger.html/pull/2623
[pr-2]:https://github.com/devtools-html/debugger.html/pull/2613
[pr-3]:https://github.com/devtools-html/debugger.html/pull/2617
[pr-4]:https://github.com/devtools-html/debugger.html/pull/2622
[pr-5]:https://github.com/devtools-html/debugger.html/pull/2607
[pr-6]:https://github.com/devtools-html/debugger.html/pull/2625
[pr-7]:https://github.com/devtools-html/debugger.html/pull/2620
[pr-8]:https://github.com/devtools-html/debugger.html/pull/2621
[pr-9]:https://github.com/devtools-html/debugger.html/pull/2627
[pr-10]:https://github.com/devtools-html/debugger.html/pull/2441
[pr-11]:https://github.com/devtools-html/debugger.html/pull/2628
[pr-12]:https://github.com/devtools-html/debugger.html/pull/2596
[pr-13]:https://github.com/devtools-html/debugger.html/pull/2633
[pr-14]:https://github.com/devtools-html/debugger.html/pull/2635
[pr-15]:https://github.com/devtools-html/debugger.html/pull/2640
[pr-16]:https://github.com/devtools-html/debugger.html/pull/2642
[pr-17]:https://github.com/devtools-html/debugger.html/pull/2639
[pr-18]:https://github.com/devtools-html/debugger.html/pull/2629
[pr-19]:https://github.com/devtools-html/debugger.html/pull/2648
[pr-20]:https://github.com/devtools-html/debugger.html/pull/2624
[pr-21]:https://github.com/devtools-html/debugger.html/pull/2649
[pr-22]:https://github.com/devtools-html/debugger.html/pull/2661
[pr-23]:https://github.com/devtools-html/debugger.html/pull/2655
[pr-24]:https://github.com/devtools-html/debugger.html/pull/2657
[pr-25]:https://github.com/devtools-html/debugger.html/pull/2664
[pr-26]:https://github.com/devtools-html/debugger.html/pull/2665
[@jasonLaster]:http://github.com/jasonLaster
[@bomsy]:http://github.com/bomsy
[@mquander]:http://github.com/mquander
[@AnshulMalik]:http://github.com/AnshulMalik
[@arthur801031]:http://github.com/arthur801031
[@samjwalker]:http://github.com/samjwalker
[@jbhoosreddy]:http://github.com/jbhoosreddy
[@tommai78101]:http://github.com/tommai78101
[@irfanhudda]:http://github.com/irfanhudda
[@nchevobbe]:http://github.com/nchevobbe
[@AlfonsoML]:http://github.com/AlfonsoML
