## March 20th

This was a jam packed week:

1.  Original Languages got support for preview
2.  Stepping now handles many edge cases
3.  Preview supports many new edge cases
4.  Huge performance wins for loading evil and cheap webpack bundles

Thanks to all of the contributors!

[@Rohanhacker], [@atwalg2], [@bomsy], [@lukaszsobek], [@loganfsmyth], [@mmcote], [@AnshulMalik], [@zeoneo], [@hozefaj], [@MarkPollmann]

### Map Original Languages

Last week we landed support for mapping expressions. We map original variables to generated expressions, which is especially useful for webpack and babel module dependencies.

We are currently using the new mappings in the debugger's preview and watch expressions. We will add support to the console this week.

Last week we also fixed some bugs with the scope mapping logic:

1.  out of order declarations
2.  flow types are now excluded
3.  optimized away bindings

* [Use original scope mappings to rewrite preview and watch expressions][5684] [@loganfsmyth]
* [Handle out-of-order declarations in scopes.][5690] [@loganfsmyth]
* [Exclude Flowtype bindings from original scope list.][5692] [@loganfsmyth]
* [Render a toggle for original/generated scopes when available.][5702] [@loganfsmyth]
* [[Scopes] Avoid exceptions when import bindings are optimized away.][5722] [@loganfsmyth]

[preview]: https://user-images.githubusercontent.com/254562/37664954-99287814-2c32-11e8-9b0c-d8088148ec3c.gif

| Preview original expressions |
| ---------------------------- |
| ![preview]                   |

| Jump between original and generated scopes |
| ------------------------------------------ |
| ![5702-0]                                  |

### Stepping

One of our quarterly goals is to improve the debugger's stepping quality. There are some cases where we either step too often or miss locations:

1.  multiple statements on the same line `console.log(); debugger; console.log(); debugger;`
2.  multiple expressions on the same line `e.g. a() ? b() ? c() : d()`
3.  multi-line statements e.g. array, object declarations and call expressions

We hope to solve all of these issues in the engine's debugger frontend, but in the meantime,
we're using a new pause point data structure which has all of the valid pause locations.

* [Pause points - client][5537] [@jasonLaster]
* [Pause points - server][pp]

[pp]: https://bugzilla.mozilla.org/show_bug.cgi?id=1447316

#### Statements

![](http://g.recordit.co/jlhm0BSr8b.gif)

#### Sequences

![](http://g.recordit.co/28uojVq9M0.gif)

#### Old Behavior -Sequences

![](http://g.recordit.co/fbnwBZrJ9m.gif)

### Performance

* [Improve loading sources][5648] [@jasonLaster]
* [refactored loading states & added loading in outline][5651] [@Rohanhacker]
* [Added VisibilityHandler to handle the mounting and unmounting of child components of App when changing panel tabs.][5688] [@mmcote]
* [update file icons to use img instead of svg][5709] [@hozefaj]

| Loading eval-source-maps (New) |
| ------------------------------ |
| ![5648-3]                      |

| Loading eval-source-maps (Old) |
| ------------------------------ |
| ![5648-0]                      |

### Preview

[@bomsy] landed an awesome fix for our preview engine, which makes it possible to preview member properties of indexed objects. In the example below, previously it was only possible to preview `collection` and `genres`, now it is possible to preview `movies` and `director`.

We'll be adding additional support for index keys and several other syntax locations in this [issue](https://github.com/devtools-html/debugger.html/issues/5695).

```js
collection.genres["sci-fi"].movies[0].director;
```

* [Fix computed member expressions][5655] [@bomsy]

### UI

* [[QuickOpen] Fix loading for searching symbols][5653] [@atwalg2]
* [Ensure sort by name button is visible in dark theme][5666] [@darkwing]
* [Fix home button color for dark theme][5673] [@darkwing]
* [Fix #5668 - Restore missing CSS var][5675] [@darkwing]
* [Fix message and formatting of Outline when no functions][5683] [@darkwing]
* [Open quick open without prefix selected][5715] [@MarkPollmann]
* [Enhancement add contenxt menu copy to clipboard][5704] [@zeoneo]

| Quick Open - Prefix |
| ------------------- |
| ![5715-0]           |

### Flow

One of our goals this quarter is to improve our pausing and stepping stability. To that end, we want to improve our flow support to help prevent preventable typeErrors.

This past week [@AnshulMalik] converted our source type, to a stricter read-only object. This will catch unintentional sets.

[@lukaszsobek] is making progress removing `toJS` calls from the codebase. He's seeing a significant performance win here as well.

* [Removes toJS from setInScopeLines][5664] [@lukaszsobek]
* [Fix flow config rules][5671] [@jasonLaster]
* [Make SourceRecord fields Read-Only][5703] [@AnshulMalik]
* [Lock down parser flow type exports][5674] [@jasonLaster]

### Bugs

* [Fix a couple of stepping typeErrors][5680] [@jasonLaster]

### Docs

* [March 13th update][5662] [@jasonLaster]

### Testing

* [Bump mochii][5670] [@jasonLaster]
* [Bump mochii to 28][5700] [@jasonLaster]
* [Fix failing mochitests][5676] [@jasonLaster]
* [Fixup console pretty print test][5689] [@jasonLaster]

### Code Health

* [backport - Bug 1436187 Move existing shared head files to devtools/cl…][5667] [@jasonLaster]
* [Allow dbg in the browser toolbox][5685] [@jasonLaster]
* [Backport changes from MC][5696] [@jasonLaster]
* [Backport changes made in mozilla-central for Bug 1382581][5705] [@nchevobbe]
* [Reformat the getIcon code][5723] [@darkwing]

### Infrastructure

* [added pretty quick][5719] [@Rohanhacker]

[5648-0]: https://shipusercontent.com/e43b9730dc89b9c3d794f7d9a7f8e4d4/Screen%20Shot%202018-03-09%20at%2010.14.16%20AM.png
[5648-1]: https://shipusercontent.com/684ced3a48464effd75d7bbc296973b4/Screen%20Shot%202018-03-09%20at%2010.14.00%20AM.png
[5648-2]: https://shipusercontent.com/9eb51ab907c4ff4387465344d52f248d/Screen%20Shot%202018-03-09%20at%2010.14.34%20AM.png
[5648-3]: https://shipusercontent.com/92dcf1ed3d7d3681e389a0d3940656ff/Screen%20Shot%202018-03-09%20at%2010.10.25%20AM.png
[5648-4]: https://shipusercontent.com/1ecb7b22f7a5bd3c241426e7c75fa7b4/Screen%20Shot%202018-03-09%20at%2010.08.51%20AM.png
[5648-5]: https://shipusercontent.com/0e3393c1c21a690e59e409f83e2a8dec/Screen%20Shot%202018-03-09%20at%2010.08.12%20AM.png
[5653-0]: https://user-images.githubusercontent.com/23143862/37255763-9e1dd6b6-2516-11e8-984f-619340629fa4.gif
[5666-0]: https://user-images.githubusercontent.com/46655/37372064-835743d8-26df-11e8-9971-f50c08f0a61c.png
[5670-0]: https://user-images.githubusercontent.com/254562/37410574-4c8aabb8-2777-11e8-82e9-aa02593eac89.png
[5673-0]: https://user-images.githubusercontent.com/46655/37427326-136f9652-2797-11e8-8671-e7f47bb3b08b.png
[5688-0]: https://user-images.githubusercontent.com/14250545/37176004-5d396b46-22d8-11e8-92f7-6e0ed588ca3d.gif
[5688-1]: https://user-images.githubusercontent.com/14250545/37488408-1f14a36c-285a-11e8-86c6-073693e9a725.gif
[5702-0]: https://user-images.githubusercontent.com/132260/37547099-eedb0082-292c-11e8-81f3-af2241649b82.gif
[5704-0]: https://user-images.githubusercontent.com/26451940/37554772-5401dfd6-2a03-11e8-82d3-00c001471416.gif
[5715-0]: https://user-images.githubusercontent.com/5286559/37593249-95cdf0ac-2b71-11e8-9385-3fe4d105a215.gif
[5537]: https://github.com/devtools-html/debugger.html/pull/5537
[5648]: https://github.com/devtools-html/debugger.html/pull/5648
[5651]: https://github.com/devtools-html/debugger.html/pull/5651
[5653]: https://github.com/devtools-html/debugger.html/pull/5653
[5655]: https://github.com/devtools-html/debugger.html/pull/5655
[5662]: https://github.com/devtools-html/debugger.html/pull/5662
[5664]: https://github.com/devtools-html/debugger.html/pull/5664
[5666]: https://github.com/devtools-html/debugger.html/pull/5666
[5667]: https://github.com/devtools-html/debugger.html/pull/5667
[5670]: https://github.com/devtools-html/debugger.html/pull/5670
[5671]: https://github.com/devtools-html/debugger.html/pull/5671
[5673]: https://github.com/devtools-html/debugger.html/pull/5673
[5674]: https://github.com/devtools-html/debugger.html/pull/5674
[5675]: https://github.com/devtools-html/debugger.html/pull/5675
[5676]: https://github.com/devtools-html/debugger.html/pull/5676
[5680]: https://github.com/devtools-html/debugger.html/pull/5680
[5683]: https://github.com/devtools-html/debugger.html/pull/5683
[5684]: https://github.com/devtools-html/debugger.html/pull/5684
[5685]: https://github.com/devtools-html/debugger.html/pull/5685
[5688]: https://github.com/devtools-html/debugger.html/pull/5688
[5689]: https://github.com/devtools-html/debugger.html/pull/5689
[5690]: https://github.com/devtools-html/debugger.html/pull/5690
[5692]: https://github.com/devtools-html/debugger.html/pull/5692
[5696]: https://github.com/devtools-html/debugger.html/pull/5696
[5700]: https://github.com/devtools-html/debugger.html/pull/5700
[5702]: https://github.com/devtools-html/debugger.html/pull/5702
[5703]: https://github.com/devtools-html/debugger.html/pull/5703
[5704]: https://github.com/devtools-html/debugger.html/pull/5704
[5705]: https://github.com/devtools-html/debugger.html/pull/5705
[5709]: https://github.com/devtools-html/debugger.html/pull/5709
[5715]: https://github.com/devtools-html/debugger.html/pull/5715
[5719]: https://github.com/devtools-html/debugger.html/pull/5719
[5722]: https://github.com/devtools-html/debugger.html/pull/5722
[5723]: https://github.com/devtools-html/debugger.html/pull/5723
[@jasonlaster]: https://github.com/jasonLaster
[@rohanhacker]: https://github.com/Rohanhacker
[@atwalg2]: https://github.com/atwalg2
[@bomsy]: https://github.com/bomsy
[@lukaszsobek]: https://github.com/lukaszsobek
[@darkwing]: https://github.com/darkwing
[@loganfsmyth]: https://github.com/loganfsmyth
[@mmcote]: https://github.com/mmcote
[@anshulmalik]: https://github.com/AnshulMalik
[@zeoneo]: https://github.com/zeoneo
[@nchevobbe]: https://github.com/nchevobbe
[@hozefaj]: https://github.com/hozefaj
[@markpollmann]: https://github.com/MarkPollmann
