## February 27th

Last Week we continued focusing on bug fixes and UI polish as we prepare for Firefox 60. We also made progress on some original stepping and scopes projects.

We also worked on improving breakpoint and stepping support. These fixes should make the debugger more stable and ensure breakpoints at original locations get hit more often. If you find a case where we're not pausing let us know!

If you're into framework features you will also like the progress we're making on improving preview, frameworks.

[@AlexisDeschamps], [@lukaszsobek], [@darkwing], [@CharlesStocky], [@jasonLaster], [@nchevobbe], [@mmcote], [@loganfsmyth], [@AnshulMalik], [@juliandescottes], [@codehag], [@calebstdenis], [@bhackett1024], [@munyari], [@atwalg2]

### Features

#### Original Stepping

Our goal is to make stepping over original code with sourcemaps as good as stepping over regular JS code. This is difficult because we have to rely on source maps and parsing the original code
to understand where we are paused and where we want to step. With that said, there are some concrete steps we can take. Pun not intended :)

1.  don't step in the same place twice
2.  don't pause in a function header or opening curly of a block like a for loop

We added support for these two heuristics last week. We will continue exploring new heuristics over the next couple of months.

* [Automatically stepOver locations with useless mappings][5485] [@loganfsmyth]

#### Original Scopes

Our goal is to show original scopes & variables as well as we show normal JS scopes and variables. This is a challenge because the debugger is _actually_ paused at a generated location. The JS engine does not know the source map exists! Our strategy is to parse the original code and try to map original scopes and bindings with the browser's scopes and bindings.

We have been making a lot of progress and believe we've done all of the "happy" cases where babel creates correct mappings. This past week we looked into a case where babel 6 did not create mappings for imported bindings. This was a problem because in this case all of the dependencies would be marked as un-mapped. We believe we solved this problem and dependencies should now be mapped!

* [[Scopes] Recognize imports when from babel 6][5539] [@loganfsmyth]

| Stepping Into function w/ assignments! |
| -------------------------------------- |
| ![5485-0]                              |

#### Preview

Our previews use Babel's parser, which lets us be smart about what we want to preview and exclude things we do not want to preview. For instance, we don't preview expressions that are out of scope. Last week, we added support for excluding class methods and flow types. Hopefully we'll continue to find more cases where it doesn't make sense to preview!

* [Exclude flow annotations from symbol identifiers][5486] [@AnshulMalik]
* [should ignore some labels][5531] [@atwalg2]

| Preview   |
| --------- |
| ![5486-0] |

#### Parser

We like to recognize when a file has a Framework component, because when we do we can show the framework badge in the tab or the source tree. Up to this point, we've only done this for React, but we're now looking into doing it for Angular and Vue!

* [recognize Angular files][5527] [@lukaszsobek]

#### Bug Fixes

* [Clear the sourceMapURL on fail to load source maps in order to enable pretty printing][5296] [@AlexisDeschamps]
* [Stepping with await should check the text before and after the pause location][5452] [@jasonLaster]
* [Allow 'Reveal in Tree' for pretty tabs][5483] [@darkwing]
* [Try to address empty debugger bug by keeping track of ongoing work][5490] [@codehag]
* [Fix project directory root][5493] [@jasonLaster]
* [Don't show scopes/frames panes if there are no frames.][5516] [@bhackett1024]

#### Breakpoints & Stepping

We're working hard to improve our support for handling edge cases like reloading with source maps or watch expressions. And, edge cases with breakpoints and stepping like adding a breakpoint at the beginning or end of lines.

* [Fix re-evaluating on resume][5524] [@jasonLaster]
* Adding a breakpoint at the end of the line
* Pausing while loading in an original file
* Breakpoint on first expression in block, before lexical declaration, excludes block from environment hierarchy
  [bug](https://bugzilla.mozilla.org/show_bug.cgi?id=1432682)

We hope to look at some other weird cases with stepping and pausing in the future!

* stepping over multiple statements on the same lines [example](http://silly-stepping.glitch.me/)
* stepping over boring lines in arrays, objects, parameters [example](http://silly-stepping.glitch.me/)
* pausing and resuming should advance the debugger [example](https://dbg-two-step.glitch.me/)

We're also making progress on skipping worker onmessage.

#### Code Health

* [Moves selectors to selector folder][5344] [@lukaszsobek]
* [Update devtools-reps to 0.20.0][5469] [@nchevobbe]
* [Enable original scopes in nightly][5492] [@jasonLaster]
* [Backport Bug 1434792 - Disable browser_dbg-sourcemaps-reload.js][5520] [@jasonLaster]
* [Backport Bug 1438487 - Restore the Browser Toolbox using session store][5521] [@jasonLaster]
* [Revert "Enable original scopes in nightly (#5492)"][5523] [@jasonLaster]
* [Use functional setState when derived from previous][5525] [@munyari]

#### UI

* [Ensure SearchInput retains value when open and clears when closed][5399] [@darkwing]
* [Truncate footer labels][5438] [@CharlesStocky]
* [Ensure the source tree highlights the correct item][5455] [@darkwing]

#### Quick Open Modal

* [Fixes Quick Open ? pr][5504] [@lukaszsobek]
* [Close Quick Open Model when file or project search opens][5417] [@lukaszsobek]
* [Fix Quick Open Modal error][5517] [@darkwing]

#### Performance

* [[Preview] Empty Expression][5475] [@jasonLaster]

### Docs

* [February 20th update][5478] [@jasonLaster]
* [Fix 2/20 update text to fix warnings][5481] [@darkwing]

### Infrastructure

* [Add @juliandescottes to CODEOWNERS for properties file][5488] [@juliandescottes]
* [Update lint-staged to the latest version 🚀][5489]
* [Update eslint-plugin-mozilla to the latest version 🚀][5503]
* [Bump launchpad][5542] [@jasonLaster]

### Testing

* [[CallStack] More test coverage for framework grouping][5502] [@calebstdenis]
* [Fix the storybook enough to run by changing dark theme path][5513] [@darkwing]

[5296-0]: https://user-images.githubusercontent.com/12681350/36043558-a7867220-0d9d-11e8-8d4d-10a790cdc101.png
[5296-1]: https://user-images.githubusercontent.com/12681350/36043272-c53f9fea-0d9c-11e8-9e49-2c5e10194124.png
[5417-0]: https://user-images.githubusercontent.com/23530054/36194193-0ea3ddca-1169-11e8-931a-c1f18813dec9.gif
[5438-0]: https://user-images.githubusercontent.com/24966772/36284297-cfa284dc-126c-11e8-9cae-8dd5cb1300c9.png
[5438-1]: https://user-images.githubusercontent.com/24966772/36284313-ddaeba46-126c-11e8-89a4-b7256fe1e9d4.png
[5438-2]: https://user-images.githubusercontent.com/24966772/36284361-044384ca-126d-11e8-9662-68050ee38a8e.png
[5438-3]: https://user-images.githubusercontent.com/24966772/36284365-08284b02-126d-11e8-87b8-70ced08181ba.png
[5480-0]: https://user-images.githubusercontent.com/14250545/36442058-bdb8f350-1631-11e8-87b4-c0a3ad12bf97.gif
[5480-1]: https://user-images.githubusercontent.com/14250545/36442064-c26b6cac-1631-11e8-826e-c0d7824070d2.gif
[5485-0]: https://user-images.githubusercontent.com/132260/36460862-401bc0ce-166f-11e8-8fa2-792f199ed5b2.gif
[5486-0]: https://user-images.githubusercontent.com/7821757/36467741-1ebec1fa-1706-11e8-80c7-ebc7be26c6db.gif
[5502-0]: https://user-images.githubusercontent.com/7321311/36545476-f434d152-17b6-11e8-8b0c-a0a34a08736b.png
[5504-0]: https://user-images.githubusercontent.com/23530054/36548103-b5d50628-17ef-11e8-9a60-45ac490f8266.gif
[5508-0]: https://user-images.githubusercontent.com/14250545/36173564-b21be2ca-10c6-11e8-991e-0fc19dd142a6.gif
[5508-1]: https://user-images.githubusercontent.com/14250545/36173600-cf3739d6-10c6-11e8-8b21-b82a50cc2f54.gif
[5531-0]: https://user-images.githubusercontent.com/23143862/36647331-182cad6e-1a41-11e8-8282-794cd09a18d2.gif
[5296]: https://github.com/devtools-html/debugger.html/pull/5296
[5344]: https://github.com/devtools-html/debugger.html/pull/5344
[5399]: https://github.com/devtools-html/debugger.html/pull/5399
[5417]: https://github.com/devtools-html/debugger.html/pull/5417
[5438]: https://github.com/devtools-html/debugger.html/pull/5438
[5452]: https://github.com/devtools-html/debugger.html/pull/5452
[5455]: https://github.com/devtools-html/debugger.html/pull/5455
[5469]: https://github.com/devtools-html/debugger.html/pull/5469
[5475]: https://github.com/devtools-html/debugger.html/pull/5475
[5478]: https://github.com/devtools-html/debugger.html/pull/5478
[5480]: https://github.com/devtools-html/debugger.html/pull/5480
[5481]: https://github.com/devtools-html/debugger.html/pull/5481
[5483]: https://github.com/devtools-html/debugger.html/pull/5483
[5485]: https://github.com/devtools-html/debugger.html/pull/5485
[5486]: https://github.com/devtools-html/debugger.html/pull/5486
[5488]: https://github.com/devtools-html/debugger.html/pull/5488
[5489]: https://github.com/devtools-html/debugger.html/pull/5489
[5490]: https://github.com/devtools-html/debugger.html/pull/5490
[5492]: https://github.com/devtools-html/debugger.html/pull/5492
[5493]: https://github.com/devtools-html/debugger.html/pull/5493
[5502]: https://github.com/devtools-html/debugger.html/pull/5502
[5503]: https://github.com/devtools-html/debugger.html/pull/5503
[5504]: https://github.com/devtools-html/debugger.html/pull/5504
[5507]: https://github.com/devtools-html/debugger.html/pull/5507
[5508]: https://github.com/devtools-html/debugger.html/pull/5508
[5513]: https://github.com/devtools-html/debugger.html/pull/5513
[5516]: https://github.com/devtools-html/debugger.html/pull/5516
[5517]: https://github.com/devtools-html/debugger.html/pull/5517
[5520]: https://github.com/devtools-html/debugger.html/pull/5520
[5521]: https://github.com/devtools-html/debugger.html/pull/5521
[5523]: https://github.com/devtools-html/debugger.html/pull/5523
[5524]: https://github.com/devtools-html/debugger.html/pull/5524
[5525]: https://github.com/devtools-html/debugger.html/pull/5525
[5527]: https://github.com/devtools-html/debugger.html/pull/5527
[5531]: https://github.com/devtools-html/debugger.html/pull/5531
[5539]: https://github.com/devtools-html/debugger.html/pull/5539
[5541]: https://github.com/devtools-html/debugger.html/pull/5541
[5542]: https://github.com/devtools-html/debugger.html/pull/5542
[@alexisdeschamps]: https://github.com/AlexisDeschamps
[@lukaszsobek]: https://github.com/lukaszsobek
[@darkwing]: https://github.com/darkwing
[@charlesstocky]: https://github.com/CharlesStocky
[@jasonlaster]: https://github.com/jasonLaster
[@nchevobbe]: https://github.com/nchevobbe
[@mmcote]: https://github.com/mmcote
[@loganfsmyth]: https://github.com/loganfsmyth
[@anshulmalik]: https://github.com/AnshulMalik
[@juliandescottes]: https://github.com/juliandescottes
[@codehag]: https://github.com/codehag
[@calebstdenis]: https://github.com/calebstdenis
[@bhackett1024]: https://github.com/bhackett1024
[@munyari]: https://github.com/munyari
[@atwalg2]: https://github.com/atwalg2
