## April 10th

[@atwalg2], [@AnshulMalik], [@MicahRamirez], [@mmcote], [@marcogallo566], [@AlexisDeschamps], [@loganfsmyth], [@dimitardanailov], [@yurydelendik], [@juliandescottes], [@marcobeltempo]

### Breakpoints

The past two weeks saw the beginning of implementation for our enhanced breakpoints display. Breakpoints are now syntax-highlighted and grouped by file while maintaining performance. The best part about this new feature is that it provides much more information "at a glance" to the user about where their breakpoints are and where they've placed their breakpoints.

* [Create a BreakpointItem component to make Breakpoints component cleaner][5852] [@darkwing]
* [Sort breakpoints by file name][5855] [@darkwing]
* [Syntax-highlight breakpoints][5864] [@darkwing]
* [Prevent selection of breakpoint contents][5879] [@darkwing]
* [Fix breakpoint line height][5889] [@darkwing]

| New UI    |
| --------- |
| ![5864-0] |

### Photon UI

The new Photon ResultList design is a great improvement. We now provide a resource icon which matches the its sources tree icon, as well as a tab icon which is shown when a given resource in the result list is currently opened. We've also condensed the line-height of source information, allowing us to show the user more without losing important result information.

* [Implement Photon ResultList Design][5839] [@MicahRamirez]
* [quickopen - path is too wide #5860][5868] [@dimitardanailov]

![](https://shipusercontent.com/79440ed4d132b022d6d808a1b114c8c2/Screen%20Shot%202018-04-10%20at%2011.25.44%20AM.png)

### Bugs

This week we landed fixes for watch expressions which should make the feature more stable:

1.  we no longer pause when an expression throws an exception
2.  we evaluated expressions concurrently in the client.

[PR][5644] [@jasonLaster]

We also fixed some issues with directory roots where a root with `webpack://` would not match [PR][5861].

### Preview

The Preview feature continues to improve in its ability to show expression values with different syntax usage; recent updates include destructured variable values, object properties with assignment, and other small improvements.

* [Evaluate Object properties with an assignment][5693] [@atwalg2]
* [Support destructured variables][5853] [@marcogallo566]
* [Preview - stop showing preview for the wrong original files][5878] [@jasonLaster]

### Sources Tree

We've talked about adding VS Code style source tree auto expanding in the past.
Anshul added it this week, and we're excited to see how it feels.

* [Auto expand path of selected source][5716] [@AnshulMalik]
* [Reveal in tree opens the left sidebar][5885] [@marcobeltempo]

| Auto Expand |
| ----------- |
| ![5716-0]   |

### UI

* [Escape no longer closes the modal][5866] [@dimitardanailov]
* [Fix odd cursor text issue][5877] [@darkwing]
* [ProjectSearch - Focus state colors are a bit off #5863][5882] [@dimitardanailov]
* [Remove all references to Firebug theme][5883] [@juliandescottes]
* [Avoid tree item height bouncing by setting line height][5890] [@darkwing]

### Features

* [Started highlighting the searched terms when clicking on a ProjectSearch result][5854] [@AlexisDeschamps]
* [Enable reading of the wasm name section to display debug names in text][5880] [@yurydelendik]

### Code Health

* [Switched getExtraProps to use findClosestFunction to get the component name.][5851] [@mmcote]
* [Update wasmparser to the latest version 🚀][5870]
* [preview - tweak getMappedExpression][5887] [@jasonLaster]

### Flow

The numerous Flow improvements continue to improve our code quality and documentation. The biggest improvement was adding `// @flow` to our reducers/types file which has the type definition for our application State.

* [Add flow header to reducers/types.js][5874] [@AnshulMalik]
* [src/utils/clipboard.js - add type defs for flow][5895] [@atwalg2]
* [src/utils/dbg.js - add type defs for flow][5896] [@atwalg2]
* [src/utils/DevtoolsUtils.js - add type defs for flow coverage][5872] [@atwalg2]
* [src/utils/bootstrap.js - add type defs for flow coverage][5873] [@atwalg2]

### Testing

* [Add test already added in MC bug 1450145.][5856] [@loganfsmyth]
* [Backport expression error test][5867] [@jasonLaster]

[5693-0]: https://user-images.githubusercontent.com/23143862/37941756-07daf648-312d-11e8-8df8-a05e3875aa1b.png
[5693-1]: https://user-images.githubusercontent.com/23143862/37504516-7bab63c8-28a4-11e8-8249-ab72c02bdd38.gif
[5716-0]: https://user-images.githubusercontent.com/7821757/37600510-905cf28a-2bad-11e8-9c9d-2af08c0f1345.gif
[5839-0]: https://user-images.githubusercontent.com/5976612/38178110-59bb9be0-35d1-11e8-994d-1438add4c6fc.png
[5839-1]: https://user-images.githubusercontent.com/5976612/38178112-6dc12a92-35d1-11e8-9b16-4558ca48349c.png
[5839-2]: https://user-images.githubusercontent.com/5976612/38178122-8c327e0e-35d1-11e8-8200-2a3cd47d5e7b.png
[5851-0]: https://user-images.githubusercontent.com/14250545/38272818-96739732-3747-11e8-8a81-064c60871eaf.png
[5851-1]: https://user-images.githubusercontent.com/14250545/38272854-b6ac7370-3747-11e8-856e-47a5edcdb57a.png
[5853-0]: https://user-images.githubusercontent.com/36955296/38323667-366c7f64-383e-11e8-8b82-a75395f77dbd.jpg
[5853-1]: https://user-images.githubusercontent.com/36955296/38358492-a520bcf4-38c5-11e8-91ca-0a52e0ba8299.jpg
[5853-2]: https://user-images.githubusercontent.com/36955296/38358500-b03fe88a-38c5-11e8-8cd3-7831efaefae3.jpg
[5854-0]: https://user-images.githubusercontent.com/12681350/38325054-f17e49c4-380f-11e8-92dc-115040232103.png
[5854-1]: https://user-images.githubusercontent.com/12681350/38324989-c1c1a618-380f-11e8-96fd-a17ef7431d3f.png
[5855-0]: https://user-images.githubusercontent.com/46655/38335367-acfc0ad4-3823-11e8-8f52-41876b0e1056.png
[5861-0]: https://user-images.githubusercontent.com/254562/38369164-1af01350-38b5-11e8-8a6b-c9059aa60ffa.png
[5861-1]: https://user-images.githubusercontent.com/254562/38369108-f9534686-38b4-11e8-854b-beed191da438.png
[5864-0]: https://user-images.githubusercontent.com/46655/38400976-974b738c-3918-11e8-8aee-0ab9378e10d8.png
[5877-0]: https://user-images.githubusercontent.com/46655/38426901-73774548-397d-11e8-9204-bb074cb243b8.png
[5885-0]: https://user-images.githubusercontent.com/15523758/38449580-a76f93c6-39de-11e8-8c6f-c14a6cb6e510.gif
[5889-0]: https://user-images.githubusercontent.com/46655/38524895-e3bdeac4-3c15-11e8-800a-29a0eb348983.png
[5644]: https://github.com/devtools-html/debugger.html/pull/5644
[5693]: https://github.com/devtools-html/debugger.html/pull/5693
[5716]: https://github.com/devtools-html/debugger.html/pull/5716
[5839]: https://github.com/devtools-html/debugger.html/pull/5839
[5851]: https://github.com/devtools-html/debugger.html/pull/5851
[5852]: https://github.com/devtools-html/debugger.html/pull/5852
[5853]: https://github.com/devtools-html/debugger.html/pull/5853
[5854]: https://github.com/devtools-html/debugger.html/pull/5854
[5855]: https://github.com/devtools-html/debugger.html/pull/5855
[5856]: https://github.com/devtools-html/debugger.html/pull/5856
[5861]: https://github.com/devtools-html/debugger.html/pull/5861
[5864]: https://github.com/devtools-html/debugger.html/pull/5864
[5866]: https://github.com/devtools-html/debugger.html/pull/5866
[5867]: https://github.com/devtools-html/debugger.html/pull/5867
[5868]: https://github.com/devtools-html/debugger.html/pull/5868
[5870]: https://github.com/devtools-html/debugger.html/pull/5870
[5872]: https://github.com/devtools-html/debugger.html/pull/5872
[5873]: https://github.com/devtools-html/debugger.html/pull/5873
[5874]: https://github.com/devtools-html/debugger.html/pull/5874
[5877]: https://github.com/devtools-html/debugger.html/pull/5877
[5878]: https://github.com/devtools-html/debugger.html/pull/5878
[5879]: https://github.com/devtools-html/debugger.html/pull/5879
[5880]: https://github.com/devtools-html/debugger.html/pull/5880
[5882]: https://github.com/devtools-html/debugger.html/pull/5882
[5883]: https://github.com/devtools-html/debugger.html/pull/5883
[5885]: https://github.com/devtools-html/debugger.html/pull/5885
[5887]: https://github.com/devtools-html/debugger.html/pull/5887
[5889]: https://github.com/devtools-html/debugger.html/pull/5889
[5890]: https://github.com/devtools-html/debugger.html/pull/5890
[5895]: https://github.com/devtools-html/debugger.html/pull/5895
[5896]: https://github.com/devtools-html/debugger.html/pull/5896
[@jasonlaster]: https://github.com/jasonLaster
[@atwalg2]: https://github.com/atwalg2
[@anshulmalik]: https://github.com/AnshulMalik
[@micahramirez]: https://github.com/MicahRamirez
[@mmcote]: https://github.com/mmcote
[@darkwing]: https://github.com/darkwing
[@marcogallo566]: https://github.com/marcogallo566
[@alexisdeschamps]: https://github.com/AlexisDeschamps
[@loganfsmyth]: https://github.com/loganfsmyth
[@dimitardanailov]: https://github.com/dimitardanailov
[@yurydelendik]: https://github.com/yurydelendik
[@juliandescottes]: https://github.com/juliandescottes
[@marcobeltempo]: https://github.com/marcobeltempo
