/*
 * Copyright (c) 2019-2021, JetBrains s.r.o. and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation. JetBrains designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact JetBrains, Na Hrebenech II 1718/10, Prague, 14000, Czech Republic
 * if you need additional information or have any questions.
 */
package org.jetbrains.projector.awt.image

import java.awt.GraphicsConfiguration
import java.awt.GraphicsDevice
import java.awt.Point
import java.awt.Rectangle

class PGraphicsDevice(val idString: String) : GraphicsDevice() {

  val configuration = PGraphicsConfiguration(this)

  val bounds = Rectangle(1024, 768)
  val clientShift = Point(0, 0)
  var scaleFactor = 1.0

  val clientScreenBounds
    get() = Rectangle(bounds).apply {
      clientShift.let {
        x += it.x
        y += it.y
      }
    }

  override fun getType(): Int {
    return TYPE_RASTER_SCREEN
  }

  override fun getIDstring(): String {
    return idString
  }

  override fun getConfigurations(): Array<GraphicsConfiguration> {
    return arrayOf(defaultConfiguration)
  }

  override fun getDefaultConfiguration(): GraphicsConfiguration {
    return configuration
  }
}
