﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/s3control/model/JobReportScope.h>
#include <aws/core/utils/HashingUtils.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>

using namespace Aws::Utils;


namespace Aws
{
  namespace S3Control
  {
    namespace Model
    {
      namespace JobReportScopeMapper
      {

        static const int AllTasks_HASH = HashingUtils::HashString("AllTasks");
        static const int FailedTasksOnly_HASH = HashingUtils::HashString("FailedTasksOnly");


        JobReportScope GetJobReportScopeForName(const Aws::String& name)
        {
          int hashCode = HashingUtils::HashString(name.c_str());
          if (hashCode == AllTasks_HASH)
          {
            return JobReportScope::AllTasks;
          }
          else if (hashCode == FailedTasksOnly_HASH)
          {
            return JobReportScope::FailedTasksOnly;
          }
          EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
          if(overflowContainer)
          {
            overflowContainer->StoreOverflow(hashCode, name);
            return static_cast<JobReportScope>(hashCode);
          }

          return JobReportScope::NOT_SET;
        }

        Aws::String GetNameForJobReportScope(JobReportScope enumValue)
        {
          switch(enumValue)
          {
          case JobReportScope::AllTasks:
            return "AllTasks";
          case JobReportScope::FailedTasksOnly:
            return "FailedTasksOnly";
          default:
            EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
            if(overflowContainer)
            {
              return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
            }

            return {};
          }
        }

      } // namespace JobReportScopeMapper
    } // namespace Model
  } // namespace S3Control
} // namespace Aws
