﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/sqs/model/CreateQueueRequest.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

using namespace Aws::SQS::Model;
using namespace Aws::Utils;

CreateQueueRequest::CreateQueueRequest() : 
    m_queueNameHasBeenSet(false),
    m_attributesHasBeenSet(false),
    m_tagsHasBeenSet(false)
{
}

Aws::String CreateQueueRequest::SerializePayload() const
{
  Aws::StringStream ss;
  ss << "Action=CreateQueue&";
  if(m_queueNameHasBeenSet)
  {
    ss << "QueueName=" << StringUtils::URLEncode(m_queueName.c_str()) << "&";
  }

  if(m_attributesHasBeenSet)
  {
    unsigned attributesCount = 1;
    for(auto& item : m_attributes)
    {
      ss << "Attribute." << attributesCount << ".Name="
          << StringUtils::URLEncode(QueueAttributeNameMapper::GetNameForQueueAttributeName(item.first).c_str()) << "&";
      ss << "Attribute." << attributesCount << ".Value="
          << StringUtils::URLEncode(item.second.c_str()) << "&";
      attributesCount++;
    }
  }

  if(m_tagsHasBeenSet)
  {
    unsigned tagsCount = 1;
    for(auto& item : m_tags)
    {
      ss << "Tag." << tagsCount << ".Key="
          << StringUtils::URLEncode(item.first.c_str()) << "&";
      ss << "Tag." << tagsCount << ".Value="
          << StringUtils::URLEncode(item.second.c_str()) << "&";
      tagsCount++;
    }
  }

  ss << "Version=2012-11-05";
  return ss.str();
}


void  CreateQueueRequest::DumpBodyToUrl(Aws::Http::URI& uri ) const
{
  uri.SetQueryString(SerializePayload());
}
