﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#include <aws/translate/model/TerminologyData.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/HashingUtils.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws
{
namespace Translate
{
namespace Model
{

TerminologyData::TerminologyData() : 
    m_fileHasBeenSet(false),
    m_format(TerminologyDataFormat::NOT_SET),
    m_formatHasBeenSet(false)
{
}

TerminologyData::TerminologyData(JsonView jsonValue) : 
    m_fileHasBeenSet(false),
    m_format(TerminologyDataFormat::NOT_SET),
    m_formatHasBeenSet(false)
{
  *this = jsonValue;
}

TerminologyData& TerminologyData::operator =(JsonView jsonValue)
{
  if(jsonValue.ValueExists("File"))
  {
    m_file = HashingUtils::Base64Decode(jsonValue.GetString("File"));
    m_fileHasBeenSet = true;
  }

  if(jsonValue.ValueExists("Format"))
  {
    m_format = TerminologyDataFormatMapper::GetTerminologyDataFormatForName(jsonValue.GetString("Format"));

    m_formatHasBeenSet = true;
  }

  return *this;
}

JsonValue TerminologyData::Jsonize() const
{
  JsonValue payload;

  if(m_fileHasBeenSet)
  {
   payload.WithString("File", HashingUtils::Base64Encode(m_file));
  }

  if(m_formatHasBeenSet)
  {
   payload.WithString("Format", TerminologyDataFormatMapper::GetNameForTerminologyDataFormat(m_format));
  }

  return payload;
}

} // namespace Model
} // namespace Translate
} // namespace Aws
