/*
 * Copyright (c) 2013 Cinnober Financial Technology AB, Stockholm,
 * Sweden. All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Cinnober Financial Technology AB, Stockholm, Sweden. You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Cinnober.
 *
 * Cinnober makes no representations or warranties about the suitability
 * of the software, either expressed or implied, including, but not limited
 * to, the implied warranties of merchantibility, fitness for a particular
 * purpose, or non-infringement. Cinnober shall not be liable for any
 * damages suffered by licensee as a result of using, modifying, or
 * distributing this software or its derivatives.
 */
package com.cinnober.msgcodec.xml;

import java.util.Objects;

/**
 * @author mikael.brannstrom
 *
 */
public class NsName {
    private final String namespace;
    private final String name;
    /**
     * Create a new namespaced name.
     * @param namespace the namespace, or null for no namespace
     * @param name the name, not null.
     */
    public NsName(String namespace, String name) {
        this.namespace = namespace;
        this.name = Objects.requireNonNull(name);
    }
    /**
     * Returns the namespace.
     * @return the namespace, or null of no namespace.
     */
    public String getNamespace() {
        return namespace;
    }
    /**
     * @return the name, not null.
     */
    public String getName() {
        return name;
    }
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result
                + ((namespace == null) ? 0 : namespace.hashCode());
        return result;
    }
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        NsName other = (NsName) obj;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (namespace == null) {
            if (other.namespace != null)
                return false;
        } else if (!namespace.equals(other.namespace))
            return false;
        return true;
    }
    @Override
    public String toString() {
        return "NsName [namespace=" + namespace + ", name=" + name + "]";
    }


}
