

<!--
 * @Author: Boris
 * @Date: 2021-02-09 15:03:53
 * @Description:
-->

# 糗事百科抓取



https://www.qiushibaike.com/8hr/page/1/

![-w843](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/01/09/16101267651625.jpg)

我们以糗事百科抓取抓取为例，先抓推荐列表，然后抓详情，带领大家10分钟快速入门

## 1. 抓列表

![-w1485](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/01/09/16101239769142.jpg)

列表是html里直接返回的，我们打开检查工具，观察标题所在的标签，可写出如下xpath表达式

    //a[@class="recmd-content"]

创建爬虫

    feapder create -s spider_test

开始写代码

1. 下发任务：下发1~14页列表任务

        def start_requests(self):
            for i in range(1, 15):
                yield feapder.Request("https://www.qiushibaike.com/8hr/page/{}/".format(i))

1. 解析标题及详情页链接

        def parse(self, request, response):
            article_list = response.xpath('//a[@class="recmd-content"]')
            for article in article_list:
                title = article.xpath("./text()").extract_first()
                url = article.xpath("./@href").extract_first()
                print(title, url)

3. 运行，打印如下：

    ![-w1183](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/01/09/16101251846542.jpg)

    细心的你，会发现连接也自动补全了，网页源代码如下：
    ![-w671](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/01/09/16101252789007.jpg)

## 2. 抓详情

抓详情需要将列表采集到的url作为新任务，然后请求，解析。写法很简单，代码如下：

派发详情任务：

    yield feapder.Request(url, callback=self.parser_detail)  # callback 为回调函数

若我们需要携带title字段，写法如下

    yield feapder.Request(url, callback=self.parser_detail, title=title)  # title 为携带的字段，直接携带就行，不用放到一个meta里

解析详情

![-w1470](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/01/09/16101256627827.jpg)

    def parse_detail(self, request, response):
        """
        解析详情
        """
        # 取url
        url = request.url
        # 取title
        title = request.title
        # 解析正文
        content = response.xpath('string(//div[@class="content"])').extract_first() # string 表达式是取某个标签下的文本，包括子标签文本

        print("url", url)
        print("title", title)
        print("content", content)

## 整体代码如下


    import feapder


    class SpiderTest(feapder.AirSpider):
        def start_requests(self):
            for i in range(1, 15):
                yield feapder.Request("https://www.qiushibaike.com/8hr/page/{}/".format(i))

        def parse(self, request, response):
            article_list = response.xpath('//a[@class="recmd-content"]')
            for article in article_list:
                title = article.xpath("./text()").extract_first()
                url = article.xpath("./@href").extract_first()
                # print(title, url)

                yield feapder.Request(
                    url, callback=self.parse_detail, title=title
                )  # callback 为回调函数

        def parse_detail(self, request, response):
            """
            解析详情
            """
            # 取url
            url = request.url
            # 取title
            title = request.title
            # 解析正文
            content = response.xpath(
                'string(//div[@class="content"])'
            ).extract_first()  # string 表达式是取某个标签下的文本，包括子标签文本

            print("url", url)
            print("title", title)
            print("content", content)


    if __name__ == "__main__":
        SpiderTest().start()

嫌弃跑的太慢? 我们可以加一个参数轻松解决


    if __name__ == "__main__":
        SpiderTest(thread_count=15).start()

thread_count 为线程数


## 采集中可能需要如下问题：

编码错误

![-w1444](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/01/09/16101262462057.jpg)

这是因为框架解析解析text时默认使用了`strict`模式，我们可以加如下一行代码将其改成`ignore`模式，这样遇到不支持的字符便忽略

    response.encoding_errors = 'ignore'

![-w718](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/03/17/16159888418946.jpg)


我们还可以指定编码，来解决。写法如下

    response.code = '网页编码' #  已将encoding简写为code
