# FEAPDER

## 1. 支持周期性采集

周期性抓取是爬虫中常见的需求，如每日抓取一次商品的销量等，我们把每个周期称为一个批次。

本框架支持批次采集，引入了批次表的概念，详细记录了每一批次的抓取状态

![-w899](http://markdown-media.oss-cn-beijing.aliyuncs.com/2020/12/20/16084680404224.jpg)

## 2. 支持分布式采集

面对海量的数据，分布式采集必不可少的，本框架支持分布式，且可随时重启爬虫，任务不丢失

## 3. 支持爬虫集成

本功能可以将多个爬虫以插件的形式集成为一个爬虫，常用于采集周期一致，需求一致的，但需要采集多个数据源的项目

## 4. 支持海量数据去重

框架内置3种去重机制，通过简单的配置可对任务及数据自动去重，也可拿出来单独作为模块使用，支持批量去重。

1. 临时去重：处理一万条数据约0.26秒。 去重一亿条数据占用内存约1.43G，可指定去重的失效周期
2. 内存去重：处理一万条数据约0.5秒。 去重一亿条数据占用内存约285MB
3. 永久去重：处理一万条数据约3.5秒。去重一亿条数据占用内存约285MB

## 5. 数据采集完整性

feapder对于每一条URL数据的抓取采取了强状态的控制，做到采集任务中URL抓取100%不丢失，即使多次尝试失败的URL也会进入错误队列并记录失败原因日志。这一特性对于很多强依赖采集数据的业务场景非常重要，保证数据用的放心。

## 6. 数据自动入库

只需要根据数据库表自动生成item，然后给item属性赋值，直接yield 返回即可批量入库

## 7. 支持Debug模式

爬虫支持debug模式，debug模式下默认数据不入库、不修改任务状态。可针对某个任务进行调试，方便开发

## 8. 完善的报警机制

为了保证数据的全量性、准确性、时效性，本框架内置报警机制，有了这些报警，我们可以实时掌握爬虫状态

1. 实时计算爬虫抓取速度，估算剩余时间，在指定的抓取周期内预判是否会超时

    ![-w657](http://markdown-media.oss-cn-beijing.aliyuncs.com/2020/12/20/16084718683378.jpg)


2. 爬虫卡死报警

    ![-w501](http://markdown-media.oss-cn-beijing.aliyuncs.com/2020/12/20/16084718974597.jpg)

3. 爬虫任务失败数过多报警，可能是由于网站模板改动或封堵导致

    ![-w416](http://markdown-media.oss-cn-beijing.aliyuncs.com/2020/12/29/16092335882158.jpg)

## 9. 下载监控

框架对请求总数、成功数、失败数、解析异常数进行监控，将数据点打入到infuxdb，结合Grafana面板，可方便掌握抓取情况

![-w1299](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/02/09/16128568548280.jpg)


