# 运行问题

## 1. 二次运行时卡住，不继续抓取

![1779423237](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/03/11/1779423237.jpg)

**原因：**

因爬虫支持分布式和任务防丢，为防止任务抢占和任务丢失，巧妙的利用了redis有序集合来存储任务。

策略：有序集合有个分数，爬虫取任务时，只取小于当前时间戳分数的任务，同时将任务分数修改为当前时间戳+10分钟，当任务做完时，再主动将任务删除。

目的：将取到的任务分数修改成10分钟后，可防止其他爬虫节点取到同样的任务，同时当爬虫意外退出后，任务也不会丢失，10分钟后还可以取到。但也会导致有时爬虫启动时，明明有任务，却处于等待任务的情况。

应对等待情况：

1. 可将任务清空，重新抓取，可直接操作redis清空，或通过传参方式

        spider = test_spider.TestSpider(redis_key="feapder:test_spider", delete_keys="*z_requsets")
        spider.start()
        
    delete_keys为需要删除的key，类型: 元组/bool/string，支持正则; 常用于清空任务队列，否则重启时会断点续爬，如写成`delete_keys=True`也是可以的

1. 手动修改任务分数为小于当前时间搓的分数

    ![-w917](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/03/11/16154327722622.jpg)

1. 等10分钟就好了

2. 用debug模式开发
