# Item

有关Item的简介及创建，可参考[命令行工具](command/cmdline?id=_3-创建-item)

## 数据入库

数据自动入库，除了根据mysql表生产item外，也可以直接给item赋值，示例如下：

```
from feapder import Item

item = Item()
item.table_name = "spider_data" # 表名
item.title = title
yield item
```

等价于：
 
1. 生成item
    
    ```
    from feapder import Item
    
    class SpiderDataItem(Item):
        """
        This class was generated by feapder.
        command: feapder create -i spider_data.
        """
    
        def __init__(self, *args, **kwargs):
            # self.id = None
            self.title = None
    ```

1. 使用

    ```         
    item = SpiderDataItem()
    item.title = title
    yield item
    ```
    
## Item指纹

item指纹用于数据入库前的去重，默认为所有字段值排序后计算的md5，但当数据中有采集时间时，这种指纹计算方式明显不合理。因此我们可以通过如下方法指定参与去重的key

```
from feapder import Item


class SpiderDataItem(Item):
    
    __unique_key__ = ["title", "url"] # 指定去重的key为 title、url，最后的指纹为title与url值联合计算的md5

    def __init__(self, *args, **kwargs):
        # self.id = None
        self.title = None
        self.url = None
        self.crawl_time = None
```

或可通过如下方式指定`__unique_key__`

```
item = SpiderDataItem()
item.unique_key =  ["title", "url"] # 支持列表、元组、字符串
```

或者重写指纹函数

```
from feapder import Item


class SpiderDataItem(Item):
    ...

    @property
    def fingerprint(self):
        return "我是指纹"
```

## 入库前对item进行处理

pre_to_db函数为每个item入库前的回调函数，可通过此函数对数据进行处理

```python
from feapder import Item


class SpiderDataItem(Item):

    def __init__(self, *args, **kwargs):
        # self.id = None
        self.title = None

    def pre_to_db(self):
        """
        入库前的处理
        """
        self.title = self.title.strip()
```

## 更新数据

采集过程中，往往会有些数据漏采或解析出错，如果我们想更新已入库的数据，可将Item转为UpdateItem

    item = SpiderDataItem.to_UpdateItem()
    
或直接修改继承类

```
from feapder import Item, UpdateItem

class SpiderDataItem(UpdateItem):
    ...
```

关于UpdateItem使用，详见[UpdateItem](source_code/UpdateItem)
