# 报警及监控

## 钉钉报警

条件：需要有钉钉群，需要获取钉钉机器人的Webhook地址

获取方式参考官方文档：https://developers.dingtalk.com/document/app/custom-robot-access

安全设置选择自定义关键词，填入**feapder**

![-w547](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/03/27/16167753030324.jpg)

相关配置：

```python
# 钉钉报警
DINGDING_WARNING_URL = ""  # 钉钉机器人api
DINGDING_WARNING_PHONE = ""  # 报警人 支持列表，可指定多个
```

## 微信报警

条件：需要企业微信群，并获取企业微信机器人的Webhook地址

获取方式：https://weibanzhushou.com/blog/330

报警简介：

- 仅支持文本模式
- 当用户手机号码为空字符串或`WECHAT_WARNING_ALL`为`True`时将会`@全体成员`


相关设置：

```python
# 企业微信报警
WECHAT_WARNING_URL = ""  # 企业微信机器人api
WECHAT_WARNING_PHONE = ""  # 报警人 将会在群内@此人, 支持列表，可指定多人
WECHAT_WARNING_ALL = False  # 是否提示所有人， 默认为False
```


## 邮件报警

相关配置：

```
# 邮件报警
EMAIL_SENDER = ""  # 发件人
EMAIL_PASSWORD = ""  # 授权码
EMAIL_RECEIVER = "" # 收件人 支持列表，可指定多个
```

邮件报警目前支持163邮箱作为发送者，`EMAIL_SENDER`为邮箱账号，如`feapder@163.com`, `EMAIL_PASSWORD`为授权码，不是登录密码，获取授权码的流程如下：

1. 设置 -> POP3/SMTP/IMAP

    ![-w258](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/03/27/16167719328720.jpg)

2. 开启SMTP服务

    ![-w444](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/03/27/16167719490656.jpg)
    
    开启后，会弹出授权码，该授权码即为EMAIL_PASSWORD
    
3. 设置反垃圾规则为高级
    
    ![-w1112](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/03/27/16167719655644.jpg)

4. 将本邮箱账号添加到白名单中

## 报警间隔及报警级别

框架会对相同的报警进行过滤，防止刷屏，默认的报警时间间隔为1小时，可通过以下配置修改：

```python
WARNING_INTERVAL = 3600  # 相同报警的报警时间间隔，防止刷屏
WARNING_LEVEL = "DEBUG" # 报警级别， DEBUG / ERROR
```

DEBUG级别的报警包含一些运行信息，ERROR级别的报警都是有问题的报警，需要及时处理


## 可视化监控

支持对爬虫运行情况进行监控，除了数据监控和请求监控外，用户还可自定义监控内容，详情参考[自定义监控](source_code/监控打点?id=自定义监控)

![](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/09/14/16316112326191.jpg)

需 feapder>=1.6.6, 需配合feaplat爬虫管理平台