# 监控打点

需配合爬虫管理系统 **feaplat**

监控数据默认保留180天，滚动删除

## 爬虫中使用

> 需feapder>=1.6.6

feapder内置了监控打点，只需要部署到feaplat爬虫管理系统即可实现对请求和数据监控

![](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/09/14/16316112326191.jpg)

- 注意使用 `yield item` 的方式入库的数据，才能看到数据监控的指标，图表的title是表名，折线图展示了每个字段是否有值的情况以及数据总量（total count）

- document为下载情况

若想监控些其他的指标，参考自定义监控：


## 自定义监控

举例：编写`test_metrics.py`代码如下：

```python
from feapder.utils import metrics

# 初始化打点系统
metrics.init()

metrics.emit_counter("key", count=1, classify="test")

metrics.close()
```

部署到feaplat：

![](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/09/13/16315065474223.jpg)

查看监控：

![](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/09/13/16315067391666.jpg)

再来解释下
```
metrics.emit_counter("key", count=1, classify="test")
```
- key 对应上图中的折线
- count 对应上图中的点数
- classify 对应上图中的图表标题

若代码如下：
```python
from feapder.utils import metrics

# 初始化打点系统
metrics.init()

metrics.emit_counter("key", count=1, classify="test")
metrics.emit_counter("key2", count=1, classify="test")
metrics.emit_counter("key3", count=1, classify="test")

metrics.emit_counter("哈哈", count=1, classify="test2")

metrics.close()
```

应该生成两张图表，第一个图表3条折线，实际生成如下：

![](http://markdown-media.oss-cn-beijing.aliyuncs.com/2021/09/13/16315071385604.jpg)


如在feapder爬虫中使用，示例如下：

```python
import feapder
from feapder.utils import metrics


class TestSpider(feapder.AirSpider):
    def start_requests(self):
        yield feapder.Request("https://www.baidu.com")

    def parse(self, request, response):
        # 自定义监控
        metrics.emit_counter("success", count=1, classify="自定义的监控指标")


if __name__ == "__main__":
    TestSpider().start()
```

我们只需要导包，然后`metrics.emit_counter`即可，不需要关心 `metrics.init`和`metrics.close`， 若在scrapy或其他python脚本中使用，必须调用`metrics.init`和`metrics.close`
