/**Auto-generated by: https://github.com/angular-threejs/gltf
Command: npx angular-three-gltf&#64;1.1.11 apps/kitchen-sink/public/spaceship.gltf -o apps/kitchen-sink/src/app/soba/backdrop-cable/spaceship.ts --selector app-spaceship --name Spaceship --transform Size: apps/kitchen-sink/public/spaceship.gltf [69.57KB] > /Users/nartc/code/github/angular-threejs/angular-three/apps/kitchen-sink/public/spaceship-transformed.glb [59.12KB] (15%)
**/

import {
	ChangeDetectionStrategy,
	Component,
	CUSTOM_ELEMENTS_SCHEMA,
	effect,
	ElementRef,
	inject,
	input,
	viewChild,
} from '@angular/core';
import { extend, NgtObjectEvents, NgtThreeElements } from 'angular-three';
import { gltfResource } from 'angular-three-soba/loaders';
import type * as THREE from 'three';
import { Group, Mesh } from 'three';
import { GLTF } from 'three-stdlib';

export type SpaceshipGLTFResult = GLTF & {
	nodes: {
		Cube005: THREE.Mesh;
		Cube005_1: THREE.Mesh;
		Cube005_2: THREE.Mesh;
	};
	materials: {
		PaletteMaterial001: THREE.MeshStandardMaterial;
		PaletteMaterial003: THREE.MeshStandardMaterial;
		PaletteMaterial002: THREE.MeshStandardMaterial;
	};
};

@Component({
	selector: 'app-spaceship',
	template: `
		@if (gltf.value(); as gltf) {
			<ngt-group #model [parameters]="options()">
				<ngt-mesh
					castShadow
					receiveShadow
					[geometry]="gltf.nodes.Cube005.geometry"
					[material]="gltf.materials.PaletteMaterial001"
				/>
				<ngt-mesh
					castShadow
					receiveShadow
					[geometry]="gltf.nodes.Cube005_1.geometry"
					[material]="gltf.materials.PaletteMaterial003"
				/>
				<ngt-mesh
					castShadow
					receiveShadow
					[geometry]="gltf.nodes.Cube005_2.geometry"
					[material]="gltf.materials.PaletteMaterial002"
				/>

				<ng-content />
			</ngt-group>
		}
	`,
	hostDirectives: [
		{
			directive: NgtObjectEvents,
			outputs: [
				'click',
				'dblclick',
				'contextmenu',
				'pointerup',
				'pointerdown',
				'pointerover',
				'pointerout',
				'pointerenter',
				'pointerleave',
				'pointermove',
				'pointermissed',
				'pointercancel',
				'wheel',
			],
		},
	],
	schemas: [CUSTOM_ELEMENTS_SCHEMA],
	changeDetection: ChangeDetectionStrategy.OnPush,
})
export class Spaceship {
	protected readonly Math = Math;

	options = input({} as Partial<NgtThreeElements['ngt-group']>);

	modelRef = viewChild<ElementRef<Group>>('model');

	protected gltf = gltfResource<SpaceshipGLTFResult>(() => '/spaceship-transformed.glb', {
		useDraco: true,
	});

	constructor() {
		extend({ Group, Mesh });

		effect(() => {
			const gltf = this.gltf.value();
			if (!gltf) return;

			for (const materialKey in gltf.materials) {
				gltf.materials[materialKey as keyof SpaceshipGLTFResult['materials']].roughness = 0;
			}
		});

		const objectEvents = inject(NgtObjectEvents, { host: true });
		objectEvents.events.set(this.modelRef);
	}
}
