/**Auto-generated by: https://github.com/angular-threejs/gltf
Command: npx angular-three-gltf&#64;1.1.11 apps/kitchen-sink/src/app/soba/camera-scroll/model.glb -o apps/kitchen-sink/src/app/soba/camera-scroll/model.ts --selector app-model --name Model --transform Size: apps/kitchen-sink/src/app/soba/camera-scroll/model.glb [673.3KB] > /Users/nartc/code/github/angular-threejs/angular-three/apps/kitchen-sink/src/app/soba/camera-scroll/model-transformed.glb [235.96KB] (65%)
**/

import {
	ChangeDetectionStrategy,
	Component,
	CUSTOM_ELEMENTS_SCHEMA,
	DOCUMENT,
	effect,
	ElementRef,
	inject,
	signal,
	viewChild,
} from '@angular/core';
import { beforeRender, NgtArgs, NgtThreeEvent } from 'angular-three';
import { NgtsPerspectiveCamera } from 'angular-three-soba/cameras';
import { gltfResource } from 'angular-three-soba/loaders';
import { animations, NgtsAnimationApi, NgtsAnimationClips } from 'angular-three-soba/misc';
import type * as THREE from 'three';
import { BufferGeometry, Color, Group, MathUtils, Mesh, MeshStandardMaterial } from 'three';
import { GLTF } from 'three-stdlib';
import { SCROLL } from './camera-scroll';

import modelUrl from './model-transformed.glb';

type ActionName = 'CameraAction.005';
type ModelAnimationClips = NgtsAnimationClips<ActionName>;
export type ModelAnimationApi = NgtsAnimationApi<ModelAnimationClips> | null;
export type ModelGLTFResult = GLTF & {
	animations: ModelAnimationClips[];
	nodes: {
		Headphones: THREE.Mesh;
		Notebook: THREE.Mesh;
		Rocket003: THREE.Mesh;
		Roundcube001: THREE.Mesh;
		Table: THREE.Mesh;
		VR_Headset: THREE.Mesh;
		Zeppelin: THREE.Mesh;
	};
	materials: {
		M_Headphone: THREE.MeshStandardMaterial;
		M_Notebook: THREE.MeshStandardMaterial;
		M_Rocket: THREE.MeshStandardMaterial;
		M_Roundcube: THREE.MeshStandardMaterial;
		M_Table: THREE.MeshStandardMaterial;
		M_Headset: THREE.MeshStandardMaterial;
		M_Zeppelin: THREE.MeshStandardMaterial;
	};
};

@Component({
	selector: 'app-model',
	template: `
		@if (gltf.value(); as gltf) {
			<ngt-group #model [dispose]="null">
				<ngt-group
					name="Scene"
					[position]="[0.061, 4.042, 0.346]"
					[scale]="0.25"
					(pointerover)="onPointerOver($event)"
					(pointerout)="onPointerOut($event)"
				>
					<ngt-mesh
						name="Headphones"
						[geometry]="gltf.nodes.Headphones.geometry"
						[material]="gltf.materials.M_Headphone"
						castShadow
						receiveShadow
					/>
					<ngt-mesh
						name="Notebook"
						[geometry]="gltf.nodes.Notebook.geometry"
						[material]="gltf.materials.M_Notebook"
						castShadow
						receiveShadow
					/>
					<ngt-mesh
						name="Rocket003"
						[geometry]="gltf.nodes.Rocket003.geometry"
						[material]="gltf.materials.M_Rocket"
						castShadow
						receiveShadow
					/>
					<ngt-mesh
						name="Roundcube001"
						[geometry]="gltf.nodes.Roundcube001.geometry"
						[material]="gltf.materials.M_Roundcube"
						castShadow
						receiveShadow
					/>
					<ngt-mesh
						name="Table"
						[geometry]="gltf.nodes.Table.geometry"
						[material]="gltf.materials.M_Table"
						castShadow
						receiveShadow
					/>
					<ngt-mesh
						name="VR_Headset"
						[geometry]="gltf.nodes.VR_Headset.geometry"
						[material]="gltf.materials.M_Headset"
						castShadow
						receiveShadow
					/>
					<ngt-mesh
						name="Zeppelin"
						[geometry]="gltf.nodes.Zeppelin.geometry"
						[material]="gltf.materials.M_Zeppelin"
						castShadow
						receiveShadow
					/>
				</ngt-group>

				<ngt-group name="Camera" [position]="[-1.78, 2.04, 23.58]" [rotation]="[1.62, 0.01, 0.11]">
					<ngts-perspective-camera
						[options]="{ makeDefault: true, far: 100, near: 0.1, fov: 28, rotation: [-Math.PI / 2, 0, 0] }"
					>
						<ng-template>
							<ngt-directional-light [position]="[10, 20, 15]" castShadow [intensity]="Math.PI * 2">
								<ngt-value [rawValue]="-0.0001" attach="shadow.bias" />
								<ngt-vector2 *args="[1024, 1024]" attach="shadow.mapSize" />
								<ngt-value [rawValue]="8" attach="shadow.camera.right" />
								<ngt-value [rawValue]="8" attach="shadow.camera.top" />
								<ngt-value [rawValue]="-8" attach="shadow.camera.left" />
								<ngt-value [rawValue]="-8" attach="shadow.camera.bottom" />
							</ngt-directional-light>
						</ng-template>
					</ngts-perspective-camera>
				</ngt-group>

				<ng-content />
			</ngt-group>
		}
	`,
	imports: [NgtsPerspectiveCamera, NgtArgs],
	schemas: [CUSTOM_ELEMENTS_SCHEMA],
	changeDetection: ChangeDetectionStrategy.OnPush,
})
export class Model {
	protected readonly Math = Math;

	modelRef = viewChild<ElementRef<Group>>('model');

	protected gltf = gltfResource<ModelGLTFResult>(() => modelUrl, {
		useDraco: true,
	});

	private document = inject(DOCUMENT);
	private scroll = inject(SCROLL);
	private hovered = signal<string | null>(null);

	private color = new Color();

	constructor() {
		effect(() => {
			const scene = this.gltf.scene();
			if (!scene) return;

			scene.traverse((child) => {
				if (child instanceof Mesh) {
					child.material['envMapIntensity'] = 0.2;
				}
			});
		});

		const animationsApi = animations(this.gltf.value, this.modelRef);

		effect(() => {
			if (!animationsApi.isReady) return;
			animationsApi.actions['CameraAction.005'].play().paused = true;
		});

		effect(() => {
			const model = this.modelRef()?.nativeElement;
			if (!model) return;

			const hovered = this.hovered();
			if (hovered) {
				const obj = model.getObjectByName(hovered) as Mesh<BufferGeometry, MeshStandardMaterial>;
				obj?.material.color.set('white');
			}
			this.document.body.style.cursor = hovered ? 'pointer' : 'auto';
		});

		beforeRender(({ clock }) => {
			if (!animationsApi.isReady) return;

			const model = this.modelRef()?.nativeElement;
			if (!model) return;

			animationsApi.actions['CameraAction.005'].time = MathUtils.lerp(
				animationsApi.actions['CameraAction.005'].time,
				animationsApi.actions['CameraAction.005'].getClip().duration * this.scroll.value,
				0.05,
			);
			model.children[0].children.forEach((child, index) => {
				const mesh = child as Mesh<BufferGeometry, MeshStandardMaterial>;
				mesh.material.color.lerp(
					this.color.set(this.hovered() === child.name ? 'tomato' : '#202020'),
					this.hovered() ? 0.1 : 0.05,
				);
				const et = clock.elapsedTime;
				child.position.y = Math.sin((et + index * 2000) / 2);
				child.rotation.x = Math.sin((et + index * 2000) / 3) / 10;
				child.rotation.y = Math.cos((et + index * 2000) / 2) / 10;
				child.rotation.z = Math.sin((et + index * 2000) / 3) / 10;
			});
		});
	}

	onPointerOver(event: NgtThreeEvent<PointerEvent>) {
		event.stopPropagation();
		this.hovered.set(event.object.name);
	}

	onPointerOut(event: NgtThreeEvent<PointerEvent>) {
		event.stopPropagation();
		this.hovered.set(null);
	}
}
