import { ChangeDetectionStrategy, Component, CUSTOM_ELEMENTS_SCHEMA, input } from '@angular/core';
import { Meta } from '@storybook/angular';
import { NgtsPivotControls, NgtsPivotControlsOptions } from 'angular-three-soba/gizmos';
import { storyDecorators, storyObject } from '../setup-canvas';

@Component({
	template: `
		<ngts-pivot-controls [options]="options()">
			<ngt-mesh>
				<ngt-box-geometry />
				<ngt-mesh-standard-material wireframe />
			</ngt-mesh>
		</ngts-pivot-controls>
		<ngt-directional-light [position]="[10, 10, 5]" />
	`,
	schemas: [CUSTOM_ELEMENTS_SCHEMA],
	changeDetection: ChangeDetectionStrategy.OnPush,
	imports: [NgtsPivotControls],
})
class DefaultPivotControlsStory {
	options = input({} as NgtsPivotControlsOptions);
}

export default {
	title: 'Gizmos/PivotControls',
	decorators: storyDecorators(),
} as Meta;

export const Default = storyObject(DefaultPivotControlsStory, {
	camera: { position: [0, 0, 2.5] },
	argsOptions: {
		options: {
			anchor: [-1, -1, -1],
			scale: 0.75,
			depthTest: false,
			annotations: true,
		},
	},
});
