uniform sampler2D uPositions;
varying vec3 vPosition;

void main() {
    vec3 pos = texture2D(uPositions, position.xy).xyz;
    vPosition = pos;

    vec4 modelPosition = modelMatrix * vec4(pos, 1.0);
    vec4 viewPosition = viewMatrix * modelPosition;
    vec4 projectedPosition = projectionMatrix * viewPosition;

    gl_Position = projectedPosition;

    gl_PointSize = 3.0;
    // Size attenuation;
    gl_PointSize *= step(1.0 - (1.0 / 64.0), position.x) + 0.5;
}
