\name{rcloud.encrypt}
\alias{rcloud.encrypt}
\alias{rcloud.decrypt}
\title{
  Encrypt/decrypt objects
}
\description{
  \code{rcloud.encrypt} encrypts an R object

  \code{rcloud.decrypt} decrypt a previously encrypted R object
}
\usage{
rcloud.encrypt(x, key, group, cipher = "AES-256")
rcloud.decrypt(x, key = get.user.key(), cipher)
}
\arguments{
  \item{x}{object to encrypt/decrypt}
  \item{key}{string or raw vector, key to use for encryption/decryption}
  \item{group}{optional string or logical, see Details}
  \item{cipher}{string, cipher to use. If not specified for decryption
    it is either determined from the encrypted content metadata or
    it defaults to \code{"AES-256"}}
}
\details{
  The functions enable users to encrypt and decrypt sensitive
  content. They are implemented using \code{\link{PKI.encrypt}} and
  \code{\link{PKI.decrypt}}.
  
  \code{rcloud.encrypt} takes an R object or raw vector. If it is
  an object, it is serialized using \code{\link{serialize}} before
  encryption to obtain a raw vector. Then the raw vector is encrypted.

  \code{rcloud.decrypt} takes an object previously generated by
  \code{rcloud.encrypt} and decrypts it.

  For available ciphers see \code{\link{PKI.encrypt}}, but the most
  commonly used are \code{"AES-128"} and \code{"AES-256"}. Note that the
  key must be of sufficient length for the cipher, i.e., AES-128
  requires at least 16 bytes and AES-256 32 bytes. If simple passwords
  are considered as keys then \code{\link{PKI.digest}} can be useful, in
  particular \code{PKI.digest(text, "SHA256")} produces 256-bit hash
  that can be used with AES-256.

  The object created by \code{rcloud.encrypt} also contains the SHA1
  checksum of the raw vector before encryption as well as the cipher, so
  that \code{rcloud.decrypt} can check the validity of the
  decryption. All metadata is stored in the \code{"metadata"} attribute
  which is compatible with storing binary assets (where supported).

  RCloud supports group-based encryption and manages keys for groups
  and users. If neither \code{key} nor \code{group} is specified then
  user's private RCloud key will be used for encryption automatically.

  If \code{group} is set then group-based encryption is used (in the
  RCloud user interface it is referred to as protection groups) which
  allows multiple users to access the encrypted content. The groups can
  be managed in the UI by clicking on the "Notebook info" icon next to
  the name of a notebook in the notebook tree and then clicking on the
  link below "Group:". The "Group" tab allows to create and manage
  protection groups.

  The \code{group} argument to \code{rcloud.encrypt} can be set to
  either a group name (visible in the UI) or group id in which case
  the encryption will be performed using the group key. Group members
  can then decrypt the content.

  If group is set to \code{TRUE} then RCloud attempts to get a valid
  group in the following order: 1) from the current notebook - if that
  notebook is group-encrypted then the group is used, 2) a group that
  the user belongs to. If the user belongs to no groups, an error is
  raised. If the user belongs to multiple groups, the first one
  returned by \code{rcloud.get.user.cryptgroups()} is used with a
  warning.

  A special value of \code{group="private"} is used for compatibility
  with the UI. In that case a salted user-key encryption is performed
  which is equivalent to picking "private" in the RCloud UI. The
  difference to regular user key encryption is that salt is combined
  with the user key into a new key and thus the content cannot be
  decrypted without the salt.

  If \code{key} is set in \code{rcloud.encrypt} then \code{group} is
  ignored.

  Technical information: the metadata attached to the encrypted object
  is a list in the \code{"metadata"} attribute with following entries:
  \itemize{
    \item{cipher}{mandatory, string, name of the cipher}
    \item{sha1}{mandatory, string, SHA1 hash of the contents for
      integrity checking (lowercase hex notation)}
    \item{key.type}{optional, string, type of the key used. Currently
      recognized entries are: \code{"group-hash"} for group-based
      encryption and \code{"user-key"} for salted user-key
      encryption}
    \item{salt}{string, required for any salted entryption, currently
      for both \code{"group-hash"} and \code{"user-key"}.}
    \item{group}{string, group id, required for group-based
      encryption}
    \item{encoding}{optional, string, specification of the encoding of
      the payload. Currently \code{"rds"} is used to denote R
      serialized content (default for non-raw encryption)}
  }  
}
\value{
  \code{rcloud.encrypt}: a raw vector containing the encrypted
  content and with \code{"metadata"} attribute containing at least
  elements \code{"sha1"} and \code{"cipher"}.
  If the object was serialized, \code{encoding="rds"}, see Details for
  additional entries.

  \code{rcloud.decrypt}: the decrypted object
}
%\references{
%}
\author{
  Simon Urbanek
}
%\note{
%}
\seealso{
  \code{\link{PKI.encrypt}}, \code{\link{PKI.decrypt}} and \code{\link{PKI.digest}}
}
%\examples{
%}
\keyword{manip}
