# I2S Example

(See the README.md file in the upper level 'examples' directory for more information about examples.)

In this example, we generate a 100Hz triangle and sine wave and send it out from left and right channels at a sample rate of 36kHz through the I2S bus.

## How to Use Example

### Hardware Required

* A development board with ESP8266 SoC (e.g., ESP8266-DevKitC, etc.)
* A USB cable for power supply and programming

### Configure the Project

```
make menuconfig
```

* Set serial port under Serial Flasher Options.

### Build and Flash

Build the project and flash it to the board, then run monitor tool to view serial output:

```
make -j4 flash monitor
```

(To exit the serial monitor, type ``Ctrl-]``.)

See the Getting Started Guide for full steps to configure and use ESP-IDF to build projects.

## Example Output

Running this example, you will see the Bits per Sample changes every 5 seconds after you have run this example. You can use `i2s_set_clk` to change the Bits per Sample and the Sample Rate. The output log can be seen below:

```
Test bits=24 free mem=78188, written data=2880
I (5655) i2s: DMA Malloc info, datalen=blocksize=480, dma_buf_count=6

Test bits=16 free mem=78188, written data=1440
I (10735) i2s: DMA Malloc info, datalen=blocksize=240, dma_buf_count=6

Test bits=24 free mem=78188, written data=2880
I (15835) i2s: DMA Malloc info, datalen=blocksize=480, dma_buf_count=6

Test bits=16 free mem=78188, written data=1440
I (20915) i2s: DMA Malloc info, datalen=blocksize=240, dma_buf_count=6
```

If you have a logic analyzer, you can use a logic analyzer to grab online data. The following table describes the pins we use by default (Note that you can also use other pins for the same purpose).

| pin name| function | gpio_num |
|:---:|:---:|:---:|
| MCLK|main clock | GPIO_NUM_4 |
| WS  |word select| GPIO_NUM_2 |
| SCK |continuous serial clock| GPIO_NUM_15 |
| SD  |serial data| GPIO_NUM_3 |

## Troubleshooting

* Program upload failure

    * Hardware connection is not correct: run `make monitor`, and reboot your board to see if there are any output logs.
    * The baud rate for downloading is too high: lower your baud rate in the `menuconfig` menu, and try again.

For any technical queries, please open an [issue](https://github.com/espressif/ESP8266_RTOS_SDK/issues) on GitHub. We will get back to you soon.