## Terminology

### Generated / Original

The Generated and Original terms come from the Source Maps [spec], which is still in a google doc :)
The terms are counter intuitive, so if you keep flipping them in your head that's completely understandable.

| Term | Definition |
|--|--|
| Generated | The code which is generated by the compiler |
| Original | The source code which has not been passed through the compiler |

Another useful rule to remember is that files default to generated.
The source in the page is generated!

Here are a couple of examples:

1. If an app does not use sourcemaps, every file is a generated file.
2. If an app uses webpack, the bundle was generated by webpack. The original files, that are in the Map reference the original files on disk.
3. If you pretty print a source, the minified file is generated because it's what the page has.

[spec]: https://docs.google.com/document/d/1U1RGAehQwRypUTovF1KRlpiOFze0b-_2gc6fAH0KY0k/edit#heading=h.ue4jskhddao6
