## October 24th

This week we had 25 contributors and 30+ PRs.

* [@ahuth] helped us upgrade to flow 53
* [@jselmani] helped us convert SVGs to background images
* [@tohmjudson] blackboxed sources are now identified in the source tree
* [@jainsneha23] Aligned the first tab with wide gutters
* [@bomsy] and [@James300] got jump to line to support scrolling to columns.

[@jselmani], [@joel-bentley], [@pradeepgangwar], [@leibale], [@jainsneha23], [@bomsy], [@nyrosmith], [@stefanjudis], [@rameramwe], [@amelzer], [@jasonLaster], [@lukaszsobek], [@tohmjudson], [@michaelgv], [@ahuth], [@darkwing], [@juliandescottes], [@yurydelendik], [@codehag], [@wldcordeiro], [@James300]

### Performance

Performance is one of our primary goals post launch. We've identified two bottlenecks, naive computations.
[@jselmani] is helping us migrate to background SVGs. [@jasonLaster] is looking at deferring expensive work like calculating
how variables are mapped when there is a bundle.

+ [Converted Source Tree SVG's (including Blackbox) to images using CSS styles (#4350)][4477] [@jselmani]
+ [Converted blackBox/prettyPrint SVG's to CSS][4386] [@jselmani]

### Frameworks

We landed call stack logs from the Next.js, nuxt, Aframe, and Marko projects. Also a special shout out to Next.js, which we're now using to host our bots!

We also landed support for finding the classes and imports in a source file as well. We're using this data to identify files that have a React component!

+ [Add Next.js to framework frames][4476] [@joel-bentley]
+ [Add nuxt framework to stacktraces][4460] [@stefanjudis]
+ [support framework frames for Aframe #2980][4458] [@rameramwe]
+ [Support framework frames for Marko][4430] [@jainsneha23]
+ [Add Classes and Imports to the AST][4329] [@James300]

| Frameworks |
|----|
| ![4476-0] |
| ![4460-0] |
| ![4458-0] |
| ![4430-0] |

### UI Polish

We're continuing to get great UI polish and the product is looking better and better.

+ [Fix footer background length in dark theme][4474] [@pradeepgangwar]
+ [Expand the right sidebar on pausing at breakpoint][4473] [@leibale]
+ [Only show one contextmenu at a time][4470] [@jainsneha23]
+ [Blackboxed sources distinguished by icon in source tree ][4441] [@tohmjudson]
+ [Keeps focus on input field][4423] [@lukaszsobek]
+ [Disallow gutter context menus for empty lines][4424] [@darkwing]
+ [Align the first tab with wide gutters][4427] [@jainsneha23]

| Footer |
|----|
| ![4474-0] |


### Bug

Perhaps the single best thing about launching a product is the fantastic bugs that are filed.
This week, [@bomsy] helped us solve two edge cases w/ highlighting the first line of a file when the debugger pausing and
previewing computed properties, e.g. the `a` variable in this example `{[a]: 3}`.


+ [Support previewing computed object keys][4468] [@bomsy]
+ [Support highlighting the first line of file][4445] [@bomsy]
+ [Support quoted strings in watch expressions (e.g. "3")][4425] [@jasonLaster]

| Preview computed fields |
|----|
| ![4427-0] |

| Evaluate "3" |
|----|
| ![4425-0] |

### Highlight errors in editor [PR][4467]

[@nyrosmith] landed an amazing UI enhancement for distinguishing between pausing due to a breakpoint and pausing on exceptions.
When the debugger pauses on an exception the line is now red.

| Exceptions |
|----|
| ![4467-0] |

### Features

[@wldcordeiro] moved the Source Search UI into a modal. [PR][4398] This is now consistent with other editors, where cmd+p launches a search modal

| Modal |
|----|
| ![4398-0] |


[@James300] and [@bomsy] upgraded our jump to location action to support jumping to a line and column. [PR][4143]
While scrolling to the correct column location, might seem like a minor UI detail, this feature was a month
in the making and was one of the scarier changes we've landed in awhile.

A good way to think about the magnitude of this change is that everything touches location data in some way,
breakpoints, call stacks, source maps, search... Getting it right required addressing all of the use cases and
fixing almost all of the integration tests. Great work guys!

| Jump to Column |
|----|
| ![4143-0] |


### Testing

+ [add layout test][4415] [@jasonLaster]
+ [Synchronize smoke test for browser content toolbox from m-c][4408] [@juliandescottes]


### Code Health

[@ahuth] helped us upgrade to flow 53 ([PR][4433]), which was a huge under taking.
Types have been critical for us maintaining code quality while working with so many new comers.


+ [Fix warnings for var usage][4456] [@amelzer]
+ [Add Jest Cases][4449] [@jasonLaster]
+ [Undo string change to editor.addConditionalBreakpoint][4448] [@lukaszsobek]
+ [Revert "Use a monospace font for editor line numbers"][4416] [@darkwing]
+ [Adds flow types to the Scope declaration.][4405] [@yurydelendik]
+ [Cleanup babel][4404] [@jasonLaster]

### Docs

+ [Fix link issues in docs ][4462] [@pradeepgangwar]
+ [The second 10/13 release][4447] [@jasonLaster]
+ [update 10-17-2017][4400] [@codehag]


### Infrastructure

+ [bump launchpad][4452] [@jasonLaster]
+ [bump yarn][4442] [@jasonLaster]
+ [Change port 9000 default to 8116 default][4434] [@michaelgv]
+ [Update mochii to the latest version 🚀][4414] [@jasonLaster]


[4143-0]: https://user-images.githubusercontent.com/3307404/30053921-a9d9b5e4-922a-11e7-9533-e0e4e9e78758.png
[4467-0]: https://user-images.githubusercontent.com/2511026/31862855-5ad67b4a-b745-11e7-8b63-32d91694e80d.gif
[4477-0]: https://user-images.githubusercontent.com/25250594/31919381-05a0d198-b830-11e7-9166-900c414882fa.PNG
[4476-0]: https://user-images.githubusercontent.com/10087880/31913734-579249a6-b848-11e7-9fcc-6f6592560d2d.png
[4474-0]: https://user-images.githubusercontent.com/21259802/31912450-93ebdd72-b861-11e7-8bff-4404caf2ddbe.png
[4460-0]: https://user-images.githubusercontent.com/962099/31852673-202297dc-b67c-11e7-9b0e-4f59d466d1c8.png
[4458-0]: https://user-images.githubusercontent.com/17526866/31852285-64cc8b88-b675-11e7-8ae1-2b01f74174f2.png
[4430-0]: https://user-images.githubusercontent.com/8366397/31739666-43a9a4fa-b46c-11e7-878e-008b9259cfa6.png
[4427-0]: https://user-images.githubusercontent.com/8366397/31733681-07bf433a-b45a-11e7-91b1-57c546563282.png
[4425-0]: https://user-images.githubusercontent.com/254562/31724979-37ce2b86-b3f1-11e7-8a81-412bd5506d9d.png
[4398-0]: https://user-images.githubusercontent.com/580982/31694689-e37a4c4c-b362-11e7-8dff-15b708d7199f.png
[4386-0]: https://user-images.githubusercontent.com/25250594/31640486-c7f09a0a-b2ac-11e7-95e6-f9aa50a1df3c.PNG
[4477]: https://github.com/devtools-html/debugger.html/pull/4477
[4476]: https://github.com/devtools-html/debugger.html/pull/4476
[4474]: https://github.com/devtools-html/debugger.html/pull/4474
[4473]: https://github.com/devtools-html/debugger.html/pull/4473
[4470]: https://github.com/devtools-html/debugger.html/pull/4470
[4468]: https://github.com/devtools-html/debugger.html/pull/4468
[4467]: https://github.com/devtools-html/debugger.html/pull/4467
[4462]: https://github.com/devtools-html/debugger.html/pull/4462
[4460]: https://github.com/devtools-html/debugger.html/pull/4460
[4458]: https://github.com/devtools-html/debugger.html/pull/4458
[4456]: https://github.com/devtools-html/debugger.html/pull/4456
[4452]: https://github.com/devtools-html/debugger.html/pull/4452
[4449]: https://github.com/devtools-html/debugger.html/pull/4449
[4448]: https://github.com/devtools-html/debugger.html/pull/4448
[4447]: https://github.com/devtools-html/debugger.html/pull/4447
[4445]: https://github.com/devtools-html/debugger.html/pull/4445
[4442]: https://github.com/devtools-html/debugger.html/pull/4442
[4441]: https://github.com/devtools-html/debugger.html/pull/4441
[4434]: https://github.com/devtools-html/debugger.html/pull/4434
[4433]: https://github.com/devtools-html/debugger.html/pull/4433
[4430]: https://github.com/devtools-html/debugger.html/pull/4430
[4427]: https://github.com/devtools-html/debugger.html/pull/4427
[4425]: https://github.com/devtools-html/debugger.html/pull/4425
[4424]: https://github.com/devtools-html/debugger.html/pull/4424
[4423]: https://github.com/devtools-html/debugger.html/pull/4423
[4416]: https://github.com/devtools-html/debugger.html/pull/4416
[4415]: https://github.com/devtools-html/debugger.html/pull/4415
[4414]: https://github.com/devtools-html/debugger.html/pull/4414
[4408]: https://github.com/devtools-html/debugger.html/pull/4408
[4405]: https://github.com/devtools-html/debugger.html/pull/4405
[4404]: https://github.com/devtools-html/debugger.html/pull/4404
[4400]: https://github.com/devtools-html/debugger.html/pull/4400
[4398]: https://github.com/devtools-html/debugger.html/pull/4398
[4386]: https://github.com/devtools-html/debugger.html/pull/4386
[4329]: https://github.com/devtools-html/debugger.html/pull/4329
[4143]: https://github.com/devtools-html/debugger.html/pull/4143
[@jselmani]: https://github.com/jselmani
[@joel-bentley]: https://github.com/joel-bentley
[@pradeepgangwar]: https://github.com/pradeepgangwar
[@leibale]: https://github.com/leibale
[@jainsneha23]: https://github.com/jainsneha23
[@bomsy]: https://github.com/bomsy
[@nyrosmith]: https://github.com/nyrosmith
[@stefanjudis]: https://github.com/stefanjudis
[@rameramwe]: https://github.com/rameramwe
[@amelzer]: https://github.com/amelzer
[@jasonLaster]: https://github.com/jasonLaster
[@lukaszsobek]: https://github.com/lukaszsobek
[@tohmjudson]: https://github.com/tohmjudson
[@michaelgv]: https://github.com/michaelgv
[@ahuth]: https://github.com/ahuth
[@darkwing]: https://github.com/darkwing
[@juliandescottes]: https://github.com/juliandescottes
[@yurydelendik]: https://github.com/yurydelendik
[@codehag]: https://github.com/codehag
[@wldcordeiro]: https://github.com/wldcordeiro
[@James300]: https://github.com/James300
