## November 7

28 commits

[@stratigos], [@amelzer], [@lukaszsobek], [@jasonLaster], [@princiya], [@tohmjudson], [@nyrosmith],
[@codehag], [@James300], [@sharathnarayanph]


### Performance

This week we started optimistically clearing the pause state when we step, which eagerly clears the UI and prepares it for another step. We also defer fetching and mapping scopes when the debugger pauses, which makes the UI a bit snappier.

* [Refactor waitForPaused helper to support faster stepping][pr-7] - [@jasonLaster]
* [Refactor command action to use PROMISE][pr-8] - [@jasonLaster]
* [Optimistically clear pause state][pr-26] - [@jasonLaster]
* [do not expand all scope objects][pr-17] - [@codehag]
* currently working on new damp tests [@codehag]
* [Refactor map scopes to fetch scopes][pr-5] - [@jasonLaster]


### User visible

Some of our contributors did some great tweaks to the visuals of the debugger. We now have better JSX syntax highlighting thanks to @nyrosmith

* [Improve JSX syntax highlighting][pr-27] - [@nyrosmith]
* [Style line numbers in search results][pr-6] - [@princiya]
* [togglePaneCollapse update][pr-12] - [@tohmjudson]

| JSX |
|--|
| ![jsx] |

| Line numbers |
|--|
| ![line-numbers] |

| toggle panel collapse |
|--|
| ![toggle-panel] |

[jsx]:https://user-images.githubusercontent.com/2511026/32187057-253f40ec-bda4-11e7-89bb-8c9dfb890f47.png
[line-numbers]:
https://user-images.githubusercontent.com/8022693/32213030-8a8717e0-be3f-11e7-9c03-09052dc47f54.png
[toggle-panel]:
https://user-images.githubusercontent.com/12687394/32090996-0f412468-baa7-11e7-90b4-e8f2919b94e5.gif

### Infrastructure

We devoted some of our time to improving our airtable config. Airtable will allow us to better manage our open source work / github progress, as well as give us faster access to what has happened over the past week.

* [show better error messages in jest][pr-4] - [@jasonLaster]
* [Fix filename for assert.js tests][pr-0] - [@stratigos]
* [Add airtable CRM config][pr-18] - [@jasonLaster]
* [bump map-bindings][pr-9] - [@jasonLaster]
* [Release 10/25][pr-10] - [@jasonLaster]
* [Add timing data][pr-11] - [@jasonLaster]
* [10-31][pr-13] - [@jasonLaster]

### Testing

* [Re-enable tests][pr-24] - [@jasonLaster]
* [Add Unit tests for Editor][pr-20] - [@James300]
* [Add tests for src/utils/log.js][pr-3] - [@stratigos]
* [Don't show Mochi output for passing tests][pr-16] - [@jasonLaster]
* [Preview mochitest][pr-28] - [@samuel-peers]

### Code health

This week we did quite a bit of redux refactoring and split up reducers that were taking on too much
responsibility.

* [Use new redux action in editor][pr-1] - [@amelzer]
* [Validate scripts][pr-15] - [@jasonLaster]
* [Moves redux middleware to actions/utils][pr-19] - [@lukaszsobek]
* [Displays result count only after initiating search][pr-2] - [@lukaszsobek]
* [Disallow uncaught exceptions][pr-25] - [@jasonLaster]

### Bugs

The biggest fix we had this week was done by @nyrosmith, who noticed that our breakpoints were not
responding when the page was reloaded. This turned out to be an issue with how breakpoints were
being synced, and could have been avoided if we were stricter with our types!

* [Fix conditional breakpoints][pr-14] - [@nyrosmith]
* [Mochi intermittent script][pr-23] - [@jasonLaster]


[pr-0]:https://github.com/devtools-html/debugger.html/pull/4548
[pr-1]:https://github.com/devtools-html/debugger.html/pull/4552
[pr-2]:https://github.com/devtools-html/debugger.html/pull/4525
[pr-3]:https://github.com/devtools-html/debugger.html/pull/4549
[pr-4]:https://github.com/devtools-html/debugger.html/pull/4558
[pr-5]:https://github.com/devtools-html/debugger.html/pull/4550
[pr-6]:https://github.com/devtools-html/debugger.html/pull/4541
[pr-7]:https://github.com/devtools-html/debugger.html/pull/4553
[pr-8]:https://github.com/devtools-html/debugger.html/pull/4554
[pr-9]:https://github.com/devtools-html/debugger.html/pull/4566
[pr-10]:https://github.com/devtools-html/debugger.html/pull/4493
[pr-11]:https://github.com/devtools-html/debugger.html/pull/4540
[pr-12]:https://github.com/devtools-html/debugger.html/pull/4508
[pr-13]:https://github.com/devtools-html/debugger.html/pull/4543
[pr-14]:https://github.com/devtools-html/debugger.html/pull/4465
[pr-15]:https://github.com/devtools-html/debugger.html/pull/4565
[pr-16]:https://github.com/devtools-html/debugger.html/pull/4580
[pr-17]:https://github.com/devtools-html/debugger.html/pull/4498
[pr-18]:https://github.com/devtools-html/debugger.html/pull/4582
[pr-19]:https://github.com/devtools-html/debugger.html/pull/4567
[pr-20]:https://github.com/devtools-html/debugger.html/pull/4522
[pr-21]:https://github.com/devtools-html/debugger.html/pull/4589
[pr-22]:https://github.com/devtools-html/debugger.html/pull/4595
[pr-23]:https://github.com/devtools-html/debugger.html/pull/4586
[pr-24]:https://github.com/devtools-html/debugger.html/pull/4564
[pr-25]:https://github.com/devtools-html/debugger.html/pull/4584
[pr-26]:https://github.com/devtools-html/debugger.html/pull/4557
[pr-27]:https://github.com/devtools-html/debugger.html/pull/4539
[pr-28]:https://github.com/devtools-html/debugger.html/pull/4603
[@stratigos]:http://github.com/stratigos
[@amelzer]:http://github.com/amelzer
[@lukaszsobek]:http://github.com/lukaszsobek
[@jasonLaster]:http://github.com/jasonLaster
[@princiya]:http://github.com/princiya
[@tohmjudson]:http://github.com/tohmjudson
[@nyrosmith]:http://github.com/nyrosmith
[@codehag]:http://github.com/codehag
[@James300]:http://github.com/James300
[@sharathnarayanph]:http://github.com/sharathnarayanph
[@samuel-peers]:http://github.com/samuel-peers
