### August 29

This week marks the completion of our JSX conversion. It was a community effort and we couldn’t have done it without everyone’s help. We also moved forward with async stepping and AST breakpoints. Improvements were made to our testing infrastructure. Finally, we have made some improvements to the preview startup display. Thanks to everyone who helped this week! [@jasonLaster], [@darkwing], [@rohanprasad], [@codehag], [@hughugsy], [@bomsy],[@wldcordeiro], [@juliandescottes], [@sharathnarayanph]

#### Features

We managed some progress on the Async stepping feature, and on AST breakpoints, as well as some great new contributor features such as improving our UI buttons with a hover state (thanks @rohanprasad!) and labels to help users find search functions (Thanks @hughugsy!)

* [Add hover color to new-tab button][pr-2] - [@rohanprasad] :tada: new contributor!
* [Setting a condition should enable a breakpoint][pr-4] - [@sagorika1996]
* [Stop showing previews loading state][pr-5] - [@jasonLaster]
* [Stop showing when there's a text selection][pr-5] - [@jasonLaster]
* [Labels are aligned and keys are bold now][pr-15] - [@hughugsy] :tada: new contributor!
* [Switch to source loaded state][pr-28] - [@sharathnarayanph]
* [fix breakpoints offset issue, Remove breakpoint on click][pr-34] - [@bomsy]

![](http://g.recordit.co/sxf6l3fIDV.gif)

#### Async Stepping

Async Stepping will let the debugger step over, and into async functions. It takes advantage of our babel client integration to figure out when we're paused at async functions and where we want to step to next. Congrats to Jaideep who has made tons of progress landing the underlying utils and command integrations. He's currently ironing out this rough edges with stepping, but it's getting close.

* [Async Stepping][pr-33] - [@jbhoosreddy]
* [Async stepping test][pr-31] - [@jasonLaster]

#### AST Breakpoints

Yulia started working on AST Breakpoints, which will be a magical auto-correcting breakpoint feature. We currently pin breakpoints to original locations, so when the user changes another file, the breakpoint does not move. With AST Breakpoints we will pin the breakpoint to the function it is in, so changes to the file will no longer move the breakpoint!

* [add AST breakpoint util][pr-27] - [@codehag]
* [add astbreakpoints flowtypes][pr-24] - [@codehag]


#### Bugs

Our work on bugs was this week was partially about bugs infrastructure. @jasonLaster added a script to help debug intermittent bugs, and @juliandescottes added @flodolo to help us with translations

* [Fix intermittent][pr-0] - [@jasonLaster]
* [add an intermittent finding script][pr-26] - [@jasonLaster]

<img width="818" alt="screen shot 2017-08-24 at 12 20 15 am" src="https://user-images.githubusercontent.com/254562/29649553-c2a4e37c-8862-11e7-8705-c8501cf8f60c.png">

* [Fix #3729 - Ensure 'Reveal in Tree' always works, even if source doesn't change][pr-1] - [@darkwing]
* [Do not save Expression values in prefs][pr-8] - [@jasonLaster]
* [update mochi to make browser_dbg optional][pr-9] - [@jasonLaster]
* [Fix 'copySource.accesskey' error when right-clicking][pr-13] - [@darkwing]
* [Issue #3795 - create CODEOWNERS file, assign @flodolo to debugger.pro…][pr-23] - [@juliandescottes]

#### JSX conversion

We have completed our move to JSX, huge thank you to @darkwing and @wldcordero for their hard work!

* [Convert PrimaryPanes/index to JSX][pr-10] - [@darkwing]
* [Add React for CallSites JSX][pr-11] - [@darkwing]
* [Convert CallSites to JSX][pr-12] - [@darkwing]
* [Convert TextSearch completely to jsx][pr-14] - [@darkwing]
* [Convert SourcesTree to JSX][pr-16] - [@darkwing]
* [Convert SecondaryPanes/index to JSX][pr-17] - [@darkwing]
* [Transform ConditionalPanel to JSX][pr-18] - [@darkwing]
* [JSX Conversions for Frame components.][pr-19] - [@wldcordeiro]
* [Convert SVG icon usage to JSX][pr-21] - [@darkwing]
* [Convert ChromeScopes and PreviewFunction to JSX along with stories.][pr-25] - [@wldcordeiro]
* [Convert Breakpoints to JSX][pr-29] - [@darkwing]


#### Infrastructure

We have improved our eslint config to automatically fix obvious errors that do not need human intervention, and to lint for the use of let and const. There have also been improvements to our mochitest runner

* [Bugfix/readme rebased][pr-3] - [@codehag]
* [add prefer-const rule to eslint][pr-20] - [@codehag]
* [autofix simple eslint errors][pr-22] - [@codehag]
* [Issue #3794 - synchronize properties file cleanup from mozilla-centra…][pr-30] - [@juliandescottes]
* [capture mochi exit code][pr-32] - [@jasonLaster]
* [run mochitests w/ the mochi runner][pr-32] - [@jasonLaster]

[pr-0]:https://github.com/devtools-html/debugger.html/pull/3763
[pr-1]:https://github.com/devtools-html/debugger.html/pull/3760
[pr-2]:https://github.com/devtools-html/debugger.html/pull/3741
[pr-3]:https://github.com/devtools-html/debugger.html/pull/3762
[pr-4]:https://github.com/devtools-html/debugger.html/pull/3765
[pr-5]:https://github.com/devtools-html/debugger.html/pull/3749
[pr-6]:https://github.com/devtools-html/debugger.html/pull/3747
[pr-7]:https://github.com/devtools-html/debugger.html/pull/3716
[pr-8]:https://github.com/devtools-html/debugger.html/pull/3759
[pr-9]:https://github.com/devtools-html/debugger.html/pull/3744
[pr-10]:https://github.com/devtools-html/debugger.html/pull/3773
[pr-11]:https://github.com/devtools-html/debugger.html/pull/3774
[pr-12]:https://github.com/devtools-html/debugger.html/pull/3772
[pr-13]:https://github.com/devtools-html/debugger.html/pull/3775
[pr-14]:https://github.com/devtools-html/debugger.html/pull/3786
[pr-15]:https://github.com/devtools-html/debugger.html/pull/3779
[pr-16]:https://github.com/devtools-html/debugger.html/pull/3780
[pr-17]:https://github.com/devtools-html/debugger.html/pull/3781
[pr-18]:https://github.com/devtools-html/debugger.html/pull/3776
[pr-19]:https://github.com/devtools-html/debugger.html/pull/3785
[pr-20]:https://github.com/devtools-html/debugger.html/pull/3783
[pr-21]:https://github.com/devtools-html/debugger.html/pull/3791
[pr-22]:https://github.com/devtools-html/debugger.html/pull/3784
[pr-23]:https://github.com/devtools-html/debugger.html/pull/3797
[pr-24]:https://github.com/devtools-html/debugger.html/pull/3805
[pr-25]:https://github.com/devtools-html/debugger.html/pull/3793
[pr-26]:https://github.com/devtools-html/debugger.html/pull/3770
[pr-27]:https://github.com/devtools-html/debugger.html/pull/3753
[pr-28]:https://github.com/devtools-html/debugger.html/pull/3740
[pr-29]:https://github.com/devtools-html/debugger.html/pull/3788
[pr-30]:https://github.com/devtools-html/debugger.html/pull/3796
[pr-31]:https://github.com/devtools-html/debugger.html/pull/3743
[pr-32]:https://github.com/devtools-html/debugger.html/pull/3768
[pr-33]:https://github.com/devtools-html/debugger.html/pull/3242
[pr-34]:https://github.com/devtools-html/debugger.html/pull/3748
[@jasonLaster]:http://github.com/jasonLaster
[@darkwing]:http://github.com/darkwing
[@rohanprasad]:http://github.com/rohanprasad
[@codehag]:http://github.com/codehag
[@hughugsy]:http://github.com/hughugsy
[@wldcordeiro]:http://github.com/wldcordeiro
[@juliandescottes]:http://github.com/juliandescottes
[@sharathnarayanph]:http://github.com/sharathnarayanph
[@sagorika1996]:http://github.com/sagorika1996
[@jbhoosreddy]:http://github.com/jbhoosreddy
[@bomsy]:http://github.com/bomsy
