### March 28th

This week we added some nice polish to the UI and function search.

We also landed Jest [code coverage], which shows us where we need to add additional unit tests.

Special thanks to:

* [Ruturaj][@ruturajv] who helped us improve function search by inferring function names from the variables they're assigned to.
* [Sam][@samjwalker] who fixed a UI nit where the debugger would highlight the previously selected line on open.

and everyone else who helped this week!

[@wildskyf], [@ruturajv], [@clarkbw], [@samjwalker], [@abhishekg785], [@jacobjzhang], [@arthur801031], [@AnshulMalik], [@jasonLaster]

### UI

* [Re-add accordion focus inner style][pr-0] - [@jasonLaster]
* [Stop the previously highlighted line flashing after refreshing the debugger.][pr-6] - [@samjwalker]
* [Add a separate highlight animation for dark theme][pr-15] - [@jacobjzhang]

### Function Search

* [Name functions based on their var][pr-2] - [@ruturajv]
* [Name Functions defined via an expression][pr-13] - [@ruturajv]

```js
function incrementCounter(counter) {
  return counter++;
}

const sum = (a, b) => a + b;
```

### Infrastructure
* [Fix table layout for markdown on GitHub][pr-1] - [@wildskyf]
* [Jest coverage][pr-3] - [@clarkbw]
* [[prettier] switch es5 commas][pr-4] - [@jasonLaster]
* [[docs] add table markdown linting][pr-5] - [@jasonLaster]
* [[tests] Fix requiring workers in jest][pr-7] - [@jasonLaster]
* [Fix duplicate locale][pr-9] - [@jasonLaster]
* [broken table fixed][pr-10] - [@abhishekg785]
* [Bump source-map to 2.2.4][pr-12] - [@jasonLaster]
* [3rd party docs][pr-16] - [@jasonLaster]
* [Upgrade to flow `0.41`][pr-17] - [@arthur801031]
* [Refactor(ES6) components/shared/Dropdown.js][pr-18] - [@AnshulMalik]

![](http://g.recordit.co/KEEn6tvCCX.gif)

![cov-screen]

[cov-screen]:https://cloud.githubusercontent.com/assets/254562/24416335/700b5bde-13b2-11e7-9380-aba9ab13d71b.png

[pr-0]:https://github.com/devtools-html/debugger.html/pull/2420
[pr-1]:https://github.com/devtools-html/debugger.html/pull/2422
[pr-2]:https://github.com/devtools-html/debugger.html/pull/2404
[pr-3]:https://github.com/devtools-html/debugger.html/pull/2417
[pr-4]:https://github.com/devtools-html/debugger.html/pull/2432
[pr-5]:https://github.com/devtools-html/debugger.html/pull/2423
[pr-6]:https://github.com/devtools-html/debugger.html/pull/2430
[pr-7]:https://github.com/devtools-html/debugger.html/pull/2431
[pr-8]:https://github.com/devtools-html/debugger.html/pull/2369
[pr-9]:https://github.com/devtools-html/debugger.html/pull/2445
[pr-10]:https://github.com/devtools-html/debugger.html/pull/2456
[pr-11]:https://github.com/devtools-html/debugger.html/pull/2454
[pr-12]:https://github.com/devtools-html/debugger.html/pull/2459
[pr-13]:https://github.com/devtools-html/debugger.html/pull/2452
[pr-14]:https://github.com/devtools-html/debugger.html/pull/2449
[pr-15]:https://github.com/devtools-html/debugger.html/pull/2466
[pr-16]:https://github.com/devtools-html/debugger.html/pull/2457
[pr-17]:https://github.com/devtools-html/debugger.html/pull/2462
[pr-18]:https://github.com/devtools-html/debugger.html/pull/2464
[@jasonLaster]:http://github.com/jasonLaster
[@wildskyf]:http://github.com/wildskyf
[@ruturajv]:http://github.com/ruturajv
[@clarkbw]:http://github.com/clarkbw
[@samjwalker]:http://github.com/samjwalker
[@abhishekg785]:http://github.com/abhishekg785
[@jacobjzhang]:http://github.com/jacobjzhang
[@arthur801031]:http://github.com/arthur801031
[@AnshulMalik]:http://github.com/AnshulMalik
[code coverage]:https://codecov.io/gh/devtools-html/debugger.html
