// Code generated by dcspec/gen.sh. DO NOT EDIT.
//
// This file was generated from JSON Schema using quicktype, do not modify it directly.
// To parse and unparse this JSON data, add this code to your project and do:
//
//    devContainer, err := UnmarshalDevContainer(bytes)
//    bytes, err = devContainer.Marshal()

package dcspec

import (
	"bytes"
	"encoding/json"
	"errors"
)

func UnmarshalDevContainer(data []byte) (DevContainer, error) {
	var r DevContainer
	err := json.Unmarshal(data, &r)
	return r, err
}

func (r *DevContainer) Marshal() ([]byte, error) {
	return json.Marshal(r)
}

// Defines a dev container
type DevContainer struct {
	// Docker build-related options.
	Build *BuildOptions `json:"build,omitempty"`
	// The location of the context folder for building the Docker image. The path is relative to
	// the folder containing the `devcontainer.json` file.
	Context *string `json:"context,omitempty"`
	// The location of the Dockerfile that defines the contents of the container. The path is
	// relative to the folder containing the `devcontainer.json` file.
	DockerFile *string `json:"dockerFile,omitempty"`
	// The docker image that will be used to create the container.
	Image *string `json:"image,omitempty"`
	// Application ports that are exposed by the container. This can be a single port or an
	// array of ports. Each port can be a number or a string. A number is mapped to the same
	// port on the host. A string is passed to Docker unchanged and can be used to map ports
	// differently, e.g. "8000:8010".
	AppPort *DevContainerAppPort `json:"appPort"`
	// Whether to overwrite the command specified in the image. The default is true.
	//
	// Whether to overwrite the command specified in the image. The default is false.
	OverrideCommand *bool `json:"overrideCommand,omitempty"`
	// The arguments required when starting in the container.
	RunArgs []string `json:"runArgs,omitempty"`
	// Action to take when the user disconnects from the container in their editor. The default
	// is to stop the container.
	//
	// Action to take when the user disconnects from the primary container in their editor. The
	// default is to stop all of the compose containers.
	ShutdownAction *ShutdownAction `json:"shutdownAction,omitempty"`
	// The path of the workspace folder inside the container.
	//
	// The path of the workspace folder inside the container. This is typically the target path
	// of a volume mount in the docker-compose.yml.
	WorkspaceFolder *string `json:"workspaceFolder,omitempty"`
	// The --mount parameter for docker run. The default is to mount the project folder at
	// /workspaces/$project.
	WorkspaceMount *string `json:"workspaceMount,omitempty"`
	// The name of the docker-compose file(s) used to start the services.
	DockerComposeFile *CacheFrom `json:"dockerComposeFile"`
	// An array of services that should be started and stopped.
	RunServices []string `json:"runServices,omitempty"`
	// The service you want to work on. This is considered the primary container for your dev
	// environment which your editor will connect to.
	Service *string `json:"service,omitempty"`
	// The JSON schema of the `devcontainer.json` file.
	Schema               *string                `json:"$schema,omitempty"`
	AdditionalProperties map[string]interface{} `json:"additionalProperties,omitempty"`
	// Passes docker capabilities to include when creating the dev container.
	CapAdd []string `json:"capAdd,omitempty"`
	// Container environment variables.
	ContainerEnv map[string]string `json:"containerEnv,omitempty"`
	// The user the container will be started with. The default is the user on the Docker image.
	ContainerUser *string `json:"containerUser,omitempty"`
	// Tool-specific configuration. Each tool should use a JSON object subproperty with a unique
	// name to group its customizations.
	Customizations map[string]interface{} `json:"customizations,omitempty"`
	// Features to add to the dev container.
	Features *Features `json:"features,omitempty"`
	// Ports that are forwarded from the container to the local machine. Can be an integer port
	// number, or a string of the format "host:port_number".
	ForwardPorts []ForwardPort `json:"forwardPorts,omitempty"`
	// Host hardware requirements.
	HostRequirements *HostRequirements `json:"hostRequirements,omitempty"`
	// Passes the --init flag when creating the dev container.
	Init *bool `json:"init,omitempty"`
	// A command to run locally (i.e Your host machine, cloud VM) before anything else. This
	// command is run before "onCreateCommand". If this is a single string, it will be run in a
	// shell. If this is an array of strings, it will be run as a single command without shell.
	// If this is an object, each provided command will be run in parallel.
	InitializeCommand *Command `json:"initializeCommand"`
	// Mount points to set up when creating the container. See Docker's documentation for the
	// --mount option for the supported syntax.
	Mounts []MountElement `json:"mounts,omitempty"`
	// A name for the dev container which can be displayed to the user.
	Name *string `json:"name,omitempty"`
	// A command to run when creating the container. This command is run after
	// "initializeCommand" and before "updateContentCommand". If this is a single string, it
	// will be run in a shell. If this is an array of strings, it will be run as a single
	// command without shell. If this is an object, each provided command will be run in
	// parallel.
	OnCreateCommand      *Command              `json:"onCreateCommand"`
	OtherPortsAttributes *OtherPortsAttributes `json:"otherPortsAttributes,omitempty"`
	// Array consisting of the Feature id (without the semantic version) of Features in the
	// order the user wants them to be installed.
	OverrideFeatureInstallOrder []string         `json:"overrideFeatureInstallOrder,omitempty"`
	PortsAttributes             *PortsAttributes `json:"portsAttributes,omitempty"`
	// A command to run when attaching to the container. This command is run after
	// "postStartCommand". If this is a single string, it will be run in a shell. If this is an
	// array of strings, it will be run as a single command without shell. If this is an object,
	// each provided command will be run in parallel.
	PostAttachCommand *Command `json:"postAttachCommand"`
	// A command to run after creating the container. This command is run after
	// "updateContentCommand" and before "postStartCommand". If this is a single string, it will
	// be run in a shell. If this is an array of strings, it will be run as a single command
	// without shell. If this is an object, each provided command will be run in parallel.
	PostCreateCommand *Command `json:"postCreateCommand"`
	// A command to run after starting the container. This command is run after
	// "postCreateCommand" and before "postAttachCommand". If this is a single string, it will
	// be run in a shell. If this is an array of strings, it will be run as a single command
	// without shell. If this is an object, each provided command will be run in parallel.
	PostStartCommand *Command `json:"postStartCommand"`
	// Passes the --privileged flag when creating the dev container.
	Privileged *bool `json:"privileged,omitempty"`
	// Remote environment variables to set for processes spawned in the container including
	// lifecycle scripts and any remote editor/IDE server process.
	RemoteEnv map[string]*string `json:"remoteEnv,omitempty"`
	// The username to use for spawning processes in the container including lifecycle scripts
	// and any remote editor/IDE server process. The default is the same user as the container.
	RemoteUser *string `json:"remoteUser,omitempty"`
	// Recommended secrets for this dev container. Recommendations are provided as environment
	// variable keys with optional metadata.
	Secrets *Secrets `json:"secrets,omitempty"`
	// Passes docker security options to include when creating the dev container.
	SecurityOpt []string `json:"securityOpt,omitempty"`
	// A command to run when creating the container and rerun when the workspace content was
	// updated while creating the container. This command is run after "onCreateCommand" and
	// before "postCreateCommand". If this is a single string, it will be run in a shell. If
	// this is an array of strings, it will be run as a single command without shell. If this is
	// an object, each provided command will be run in parallel.
	UpdateContentCommand *Command `json:"updateContentCommand"`
	// Controls whether on Linux the container's user should be updated with the local user's
	// UID and GID. On by default when opening from a local folder.
	UpdateRemoteUserUID *bool `json:"updateRemoteUserUID,omitempty"`
	// User environment probe to run. The default is "loginInteractiveShell".
	UserEnvProbe *UserEnvProbe `json:"userEnvProbe,omitempty"`
	// The user command to wait for before continuing execution in the background while the UI
	// is starting up. The default is "updateContentCommand".
	WaitFor *WaitFor `json:"waitFor,omitempty"`
}

// Docker build-related options.
type BuildOptions struct {
	// The location of the context folder for building the Docker image. The path is relative to
	// the folder containing the `devcontainer.json` file.
	Context *string `json:"context,omitempty"`
	// The location of the Dockerfile that defines the contents of the container. The path is
	// relative to the folder containing the `devcontainer.json` file.
	Dockerfile *string `json:"dockerfile,omitempty"`
	// Build arguments.
	Args map[string]string `json:"args,omitempty"`
	// The image to consider as a cache. Use an array to specify multiple images.
	CacheFrom *CacheFrom `json:"cacheFrom"`
	// Additional arguments passed to the build command.
	Options []string `json:"options,omitempty"`
	// Target stage in a multi-stage build.
	Target *string `json:"target,omitempty"`
}

// Features to add to the dev container.
type Features struct {
	Fish       interface{} `json:"fish"`
	Gradle     interface{} `json:"gradle"`
	Homebrew   interface{} `json:"homebrew"`
	Jupyterlab interface{} `json:"jupyterlab"`
	Maven      interface{} `json:"maven"`
}

// Host hardware requirements.
type HostRequirements struct {
	// Number of required CPUs.
	Cpus *int64    `json:"cpus,omitempty"`
	GPU  *GPUUnion `json:"gpu"`
	// Amount of required RAM in bytes. Supports units tb, gb, mb and kb.
	Memory *string `json:"memory,omitempty"`
	// Amount of required disk space in bytes. Supports units tb, gb, mb and kb.
	Storage *string `json:"storage,omitempty"`
}

// Indicates whether a GPU is required. The string "optional" indicates that a GPU is
// optional. An object value can be used to configure more detailed requirements.
type GPUClass struct {
	// Number of required cores.
	Cores *int64 `json:"cores,omitempty"`
	// Amount of required RAM in bytes. Supports units tb, gb, mb and kb.
	Memory *string `json:"memory,omitempty"`
}

type Mount struct {
	// Mount source.
	Source *string `json:"source,omitempty"`
	// Mount target.
	Target string `json:"target"`
	// Mount type.
	Type Type `json:"type"`
}

type OtherPortsAttributes struct {
	// Automatically prompt for elevation (if needed) when this port is forwarded. Elevate is
	// required if the local port is a privileged port.
	ElevateIfNeeded *bool `json:"elevateIfNeeded,omitempty"`
	// Label that will be shown in the UI for this port.
	Label *string `json:"label,omitempty"`
	// Defines the action that occurs when the port is discovered for automatic forwarding
	OnAutoForward *OnAutoForward `json:"onAutoForward,omitempty"`
	// The protocol to use when forwarding this port.
	Protocol         *Protocol `json:"protocol,omitempty"`
	RequireLocalPort *bool     `json:"requireLocalPort,omitempty"`
}

type PortsAttributes struct{}

// Recommended secrets for this dev container. Recommendations are provided as environment
// variable keys with optional metadata.
type Secrets struct{}

type GPUEnum string

const (
	Optional GPUEnum = "optional"
)

// Mount type.
type Type string

const (
	Bind   Type = "bind"
	Volume Type = "volume"
)

// Defines the action that occurs when the port is discovered for automatic forwarding
type OnAutoForward string

const (
	Ignore      OnAutoForward = "ignore"
	Notify      OnAutoForward = "notify"
	OpenBrowser OnAutoForward = "openBrowser"
	OpenPreview OnAutoForward = "openPreview"
	Silent      OnAutoForward = "silent"
)

// The protocol to use when forwarding this port.
type Protocol string

const (
	HTTP  Protocol = "http"
	HTTPS Protocol = "https"
)

// Action to take when the user disconnects from the container in their editor. The default
// is to stop the container.
//
// Action to take when the user disconnects from the primary container in their editor. The
// default is to stop all of the compose containers.
type ShutdownAction string

const (
	ShutdownActionNone ShutdownAction = "none"
	StopCompose        ShutdownAction = "stopCompose"
	StopContainer      ShutdownAction = "stopContainer"
)

// User environment probe to run. The default is "loginInteractiveShell".
type UserEnvProbe string

const (
	InteractiveShell      UserEnvProbe = "interactiveShell"
	LoginInteractiveShell UserEnvProbe = "loginInteractiveShell"
	LoginShell            UserEnvProbe = "loginShell"
	UserEnvProbeNone      UserEnvProbe = "none"
)

// The user command to wait for before continuing execution in the background while the UI
// is starting up. The default is "updateContentCommand".
type WaitFor string

const (
	InitializeCommand    WaitFor = "initializeCommand"
	OnCreateCommand      WaitFor = "onCreateCommand"
	PostCreateCommand    WaitFor = "postCreateCommand"
	PostStartCommand     WaitFor = "postStartCommand"
	UpdateContentCommand WaitFor = "updateContentCommand"
)

// Application ports that are exposed by the container. This can be a single port or an
// array of ports. Each port can be a number or a string. A number is mapped to the same
// port on the host. A string is passed to Docker unchanged and can be used to map ports
// differently, e.g. "8000:8010".
type DevContainerAppPort struct {
	Integer    *int64
	String     *string
	UnionArray []AppPortElement
}

func (x *DevContainerAppPort) UnmarshalJSON(data []byte) error {
	x.UnionArray = nil
	object, err := unmarshalUnion(data, &x.Integer, nil, nil, &x.String, true, &x.UnionArray, false, nil, false, nil, false, nil, false)
	if err != nil {
		return err
	}
	if object {
	}
	return nil
}

func (x *DevContainerAppPort) MarshalJSON() ([]byte, error) {
	return marshalUnion(x.Integer, nil, nil, x.String, x.UnionArray != nil, x.UnionArray, false, nil, false, nil, false, nil, false)
}

// Application ports that are exposed by the container. This can be a single port or an
// array of ports. Each port can be a number or a string. A number is mapped to the same
// port on the host. A string is passed to Docker unchanged and can be used to map ports
// differently, e.g. "8000:8010".
type AppPortElement struct {
	Integer *int64
	String  *string
}

func (x *AppPortElement) UnmarshalJSON(data []byte) error {
	object, err := unmarshalUnion(data, &x.Integer, nil, nil, &x.String, false, nil, false, nil, false, nil, false, nil, false)
	if err != nil {
		return err
	}
	if object {
	}
	return nil
}

func (x *AppPortElement) MarshalJSON() ([]byte, error) {
	return marshalUnion(x.Integer, nil, nil, x.String, false, nil, false, nil, false, nil, false, nil, false)
}

// The image to consider as a cache. Use an array to specify multiple images.
//
// The name of the docker-compose file(s) used to start the services.
type CacheFrom struct {
	String      *string
	StringArray []string
}

func (x *CacheFrom) UnmarshalJSON(data []byte) error {
	x.StringArray = nil
	object, err := unmarshalUnion(data, nil, nil, nil, &x.String, true, &x.StringArray, false, nil, false, nil, false, nil, false)
	if err != nil {
		return err
	}
	if object {
	}
	return nil
}

func (x *CacheFrom) MarshalJSON() ([]byte, error) {
	return marshalUnion(nil, nil, nil, x.String, x.StringArray != nil, x.StringArray, false, nil, false, nil, false, nil, false)
}

type ForwardPort struct {
	Integer *int64
	String  *string
}

func (x *ForwardPort) UnmarshalJSON(data []byte) error {
	object, err := unmarshalUnion(data, &x.Integer, nil, nil, &x.String, false, nil, false, nil, false, nil, false, nil, false)
	if err != nil {
		return err
	}
	if object {
	}
	return nil
}

func (x *ForwardPort) MarshalJSON() ([]byte, error) {
	return marshalUnion(x.Integer, nil, nil, x.String, false, nil, false, nil, false, nil, false, nil, false)
}

type GPUUnion struct {
	Bool     *bool
	Enum     *GPUEnum
	GPUClass *GPUClass
}

func (x *GPUUnion) UnmarshalJSON(data []byte) error {
	x.GPUClass = nil
	x.Enum = nil
	var c GPUClass
	object, err := unmarshalUnion(data, nil, nil, &x.Bool, nil, false, nil, true, &c, false, nil, true, &x.Enum, false)
	if err != nil {
		return err
	}
	if object {
		x.GPUClass = &c
	}
	return nil
}

func (x *GPUUnion) MarshalJSON() ([]byte, error) {
	return marshalUnion(nil, nil, x.Bool, nil, false, nil, x.GPUClass != nil, x.GPUClass, false, nil, x.Enum != nil, x.Enum, false)
}

// A command to run locally (i.e Your host machine, cloud VM) before anything else. This
// command is run before "onCreateCommand". If this is a single string, it will be run in a
// shell. If this is an array of strings, it will be run as a single command without shell.
// If this is an object, each provided command will be run in parallel.
//
// A command to run when creating the container. This command is run after
// "initializeCommand" and before "updateContentCommand". If this is a single string, it
// will be run in a shell. If this is an array of strings, it will be run as a single
// command without shell. If this is an object, each provided command will be run in
// parallel.
//
// A command to run when attaching to the container. This command is run after
// "postStartCommand". If this is a single string, it will be run in a shell. If this is an
// array of strings, it will be run as a single command without shell. If this is an object,
// each provided command will be run in parallel.
//
// A command to run after creating the container. This command is run after
// "updateContentCommand" and before "postStartCommand". If this is a single string, it will
// be run in a shell. If this is an array of strings, it will be run as a single command
// without shell. If this is an object, each provided command will be run in parallel.
//
// A command to run after starting the container. This command is run after
// "postCreateCommand" and before "postAttachCommand". If this is a single string, it will
// be run in a shell. If this is an array of strings, it will be run as a single command
// without shell. If this is an object, each provided command will be run in parallel.
//
// A command to run when creating the container and rerun when the workspace content was
// updated while creating the container. This command is run after "onCreateCommand" and
// before "postCreateCommand". If this is a single string, it will be run in a shell. If
// this is an array of strings, it will be run as a single command without shell. If this is
// an object, each provided command will be run in parallel.
type Command struct {
	String      *string
	StringArray []string
	UnionMap    map[string]*CacheFrom
}

func (x *Command) UnmarshalJSON(data []byte) error {
	x.StringArray = nil
	x.UnionMap = nil
	object, err := unmarshalUnion(data, nil, nil, nil, &x.String, true, &x.StringArray, false, nil, true, &x.UnionMap, false, nil, false)
	if err != nil {
		return err
	}
	if object {
	}
	return nil
}

func (x *Command) MarshalJSON() ([]byte, error) {
	return marshalUnion(nil, nil, nil, x.String, x.StringArray != nil, x.StringArray, false, nil, x.UnionMap != nil, x.UnionMap, false, nil, false)
}

type MountElement struct {
	Mount  *Mount
	String *string
}

func (x *MountElement) UnmarshalJSON(data []byte) error {
	x.Mount = nil
	var c Mount
	object, err := unmarshalUnion(data, nil, nil, nil, &x.String, false, nil, true, &c, false, nil, false, nil, false)
	if err != nil {
		return err
	}
	if object {
		x.Mount = &c
	}
	return nil
}

func (x *MountElement) MarshalJSON() ([]byte, error) {
	return marshalUnion(nil, nil, nil, x.String, false, nil, x.Mount != nil, x.Mount, false, nil, false, nil, false)
}

func unmarshalUnion(data []byte, pi **int64, pf **float64, pb **bool, ps **string, haveArray bool, pa interface{}, haveObject bool, pc interface{}, haveMap bool, pm interface{}, haveEnum bool, pe interface{}, nullable bool) (bool, error) {
	if pi != nil {
		*pi = nil
	}
	if pf != nil {
		*pf = nil
	}
	if pb != nil {
		*pb = nil
	}
	if ps != nil {
		*ps = nil
	}

	dec := json.NewDecoder(bytes.NewReader(data))
	dec.UseNumber()
	tok, err := dec.Token()
	if err != nil {
		return false, err
	}

	switch v := tok.(type) {
	case json.Number:
		if pi != nil {
			i, err := v.Int64()
			if err == nil {
				*pi = &i
				return false, nil
			}
		}
		if pf != nil {
			f, err := v.Float64()
			if err == nil {
				*pf = &f
				return false, nil
			}
			return false, errors.New("Unparsable number")
		}
		return false, errors.New("Union does not contain number")
	case float64:
		return false, errors.New("Decoder should not return float64")
	case bool:
		if pb != nil {
			*pb = &v
			return false, nil
		}
		return false, errors.New("Union does not contain bool")
	case string:
		if haveEnum {
			return false, json.Unmarshal(data, pe)
		}
		if ps != nil {
			*ps = &v
			return false, nil
		}
		return false, errors.New("Union does not contain string")
	case nil:
		if nullable {
			return false, nil
		}
		return false, errors.New("Union does not contain null")
	case json.Delim:
		if v == '{' {
			if haveObject {
				return true, json.Unmarshal(data, pc)
			}
			if haveMap {
				return false, json.Unmarshal(data, pm)
			}
			return false, errors.New("Union does not contain object")
		}
		if v == '[' {
			if haveArray {
				return false, json.Unmarshal(data, pa)
			}
			return false, errors.New("Union does not contain array")
		}
		return false, errors.New("Cannot handle delimiter")
	}
	return false, errors.New("Cannot unmarshal union")
}

func marshalUnion(pi *int64, pf *float64, pb *bool, ps *string, haveArray bool, pa interface{}, haveObject bool, pc interface{}, haveMap bool, pm interface{}, haveEnum bool, pe interface{}, nullable bool) ([]byte, error) {
	if pi != nil {
		return json.Marshal(*pi)
	}
	if pf != nil {
		return json.Marshal(*pf)
	}
	if pb != nil {
		return json.Marshal(*pb)
	}
	if ps != nil {
		return json.Marshal(*ps)
	}
	if haveArray {
		return json.Marshal(pa)
	}
	if haveObject {
		return json.Marshal(pc)
	}
	if haveMap {
		return json.Marshal(pm)
	}
	if haveEnum {
		return json.Marshal(pe)
	}
	if nullable {
		return json.Marshal(nil)
	}
	return nil, errors.New("Union must not be null")
}
