// Package apidoc Code generated by swaggo/swag. DO NOT EDIT
package apidoc

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "termsOfService": "https://coder.com/legal/terms-of-service",
        "contact": {
            "name": "API Support",
            "url": "https://coder.com",
            "email": "support@coder.com"
        },
        "license": {
            "name": "AGPL-3.0",
            "url": "https://github.com/coder/coder/blob/main/LICENSE"
        },
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "API root handler",
                "operationId": "api-root-handler",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/.well-known/oauth-authorization-server": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "OAuth2 authorization server metadata.",
                "operationId": "oauth2-authorization-server-metadata",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2AuthorizationServerMetadata"
                        }
                    }
                }
            }
        },
        "/.well-known/oauth-protected-resource": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "OAuth2 protected resource metadata.",
                "operationId": "oauth2-protected-resource-metadata",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ProtectedResourceMetadata"
                        }
                    }
                }
            }
        },
        "/aibridge/interceptions": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "AI Bridge"
                ],
                "summary": "List AI Bridge interceptions",
                "operationId": "list-ai-bridge-interceptions",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Search query in the format ` + "`" + `key:value` + "`" + `. Available keys are: initiator, provider, model, started_after, started_before.",
                        "name": "q",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Cursor pagination after ID (cannot be used with offset)",
                        "name": "after_id",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Offset pagination (cannot be used with after_id)",
                        "name": "offset",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.AIBridgeListInterceptionsResponse"
                        }
                    }
                }
            }
        },
        "/appearance": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get appearance",
                "operationId": "get-appearance",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.AppearanceConfig"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update appearance",
                "operationId": "update-appearance",
                "parameters": [
                    {
                        "description": "Update appearance request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateAppearanceConfig"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateAppearanceConfig"
                        }
                    }
                }
            }
        },
        "/applications/auth-redirect": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Applications"
                ],
                "summary": "Redirect to URI with encrypted API key",
                "operationId": "redirect-to-uri-with-encrypted-api-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Redirect destination",
                        "name": "redirect_uri",
                        "in": "query"
                    }
                ],
                "responses": {
                    "307": {
                        "description": "Temporary Redirect"
                    }
                }
            }
        },
        "/applications/host": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Applications"
                ],
                "summary": "Get applications host",
                "operationId": "get-applications-host",
                "deprecated": true,
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.AppHostResponse"
                        }
                    }
                }
            }
        },
        "/applications/reconnecting-pty-signed-token": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Issue signed app token for reconnecting PTY",
                "operationId": "issue-signed-app-token-for-reconnecting-pty",
                "parameters": [
                    {
                        "description": "Issue reconnecting PTY signed token request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.IssueReconnectingPTYSignedTokenRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.IssueReconnectingPTYSignedTokenResponse"
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/audit": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Audit"
                ],
                "summary": "Get audit logs",
                "operationId": "get-audit-logs",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Search query",
                        "name": "q",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Page offset",
                        "name": "offset",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.AuditLogResponse"
                        }
                    }
                }
            }
        },
        "/audit/testgenerate": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Audit"
                ],
                "summary": "Generate fake audit log",
                "operationId": "generate-fake-audit-log",
                "parameters": [
                    {
                        "description": "Audit log request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateTestAuditLogRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/auth/scopes": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Authorization"
                ],
                "summary": "List API key scopes",
                "operationId": "list-api-key-scopes",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ExternalAPIKeyScopes"
                        }
                    }
                }
            }
        },
        "/authcheck": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Authorization"
                ],
                "summary": "Check authorization",
                "operationId": "check-authorization",
                "parameters": [
                    {
                        "description": "Authorization request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.AuthorizationRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.AuthorizationResponse"
                        }
                    }
                }
            }
        },
        "/buildinfo": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "Build info",
                "operationId": "build-info",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.BuildInfoResponse"
                        }
                    }
                }
            }
        },
        "/connectionlog": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get connection logs",
                "operationId": "get-connection-logs",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Search query",
                        "name": "q",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Page offset",
                        "name": "offset",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ConnectionLogResponse"
                        }
                    }
                }
            }
        },
        "/csp/reports": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "Report CSP violations",
                "operationId": "report-csp-violations",
                "parameters": [
                    {
                        "description": "Violation report",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/coderd.cspViolation"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/coordinator": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "text/html"
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug Info Wireguard Coordinator",
                "operationId": "debug-info-wireguard-coordinator",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/derp/traffic": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug DERP traffic",
                "operationId": "debug-derp-traffic",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/derp.BytesSentRecv"
                            }
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/expvar": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug expvar",
                "operationId": "debug-expvar",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "object",
                            "additionalProperties": true
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/health": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug Info Deployment Health",
                "operationId": "debug-info-deployment-health",
                "parameters": [
                    {
                        "type": "boolean",
                        "description": "Force a healthcheck to run",
                        "name": "force",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/healthsdk.HealthcheckReport"
                        }
                    }
                }
            }
        },
        "/debug/health/settings": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Get health settings",
                "operationId": "get-health-settings",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/healthsdk.HealthSettings"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Update health settings",
                "operationId": "update-health-settings",
                "parameters": [
                    {
                        "description": "Update health settings",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/healthsdk.UpdateHealthSettings"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/healthsdk.UpdateHealthSettings"
                        }
                    }
                }
            }
        },
        "/debug/metrics": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug metrics",
                "operationId": "debug-metrics",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/pprof": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug pprof index",
                "operationId": "debug-pprof-index",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/pprof/cmdline": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug pprof cmdline",
                "operationId": "debug-pprof-cmdline",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/pprof/profile": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug pprof profile",
                "operationId": "debug-pprof-profile",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/pprof/symbol": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug pprof symbol",
                "operationId": "debug-pprof-symbol",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/pprof/trace": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug pprof trace",
                "operationId": "debug-pprof-trace",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/tailnet": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "text/html"
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug Info Tailnet",
                "operationId": "debug-info-tailnet",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/debug/ws": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Debug"
                ],
                "summary": "Debug Info Websocket Test",
                "operationId": "debug-info-websocket-test",
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/debug/{user}/debug-link": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Debug OIDC context for a user",
                "operationId": "debug-oidc-context-for-a-user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "Success"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/deployment/config": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "Get deployment config",
                "operationId": "get-deployment-config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.DeploymentConfig"
                        }
                    }
                }
            }
        },
        "/deployment/ssh": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "SSH Config",
                "operationId": "ssh-config",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.SSHConfigResponse"
                        }
                    }
                }
            }
        },
        "/deployment/stats": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "Get deployment stats",
                "operationId": "get-deployment-stats",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.DeploymentStats"
                        }
                    }
                }
            }
        },
        "/derp-map": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get DERP map updates",
                "operationId": "get-derp-map-updates",
                "responses": {
                    "101": {
                        "description": "Switching Protocols"
                    }
                }
            }
        },
        "/entitlements": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get entitlements",
                "operationId": "get-entitlements",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Entitlements"
                        }
                    }
                }
            }
        },
        "/experiments": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "Get enabled experiments",
                "operationId": "get-enabled-experiments",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Experiment"
                            }
                        }
                    }
                }
            }
        },
        "/experiments/available": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "Get safe experiments",
                "operationId": "get-safe-experiments",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Experiment"
                            }
                        }
                    }
                }
            }
        },
        "/external-auth": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Git"
                ],
                "summary": "Get user external auths",
                "operationId": "get-user-external-auths",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ExternalAuthLink"
                        }
                    }
                }
            }
        },
        "/external-auth/{externalauth}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Git"
                ],
                "summary": "Get external auth by ID",
                "operationId": "get-external-auth-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "string",
                        "description": "Git Provider ID",
                        "name": "externalauth",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ExternalAuth"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Git"
                ],
                "summary": "Delete external auth user link by ID",
                "operationId": "delete-external-auth-user-link-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "string",
                        "description": "Git Provider ID",
                        "name": "externalauth",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.DeleteExternalAuthByIDResponse"
                        }
                    }
                }
            }
        },
        "/external-auth/{externalauth}/device": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Git"
                ],
                "summary": "Get external auth device by ID.",
                "operationId": "get-external-auth-device-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "string",
                        "description": "Git Provider ID",
                        "name": "externalauth",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ExternalAuthDevice"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Git"
                ],
                "summary": "Post external auth device by ID",
                "operationId": "post-external-auth-device-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "string",
                        "description": "External Provider ID",
                        "name": "externalauth",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/files": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "description": "Swagger notice: Swagger 2.0 doesn't support file upload with a ` + "`" + `content-type` + "`" + ` different than ` + "`" + `application/x-www-form-urlencoded` + "`" + `.",
                "consumes": [
                    "application/x-tar"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Files"
                ],
                "summary": "Upload file",
                "operationId": "upload-file",
                "parameters": [
                    {
                        "type": "string",
                        "default": "application/x-tar",
                        "description": "Content-Type must be ` + "`" + `application/x-tar` + "`" + ` or ` + "`" + `application/zip` + "`" + `",
                        "name": "Content-Type",
                        "in": "header",
                        "required": true
                    },
                    {
                        "type": "file",
                        "description": "File to be uploaded. If using tar format, file must conform to ustar (pax may cause problems).",
                        "name": "file",
                        "in": "formData",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "Returns existing file if duplicate",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UploadResponse"
                        }
                    },
                    "201": {
                        "description": "Returns newly created file",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UploadResponse"
                        }
                    }
                }
            }
        },
        "/files/{fileID}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Files"
                ],
                "summary": "Get file by ID",
                "operationId": "get-file-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "File ID",
                        "name": "fileID",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/groups": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get groups",
                "operationId": "get-groups",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID or name",
                        "name": "organization",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "User ID or name",
                        "name": "has_member",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Comma separated list of group IDs",
                        "name": "group_ids",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Group"
                            }
                        }
                    }
                }
            }
        },
        "/groups/{group}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get group by ID",
                "operationId": "get-group-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Group id",
                        "name": "group",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Group"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Delete group by name",
                "operationId": "delete-group-by-name",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Group name",
                        "name": "group",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Group"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update group by name",
                "operationId": "update-group-by-name",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Group name",
                        "name": "group",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Patch group request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchGroupRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Group"
                        }
                    }
                }
            }
        },
        "/init-script/{os}/{arch}": {
            "get": {
                "produces": [
                    "text/plain"
                ],
                "tags": [
                    "InitScript"
                ],
                "summary": "Get agent init script",
                "operationId": "get-agent-init-script",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Operating system",
                        "name": "os",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Architecture",
                        "name": "arch",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "Success"
                    }
                }
            }
        },
        "/insights/daus": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Insights"
                ],
                "summary": "Get deployment DAUs",
                "operationId": "get-deployment-daus",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Time-zone offset (e.g. -2)",
                        "name": "tz_offset",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.DAUsResponse"
                        }
                    }
                }
            }
        },
        "/insights/templates": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Insights"
                ],
                "summary": "Get insights about templates",
                "operationId": "get-insights-about-templates",
                "parameters": [
                    {
                        "type": "string",
                        "format": "date-time",
                        "description": "Start time",
                        "name": "start_time",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "date-time",
                        "description": "End time",
                        "name": "end_time",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "week",
                            "day"
                        ],
                        "type": "string",
                        "description": "Interval",
                        "name": "interval",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "array",
                        "items": {
                            "type": "string"
                        },
                        "collectionFormat": "csv",
                        "description": "Template IDs",
                        "name": "template_ids",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TemplateInsightsResponse"
                        }
                    }
                }
            }
        },
        "/insights/user-activity": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Insights"
                ],
                "summary": "Get insights about user activity",
                "operationId": "get-insights-about-user-activity",
                "parameters": [
                    {
                        "type": "string",
                        "format": "date-time",
                        "description": "Start time",
                        "name": "start_time",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "date-time",
                        "description": "End time",
                        "name": "end_time",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "array",
                        "items": {
                            "type": "string"
                        },
                        "collectionFormat": "csv",
                        "description": "Template IDs",
                        "name": "template_ids",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UserActivityInsightsResponse"
                        }
                    }
                }
            }
        },
        "/insights/user-latency": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Insights"
                ],
                "summary": "Get insights about user latency",
                "operationId": "get-insights-about-user-latency",
                "parameters": [
                    {
                        "type": "string",
                        "format": "date-time",
                        "description": "Start time",
                        "name": "start_time",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "date-time",
                        "description": "End time",
                        "name": "end_time",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "array",
                        "items": {
                            "type": "string"
                        },
                        "collectionFormat": "csv",
                        "description": "Template IDs",
                        "name": "template_ids",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UserLatencyInsightsResponse"
                        }
                    }
                }
            }
        },
        "/insights/user-status-counts": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Insights"
                ],
                "summary": "Get insights about user status counts",
                "operationId": "get-insights-about-user-status-counts",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Time-zone offset (e.g. -2)",
                        "name": "tz_offset",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GetUserStatusCountsResponse"
                        }
                    }
                }
            }
        },
        "/licenses": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get licenses",
                "operationId": "get-licenses",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.License"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Add new license",
                "operationId": "add-new-license",
                "parameters": [
                    {
                        "description": "Add license request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.AddLicenseRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.License"
                        }
                    }
                }
            }
        },
        "/licenses/refresh-entitlements": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update license entitlements",
                "operationId": "update-license-entitlements",
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/licenses/{id}": {
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Delete license",
                "operationId": "delete-license",
                "parameters": [
                    {
                        "type": "string",
                        "format": "number",
                        "description": "License ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/notifications/custom": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Send a custom notification",
                "operationId": "send-a-custom-notification",
                "parameters": [
                    {
                        "description": "Provide a non-empty title or message",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CustomNotificationRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    },
                    "400": {
                        "description": "Invalid request body",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    },
                    "403": {
                        "description": "System users cannot send custom notifications",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    },
                    "500": {
                        "description": "Failed to send custom notification",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/notifications/dispatch-methods": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Get notification dispatch methods",
                "operationId": "get-notification-dispatch-methods",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.NotificationMethodsResponse"
                            }
                        }
                    }
                }
            }
        },
        "/notifications/inbox": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "List inbox notifications",
                "operationId": "list-inbox-notifications",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Comma-separated list of target IDs to filter notifications",
                        "name": "targets",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Comma-separated list of template IDs to filter notifications",
                        "name": "templates",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Filter notifications by read status. Possible values: read, unread, all",
                        "name": "read_status",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "ID of the last notification from the current page. Notifications returned will be older than the associated one",
                        "name": "starting_before",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ListInboxNotificationsResponse"
                        }
                    }
                }
            }
        },
        "/notifications/inbox/mark-all-as-read": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Mark all unread notifications as read",
                "operationId": "mark-all-unread-notifications-as-read",
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/notifications/inbox/watch": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Watch for new inbox notifications",
                "operationId": "watch-for-new-inbox-notifications",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Comma-separated list of target IDs to filter notifications",
                        "name": "targets",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Comma-separated list of template IDs to filter notifications",
                        "name": "templates",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Filter notifications by read status. Possible values: read, unread, all",
                        "name": "read_status",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "plaintext",
                            "markdown"
                        ],
                        "type": "string",
                        "description": "Define the output format for notifications title and body.",
                        "name": "format",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GetInboxNotificationResponse"
                        }
                    }
                }
            }
        },
        "/notifications/inbox/{id}/read-status": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Update read status of a notification",
                "operationId": "update-read-status-of-a-notification",
                "parameters": [
                    {
                        "type": "string",
                        "description": "id of the notification",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/notifications/settings": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Get notifications settings",
                "operationId": "get-notifications-settings",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.NotificationsSettings"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Update notifications settings",
                "operationId": "update-notifications-settings",
                "parameters": [
                    {
                        "description": "Notifications settings request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.NotificationsSettings"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.NotificationsSettings"
                        }
                    },
                    "304": {
                        "description": "Not Modified"
                    }
                }
            }
        },
        "/notifications/templates/custom": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Get custom notification templates",
                "operationId": "get-custom-notification-templates",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.NotificationTemplate"
                            }
                        }
                    },
                    "500": {
                        "description": "Failed to retrieve 'custom' notifications template",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/notifications/templates/system": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Get system notification templates",
                "operationId": "get-system-notification-templates",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.NotificationTemplate"
                            }
                        }
                    },
                    "500": {
                        "description": "Failed to retrieve 'system' notifications template",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/notifications/templates/{notification_template}/method": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update notification template dispatch method",
                "operationId": "update-notification-template-dispatch-method",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Notification template UUID",
                        "name": "notification_template",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "Success"
                    },
                    "304": {
                        "description": "Not modified"
                    }
                }
            }
        },
        "/notifications/test": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Send a test notification",
                "operationId": "send-a-test-notification",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/oauth2-provider/apps": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get OAuth2 applications.",
                "operationId": "get-oauth2-applications",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Filter by applications authorized for a user",
                        "name": "user_id",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.OAuth2ProviderApp"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Create OAuth2 application.",
                "operationId": "create-oauth2-application",
                "parameters": [
                    {
                        "description": "The OAuth2 application to create.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PostOAuth2ProviderAppRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ProviderApp"
                        }
                    }
                }
            }
        },
        "/oauth2-provider/apps/{app}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get OAuth2 application.",
                "operationId": "get-oauth2-application",
                "parameters": [
                    {
                        "type": "string",
                        "description": "App ID",
                        "name": "app",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ProviderApp"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update OAuth2 application.",
                "operationId": "update-oauth2-application",
                "parameters": [
                    {
                        "type": "string",
                        "description": "App ID",
                        "name": "app",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update an OAuth2 application.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PutOAuth2ProviderAppRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ProviderApp"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Delete OAuth2 application.",
                "operationId": "delete-oauth2-application",
                "parameters": [
                    {
                        "type": "string",
                        "description": "App ID",
                        "name": "app",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/oauth2-provider/apps/{app}/secrets": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get OAuth2 application secrets.",
                "operationId": "get-oauth2-application-secrets",
                "parameters": [
                    {
                        "type": "string",
                        "description": "App ID",
                        "name": "app",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.OAuth2ProviderAppSecret"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Create OAuth2 application secret.",
                "operationId": "create-oauth2-application-secret",
                "parameters": [
                    {
                        "type": "string",
                        "description": "App ID",
                        "name": "app",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.OAuth2ProviderAppSecretFull"
                            }
                        }
                    }
                }
            }
        },
        "/oauth2-provider/apps/{app}/secrets/{secretID}": {
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Delete OAuth2 application secret.",
                "operationId": "delete-oauth2-application-secret",
                "parameters": [
                    {
                        "type": "string",
                        "description": "App ID",
                        "name": "app",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Secret ID",
                        "name": "secretID",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/oauth2/authorize": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "OAuth2 authorization request (GET - show authorization page).",
                "operationId": "oauth2-authorization-request-get",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Client ID",
                        "name": "client_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "A random unguessable string",
                        "name": "state",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "code",
                            "token"
                        ],
                        "type": "string",
                        "description": "Response type",
                        "name": "response_type",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Redirect here after authorization",
                        "name": "redirect_uri",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Token scopes (currently ignored)",
                        "name": "scope",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "Returns HTML authorization page"
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "OAuth2 authorization request (POST - process authorization).",
                "operationId": "oauth2-authorization-request-post",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Client ID",
                        "name": "client_id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "A random unguessable string",
                        "name": "state",
                        "in": "query",
                        "required": true
                    },
                    {
                        "enum": [
                            "code",
                            "token"
                        ],
                        "type": "string",
                        "description": "Response type",
                        "name": "response_type",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Redirect here after authorization",
                        "name": "redirect_uri",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Token scopes (currently ignored)",
                        "name": "scope",
                        "in": "query"
                    }
                ],
                "responses": {
                    "302": {
                        "description": "Returns redirect with authorization code"
                    }
                }
            }
        },
        "/oauth2/clients/{client_id}": {
            "get": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get OAuth2 client configuration (RFC 7592)",
                "operationId": "get-oauth2-client-configuration",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Client ID",
                        "name": "client_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ClientConfiguration"
                        }
                    }
                }
            },
            "put": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update OAuth2 client configuration (RFC 7592)",
                "operationId": "put-oauth2-client-configuration",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Client ID",
                        "name": "client_id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Client update request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ClientRegistrationRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ClientConfiguration"
                        }
                    }
                }
            },
            "delete": {
                "tags": [
                    "Enterprise"
                ],
                "summary": "Delete OAuth2 client registration (RFC 7592)",
                "operationId": "delete-oauth2-client-configuration",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Client ID",
                        "name": "client_id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/oauth2/register": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "OAuth2 dynamic client registration (RFC 7591)",
                "operationId": "oauth2-dynamic-client-registration",
                "parameters": [
                    {
                        "description": "Client registration request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ClientRegistrationRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuth2ClientRegistrationResponse"
                        }
                    }
                }
            }
        },
        "/oauth2/revoke": {
            "post": {
                "consumes": [
                    "application/x-www-form-urlencoded"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Revoke OAuth2 tokens (RFC 7009).",
                "operationId": "oauth2-token-revocation",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Client ID for authentication",
                        "name": "client_id",
                        "in": "formData",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "The token to revoke",
                        "name": "token",
                        "in": "formData",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Hint about token type (access_token or refresh_token)",
                        "name": "token_type_hint",
                        "in": "formData"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "Token successfully revoked"
                    }
                }
            }
        },
        "/oauth2/tokens": {
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "OAuth2 token exchange.",
                "operationId": "oauth2-token-exchange",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Client ID, required if grant_type=authorization_code",
                        "name": "client_id",
                        "in": "formData"
                    },
                    {
                        "type": "string",
                        "description": "Client secret, required if grant_type=authorization_code",
                        "name": "client_secret",
                        "in": "formData"
                    },
                    {
                        "type": "string",
                        "description": "Authorization code, required if grant_type=authorization_code",
                        "name": "code",
                        "in": "formData"
                    },
                    {
                        "type": "string",
                        "description": "Refresh token, required if grant_type=refresh_token",
                        "name": "refresh_token",
                        "in": "formData"
                    },
                    {
                        "enum": [
                            "authorization_code",
                            "refresh_token",
                            "password",
                            "client_credentials",
                            "implicit"
                        ],
                        "type": "string",
                        "description": "Grant type",
                        "name": "grant_type",
                        "in": "formData",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/oauth2.Token"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Delete OAuth2 application tokens.",
                "operationId": "delete-oauth2-application-tokens",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Client ID",
                        "name": "client_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/organizations": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organizations"
                ],
                "summary": "Get organizations",
                "operationId": "get-organizations",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Organization"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organizations"
                ],
                "summary": "Create organization",
                "operationId": "create-organization",
                "parameters": [
                    {
                        "description": "Create organization request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateOrganizationRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Organization"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organizations"
                ],
                "summary": "Get organization by ID",
                "operationId": "get-organization-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Organization"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organizations"
                ],
                "summary": "Delete organization",
                "operationId": "delete-organization",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID or name",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organizations"
                ],
                "summary": "Update organization",
                "operationId": "update-organization",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID or name",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Patch organization request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateOrganizationRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Organization"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/groups": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get groups by organization",
                "operationId": "get-groups-by-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Group"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Create group for organization",
                "operationId": "create-group-for-organization",
                "parameters": [
                    {
                        "description": "Create group request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateGroupRequest"
                        }
                    },
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Group"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/groups/{groupName}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get group by organization and group name",
                "operationId": "get-group-by-organization-and-group-name",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Group name",
                        "name": "groupName",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Group"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/members": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "List organization members",
                "operationId": "list-organization-members",
                "deprecated": true,
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.OrganizationMemberWithUserData"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/members/roles": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Get member roles by organization",
                "operationId": "get-member-roles-by-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.AssignableRoles"
                            }
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Update a custom organization role",
                "operationId": "update-a-custom-organization-role",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update role request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CustomRoleRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Role"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Insert a custom organization role",
                "operationId": "insert-a-custom-organization-role",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Insert role request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CustomRoleRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Role"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/members/roles/{roleName}": {
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Delete a custom organization role",
                "operationId": "delete-a-custom-organization-role",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Role name",
                        "name": "roleName",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Role"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/members/{user}": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Add organization member",
                "operationId": "add-organization-member",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OrganizationMember"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Remove organization member",
                "operationId": "remove-organization-member",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/organizations/{organization}/members/{user}/roles": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Assign role to organization member",
                "operationId": "assign-role-to-organization-member",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update roles request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateRoles"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OrganizationMember"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/members/{user}/workspace-quota": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get workspace quota by user",
                "operationId": "get-workspace-quota-by-user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceQuota"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/members/{user}/workspaces": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "description": "Create a new workspace using a template. The request must\nspecify either the Template ID or the Template Version ID,\nnot both. If the Template ID is specified, the active version\nof the template will be used.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Create user workspace by organization",
                "operationId": "create-user-workspace-by-organization",
                "deprecated": true,
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Username, UUID, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Create workspace request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateWorkspaceRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Workspace"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/paginated-members": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Paginated organization members",
                "operationId": "paginated-organization-members",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Page limit, if 0 returns all members",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page offset",
                        "name": "offset",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.PaginatedMembersResponse"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/provisionerdaemons": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Provisioning"
                ],
                "summary": "Get provisioner daemons",
                "operationId": "get-provisioner-daemons",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "array",
                        "format": "uuid",
                        "items": {
                            "type": "string"
                        },
                        "collectionFormat": "csv",
                        "description": "Filter results by job IDs",
                        "name": "ids",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "pending",
                            "running",
                            "succeeded",
                            "canceling",
                            "canceled",
                            "failed",
                            "unknown",
                            "pending",
                            "running",
                            "succeeded",
                            "canceling",
                            "canceled",
                            "failed"
                        ],
                        "type": "string",
                        "description": "Filter results by status",
                        "name": "status",
                        "in": "query"
                    },
                    {
                        "type": "object",
                        "description": "Provisioner tags to filter by (JSON of the form {'tag1':'value1','tag2':'value2'})",
                        "name": "tags",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.ProvisionerDaemon"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/provisionerdaemons/serve": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Serve provisioner daemon",
                "operationId": "serve-provisioner-daemon",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "101": {
                        "description": "Switching Protocols"
                    }
                }
            }
        },
        "/organizations/{organization}/provisionerjobs": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organizations"
                ],
                "summary": "Get provisioner jobs",
                "operationId": "get-provisioner-jobs",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "array",
                        "format": "uuid",
                        "items": {
                            "type": "string"
                        },
                        "collectionFormat": "csv",
                        "description": "Filter results by job IDs",
                        "name": "ids",
                        "in": "query"
                    },
                    {
                        "enum": [
                            "pending",
                            "running",
                            "succeeded",
                            "canceling",
                            "canceled",
                            "failed",
                            "unknown",
                            "pending",
                            "running",
                            "succeeded",
                            "canceling",
                            "canceled",
                            "failed"
                        ],
                        "type": "string",
                        "description": "Filter results by status",
                        "name": "status",
                        "in": "query"
                    },
                    {
                        "type": "object",
                        "description": "Provisioner tags to filter by (JSON of the form {'tag1':'value1','tag2':'value2'})",
                        "name": "tags",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Filter results by initiator",
                        "name": "initiator",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.ProvisionerJob"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/provisionerjobs/{job}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Organizations"
                ],
                "summary": "Get provisioner job",
                "operationId": "get-provisioner-job",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Job ID",
                        "name": "job",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ProvisionerJob"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/provisionerkeys": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "List provisioner key",
                "operationId": "list-provisioner-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.ProvisionerKey"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Create provisioner key",
                "operationId": "create-provisioner-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateProvisionerKeyResponse"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/provisionerkeys/daemons": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "List provisioner key daemons",
                "operationId": "list-provisioner-key-daemons",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.ProvisionerKeyDaemons"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/provisionerkeys/{provisionerkey}": {
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Delete provisioner key",
                "operationId": "delete-provisioner-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Provisioner key name",
                        "name": "provisionerkey",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/organizations/{organization}/settings/idpsync/available-fields": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get the available organization idp sync claim fields",
                "operationId": "get-the-available-organization-idp-sync-claim-fields",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/settings/idpsync/field-values": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get the organization idp sync claim field values",
                "operationId": "get-the-organization-idp-sync-claim-field-values",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "string",
                        "description": "Claim Field",
                        "name": "claimField",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/settings/idpsync/groups": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get group IdP Sync settings by organization",
                "operationId": "get-group-idp-sync-settings-by-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GroupSyncSettings"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update group IdP Sync settings by organization",
                "operationId": "update-group-idp-sync-settings-by-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "New settings",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.GroupSyncSettings"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GroupSyncSettings"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/settings/idpsync/groups/config": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update group IdP Sync config",
                "operationId": "update-group-idp-sync-config",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID or name",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "New config values",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchGroupIDPSyncConfigRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GroupSyncSettings"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/settings/idpsync/groups/mapping": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update group IdP Sync mapping",
                "operationId": "update-group-idp-sync-mapping",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID or name",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Description of the mappings to add and remove",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchGroupIDPSyncMappingRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GroupSyncSettings"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/settings/idpsync/roles": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get role IdP Sync settings by organization",
                "operationId": "get-role-idp-sync-settings-by-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.RoleSyncSettings"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update role IdP Sync settings by organization",
                "operationId": "update-role-idp-sync-settings-by-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "New settings",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.RoleSyncSettings"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.RoleSyncSettings"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/settings/idpsync/roles/config": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update role IdP Sync config",
                "operationId": "update-role-idp-sync-config",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID or name",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "New config values",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchRoleIDPSyncConfigRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.RoleSyncSettings"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/settings/idpsync/roles/mapping": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update role IdP Sync mapping",
                "operationId": "update-role-idp-sync-mapping",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID or name",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Description of the mappings to add and remove",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchRoleIDPSyncMappingRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.RoleSyncSettings"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/settings/workspace-sharing": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get workspace sharing settings for organization",
                "operationId": "get-workspace-sharing-settings-for-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceSharingSettings"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update workspace sharing settings for organization",
                "operationId": "update-workspace-sharing-settings-for-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Workspace sharing settings",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceSharingSettings"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceSharingSettings"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/templates": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "description": "Returns a list of templates for the specified organization.\nBy default, only non-deprecated templates are returned.\nTo include deprecated templates, specify ` + "`" + `deprecated:true` + "`" + ` in the search query.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get templates by organization",
                "operationId": "get-templates-by-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Template"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Create template by organization",
                "operationId": "create-template-by-organization",
                "parameters": [
                    {
                        "description": "Request body",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateTemplateRequest"
                        }
                    },
                    {
                        "type": "string",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Template"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/templates/examples": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template examples by organization",
                "operationId": "get-template-examples-by-organization",
                "deprecated": true,
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.TemplateExample"
                            }
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/templates/{templatename}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get templates by organization and template name",
                "operationId": "get-templates-by-organization-and-template-name",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Template name",
                        "name": "templatename",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Template"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/templates/{templatename}/versions/{templateversionname}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template version by organization, template, and name",
                "operationId": "get-template-version-by-organization-template-and-name",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Template name",
                        "name": "templatename",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Template version name",
                        "name": "templateversionname",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TemplateVersion"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/templates/{templatename}/versions/{templateversionname}/previous": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get previous template version by organization, template, and name",
                "operationId": "get-previous-template-version-by-organization-template-and-name",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Template name",
                        "name": "templatename",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Template version name",
                        "name": "templateversionname",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TemplateVersion"
                        }
                    }
                }
            }
        },
        "/organizations/{organization}/templateversions": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Create template version by organization",
                "operationId": "create-template-version-by-organization",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Create template version request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateTemplateVersionRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TemplateVersion"
                        }
                    }
                }
            }
        },
        "/prebuilds/settings": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prebuilds"
                ],
                "summary": "Get prebuilds settings",
                "operationId": "get-prebuilds-settings",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.PrebuildsSettings"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Prebuilds"
                ],
                "summary": "Update prebuilds settings",
                "operationId": "update-prebuilds-settings",
                "parameters": [
                    {
                        "description": "Prebuilds settings request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PrebuildsSettings"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.PrebuildsSettings"
                        }
                    },
                    "304": {
                        "description": "Not Modified"
                    }
                }
            }
        },
        "/provisionerkeys/{provisionerkey}": {
            "get": {
                "security": [
                    {
                        "CoderProvisionerKey": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Fetch provisioner key details",
                "operationId": "fetch-provisioner-key-details",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Provisioner Key",
                        "name": "provisionerkey",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ProvisionerKey"
                        }
                    }
                }
            }
        },
        "/regions": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "WorkspaceProxies"
                ],
                "summary": "Get site-wide regions for workspace connections",
                "operationId": "get-site-wide-regions-for-workspace-connections",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.RegionsResponse-codersdk_Region"
                        }
                    }
                }
            }
        },
        "/replicas": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get active replicas",
                "operationId": "get-active-replicas",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Replica"
                            }
                        }
                    }
                }
            }
        },
        "/scim/v2/ServiceProviderConfig": {
            "get": {
                "produces": [
                    "application/scim+json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "SCIM 2.0: Service Provider Config",
                "operationId": "scim-get-service-provider-config",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/scim/v2/Users": {
            "get": {
                "security": [
                    {
                        "Authorization": []
                    }
                ],
                "produces": [
                    "application/scim+json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "SCIM 2.0: Get users",
                "operationId": "scim-get-users",
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "Authorization": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "SCIM 2.0: Create new user",
                "operationId": "scim-create-new-user",
                "parameters": [
                    {
                        "description": "New user",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/coderd.SCIMUser"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/coderd.SCIMUser"
                        }
                    }
                }
            }
        },
        "/scim/v2/Users/{id}": {
            "get": {
                "security": [
                    {
                        "Authorization": []
                    }
                ],
                "produces": [
                    "application/scim+json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "SCIM 2.0: Get user by ID",
                "operationId": "scim-get-user-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "User ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "404": {
                        "description": "Not Found"
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "Authorization": []
                    }
                ],
                "produces": [
                    "application/scim+json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "SCIM 2.0: Replace user account",
                "operationId": "scim-replace-user-status",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "User ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Replace user request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/coderd.SCIMUser"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "Authorization": []
                    }
                ],
                "produces": [
                    "application/scim+json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "SCIM 2.0: Update user account",
                "operationId": "scim-update-user-status",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "User ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update user request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/coderd.SCIMUser"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            }
        },
        "/settings/idpsync/available-fields": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get the available idp sync claim fields",
                "operationId": "get-the-available-idp-sync-claim-fields",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/settings/idpsync/field-values": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get the idp sync claim field values",
                "operationId": "get-the-idp-sync-claim-field-values",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Organization ID",
                        "name": "organization",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "string",
                        "description": "Claim Field",
                        "name": "claimField",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "/settings/idpsync/organization": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get organization IdP Sync settings",
                "operationId": "get-organization-idp-sync-settings",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OrganizationSyncSettings"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update organization IdP Sync settings",
                "operationId": "update-organization-idp-sync-settings",
                "parameters": [
                    {
                        "description": "New settings",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.OrganizationSyncSettings"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OrganizationSyncSettings"
                        }
                    }
                }
            }
        },
        "/settings/idpsync/organization/config": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update organization IdP Sync config",
                "operationId": "update-organization-idp-sync-config",
                "parameters": [
                    {
                        "description": "New config values",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchOrganizationIDPSyncConfigRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OrganizationSyncSettings"
                        }
                    }
                }
            }
        },
        "/settings/idpsync/organization/mapping": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update organization IdP Sync mapping",
                "operationId": "update-organization-idp-sync-mapping",
                "parameters": [
                    {
                        "description": "Description of the mappings to add and remove",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchOrganizationIDPSyncMappingRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OrganizationSyncSettings"
                        }
                    }
                }
            }
        },
        "/tailnet": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "User-scoped tailnet RPC connection",
                "operationId": "user-scoped-tailnet-rpc-connection",
                "responses": {
                    "101": {
                        "description": "Switching Protocols"
                    }
                }
            }
        },
        "/tasks": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tasks"
                ],
                "summary": "List AI tasks",
                "operationId": "list-ai-tasks",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Search query for filtering tasks. Supports: owner:\u003cusername/uuid/me\u003e, organization:\u003corg-name/uuid\u003e, status:\u003cstatus\u003e",
                        "name": "q",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TasksListResponse"
                        }
                    }
                }
            }
        },
        "/tasks/{user}": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tasks"
                ],
                "summary": "Create a new AI task",
                "operationId": "create-a-new-ai-task",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Username, user ID, or 'me' for the authenticated user",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Create task request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateTaskRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Task"
                        }
                    }
                }
            }
        },
        "/tasks/{user}/{task}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tasks"
                ],
                "summary": "Get AI task by ID or name",
                "operationId": "get-ai-task-by-id-or-name",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Username, user ID, or 'me' for the authenticated user",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Task ID, or task name",
                        "name": "task",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Task"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Tasks"
                ],
                "summary": "Delete AI task",
                "operationId": "delete-ai-task",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Username, user ID, or 'me' for the authenticated user",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Task ID, or task name",
                        "name": "task",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "202": {
                        "description": "Accepted"
                    }
                }
            }
        },
        "/tasks/{user}/{task}/input": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Tasks"
                ],
                "summary": "Update AI task input",
                "operationId": "update-ai-task-input",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Username, user ID, or 'me' for the authenticated user",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Task ID, or task name",
                        "name": "task",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update task input request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateTaskInputRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/tasks/{user}/{task}/logs": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tasks"
                ],
                "summary": "Get AI task logs",
                "operationId": "get-ai-task-logs",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Username, user ID, or 'me' for the authenticated user",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Task ID, or task name",
                        "name": "task",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TaskLogsResponse"
                        }
                    }
                }
            }
        },
        "/tasks/{user}/{task}/send": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Tasks"
                ],
                "summary": "Send input to AI task",
                "operationId": "send-input-to-ai-task",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Username, user ID, or 'me' for the authenticated user",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Task ID, or task name",
                        "name": "task",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Task input request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.TaskSendRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/templates": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "description": "Returns a list of templates.\nBy default, only non-deprecated templates are returned.\nTo include deprecated templates, specify ` + "`" + `deprecated:true` + "`" + ` in the search query.",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get all templates",
                "operationId": "get-all-templates",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Template"
                            }
                        }
                    }
                }
            }
        },
        "/templates/examples": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template examples",
                "operationId": "get-template-examples",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.TemplateExample"
                            }
                        }
                    }
                }
            }
        },
        "/templates/{template}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template settings by ID",
                "operationId": "get-template-settings-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Template"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Delete template by ID",
                "operationId": "delete-template-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Update template settings by ID",
                "operationId": "update-template-settings-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Patch template settings request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateTemplateMeta"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Template"
                        }
                    }
                }
            }
        },
        "/templates/{template}/acl": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get template ACLs",
                "operationId": "get-template-acls",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TemplateACL"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update template ACL",
                "operationId": "update-template-acl",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update template ACL request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateTemplateACL"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/templates/{template}/acl/available": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get template available acl users/groups",
                "operationId": "get-template-available-acl-usersgroups",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.ACLAvailable"
                            }
                        }
                    }
                }
            }
        },
        "/templates/{template}/daus": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template DAUs by ID",
                "operationId": "get-template-daus-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.DAUsResponse"
                        }
                    }
                }
            }
        },
        "/templates/{template}/prebuilds/invalidate": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Invalidate presets for template",
                "operationId": "invalidate-presets-for-template",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.InvalidatePresetsResponse"
                        }
                    }
                }
            }
        },
        "/templates/{template}/versions": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "List template versions by template ID",
                "operationId": "list-template-versions-by-template-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "After ID",
                        "name": "after_id",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Include archived versions in the list",
                        "name": "include_archived",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page offset",
                        "name": "offset",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.TemplateVersion"
                            }
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Update active template version by template ID",
                "operationId": "update-active-template-version-by-template-id",
                "parameters": [
                    {
                        "description": "Modified template version",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateActiveTemplateVersion"
                        }
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/templates/{template}/versions/archive": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Archive template unused versions by template id",
                "operationId": "archive-template-unused-versions-by-template-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Archive request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.ArchiveTemplateVersionsRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/templates/{template}/versions/{templateversionname}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template version by template ID and name",
                "operationId": "get-template-version-by-template-id-and-name",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template ID",
                        "name": "template",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Template version name",
                        "name": "templateversionname",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.TemplateVersion"
                            }
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template version by ID",
                "operationId": "get-template-version-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TemplateVersion"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Patch template version by ID",
                "operationId": "patch-template-version-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Patch template version request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchTemplateVersionRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TemplateVersion"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/archive": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Archive template version",
                "operationId": "archive-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/cancel": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Cancel template version by ID",
                "operationId": "cancel-template-version-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/dry-run": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Create template version dry-run",
                "operationId": "create-template-version-dry-run",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Dry-run request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateTemplateVersionDryRunRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ProvisionerJob"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/dry-run/{jobID}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template version dry-run by job ID",
                "operationId": "get-template-version-dry-run-by-job-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Job ID",
                        "name": "jobID",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ProvisionerJob"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/dry-run/{jobID}/cancel": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Cancel template version dry-run by job ID",
                "operationId": "cancel-template-version-dry-run-by-job-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Job ID",
                        "name": "jobID",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/dry-run/{jobID}/logs": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template version dry-run logs by job ID",
                "operationId": "get-template-version-dry-run-logs-by-job-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Job ID",
                        "name": "jobID",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Before Unix timestamp",
                        "name": "before",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "After Unix timestamp",
                        "name": "after",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Follow log stream",
                        "name": "follow",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.ProvisionerJobLog"
                            }
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/dry-run/{jobID}/matched-provisioners": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template version dry-run matched provisioners",
                "operationId": "get-template-version-dry-run-matched-provisioners",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Job ID",
                        "name": "jobID",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.MatchedProvisioners"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/dry-run/{jobID}/resources": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template version dry-run resources by job ID",
                "operationId": "get-template-version-dry-run-resources-by-job-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Job ID",
                        "name": "jobID",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.WorkspaceResource"
                            }
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/dynamic-parameters": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Open dynamic parameters WebSocket by template version",
                "operationId": "open-dynamic-parameters-websocket-by-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "101": {
                        "description": "Switching Protocols"
                    }
                }
            }
        },
        "/templateversions/{templateversion}/dynamic-parameters/evaluate": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Evaluate dynamic parameters for template version",
                "operationId": "evaluate-dynamic-parameters-for-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Initial parameter values",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.DynamicParametersRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.DynamicParametersResponse"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/external-auth": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get external auth by template version",
                "operationId": "get-external-auth-by-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.TemplateVersionExternalAuth"
                            }
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/logs": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get logs by template version",
                "operationId": "get-logs-by-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Before log id",
                        "name": "before",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "After log id",
                        "name": "after",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Follow log stream",
                        "name": "follow",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.ProvisionerJobLog"
                            }
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/parameters": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Removed: Get parameters by template version",
                "operationId": "removed-get-parameters-by-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/templateversions/{templateversion}/presets": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template version presets",
                "operationId": "get-template-version-presets",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Preset"
                            }
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/resources": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get resources by template version",
                "operationId": "get-resources-by-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.WorkspaceResource"
                            }
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/rich-parameters": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get rich parameters by template version",
                "operationId": "get-rich-parameters-by-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.TemplateVersionParameter"
                            }
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/schema": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Removed: Get schema by template version",
                "operationId": "removed-get-schema-by-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/templateversions/{templateversion}/unarchive": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Unarchive template version",
                "operationId": "unarchive-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/templateversions/{templateversion}/variables": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Templates"
                ],
                "summary": "Get template variables by template version",
                "operationId": "get-template-variables-by-template-version",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Template version ID",
                        "name": "templateversion",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.TemplateVersionVariable"
                            }
                        }
                    }
                }
            }
        },
        "/updatecheck": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "Update check",
                "operationId": "update-check",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateCheckResponse"
                        }
                    }
                }
            }
        },
        "/users": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get users",
                "operationId": "get-users",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Search query",
                        "name": "q",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "After ID",
                        "name": "after_id",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page offset",
                        "name": "offset",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GetUsersResponse"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Create new user",
                "operationId": "create-new-user",
                "parameters": [
                    {
                        "description": "Create user request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateUserRequestWithOrgs"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            }
        },
        "/users/authmethods": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get authentication methods",
                "operationId": "get-authentication-methods",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.AuthMethods"
                        }
                    }
                }
            }
        },
        "/users/first": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Check initial user created",
                "operationId": "check-initial-user-created",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Create initial user",
                "operationId": "create-initial-user",
                "parameters": [
                    {
                        "description": "First user request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateFirstUserRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateFirstUserResponse"
                        }
                    }
                }
            }
        },
        "/users/login": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Authorization"
                ],
                "summary": "Log in user",
                "operationId": "log-in-user",
                "parameters": [
                    {
                        "description": "Login request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.LoginWithPasswordRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.LoginWithPasswordResponse"
                        }
                    }
                }
            }
        },
        "/users/logout": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Log out user",
                "operationId": "log-out-user",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/users/oauth2/github/callback": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Users"
                ],
                "summary": "OAuth 2.0 GitHub Callback",
                "operationId": "oauth-20-github-callback",
                "responses": {
                    "307": {
                        "description": "Temporary Redirect"
                    }
                }
            }
        },
        "/users/oauth2/github/device": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get Github device auth.",
                "operationId": "get-github-device-auth",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ExternalAuthDevice"
                        }
                    }
                }
            }
        },
        "/users/oidc/callback": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Users"
                ],
                "summary": "OpenID Connect Callback",
                "operationId": "openid-connect-callback",
                "responses": {
                    "307": {
                        "description": "Temporary Redirect"
                    }
                }
            }
        },
        "/users/otp/change-password": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Authorization"
                ],
                "summary": "Change password with a one-time passcode",
                "operationId": "change-password-with-a-one-time-passcode",
                "parameters": [
                    {
                        "description": "Change password request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.ChangePasswordWithOneTimePasscodeRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/users/otp/request": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Authorization"
                ],
                "summary": "Request one-time passcode",
                "operationId": "request-one-time-passcode",
                "parameters": [
                    {
                        "description": "One-time passcode request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.RequestOneTimePasscodeRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/users/roles": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Members"
                ],
                "summary": "Get site member roles",
                "operationId": "get-site-member-roles",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.AssignableRoles"
                            }
                        }
                    }
                }
            }
        },
        "/users/validate-password": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Authorization"
                ],
                "summary": "Validate user password",
                "operationId": "validate-user-password",
                "parameters": [
                    {
                        "description": "Validate user password request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.ValidateUserPasswordRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ValidateUserPasswordResponse"
                        }
                    }
                }
            }
        },
        "/users/{user}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get user by name",
                "operationId": "get-user-by-name",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, username, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Delete user",
                "operationId": "delete-user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/users/{user}/appearance": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get user appearance settings",
                "operationId": "get-user-appearance-settings",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UserAppearanceSettings"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Update user appearance settings",
                "operationId": "update-user-appearance-settings",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "New appearance settings",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateUserAppearanceSettingsRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UserAppearanceSettings"
                        }
                    }
                }
            }
        },
        "/users/{user}/autofill-parameters": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get autofill build parameters for user",
                "operationId": "get-autofill-build-parameters-for-user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, username, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Template ID",
                        "name": "template_id",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.UserParameter"
                            }
                        }
                    }
                }
            }
        },
        "/users/{user}/convert-login": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Authorization"
                ],
                "summary": "Convert user from password to oauth authentication",
                "operationId": "convert-user-from-password-to-oauth-authentication",
                "parameters": [
                    {
                        "description": "Convert request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.ConvertLoginRequest"
                        }
                    },
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.OAuthConversionResponse"
                        }
                    }
                }
            }
        },
        "/users/{user}/gitsshkey": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get user Git SSH key",
                "operationId": "get-user-git-ssh-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GitSSHKey"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Regenerate user SSH key",
                "operationId": "regenerate-user-ssh-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GitSSHKey"
                        }
                    }
                }
            }
        },
        "/users/{user}/keys": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Create new session key",
                "operationId": "create-new-session-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GenerateAPIKeyResponse"
                        }
                    }
                }
            }
        },
        "/users/{user}/keys/tokens": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get user tokens",
                "operationId": "get-user-tokens",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.APIKey"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Create token API key",
                "operationId": "create-token-api-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Create token request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateTokenRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.GenerateAPIKeyResponse"
                        }
                    }
                }
            }
        },
        "/users/{user}/keys/tokens/tokenconfig": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "General"
                ],
                "summary": "Get token config",
                "operationId": "get-token-config",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.TokenConfig"
                        }
                    }
                }
            }
        },
        "/users/{user}/keys/tokens/{keyname}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get API key by token name",
                "operationId": "get-api-key-by-token-name",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "string",
                        "description": "Key Name",
                        "name": "keyname",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.APIKey"
                        }
                    }
                }
            }
        },
        "/users/{user}/keys/{keyid}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get API key by ID",
                "operationId": "get-api-key-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "string",
                        "description": "Key ID",
                        "name": "keyid",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.APIKey"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Delete API key",
                "operationId": "delete-api-key",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "string",
                        "description": "Key ID",
                        "name": "keyid",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/users/{user}/login-type": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get user login type",
                "operationId": "get-user-login-type",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UserLoginType"
                        }
                    }
                }
            }
        },
        "/users/{user}/notifications/preferences": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Get user notification preferences",
                "operationId": "get-user-notification-preferences",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.NotificationPreference"
                            }
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Update user notification preferences",
                "operationId": "update-user-notification-preferences",
                "parameters": [
                    {
                        "description": "Preferences",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateUserNotificationPreferences"
                        }
                    },
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.NotificationPreference"
                            }
                        }
                    }
                }
            }
        },
        "/users/{user}/organizations": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get organizations by user",
                "operationId": "get-organizations-by-user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.Organization"
                            }
                        }
                    }
                }
            }
        },
        "/users/{user}/organizations/{organizationname}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get organization by user and organization name",
                "operationId": "get-organization-by-user-and-organization-name",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Organization name",
                        "name": "organizationname",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Organization"
                        }
                    }
                }
            }
        },
        "/users/{user}/password": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Update user password",
                "operationId": "update-user-password",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update password request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateUserPasswordRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/users/{user}/preferences": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get user preference settings",
                "operationId": "get-user-preference-settings",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UserPreferenceSettings"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Update user preference settings",
                "operationId": "update-user-preference-settings",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "New preference settings",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateUserPreferenceSettingsRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.UserPreferenceSettings"
                        }
                    }
                }
            }
        },
        "/users/{user}/profile": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Update user profile",
                "operationId": "update-user-profile",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Updated profile",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateUserProfileRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            }
        },
        "/users/{user}/quiet-hours": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get user quiet hours schedule",
                "operationId": "get-user-quiet-hours-schedule",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "User ID",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.UserQuietHoursScheduleResponse"
                            }
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update user quiet hours schedule",
                "operationId": "update-user-quiet-hours-schedule",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "User ID",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update schedule request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateUserQuietHoursScheduleRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.UserQuietHoursScheduleResponse"
                            }
                        }
                    }
                }
            }
        },
        "/users/{user}/roles": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Get user roles",
                "operationId": "get-user-roles",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Assign role to user",
                "operationId": "assign-role-to-user",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update roles request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateRoles"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            }
        },
        "/users/{user}/status/activate": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Activate user account",
                "operationId": "activate-user-account",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            }
        },
        "/users/{user}/status/suspend": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Users"
                ],
                "summary": "Suspend user account",
                "operationId": "suspend-user-account",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    }
                }
            }
        },
        "/users/{user}/webpush/subscription": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Create user webpush subscription",
                "operationId": "create-user-webpush-subscription",
                "parameters": [
                    {
                        "description": "Webpush subscription",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.WebpushSubscription"
                        }
                    },
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Delete user webpush subscription",
                "operationId": "delete-user-webpush-subscription",
                "parameters": [
                    {
                        "description": "Webpush subscription",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.DeleteWebpushSubscription"
                        }
                    },
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/users/{user}/webpush/test": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Notifications"
                ],
                "summary": "Send a test push notification",
                "operationId": "send-a-test-push-notification",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/users/{user}/workspace/{workspacename}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Get workspace metadata by user and workspace name",
                "operationId": "get-workspace-metadata-by-user-and-workspace-name",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Workspace name",
                        "name": "workspacename",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "Return data instead of HTTP 404 if the workspace is deleted",
                        "name": "include_deleted",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Workspace"
                        }
                    }
                }
            }
        },
        "/users/{user}/workspace/{workspacename}/builds/{buildnumber}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Get workspace build by user, workspace name, and build number",
                "operationId": "get-workspace-build-by-user-workspace-name-and-build-number",
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Workspace name",
                        "name": "workspacename",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "number",
                        "description": "Build number",
                        "name": "buildnumber",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceBuild"
                        }
                    }
                }
            }
        },
        "/users/{user}/workspaces": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "description": "Create a new workspace using a template. The request must\nspecify either the Template ID or the Template Version ID,\nnot both. If the Template ID is specified, the active version\nof the template will be used.",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Create user workspace",
                "operationId": "create-user-workspace",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Username, UUID, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Create workspace request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateWorkspaceRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Workspace"
                        }
                    }
                }
            }
        },
        "/workspace-quota/{user}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get workspace quota by user deprecated",
                "operationId": "get-workspace-quota-by-user-deprecated",
                "deprecated": true,
                "parameters": [
                    {
                        "type": "string",
                        "description": "User ID, name, or me",
                        "name": "user",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceQuota"
                        }
                    }
                }
            }
        },
        "/workspaceagents/aws-instance-identity": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Authenticate agent on AWS instance",
                "operationId": "authenticate-agent-on-aws-instance",
                "parameters": [
                    {
                        "description": "Instance identity token",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/agentsdk.AWSInstanceIdentityToken"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/agentsdk.AuthenticateResponse"
                        }
                    }
                }
            }
        },
        "/workspaceagents/azure-instance-identity": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Authenticate agent on Azure instance",
                "operationId": "authenticate-agent-on-azure-instance",
                "parameters": [
                    {
                        "description": "Instance identity token",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/agentsdk.AzureInstanceIdentityToken"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/agentsdk.AuthenticateResponse"
                        }
                    }
                }
            }
        },
        "/workspaceagents/connection": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get connection info for workspace agent generic",
                "operationId": "get-connection-info-for-workspace-agent-generic",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/workspacesdk.AgentConnectionInfo"
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceagents/google-instance-identity": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Authenticate agent on Google Cloud instance",
                "operationId": "authenticate-agent-on-google-cloud-instance",
                "parameters": [
                    {
                        "description": "Instance identity token",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/agentsdk.GoogleInstanceIdentityToken"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/agentsdk.AuthenticateResponse"
                        }
                    }
                }
            }
        },
        "/workspaceagents/me/app-status": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Patch workspace agent app status",
                "operationId": "patch-workspace-agent-app-status",
                "parameters": [
                    {
                        "description": "app status",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/agentsdk.PatchAppStatus"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/workspaceagents/me/external-auth": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get workspace agent external auth",
                "operationId": "get-workspace-agent-external-auth",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Match",
                        "name": "match",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Provider ID",
                        "name": "id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "Wait for a new token to be issued",
                        "name": "listen",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/agentsdk.ExternalAuthResponse"
                        }
                    }
                }
            }
        },
        "/workspaceagents/me/gitauth": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Removed: Get workspace agent git auth",
                "operationId": "removed-get-workspace-agent-git-auth",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Match",
                        "name": "match",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Provider ID",
                        "name": "id",
                        "in": "query",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "Wait for a new token to be issued",
                        "name": "listen",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/agentsdk.ExternalAuthResponse"
                        }
                    }
                }
            }
        },
        "/workspaceagents/me/gitsshkey": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get workspace agent Git SSH key",
                "operationId": "get-workspace-agent-git-ssh-key",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/agentsdk.GitSSHKey"
                        }
                    }
                }
            }
        },
        "/workspaceagents/me/log-source": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Post workspace agent log source",
                "operationId": "post-workspace-agent-log-source",
                "parameters": [
                    {
                        "description": "Log source request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/agentsdk.PostLogSourceRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentLogSource"
                        }
                    }
                }
            }
        },
        "/workspaceagents/me/logs": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Patch workspace agent logs",
                "operationId": "patch-workspace-agent-logs",
                "parameters": [
                    {
                        "description": "logs",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/agentsdk.PatchLogs"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/workspaceagents/me/reinit": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get workspace agent reinitialization",
                "operationId": "get-workspace-agent-reinitialization",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/agentsdk.ReinitializationEvent"
                        }
                    }
                }
            }
        },
        "/workspaceagents/me/rpc": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Workspace agent RPC API",
                "operationId": "workspace-agent-rpc-api",
                "responses": {
                    "101": {
                        "description": "Switching Protocols"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceagents/me/tasks/{task}/log-snapshot": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Tasks"
                ],
                "summary": "Upload task log snapshot",
                "operationId": "upload-task-log-snapshot",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Task ID",
                        "name": "task",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            "agentapi"
                        ],
                        "type": "string",
                        "description": "Snapshot format",
                        "name": "format",
                        "in": "query",
                        "required": true
                    },
                    {
                        "description": "Raw snapshot payload (structure depends on format parameter)",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "type": "object"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get workspace agent by ID",
                "operationId": "get-workspace-agent-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceAgent"
                        }
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/connection": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get connection info for workspace agent",
                "operationId": "get-connection-info-for-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/workspacesdk.AgentConnectionInfo"
                        }
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/containers": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get running containers for workspace agent",
                "operationId": "get-running-containers-for-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "key=value",
                        "description": "Labels",
                        "name": "label",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentListContainersResponse"
                        }
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/containers/devcontainers/{devcontainer}": {
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Delete devcontainer for workspace agent",
                "operationId": "delete-devcontainer-for-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Devcontainer ID",
                        "name": "devcontainer",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/containers/devcontainers/{devcontainer}/recreate": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Recreate devcontainer for workspace agent",
                "operationId": "recreate-devcontainer-for-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Devcontainer ID",
                        "name": "devcontainer",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "202": {
                        "description": "Accepted",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/containers/watch": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Watch workspace agent for container updates.",
                "operationId": "watch-workspace-agent-for-container-updates",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentListContainersResponse"
                        }
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/coordinate": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Coordinate workspace agent",
                "operationId": "coordinate-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "101": {
                        "description": "Switching Protocols"
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/listening-ports": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get listening ports for workspace agent",
                "operationId": "get-listening-ports-for-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentListeningPortsResponse"
                        }
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/logs": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Get logs by workspace agent",
                "operationId": "get-logs-by-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Before log id",
                        "name": "before",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "After log id",
                        "name": "after",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Follow log stream",
                        "name": "follow",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Disable compression for WebSocket connection",
                        "name": "no_compression",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.WorkspaceAgentLog"
                            }
                        }
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/pty": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Open PTY to workspace agent",
                "operationId": "open-pty-to-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "101": {
                        "description": "Switching Protocols"
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/startup-logs": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Removed: Get logs by workspace agent",
                "operationId": "removed-get-logs-by-workspace-agent",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Before log id",
                        "name": "before",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "After log id",
                        "name": "after",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Follow log stream",
                        "name": "follow",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Disable compression for WebSocket connection",
                        "name": "no_compression",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.WorkspaceAgentLog"
                            }
                        }
                    }
                }
            }
        },
        "/workspaceagents/{workspaceagent}/watch-metadata": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Watch for workspace agent metadata updates",
                "operationId": "watch-for-workspace-agent-metadata-updates",
                "deprecated": true,
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "Success"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceagents/{workspaceagent}/watch-metadata-ws": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Agents"
                ],
                "summary": "Watch for workspace agent metadata updates via WebSockets",
                "operationId": "watch-for-workspace-agent-metadata-updates-via-websockets",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace agent ID",
                        "name": "workspaceagent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ServerSentEvent"
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspacebuilds/{workspacebuild}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Get workspace build",
                "operationId": "get-workspace-build",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Workspace build ID",
                        "name": "workspacebuild",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceBuild"
                        }
                    }
                }
            }
        },
        "/workspacebuilds/{workspacebuild}/cancel": {
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Cancel workspace build",
                "operationId": "cancel-workspace-build",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Workspace build ID",
                        "name": "workspacebuild",
                        "in": "path",
                        "required": true
                    },
                    {
                        "enum": [
                            "running",
                            "pending"
                        ],
                        "type": "string",
                        "description": "Expected status of the job. If expect_status is supplied, the request will be rejected with 412 Precondition Failed if the job doesn't match the state when performing the cancellation.",
                        "name": "expect_status",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/workspacebuilds/{workspacebuild}/logs": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Get workspace build logs",
                "operationId": "get-workspace-build-logs",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Workspace build ID",
                        "name": "workspacebuild",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "integer",
                        "description": "Before log id",
                        "name": "before",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "After log id",
                        "name": "after",
                        "in": "query"
                    },
                    {
                        "type": "boolean",
                        "description": "Follow log stream",
                        "name": "follow",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.ProvisionerJobLog"
                            }
                        }
                    }
                }
            }
        },
        "/workspacebuilds/{workspacebuild}/parameters": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Get build parameters for workspace build",
                "operationId": "get-build-parameters-for-workspace-build",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Workspace build ID",
                        "name": "workspacebuild",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.WorkspaceBuildParameter"
                            }
                        }
                    }
                }
            }
        },
        "/workspacebuilds/{workspacebuild}/resources": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Removed: Get workspace resources for workspace build",
                "operationId": "removed-get-workspace-resources-for-workspace-build",
                "deprecated": true,
                "parameters": [
                    {
                        "type": "string",
                        "description": "Workspace build ID",
                        "name": "workspacebuild",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.WorkspaceResource"
                            }
                        }
                    }
                }
            }
        },
        "/workspacebuilds/{workspacebuild}/state": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Get provisioner state for workspace build",
                "operationId": "get-provisioner-state-for-workspace-build",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Workspace build ID",
                        "name": "workspacebuild",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceBuild"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Update workspace build state",
                "operationId": "update-workspace-build-state",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace build ID",
                        "name": "workspacebuild",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Request body",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateWorkspaceBuildStateRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspacebuilds/{workspacebuild}/timings": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Get workspace build timings by ID",
                "operationId": "get-workspace-build-timings-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace build ID",
                        "name": "workspacebuild",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceBuildTimings"
                        }
                    }
                }
            }
        },
        "/workspaceproxies": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get workspace proxies",
                "operationId": "get-workspace-proxies",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.RegionsResponse-codersdk_WorkspaceProxy"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Create workspace proxy",
                "operationId": "create-workspace-proxy",
                "parameters": [
                    {
                        "description": "Create workspace proxy request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateWorkspaceProxyRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceProxy"
                        }
                    }
                }
            }
        },
        "/workspaceproxies/me/app-stats": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Report workspace app stats",
                "operationId": "report-workspace-app-stats",
                "parameters": [
                    {
                        "description": "Report app stats request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/wsproxysdk.ReportAppStatsRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceproxies/me/coordinate": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Workspace Proxy Coordinate",
                "operationId": "workspace-proxy-coordinate",
                "responses": {
                    "101": {
                        "description": "Switching Protocols"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceproxies/me/crypto-keys": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get workspace proxy crypto keys",
                "operationId": "get-workspace-proxy-crypto-keys",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Feature key",
                        "name": "feature",
                        "in": "query",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/wsproxysdk.CryptoKeysResponse"
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceproxies/me/deregister": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Deregister workspace proxy",
                "operationId": "deregister-workspace-proxy",
                "parameters": [
                    {
                        "description": "Deregister workspace proxy request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/wsproxysdk.DeregisterWorkspaceProxyRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceproxies/me/issue-signed-app-token": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Issue signed workspace app token",
                "operationId": "issue-signed-workspace-app-token",
                "parameters": [
                    {
                        "description": "Issue signed app token request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/workspaceapps.IssueTokenRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/wsproxysdk.IssueSignedAppTokenResponse"
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceproxies/me/register": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Register workspace proxy",
                "operationId": "register-workspace-proxy",
                "parameters": [
                    {
                        "description": "Register workspace proxy request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/wsproxysdk.RegisterWorkspaceProxyRequest"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/wsproxysdk.RegisterWorkspaceProxyResponse"
                        }
                    }
                },
                "x-apidocgen": {
                    "skip": true
                }
            }
        },
        "/workspaceproxies/{workspaceproxy}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get workspace proxy",
                "operationId": "get-workspace-proxy",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Proxy ID or name",
                        "name": "workspaceproxy",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceProxy"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Delete workspace proxy",
                "operationId": "delete-workspace-proxy",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Proxy ID or name",
                        "name": "workspaceproxy",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Update workspace proxy",
                "operationId": "update-workspace-proxy",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Proxy ID or name",
                        "name": "workspaceproxy",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update workspace proxy request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PatchWorkspaceProxy"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceProxy"
                        }
                    }
                }
            }
        },
        "/workspaces": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "List workspaces",
                "operationId": "list-workspaces",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Search query in the format ` + "`" + `key:value` + "`" + `. Available keys are: owner, template, name, status, has-agent, dormant, last_used_after, last_used_before, has-ai-task, has_external_agent.",
                        "name": "q",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page offset",
                        "name": "offset",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspacesResponse"
                        }
                    }
                }
            }
        },
        "/workspaces/{workspace}": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Get workspace metadata by ID",
                "operationId": "get-workspace-metadata-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "boolean",
                        "description": "Return data instead of HTTP 404 if the workspace is deleted",
                        "name": "include_deleted",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Workspace"
                        }
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Update workspace metadata by ID",
                "operationId": "update-workspace-metadata-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Metadata update request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateWorkspaceRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaces/{workspace}/acl": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Get workspace ACLs",
                "operationId": "get-workspace-acls",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceACL"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Completely clears the workspace's user and group ACLs.",
                "operationId": "completely-clears-the-workspaces-user-and-group-acls",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "patch": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Update workspace ACL",
                "operationId": "update-workspace-acl",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Update workspace ACL request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateWorkspaceACL"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaces/{workspace}/autostart": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Update workspace autostart schedule by ID",
                "operationId": "update-workspace-autostart-schedule-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Schedule update request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateWorkspaceAutostartRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaces/{workspace}/autoupdates": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Update workspace automatic updates by ID",
                "operationId": "update-workspace-automatic-updates-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Automatic updates request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateWorkspaceAutomaticUpdatesRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaces/{workspace}/builds": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Get workspace builds by workspace ID",
                "operationId": "get-workspace-builds-by-workspace-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "After ID",
                        "name": "after_id",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page limit",
                        "name": "limit",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page offset",
                        "name": "offset",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "format": "date-time",
                        "description": "Since timestamp",
                        "name": "since",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/codersdk.WorkspaceBuild"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Builds"
                ],
                "summary": "Create workspace build",
                "operationId": "create-workspace-build",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Create workspace build request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.CreateWorkspaceBuildRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceBuild"
                        }
                    }
                }
            }
        },
        "/workspaces/{workspace}/dormant": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Update workspace dormancy status by id.",
                "operationId": "update-workspace-dormancy-status-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Make a workspace dormant or active",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateWorkspaceDormancy"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Workspace"
                        }
                    }
                }
            }
        },
        "/workspaces/{workspace}/extend": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Extend workspace deadline by ID",
                "operationId": "extend-workspace-deadline-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Extend deadline update request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.PutExtendWorkspaceRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/workspaces/{workspace}/external-agent/{agent}/credentials": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Enterprise"
                ],
                "summary": "Get workspace external agent credentials",
                "operationId": "get-workspace-external-agent-credentials",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "type": "string",
                        "description": "Agent name",
                        "name": "agent",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ExternalAgentCredentials"
                        }
                    }
                }
            }
        },
        "/workspaces/{workspace}/favorite": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Favorite workspace by ID.",
                "operationId": "favorite-workspace-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Unfavorite workspace by ID.",
                "operationId": "unfavorite-workspace-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaces/{workspace}/port-share": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "PortSharing"
                ],
                "summary": "Get workspace agent port shares",
                "operationId": "get-workspace-agent-port-shares",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentPortShares"
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "PortSharing"
                ],
                "summary": "Upsert workspace agent port share",
                "operationId": "upsert-workspace-agent-port-share",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Upsert port sharing level request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpsertWorkspaceAgentPortShareRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentPortShare"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "PortSharing"
                ],
                "summary": "Delete workspace agent port share",
                "operationId": "delete-workspace-agent-port-share",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Delete port sharing level request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.DeleteWorkspaceAgentPortShareRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/workspaces/{workspace}/resolve-autostart": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Resolve workspace autostart by id.",
                "operationId": "resolve-workspace-autostart-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ResolveAutostartResponse"
                        }
                    }
                }
            }
        },
        "/workspaces/{workspace}/timings": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Get workspace timings by ID",
                "operationId": "get-workspace-timings-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.WorkspaceBuildTimings"
                        }
                    }
                }
            }
        },
        "/workspaces/{workspace}/ttl": {
            "put": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Update workspace TTL by ID",
                "operationId": "update-workspace-ttl-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Workspace TTL update request",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/codersdk.UpdateWorkspaceTTLRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaces/{workspace}/usage": {
            "post": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "consumes": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Post Workspace Usage by ID",
                "operationId": "post-workspace-usage-by-id",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Post workspace usage request",
                        "name": "request",
                        "in": "body",
                        "schema": {
                            "$ref": "#/definitions/codersdk.PostWorkspaceUsageRequest"
                        }
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    }
                }
            }
        },
        "/workspaces/{workspace}/watch": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "text/event-stream"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Watch workspace by ID",
                "operationId": "watch-workspace-by-id",
                "deprecated": true,
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.Response"
                        }
                    }
                }
            }
        },
        "/workspaces/{workspace}/watch-ws": {
            "get": {
                "security": [
                    {
                        "CoderSessionToken": []
                    }
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Workspaces"
                ],
                "summary": "Watch workspace by ID via WebSockets",
                "operationId": "watch-workspace-by-id-via-websockets",
                "parameters": [
                    {
                        "type": "string",
                        "format": "uuid",
                        "description": "Workspace ID",
                        "name": "workspace",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/codersdk.ServerSentEvent"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "agentsdk.AWSInstanceIdentityToken": {
            "type": "object",
            "required": [
                "document",
                "signature"
            ],
            "properties": {
                "document": {
                    "type": "string"
                },
                "signature": {
                    "type": "string"
                }
            }
        },
        "agentsdk.AuthenticateResponse": {
            "type": "object",
            "properties": {
                "session_token": {
                    "type": "string"
                }
            }
        },
        "agentsdk.AzureInstanceIdentityToken": {
            "type": "object",
            "required": [
                "encoding",
                "signature"
            ],
            "properties": {
                "encoding": {
                    "type": "string"
                },
                "signature": {
                    "type": "string"
                }
            }
        },
        "agentsdk.ExternalAuthResponse": {
            "type": "object",
            "properties": {
                "access_token": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                },
                "token_extra": {
                    "type": "object",
                    "additionalProperties": true
                },
                "type": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                },
                "username": {
                    "description": "Deprecated: Only supported on ` + "`" + `/workspaceagents/me/gitauth` + "`" + `\nfor backwards compatibility.",
                    "type": "string"
                }
            }
        },
        "agentsdk.GitSSHKey": {
            "type": "object",
            "properties": {
                "private_key": {
                    "type": "string"
                },
                "public_key": {
                    "type": "string"
                }
            }
        },
        "agentsdk.GoogleInstanceIdentityToken": {
            "type": "object",
            "required": [
                "json_web_token"
            ],
            "properties": {
                "json_web_token": {
                    "type": "string"
                }
            }
        },
        "agentsdk.Log": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string"
                },
                "level": {
                    "$ref": "#/definitions/codersdk.LogLevel"
                },
                "output": {
                    "type": "string"
                }
            }
        },
        "agentsdk.PatchAppStatus": {
            "type": "object",
            "properties": {
                "app_slug": {
                    "type": "string"
                },
                "icon": {
                    "description": "Deprecated: this field is unused and will be removed in a future version.",
                    "type": "string"
                },
                "message": {
                    "type": "string"
                },
                "needs_user_attention": {
                    "description": "Deprecated: this field is unused and will be removed in a future version.",
                    "type": "boolean"
                },
                "state": {
                    "$ref": "#/definitions/codersdk.WorkspaceAppStatusState"
                },
                "uri": {
                    "type": "string"
                }
            }
        },
        "agentsdk.PatchLogs": {
            "type": "object",
            "properties": {
                "log_source_id": {
                    "type": "string"
                },
                "logs": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/agentsdk.Log"
                    }
                }
            }
        },
        "agentsdk.PostLogSourceRequest": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "description": "ID is a unique identifier for the log source.\nIt is scoped to a workspace agent, and can be statically\ndefined inside code to prevent duplicate sources from being\ncreated for the same agent.",
                    "type": "string"
                }
            }
        },
        "agentsdk.ReinitializationEvent": {
            "type": "object",
            "properties": {
                "reason": {
                    "$ref": "#/definitions/agentsdk.ReinitializationReason"
                },
                "workspaceID": {
                    "type": "string"
                }
            }
        },
        "agentsdk.ReinitializationReason": {
            "type": "string",
            "enum": [
                "prebuild_claimed"
            ],
            "x-enum-varnames": [
                "ReinitializeReasonPrebuildClaimed"
            ]
        },
        "coderd.SCIMUser": {
            "type": "object",
            "properties": {
                "active": {
                    "description": "Active is a ptr to prevent the empty value from being interpreted as false.",
                    "type": "boolean"
                },
                "emails": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "display": {
                                "type": "string"
                            },
                            "primary": {
                                "type": "boolean"
                            },
                            "type": {
                                "type": "string"
                            },
                            "value": {
                                "type": "string",
                                "format": "email"
                            }
                        }
                    }
                },
                "groups": {
                    "type": "array",
                    "items": {}
                },
                "id": {
                    "type": "string"
                },
                "meta": {
                    "type": "object",
                    "properties": {
                        "resourceType": {
                            "type": "string"
                        }
                    }
                },
                "name": {
                    "type": "object",
                    "properties": {
                        "familyName": {
                            "type": "string"
                        },
                        "givenName": {
                            "type": "string"
                        }
                    }
                },
                "schemas": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "userName": {
                    "type": "string"
                }
            }
        },
        "coderd.cspViolation": {
            "type": "object",
            "properties": {
                "csp-report": {
                    "type": "object",
                    "additionalProperties": true
                }
            }
        },
        "codersdk.ACLAvailable": {
            "type": "object",
            "properties": {
                "groups": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Group"
                    }
                },
                "users": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ReducedUser"
                    }
                }
            }
        },
        "codersdk.AIBridgeAnthropicConfig": {
            "type": "object",
            "properties": {
                "base_url": {
                    "type": "string"
                },
                "key": {
                    "type": "string"
                }
            }
        },
        "codersdk.AIBridgeBedrockConfig": {
            "type": "object",
            "properties": {
                "access_key": {
                    "type": "string"
                },
                "access_key_secret": {
                    "type": "string"
                },
                "base_url": {
                    "type": "string"
                },
                "model": {
                    "type": "string"
                },
                "region": {
                    "type": "string"
                },
                "small_fast_model": {
                    "type": "string"
                }
            }
        },
        "codersdk.AIBridgeConfig": {
            "type": "object",
            "properties": {
                "anthropic": {
                    "$ref": "#/definitions/codersdk.AIBridgeAnthropicConfig"
                },
                "bedrock": {
                    "$ref": "#/definitions/codersdk.AIBridgeBedrockConfig"
                },
                "circuit_breaker_enabled": {
                    "description": "Circuit breaker protects against cascading failures from upstream AI\nprovider rate limits (429, 503, 529 overloaded).",
                    "type": "boolean"
                },
                "circuit_breaker_failure_threshold": {
                    "type": "integer"
                },
                "circuit_breaker_interval": {
                    "type": "integer"
                },
                "circuit_breaker_max_requests": {
                    "type": "integer"
                },
                "circuit_breaker_timeout": {
                    "type": "integer"
                },
                "enabled": {
                    "type": "boolean"
                },
                "inject_coder_mcp_tools": {
                    "type": "boolean"
                },
                "max_concurrency": {
                    "type": "integer"
                },
                "openai": {
                    "$ref": "#/definitions/codersdk.AIBridgeOpenAIConfig"
                },
                "rate_limit": {
                    "type": "integer"
                },
                "retention": {
                    "type": "integer"
                },
                "send_actor_headers": {
                    "type": "boolean"
                },
                "structured_logging": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.AIBridgeInterception": {
            "type": "object",
            "properties": {
                "api_key_id": {
                    "type": "string"
                },
                "ended_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "initiator": {
                    "$ref": "#/definitions/codersdk.MinimalUser"
                },
                "metadata": {
                    "type": "object",
                    "additionalProperties": {}
                },
                "model": {
                    "type": "string"
                },
                "provider": {
                    "type": "string"
                },
                "started_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "token_usages": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.AIBridgeTokenUsage"
                    }
                },
                "tool_usages": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.AIBridgeToolUsage"
                    }
                },
                "user_prompts": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.AIBridgeUserPrompt"
                    }
                }
            }
        },
        "codersdk.AIBridgeListInterceptionsResponse": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "results": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.AIBridgeInterception"
                    }
                }
            }
        },
        "codersdk.AIBridgeOpenAIConfig": {
            "type": "object",
            "properties": {
                "base_url": {
                    "type": "string"
                },
                "key": {
                    "type": "string"
                }
            }
        },
        "codersdk.AIBridgeProxyConfig": {
            "type": "object",
            "properties": {
                "cert_file": {
                    "type": "string"
                },
                "domain_allowlist": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "enabled": {
                    "type": "boolean"
                },
                "key_file": {
                    "type": "string"
                },
                "listen_addr": {
                    "type": "string"
                },
                "upstream_proxy": {
                    "type": "string"
                },
                "upstream_proxy_ca": {
                    "type": "string"
                }
            }
        },
        "codersdk.AIBridgeTokenUsage": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "input_tokens": {
                    "type": "integer"
                },
                "interception_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "metadata": {
                    "type": "object",
                    "additionalProperties": {}
                },
                "output_tokens": {
                    "type": "integer"
                },
                "provider_response_id": {
                    "type": "string"
                }
            }
        },
        "codersdk.AIBridgeToolUsage": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "injected": {
                    "type": "boolean"
                },
                "input": {
                    "type": "string"
                },
                "interception_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "invocation_error": {
                    "type": "string"
                },
                "metadata": {
                    "type": "object",
                    "additionalProperties": {}
                },
                "provider_response_id": {
                    "type": "string"
                },
                "server_url": {
                    "type": "string"
                },
                "tool": {
                    "type": "string"
                }
            }
        },
        "codersdk.AIBridgeUserPrompt": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "interception_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "metadata": {
                    "type": "object",
                    "additionalProperties": {}
                },
                "prompt": {
                    "type": "string"
                },
                "provider_response_id": {
                    "type": "string"
                }
            }
        },
        "codersdk.AIConfig": {
            "type": "object",
            "properties": {
                "aibridge_proxy": {
                    "$ref": "#/definitions/codersdk.AIBridgeProxyConfig"
                },
                "bridge": {
                    "$ref": "#/definitions/codersdk.AIBridgeConfig"
                }
            }
        },
        "codersdk.APIAllowListTarget": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string"
                },
                "type": {
                    "$ref": "#/definitions/codersdk.RBACResource"
                }
            }
        },
        "codersdk.APIKey": {
            "type": "object",
            "required": [
                "created_at",
                "expires_at",
                "id",
                "last_used",
                "lifetime_seconds",
                "login_type",
                "token_name",
                "updated_at",
                "user_id"
            ],
            "properties": {
                "allow_list": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.APIAllowListTarget"
                    }
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "expires_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "string"
                },
                "last_used": {
                    "type": "string",
                    "format": "date-time"
                },
                "lifetime_seconds": {
                    "type": "integer"
                },
                "login_type": {
                    "enum": [
                        "password",
                        "github",
                        "oidc",
                        "token"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.LoginType"
                        }
                    ]
                },
                "scope": {
                    "description": "Deprecated: use Scopes instead.",
                    "enum": [
                        "all",
                        "application_connect"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.APIKeyScope"
                        }
                    ]
                },
                "scopes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.APIKeyScope"
                    }
                },
                "token_name": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.APIKeyScope": {
            "type": "string",
            "enum": [
                "all",
                "application_connect",
                "aibridge_interception:*",
                "aibridge_interception:create",
                "aibridge_interception:read",
                "aibridge_interception:update",
                "api_key:*",
                "api_key:create",
                "api_key:delete",
                "api_key:read",
                "api_key:update",
                "assign_org_role:*",
                "assign_org_role:assign",
                "assign_org_role:create",
                "assign_org_role:delete",
                "assign_org_role:read",
                "assign_org_role:unassign",
                "assign_org_role:update",
                "assign_role:*",
                "assign_role:assign",
                "assign_role:read",
                "assign_role:unassign",
                "audit_log:*",
                "audit_log:create",
                "audit_log:read",
                "boundary_usage:*",
                "boundary_usage:delete",
                "boundary_usage:read",
                "boundary_usage:update",
                "coder:all",
                "coder:apikeys.manage_self",
                "coder:application_connect",
                "coder:templates.author",
                "coder:templates.build",
                "coder:workspaces.access",
                "coder:workspaces.create",
                "coder:workspaces.delete",
                "coder:workspaces.operate",
                "connection_log:*",
                "connection_log:read",
                "connection_log:update",
                "crypto_key:*",
                "crypto_key:create",
                "crypto_key:delete",
                "crypto_key:read",
                "crypto_key:update",
                "debug_info:*",
                "debug_info:read",
                "deployment_config:*",
                "deployment_config:read",
                "deployment_config:update",
                "deployment_stats:*",
                "deployment_stats:read",
                "file:*",
                "file:create",
                "file:read",
                "group:*",
                "group:create",
                "group:delete",
                "group:read",
                "group:update",
                "group_member:*",
                "group_member:read",
                "idpsync_settings:*",
                "idpsync_settings:read",
                "idpsync_settings:update",
                "inbox_notification:*",
                "inbox_notification:create",
                "inbox_notification:read",
                "inbox_notification:update",
                "license:*",
                "license:create",
                "license:delete",
                "license:read",
                "notification_message:*",
                "notification_message:create",
                "notification_message:delete",
                "notification_message:read",
                "notification_message:update",
                "notification_preference:*",
                "notification_preference:read",
                "notification_preference:update",
                "notification_template:*",
                "notification_template:read",
                "notification_template:update",
                "oauth2_app:*",
                "oauth2_app:create",
                "oauth2_app:delete",
                "oauth2_app:read",
                "oauth2_app:update",
                "oauth2_app_code_token:*",
                "oauth2_app_code_token:create",
                "oauth2_app_code_token:delete",
                "oauth2_app_code_token:read",
                "oauth2_app_secret:*",
                "oauth2_app_secret:create",
                "oauth2_app_secret:delete",
                "oauth2_app_secret:read",
                "oauth2_app_secret:update",
                "organization:*",
                "organization:create",
                "organization:delete",
                "organization:read",
                "organization:update",
                "organization_member:*",
                "organization_member:create",
                "organization_member:delete",
                "organization_member:read",
                "organization_member:update",
                "prebuilt_workspace:*",
                "prebuilt_workspace:delete",
                "prebuilt_workspace:update",
                "provisioner_daemon:*",
                "provisioner_daemon:create",
                "provisioner_daemon:delete",
                "provisioner_daemon:read",
                "provisioner_daemon:update",
                "provisioner_jobs:*",
                "provisioner_jobs:create",
                "provisioner_jobs:read",
                "provisioner_jobs:update",
                "replicas:*",
                "replicas:read",
                "system:*",
                "system:create",
                "system:delete",
                "system:read",
                "system:update",
                "tailnet_coordinator:*",
                "tailnet_coordinator:create",
                "tailnet_coordinator:delete",
                "tailnet_coordinator:read",
                "tailnet_coordinator:update",
                "task:*",
                "task:create",
                "task:delete",
                "task:read",
                "task:update",
                "template:*",
                "template:create",
                "template:delete",
                "template:read",
                "template:update",
                "template:use",
                "template:view_insights",
                "usage_event:*",
                "usage_event:create",
                "usage_event:read",
                "usage_event:update",
                "user:*",
                "user:create",
                "user:delete",
                "user:read",
                "user:read_personal",
                "user:update",
                "user:update_personal",
                "user_secret:*",
                "user_secret:create",
                "user_secret:delete",
                "user_secret:read",
                "user_secret:update",
                "webpush_subscription:*",
                "webpush_subscription:create",
                "webpush_subscription:delete",
                "webpush_subscription:read",
                "workspace:*",
                "workspace:application_connect",
                "workspace:create",
                "workspace:create_agent",
                "workspace:delete",
                "workspace:delete_agent",
                "workspace:read",
                "workspace:share",
                "workspace:ssh",
                "workspace:start",
                "workspace:stop",
                "workspace:update",
                "workspace_agent_devcontainers:*",
                "workspace_agent_devcontainers:create",
                "workspace_agent_resource_monitor:*",
                "workspace_agent_resource_monitor:create",
                "workspace_agent_resource_monitor:read",
                "workspace_agent_resource_monitor:update",
                "workspace_dormant:*",
                "workspace_dormant:application_connect",
                "workspace_dormant:create",
                "workspace_dormant:create_agent",
                "workspace_dormant:delete",
                "workspace_dormant:delete_agent",
                "workspace_dormant:read",
                "workspace_dormant:share",
                "workspace_dormant:ssh",
                "workspace_dormant:start",
                "workspace_dormant:stop",
                "workspace_dormant:update",
                "workspace_proxy:*",
                "workspace_proxy:create",
                "workspace_proxy:delete",
                "workspace_proxy:read",
                "workspace_proxy:update"
            ],
            "x-enum-varnames": [
                "APIKeyScopeAll",
                "APIKeyScopeApplicationConnect",
                "APIKeyScopeAibridgeInterceptionAll",
                "APIKeyScopeAibridgeInterceptionCreate",
                "APIKeyScopeAibridgeInterceptionRead",
                "APIKeyScopeAibridgeInterceptionUpdate",
                "APIKeyScopeApiKeyAll",
                "APIKeyScopeApiKeyCreate",
                "APIKeyScopeApiKeyDelete",
                "APIKeyScopeApiKeyRead",
                "APIKeyScopeApiKeyUpdate",
                "APIKeyScopeAssignOrgRoleAll",
                "APIKeyScopeAssignOrgRoleAssign",
                "APIKeyScopeAssignOrgRoleCreate",
                "APIKeyScopeAssignOrgRoleDelete",
                "APIKeyScopeAssignOrgRoleRead",
                "APIKeyScopeAssignOrgRoleUnassign",
                "APIKeyScopeAssignOrgRoleUpdate",
                "APIKeyScopeAssignRoleAll",
                "APIKeyScopeAssignRoleAssign",
                "APIKeyScopeAssignRoleRead",
                "APIKeyScopeAssignRoleUnassign",
                "APIKeyScopeAuditLogAll",
                "APIKeyScopeAuditLogCreate",
                "APIKeyScopeAuditLogRead",
                "APIKeyScopeBoundaryUsageAll",
                "APIKeyScopeBoundaryUsageDelete",
                "APIKeyScopeBoundaryUsageRead",
                "APIKeyScopeBoundaryUsageUpdate",
                "APIKeyScopeCoderAll",
                "APIKeyScopeCoderApikeysManageSelf",
                "APIKeyScopeCoderApplicationConnect",
                "APIKeyScopeCoderTemplatesAuthor",
                "APIKeyScopeCoderTemplatesBuild",
                "APIKeyScopeCoderWorkspacesAccess",
                "APIKeyScopeCoderWorkspacesCreate",
                "APIKeyScopeCoderWorkspacesDelete",
                "APIKeyScopeCoderWorkspacesOperate",
                "APIKeyScopeConnectionLogAll",
                "APIKeyScopeConnectionLogRead",
                "APIKeyScopeConnectionLogUpdate",
                "APIKeyScopeCryptoKeyAll",
                "APIKeyScopeCryptoKeyCreate",
                "APIKeyScopeCryptoKeyDelete",
                "APIKeyScopeCryptoKeyRead",
                "APIKeyScopeCryptoKeyUpdate",
                "APIKeyScopeDebugInfoAll",
                "APIKeyScopeDebugInfoRead",
                "APIKeyScopeDeploymentConfigAll",
                "APIKeyScopeDeploymentConfigRead",
                "APIKeyScopeDeploymentConfigUpdate",
                "APIKeyScopeDeploymentStatsAll",
                "APIKeyScopeDeploymentStatsRead",
                "APIKeyScopeFileAll",
                "APIKeyScopeFileCreate",
                "APIKeyScopeFileRead",
                "APIKeyScopeGroupAll",
                "APIKeyScopeGroupCreate",
                "APIKeyScopeGroupDelete",
                "APIKeyScopeGroupRead",
                "APIKeyScopeGroupUpdate",
                "APIKeyScopeGroupMemberAll",
                "APIKeyScopeGroupMemberRead",
                "APIKeyScopeIdpsyncSettingsAll",
                "APIKeyScopeIdpsyncSettingsRead",
                "APIKeyScopeIdpsyncSettingsUpdate",
                "APIKeyScopeInboxNotificationAll",
                "APIKeyScopeInboxNotificationCreate",
                "APIKeyScopeInboxNotificationRead",
                "APIKeyScopeInboxNotificationUpdate",
                "APIKeyScopeLicenseAll",
                "APIKeyScopeLicenseCreate",
                "APIKeyScopeLicenseDelete",
                "APIKeyScopeLicenseRead",
                "APIKeyScopeNotificationMessageAll",
                "APIKeyScopeNotificationMessageCreate",
                "APIKeyScopeNotificationMessageDelete",
                "APIKeyScopeNotificationMessageRead",
                "APIKeyScopeNotificationMessageUpdate",
                "APIKeyScopeNotificationPreferenceAll",
                "APIKeyScopeNotificationPreferenceRead",
                "APIKeyScopeNotificationPreferenceUpdate",
                "APIKeyScopeNotificationTemplateAll",
                "APIKeyScopeNotificationTemplateRead",
                "APIKeyScopeNotificationTemplateUpdate",
                "APIKeyScopeOauth2AppAll",
                "APIKeyScopeOauth2AppCreate",
                "APIKeyScopeOauth2AppDelete",
                "APIKeyScopeOauth2AppRead",
                "APIKeyScopeOauth2AppUpdate",
                "APIKeyScopeOauth2AppCodeTokenAll",
                "APIKeyScopeOauth2AppCodeTokenCreate",
                "APIKeyScopeOauth2AppCodeTokenDelete",
                "APIKeyScopeOauth2AppCodeTokenRead",
                "APIKeyScopeOauth2AppSecretAll",
                "APIKeyScopeOauth2AppSecretCreate",
                "APIKeyScopeOauth2AppSecretDelete",
                "APIKeyScopeOauth2AppSecretRead",
                "APIKeyScopeOauth2AppSecretUpdate",
                "APIKeyScopeOrganizationAll",
                "APIKeyScopeOrganizationCreate",
                "APIKeyScopeOrganizationDelete",
                "APIKeyScopeOrganizationRead",
                "APIKeyScopeOrganizationUpdate",
                "APIKeyScopeOrganizationMemberAll",
                "APIKeyScopeOrganizationMemberCreate",
                "APIKeyScopeOrganizationMemberDelete",
                "APIKeyScopeOrganizationMemberRead",
                "APIKeyScopeOrganizationMemberUpdate",
                "APIKeyScopePrebuiltWorkspaceAll",
                "APIKeyScopePrebuiltWorkspaceDelete",
                "APIKeyScopePrebuiltWorkspaceUpdate",
                "APIKeyScopeProvisionerDaemonAll",
                "APIKeyScopeProvisionerDaemonCreate",
                "APIKeyScopeProvisionerDaemonDelete",
                "APIKeyScopeProvisionerDaemonRead",
                "APIKeyScopeProvisionerDaemonUpdate",
                "APIKeyScopeProvisionerJobsAll",
                "APIKeyScopeProvisionerJobsCreate",
                "APIKeyScopeProvisionerJobsRead",
                "APIKeyScopeProvisionerJobsUpdate",
                "APIKeyScopeReplicasAll",
                "APIKeyScopeReplicasRead",
                "APIKeyScopeSystemAll",
                "APIKeyScopeSystemCreate",
                "APIKeyScopeSystemDelete",
                "APIKeyScopeSystemRead",
                "APIKeyScopeSystemUpdate",
                "APIKeyScopeTailnetCoordinatorAll",
                "APIKeyScopeTailnetCoordinatorCreate",
                "APIKeyScopeTailnetCoordinatorDelete",
                "APIKeyScopeTailnetCoordinatorRead",
                "APIKeyScopeTailnetCoordinatorUpdate",
                "APIKeyScopeTaskAll",
                "APIKeyScopeTaskCreate",
                "APIKeyScopeTaskDelete",
                "APIKeyScopeTaskRead",
                "APIKeyScopeTaskUpdate",
                "APIKeyScopeTemplateAll",
                "APIKeyScopeTemplateCreate",
                "APIKeyScopeTemplateDelete",
                "APIKeyScopeTemplateRead",
                "APIKeyScopeTemplateUpdate",
                "APIKeyScopeTemplateUse",
                "APIKeyScopeTemplateViewInsights",
                "APIKeyScopeUsageEventAll",
                "APIKeyScopeUsageEventCreate",
                "APIKeyScopeUsageEventRead",
                "APIKeyScopeUsageEventUpdate",
                "APIKeyScopeUserAll",
                "APIKeyScopeUserCreate",
                "APIKeyScopeUserDelete",
                "APIKeyScopeUserRead",
                "APIKeyScopeUserReadPersonal",
                "APIKeyScopeUserUpdate",
                "APIKeyScopeUserUpdatePersonal",
                "APIKeyScopeUserSecretAll",
                "APIKeyScopeUserSecretCreate",
                "APIKeyScopeUserSecretDelete",
                "APIKeyScopeUserSecretRead",
                "APIKeyScopeUserSecretUpdate",
                "APIKeyScopeWebpushSubscriptionAll",
                "APIKeyScopeWebpushSubscriptionCreate",
                "APIKeyScopeWebpushSubscriptionDelete",
                "APIKeyScopeWebpushSubscriptionRead",
                "APIKeyScopeWorkspaceAll",
                "APIKeyScopeWorkspaceApplicationConnect",
                "APIKeyScopeWorkspaceCreate",
                "APIKeyScopeWorkspaceCreateAgent",
                "APIKeyScopeWorkspaceDelete",
                "APIKeyScopeWorkspaceDeleteAgent",
                "APIKeyScopeWorkspaceRead",
                "APIKeyScopeWorkspaceShare",
                "APIKeyScopeWorkspaceSsh",
                "APIKeyScopeWorkspaceStart",
                "APIKeyScopeWorkspaceStop",
                "APIKeyScopeWorkspaceUpdate",
                "APIKeyScopeWorkspaceAgentDevcontainersAll",
                "APIKeyScopeWorkspaceAgentDevcontainersCreate",
                "APIKeyScopeWorkspaceAgentResourceMonitorAll",
                "APIKeyScopeWorkspaceAgentResourceMonitorCreate",
                "APIKeyScopeWorkspaceAgentResourceMonitorRead",
                "APIKeyScopeWorkspaceAgentResourceMonitorUpdate",
                "APIKeyScopeWorkspaceDormantAll",
                "APIKeyScopeWorkspaceDormantApplicationConnect",
                "APIKeyScopeWorkspaceDormantCreate",
                "APIKeyScopeWorkspaceDormantCreateAgent",
                "APIKeyScopeWorkspaceDormantDelete",
                "APIKeyScopeWorkspaceDormantDeleteAgent",
                "APIKeyScopeWorkspaceDormantRead",
                "APIKeyScopeWorkspaceDormantShare",
                "APIKeyScopeWorkspaceDormantSsh",
                "APIKeyScopeWorkspaceDormantStart",
                "APIKeyScopeWorkspaceDormantStop",
                "APIKeyScopeWorkspaceDormantUpdate",
                "APIKeyScopeWorkspaceProxyAll",
                "APIKeyScopeWorkspaceProxyCreate",
                "APIKeyScopeWorkspaceProxyDelete",
                "APIKeyScopeWorkspaceProxyRead",
                "APIKeyScopeWorkspaceProxyUpdate"
            ]
        },
        "codersdk.AddLicenseRequest": {
            "type": "object",
            "required": [
                "license"
            ],
            "properties": {
                "license": {
                    "type": "string"
                }
            }
        },
        "codersdk.AgentConnectionTiming": {
            "type": "object",
            "properties": {
                "ended_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "stage": {
                    "$ref": "#/definitions/codersdk.TimingStage"
                },
                "started_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "workspace_agent_id": {
                    "type": "string"
                },
                "workspace_agent_name": {
                    "type": "string"
                }
            }
        },
        "codersdk.AgentScriptTiming": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "ended_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "exit_code": {
                    "type": "integer"
                },
                "stage": {
                    "$ref": "#/definitions/codersdk.TimingStage"
                },
                "started_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "status": {
                    "type": "string"
                },
                "workspace_agent_id": {
                    "type": "string"
                },
                "workspace_agent_name": {
                    "type": "string"
                }
            }
        },
        "codersdk.AgentSubsystem": {
            "type": "string",
            "enum": [
                "envbox",
                "envbuilder",
                "exectrace"
            ],
            "x-enum-varnames": [
                "AgentSubsystemEnvbox",
                "AgentSubsystemEnvbuilder",
                "AgentSubsystemExectrace"
            ]
        },
        "codersdk.AppHostResponse": {
            "type": "object",
            "properties": {
                "host": {
                    "description": "Host is the externally accessible URL for the Coder instance.",
                    "type": "string"
                }
            }
        },
        "codersdk.AppearanceConfig": {
            "type": "object",
            "properties": {
                "announcement_banners": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.BannerConfig"
                    }
                },
                "application_name": {
                    "type": "string"
                },
                "docs_url": {
                    "type": "string"
                },
                "logo_url": {
                    "type": "string"
                },
                "service_banner": {
                    "description": "Deprecated: ServiceBanner has been replaced by AnnouncementBanners.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.BannerConfig"
                        }
                    ]
                },
                "support_links": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.LinkConfig"
                    }
                }
            }
        },
        "codersdk.ArchiveTemplateVersionsRequest": {
            "type": "object",
            "properties": {
                "all": {
                    "description": "By default, only failed versions are archived. Set this to true\nto archive all unused versions regardless of job status.",
                    "type": "boolean"
                }
            }
        },
        "codersdk.AssignableRoles": {
            "type": "object",
            "properties": {
                "assignable": {
                    "type": "boolean"
                },
                "built_in": {
                    "description": "BuiltIn roles are immutable",
                    "type": "boolean"
                },
                "display_name": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "organization_member_permissions": {
                    "description": "OrganizationMemberPermissions are specific for the organization in the field 'OrganizationID' above.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "organization_permissions": {
                    "description": "OrganizationPermissions are specific for the organization in the field 'OrganizationID' above.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "site_permissions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "user_permissions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                }
            }
        },
        "codersdk.AuditAction": {
            "type": "string",
            "enum": [
                "create",
                "write",
                "delete",
                "start",
                "stop",
                "login",
                "logout",
                "register",
                "request_password_reset",
                "connect",
                "disconnect",
                "open",
                "close"
            ],
            "x-enum-varnames": [
                "AuditActionCreate",
                "AuditActionWrite",
                "AuditActionDelete",
                "AuditActionStart",
                "AuditActionStop",
                "AuditActionLogin",
                "AuditActionLogout",
                "AuditActionRegister",
                "AuditActionRequestPasswordReset",
                "AuditActionConnect",
                "AuditActionDisconnect",
                "AuditActionOpen",
                "AuditActionClose"
            ]
        },
        "codersdk.AuditDiff": {
            "type": "object",
            "additionalProperties": {
                "$ref": "#/definitions/codersdk.AuditDiffField"
            }
        },
        "codersdk.AuditDiffField": {
            "type": "object",
            "properties": {
                "new": {},
                "old": {},
                "secret": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.AuditLog": {
            "type": "object",
            "properties": {
                "action": {
                    "$ref": "#/definitions/codersdk.AuditAction"
                },
                "additional_fields": {
                    "type": "object"
                },
                "description": {
                    "type": "string"
                },
                "diff": {
                    "$ref": "#/definitions/codersdk.AuditDiff"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "ip": {
                    "type": "string"
                },
                "is_deleted": {
                    "type": "boolean"
                },
                "organization": {
                    "$ref": "#/definitions/codersdk.MinimalOrganization"
                },
                "organization_id": {
                    "description": "Deprecated: Use 'organization.id' instead.",
                    "type": "string",
                    "format": "uuid"
                },
                "request_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "resource_icon": {
                    "type": "string"
                },
                "resource_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "resource_link": {
                    "type": "string"
                },
                "resource_target": {
                    "description": "ResourceTarget is the name of the resource.",
                    "type": "string"
                },
                "resource_type": {
                    "$ref": "#/definitions/codersdk.ResourceType"
                },
                "status_code": {
                    "type": "integer"
                },
                "time": {
                    "type": "string",
                    "format": "date-time"
                },
                "user": {
                    "$ref": "#/definitions/codersdk.User"
                },
                "user_agent": {
                    "type": "string"
                }
            }
        },
        "codersdk.AuditLogResponse": {
            "type": "object",
            "properties": {
                "audit_logs": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.AuditLog"
                    }
                },
                "count": {
                    "type": "integer"
                }
            }
        },
        "codersdk.AuthMethod": {
            "type": "object",
            "properties": {
                "enabled": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.AuthMethods": {
            "type": "object",
            "properties": {
                "github": {
                    "$ref": "#/definitions/codersdk.GithubAuthMethod"
                },
                "oidc": {
                    "$ref": "#/definitions/codersdk.OIDCAuthMethod"
                },
                "password": {
                    "$ref": "#/definitions/codersdk.AuthMethod"
                },
                "terms_of_service_url": {
                    "type": "string"
                }
            }
        },
        "codersdk.AuthorizationCheck": {
            "description": "AuthorizationCheck is used to check if the currently authenticated user (or the specified user) can do a given action to a given set of objects.",
            "type": "object",
            "properties": {
                "action": {
                    "enum": [
                        "create",
                        "read",
                        "update",
                        "delete"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.RBACAction"
                        }
                    ]
                },
                "object": {
                    "description": "Object can represent a \"set\" of objects, such as: all workspaces in an organization, all workspaces owned by me, and all workspaces across the entire product.\nWhen defining an object, use the most specific language when possible to\nproduce the smallest set. Meaning to set as many fields on 'Object' as\nyou can. Example, if you want to check if you can update all workspaces\nowned by 'me', try to also add an 'OrganizationID' to the settings.\nOmitting the 'OrganizationID' could produce the incorrect value, as\nworkspaces have both ` + "`" + `user` + "`" + ` and ` + "`" + `organization` + "`" + ` owners.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.AuthorizationObject"
                        }
                    ]
                }
            }
        },
        "codersdk.AuthorizationObject": {
            "description": "AuthorizationObject can represent a \"set\" of objects, such as: all workspaces in an organization, all workspaces owned by me, all workspaces across the entire product.",
            "type": "object",
            "properties": {
                "any_org": {
                    "description": "AnyOrgOwner (optional) will disregard the org_owner when checking for permissions.\nThis cannot be set to true if the OrganizationID is set.",
                    "type": "boolean"
                },
                "organization_id": {
                    "description": "OrganizationID (optional) adds the set constraint to all resources owned by a given organization.",
                    "type": "string"
                },
                "owner_id": {
                    "description": "OwnerID (optional) adds the set constraint to all resources owned by a given user.",
                    "type": "string"
                },
                "resource_id": {
                    "description": "ResourceID (optional) reduces the set to a singular resource. This assigns\na resource ID to the resource type, eg: a single workspace.\nThe rbac library will not fetch the resource from the database, so if you\nare using this option, you should also set the owner ID and organization ID\nif possible. Be as specific as possible using all the fields relevant.",
                    "type": "string"
                },
                "resource_type": {
                    "description": "ResourceType is the name of the resource.\n` + "`" + `./coderd/rbac/object.go` + "`" + ` has the list of valid resource types.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.RBACResource"
                        }
                    ]
                }
            }
        },
        "codersdk.AuthorizationRequest": {
            "type": "object",
            "properties": {
                "checks": {
                    "description": "Checks is a map keyed with an arbitrary string to a permission check.\nThe key can be any string that is helpful to the caller, and allows\nmultiple permission checks to be run in a single request.\nThe key ensures that each permission check has the same key in the\nresponse.",
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/codersdk.AuthorizationCheck"
                    }
                }
            }
        },
        "codersdk.AuthorizationResponse": {
            "type": "object",
            "additionalProperties": {
                "type": "boolean"
            }
        },
        "codersdk.AutomaticUpdates": {
            "type": "string",
            "enum": [
                "always",
                "never"
            ],
            "x-enum-varnames": [
                "AutomaticUpdatesAlways",
                "AutomaticUpdatesNever"
            ]
        },
        "codersdk.BannerConfig": {
            "type": "object",
            "properties": {
                "background_color": {
                    "type": "string"
                },
                "enabled": {
                    "type": "boolean"
                },
                "message": {
                    "type": "string"
                }
            }
        },
        "codersdk.BuildInfoResponse": {
            "type": "object",
            "properties": {
                "agent_api_version": {
                    "description": "AgentAPIVersion is the current version of the Agent API (back versions\nMAY still be supported).",
                    "type": "string"
                },
                "dashboard_url": {
                    "description": "DashboardURL is the URL to hit the deployment's dashboard.\nFor external workspace proxies, this is the coderd they are connected\nto.",
                    "type": "string"
                },
                "deployment_id": {
                    "description": "DeploymentID is the unique identifier for this deployment.",
                    "type": "string"
                },
                "external_url": {
                    "description": "ExternalURL references the current Coder version.\nFor production builds, this will link directly to a release. For development builds, this will link to a commit.",
                    "type": "string"
                },
                "provisioner_api_version": {
                    "description": "ProvisionerAPIVersion is the current version of the Provisioner API",
                    "type": "string"
                },
                "telemetry": {
                    "description": "Telemetry is a boolean that indicates whether telemetry is enabled.",
                    "type": "boolean"
                },
                "upgrade_message": {
                    "description": "UpgradeMessage is the message displayed to users when an outdated client\nis detected.",
                    "type": "string"
                },
                "version": {
                    "description": "Version returns the semantic version of the build.",
                    "type": "string"
                },
                "webpush_public_key": {
                    "description": "WebPushPublicKey is the public key for push notifications via Web Push.",
                    "type": "string"
                },
                "workspace_proxy": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.BuildReason": {
            "type": "string",
            "enum": [
                "initiator",
                "autostart",
                "autostop",
                "dormancy",
                "dashboard",
                "cli",
                "ssh_connection",
                "vscode_connection",
                "jetbrains_connection"
            ],
            "x-enum-varnames": [
                "BuildReasonInitiator",
                "BuildReasonAutostart",
                "BuildReasonAutostop",
                "BuildReasonDormancy",
                "BuildReasonDashboard",
                "BuildReasonCLI",
                "BuildReasonSSHConnection",
                "BuildReasonVSCodeConnection",
                "BuildReasonJetbrainsConnection"
            ]
        },
        "codersdk.CORSBehavior": {
            "type": "string",
            "enum": [
                "simple",
                "passthru"
            ],
            "x-enum-varnames": [
                "CORSBehaviorSimple",
                "CORSBehaviorPassthru"
            ]
        },
        "codersdk.ChangePasswordWithOneTimePasscodeRequest": {
            "type": "object",
            "required": [
                "email",
                "one_time_passcode",
                "password"
            ],
            "properties": {
                "email": {
                    "type": "string",
                    "format": "email"
                },
                "one_time_passcode": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                }
            }
        },
        "codersdk.ConnectionLatency": {
            "type": "object",
            "properties": {
                "p50": {
                    "type": "number",
                    "example": 31.312
                },
                "p95": {
                    "type": "number",
                    "example": 119.832
                }
            }
        },
        "codersdk.ConnectionLog": {
            "type": "object",
            "properties": {
                "agent_name": {
                    "type": "string"
                },
                "connect_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "ip": {
                    "type": "string"
                },
                "organization": {
                    "$ref": "#/definitions/codersdk.MinimalOrganization"
                },
                "ssh_info": {
                    "description": "SSHInfo is only set when ` + "`" + `type` + "`" + ` is one of:\n- ` + "`" + `ConnectionTypeSSH` + "`" + `\n- ` + "`" + `ConnectionTypeReconnectingPTY` + "`" + `\n- ` + "`" + `ConnectionTypeVSCode` + "`" + `\n- ` + "`" + `ConnectionTypeJetBrains` + "`" + `",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ConnectionLogSSHInfo"
                        }
                    ]
                },
                "type": {
                    "$ref": "#/definitions/codersdk.ConnectionType"
                },
                "web_info": {
                    "description": "WebInfo is only set when ` + "`" + `type` + "`" + ` is one of:\n- ` + "`" + `ConnectionTypePortForwarding` + "`" + `\n- ` + "`" + `ConnectionTypeWorkspaceApp` + "`" + `",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ConnectionLogWebInfo"
                        }
                    ]
                },
                "workspace_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "workspace_name": {
                    "type": "string"
                },
                "workspace_owner_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "workspace_owner_username": {
                    "type": "string"
                }
            }
        },
        "codersdk.ConnectionLogResponse": {
            "type": "object",
            "properties": {
                "connection_logs": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ConnectionLog"
                    }
                },
                "count": {
                    "type": "integer"
                }
            }
        },
        "codersdk.ConnectionLogSSHInfo": {
            "type": "object",
            "properties": {
                "connection_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "disconnect_reason": {
                    "description": "DisconnectReason is omitted if a disconnect event with the same connection ID\nhas not yet been seen.",
                    "type": "string"
                },
                "disconnect_time": {
                    "description": "DisconnectTime is omitted if a disconnect event with the same connection ID\nhas not yet been seen.",
                    "type": "string",
                    "format": "date-time"
                },
                "exit_code": {
                    "description": "ExitCode is the exit code of the SSH session. It is omitted if a\ndisconnect event with the same connection ID has not yet been seen.",
                    "type": "integer"
                }
            }
        },
        "codersdk.ConnectionLogWebInfo": {
            "type": "object",
            "properties": {
                "slug_or_port": {
                    "type": "string"
                },
                "status_code": {
                    "description": "StatusCode is the HTTP status code of the request.",
                    "type": "integer"
                },
                "user": {
                    "description": "User is omitted if the connection event was from an unauthenticated user.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.User"
                        }
                    ]
                },
                "user_agent": {
                    "type": "string"
                }
            }
        },
        "codersdk.ConnectionType": {
            "type": "string",
            "enum": [
                "ssh",
                "vscode",
                "jetbrains",
                "reconnecting_pty",
                "workspace_app",
                "port_forwarding"
            ],
            "x-enum-varnames": [
                "ConnectionTypeSSH",
                "ConnectionTypeVSCode",
                "ConnectionTypeJetBrains",
                "ConnectionTypeReconnectingPTY",
                "ConnectionTypeWorkspaceApp",
                "ConnectionTypePortForwarding"
            ]
        },
        "codersdk.ConvertLoginRequest": {
            "type": "object",
            "required": [
                "password",
                "to_type"
            ],
            "properties": {
                "password": {
                    "type": "string"
                },
                "to_type": {
                    "description": "ToType is the login type to convert to.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.LoginType"
                        }
                    ]
                }
            }
        },
        "codersdk.CreateFirstUserRequest": {
            "type": "object",
            "required": [
                "email",
                "password",
                "username"
            ],
            "properties": {
                "email": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                },
                "trial": {
                    "type": "boolean"
                },
                "trial_info": {
                    "$ref": "#/definitions/codersdk.CreateFirstUserTrialInfo"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.CreateFirstUserResponse": {
            "type": "object",
            "properties": {
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.CreateFirstUserTrialInfo": {
            "type": "object",
            "properties": {
                "company_name": {
                    "type": "string"
                },
                "country": {
                    "type": "string"
                },
                "developers": {
                    "type": "string"
                },
                "first_name": {
                    "type": "string"
                },
                "job_title": {
                    "type": "string"
                },
                "last_name": {
                    "type": "string"
                },
                "phone_number": {
                    "type": "string"
                }
            }
        },
        "codersdk.CreateGroupRequest": {
            "type": "object",
            "required": [
                "name"
            ],
            "properties": {
                "avatar_url": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "quota_allowance": {
                    "type": "integer"
                }
            }
        },
        "codersdk.CreateOrganizationRequest": {
            "type": "object",
            "required": [
                "name"
            ],
            "properties": {
                "description": {
                    "type": "string"
                },
                "display_name": {
                    "description": "DisplayName will default to the same value as ` + "`" + `Name` + "`" + ` if not provided.",
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.CreateProvisionerKeyResponse": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string"
                }
            }
        },
        "codersdk.CreateTaskRequest": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "input": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "template_version_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "template_version_preset_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.CreateTemplateRequest": {
            "type": "object",
            "required": [
                "name",
                "template_version_id"
            ],
            "properties": {
                "activity_bump_ms": {
                    "description": "ActivityBumpMillis allows optionally specifying the activity bump\nduration for all workspaces created from this template. Defaults to 1h\nbut can be set to 0 to disable activity bumping.",
                    "type": "integer"
                },
                "allow_user_autostart": {
                    "description": "AllowUserAutostart allows users to set a schedule for autostarting their\nworkspace. By default this is true. This can only be disabled when using\nan enterprise license.",
                    "type": "boolean"
                },
                "allow_user_autostop": {
                    "description": "AllowUserAutostop allows users to set a custom workspace TTL to use in\nplace of the template's DefaultTTL field. By default this is true. If\nfalse, the DefaultTTL will always be used. This can only be disabled when\nusing an enterprise license.",
                    "type": "boolean"
                },
                "allow_user_cancel_workspace_jobs": {
                    "description": "Allow users to cancel in-progress workspace jobs.\n*bool as the default value is \"true\".",
                    "type": "boolean"
                },
                "autostart_requirement": {
                    "description": "AutostartRequirement allows optionally specifying the autostart allowed days\nfor workspaces created from this template. This is an enterprise feature.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.TemplateAutostartRequirement"
                        }
                    ]
                },
                "autostop_requirement": {
                    "description": "AutostopRequirement allows optionally specifying the autostop requirement\nfor workspaces created from this template. This is an enterprise feature.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.TemplateAutostopRequirement"
                        }
                    ]
                },
                "cors_behavior": {
                    "description": "CORSBehavior allows optionally specifying the CORS behavior for all shared ports.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.CORSBehavior"
                        }
                    ]
                },
                "default_ttl_ms": {
                    "description": "DefaultTTLMillis allows optionally specifying the default TTL\nfor all workspaces created from this template.",
                    "type": "integer"
                },
                "delete_ttl_ms": {
                    "description": "TimeTilDormantAutoDeleteMillis allows optionally specifying the max lifetime before Coder\npermanently deletes dormant workspaces created from this template.",
                    "type": "integer"
                },
                "description": {
                    "description": "Description is a description of what the template contains. It must be\nless than 128 bytes.",
                    "type": "string"
                },
                "disable_everyone_group_access": {
                    "description": "DisableEveryoneGroupAccess allows optionally disabling the default\nbehavior of granting the 'everyone' group access to use the template.\nIf this is set to true, the template will not be available to all users,\nand must be explicitly granted to users or groups in the permissions settings\nof the template.",
                    "type": "boolean"
                },
                "display_name": {
                    "description": "DisplayName is the displayed name of the template.",
                    "type": "string"
                },
                "dormant_ttl_ms": {
                    "description": "TimeTilDormantMillis allows optionally specifying the max lifetime before Coder\nlocks inactive workspaces created from this template.",
                    "type": "integer"
                },
                "failure_ttl_ms": {
                    "description": "FailureTTLMillis allows optionally specifying the max lifetime before Coder\nstops all resources for failed workspaces created from this template.",
                    "type": "integer"
                },
                "icon": {
                    "description": "Icon is a relative path or external URL that specifies\nan icon to be displayed in the dashboard.",
                    "type": "string"
                },
                "max_port_share_level": {
                    "description": "MaxPortShareLevel allows optionally specifying the maximum port share level\nfor workspaces created from the template.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentPortShareLevel"
                        }
                    ]
                },
                "name": {
                    "description": "Name is the name of the template.",
                    "type": "string"
                },
                "require_active_version": {
                    "description": "RequireActiveVersion mandates that workspaces are built with the active\ntemplate version.",
                    "type": "boolean"
                },
                "template_use_classic_parameter_flow": {
                    "description": "UseClassicParameterFlow allows optionally specifying whether\nthe template should use the classic parameter flow. The default if unset is\ntrue, and is why ` + "`" + `*bool` + "`" + ` is used here. When dynamic parameters becomes\nthe default, this will default to false.",
                    "type": "boolean"
                },
                "template_version_id": {
                    "description": "VersionID is an in-progress or completed job to use as an initial version\nof the template.\n\nThis is required on creation to enable a user-flow of validating a\ntemplate works. There is no reason the data-model cannot support empty\ntemplates, but it doesn't make sense for users.",
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.CreateTemplateVersionDryRunRequest": {
            "type": "object",
            "properties": {
                "rich_parameter_values": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceBuildParameter"
                    }
                },
                "user_variable_values": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.VariableValue"
                    }
                },
                "workspace_name": {
                    "type": "string"
                }
            }
        },
        "codersdk.CreateTemplateVersionRequest": {
            "type": "object",
            "required": [
                "provisioner",
                "storage_method"
            ],
            "properties": {
                "example_id": {
                    "type": "string"
                },
                "file_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "message": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "provisioner": {
                    "type": "string",
                    "enum": [
                        "terraform",
                        "echo"
                    ]
                },
                "storage_method": {
                    "enum": [
                        "file"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ProvisionerStorageMethod"
                        }
                    ]
                },
                "tags": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "template_id": {
                    "description": "TemplateID optionally associates a version with a template.",
                    "type": "string",
                    "format": "uuid"
                },
                "user_variable_values": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.VariableValue"
                    }
                }
            }
        },
        "codersdk.CreateTestAuditLogRequest": {
            "type": "object",
            "properties": {
                "action": {
                    "enum": [
                        "create",
                        "write",
                        "delete",
                        "start",
                        "stop"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.AuditAction"
                        }
                    ]
                },
                "additional_fields": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "build_reason": {
                    "enum": [
                        "autostart",
                        "autostop",
                        "initiator"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.BuildReason"
                        }
                    ]
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "request_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "resource_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "resource_type": {
                    "enum": [
                        "template",
                        "template_version",
                        "user",
                        "workspace",
                        "workspace_build",
                        "git_ssh_key",
                        "auditable_group"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ResourceType"
                        }
                    ]
                },
                "time": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.CreateTokenRequest": {
            "type": "object",
            "properties": {
                "allow_list": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.APIAllowListTarget"
                    }
                },
                "lifetime": {
                    "type": "integer"
                },
                "scope": {
                    "description": "Deprecated: use Scopes instead.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.APIKeyScope"
                        }
                    ]
                },
                "scopes": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.APIKeyScope"
                    }
                },
                "token_name": {
                    "type": "string"
                }
            }
        },
        "codersdk.CreateUserRequestWithOrgs": {
            "type": "object",
            "required": [
                "email",
                "username"
            ],
            "properties": {
                "email": {
                    "type": "string",
                    "format": "email"
                },
                "login_type": {
                    "description": "UserLoginType defaults to LoginTypePassword.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.LoginType"
                        }
                    ]
                },
                "name": {
                    "type": "string"
                },
                "organization_ids": {
                    "description": "OrganizationIDs is a list of organization IDs that the user should be a member of.",
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "password": {
                    "type": "string"
                },
                "user_status": {
                    "description": "UserStatus defaults to UserStatusDormant.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.UserStatus"
                        }
                    ]
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.CreateWorkspaceBuildReason": {
            "type": "string",
            "enum": [
                "dashboard",
                "cli",
                "ssh_connection",
                "vscode_connection",
                "jetbrains_connection"
            ],
            "x-enum-varnames": [
                "CreateWorkspaceBuildReasonDashboard",
                "CreateWorkspaceBuildReasonCLI",
                "CreateWorkspaceBuildReasonSSHConnection",
                "CreateWorkspaceBuildReasonVSCodeConnection",
                "CreateWorkspaceBuildReasonJetbrainsConnection"
            ]
        },
        "codersdk.CreateWorkspaceBuildRequest": {
            "type": "object",
            "required": [
                "transition"
            ],
            "properties": {
                "dry_run": {
                    "type": "boolean"
                },
                "log_level": {
                    "description": "Log level changes the default logging verbosity of a provider (\"info\" if empty).",
                    "enum": [
                        "debug"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ProvisionerLogLevel"
                        }
                    ]
                },
                "orphan": {
                    "description": "Orphan may be set for the Destroy transition.",
                    "type": "boolean"
                },
                "reason": {
                    "description": "Reason sets the reason for the workspace build.",
                    "enum": [
                        "dashboard",
                        "cli",
                        "ssh_connection",
                        "vscode_connection",
                        "jetbrains_connection"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.CreateWorkspaceBuildReason"
                        }
                    ]
                },
                "rich_parameter_values": {
                    "description": "ParameterValues are optional. It will write params to the 'workspace' scope.\nThis will overwrite any existing parameters with the same name.\nThis will not delete old params not included in this list.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceBuildParameter"
                    }
                },
                "state": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "template_version_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "template_version_preset_id": {
                    "description": "TemplateVersionPresetID is the ID of the template version preset to use for the build.",
                    "type": "string",
                    "format": "uuid"
                },
                "transition": {
                    "enum": [
                        "start",
                        "stop",
                        "delete"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceTransition"
                        }
                    ]
                }
            }
        },
        "codersdk.CreateWorkspaceProxyRequest": {
            "type": "object",
            "required": [
                "name"
            ],
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.CreateWorkspaceRequest": {
            "description": "CreateWorkspaceRequest provides options for creating a new workspace. Only one of TemplateID or TemplateVersionID can be specified, not both. If TemplateID is specified, the active version of the template will be used. Workspace names: - Must start with a letter or number - Can only contain letters, numbers, and hyphens - Cannot contain spaces or special characters - Cannot be named ` + "`" + `new` + "`" + ` or ` + "`" + `create` + "`" + ` - Must be unique within your workspaces - Maximum length of 32 characters",
            "type": "object",
            "required": [
                "name"
            ],
            "properties": {
                "automatic_updates": {
                    "$ref": "#/definitions/codersdk.AutomaticUpdates"
                },
                "autostart_schedule": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "rich_parameter_values": {
                    "description": "RichParameterValues allows for additional parameters to be provided\nduring the initial provision.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceBuildParameter"
                    }
                },
                "template_id": {
                    "description": "TemplateID specifies which template should be used for creating the workspace.",
                    "type": "string",
                    "format": "uuid"
                },
                "template_version_id": {
                    "description": "TemplateVersionID can be used to specify a specific version of a template for creating the workspace.",
                    "type": "string",
                    "format": "uuid"
                },
                "template_version_preset_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "ttl_ms": {
                    "type": "integer"
                }
            }
        },
        "codersdk.CryptoKey": {
            "type": "object",
            "properties": {
                "deletes_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "feature": {
                    "$ref": "#/definitions/codersdk.CryptoKeyFeature"
                },
                "secret": {
                    "type": "string"
                },
                "sequence": {
                    "type": "integer"
                },
                "starts_at": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.CryptoKeyFeature": {
            "type": "string",
            "enum": [
                "workspace_apps_api_key",
                "workspace_apps_token",
                "oidc_convert",
                "tailnet_resume"
            ],
            "x-enum-varnames": [
                "CryptoKeyFeatureWorkspaceAppsAPIKey",
                "CryptoKeyFeatureWorkspaceAppsToken",
                "CryptoKeyFeatureOIDCConvert",
                "CryptoKeyFeatureTailnetResume"
            ]
        },
        "codersdk.CustomNotificationContent": {
            "type": "object",
            "properties": {
                "message": {
                    "type": "string"
                },
                "title": {
                    "type": "string"
                }
            }
        },
        "codersdk.CustomNotificationRequest": {
            "type": "object",
            "properties": {
                "content": {
                    "$ref": "#/definitions/codersdk.CustomNotificationContent"
                }
            }
        },
        "codersdk.CustomRoleRequest": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "organization_member_permissions": {
                    "description": "OrganizationMemberPermissions are specific to the organization the role belongs to.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "organization_permissions": {
                    "description": "OrganizationPermissions are specific to the organization the role belongs to.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "site_permissions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "user_permissions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                }
            }
        },
        "codersdk.DAUEntry": {
            "type": "object",
            "properties": {
                "amount": {
                    "type": "integer"
                },
                "date": {
                    "description": "Date is a string formatted as 2024-01-31.\nTimezone and time information is not included.",
                    "type": "string"
                }
            }
        },
        "codersdk.DAUsResponse": {
            "type": "object",
            "properties": {
                "entries": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.DAUEntry"
                    }
                },
                "tz_hour_offset": {
                    "type": "integer"
                }
            }
        },
        "codersdk.DERP": {
            "type": "object",
            "properties": {
                "config": {
                    "$ref": "#/definitions/codersdk.DERPConfig"
                },
                "server": {
                    "$ref": "#/definitions/codersdk.DERPServerConfig"
                }
            }
        },
        "codersdk.DERPConfig": {
            "type": "object",
            "properties": {
                "block_direct": {
                    "type": "boolean"
                },
                "force_websockets": {
                    "type": "boolean"
                },
                "path": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "codersdk.DERPRegion": {
            "type": "object",
            "properties": {
                "latency_ms": {
                    "type": "number"
                },
                "preferred": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.DERPServerConfig": {
            "type": "object",
            "properties": {
                "enable": {
                    "type": "boolean"
                },
                "region_code": {
                    "type": "string"
                },
                "region_id": {
                    "type": "integer"
                },
                "region_name": {
                    "type": "string"
                },
                "relay_url": {
                    "$ref": "#/definitions/serpent.URL"
                },
                "stun_addresses": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.DangerousConfig": {
            "type": "object",
            "properties": {
                "allow_all_cors": {
                    "type": "boolean"
                },
                "allow_path_app_sharing": {
                    "type": "boolean"
                },
                "allow_path_app_site_owner_access": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.DeleteExternalAuthByIDResponse": {
            "type": "object",
            "properties": {
                "token_revocation_error": {
                    "type": "string"
                },
                "token_revoked": {
                    "description": "TokenRevoked set to true if token revocation was attempted and was successful",
                    "type": "boolean"
                }
            }
        },
        "codersdk.DeleteWebpushSubscription": {
            "type": "object",
            "properties": {
                "endpoint": {
                    "type": "string"
                }
            }
        },
        "codersdk.DeleteWorkspaceAgentPortShareRequest": {
            "type": "object",
            "properties": {
                "agent_name": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                }
            }
        },
        "codersdk.DeploymentConfig": {
            "type": "object",
            "properties": {
                "config": {
                    "$ref": "#/definitions/codersdk.DeploymentValues"
                },
                "options": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/serpent.Option"
                    }
                }
            }
        },
        "codersdk.DeploymentStats": {
            "type": "object",
            "properties": {
                "aggregated_from": {
                    "description": "AggregatedFrom is the time in which stats are aggregated from.\nThis might be back in time a specific duration or interval.",
                    "type": "string",
                    "format": "date-time"
                },
                "collected_at": {
                    "description": "CollectedAt is the time in which stats are collected at.",
                    "type": "string",
                    "format": "date-time"
                },
                "next_update_at": {
                    "description": "NextUpdateAt is the time when the next batch of stats will\nbe updated.",
                    "type": "string",
                    "format": "date-time"
                },
                "session_count": {
                    "$ref": "#/definitions/codersdk.SessionCountDeploymentStats"
                },
                "workspaces": {
                    "$ref": "#/definitions/codersdk.WorkspaceDeploymentStats"
                }
            }
        },
        "codersdk.DeploymentValues": {
            "type": "object",
            "properties": {
                "access_url": {
                    "$ref": "#/definitions/serpent.URL"
                },
                "additional_csp_policy": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "address": {
                    "description": "Deprecated: Use HTTPAddress or TLS.Address instead.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/serpent.HostPort"
                        }
                    ]
                },
                "agent_fallback_troubleshooting_url": {
                    "$ref": "#/definitions/serpent.URL"
                },
                "agent_stat_refresh_interval": {
                    "type": "integer"
                },
                "ai": {
                    "$ref": "#/definitions/codersdk.AIConfig"
                },
                "allow_workspace_renames": {
                    "type": "boolean"
                },
                "autobuild_poll_interval": {
                    "type": "integer"
                },
                "browser_only": {
                    "type": "boolean"
                },
                "cache_directory": {
                    "type": "string"
                },
                "cli_upgrade_message": {
                    "type": "string"
                },
                "config": {
                    "type": "string"
                },
                "config_ssh": {
                    "$ref": "#/definitions/codersdk.SSHConfig"
                },
                "dangerous": {
                    "$ref": "#/definitions/codersdk.DangerousConfig"
                },
                "derp": {
                    "$ref": "#/definitions/codersdk.DERP"
                },
                "disable_owner_workspace_exec": {
                    "type": "boolean"
                },
                "disable_password_auth": {
                    "type": "boolean"
                },
                "disable_path_apps": {
                    "type": "boolean"
                },
                "disable_workspace_sharing": {
                    "type": "boolean"
                },
                "docs_url": {
                    "$ref": "#/definitions/serpent.URL"
                },
                "enable_authz_recording": {
                    "type": "boolean"
                },
                "enable_terraform_debug_mode": {
                    "type": "boolean"
                },
                "ephemeral_deployment": {
                    "type": "boolean"
                },
                "experiments": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "external_auth": {
                    "$ref": "#/definitions/serpent.Struct-array_codersdk_ExternalAuthConfig"
                },
                "external_token_encryption_keys": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "healthcheck": {
                    "$ref": "#/definitions/codersdk.HealthcheckConfig"
                },
                "hide_ai_tasks": {
                    "type": "boolean"
                },
                "http_address": {
                    "description": "HTTPAddress is a string because it may be set to zero to disable.",
                    "type": "string"
                },
                "http_cookies": {
                    "$ref": "#/definitions/codersdk.HTTPCookieConfig"
                },
                "job_hang_detector_interval": {
                    "type": "integer"
                },
                "logging": {
                    "$ref": "#/definitions/codersdk.LoggingConfig"
                },
                "metrics_cache_refresh_interval": {
                    "type": "integer"
                },
                "notifications": {
                    "$ref": "#/definitions/codersdk.NotificationsConfig"
                },
                "oauth2": {
                    "$ref": "#/definitions/codersdk.OAuth2Config"
                },
                "oidc": {
                    "$ref": "#/definitions/codersdk.OIDCConfig"
                },
                "pg_auth": {
                    "type": "string"
                },
                "pg_conn_max_idle": {
                    "type": "string"
                },
                "pg_conn_max_open": {
                    "type": "integer"
                },
                "pg_connection_url": {
                    "type": "string"
                },
                "pprof": {
                    "$ref": "#/definitions/codersdk.PprofConfig"
                },
                "prometheus": {
                    "$ref": "#/definitions/codersdk.PrometheusConfig"
                },
                "provisioner": {
                    "$ref": "#/definitions/codersdk.ProvisionerConfig"
                },
                "proxy_health_status_interval": {
                    "type": "integer"
                },
                "proxy_trusted_headers": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "proxy_trusted_origins": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "rate_limit": {
                    "$ref": "#/definitions/codersdk.RateLimitConfig"
                },
                "redirect_to_access_url": {
                    "type": "boolean"
                },
                "retention": {
                    "$ref": "#/definitions/codersdk.RetentionConfig"
                },
                "scim_api_key": {
                    "type": "string"
                },
                "session_lifetime": {
                    "$ref": "#/definitions/codersdk.SessionLifetime"
                },
                "ssh_keygen_algorithm": {
                    "type": "string"
                },
                "stats_collection": {
                    "$ref": "#/definitions/codersdk.StatsCollectionConfig"
                },
                "strict_transport_security": {
                    "type": "integer"
                },
                "strict_transport_security_options": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "support": {
                    "$ref": "#/definitions/codersdk.SupportConfig"
                },
                "swagger": {
                    "$ref": "#/definitions/codersdk.SwaggerConfig"
                },
                "telemetry": {
                    "$ref": "#/definitions/codersdk.TelemetryConfig"
                },
                "terms_of_service_url": {
                    "type": "string"
                },
                "tls": {
                    "$ref": "#/definitions/codersdk.TLSConfig"
                },
                "trace": {
                    "$ref": "#/definitions/codersdk.TraceConfig"
                },
                "update_check": {
                    "type": "boolean"
                },
                "user_quiet_hours_schedule": {
                    "$ref": "#/definitions/codersdk.UserQuietHoursScheduleConfig"
                },
                "verbose": {
                    "type": "boolean"
                },
                "web_terminal_renderer": {
                    "type": "string"
                },
                "wgtunnel_host": {
                    "type": "string"
                },
                "wildcard_access_url": {
                    "type": "string"
                },
                "workspace_hostname_suffix": {
                    "type": "string"
                },
                "workspace_prebuilds": {
                    "$ref": "#/definitions/codersdk.PrebuildsConfig"
                },
                "write_config": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.DiagnosticExtra": {
            "type": "object",
            "properties": {
                "code": {
                    "type": "string"
                }
            }
        },
        "codersdk.DiagnosticSeverityString": {
            "type": "string",
            "enum": [
                "error",
                "warning"
            ],
            "x-enum-varnames": [
                "DiagnosticSeverityError",
                "DiagnosticSeverityWarning"
            ]
        },
        "codersdk.DisplayApp": {
            "type": "string",
            "enum": [
                "vscode",
                "vscode_insiders",
                "web_terminal",
                "port_forwarding_helper",
                "ssh_helper"
            ],
            "x-enum-varnames": [
                "DisplayAppVSCodeDesktop",
                "DisplayAppVSCodeInsiders",
                "DisplayAppWebTerminal",
                "DisplayAppPortForward",
                "DisplayAppSSH"
            ]
        },
        "codersdk.DynamicParametersRequest": {
            "type": "object",
            "properties": {
                "id": {
                    "description": "ID identifies the request. The response contains the same\nID so that the client can match it to the request.",
                    "type": "integer"
                },
                "inputs": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "owner_id": {
                    "description": "OwnerID if uuid.Nil, it defaults to ` + "`" + `codersdk.Me` + "`" + `",
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.DynamicParametersResponse": {
            "type": "object",
            "properties": {
                "diagnostics": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.FriendlyDiagnostic"
                    }
                },
                "id": {
                    "type": "integer"
                },
                "parameters": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.PreviewParameter"
                    }
                }
            }
        },
        "codersdk.Entitlement": {
            "type": "string",
            "enum": [
                "entitled",
                "grace_period",
                "not_entitled"
            ],
            "x-enum-varnames": [
                "EntitlementEntitled",
                "EntitlementGracePeriod",
                "EntitlementNotEntitled"
            ]
        },
        "codersdk.Entitlements": {
            "type": "object",
            "properties": {
                "errors": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "features": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/codersdk.Feature"
                    }
                },
                "has_license": {
                    "type": "boolean"
                },
                "refreshed_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "require_telemetry": {
                    "type": "boolean"
                },
                "trial": {
                    "type": "boolean"
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.Experiment": {
            "type": "string",
            "enum": [
                "example",
                "auto-fill-parameters",
                "notifications",
                "workspace-usage",
                "web-push",
                "oauth2",
                "mcp-server-http",
                "workspace-sharing"
            ],
            "x-enum-comments": {
                "ExperimentAutoFillParameters": "This should not be taken out of experiments until we have redesigned the feature.",
                "ExperimentExample": "This isn't used for anything.",
                "ExperimentMCPServerHTTP": "Enables the MCP HTTP server functionality.",
                "ExperimentNotifications": "Sends notifications via SMTP and webhooks following certain events.",
                "ExperimentOAuth2": "Enables OAuth2 provider functionality.",
                "ExperimentWebPush": "Enables web push notifications through the browser.",
                "ExperimentWorkspaceSharing": "Enables updating workspace ACLs for sharing with users and groups.",
                "ExperimentWorkspaceUsage": "Enables the new workspace usage tracking."
            },
            "x-enum-varnames": [
                "ExperimentExample",
                "ExperimentAutoFillParameters",
                "ExperimentNotifications",
                "ExperimentWorkspaceUsage",
                "ExperimentWebPush",
                "ExperimentOAuth2",
                "ExperimentMCPServerHTTP",
                "ExperimentWorkspaceSharing"
            ]
        },
        "codersdk.ExternalAPIKeyScopes": {
            "type": "object",
            "properties": {
                "external": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.APIKeyScope"
                    }
                }
            }
        },
        "codersdk.ExternalAgentCredentials": {
            "type": "object",
            "properties": {
                "agent_token": {
                    "type": "string"
                },
                "command": {
                    "type": "string"
                }
            }
        },
        "codersdk.ExternalAuth": {
            "type": "object",
            "properties": {
                "app_install_url": {
                    "description": "AppInstallURL is the URL to install the app.",
                    "type": "string"
                },
                "app_installable": {
                    "description": "AppInstallable is true if the request for app installs was successful.",
                    "type": "boolean"
                },
                "authenticated": {
                    "type": "boolean"
                },
                "device": {
                    "type": "boolean"
                },
                "display_name": {
                    "type": "string"
                },
                "installations": {
                    "description": "AppInstallations are the installations that the user has access to.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ExternalAuthAppInstallation"
                    }
                },
                "supports_revocation": {
                    "type": "boolean"
                },
                "user": {
                    "description": "User is the user that authenticated with the provider.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ExternalAuthUser"
                        }
                    ]
                }
            }
        },
        "codersdk.ExternalAuthAppInstallation": {
            "type": "object",
            "properties": {
                "account": {
                    "$ref": "#/definitions/codersdk.ExternalAuthUser"
                },
                "configure_url": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                }
            }
        },
        "codersdk.ExternalAuthConfig": {
            "type": "object",
            "properties": {
                "app_install_url": {
                    "type": "string"
                },
                "app_installations_url": {
                    "type": "string"
                },
                "auth_url": {
                    "type": "string"
                },
                "client_id": {
                    "type": "string"
                },
                "code_challenge_methods_supported": {
                    "description": "CodeChallengeMethodsSupported lists the PKCE code challenge methods\nThe only one supported by Coder is \"S256\".",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "device_code_url": {
                    "type": "string"
                },
                "device_flow": {
                    "type": "boolean"
                },
                "display_icon": {
                    "description": "DisplayIcon is a URL to an icon to display in the UI.",
                    "type": "string"
                },
                "display_name": {
                    "description": "DisplayName is shown in the UI to identify the auth config.",
                    "type": "string"
                },
                "id": {
                    "description": "ID is a unique identifier for the auth config.\nIt defaults to ` + "`" + `type` + "`" + ` when not provided.",
                    "type": "string"
                },
                "mcp_tool_allow_regex": {
                    "type": "string"
                },
                "mcp_tool_deny_regex": {
                    "type": "string"
                },
                "mcp_url": {
                    "type": "string"
                },
                "no_refresh": {
                    "type": "boolean"
                },
                "regex": {
                    "description": "Regex allows API requesters to match an auth config by\na string (e.g. coder.com) instead of by it's type.\n\nGit clone makes use of this by parsing the URL from:\n'Username for \"https://github.com\":'\nAnd sending it to the Coder server to match against the Regex.",
                    "type": "string"
                },
                "revoke_url": {
                    "type": "string"
                },
                "scopes": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "token_url": {
                    "type": "string"
                },
                "type": {
                    "description": "Type is the type of external auth config.",
                    "type": "string"
                },
                "validate_url": {
                    "type": "string"
                }
            }
        },
        "codersdk.ExternalAuthDevice": {
            "type": "object",
            "properties": {
                "device_code": {
                    "type": "string"
                },
                "expires_in": {
                    "type": "integer"
                },
                "interval": {
                    "type": "integer"
                },
                "user_code": {
                    "type": "string"
                },
                "verification_uri": {
                    "type": "string"
                }
            }
        },
        "codersdk.ExternalAuthLink": {
            "type": "object",
            "properties": {
                "authenticated": {
                    "type": "boolean"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "expires": {
                    "type": "string",
                    "format": "date-time"
                },
                "has_refresh_token": {
                    "type": "boolean"
                },
                "provider_id": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "validate_error": {
                    "type": "string"
                }
            }
        },
        "codersdk.ExternalAuthUser": {
            "type": "object",
            "properties": {
                "avatar_url": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "login": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "profile_url": {
                    "type": "string"
                }
            }
        },
        "codersdk.Feature": {
            "type": "object",
            "properties": {
                "actual": {
                    "type": "integer"
                },
                "enabled": {
                    "type": "boolean"
                },
                "entitlement": {
                    "$ref": "#/definitions/codersdk.Entitlement"
                },
                "limit": {
                    "type": "integer"
                },
                "usage_period": {
                    "description": "UsagePeriod denotes that the usage is a counter that accumulates over\nthis period (and most likely resets with the issuance of the next\nlicense).\n\nThese dates are determined from the license that this entitlement comes\nfrom, see enterprise/coderd/license/license.go.\n\nOnly certain features set these fields:\n- FeatureManagedAgentLimit",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.UsagePeriod"
                        }
                    ]
                }
            }
        },
        "codersdk.FriendlyDiagnostic": {
            "type": "object",
            "properties": {
                "detail": {
                    "type": "string"
                },
                "extra": {
                    "$ref": "#/definitions/codersdk.DiagnosticExtra"
                },
                "severity": {
                    "$ref": "#/definitions/codersdk.DiagnosticSeverityString"
                },
                "summary": {
                    "type": "string"
                }
            }
        },
        "codersdk.GenerateAPIKeyResponse": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string"
                }
            }
        },
        "codersdk.GetInboxNotificationResponse": {
            "type": "object",
            "properties": {
                "notification": {
                    "$ref": "#/definitions/codersdk.InboxNotification"
                },
                "unread_count": {
                    "type": "integer"
                }
            }
        },
        "codersdk.GetUserStatusCountsResponse": {
            "type": "object",
            "properties": {
                "status_counts": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "array",
                        "items": {
                            "$ref": "#/definitions/codersdk.UserStatusChangeCount"
                        }
                    }
                }
            }
        },
        "codersdk.GetUsersResponse": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "users": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.User"
                    }
                }
            }
        },
        "codersdk.GitSSHKey": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "public_key": {
                    "description": "PublicKey is the SSH public key in OpenSSH format.\nExample: \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAID3OmYJvT7q1cF1azbybYy0OZ9yrXfA+M6Lr4vzX5zlp\\n\"\nNote: The key includes a trailing newline (\\n).",
                    "type": "string"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.GithubAuthMethod": {
            "type": "object",
            "properties": {
                "default_provider_configured": {
                    "type": "boolean"
                },
                "enabled": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.Group": {
            "type": "object",
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "members": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ReducedUser"
                    }
                },
                "name": {
                    "type": "string"
                },
                "organization_display_name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "organization_name": {
                    "type": "string"
                },
                "quota_allowance": {
                    "type": "integer"
                },
                "source": {
                    "$ref": "#/definitions/codersdk.GroupSource"
                },
                "total_member_count": {
                    "description": "How many members are in this group. Shows the total count,\neven if the user is not authorized to read group member details.\nMay be greater than ` + "`" + `len(Group.Members)` + "`" + `.",
                    "type": "integer"
                }
            }
        },
        "codersdk.GroupSource": {
            "type": "string",
            "enum": [
                "user",
                "oidc"
            ],
            "x-enum-varnames": [
                "GroupSourceUser",
                "GroupSourceOIDC"
            ]
        },
        "codersdk.GroupSyncSettings": {
            "type": "object",
            "properties": {
                "auto_create_missing_groups": {
                    "description": "AutoCreateMissing controls whether groups returned by the OIDC provider\nare automatically created in Coder if they are missing.",
                    "type": "boolean"
                },
                "field": {
                    "description": "Field is the name of the claim field that specifies what groups a user\nshould be in. If empty, no groups will be synced.",
                    "type": "string"
                },
                "legacy_group_name_mapping": {
                    "description": "LegacyNameMapping is deprecated. It remaps an IDP group name to\na Coder group name. Since configuration is now done at runtime,\ngroup IDs are used to account for group renames.\nFor legacy configurations, this config option has to remain.\nDeprecated: Use Mapping instead.",
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "mapping": {
                    "description": "Mapping is a map from OIDC groups to Coder group IDs",
                    "type": "object",
                    "additionalProperties": {
                        "type": "array",
                        "items": {
                            "type": "string"
                        }
                    }
                },
                "regex_filter": {
                    "description": "RegexFilter is a regular expression that filters the groups returned by\nthe OIDC provider. Any group not matched by this regex will be ignored.\nIf the group filter is nil, then no group filtering will occur.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/regexp.Regexp"
                        }
                    ]
                }
            }
        },
        "codersdk.HTTPCookieConfig": {
            "type": "object",
            "properties": {
                "same_site": {
                    "type": "string"
                },
                "secure_auth_cookie": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.Healthcheck": {
            "type": "object",
            "properties": {
                "interval": {
                    "description": "Interval specifies the seconds between each health check.",
                    "type": "integer"
                },
                "threshold": {
                    "description": "Threshold specifies the number of consecutive failed health checks before returning \"unhealthy\".",
                    "type": "integer"
                },
                "url": {
                    "description": "URL specifies the endpoint to check for the app health.",
                    "type": "string"
                }
            }
        },
        "codersdk.HealthcheckConfig": {
            "type": "object",
            "properties": {
                "refresh": {
                    "type": "integer"
                },
                "threshold_database": {
                    "type": "integer"
                }
            }
        },
        "codersdk.InboxNotification": {
            "type": "object",
            "properties": {
                "actions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.InboxNotificationAction"
                    }
                },
                "content": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "read_at": {
                    "type": "string"
                },
                "targets": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "template_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "title": {
                    "type": "string"
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.InboxNotificationAction": {
            "type": "object",
            "properties": {
                "label": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "codersdk.InsightsReportInterval": {
            "type": "string",
            "enum": [
                "day",
                "week"
            ],
            "x-enum-varnames": [
                "InsightsReportIntervalDay",
                "InsightsReportIntervalWeek"
            ]
        },
        "codersdk.InvalidatePresetsResponse": {
            "type": "object",
            "properties": {
                "invalidated": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.InvalidatedPreset"
                    }
                }
            }
        },
        "codersdk.InvalidatedPreset": {
            "type": "object",
            "properties": {
                "preset_name": {
                    "type": "string"
                },
                "template_name": {
                    "type": "string"
                },
                "template_version_name": {
                    "type": "string"
                }
            }
        },
        "codersdk.IssueReconnectingPTYSignedTokenRequest": {
            "type": "object",
            "required": [
                "agentID",
                "url"
            ],
            "properties": {
                "agentID": {
                    "type": "string",
                    "format": "uuid"
                },
                "url": {
                    "description": "URL is the URL of the reconnecting-pty endpoint you are connecting to.",
                    "type": "string"
                }
            }
        },
        "codersdk.IssueReconnectingPTYSignedTokenResponse": {
            "type": "object",
            "properties": {
                "signed_token": {
                    "type": "string"
                }
            }
        },
        "codersdk.JobErrorCode": {
            "type": "string",
            "enum": [
                "REQUIRED_TEMPLATE_VARIABLES"
            ],
            "x-enum-varnames": [
                "RequiredTemplateVariables"
            ]
        },
        "codersdk.License": {
            "type": "object",
            "properties": {
                "claims": {
                    "description": "Claims are the JWT claims asserted by the license.  Here we use\na generic string map to ensure that all data from the server is\nparsed verbatim, not just the fields this version of Coder\nunderstands.",
                    "type": "object",
                    "additionalProperties": true
                },
                "id": {
                    "type": "integer"
                },
                "uploaded_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "uuid": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.LinkConfig": {
            "type": "object",
            "properties": {
                "icon": {
                    "type": "string",
                    "enum": [
                        "bug",
                        "chat",
                        "docs",
                        "star"
                    ]
                },
                "location": {
                    "type": "string",
                    "enum": [
                        "navbar",
                        "dropdown"
                    ]
                },
                "name": {
                    "type": "string"
                },
                "target": {
                    "type": "string"
                }
            }
        },
        "codersdk.ListInboxNotificationsResponse": {
            "type": "object",
            "properties": {
                "notifications": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.InboxNotification"
                    }
                },
                "unread_count": {
                    "type": "integer"
                }
            }
        },
        "codersdk.LogLevel": {
            "type": "string",
            "enum": [
                "trace",
                "debug",
                "info",
                "warn",
                "error"
            ],
            "x-enum-varnames": [
                "LogLevelTrace",
                "LogLevelDebug",
                "LogLevelInfo",
                "LogLevelWarn",
                "LogLevelError"
            ]
        },
        "codersdk.LogSource": {
            "type": "string",
            "enum": [
                "provisioner_daemon",
                "provisioner"
            ],
            "x-enum-varnames": [
                "LogSourceProvisionerDaemon",
                "LogSourceProvisioner"
            ]
        },
        "codersdk.LoggingConfig": {
            "type": "object",
            "properties": {
                "human": {
                    "type": "string"
                },
                "json": {
                    "type": "string"
                },
                "log_filter": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "stackdriver": {
                    "type": "string"
                }
            }
        },
        "codersdk.LoginType": {
            "type": "string",
            "enum": [
                "",
                "password",
                "github",
                "oidc",
                "token",
                "none"
            ],
            "x-enum-varnames": [
                "LoginTypeUnknown",
                "LoginTypePassword",
                "LoginTypeGithub",
                "LoginTypeOIDC",
                "LoginTypeToken",
                "LoginTypeNone"
            ]
        },
        "codersdk.LoginWithPasswordRequest": {
            "type": "object",
            "required": [
                "email",
                "password"
            ],
            "properties": {
                "email": {
                    "type": "string",
                    "format": "email"
                },
                "password": {
                    "type": "string"
                }
            }
        },
        "codersdk.LoginWithPasswordResponse": {
            "type": "object",
            "required": [
                "session_token"
            ],
            "properties": {
                "session_token": {
                    "type": "string"
                }
            }
        },
        "codersdk.MatchedProvisioners": {
            "type": "object",
            "properties": {
                "available": {
                    "description": "Available is the number of provisioner daemons that are available to\ntake jobs. This may be less than the count if some provisioners are\nbusy or have been stopped.",
                    "type": "integer"
                },
                "count": {
                    "description": "Count is the number of provisioner daemons that matched the given\ntags. If the count is 0, it means no provisioner daemons matched the\nrequested tags.",
                    "type": "integer"
                },
                "most_recently_seen": {
                    "description": "MostRecentlySeen is the most recently seen time of the set of matched\nprovisioners. If no provisioners matched, this field will be null.",
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.MinimalOrganization": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.MinimalUser": {
            "type": "object",
            "required": [
                "id",
                "username"
            ],
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.NotificationMethodsResponse": {
            "type": "object",
            "properties": {
                "available": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "default": {
                    "type": "string"
                }
            }
        },
        "codersdk.NotificationPreference": {
            "type": "object",
            "properties": {
                "disabled": {
                    "type": "boolean"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.NotificationTemplate": {
            "type": "object",
            "properties": {
                "actions": {
                    "type": "string"
                },
                "body_template": {
                    "type": "string"
                },
                "enabled_by_default": {
                    "type": "boolean"
                },
                "group": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "kind": {
                    "type": "string"
                },
                "method": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "title_template": {
                    "type": "string"
                }
            }
        },
        "codersdk.NotificationsConfig": {
            "type": "object",
            "properties": {
                "dispatch_timeout": {
                    "description": "How long to wait while a notification is being sent before giving up.",
                    "type": "integer"
                },
                "email": {
                    "description": "SMTP settings.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.NotificationsEmailConfig"
                        }
                    ]
                },
                "fetch_interval": {
                    "description": "How often to query the database for queued notifications.",
                    "type": "integer"
                },
                "inbox": {
                    "description": "Inbox settings.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.NotificationsInboxConfig"
                        }
                    ]
                },
                "lease_count": {
                    "description": "How many notifications a notifier should lease per fetch interval.",
                    "type": "integer"
                },
                "lease_period": {
                    "description": "How long a notifier should lease a message. This is effectively how long a notification is 'owned'\nby a notifier, and once this period expires it will be available for lease by another notifier. Leasing\nis important in order for multiple running notifiers to not pick the same messages to deliver concurrently.\nThis lease period will only expire if a notifier shuts down ungracefully; a dispatch of the notification\nreleases the lease.",
                    "type": "integer"
                },
                "max_send_attempts": {
                    "description": "The upper limit of attempts to send a notification.",
                    "type": "integer"
                },
                "method": {
                    "description": "Which delivery method to use (available options: 'smtp', 'webhook').",
                    "type": "string"
                },
                "retry_interval": {
                    "description": "The minimum time between retries.",
                    "type": "integer"
                },
                "sync_buffer_size": {
                    "description": "The notifications system buffers message updates in memory to ease pressure on the database.\nThis option controls how many updates are kept in memory. The lower this value the\nlower the change of state inconsistency in a non-graceful shutdown - but it also increases load on the\ndatabase. It is recommended to keep this option at its default value.",
                    "type": "integer"
                },
                "sync_interval": {
                    "description": "The notifications system buffers message updates in memory to ease pressure on the database.\nThis option controls how often it synchronizes its state with the database. The shorter this value the\nlower the change of state inconsistency in a non-graceful shutdown - but it also increases load on the\ndatabase. It is recommended to keep this option at its default value.",
                    "type": "integer"
                },
                "webhook": {
                    "description": "Webhook settings.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.NotificationsWebhookConfig"
                        }
                    ]
                }
            }
        },
        "codersdk.NotificationsEmailAuthConfig": {
            "type": "object",
            "properties": {
                "identity": {
                    "description": "Identity for PLAIN auth.",
                    "type": "string"
                },
                "password": {
                    "description": "Password for LOGIN/PLAIN auth.",
                    "type": "string"
                },
                "password_file": {
                    "description": "File from which to load the password for LOGIN/PLAIN auth.",
                    "type": "string"
                },
                "username": {
                    "description": "Username for LOGIN/PLAIN auth.",
                    "type": "string"
                }
            }
        },
        "codersdk.NotificationsEmailConfig": {
            "type": "object",
            "properties": {
                "auth": {
                    "description": "Authentication details.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.NotificationsEmailAuthConfig"
                        }
                    ]
                },
                "force_tls": {
                    "description": "ForceTLS causes a TLS connection to be attempted.",
                    "type": "boolean"
                },
                "from": {
                    "description": "The sender's address.",
                    "type": "string"
                },
                "hello": {
                    "description": "The hostname identifying the SMTP server.",
                    "type": "string"
                },
                "smarthost": {
                    "description": "The intermediary SMTP host through which emails are sent (host:port).",
                    "type": "string"
                },
                "tls": {
                    "description": "TLS details.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.NotificationsEmailTLSConfig"
                        }
                    ]
                }
            }
        },
        "codersdk.NotificationsEmailTLSConfig": {
            "type": "object",
            "properties": {
                "ca_file": {
                    "description": "CAFile specifies the location of the CA certificate to use.",
                    "type": "string"
                },
                "cert_file": {
                    "description": "CertFile specifies the location of the certificate to use.",
                    "type": "string"
                },
                "insecure_skip_verify": {
                    "description": "InsecureSkipVerify skips target certificate validation.",
                    "type": "boolean"
                },
                "key_file": {
                    "description": "KeyFile specifies the location of the key to use.",
                    "type": "string"
                },
                "server_name": {
                    "description": "ServerName to verify the hostname for the targets.",
                    "type": "string"
                },
                "start_tls": {
                    "description": "StartTLS attempts to upgrade plain connections to TLS.",
                    "type": "boolean"
                }
            }
        },
        "codersdk.NotificationsInboxConfig": {
            "type": "object",
            "properties": {
                "enabled": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.NotificationsSettings": {
            "type": "object",
            "properties": {
                "notifier_paused": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.NotificationsWebhookConfig": {
            "type": "object",
            "properties": {
                "endpoint": {
                    "description": "The URL to which the payload will be sent with an HTTP POST request.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/serpent.URL"
                        }
                    ]
                }
            }
        },
        "codersdk.NullHCLString": {
            "type": "object",
            "properties": {
                "valid": {
                    "type": "boolean"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.OAuth2AppEndpoints": {
            "type": "object",
            "properties": {
                "authorization": {
                    "type": "string"
                },
                "device_authorization": {
                    "description": "DeviceAuth is optional.",
                    "type": "string"
                },
                "token": {
                    "type": "string"
                },
                "token_revoke": {
                    "type": "string"
                }
            }
        },
        "codersdk.OAuth2AuthorizationServerMetadata": {
            "type": "object",
            "properties": {
                "authorization_endpoint": {
                    "type": "string"
                },
                "code_challenge_methods_supported": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2PKCECodeChallengeMethod"
                    }
                },
                "grant_types_supported": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2ProviderGrantType"
                    }
                },
                "issuer": {
                    "type": "string"
                },
                "registration_endpoint": {
                    "type": "string"
                },
                "response_types_supported": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2ProviderResponseType"
                    }
                },
                "revocation_endpoint": {
                    "type": "string"
                },
                "scopes_supported": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "token_endpoint": {
                    "type": "string"
                },
                "token_endpoint_auth_methods_supported": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2TokenEndpointAuthMethod"
                    }
                }
            }
        },
        "codersdk.OAuth2ClientConfiguration": {
            "type": "object",
            "properties": {
                "client_id": {
                    "type": "string"
                },
                "client_id_issued_at": {
                    "type": "integer"
                },
                "client_name": {
                    "type": "string"
                },
                "client_secret_expires_at": {
                    "type": "integer"
                },
                "client_uri": {
                    "type": "string"
                },
                "contacts": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "grant_types": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2ProviderGrantType"
                    }
                },
                "jwks": {
                    "type": "object"
                },
                "jwks_uri": {
                    "type": "string"
                },
                "logo_uri": {
                    "type": "string"
                },
                "policy_uri": {
                    "type": "string"
                },
                "redirect_uris": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "registration_access_token": {
                    "type": "string"
                },
                "registration_client_uri": {
                    "type": "string"
                },
                "response_types": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2ProviderResponseType"
                    }
                },
                "scope": {
                    "type": "string"
                },
                "software_id": {
                    "type": "string"
                },
                "software_version": {
                    "type": "string"
                },
                "token_endpoint_auth_method": {
                    "$ref": "#/definitions/codersdk.OAuth2TokenEndpointAuthMethod"
                },
                "tos_uri": {
                    "type": "string"
                }
            }
        },
        "codersdk.OAuth2ClientRegistrationRequest": {
            "type": "object",
            "properties": {
                "client_name": {
                    "type": "string"
                },
                "client_uri": {
                    "type": "string"
                },
                "contacts": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "grant_types": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2ProviderGrantType"
                    }
                },
                "jwks": {
                    "type": "object"
                },
                "jwks_uri": {
                    "type": "string"
                },
                "logo_uri": {
                    "type": "string"
                },
                "policy_uri": {
                    "type": "string"
                },
                "redirect_uris": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "response_types": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2ProviderResponseType"
                    }
                },
                "scope": {
                    "type": "string"
                },
                "software_id": {
                    "type": "string"
                },
                "software_statement": {
                    "type": "string"
                },
                "software_version": {
                    "type": "string"
                },
                "token_endpoint_auth_method": {
                    "$ref": "#/definitions/codersdk.OAuth2TokenEndpointAuthMethod"
                },
                "tos_uri": {
                    "type": "string"
                }
            }
        },
        "codersdk.OAuth2ClientRegistrationResponse": {
            "type": "object",
            "properties": {
                "client_id": {
                    "type": "string"
                },
                "client_id_issued_at": {
                    "type": "integer"
                },
                "client_name": {
                    "type": "string"
                },
                "client_secret": {
                    "type": "string"
                },
                "client_secret_expires_at": {
                    "type": "integer"
                },
                "client_uri": {
                    "type": "string"
                },
                "contacts": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "grant_types": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2ProviderGrantType"
                    }
                },
                "jwks": {
                    "type": "object"
                },
                "jwks_uri": {
                    "type": "string"
                },
                "logo_uri": {
                    "type": "string"
                },
                "policy_uri": {
                    "type": "string"
                },
                "redirect_uris": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "registration_access_token": {
                    "type": "string"
                },
                "registration_client_uri": {
                    "type": "string"
                },
                "response_types": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OAuth2ProviderResponseType"
                    }
                },
                "scope": {
                    "type": "string"
                },
                "software_id": {
                    "type": "string"
                },
                "software_version": {
                    "type": "string"
                },
                "token_endpoint_auth_method": {
                    "$ref": "#/definitions/codersdk.OAuth2TokenEndpointAuthMethod"
                },
                "tos_uri": {
                    "type": "string"
                }
            }
        },
        "codersdk.OAuth2Config": {
            "type": "object",
            "properties": {
                "github": {
                    "$ref": "#/definitions/codersdk.OAuth2GithubConfig"
                }
            }
        },
        "codersdk.OAuth2GithubConfig": {
            "type": "object",
            "properties": {
                "allow_everyone": {
                    "type": "boolean"
                },
                "allow_signups": {
                    "type": "boolean"
                },
                "allowed_orgs": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "allowed_teams": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "client_id": {
                    "type": "string"
                },
                "client_secret": {
                    "type": "string"
                },
                "default_provider_enable": {
                    "type": "boolean"
                },
                "device_flow": {
                    "type": "boolean"
                },
                "enterprise_base_url": {
                    "type": "string"
                }
            }
        },
        "codersdk.OAuth2PKCECodeChallengeMethod": {
            "type": "string",
            "enum": [
                "S256",
                "plain"
            ],
            "x-enum-varnames": [
                "OAuth2PKCECodeChallengeMethodS256",
                "OAuth2PKCECodeChallengeMethodPlain"
            ]
        },
        "codersdk.OAuth2ProtectedResourceMetadata": {
            "type": "object",
            "properties": {
                "authorization_servers": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "bearer_methods_supported": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "resource": {
                    "type": "string"
                },
                "scopes_supported": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.OAuth2ProviderApp": {
            "type": "object",
            "properties": {
                "callback_url": {
                    "type": "string"
                },
                "endpoints": {
                    "description": "Endpoints are included in the app response for easier discovery. The OAuth2\nspec does not have a defined place to find these (for comparison, OIDC has\na '/.well-known/openid-configuration' endpoint).",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.OAuth2AppEndpoints"
                        }
                    ]
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.OAuth2ProviderAppSecret": {
            "type": "object",
            "properties": {
                "client_secret_truncated": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "last_used_at": {
                    "type": "string"
                }
            }
        },
        "codersdk.OAuth2ProviderAppSecretFull": {
            "type": "object",
            "properties": {
                "client_secret_full": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.OAuth2ProviderGrantType": {
            "type": "string",
            "enum": [
                "authorization_code",
                "refresh_token",
                "password",
                "client_credentials",
                "implicit"
            ],
            "x-enum-varnames": [
                "OAuth2ProviderGrantTypeAuthorizationCode",
                "OAuth2ProviderGrantTypeRefreshToken",
                "OAuth2ProviderGrantTypePassword",
                "OAuth2ProviderGrantTypeClientCredentials",
                "OAuth2ProviderGrantTypeImplicit"
            ]
        },
        "codersdk.OAuth2ProviderResponseType": {
            "type": "string",
            "enum": [
                "code",
                "token"
            ],
            "x-enum-varnames": [
                "OAuth2ProviderResponseTypeCode",
                "OAuth2ProviderResponseTypeToken"
            ]
        },
        "codersdk.OAuth2TokenEndpointAuthMethod": {
            "type": "string",
            "enum": [
                "client_secret_basic",
                "client_secret_post",
                "none"
            ],
            "x-enum-varnames": [
                "OAuth2TokenEndpointAuthMethodClientSecretBasic",
                "OAuth2TokenEndpointAuthMethodClientSecretPost",
                "OAuth2TokenEndpointAuthMethodNone"
            ]
        },
        "codersdk.OAuthConversionResponse": {
            "type": "object",
            "properties": {
                "expires_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "state_string": {
                    "type": "string"
                },
                "to_type": {
                    "$ref": "#/definitions/codersdk.LoginType"
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.OIDCAuthMethod": {
            "type": "object",
            "properties": {
                "enabled": {
                    "type": "boolean"
                },
                "iconUrl": {
                    "type": "string"
                },
                "signInText": {
                    "type": "string"
                }
            }
        },
        "codersdk.OIDCConfig": {
            "type": "object",
            "properties": {
                "allow_signups": {
                    "type": "boolean"
                },
                "auth_url_params": {
                    "type": "object"
                },
                "client_cert_file": {
                    "type": "string"
                },
                "client_id": {
                    "type": "string"
                },
                "client_key_file": {
                    "description": "ClientKeyFile \u0026 ClientCertFile are used in place of ClientSecret for PKI auth.",
                    "type": "string"
                },
                "client_secret": {
                    "type": "string"
                },
                "email_domain": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "email_field": {
                    "type": "string"
                },
                "group_allow_list": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "group_auto_create": {
                    "type": "boolean"
                },
                "group_mapping": {
                    "type": "object"
                },
                "group_regex_filter": {
                    "$ref": "#/definitions/serpent.Regexp"
                },
                "groups_field": {
                    "type": "string"
                },
                "icon_url": {
                    "$ref": "#/definitions/serpent.URL"
                },
                "ignore_email_verified": {
                    "type": "boolean"
                },
                "ignore_user_info": {
                    "description": "IgnoreUserInfo \u0026 UserInfoFromAccessToken are mutually exclusive. Only 1\ncan be set to true. Ideally this would be an enum with 3 states, ['none',\n'userinfo', 'access_token']. However, for backward compatibility,\n` + "`" + `ignore_user_info` + "`" + ` must remain. And ` + "`" + `access_token` + "`" + ` is a niche, non-spec\ncompliant edge case. So it's use is rare, and should not be advised.",
                    "type": "boolean"
                },
                "issuer_url": {
                    "type": "string"
                },
                "name_field": {
                    "type": "string"
                },
                "organization_assign_default": {
                    "type": "boolean"
                },
                "organization_field": {
                    "type": "string"
                },
                "organization_mapping": {
                    "type": "object"
                },
                "scopes": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "sign_in_text": {
                    "type": "string"
                },
                "signups_disabled_text": {
                    "type": "string"
                },
                "skip_issuer_checks": {
                    "type": "boolean"
                },
                "source_user_info_from_access_token": {
                    "description": "UserInfoFromAccessToken as mentioned above is an edge case. This allows\nsourcing the user_info from the access token itself instead of a user_info\nendpoint. This assumes the access token is a valid JWT with a set of claims to\nbe merged with the id_token.",
                    "type": "boolean"
                },
                "user_role_field": {
                    "type": "string"
                },
                "user_role_mapping": {
                    "type": "object"
                },
                "user_roles_default": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "username_field": {
                    "type": "string"
                }
            }
        },
        "codersdk.OptionType": {
            "type": "string",
            "enum": [
                "string",
                "number",
                "bool",
                "list(string)"
            ],
            "x-enum-varnames": [
                "OptionTypeString",
                "OptionTypeNumber",
                "OptionTypeBoolean",
                "OptionTypeListString"
            ]
        },
        "codersdk.Organization": {
            "type": "object",
            "required": [
                "created_at",
                "id",
                "is_default",
                "updated_at"
            ],
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "description": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "is_default": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.OrganizationMember": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "roles": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.SlimRole"
                    }
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.OrganizationMemberWithUserData": {
            "type": "object",
            "properties": {
                "avatar_url": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "email": {
                    "type": "string"
                },
                "global_roles": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.SlimRole"
                    }
                },
                "name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "roles": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.SlimRole"
                    }
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.OrganizationSyncSettings": {
            "type": "object",
            "properties": {
                "field": {
                    "description": "Field selects the claim field to be used as the created user's\norganizations. If the field is the empty string, then no organization\nupdates will ever come from the OIDC provider.",
                    "type": "string"
                },
                "mapping": {
                    "description": "Mapping maps from an OIDC claim --\u003e Coder organization uuid",
                    "type": "object",
                    "additionalProperties": {
                        "type": "array",
                        "items": {
                            "type": "string"
                        }
                    }
                },
                "organization_assign_default": {
                    "description": "AssignDefault will ensure the default org is always included\nfor every user, regardless of their claims. This preserves legacy behavior.",
                    "type": "boolean"
                }
            }
        },
        "codersdk.PaginatedMembersResponse": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "members": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.OrganizationMemberWithUserData"
                    }
                }
            }
        },
        "codersdk.ParameterFormType": {
            "type": "string",
            "enum": [
                "",
                "radio",
                "slider",
                "input",
                "dropdown",
                "checkbox",
                "switch",
                "multi-select",
                "tag-select",
                "textarea",
                "error"
            ],
            "x-enum-varnames": [
                "ParameterFormTypeDefault",
                "ParameterFormTypeRadio",
                "ParameterFormTypeSlider",
                "ParameterFormTypeInput",
                "ParameterFormTypeDropdown",
                "ParameterFormTypeCheckbox",
                "ParameterFormTypeSwitch",
                "ParameterFormTypeMultiSelect",
                "ParameterFormTypeTagSelect",
                "ParameterFormTypeTextArea",
                "ParameterFormTypeError"
            ]
        },
        "codersdk.PatchGroupIDPSyncConfigRequest": {
            "type": "object",
            "properties": {
                "auto_create_missing_groups": {
                    "type": "boolean"
                },
                "field": {
                    "type": "string"
                },
                "regex_filter": {
                    "$ref": "#/definitions/regexp.Regexp"
                }
            }
        },
        "codersdk.PatchGroupIDPSyncMappingRequest": {
            "type": "object",
            "properties": {
                "add": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "gets": {
                                "description": "The ID of the Coder resource the user should be added to",
                                "type": "string"
                            },
                            "given": {
                                "description": "The IdP claim the user has",
                                "type": "string"
                            }
                        }
                    }
                },
                "remove": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "gets": {
                                "description": "The ID of the Coder resource the user should be added to",
                                "type": "string"
                            },
                            "given": {
                                "description": "The IdP claim the user has",
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "codersdk.PatchGroupRequest": {
            "type": "object",
            "properties": {
                "add_users": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "avatar_url": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "quota_allowance": {
                    "type": "integer"
                },
                "remove_users": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.PatchOrganizationIDPSyncConfigRequest": {
            "type": "object",
            "properties": {
                "assign_default": {
                    "type": "boolean"
                },
                "field": {
                    "type": "string"
                }
            }
        },
        "codersdk.PatchOrganizationIDPSyncMappingRequest": {
            "type": "object",
            "properties": {
                "add": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "gets": {
                                "description": "The ID of the Coder resource the user should be added to",
                                "type": "string"
                            },
                            "given": {
                                "description": "The IdP claim the user has",
                                "type": "string"
                            }
                        }
                    }
                },
                "remove": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "gets": {
                                "description": "The ID of the Coder resource the user should be added to",
                                "type": "string"
                            },
                            "given": {
                                "description": "The IdP claim the user has",
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "codersdk.PatchRoleIDPSyncConfigRequest": {
            "type": "object",
            "properties": {
                "field": {
                    "type": "string"
                }
            }
        },
        "codersdk.PatchRoleIDPSyncMappingRequest": {
            "type": "object",
            "properties": {
                "add": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "gets": {
                                "description": "The ID of the Coder resource the user should be added to",
                                "type": "string"
                            },
                            "given": {
                                "description": "The IdP claim the user has",
                                "type": "string"
                            }
                        }
                    }
                },
                "remove": {
                    "type": "array",
                    "items": {
                        "type": "object",
                        "properties": {
                            "gets": {
                                "description": "The ID of the Coder resource the user should be added to",
                                "type": "string"
                            },
                            "given": {
                                "description": "The IdP claim the user has",
                                "type": "string"
                            }
                        }
                    }
                }
            }
        },
        "codersdk.PatchTemplateVersionRequest": {
            "type": "object",
            "properties": {
                "message": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.PatchWorkspaceProxy": {
            "type": "object",
            "required": [
                "display_name",
                "icon",
                "id",
                "name"
            ],
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                },
                "regenerate_token": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.Permission": {
            "type": "object",
            "properties": {
                "action": {
                    "$ref": "#/definitions/codersdk.RBACAction"
                },
                "negate": {
                    "description": "Negate makes this a negative permission",
                    "type": "boolean"
                },
                "resource_type": {
                    "$ref": "#/definitions/codersdk.RBACResource"
                }
            }
        },
        "codersdk.PostOAuth2ProviderAppRequest": {
            "type": "object",
            "required": [
                "callback_url",
                "name"
            ],
            "properties": {
                "callback_url": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.PostWorkspaceUsageRequest": {
            "type": "object",
            "properties": {
                "agent_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "app_name": {
                    "$ref": "#/definitions/codersdk.UsageAppName"
                }
            }
        },
        "codersdk.PprofConfig": {
            "type": "object",
            "properties": {
                "address": {
                    "$ref": "#/definitions/serpent.HostPort"
                },
                "enable": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.PrebuildsConfig": {
            "type": "object",
            "properties": {
                "failure_hard_limit": {
                    "description": "FailureHardLimit defines the maximum number of consecutive failed prebuild attempts allowed\nbefore a preset is considered to be in a hard limit state. When a preset hits this limit,\nno new prebuilds will be created until the limit is reset.\nFailureHardLimit is disabled when set to zero.",
                    "type": "integer"
                },
                "reconciliation_backoff_interval": {
                    "description": "ReconciliationBackoffInterval specifies the amount of time to increase the backoff interval\nwhen errors occur during reconciliation.",
                    "type": "integer"
                },
                "reconciliation_backoff_lookback": {
                    "description": "ReconciliationBackoffLookback determines the time window to look back when calculating\nthe number of failed prebuilds, which influences the backoff strategy.",
                    "type": "integer"
                },
                "reconciliation_interval": {
                    "description": "ReconciliationInterval defines how often the workspace prebuilds state should be reconciled.",
                    "type": "integer"
                }
            }
        },
        "codersdk.PrebuildsSettings": {
            "type": "object",
            "properties": {
                "reconciliation_paused": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.Preset": {
            "type": "object",
            "properties": {
                "default": {
                    "type": "boolean"
                },
                "description": {
                    "type": "string"
                },
                "desiredPrebuildInstances": {
                    "type": "integer"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "parameters": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.PresetParameter"
                    }
                }
            }
        },
        "codersdk.PresetParameter": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.PreviewParameter": {
            "type": "object",
            "properties": {
                "default_value": {
                    "$ref": "#/definitions/codersdk.NullHCLString"
                },
                "description": {
                    "type": "string"
                },
                "diagnostics": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.FriendlyDiagnostic"
                    }
                },
                "display_name": {
                    "type": "string"
                },
                "ephemeral": {
                    "type": "boolean"
                },
                "form_type": {
                    "$ref": "#/definitions/codersdk.ParameterFormType"
                },
                "icon": {
                    "type": "string"
                },
                "mutable": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "options": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.PreviewParameterOption"
                    }
                },
                "order": {
                    "description": "legacy_variable_name was removed (= 14)",
                    "type": "integer"
                },
                "required": {
                    "type": "boolean"
                },
                "styling": {
                    "$ref": "#/definitions/codersdk.PreviewParameterStyling"
                },
                "type": {
                    "$ref": "#/definitions/codersdk.OptionType"
                },
                "validations": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.PreviewParameterValidation"
                    }
                },
                "value": {
                    "$ref": "#/definitions/codersdk.NullHCLString"
                }
            }
        },
        "codersdk.PreviewParameterOption": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "value": {
                    "$ref": "#/definitions/codersdk.NullHCLString"
                }
            }
        },
        "codersdk.PreviewParameterStyling": {
            "type": "object",
            "properties": {
                "disabled": {
                    "type": "boolean"
                },
                "label": {
                    "type": "string"
                },
                "mask_input": {
                    "type": "boolean"
                },
                "placeholder": {
                    "type": "string"
                }
            }
        },
        "codersdk.PreviewParameterValidation": {
            "type": "object",
            "properties": {
                "validation_error": {
                    "type": "string"
                },
                "validation_max": {
                    "type": "integer"
                },
                "validation_min": {
                    "type": "integer"
                },
                "validation_monotonic": {
                    "type": "string"
                },
                "validation_regex": {
                    "description": "All validation attributes are optional.",
                    "type": "string"
                }
            }
        },
        "codersdk.PrometheusConfig": {
            "type": "object",
            "properties": {
                "address": {
                    "$ref": "#/definitions/serpent.HostPort"
                },
                "aggregate_agent_stats_by": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "collect_agent_stats": {
                    "type": "boolean"
                },
                "collect_db_metrics": {
                    "type": "boolean"
                },
                "enable": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.ProvisionerConfig": {
            "type": "object",
            "properties": {
                "daemon_poll_interval": {
                    "type": "integer"
                },
                "daemon_poll_jitter": {
                    "type": "integer"
                },
                "daemon_psk": {
                    "type": "string"
                },
                "daemon_types": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "daemons": {
                    "description": "Daemons is the number of built-in terraform provisioners.",
                    "type": "integer"
                },
                "force_cancel_interval": {
                    "type": "integer"
                }
            }
        },
        "codersdk.ProvisionerDaemon": {
            "type": "object",
            "properties": {
                "api_version": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "current_job": {
                    "$ref": "#/definitions/codersdk.ProvisionerDaemonJob"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "key_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "key_name": {
                    "description": "Optional fields.",
                    "type": "string"
                },
                "last_seen_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "previous_job": {
                    "$ref": "#/definitions/codersdk.ProvisionerDaemonJob"
                },
                "provisioners": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "status": {
                    "enum": [
                        "offline",
                        "idle",
                        "busy"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ProvisionerDaemonStatus"
                        }
                    ]
                },
                "tags": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "codersdk.ProvisionerDaemonJob": {
            "type": "object",
            "properties": {
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "status": {
                    "enum": [
                        "pending",
                        "running",
                        "succeeded",
                        "canceling",
                        "canceled",
                        "failed"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ProvisionerJobStatus"
                        }
                    ]
                },
                "template_display_name": {
                    "type": "string"
                },
                "template_icon": {
                    "type": "string"
                },
                "template_name": {
                    "type": "string"
                }
            }
        },
        "codersdk.ProvisionerDaemonStatus": {
            "type": "string",
            "enum": [
                "offline",
                "idle",
                "busy"
            ],
            "x-enum-varnames": [
                "ProvisionerDaemonOffline",
                "ProvisionerDaemonIdle",
                "ProvisionerDaemonBusy"
            ]
        },
        "codersdk.ProvisionerJob": {
            "type": "object",
            "properties": {
                "available_workers": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "canceled_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "completed_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "error": {
                    "type": "string"
                },
                "error_code": {
                    "enum": [
                        "REQUIRED_TEMPLATE_VARIABLES"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.JobErrorCode"
                        }
                    ]
                },
                "file_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "initiator_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "input": {
                    "$ref": "#/definitions/codersdk.ProvisionerJobInput"
                },
                "logs_overflowed": {
                    "type": "boolean"
                },
                "metadata": {
                    "$ref": "#/definitions/codersdk.ProvisionerJobMetadata"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "queue_position": {
                    "type": "integer"
                },
                "queue_size": {
                    "type": "integer"
                },
                "started_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "status": {
                    "enum": [
                        "pending",
                        "running",
                        "succeeded",
                        "canceling",
                        "canceled",
                        "failed"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ProvisionerJobStatus"
                        }
                    ]
                },
                "tags": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "type": {
                    "$ref": "#/definitions/codersdk.ProvisionerJobType"
                },
                "worker_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "worker_name": {
                    "type": "string"
                }
            }
        },
        "codersdk.ProvisionerJobInput": {
            "type": "object",
            "properties": {
                "error": {
                    "type": "string"
                },
                "template_version_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "workspace_build_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.ProvisionerJobLog": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "integer"
                },
                "log_level": {
                    "enum": [
                        "trace",
                        "debug",
                        "info",
                        "warn",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.LogLevel"
                        }
                    ]
                },
                "log_source": {
                    "$ref": "#/definitions/codersdk.LogSource"
                },
                "output": {
                    "type": "string"
                },
                "stage": {
                    "type": "string"
                }
            }
        },
        "codersdk.ProvisionerJobMetadata": {
            "type": "object",
            "properties": {
                "template_display_name": {
                    "type": "string"
                },
                "template_icon": {
                    "type": "string"
                },
                "template_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "template_name": {
                    "type": "string"
                },
                "template_version_name": {
                    "type": "string"
                },
                "workspace_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "workspace_name": {
                    "type": "string"
                }
            }
        },
        "codersdk.ProvisionerJobStatus": {
            "type": "string",
            "enum": [
                "pending",
                "running",
                "succeeded",
                "canceling",
                "canceled",
                "failed",
                "unknown"
            ],
            "x-enum-varnames": [
                "ProvisionerJobPending",
                "ProvisionerJobRunning",
                "ProvisionerJobSucceeded",
                "ProvisionerJobCanceling",
                "ProvisionerJobCanceled",
                "ProvisionerJobFailed",
                "ProvisionerJobUnknown"
            ]
        },
        "codersdk.ProvisionerJobType": {
            "type": "string",
            "enum": [
                "template_version_import",
                "workspace_build",
                "template_version_dry_run"
            ],
            "x-enum-varnames": [
                "ProvisionerJobTypeTemplateVersionImport",
                "ProvisionerJobTypeWorkspaceBuild",
                "ProvisionerJobTypeTemplateVersionDryRun"
            ]
        },
        "codersdk.ProvisionerKey": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                },
                "organization": {
                    "type": "string",
                    "format": "uuid"
                },
                "tags": {
                    "$ref": "#/definitions/codersdk.ProvisionerKeyTags"
                }
            }
        },
        "codersdk.ProvisionerKeyDaemons": {
            "type": "object",
            "properties": {
                "daemons": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ProvisionerDaemon"
                    }
                },
                "key": {
                    "$ref": "#/definitions/codersdk.ProvisionerKey"
                }
            }
        },
        "codersdk.ProvisionerKeyTags": {
            "type": "object",
            "additionalProperties": {
                "type": "string"
            }
        },
        "codersdk.ProvisionerLogLevel": {
            "type": "string",
            "enum": [
                "debug"
            ],
            "x-enum-varnames": [
                "ProvisionerLogLevelDebug"
            ]
        },
        "codersdk.ProvisionerStorageMethod": {
            "type": "string",
            "enum": [
                "file"
            ],
            "x-enum-varnames": [
                "ProvisionerStorageMethodFile"
            ]
        },
        "codersdk.ProvisionerTiming": {
            "type": "object",
            "properties": {
                "action": {
                    "type": "string"
                },
                "ended_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "job_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "resource": {
                    "type": "string"
                },
                "source": {
                    "type": "string"
                },
                "stage": {
                    "$ref": "#/definitions/codersdk.TimingStage"
                },
                "started_at": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.ProxyHealthReport": {
            "type": "object",
            "properties": {
                "errors": {
                    "description": "Errors are problems that prevent the workspace proxy from being healthy",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "warnings": {
                    "description": "Warnings do not prevent the workspace proxy from being healthy, but\nshould be addressed.",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.ProxyHealthStatus": {
            "type": "string",
            "enum": [
                "ok",
                "unreachable",
                "unhealthy",
                "unregistered"
            ],
            "x-enum-varnames": [
                "ProxyHealthy",
                "ProxyUnreachable",
                "ProxyUnhealthy",
                "ProxyUnregistered"
            ]
        },
        "codersdk.PutExtendWorkspaceRequest": {
            "type": "object",
            "required": [
                "deadline"
            ],
            "properties": {
                "deadline": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.PutOAuth2ProviderAppRequest": {
            "type": "object",
            "required": [
                "callback_url",
                "name"
            ],
            "properties": {
                "callback_url": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.RBACAction": {
            "type": "string",
            "enum": [
                "application_connect",
                "assign",
                "create",
                "create_agent",
                "delete",
                "delete_agent",
                "read",
                "read_personal",
                "ssh",
                "share",
                "unassign",
                "update",
                "update_personal",
                "use",
                "view_insights",
                "start",
                "stop"
            ],
            "x-enum-varnames": [
                "ActionApplicationConnect",
                "ActionAssign",
                "ActionCreate",
                "ActionCreateAgent",
                "ActionDelete",
                "ActionDeleteAgent",
                "ActionRead",
                "ActionReadPersonal",
                "ActionSSH",
                "ActionShare",
                "ActionUnassign",
                "ActionUpdate",
                "ActionUpdatePersonal",
                "ActionUse",
                "ActionViewInsights",
                "ActionWorkspaceStart",
                "ActionWorkspaceStop"
            ]
        },
        "codersdk.RBACResource": {
            "type": "string",
            "enum": [
                "*",
                "aibridge_interception",
                "api_key",
                "assign_org_role",
                "assign_role",
                "audit_log",
                "boundary_usage",
                "connection_log",
                "crypto_key",
                "debug_info",
                "deployment_config",
                "deployment_stats",
                "file",
                "group",
                "group_member",
                "idpsync_settings",
                "inbox_notification",
                "license",
                "notification_message",
                "notification_preference",
                "notification_template",
                "oauth2_app",
                "oauth2_app_code_token",
                "oauth2_app_secret",
                "organization",
                "organization_member",
                "prebuilt_workspace",
                "provisioner_daemon",
                "provisioner_jobs",
                "replicas",
                "system",
                "tailnet_coordinator",
                "task",
                "template",
                "usage_event",
                "user",
                "user_secret",
                "webpush_subscription",
                "workspace",
                "workspace_agent_devcontainers",
                "workspace_agent_resource_monitor",
                "workspace_dormant",
                "workspace_proxy"
            ],
            "x-enum-varnames": [
                "ResourceWildcard",
                "ResourceAibridgeInterception",
                "ResourceApiKey",
                "ResourceAssignOrgRole",
                "ResourceAssignRole",
                "ResourceAuditLog",
                "ResourceBoundaryUsage",
                "ResourceConnectionLog",
                "ResourceCryptoKey",
                "ResourceDebugInfo",
                "ResourceDeploymentConfig",
                "ResourceDeploymentStats",
                "ResourceFile",
                "ResourceGroup",
                "ResourceGroupMember",
                "ResourceIdpsyncSettings",
                "ResourceInboxNotification",
                "ResourceLicense",
                "ResourceNotificationMessage",
                "ResourceNotificationPreference",
                "ResourceNotificationTemplate",
                "ResourceOauth2App",
                "ResourceOauth2AppCodeToken",
                "ResourceOauth2AppSecret",
                "ResourceOrganization",
                "ResourceOrganizationMember",
                "ResourcePrebuiltWorkspace",
                "ResourceProvisionerDaemon",
                "ResourceProvisionerJobs",
                "ResourceReplicas",
                "ResourceSystem",
                "ResourceTailnetCoordinator",
                "ResourceTask",
                "ResourceTemplate",
                "ResourceUsageEvent",
                "ResourceUser",
                "ResourceUserSecret",
                "ResourceWebpushSubscription",
                "ResourceWorkspace",
                "ResourceWorkspaceAgentDevcontainers",
                "ResourceWorkspaceAgentResourceMonitor",
                "ResourceWorkspaceDormant",
                "ResourceWorkspaceProxy"
            ]
        },
        "codersdk.RateLimitConfig": {
            "type": "object",
            "properties": {
                "api": {
                    "type": "integer"
                },
                "disable_all": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.ReducedUser": {
            "type": "object",
            "required": [
                "created_at",
                "email",
                "id",
                "username"
            ],
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "email": {
                    "type": "string",
                    "format": "email"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "last_seen_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "login_type": {
                    "$ref": "#/definitions/codersdk.LoginType"
                },
                "name": {
                    "type": "string"
                },
                "status": {
                    "enum": [
                        "active",
                        "suspended"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.UserStatus"
                        }
                    ]
                },
                "theme_preference": {
                    "description": "Deprecated: this value should be retrieved from\n` + "`" + `codersdk.UserPreferenceSettings` + "`" + ` instead.",
                    "type": "string"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.Region": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "healthy": {
                    "type": "boolean"
                },
                "icon_url": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                },
                "path_app_url": {
                    "description": "PathAppURL is the URL to the base path for path apps. Optional\nunless wildcard_hostname is set.\nE.g. https://us.example.com",
                    "type": "string"
                },
                "wildcard_hostname": {
                    "description": "WildcardHostname is the wildcard hostname for subdomain apps.\nE.g. *.us.example.com\nE.g. *--suffix.au.example.com\nOptional. Does not need to be on the same domain as PathAppURL.",
                    "type": "string"
                }
            }
        },
        "codersdk.RegionsResponse-codersdk_Region": {
            "type": "object",
            "properties": {
                "regions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Region"
                    }
                }
            }
        },
        "codersdk.RegionsResponse-codersdk_WorkspaceProxy": {
            "type": "object",
            "properties": {
                "regions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceProxy"
                    }
                }
            }
        },
        "codersdk.Replica": {
            "type": "object",
            "properties": {
                "created_at": {
                    "description": "CreatedAt is the timestamp when the replica was first seen.",
                    "type": "string",
                    "format": "date-time"
                },
                "database_latency": {
                    "description": "DatabaseLatency is the latency in microseconds to the database.",
                    "type": "integer"
                },
                "error": {
                    "description": "Error is the replica error.",
                    "type": "string"
                },
                "hostname": {
                    "description": "Hostname is the hostname of the replica.",
                    "type": "string"
                },
                "id": {
                    "description": "ID is the unique identifier for the replica.",
                    "type": "string",
                    "format": "uuid"
                },
                "region_id": {
                    "description": "RegionID is the region of the replica.",
                    "type": "integer"
                },
                "relay_address": {
                    "description": "RelayAddress is the accessible address to relay DERP connections.",
                    "type": "string"
                }
            }
        },
        "codersdk.RequestOneTimePasscodeRequest": {
            "type": "object",
            "required": [
                "email"
            ],
            "properties": {
                "email": {
                    "type": "string",
                    "format": "email"
                }
            }
        },
        "codersdk.ResolveAutostartResponse": {
            "type": "object",
            "properties": {
                "parameter_mismatch": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.ResourceType": {
            "type": "string",
            "enum": [
                "template",
                "template_version",
                "user",
                "workspace",
                "workspace_build",
                "git_ssh_key",
                "api_key",
                "group",
                "license",
                "convert_login",
                "health_settings",
                "notifications_settings",
                "prebuilds_settings",
                "workspace_proxy",
                "organization",
                "oauth2_provider_app",
                "oauth2_provider_app_secret",
                "custom_role",
                "organization_member",
                "notification_template",
                "idp_sync_settings_organization",
                "idp_sync_settings_group",
                "idp_sync_settings_role",
                "workspace_agent",
                "workspace_app",
                "task"
            ],
            "x-enum-varnames": [
                "ResourceTypeTemplate",
                "ResourceTypeTemplateVersion",
                "ResourceTypeUser",
                "ResourceTypeWorkspace",
                "ResourceTypeWorkspaceBuild",
                "ResourceTypeGitSSHKey",
                "ResourceTypeAPIKey",
                "ResourceTypeGroup",
                "ResourceTypeLicense",
                "ResourceTypeConvertLogin",
                "ResourceTypeHealthSettings",
                "ResourceTypeNotificationsSettings",
                "ResourceTypePrebuildsSettings",
                "ResourceTypeWorkspaceProxy",
                "ResourceTypeOrganization",
                "ResourceTypeOAuth2ProviderApp",
                "ResourceTypeOAuth2ProviderAppSecret",
                "ResourceTypeCustomRole",
                "ResourceTypeOrganizationMember",
                "ResourceTypeNotificationTemplate",
                "ResourceTypeIdpSyncSettingsOrganization",
                "ResourceTypeIdpSyncSettingsGroup",
                "ResourceTypeIdpSyncSettingsRole",
                "ResourceTypeWorkspaceAgent",
                "ResourceTypeWorkspaceApp",
                "ResourceTypeTask"
            ]
        },
        "codersdk.Response": {
            "type": "object",
            "properties": {
                "detail": {
                    "description": "Detail is a debug message that provides further insight into why the\naction failed. This information can be technical and a regular golang\nerr.Error() text.\n- \"database: too many open connections\"\n- \"stat: too many open files\"",
                    "type": "string"
                },
                "message": {
                    "description": "Message is an actionable message that depicts actions the request took.\nThese messages should be fully formed sentences with proper punctuation.\nExamples:\n- \"A user has been created.\"\n- \"Failed to create a user.\"",
                    "type": "string"
                },
                "validations": {
                    "description": "Validations are form field-specific friendly error messages. They will be\nshown on a form field in the UI. These can also be used to add additional\ncontext if there is a set of errors in the primary 'Message'.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ValidationError"
                    }
                }
            }
        },
        "codersdk.RetentionConfig": {
            "type": "object",
            "properties": {
                "api_keys": {
                    "description": "APIKeys controls how long expired API keys are retained before being deleted.\nKeys are only deleted if they have been expired for at least this duration.\nDefaults to 7 days to preserve existing behavior.",
                    "type": "integer"
                },
                "audit_logs": {
                    "description": "AuditLogs controls how long audit log entries are retained.\nSet to 0 to disable (keep indefinitely).",
                    "type": "integer"
                },
                "connection_logs": {
                    "description": "ConnectionLogs controls how long connection log entries are retained.\nSet to 0 to disable (keep indefinitely).",
                    "type": "integer"
                },
                "workspace_agent_logs": {
                    "description": "WorkspaceAgentLogs controls how long workspace agent logs are retained.\nLogs are deleted if the agent hasn't connected within this period.\nLogs from the latest build are always retained regardless of age.\nDefaults to 7 days to preserve existing behavior.",
                    "type": "integer"
                }
            }
        },
        "codersdk.Role": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "organization_member_permissions": {
                    "description": "OrganizationMemberPermissions are specific for the organization in the field 'OrganizationID' above.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "organization_permissions": {
                    "description": "OrganizationPermissions are specific for the organization in the field 'OrganizationID' above.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "site_permissions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                },
                "user_permissions": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Permission"
                    }
                }
            }
        },
        "codersdk.RoleSyncSettings": {
            "type": "object",
            "properties": {
                "field": {
                    "description": "Field is the name of the claim field that specifies what organization roles\na user should be given. If empty, no roles will be synced.",
                    "type": "string"
                },
                "mapping": {
                    "description": "Mapping is a map from OIDC groups to Coder organization roles.",
                    "type": "object",
                    "additionalProperties": {
                        "type": "array",
                        "items": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "codersdk.SSHConfig": {
            "type": "object",
            "properties": {
                "deploymentName": {
                    "description": "DeploymentName is the config-ssh Hostname prefix",
                    "type": "string"
                },
                "sshconfigOptions": {
                    "description": "SSHConfigOptions are additional options to add to the ssh config file.\nThis will override defaults.",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.SSHConfigResponse": {
            "type": "object",
            "properties": {
                "hostname_prefix": {
                    "description": "HostnamePrefix is the prefix we append to workspace names for SSH hostnames.\nDeprecated: use HostnameSuffix instead.",
                    "type": "string"
                },
                "hostname_suffix": {
                    "description": "HostnameSuffix is the suffix to append to workspace names for SSH hostnames.",
                    "type": "string"
                },
                "ssh_config_options": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.ServerSentEvent": {
            "type": "object",
            "properties": {
                "data": {},
                "type": {
                    "$ref": "#/definitions/codersdk.ServerSentEventType"
                }
            }
        },
        "codersdk.ServerSentEventType": {
            "type": "string",
            "enum": [
                "ping",
                "data",
                "error"
            ],
            "x-enum-varnames": [
                "ServerSentEventTypePing",
                "ServerSentEventTypeData",
                "ServerSentEventTypeError"
            ]
        },
        "codersdk.SessionCountDeploymentStats": {
            "type": "object",
            "properties": {
                "jetbrains": {
                    "type": "integer"
                },
                "reconnecting_pty": {
                    "type": "integer"
                },
                "ssh": {
                    "type": "integer"
                },
                "vscode": {
                    "type": "integer"
                }
            }
        },
        "codersdk.SessionLifetime": {
            "type": "object",
            "properties": {
                "default_duration": {
                    "description": "DefaultDuration is only for browser, workspace app and oauth sessions.",
                    "type": "integer"
                },
                "default_token_lifetime": {
                    "type": "integer"
                },
                "disable_expiry_refresh": {
                    "description": "DisableExpiryRefresh will disable automatically refreshing api\nkeys when they are used from the api. This means the api key lifetime at\ncreation is the lifetime of the api key.",
                    "type": "boolean"
                },
                "max_admin_token_lifetime": {
                    "type": "integer"
                },
                "max_token_lifetime": {
                    "type": "integer"
                },
                "refresh_default_duration": {
                    "description": "RefreshDefaultDuration is the default lifetime for OAuth2 refresh tokens.\nThis should generally be longer than access token lifetimes to allow\nrefreshing after access token expiry.",
                    "type": "integer"
                }
            }
        },
        "codersdk.SharedWorkspaceActor": {
            "type": "object",
            "properties": {
                "actor_type": {
                    "enum": [
                        "group",
                        "user"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.SharedWorkspaceActorType"
                        }
                    ]
                },
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                },
                "roles": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceRole"
                    }
                }
            }
        },
        "codersdk.SharedWorkspaceActorType": {
            "type": "string",
            "enum": [
                "group",
                "user"
            ],
            "x-enum-varnames": [
                "SharedWorkspaceActorTypeGroup",
                "SharedWorkspaceActorTypeUser"
            ]
        },
        "codersdk.SlimRole": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string"
                }
            }
        },
        "codersdk.StatsCollectionConfig": {
            "type": "object",
            "properties": {
                "usage_stats": {
                    "$ref": "#/definitions/codersdk.UsageStatsConfig"
                }
            }
        },
        "codersdk.SupportConfig": {
            "type": "object",
            "properties": {
                "links": {
                    "$ref": "#/definitions/serpent.Struct-array_codersdk_LinkConfig"
                }
            }
        },
        "codersdk.SwaggerConfig": {
            "type": "object",
            "properties": {
                "enable": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.TLSConfig": {
            "type": "object",
            "properties": {
                "address": {
                    "$ref": "#/definitions/serpent.HostPort"
                },
                "allow_insecure_ciphers": {
                    "type": "boolean"
                },
                "cert_file": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "client_auth": {
                    "type": "string"
                },
                "client_ca_file": {
                    "type": "string"
                },
                "client_cert_file": {
                    "type": "string"
                },
                "client_key_file": {
                    "type": "string"
                },
                "enable": {
                    "type": "boolean"
                },
                "key_file": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "min_version": {
                    "type": "string"
                },
                "redirect_http": {
                    "type": "boolean"
                },
                "supported_ciphers": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.Task": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "current_state": {
                    "$ref": "#/definitions/codersdk.TaskStateEntry"
                },
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "initial_prompt": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "owner_avatar_url": {
                    "type": "string"
                },
                "owner_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "owner_name": {
                    "type": "string"
                },
                "status": {
                    "enum": [
                        "pending",
                        "initializing",
                        "active",
                        "paused",
                        "unknown",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.TaskStatus"
                        }
                    ]
                },
                "template_display_name": {
                    "type": "string"
                },
                "template_icon": {
                    "type": "string"
                },
                "template_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "template_name": {
                    "type": "string"
                },
                "template_version_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "workspace_agent_health": {
                    "$ref": "#/definitions/codersdk.WorkspaceAgentHealth"
                },
                "workspace_agent_id": {
                    "format": "uuid",
                    "allOf": [
                        {
                            "$ref": "#/definitions/uuid.NullUUID"
                        }
                    ]
                },
                "workspace_agent_lifecycle": {
                    "$ref": "#/definitions/codersdk.WorkspaceAgentLifecycle"
                },
                "workspace_app_id": {
                    "format": "uuid",
                    "allOf": [
                        {
                            "$ref": "#/definitions/uuid.NullUUID"
                        }
                    ]
                },
                "workspace_build_number": {
                    "type": "integer"
                },
                "workspace_id": {
                    "format": "uuid",
                    "allOf": [
                        {
                            "$ref": "#/definitions/uuid.NullUUID"
                        }
                    ]
                },
                "workspace_name": {
                    "type": "string"
                },
                "workspace_status": {
                    "enum": [
                        "pending",
                        "starting",
                        "running",
                        "stopping",
                        "stopped",
                        "failed",
                        "canceling",
                        "canceled",
                        "deleting",
                        "deleted"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceStatus"
                        }
                    ]
                }
            }
        },
        "codersdk.TaskLogEntry": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "time": {
                    "type": "string",
                    "format": "date-time"
                },
                "type": {
                    "$ref": "#/definitions/codersdk.TaskLogType"
                }
            }
        },
        "codersdk.TaskLogType": {
            "type": "string",
            "enum": [
                "input",
                "output"
            ],
            "x-enum-varnames": [
                "TaskLogTypeInput",
                "TaskLogTypeOutput"
            ]
        },
        "codersdk.TaskLogsResponse": {
            "type": "object",
            "properties": {
                "logs": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TaskLogEntry"
                    }
                }
            }
        },
        "codersdk.TaskSendRequest": {
            "type": "object",
            "properties": {
                "input": {
                    "type": "string"
                }
            }
        },
        "codersdk.TaskState": {
            "type": "string",
            "enum": [
                "working",
                "idle",
                "complete",
                "failed"
            ],
            "x-enum-varnames": [
                "TaskStateWorking",
                "TaskStateIdle",
                "TaskStateComplete",
                "TaskStateFailed"
            ]
        },
        "codersdk.TaskStateEntry": {
            "type": "object",
            "properties": {
                "message": {
                    "type": "string"
                },
                "state": {
                    "$ref": "#/definitions/codersdk.TaskState"
                },
                "timestamp": {
                    "type": "string",
                    "format": "date-time"
                },
                "uri": {
                    "type": "string"
                }
            }
        },
        "codersdk.TaskStatus": {
            "type": "string",
            "enum": [
                "pending",
                "initializing",
                "active",
                "paused",
                "unknown",
                "error"
            ],
            "x-enum-varnames": [
                "TaskStatusPending",
                "TaskStatusInitializing",
                "TaskStatusActive",
                "TaskStatusPaused",
                "TaskStatusUnknown",
                "TaskStatusError"
            ]
        },
        "codersdk.TasksListResponse": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "tasks": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Task"
                    }
                }
            }
        },
        "codersdk.TelemetryConfig": {
            "type": "object",
            "properties": {
                "enable": {
                    "type": "boolean"
                },
                "trace": {
                    "type": "boolean"
                },
                "url": {
                    "$ref": "#/definitions/serpent.URL"
                }
            }
        },
        "codersdk.Template": {
            "type": "object",
            "properties": {
                "active_user_count": {
                    "description": "ActiveUserCount is set to -1 when loading.",
                    "type": "integer"
                },
                "active_version_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "activity_bump_ms": {
                    "type": "integer"
                },
                "allow_user_autostart": {
                    "description": "AllowUserAutostart and AllowUserAutostop are enterprise-only. Their\nvalues are only used if your license is entitled to use the advanced\ntemplate scheduling feature.",
                    "type": "boolean"
                },
                "allow_user_autostop": {
                    "type": "boolean"
                },
                "allow_user_cancel_workspace_jobs": {
                    "type": "boolean"
                },
                "autostart_requirement": {
                    "$ref": "#/definitions/codersdk.TemplateAutostartRequirement"
                },
                "autostop_requirement": {
                    "description": "AutostopRequirement and AutostartRequirement are enterprise features. Its\nvalue is only used if your license is entitled to use the advanced template\nscheduling feature.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.TemplateAutostopRequirement"
                        }
                    ]
                },
                "build_time_stats": {
                    "$ref": "#/definitions/codersdk.TemplateBuildTimeStats"
                },
                "cors_behavior": {
                    "$ref": "#/definitions/codersdk.CORSBehavior"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "created_by_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "created_by_name": {
                    "type": "string"
                },
                "default_ttl_ms": {
                    "type": "integer"
                },
                "deprecated": {
                    "type": "boolean"
                },
                "deprecation_message": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "failure_ttl_ms": {
                    "description": "FailureTTLMillis, TimeTilDormantMillis, and TimeTilDormantAutoDeleteMillis are enterprise-only. Their\nvalues are used if your license is entitled to use the advanced\ntemplate scheduling feature.",
                    "type": "integer"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "max_port_share_level": {
                    "$ref": "#/definitions/codersdk.WorkspaceAgentPortShareLevel"
                },
                "name": {
                    "type": "string"
                },
                "organization_display_name": {
                    "type": "string"
                },
                "organization_icon": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "organization_name": {
                    "type": "string",
                    "format": "url"
                },
                "provisioner": {
                    "type": "string",
                    "enum": [
                        "terraform"
                    ]
                },
                "require_active_version": {
                    "description": "RequireActiveVersion mandates that workspaces are built with the active\ntemplate version.",
                    "type": "boolean"
                },
                "time_til_dormant_autodelete_ms": {
                    "type": "integer"
                },
                "time_til_dormant_ms": {
                    "type": "integer"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "use_classic_parameter_flow": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.TemplateACL": {
            "type": "object",
            "properties": {
                "group": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TemplateGroup"
                    }
                },
                "users": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TemplateUser"
                    }
                }
            }
        },
        "codersdk.TemplateAppUsage": {
            "type": "object",
            "properties": {
                "display_name": {
                    "type": "string",
                    "example": "Visual Studio Code"
                },
                "icon": {
                    "type": "string"
                },
                "seconds": {
                    "type": "integer",
                    "example": 80500
                },
                "slug": {
                    "type": "string",
                    "example": "vscode"
                },
                "template_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "times_used": {
                    "type": "integer",
                    "example": 2
                },
                "type": {
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.TemplateAppsType"
                        }
                    ],
                    "example": "builtin"
                }
            }
        },
        "codersdk.TemplateAppsType": {
            "type": "string",
            "enum": [
                "builtin",
                "app"
            ],
            "x-enum-varnames": [
                "TemplateAppsTypeBuiltin",
                "TemplateAppsTypeApp"
            ]
        },
        "codersdk.TemplateAutostartRequirement": {
            "type": "object",
            "properties": {
                "days_of_week": {
                    "description": "DaysOfWeek is a list of days of the week in which autostart is allowed\nto happen. If no days are specified, autostart is not allowed.",
                    "type": "array",
                    "items": {
                        "type": "string",
                        "enum": [
                            "monday",
                            "tuesday",
                            "wednesday",
                            "thursday",
                            "friday",
                            "saturday",
                            "sunday"
                        ]
                    }
                }
            }
        },
        "codersdk.TemplateAutostopRequirement": {
            "type": "object",
            "properties": {
                "days_of_week": {
                    "description": "DaysOfWeek is a list of days of the week on which restarts are required.\nRestarts happen within the user's quiet hours (in their configured\ntimezone). If no days are specified, restarts are not required. Weekdays\ncannot be specified twice.\n\nRestarts will only happen on weekdays in this list on weeks which line up\nwith Weeks.",
                    "type": "array",
                    "items": {
                        "type": "string",
                        "enum": [
                            "monday",
                            "tuesday",
                            "wednesday",
                            "thursday",
                            "friday",
                            "saturday",
                            "sunday"
                        ]
                    }
                },
                "weeks": {
                    "description": "Weeks is the number of weeks between required restarts. Weeks are synced\nacross all workspaces (and Coder deployments) using modulo math on a\nhardcoded epoch week of January 2nd, 2023 (the first Monday of 2023).\nValues of 0 or 1 indicate weekly restarts. Values of 2 indicate\nfortnightly restarts, etc.",
                    "type": "integer"
                }
            }
        },
        "codersdk.TemplateBuildTimeStats": {
            "type": "object",
            "additionalProperties": {
                "$ref": "#/definitions/codersdk.TransitionStats"
            }
        },
        "codersdk.TemplateExample": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "markdown": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "codersdk.TemplateGroup": {
            "type": "object",
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "members": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ReducedUser"
                    }
                },
                "name": {
                    "type": "string"
                },
                "organization_display_name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "organization_name": {
                    "type": "string"
                },
                "quota_allowance": {
                    "type": "integer"
                },
                "role": {
                    "enum": [
                        "admin",
                        "use"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.TemplateRole"
                        }
                    ]
                },
                "source": {
                    "$ref": "#/definitions/codersdk.GroupSource"
                },
                "total_member_count": {
                    "description": "How many members are in this group. Shows the total count,\neven if the user is not authorized to read group member details.\nMay be greater than ` + "`" + `len(Group.Members)` + "`" + `.",
                    "type": "integer"
                }
            }
        },
        "codersdk.TemplateInsightsIntervalReport": {
            "type": "object",
            "properties": {
                "active_users": {
                    "type": "integer",
                    "example": 14
                },
                "end_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "interval": {
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.InsightsReportInterval"
                        }
                    ],
                    "example": "week"
                },
                "start_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "template_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                }
            }
        },
        "codersdk.TemplateInsightsReport": {
            "type": "object",
            "properties": {
                "active_users": {
                    "type": "integer",
                    "example": 22
                },
                "apps_usage": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TemplateAppUsage"
                    }
                },
                "end_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "parameters_usage": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TemplateParameterUsage"
                    }
                },
                "start_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "template_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                }
            }
        },
        "codersdk.TemplateInsightsResponse": {
            "type": "object",
            "properties": {
                "interval_reports": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TemplateInsightsIntervalReport"
                    }
                },
                "report": {
                    "$ref": "#/definitions/codersdk.TemplateInsightsReport"
                }
            }
        },
        "codersdk.TemplateParameterUsage": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "options": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TemplateVersionParameterOption"
                    }
                },
                "template_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "type": {
                    "type": "string"
                },
                "values": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TemplateParameterValue"
                    }
                }
            }
        },
        "codersdk.TemplateParameterValue": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.TemplateRole": {
            "type": "string",
            "enum": [
                "admin",
                "use",
                ""
            ],
            "x-enum-varnames": [
                "TemplateRoleAdmin",
                "TemplateRoleUse",
                "TemplateRoleDeleted"
            ]
        },
        "codersdk.TemplateUser": {
            "type": "object",
            "required": [
                "created_at",
                "email",
                "id",
                "username"
            ],
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "email": {
                    "type": "string",
                    "format": "email"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "last_seen_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "login_type": {
                    "$ref": "#/definitions/codersdk.LoginType"
                },
                "name": {
                    "type": "string"
                },
                "organization_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "role": {
                    "enum": [
                        "admin",
                        "use"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.TemplateRole"
                        }
                    ]
                },
                "roles": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.SlimRole"
                    }
                },
                "status": {
                    "enum": [
                        "active",
                        "suspended"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.UserStatus"
                        }
                    ]
                },
                "theme_preference": {
                    "description": "Deprecated: this value should be retrieved from\n` + "`" + `codersdk.UserPreferenceSettings` + "`" + ` instead.",
                    "type": "string"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.TemplateVersion": {
            "type": "object",
            "properties": {
                "archived": {
                    "type": "boolean"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "created_by": {
                    "$ref": "#/definitions/codersdk.MinimalUser"
                },
                "has_external_agent": {
                    "type": "boolean"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "job": {
                    "$ref": "#/definitions/codersdk.ProvisionerJob"
                },
                "matched_provisioners": {
                    "$ref": "#/definitions/codersdk.MatchedProvisioners"
                },
                "message": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "readme": {
                    "type": "string"
                },
                "template_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "enum": [
                            "DEPRECATED_PARAMETERS"
                        ],
                        "$ref": "#/definitions/codersdk.TemplateVersionWarning"
                    }
                }
            }
        },
        "codersdk.TemplateVersionExternalAuth": {
            "type": "object",
            "properties": {
                "authenticate_url": {
                    "type": "string"
                },
                "authenticated": {
                    "type": "boolean"
                },
                "display_icon": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "optional": {
                    "type": "boolean"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "codersdk.TemplateVersionParameter": {
            "type": "object",
            "properties": {
                "default_value": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "description_plaintext": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "ephemeral": {
                    "type": "boolean"
                },
                "form_type": {
                    "description": "FormType has an enum value of empty string, ` + "`" + `\"\"` + "`" + `.\nKeep the leading comma in the enums struct tag.",
                    "type": "string",
                    "enum": [
                        "",
                        "radio",
                        "dropdown",
                        "input",
                        "textarea",
                        "slider",
                        "checkbox",
                        "switch",
                        "tag-select",
                        "multi-select",
                        "error"
                    ]
                },
                "icon": {
                    "type": "string"
                },
                "mutable": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "options": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.TemplateVersionParameterOption"
                    }
                },
                "required": {
                    "type": "boolean"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "string",
                        "number",
                        "bool",
                        "list(string)"
                    ]
                },
                "validation_error": {
                    "type": "string"
                },
                "validation_max": {
                    "type": "integer"
                },
                "validation_min": {
                    "type": "integer"
                },
                "validation_monotonic": {
                    "enum": [
                        "increasing",
                        "decreasing"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ValidationMonotonicOrder"
                        }
                    ]
                },
                "validation_regex": {
                    "type": "string"
                }
            }
        },
        "codersdk.TemplateVersionParameterOption": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.TemplateVersionVariable": {
            "type": "object",
            "properties": {
                "default_value": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "required": {
                    "type": "boolean"
                },
                "sensitive": {
                    "type": "boolean"
                },
                "type": {
                    "type": "string",
                    "enum": [
                        "string",
                        "number",
                        "bool"
                    ]
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.TemplateVersionWarning": {
            "type": "string",
            "enum": [
                "UNSUPPORTED_WORKSPACES"
            ],
            "x-enum-varnames": [
                "TemplateVersionWarningUnsupportedWorkspaces"
            ]
        },
        "codersdk.TerminalFontName": {
            "type": "string",
            "enum": [
                "",
                "ibm-plex-mono",
                "fira-code",
                "source-code-pro",
                "jetbrains-mono"
            ],
            "x-enum-varnames": [
                "TerminalFontUnknown",
                "TerminalFontIBMPlexMono",
                "TerminalFontFiraCode",
                "TerminalFontSourceCodePro",
                "TerminalFontJetBrainsMono"
            ]
        },
        "codersdk.TimingStage": {
            "type": "string",
            "enum": [
                "init",
                "plan",
                "graph",
                "apply",
                "start",
                "stop",
                "cron",
                "connect"
            ],
            "x-enum-varnames": [
                "TimingStageInit",
                "TimingStagePlan",
                "TimingStageGraph",
                "TimingStageApply",
                "TimingStageStart",
                "TimingStageStop",
                "TimingStageCron",
                "TimingStageConnect"
            ]
        },
        "codersdk.TokenConfig": {
            "type": "object",
            "properties": {
                "max_token_lifetime": {
                    "type": "integer"
                }
            }
        },
        "codersdk.TraceConfig": {
            "type": "object",
            "properties": {
                "capture_logs": {
                    "type": "boolean"
                },
                "data_dog": {
                    "type": "boolean"
                },
                "enable": {
                    "type": "boolean"
                },
                "honeycomb_api_key": {
                    "type": "string"
                }
            }
        },
        "codersdk.TransitionStats": {
            "type": "object",
            "properties": {
                "p50": {
                    "type": "integer",
                    "example": 123
                },
                "p95": {
                    "type": "integer",
                    "example": 146
                }
            }
        },
        "codersdk.UpdateActiveTemplateVersion": {
            "type": "object",
            "required": [
                "id"
            ],
            "properties": {
                "id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.UpdateAppearanceConfig": {
            "type": "object",
            "properties": {
                "announcement_banners": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.BannerConfig"
                    }
                },
                "application_name": {
                    "type": "string"
                },
                "logo_url": {
                    "type": "string"
                },
                "service_banner": {
                    "description": "Deprecated: ServiceBanner has been replaced by AnnouncementBanners.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.BannerConfig"
                        }
                    ]
                }
            }
        },
        "codersdk.UpdateCheckResponse": {
            "type": "object",
            "properties": {
                "current": {
                    "description": "Current indicates whether the server version is the same as the latest.",
                    "type": "boolean"
                },
                "url": {
                    "description": "URL to download the latest release of Coder.",
                    "type": "string"
                },
                "version": {
                    "description": "Version is the semantic version for the latest release of Coder.",
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateOrganizationRequest": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateRoles": {
            "type": "object",
            "properties": {
                "roles": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.UpdateTaskInputRequest": {
            "type": "object",
            "properties": {
                "input": {
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateTemplateACL": {
            "type": "object",
            "properties": {
                "group_perms": {
                    "description": "GroupPerms is a mapping from valid group UUIDs to the template role they\nshould be granted. To remove a group from the template, use \"\" as the role\n(available as a constant named codersdk.TemplateRoleDeleted)",
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/codersdk.TemplateRole"
                    },
                    "example": {
                        "8bd26b20-f3e8-48be-a903-46bb920cf671": "use",
                        "\u003cgroup_id\u003e": "admin"
                    }
                },
                "user_perms": {
                    "description": "UserPerms is a mapping from valid user UUIDs to the template role they\nshould be granted. To remove a user from the template, use \"\" as the role\n(available as a constant named codersdk.TemplateRoleDeleted)",
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/codersdk.TemplateRole"
                    },
                    "example": {
                        "4df59e74-c027-470b-ab4d-cbba8963a5e9": "use",
                        "\u003cuser_id\u003e": "admin"
                    }
                }
            }
        },
        "codersdk.UpdateTemplateMeta": {
            "type": "object",
            "properties": {
                "activity_bump_ms": {
                    "description": "ActivityBumpMillis allows optionally specifying the activity bump\nduration for all workspaces created from this template. Defaults to 1h\nbut can be set to 0 to disable activity bumping.",
                    "type": "integer"
                },
                "allow_user_autostart": {
                    "type": "boolean"
                },
                "allow_user_autostop": {
                    "type": "boolean"
                },
                "allow_user_cancel_workspace_jobs": {
                    "type": "boolean"
                },
                "autostart_requirement": {
                    "$ref": "#/definitions/codersdk.TemplateAutostartRequirement"
                },
                "autostop_requirement": {
                    "description": "AutostopRequirement and AutostartRequirement can only be set if your license\nincludes the advanced template scheduling feature. If you attempt to set this\nvalue while unlicensed, it will be ignored.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.TemplateAutostopRequirement"
                        }
                    ]
                },
                "cors_behavior": {
                    "$ref": "#/definitions/codersdk.CORSBehavior"
                },
                "default_ttl_ms": {
                    "type": "integer"
                },
                "deprecation_message": {
                    "description": "DeprecationMessage if set, will mark the template as deprecated and block\nany new workspaces from using this template.\nIf passed an empty string, will remove the deprecated message, making\nthe template usable for new workspaces again.",
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "disable_everyone_group_access": {
                    "description": "DisableEveryoneGroupAccess allows optionally disabling the default\nbehavior of granting the 'everyone' group access to use the template.\nIf this is set to true, the template will not be available to all users,\nand must be explicitly granted to users or groups in the permissions settings\nof the template.",
                    "type": "boolean"
                },
                "display_name": {
                    "type": "string"
                },
                "failure_ttl_ms": {
                    "type": "integer"
                },
                "icon": {
                    "type": "string"
                },
                "max_port_share_level": {
                    "$ref": "#/definitions/codersdk.WorkspaceAgentPortShareLevel"
                },
                "name": {
                    "type": "string"
                },
                "require_active_version": {
                    "description": "RequireActiveVersion mandates workspaces built using this template\nuse the active version of the template. This option has no\neffect on template admins.",
                    "type": "boolean"
                },
                "time_til_dormant_autodelete_ms": {
                    "type": "integer"
                },
                "time_til_dormant_ms": {
                    "type": "integer"
                },
                "update_workspace_dormant_at": {
                    "description": "UpdateWorkspaceDormant updates the dormant_at field of workspaces spawned\nfrom the template. This is useful for preventing dormant workspaces being immediately\ndeleted when updating the dormant_ttl field to a new, shorter value.",
                    "type": "boolean"
                },
                "update_workspace_last_used_at": {
                    "description": "UpdateWorkspaceLastUsedAt updates the last_used_at field of workspaces\nspawned from the template. This is useful for preventing workspaces being\nimmediately locked when updating the inactivity_ttl field to a new, shorter\nvalue.",
                    "type": "boolean"
                },
                "use_classic_parameter_flow": {
                    "description": "UseClassicParameterFlow is a flag that switches the default behavior to use the classic\nparameter flow when creating a workspace. This only affects deployments with the experiment\n\"dynamic-parameters\" enabled. This setting will live for a period after the experiment is\nmade the default.\nAn \"opt-out\" is present in case the new feature breaks some existing templates.",
                    "type": "boolean"
                }
            }
        },
        "codersdk.UpdateUserAppearanceSettingsRequest": {
            "type": "object",
            "required": [
                "terminal_font",
                "theme_preference"
            ],
            "properties": {
                "terminal_font": {
                    "$ref": "#/definitions/codersdk.TerminalFontName"
                },
                "theme_preference": {
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateUserNotificationPreferences": {
            "type": "object",
            "properties": {
                "template_disabled_map": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "boolean"
                    }
                }
            }
        },
        "codersdk.UpdateUserPasswordRequest": {
            "type": "object",
            "required": [
                "password"
            ],
            "properties": {
                "old_password": {
                    "type": "string"
                },
                "password": {
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateUserPreferenceSettingsRequest": {
            "type": "object",
            "properties": {
                "task_notification_alert_dismissed": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.UpdateUserProfileRequest": {
            "type": "object",
            "required": [
                "username"
            ],
            "properties": {
                "name": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateUserQuietHoursScheduleRequest": {
            "type": "object",
            "required": [
                "schedule"
            ],
            "properties": {
                "schedule": {
                    "description": "Schedule is a cron expression that defines when the user's quiet hours\nwindow is. Schedule must not be empty. For new users, the schedule is set\nto 2am in their browser or computer's timezone. The schedule denotes the\nbeginning of a 4 hour window where the workspace is allowed to\nautomatically stop or restart due to maintenance or template schedule.\n\nThe schedule must be daily with a single time, and should have a timezone\nspecified via a CRON_TZ prefix (otherwise UTC will be used).\n\nIf the schedule is empty, the user will be updated to use the default\nschedule.",
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateWorkspaceACL": {
            "type": "object",
            "properties": {
                "group_roles": {
                    "description": "GroupRoles is a mapping from valid group UUIDs to the workspace role they\nshould be granted. To remove a group from the workspace, use \"\" as the role\n(available as a constant named codersdk.WorkspaceRoleDeleted)",
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/codersdk.WorkspaceRole"
                    }
                },
                "user_roles": {
                    "description": "UserRoles is a mapping from valid user UUIDs to the workspace role they\nshould be granted. To remove a user from the workspace, use \"\" as the role\n(available as a constant named codersdk.WorkspaceRoleDeleted)",
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/codersdk.WorkspaceRole"
                    }
                }
            }
        },
        "codersdk.UpdateWorkspaceAutomaticUpdatesRequest": {
            "type": "object",
            "properties": {
                "automatic_updates": {
                    "$ref": "#/definitions/codersdk.AutomaticUpdates"
                }
            }
        },
        "codersdk.UpdateWorkspaceAutostartRequest": {
            "type": "object",
            "properties": {
                "schedule": {
                    "description": "Schedule is expected to be of the form ` + "`" + `CRON_TZ=\u003cIANA Timezone\u003e \u003cmin\u003e \u003chour\u003e * * \u003cdow\u003e` + "`" + `\nExample: ` + "`" + `CRON_TZ=US/Central 30 9 * * 1-5` + "`" + ` represents 0930 in the timezone US/Central\non weekdays (Mon-Fri). ` + "`" + `CRON_TZ` + "`" + ` defaults to UTC if not present.",
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateWorkspaceBuildStateRequest": {
            "type": "object",
            "properties": {
                "state": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        },
        "codersdk.UpdateWorkspaceDormancy": {
            "type": "object",
            "properties": {
                "dormant": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.UpdateWorkspaceRequest": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.UpdateWorkspaceTTLRequest": {
            "type": "object",
            "properties": {
                "ttl_ms": {
                    "type": "integer"
                }
            }
        },
        "codersdk.UploadResponse": {
            "type": "object",
            "properties": {
                "hash": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.UpsertWorkspaceAgentPortShareRequest": {
            "type": "object",
            "properties": {
                "agent_name": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "protocol": {
                    "enum": [
                        "http",
                        "https"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentPortShareProtocol"
                        }
                    ]
                },
                "share_level": {
                    "enum": [
                        "owner",
                        "authenticated",
                        "organization",
                        "public"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentPortShareLevel"
                        }
                    ]
                }
            }
        },
        "codersdk.UsageAppName": {
            "type": "string",
            "enum": [
                "vscode",
                "jetbrains",
                "reconnecting-pty",
                "ssh"
            ],
            "x-enum-varnames": [
                "UsageAppNameVscode",
                "UsageAppNameJetbrains",
                "UsageAppNameReconnectingPty",
                "UsageAppNameSSH"
            ]
        },
        "codersdk.UsagePeriod": {
            "type": "object",
            "properties": {
                "end": {
                    "type": "string",
                    "format": "date-time"
                },
                "issued_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "start": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.UsageStatsConfig": {
            "type": "object",
            "properties": {
                "enable": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.User": {
            "type": "object",
            "required": [
                "created_at",
                "email",
                "id",
                "username"
            ],
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "email": {
                    "type": "string",
                    "format": "email"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "last_seen_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "login_type": {
                    "$ref": "#/definitions/codersdk.LoginType"
                },
                "name": {
                    "type": "string"
                },
                "organization_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "roles": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.SlimRole"
                    }
                },
                "status": {
                    "enum": [
                        "active",
                        "suspended"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.UserStatus"
                        }
                    ]
                },
                "theme_preference": {
                    "description": "Deprecated: this value should be retrieved from\n` + "`" + `codersdk.UserPreferenceSettings` + "`" + ` instead.",
                    "type": "string"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.UserActivity": {
            "type": "object",
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "seconds": {
                    "type": "integer",
                    "example": 80500
                },
                "template_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.UserActivityInsightsReport": {
            "type": "object",
            "properties": {
                "end_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "start_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "template_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "users": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.UserActivity"
                    }
                }
            }
        },
        "codersdk.UserActivityInsightsResponse": {
            "type": "object",
            "properties": {
                "report": {
                    "$ref": "#/definitions/codersdk.UserActivityInsightsReport"
                }
            }
        },
        "codersdk.UserAppearanceSettings": {
            "type": "object",
            "properties": {
                "terminal_font": {
                    "$ref": "#/definitions/codersdk.TerminalFontName"
                },
                "theme_preference": {
                    "type": "string"
                }
            }
        },
        "codersdk.UserLatency": {
            "type": "object",
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "latency_ms": {
                    "$ref": "#/definitions/codersdk.ConnectionLatency"
                },
                "template_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "user_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.UserLatencyInsightsReport": {
            "type": "object",
            "properties": {
                "end_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "start_time": {
                    "type": "string",
                    "format": "date-time"
                },
                "template_ids": {
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "users": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.UserLatency"
                    }
                }
            }
        },
        "codersdk.UserLatencyInsightsResponse": {
            "type": "object",
            "properties": {
                "report": {
                    "$ref": "#/definitions/codersdk.UserLatencyInsightsReport"
                }
            }
        },
        "codersdk.UserLoginType": {
            "type": "object",
            "properties": {
                "login_type": {
                    "$ref": "#/definitions/codersdk.LoginType"
                }
            }
        },
        "codersdk.UserParameter": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.UserPreferenceSettings": {
            "type": "object",
            "properties": {
                "task_notification_alert_dismissed": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.UserQuietHoursScheduleConfig": {
            "type": "object",
            "properties": {
                "allow_user_custom": {
                    "type": "boolean"
                },
                "default_schedule": {
                    "type": "string"
                }
            }
        },
        "codersdk.UserQuietHoursScheduleResponse": {
            "type": "object",
            "properties": {
                "next": {
                    "description": "Next is the next time that the quiet hours window will start.",
                    "type": "string",
                    "format": "date-time"
                },
                "raw_schedule": {
                    "type": "string"
                },
                "time": {
                    "description": "Time is the time of day that the quiet hours window starts in the given\nTimezone each day.",
                    "type": "string"
                },
                "timezone": {
                    "description": "raw format from the cron expression, UTC if unspecified",
                    "type": "string"
                },
                "user_can_set": {
                    "description": "UserCanSet is true if the user is allowed to set their own quiet hours\nschedule. If false, the user cannot set a custom schedule and the default\nschedule will always be used.",
                    "type": "boolean"
                },
                "user_set": {
                    "description": "UserSet is true if the user has set their own quiet hours schedule. If\nfalse, the user is using the default schedule.",
                    "type": "boolean"
                }
            }
        },
        "codersdk.UserStatus": {
            "type": "string",
            "enum": [
                "active",
                "dormant",
                "suspended"
            ],
            "x-enum-varnames": [
                "UserStatusActive",
                "UserStatusDormant",
                "UserStatusSuspended"
            ]
        },
        "codersdk.UserStatusChangeCount": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer",
                    "example": 10
                },
                "date": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.ValidateUserPasswordRequest": {
            "type": "object",
            "required": [
                "password"
            ],
            "properties": {
                "password": {
                    "type": "string"
                }
            }
        },
        "codersdk.ValidateUserPasswordResponse": {
            "type": "object",
            "properties": {
                "details": {
                    "type": "string"
                },
                "valid": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.ValidationError": {
            "type": "object",
            "required": [
                "detail",
                "field"
            ],
            "properties": {
                "detail": {
                    "type": "string"
                },
                "field": {
                    "type": "string"
                }
            }
        },
        "codersdk.ValidationMonotonicOrder": {
            "type": "string",
            "enum": [
                "increasing",
                "decreasing"
            ],
            "x-enum-varnames": [
                "MonotonicOrderIncreasing",
                "MonotonicOrderDecreasing"
            ]
        },
        "codersdk.VariableValue": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.WebpushSubscription": {
            "type": "object",
            "properties": {
                "auth_key": {
                    "type": "string"
                },
                "endpoint": {
                    "type": "string"
                },
                "p256dh_key": {
                    "type": "string"
                }
            }
        },
        "codersdk.Workspace": {
            "type": "object",
            "properties": {
                "allow_renames": {
                    "type": "boolean"
                },
                "automatic_updates": {
                    "enum": [
                        "always",
                        "never"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.AutomaticUpdates"
                        }
                    ]
                },
                "autostart_schedule": {
                    "type": "string"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "deleting_at": {
                    "description": "DeletingAt indicates the time at which the workspace will be permanently deleted.\nA workspace is eligible for deletion if it is dormant (a non-nil dormant_at value)\nand a value has been specified for time_til_dormant_autodelete on its template.",
                    "type": "string",
                    "format": "date-time"
                },
                "dormant_at": {
                    "description": "DormantAt being non-nil indicates a workspace that is dormant.\nA dormant workspace is no longer accessible must be activated.\nIt is subject to deletion if it breaches\nthe duration of the time_til_ field on its template.",
                    "type": "string",
                    "format": "date-time"
                },
                "favorite": {
                    "type": "boolean"
                },
                "health": {
                    "description": "Health shows the health of the workspace and information about\nwhat is causing an unhealthy status.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceHealth"
                        }
                    ]
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "is_prebuild": {
                    "description": "IsPrebuild indicates whether the workspace is a prebuilt workspace.\nPrebuilt workspaces are owned by the prebuilds system user and have specific behavior,\nsuch as being managed differently from regular workspaces.\nOnce a prebuilt workspace is claimed by a user, it transitions to a regular workspace,\nand IsPrebuild returns false.",
                    "type": "boolean"
                },
                "last_used_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "latest_app_status": {
                    "$ref": "#/definitions/codersdk.WorkspaceAppStatus"
                },
                "latest_build": {
                    "$ref": "#/definitions/codersdk.WorkspaceBuild"
                },
                "name": {
                    "type": "string"
                },
                "next_start_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "organization_name": {
                    "type": "string"
                },
                "outdated": {
                    "type": "boolean"
                },
                "owner_avatar_url": {
                    "type": "string"
                },
                "owner_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "owner_name": {
                    "description": "OwnerName is the username of the owner of the workspace.",
                    "type": "string"
                },
                "shared_with": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.SharedWorkspaceActor"
                    }
                },
                "task_id": {
                    "description": "TaskID, if set, indicates that the workspace is relevant to the given codersdk.Task.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/uuid.NullUUID"
                        }
                    ]
                },
                "template_active_version_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "template_allow_user_cancel_workspace_jobs": {
                    "type": "boolean"
                },
                "template_display_name": {
                    "type": "string"
                },
                "template_icon": {
                    "type": "string"
                },
                "template_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "template_name": {
                    "type": "string"
                },
                "template_require_active_version": {
                    "type": "boolean"
                },
                "template_use_classic_parameter_flow": {
                    "type": "boolean"
                },
                "ttl_ms": {
                    "type": "integer"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                }
            }
        },
        "codersdk.WorkspaceACL": {
            "type": "object",
            "properties": {
                "group": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceGroup"
                    }
                },
                "users": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceUser"
                    }
                }
            }
        },
        "codersdk.WorkspaceAgent": {
            "type": "object",
            "properties": {
                "api_version": {
                    "type": "string"
                },
                "apps": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceApp"
                    }
                },
                "architecture": {
                    "type": "string"
                },
                "connection_timeout_seconds": {
                    "type": "integer"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "directory": {
                    "type": "string"
                },
                "disconnected_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "display_apps": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.DisplayApp"
                    }
                },
                "environment_variables": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "expanded_directory": {
                    "type": "string"
                },
                "first_connected_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "health": {
                    "description": "Health reports the health of the agent.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentHealth"
                        }
                    ]
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "instance_id": {
                    "type": "string"
                },
                "last_connected_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "latency": {
                    "description": "DERPLatency is mapped by region name (e.g. \"New York City\", \"Seattle\").",
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/codersdk.DERPRegion"
                    }
                },
                "lifecycle_state": {
                    "$ref": "#/definitions/codersdk.WorkspaceAgentLifecycle"
                },
                "log_sources": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAgentLogSource"
                    }
                },
                "logs_length": {
                    "type": "integer"
                },
                "logs_overflowed": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "operating_system": {
                    "type": "string"
                },
                "parent_id": {
                    "format": "uuid",
                    "allOf": [
                        {
                            "$ref": "#/definitions/uuid.NullUUID"
                        }
                    ]
                },
                "ready_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "resource_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "scripts": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAgentScript"
                    }
                },
                "started_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "startup_script_behavior": {
                    "description": "StartupScriptBehavior is a legacy field that is deprecated in favor\nof the ` + "`" + `coder_script` + "`" + ` resource. It's only referenced by old clients.\nDeprecated: Remove in the future!",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentStartupScriptBehavior"
                        }
                    ]
                },
                "status": {
                    "$ref": "#/definitions/codersdk.WorkspaceAgentStatus"
                },
                "subsystems": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.AgentSubsystem"
                    }
                },
                "troubleshooting_url": {
                    "type": "string"
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "version": {
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceAgentContainer": {
            "type": "object",
            "properties": {
                "created_at": {
                    "description": "CreatedAt is the time the container was created.",
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "description": "ID is the unique identifier of the container.",
                    "type": "string"
                },
                "image": {
                    "description": "Image is the name of the container image.",
                    "type": "string"
                },
                "labels": {
                    "description": "Labels is a map of key-value pairs of container labels.",
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "name": {
                    "description": "FriendlyName is the human-readable name of the container.",
                    "type": "string"
                },
                "ports": {
                    "description": "Ports includes ports exposed by the container.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAgentContainerPort"
                    }
                },
                "running": {
                    "description": "Running is true if the container is currently running.",
                    "type": "boolean"
                },
                "status": {
                    "description": "Status is the current status of the container. This is somewhat\nimplementation-dependent, but should generally be a human-readable\nstring.",
                    "type": "string"
                },
                "volumes": {
                    "description": "Volumes is a map of \"things\" mounted into the container. Again, this\nis somewhat implementation-dependent.",
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.WorkspaceAgentContainerPort": {
            "type": "object",
            "properties": {
                "host_ip": {
                    "description": "HostIP is the IP address of the host interface to which the port is\nbound. Note that this can be an IPv4 or IPv6 address.",
                    "type": "string"
                },
                "host_port": {
                    "description": "HostPort is the port number *outside* the container.",
                    "type": "integer"
                },
                "network": {
                    "description": "Network is the network protocol used by the port (tcp, udp, etc).",
                    "type": "string"
                },
                "port": {
                    "description": "Port is the port number *inside* the container.",
                    "type": "integer"
                }
            }
        },
        "codersdk.WorkspaceAgentDevcontainer": {
            "type": "object",
            "properties": {
                "agent": {
                    "$ref": "#/definitions/codersdk.WorkspaceAgentDevcontainerAgent"
                },
                "config_path": {
                    "type": "string"
                },
                "container": {
                    "$ref": "#/definitions/codersdk.WorkspaceAgentContainer"
                },
                "dirty": {
                    "type": "boolean"
                },
                "error": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                },
                "status": {
                    "description": "Additional runtime fields.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentDevcontainerStatus"
                        }
                    ]
                },
                "workspace_folder": {
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceAgentDevcontainerAgent": {
            "type": "object",
            "properties": {
                "directory": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceAgentDevcontainerStatus": {
            "type": "string",
            "enum": [
                "running",
                "stopped",
                "starting",
                "stopping",
                "deleting",
                "error"
            ],
            "x-enum-varnames": [
                "WorkspaceAgentDevcontainerStatusRunning",
                "WorkspaceAgentDevcontainerStatusStopped",
                "WorkspaceAgentDevcontainerStatusStarting",
                "WorkspaceAgentDevcontainerStatusStopping",
                "WorkspaceAgentDevcontainerStatusDeleting",
                "WorkspaceAgentDevcontainerStatusError"
            ]
        },
        "codersdk.WorkspaceAgentHealth": {
            "type": "object",
            "properties": {
                "healthy": {
                    "description": "Healthy is true if the agent is healthy.",
                    "type": "boolean",
                    "example": false
                },
                "reason": {
                    "description": "Reason is a human-readable explanation of the agent's health. It is empty if Healthy is true.",
                    "type": "string",
                    "example": "agent has lost connection"
                }
            }
        },
        "codersdk.WorkspaceAgentLifecycle": {
            "type": "string",
            "enum": [
                "created",
                "starting",
                "start_timeout",
                "start_error",
                "ready",
                "shutting_down",
                "shutdown_timeout",
                "shutdown_error",
                "off"
            ],
            "x-enum-varnames": [
                "WorkspaceAgentLifecycleCreated",
                "WorkspaceAgentLifecycleStarting",
                "WorkspaceAgentLifecycleStartTimeout",
                "WorkspaceAgentLifecycleStartError",
                "WorkspaceAgentLifecycleReady",
                "WorkspaceAgentLifecycleShuttingDown",
                "WorkspaceAgentLifecycleShutdownTimeout",
                "WorkspaceAgentLifecycleShutdownError",
                "WorkspaceAgentLifecycleOff"
            ]
        },
        "codersdk.WorkspaceAgentListContainersResponse": {
            "type": "object",
            "properties": {
                "containers": {
                    "description": "Containers is a list of containers visible to the workspace agent.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAgentContainer"
                    }
                },
                "devcontainers": {
                    "description": "Devcontainers is a list of devcontainers visible to the workspace agent.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAgentDevcontainer"
                    }
                },
                "warnings": {
                    "description": "Warnings is a list of warnings that may have occurred during the\nprocess of listing containers. This should not include fatal errors.",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "codersdk.WorkspaceAgentListeningPort": {
            "type": "object",
            "properties": {
                "network": {
                    "description": "only \"tcp\" at the moment",
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "process_name": {
                    "description": "may be empty",
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceAgentListeningPortsResponse": {
            "type": "object",
            "properties": {
                "ports": {
                    "description": "If there are no ports in the list, nothing should be displayed in the UI.\nThere must not be a \"no ports available\" message or anything similar, as\nthere will always be no ports displayed on platforms where our port\ndetection logic is unsupported.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAgentListeningPort"
                    }
                }
            }
        },
        "codersdk.WorkspaceAgentLog": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "id": {
                    "type": "integer"
                },
                "level": {
                    "$ref": "#/definitions/codersdk.LogLevel"
                },
                "output": {
                    "type": "string"
                },
                "source_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.WorkspaceAgentLogSource": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "display_name": {
                    "type": "string"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "workspace_agent_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.WorkspaceAgentPortShare": {
            "type": "object",
            "properties": {
                "agent_name": {
                    "type": "string"
                },
                "port": {
                    "type": "integer"
                },
                "protocol": {
                    "enum": [
                        "http",
                        "https"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentPortShareProtocol"
                        }
                    ]
                },
                "share_level": {
                    "enum": [
                        "owner",
                        "authenticated",
                        "organization",
                        "public"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAgentPortShareLevel"
                        }
                    ]
                },
                "workspace_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.WorkspaceAgentPortShareLevel": {
            "type": "string",
            "enum": [
                "owner",
                "authenticated",
                "organization",
                "public"
            ],
            "x-enum-varnames": [
                "WorkspaceAgentPortShareLevelOwner",
                "WorkspaceAgentPortShareLevelAuthenticated",
                "WorkspaceAgentPortShareLevelOrganization",
                "WorkspaceAgentPortShareLevelPublic"
            ]
        },
        "codersdk.WorkspaceAgentPortShareProtocol": {
            "type": "string",
            "enum": [
                "http",
                "https"
            ],
            "x-enum-varnames": [
                "WorkspaceAgentPortShareProtocolHTTP",
                "WorkspaceAgentPortShareProtocolHTTPS"
            ]
        },
        "codersdk.WorkspaceAgentPortShares": {
            "type": "object",
            "properties": {
                "shares": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAgentPortShare"
                    }
                }
            }
        },
        "codersdk.WorkspaceAgentScript": {
            "type": "object",
            "properties": {
                "cron": {
                    "type": "string"
                },
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "log_path": {
                    "type": "string"
                },
                "log_source_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "run_on_start": {
                    "type": "boolean"
                },
                "run_on_stop": {
                    "type": "boolean"
                },
                "script": {
                    "type": "string"
                },
                "start_blocks_login": {
                    "type": "boolean"
                },
                "timeout": {
                    "type": "integer"
                }
            }
        },
        "codersdk.WorkspaceAgentStartupScriptBehavior": {
            "type": "string",
            "enum": [
                "blocking",
                "non-blocking"
            ],
            "x-enum-varnames": [
                "WorkspaceAgentStartupScriptBehaviorBlocking",
                "WorkspaceAgentStartupScriptBehaviorNonBlocking"
            ]
        },
        "codersdk.WorkspaceAgentStatus": {
            "type": "string",
            "enum": [
                "connecting",
                "connected",
                "disconnected",
                "timeout"
            ],
            "x-enum-varnames": [
                "WorkspaceAgentConnecting",
                "WorkspaceAgentConnected",
                "WorkspaceAgentDisconnected",
                "WorkspaceAgentTimeout"
            ]
        },
        "codersdk.WorkspaceApp": {
            "type": "object",
            "properties": {
                "command": {
                    "type": "string"
                },
                "display_name": {
                    "description": "DisplayName is a friendly name for the app.",
                    "type": "string"
                },
                "external": {
                    "description": "External specifies whether the URL should be opened externally on\nthe client or not.",
                    "type": "boolean"
                },
                "group": {
                    "type": "string"
                },
                "health": {
                    "$ref": "#/definitions/codersdk.WorkspaceAppHealth"
                },
                "healthcheck": {
                    "description": "Healthcheck specifies the configuration for checking app health.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.Healthcheck"
                        }
                    ]
                },
                "hidden": {
                    "type": "boolean"
                },
                "icon": {
                    "description": "Icon is a relative path or external URL that specifies\nan icon to be displayed in the dashboard.",
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "open_in": {
                    "$ref": "#/definitions/codersdk.WorkspaceAppOpenIn"
                },
                "sharing_level": {
                    "enum": [
                        "owner",
                        "authenticated",
                        "organization",
                        "public"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceAppSharingLevel"
                        }
                    ]
                },
                "slug": {
                    "description": "Slug is a unique identifier within the agent.",
                    "type": "string"
                },
                "statuses": {
                    "description": "Statuses is a list of statuses for the app.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAppStatus"
                    }
                },
                "subdomain": {
                    "description": "Subdomain denotes whether the app should be accessed via a path on the\n` + "`" + `coder server` + "`" + ` or via a hostname-based dev URL. If this is set to true\nand there is no app wildcard configured on the server, the app will not\nbe accessible in the UI.",
                    "type": "boolean"
                },
                "subdomain_name": {
                    "description": "SubdomainName is the application domain exposed on the ` + "`" + `coder server` + "`" + `.",
                    "type": "string"
                },
                "tooltip": {
                    "description": "Tooltip is an optional markdown supported field that is displayed\nwhen hovering over workspace apps in the UI.",
                    "type": "string"
                },
                "url": {
                    "description": "URL is the address being proxied to inside the workspace.\nIf external is specified, this will be opened on the client.",
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceAppHealth": {
            "type": "string",
            "enum": [
                "disabled",
                "initializing",
                "healthy",
                "unhealthy"
            ],
            "x-enum-varnames": [
                "WorkspaceAppHealthDisabled",
                "WorkspaceAppHealthInitializing",
                "WorkspaceAppHealthHealthy",
                "WorkspaceAppHealthUnhealthy"
            ]
        },
        "codersdk.WorkspaceAppOpenIn": {
            "type": "string",
            "enum": [
                "slim-window",
                "tab"
            ],
            "x-enum-varnames": [
                "WorkspaceAppOpenInSlimWindow",
                "WorkspaceAppOpenInTab"
            ]
        },
        "codersdk.WorkspaceAppSharingLevel": {
            "type": "string",
            "enum": [
                "owner",
                "authenticated",
                "organization",
                "public"
            ],
            "x-enum-varnames": [
                "WorkspaceAppSharingLevelOwner",
                "WorkspaceAppSharingLevelAuthenticated",
                "WorkspaceAppSharingLevelOrganization",
                "WorkspaceAppSharingLevelPublic"
            ]
        },
        "codersdk.WorkspaceAppStatus": {
            "type": "object",
            "properties": {
                "agent_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "app_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "icon": {
                    "description": "Deprecated: This field is unused and will be removed in a future version.\nIcon is an external URL to an icon that will be rendered in the UI.",
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "message": {
                    "type": "string"
                },
                "needs_user_attention": {
                    "description": "Deprecated: This field is unused and will be removed in a future version.\nNeedsUserAttention specifies whether the status needs user attention.",
                    "type": "boolean"
                },
                "state": {
                    "$ref": "#/definitions/codersdk.WorkspaceAppStatusState"
                },
                "uri": {
                    "description": "URI is the URI of the resource that the status is for.\ne.g. https://github.com/org/repo/pull/123\ne.g. file:///path/to/file",
                    "type": "string"
                },
                "workspace_id": {
                    "type": "string",
                    "format": "uuid"
                }
            }
        },
        "codersdk.WorkspaceAppStatusState": {
            "type": "string",
            "enum": [
                "working",
                "idle",
                "complete",
                "failure"
            ],
            "x-enum-varnames": [
                "WorkspaceAppStatusStateWorking",
                "WorkspaceAppStatusStateIdle",
                "WorkspaceAppStatusStateComplete",
                "WorkspaceAppStatusStateFailure"
            ]
        },
        "codersdk.WorkspaceBuild": {
            "type": "object",
            "properties": {
                "build_number": {
                    "type": "integer"
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "daily_cost": {
                    "type": "integer"
                },
                "deadline": {
                    "type": "string",
                    "format": "date-time"
                },
                "has_ai_task": {
                    "description": "Deprecated: This field has been deprecated in favor of Task WorkspaceID.",
                    "type": "boolean"
                },
                "has_external_agent": {
                    "type": "boolean"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "initiator_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "initiator_name": {
                    "type": "string"
                },
                "job": {
                    "$ref": "#/definitions/codersdk.ProvisionerJob"
                },
                "matched_provisioners": {
                    "$ref": "#/definitions/codersdk.MatchedProvisioners"
                },
                "max_deadline": {
                    "type": "string",
                    "format": "date-time"
                },
                "reason": {
                    "enum": [
                        "initiator",
                        "autostart",
                        "autostop"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.BuildReason"
                        }
                    ]
                },
                "resources": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceResource"
                    }
                },
                "status": {
                    "enum": [
                        "pending",
                        "starting",
                        "running",
                        "stopping",
                        "stopped",
                        "failed",
                        "canceling",
                        "canceled",
                        "deleting",
                        "deleted"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceStatus"
                        }
                    ]
                },
                "template_version_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "template_version_name": {
                    "type": "string"
                },
                "template_version_preset_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "transition": {
                    "enum": [
                        "start",
                        "stop",
                        "delete"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceTransition"
                        }
                    ]
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "workspace_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "workspace_name": {
                    "type": "string"
                },
                "workspace_owner_avatar_url": {
                    "type": "string"
                },
                "workspace_owner_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "workspace_owner_name": {
                    "description": "WorkspaceOwnerName is the username of the owner of the workspace.",
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceBuildParameter": {
            "type": "object",
            "properties": {
                "name": {
                    "type": "string"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceBuildTimings": {
            "type": "object",
            "properties": {
                "agent_connection_timings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.AgentConnectionTiming"
                    }
                },
                "agent_script_timings": {
                    "description": "TODO: Consolidate agent-related timing metrics into a single struct when\nupdating the API version",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.AgentScriptTiming"
                    }
                },
                "provisioner_timings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ProvisionerTiming"
                    }
                }
            }
        },
        "codersdk.WorkspaceConnectionLatencyMS": {
            "type": "object",
            "properties": {
                "p50": {
                    "type": "number"
                },
                "p95": {
                    "type": "number"
                }
            }
        },
        "codersdk.WorkspaceDeploymentStats": {
            "type": "object",
            "properties": {
                "building": {
                    "type": "integer"
                },
                "connection_latency_ms": {
                    "$ref": "#/definitions/codersdk.WorkspaceConnectionLatencyMS"
                },
                "failed": {
                    "type": "integer"
                },
                "pending": {
                    "type": "integer"
                },
                "running": {
                    "type": "integer"
                },
                "rx_bytes": {
                    "type": "integer"
                },
                "stopped": {
                    "type": "integer"
                },
                "tx_bytes": {
                    "type": "integer"
                }
            }
        },
        "codersdk.WorkspaceGroup": {
            "type": "object",
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "display_name": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "members": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ReducedUser"
                    }
                },
                "name": {
                    "type": "string"
                },
                "organization_display_name": {
                    "type": "string"
                },
                "organization_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "organization_name": {
                    "type": "string"
                },
                "quota_allowance": {
                    "type": "integer"
                },
                "role": {
                    "enum": [
                        "admin",
                        "use"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceRole"
                        }
                    ]
                },
                "source": {
                    "$ref": "#/definitions/codersdk.GroupSource"
                },
                "total_member_count": {
                    "description": "How many members are in this group. Shows the total count,\neven if the user is not authorized to read group member details.\nMay be greater than ` + "`" + `len(Group.Members)` + "`" + `.",
                    "type": "integer"
                }
            }
        },
        "codersdk.WorkspaceHealth": {
            "type": "object",
            "properties": {
                "failing_agents": {
                    "description": "FailingAgents lists the IDs of the agents that are failing, if any.",
                    "type": "array",
                    "items": {
                        "type": "string",
                        "format": "uuid"
                    }
                },
                "healthy": {
                    "description": "Healthy is true if the workspace is healthy.",
                    "type": "boolean",
                    "example": false
                }
            }
        },
        "codersdk.WorkspaceProxy": {
            "type": "object",
            "properties": {
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "deleted": {
                    "type": "boolean"
                },
                "derp_enabled": {
                    "type": "boolean"
                },
                "derp_only": {
                    "type": "boolean"
                },
                "display_name": {
                    "type": "string"
                },
                "healthy": {
                    "type": "boolean"
                },
                "icon_url": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                },
                "path_app_url": {
                    "description": "PathAppURL is the URL to the base path for path apps. Optional\nunless wildcard_hostname is set.\nE.g. https://us.example.com",
                    "type": "string"
                },
                "status": {
                    "description": "Status is the latest status check of the proxy. This will be empty for deleted\nproxies. This value can be used to determine if a workspace proxy is healthy\nand ready to use.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceProxyStatus"
                        }
                    ]
                },
                "updated_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "version": {
                    "type": "string"
                },
                "wildcard_hostname": {
                    "description": "WildcardHostname is the wildcard hostname for subdomain apps.\nE.g. *.us.example.com\nE.g. *--suffix.au.example.com\nOptional. Does not need to be on the same domain as PathAppURL.",
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceProxyStatus": {
            "type": "object",
            "properties": {
                "checked_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "report": {
                    "description": "Report provides more information about the health of the workspace proxy.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.ProxyHealthReport"
                        }
                    ]
                },
                "status": {
                    "$ref": "#/definitions/codersdk.ProxyHealthStatus"
                }
            }
        },
        "codersdk.WorkspaceQuota": {
            "type": "object",
            "properties": {
                "budget": {
                    "type": "integer"
                },
                "credits_consumed": {
                    "type": "integer"
                }
            }
        },
        "codersdk.WorkspaceResource": {
            "type": "object",
            "properties": {
                "agents": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceAgent"
                    }
                },
                "created_at": {
                    "type": "string",
                    "format": "date-time"
                },
                "daily_cost": {
                    "type": "integer"
                },
                "hide": {
                    "type": "boolean"
                },
                "icon": {
                    "type": "string"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "job_id": {
                    "type": "string",
                    "format": "uuid"
                },
                "metadata": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.WorkspaceResourceMetadata"
                    }
                },
                "name": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                },
                "workspace_transition": {
                    "enum": [
                        "start",
                        "stop",
                        "delete"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceTransition"
                        }
                    ]
                }
            }
        },
        "codersdk.WorkspaceResourceMetadata": {
            "type": "object",
            "properties": {
                "key": {
                    "type": "string"
                },
                "sensitive": {
                    "type": "boolean"
                },
                "value": {
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspaceRole": {
            "type": "string",
            "enum": [
                "admin",
                "use",
                ""
            ],
            "x-enum-varnames": [
                "WorkspaceRoleAdmin",
                "WorkspaceRoleUse",
                "WorkspaceRoleDeleted"
            ]
        },
        "codersdk.WorkspaceSharingSettings": {
            "type": "object",
            "properties": {
                "sharing_disabled": {
                    "type": "boolean"
                }
            }
        },
        "codersdk.WorkspaceStatus": {
            "type": "string",
            "enum": [
                "pending",
                "starting",
                "running",
                "stopping",
                "stopped",
                "failed",
                "canceling",
                "canceled",
                "deleting",
                "deleted"
            ],
            "x-enum-varnames": [
                "WorkspaceStatusPending",
                "WorkspaceStatusStarting",
                "WorkspaceStatusRunning",
                "WorkspaceStatusStopping",
                "WorkspaceStatusStopped",
                "WorkspaceStatusFailed",
                "WorkspaceStatusCanceling",
                "WorkspaceStatusCanceled",
                "WorkspaceStatusDeleting",
                "WorkspaceStatusDeleted"
            ]
        },
        "codersdk.WorkspaceTransition": {
            "type": "string",
            "enum": [
                "start",
                "stop",
                "delete"
            ],
            "x-enum-varnames": [
                "WorkspaceTransitionStart",
                "WorkspaceTransitionStop",
                "WorkspaceTransitionDelete"
            ]
        },
        "codersdk.WorkspaceUser": {
            "type": "object",
            "required": [
                "id",
                "username"
            ],
            "properties": {
                "avatar_url": {
                    "type": "string",
                    "format": "uri"
                },
                "id": {
                    "type": "string",
                    "format": "uuid"
                },
                "name": {
                    "type": "string"
                },
                "role": {
                    "enum": [
                        "admin",
                        "use"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/codersdk.WorkspaceRole"
                        }
                    ]
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "codersdk.WorkspacesResponse": {
            "type": "object",
            "properties": {
                "count": {
                    "type": "integer"
                },
                "workspaces": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Workspace"
                    }
                }
            }
        },
        "derp.BytesSentRecv": {
            "type": "object",
            "properties": {
                "key": {
                    "description": "Key is the public key of the client which sent/received these bytes.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/key.NodePublic"
                        }
                    ]
                },
                "recv": {
                    "type": "integer"
                },
                "sent": {
                    "type": "integer"
                }
            }
        },
        "derp.ServerInfoMessage": {
            "type": "object",
            "properties": {
                "tokenBucketBytesBurst": {
                    "description": "TokenBucketBytesBurst is how many bytes the server will\nallow to burst, temporarily violating\nTokenBucketBytesPerSecond.\n\nZero means unspecified. There might be a limit, but the\nclient need not try to respect it.",
                    "type": "integer"
                },
                "tokenBucketBytesPerSecond": {
                    "description": "TokenBucketBytesPerSecond is how many bytes per second the\nserver says it will accept, including all framing bytes.\n\nZero means unspecified. There might be a limit, but the\nclient need not try to respect it.",
                    "type": "integer"
                }
            }
        },
        "health.Code": {
            "type": "string",
            "enum": [
                "EUNKNOWN",
                "EWP01",
                "EWP02",
                "EWP04",
                "EDB01",
                "EDB02",
                "EWS01",
                "EWS02",
                "EWS03",
                "EACS01",
                "EACS02",
                "EACS03",
                "EACS04",
                "EDERP01",
                "EDERP02",
                "EPD01",
                "EPD02",
                "EPD03"
            ],
            "x-enum-varnames": [
                "CodeUnknown",
                "CodeProxyUpdate",
                "CodeProxyFetch",
                "CodeProxyUnhealthy",
                "CodeDatabasePingFailed",
                "CodeDatabasePingSlow",
                "CodeWebsocketDial",
                "CodeWebsocketEcho",
                "CodeWebsocketMsg",
                "CodeAccessURLNotSet",
                "CodeAccessURLInvalid",
                "CodeAccessURLFetch",
                "CodeAccessURLNotOK",
                "CodeDERPNodeUsesWebsocket",
                "CodeDERPOneNodeUnhealthy",
                "CodeProvisionerDaemonsNoProvisionerDaemons",
                "CodeProvisionerDaemonVersionMismatch",
                "CodeProvisionerDaemonAPIMajorVersionDeprecated"
            ]
        },
        "health.Message": {
            "type": "object",
            "properties": {
                "code": {
                    "$ref": "#/definitions/health.Code"
                },
                "message": {
                    "type": "string"
                }
            }
        },
        "health.Severity": {
            "type": "string",
            "enum": [
                "ok",
                "warning",
                "error"
            ],
            "x-enum-varnames": [
                "SeverityOK",
                "SeverityWarning",
                "SeverityError"
            ]
        },
        "healthsdk.AccessURLReport": {
            "type": "object",
            "properties": {
                "access_url": {
                    "type": "string"
                },
                "dismissed": {
                    "type": "boolean"
                },
                "error": {
                    "type": "string"
                },
                "healthy": {
                    "description": "Healthy is deprecated and left for backward compatibility purposes, use ` + "`" + `Severity` + "`" + ` instead.",
                    "type": "boolean"
                },
                "healthz_response": {
                    "type": "string"
                },
                "reachable": {
                    "type": "boolean"
                },
                "severity": {
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "status_code": {
                    "type": "integer"
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                }
            }
        },
        "healthsdk.DERPHealthReport": {
            "type": "object",
            "properties": {
                "dismissed": {
                    "type": "boolean"
                },
                "error": {
                    "type": "string"
                },
                "healthy": {
                    "description": "Healthy is deprecated and left for backward compatibility purposes, use ` + "`" + `Severity` + "`" + ` instead.",
                    "type": "boolean"
                },
                "netcheck": {
                    "$ref": "#/definitions/netcheck.Report"
                },
                "netcheck_err": {
                    "type": "string"
                },
                "netcheck_logs": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "regions": {
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/healthsdk.DERPRegionReport"
                    }
                },
                "severity": {
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                }
            }
        },
        "healthsdk.DERPNodeReport": {
            "type": "object",
            "properties": {
                "can_exchange_messages": {
                    "type": "boolean"
                },
                "client_errs": {
                    "type": "array",
                    "items": {
                        "type": "array",
                        "items": {
                            "type": "string"
                        }
                    }
                },
                "client_logs": {
                    "type": "array",
                    "items": {
                        "type": "array",
                        "items": {
                            "type": "string"
                        }
                    }
                },
                "error": {
                    "type": "string"
                },
                "healthy": {
                    "description": "Healthy is deprecated and left for backward compatibility purposes, use ` + "`" + `Severity` + "`" + ` instead.",
                    "type": "boolean"
                },
                "node": {
                    "$ref": "#/definitions/tailcfg.DERPNode"
                },
                "node_info": {
                    "$ref": "#/definitions/derp.ServerInfoMessage"
                },
                "round_trip_ping": {
                    "type": "string"
                },
                "round_trip_ping_ms": {
                    "type": "integer"
                },
                "severity": {
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "stun": {
                    "$ref": "#/definitions/healthsdk.STUNReport"
                },
                "uses_websocket": {
                    "type": "boolean"
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                }
            }
        },
        "healthsdk.DERPRegionReport": {
            "type": "object",
            "properties": {
                "error": {
                    "type": "string"
                },
                "healthy": {
                    "description": "Healthy is deprecated and left for backward compatibility purposes, use ` + "`" + `Severity` + "`" + ` instead.",
                    "type": "boolean"
                },
                "node_reports": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/healthsdk.DERPNodeReport"
                    }
                },
                "region": {
                    "$ref": "#/definitions/tailcfg.DERPRegion"
                },
                "severity": {
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                }
            }
        },
        "healthsdk.DatabaseReport": {
            "type": "object",
            "properties": {
                "dismissed": {
                    "type": "boolean"
                },
                "error": {
                    "type": "string"
                },
                "healthy": {
                    "description": "Healthy is deprecated and left for backward compatibility purposes, use ` + "`" + `Severity` + "`" + ` instead.",
                    "type": "boolean"
                },
                "latency": {
                    "type": "string"
                },
                "latency_ms": {
                    "type": "integer"
                },
                "reachable": {
                    "type": "boolean"
                },
                "severity": {
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "threshold_ms": {
                    "type": "integer"
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                }
            }
        },
        "healthsdk.HealthSection": {
            "type": "string",
            "enum": [
                "DERP",
                "AccessURL",
                "Websocket",
                "Database",
                "WorkspaceProxy",
                "ProvisionerDaemons"
            ],
            "x-enum-varnames": [
                "HealthSectionDERP",
                "HealthSectionAccessURL",
                "HealthSectionWebsocket",
                "HealthSectionDatabase",
                "HealthSectionWorkspaceProxy",
                "HealthSectionProvisionerDaemons"
            ]
        },
        "healthsdk.HealthSettings": {
            "type": "object",
            "properties": {
                "dismissed_healthchecks": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/healthsdk.HealthSection"
                    }
                }
            }
        },
        "healthsdk.HealthcheckReport": {
            "type": "object",
            "properties": {
                "access_url": {
                    "$ref": "#/definitions/healthsdk.AccessURLReport"
                },
                "coder_version": {
                    "description": "The Coder version of the server that the report was generated on.",
                    "type": "string"
                },
                "database": {
                    "$ref": "#/definitions/healthsdk.DatabaseReport"
                },
                "derp": {
                    "$ref": "#/definitions/healthsdk.DERPHealthReport"
                },
                "healthy": {
                    "description": "Healthy is true if the report returns no errors.\nDeprecated: use ` + "`" + `Severity` + "`" + ` instead",
                    "type": "boolean"
                },
                "provisioner_daemons": {
                    "$ref": "#/definitions/healthsdk.ProvisionerDaemonsReport"
                },
                "severity": {
                    "description": "Severity indicates the status of Coder health.",
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "time": {
                    "description": "Time is the time the report was generated at.",
                    "type": "string",
                    "format": "date-time"
                },
                "websocket": {
                    "$ref": "#/definitions/healthsdk.WebsocketReport"
                },
                "workspace_proxy": {
                    "$ref": "#/definitions/healthsdk.WorkspaceProxyReport"
                }
            }
        },
        "healthsdk.ProvisionerDaemonsReport": {
            "type": "object",
            "properties": {
                "dismissed": {
                    "type": "boolean"
                },
                "error": {
                    "type": "string"
                },
                "items": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/healthsdk.ProvisionerDaemonsReportItem"
                    }
                },
                "severity": {
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                }
            }
        },
        "healthsdk.ProvisionerDaemonsReportItem": {
            "type": "object",
            "properties": {
                "provisioner_daemon": {
                    "$ref": "#/definitions/codersdk.ProvisionerDaemon"
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                }
            }
        },
        "healthsdk.STUNReport": {
            "type": "object",
            "properties": {
                "canSTUN": {
                    "type": "boolean"
                },
                "enabled": {
                    "type": "boolean"
                },
                "error": {
                    "type": "string"
                }
            }
        },
        "healthsdk.UpdateHealthSettings": {
            "type": "object",
            "properties": {
                "dismissed_healthchecks": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/healthsdk.HealthSection"
                    }
                }
            }
        },
        "healthsdk.WebsocketReport": {
            "type": "object",
            "properties": {
                "body": {
                    "type": "string"
                },
                "code": {
                    "type": "integer"
                },
                "dismissed": {
                    "type": "boolean"
                },
                "error": {
                    "type": "string"
                },
                "healthy": {
                    "description": "Healthy is deprecated and left for backward compatibility purposes, use ` + "`" + `Severity` + "`" + ` instead.",
                    "type": "boolean"
                },
                "severity": {
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                }
            }
        },
        "healthsdk.WorkspaceProxyReport": {
            "type": "object",
            "properties": {
                "dismissed": {
                    "type": "boolean"
                },
                "error": {
                    "type": "string"
                },
                "healthy": {
                    "description": "Healthy is deprecated and left for backward compatibility purposes, use ` + "`" + `Severity` + "`" + ` instead.",
                    "type": "boolean"
                },
                "severity": {
                    "enum": [
                        "ok",
                        "warning",
                        "error"
                    ],
                    "allOf": [
                        {
                            "$ref": "#/definitions/health.Severity"
                        }
                    ]
                },
                "warnings": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/health.Message"
                    }
                },
                "workspace_proxies": {
                    "$ref": "#/definitions/codersdk.RegionsResponse-codersdk_WorkspaceProxy"
                }
            }
        },
        "key.NodePublic": {
            "type": "object"
        },
        "netcheck.Report": {
            "type": "object",
            "properties": {
                "captivePortal": {
                    "description": "CaptivePortal is set when we think there's a captive portal that is\nintercepting HTTP traffic.",
                    "type": "string"
                },
                "globalV4": {
                    "description": "ip:port of global IPv4",
                    "type": "string"
                },
                "globalV6": {
                    "description": "[ip]:port of global IPv6",
                    "type": "string"
                },
                "hairPinning": {
                    "description": "HairPinning is whether the router supports communicating\nbetween two local devices through the NATted public IP address\n(on IPv4).",
                    "type": "string"
                },
                "icmpv4": {
                    "description": "an ICMPv4 round trip completed",
                    "type": "boolean"
                },
                "ipv4": {
                    "description": "an IPv4 STUN round trip completed",
                    "type": "boolean"
                },
                "ipv4CanSend": {
                    "description": "an IPv4 packet was able to be sent",
                    "type": "boolean"
                },
                "ipv6": {
                    "description": "an IPv6 STUN round trip completed",
                    "type": "boolean"
                },
                "ipv6CanSend": {
                    "description": "an IPv6 packet was able to be sent",
                    "type": "boolean"
                },
                "mappingVariesByDestIP": {
                    "description": "MappingVariesByDestIP is whether STUN results depend which\nSTUN server you're talking to (on IPv4).",
                    "type": "string"
                },
                "oshasIPv6": {
                    "description": "could bind a socket to ::1",
                    "type": "boolean"
                },
                "pcp": {
                    "description": "PCP is whether PCP appears present on the LAN.\nEmpty means not checked.",
                    "type": "string"
                },
                "pmp": {
                    "description": "PMP is whether NAT-PMP appears present on the LAN.\nEmpty means not checked.",
                    "type": "string"
                },
                "preferredDERP": {
                    "description": "or 0 for unknown",
                    "type": "integer"
                },
                "regionLatency": {
                    "description": "keyed by DERP Region ID",
                    "type": "object",
                    "additionalProperties": {
                        "type": "integer"
                    }
                },
                "regionV4Latency": {
                    "description": "keyed by DERP Region ID",
                    "type": "object",
                    "additionalProperties": {
                        "type": "integer"
                    }
                },
                "regionV6Latency": {
                    "description": "keyed by DERP Region ID",
                    "type": "object",
                    "additionalProperties": {
                        "type": "integer"
                    }
                },
                "udp": {
                    "description": "a UDP STUN round trip completed",
                    "type": "boolean"
                },
                "upnP": {
                    "description": "UPnP is whether UPnP appears present on the LAN.\nEmpty means not checked.",
                    "type": "string"
                }
            }
        },
        "oauth2.Token": {
            "type": "object",
            "properties": {
                "access_token": {
                    "description": "AccessToken is the token that authorizes and authenticates\nthe requests.",
                    "type": "string"
                },
                "expires_in": {
                    "description": "ExpiresIn is the OAuth2 wire format \"expires_in\" field,\nwhich specifies how many seconds later the token expires,\nrelative to an unknown time base approximately around \"now\".\nIt is the application's responsibility to populate\n` + "`" + `Expiry` + "`" + ` from ` + "`" + `ExpiresIn` + "`" + ` when required.",
                    "type": "integer"
                },
                "expiry": {
                    "description": "Expiry is the optional expiration time of the access token.\n\nIf zero, [TokenSource] implementations will reuse the same\ntoken forever and RefreshToken or equivalent\nmechanisms for that TokenSource will not be used.",
                    "type": "string"
                },
                "refresh_token": {
                    "description": "RefreshToken is a token that's used by the application\n(as opposed to the user) to refresh the access token\nif it expires.",
                    "type": "string"
                },
                "token_type": {
                    "description": "TokenType is the type of token.\nThe Type method returns either this or \"Bearer\", the default.",
                    "type": "string"
                }
            }
        },
        "regexp.Regexp": {
            "type": "object"
        },
        "serpent.Annotations": {
            "type": "object",
            "additionalProperties": {
                "type": "string"
            }
        },
        "serpent.Group": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "parent": {
                    "$ref": "#/definitions/serpent.Group"
                },
                "yaml": {
                    "type": "string"
                }
            }
        },
        "serpent.HostPort": {
            "type": "object",
            "properties": {
                "host": {
                    "type": "string"
                },
                "port": {
                    "type": "string"
                }
            }
        },
        "serpent.Option": {
            "type": "object",
            "properties": {
                "annotations": {
                    "description": "Annotations enable extensions to serpent higher up in the stack. It's useful for\nhelp formatting and documentation generation.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/serpent.Annotations"
                        }
                    ]
                },
                "default": {
                    "description": "Default is parsed into Value if set.",
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "env": {
                    "description": "Env is the environment variable used to configure this option. If unset,\nenvironment configuring is disabled.",
                    "type": "string"
                },
                "flag": {
                    "description": "Flag is the long name of the flag used to configure this option. If unset,\nflag configuring is disabled.",
                    "type": "string"
                },
                "flag_shorthand": {
                    "description": "FlagShorthand is the one-character shorthand for the flag. If unset, no\nshorthand is used.",
                    "type": "string"
                },
                "group": {
                    "description": "Group is a group hierarchy that helps organize this option in help, configs\nand other documentation.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/serpent.Group"
                        }
                    ]
                },
                "hidden": {
                    "type": "boolean"
                },
                "name": {
                    "type": "string"
                },
                "required": {
                    "description": "Required means this value must be set by some means. It requires\n` + "`" + `ValueSource != ValueSourceNone` + "`" + `\nIf ` + "`" + `Default` + "`" + ` is set, then ` + "`" + `Required` + "`" + ` is ignored.",
                    "type": "boolean"
                },
                "use_instead": {
                    "description": "UseInstead is a list of options that should be used instead of this one.\nThe field is used to generate a deprecation warning.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/serpent.Option"
                    }
                },
                "value": {
                    "description": "Value includes the types listed in values.go."
                },
                "value_source": {
                    "$ref": "#/definitions/serpent.ValueSource"
                },
                "yaml": {
                    "description": "YAML is the YAML key used to configure this option. If unset, YAML\nconfiguring is disabled.",
                    "type": "string"
                }
            }
        },
        "serpent.Regexp": {
            "type": "object"
        },
        "serpent.Struct-array_codersdk_ExternalAuthConfig": {
            "type": "object",
            "properties": {
                "value": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.ExternalAuthConfig"
                    }
                }
            }
        },
        "serpent.Struct-array_codersdk_LinkConfig": {
            "type": "object",
            "properties": {
                "value": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.LinkConfig"
                    }
                }
            }
        },
        "serpent.URL": {
            "type": "object",
            "properties": {
                "forceQuery": {
                    "description": "append a query ('?') even if RawQuery is empty",
                    "type": "boolean"
                },
                "fragment": {
                    "description": "fragment for references, without '#'",
                    "type": "string"
                },
                "host": {
                    "description": "host or host:port (see Hostname and Port methods)",
                    "type": "string"
                },
                "omitHost": {
                    "description": "do not emit empty host (authority)",
                    "type": "boolean"
                },
                "opaque": {
                    "description": "encoded opaque data",
                    "type": "string"
                },
                "path": {
                    "description": "path (relative paths may omit leading slash)",
                    "type": "string"
                },
                "rawFragment": {
                    "description": "encoded fragment hint (see EscapedFragment method)",
                    "type": "string"
                },
                "rawPath": {
                    "description": "encoded path hint (see EscapedPath method)",
                    "type": "string"
                },
                "rawQuery": {
                    "description": "encoded query values, without '?'",
                    "type": "string"
                },
                "scheme": {
                    "type": "string"
                },
                "user": {
                    "description": "username and password information",
                    "allOf": [
                        {
                            "$ref": "#/definitions/url.Userinfo"
                        }
                    ]
                }
            }
        },
        "serpent.ValueSource": {
            "type": "string",
            "enum": [
                "",
                "flag",
                "env",
                "yaml",
                "default"
            ],
            "x-enum-varnames": [
                "ValueSourceNone",
                "ValueSourceFlag",
                "ValueSourceEnv",
                "ValueSourceYAML",
                "ValueSourceDefault"
            ]
        },
        "tailcfg.DERPHomeParams": {
            "type": "object",
            "properties": {
                "regionScore": {
                    "description": "RegionScore scales latencies of DERP regions by a given scaling\nfactor when determining which region to use as the home\n(\"preferred\") DERP. Scores in the range (0, 1) will cause this\nregion to be proportionally more preferred, and scores in the range\n(1, ∞) will penalize a region.\n\nIf a region is not present in this map, it is treated as having a\nscore of 1.0.\n\nScores should not be 0 or negative; such scores will be ignored.\n\nA nil map means no change from the previous value (if any); an empty\nnon-nil map can be sent to reset all scores back to 1.0.",
                    "type": "object",
                    "additionalProperties": {
                        "type": "number"
                    }
                }
            }
        },
        "tailcfg.DERPMap": {
            "type": "object",
            "properties": {
                "homeParams": {
                    "description": "HomeParams, if non-nil, is a change in home parameters.\n\nThe rest of the DEPRMap fields, if zero, means unchanged.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/tailcfg.DERPHomeParams"
                        }
                    ]
                },
                "omitDefaultRegions": {
                    "description": "OmitDefaultRegions specifies to not use Tailscale's DERP servers, and only use those\nspecified in this DERPMap. If there are none set outside of the defaults, this is a noop.\n\nThis field is only meaningful if the Regions map is non-nil (indicating a change).",
                    "type": "boolean"
                },
                "regions": {
                    "description": "Regions is the set of geographic regions running DERP node(s).\n\nIt's keyed by the DERPRegion.RegionID.\n\nThe numbers are not necessarily contiguous.",
                    "type": "object",
                    "additionalProperties": {
                        "$ref": "#/definitions/tailcfg.DERPRegion"
                    }
                }
            }
        },
        "tailcfg.DERPNode": {
            "type": "object",
            "properties": {
                "canPort80": {
                    "description": "CanPort80 specifies whether this DERP node is accessible over HTTP\non port 80 specifically. This is used for captive portal checks.",
                    "type": "boolean"
                },
                "certName": {
                    "description": "CertName optionally specifies the expected TLS cert common\nname. If empty, HostName is used. If CertName is non-empty,\nHostName is only used for the TCP dial (if IPv4/IPv6 are\nnot present) + TLS ClientHello.",
                    "type": "string"
                },
                "derpport": {
                    "description": "DERPPort optionally provides an alternate TLS port number\nfor the DERP HTTPS server.\n\nIf zero, 443 is used.",
                    "type": "integer"
                },
                "forceHTTP": {
                    "description": "ForceHTTP is used by unit tests to force HTTP.\nIt should not be set by users.",
                    "type": "boolean"
                },
                "hostName": {
                    "description": "HostName is the DERP node's hostname.\n\nIt is required but need not be unique; multiple nodes may\nhave the same HostName but vary in configuration otherwise.",
                    "type": "string"
                },
                "insecureForTests": {
                    "description": "InsecureForTests is used by unit tests to disable TLS verification.\nIt should not be set by users.",
                    "type": "boolean"
                },
                "ipv4": {
                    "description": "IPv4 optionally forces an IPv4 address to use, instead of using DNS.\nIf empty, A record(s) from DNS lookups of HostName are used.\nIf the string is not an IPv4 address, IPv4 is not used; the\nconventional string to disable IPv4 (and not use DNS) is\n\"none\".",
                    "type": "string"
                },
                "ipv6": {
                    "description": "IPv6 optionally forces an IPv6 address to use, instead of using DNS.\nIf empty, AAAA record(s) from DNS lookups of HostName are used.\nIf the string is not an IPv6 address, IPv6 is not used; the\nconventional string to disable IPv6 (and not use DNS) is\n\"none\".",
                    "type": "string"
                },
                "name": {
                    "description": "Name is a unique node name (across all regions).\nIt is not a host name.\nIt's typically of the form \"1b\", \"2a\", \"3b\", etc. (region\nID + suffix within that region)",
                    "type": "string"
                },
                "regionID": {
                    "description": "RegionID is the RegionID of the DERPRegion that this node\nis running in.",
                    "type": "integer"
                },
                "stunonly": {
                    "description": "STUNOnly marks a node as only a STUN server and not a DERP\nserver.",
                    "type": "boolean"
                },
                "stunport": {
                    "description": "Port optionally specifies a STUN port to use.\nZero means 3478.\nTo disable STUN on this node, use -1.",
                    "type": "integer"
                },
                "stuntestIP": {
                    "description": "STUNTestIP is used in tests to override the STUN server's IP.\nIf empty, it's assumed to be the same as the DERP server.",
                    "type": "string"
                }
            }
        },
        "tailcfg.DERPRegion": {
            "type": "object",
            "properties": {
                "avoid": {
                    "description": "Avoid is whether the client should avoid picking this as its home\nregion. The region should only be used if a peer is there.\nClients already using this region as their home should migrate\naway to a new region without Avoid set.",
                    "type": "boolean"
                },
                "embeddedRelay": {
                    "description": "EmbeddedRelay is true when the region is bundled with the Coder\ncontrol plane.",
                    "type": "boolean"
                },
                "nodes": {
                    "description": "Nodes are the DERP nodes running in this region, in\npriority order for the current client. Client TLS\nconnections should ideally only go to the first entry\n(falling back to the second if necessary). STUN packets\nshould go to the first 1 or 2.\n\nIf nodes within a region route packets amongst themselves,\nbut not to other regions. That said, each user/domain\nshould get a the same preferred node order, so if all nodes\nfor a user/network pick the first one (as they should, when\nthings are healthy), the inter-cluster routing is minimal\nto zero.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/tailcfg.DERPNode"
                    }
                },
                "regionCode": {
                    "description": "RegionCode is a short name for the region. It's usually a popular\ncity or airport code in the region: \"nyc\", \"sf\", \"sin\",\n\"fra\", etc.",
                    "type": "string"
                },
                "regionID": {
                    "description": "RegionID is a unique integer for a geographic region.\n\nIt corresponds to the legacy derpN.tailscale.com hostnames\nused by older clients. (Older clients will continue to resolve\nderpN.tailscale.com when contacting peers, rather than use\nthe server-provided DERPMap)\n\nRegionIDs must be non-zero, positive, and guaranteed to fit\nin a JavaScript number.\n\nRegionIDs in range 900-999 are reserved for end users to run their\nown DERP nodes.",
                    "type": "integer"
                },
                "regionName": {
                    "description": "RegionName is a long English name for the region: \"New York City\",\n\"San Francisco\", \"Singapore\", \"Frankfurt\", etc.",
                    "type": "string"
                }
            }
        },
        "url.Userinfo": {
            "type": "object"
        },
        "uuid.NullUUID": {
            "type": "object",
            "properties": {
                "uuid": {
                    "type": "string"
                },
                "valid": {
                    "description": "Valid is true if UUID is not NULL",
                    "type": "boolean"
                }
            }
        },
        "workspaceapps.AccessMethod": {
            "type": "string",
            "enum": [
                "path",
                "subdomain",
                "terminal"
            ],
            "x-enum-varnames": [
                "AccessMethodPath",
                "AccessMethodSubdomain",
                "AccessMethodTerminal"
            ]
        },
        "workspaceapps.IssueTokenRequest": {
            "type": "object",
            "properties": {
                "app_hostname": {
                    "description": "AppHostname is the optional hostname for subdomain apps on the external\nproxy. It must start with an asterisk.",
                    "type": "string"
                },
                "app_path": {
                    "description": "AppPath is the path of the user underneath the app base path.",
                    "type": "string"
                },
                "app_query": {
                    "description": "AppQuery is the query parameters the user provided in the app request.",
                    "type": "string"
                },
                "app_request": {
                    "$ref": "#/definitions/workspaceapps.Request"
                },
                "path_app_base_url": {
                    "description": "PathAppBaseURL is required.",
                    "type": "string"
                },
                "session_token": {
                    "description": "SessionToken is the session token provided by the user.",
                    "type": "string"
                }
            }
        },
        "workspaceapps.Request": {
            "type": "object",
            "properties": {
                "access_method": {
                    "$ref": "#/definitions/workspaceapps.AccessMethod"
                },
                "agent_name_or_id": {
                    "description": "AgentNameOrID is not required if the workspace has only one agent.",
                    "type": "string"
                },
                "app_prefix": {
                    "description": "Prefix is the prefix of the subdomain app URL. Prefix should have a\ntrailing \"---\" if set.",
                    "type": "string"
                },
                "app_slug_or_port": {
                    "type": "string"
                },
                "base_path": {
                    "description": "BasePath of the app. For path apps, this is the path prefix in the router\nfor this particular app. For subdomain apps, this should be \"/\". This is\nused for setting the cookie path.",
                    "type": "string"
                },
                "username_or_id": {
                    "description": "For the following fields, if the AccessMethod is AccessMethodTerminal,\nthen only AgentNameOrID may be set and it must be a UUID. The other\nfields must be left blank.",
                    "type": "string"
                },
                "workspace_name_or_id": {
                    "type": "string"
                }
            }
        },
        "workspaceapps.StatsReport": {
            "type": "object",
            "properties": {
                "access_method": {
                    "$ref": "#/definitions/workspaceapps.AccessMethod"
                },
                "agent_id": {
                    "type": "string"
                },
                "requests": {
                    "type": "integer"
                },
                "session_ended_at": {
                    "description": "Updated periodically while app is in use active and when the last connection is closed.",
                    "type": "string"
                },
                "session_id": {
                    "type": "string"
                },
                "session_started_at": {
                    "type": "string"
                },
                "slug_or_port": {
                    "type": "string"
                },
                "user_id": {
                    "type": "string"
                },
                "workspace_id": {
                    "type": "string"
                }
            }
        },
        "workspacesdk.AgentConnectionInfo": {
            "type": "object",
            "properties": {
                "derp_force_websockets": {
                    "type": "boolean"
                },
                "derp_map": {
                    "$ref": "#/definitions/tailcfg.DERPMap"
                },
                "disable_direct_connections": {
                    "type": "boolean"
                },
                "hostname_suffix": {
                    "type": "string"
                }
            }
        },
        "wsproxysdk.CryptoKeysResponse": {
            "type": "object",
            "properties": {
                "crypto_keys": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.CryptoKey"
                    }
                }
            }
        },
        "wsproxysdk.DeregisterWorkspaceProxyRequest": {
            "type": "object",
            "properties": {
                "replica_id": {
                    "description": "ReplicaID is a unique identifier for the replica of the proxy that is\nderegistering. It should be generated by the client on startup and\nshould've already been passed to the register endpoint.",
                    "type": "string"
                }
            }
        },
        "wsproxysdk.IssueSignedAppTokenResponse": {
            "type": "object",
            "properties": {
                "signed_token_str": {
                    "description": "SignedTokenStr should be set as a cookie on the response.",
                    "type": "string"
                }
            }
        },
        "wsproxysdk.RegisterWorkspaceProxyRequest": {
            "type": "object",
            "properties": {
                "access_url": {
                    "description": "AccessURL that hits the workspace proxy api.",
                    "type": "string"
                },
                "derp_enabled": {
                    "description": "DerpEnabled indicates whether the proxy should be included in the DERP\nmap or not.",
                    "type": "boolean"
                },
                "derp_only": {
                    "description": "DerpOnly indicates whether the proxy should only be included in the DERP\nmap and should not be used for serving apps.",
                    "type": "boolean"
                },
                "hostname": {
                    "description": "ReplicaHostname is the OS hostname of the machine that the proxy is running\non.  This is only used for tracking purposes in the replicas table.",
                    "type": "string"
                },
                "replica_error": {
                    "description": "ReplicaError is the error that the replica encountered when trying to\ndial it's peers. This is stored in the replicas table for debugging\npurposes but does not affect the proxy's ability to register.\n\nThis value is only stored on subsequent requests to the register\nendpoint, not the first request.",
                    "type": "string"
                },
                "replica_id": {
                    "description": "ReplicaID is a unique identifier for the replica of the proxy that is\nregistering. It should be generated by the client on startup and\npersisted (in memory only) until the process is restarted.",
                    "type": "string"
                },
                "replica_relay_address": {
                    "description": "ReplicaRelayAddress is the DERP address of the replica that other\nreplicas may use to connect internally for DERP meshing.",
                    "type": "string"
                },
                "version": {
                    "description": "Version is the Coder version of the proxy.",
                    "type": "string"
                },
                "wildcard_hostname": {
                    "description": "WildcardHostname that the workspace proxy api is serving for subdomain apps.",
                    "type": "string"
                }
            }
        },
        "wsproxysdk.RegisterWorkspaceProxyResponse": {
            "type": "object",
            "properties": {
                "derp_force_websockets": {
                    "type": "boolean"
                },
                "derp_map": {
                    "$ref": "#/definitions/tailcfg.DERPMap"
                },
                "derp_mesh_key": {
                    "type": "string"
                },
                "derp_region_id": {
                    "type": "integer"
                },
                "sibling_replicas": {
                    "description": "SiblingReplicas is a list of all other replicas of the proxy that have\nnot timed out.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/codersdk.Replica"
                    }
                }
            }
        },
        "wsproxysdk.ReportAppStatsRequest": {
            "type": "object",
            "properties": {
                "stats": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/workspaceapps.StatsReport"
                    }
                }
            }
        }
    },
    "securityDefinitions": {
        "Authorization": {
            "type": "apiKey",
            "name": "Authorizaiton",
            "in": "header"
        },
        "CoderSessionToken": {
            "type": "apiKey",
            "name": "Coder-Session-Token",
            "in": "header"
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "2.0",
	Host:             "",
	BasePath:         "/api/v2",
	Schemes:          []string{},
	Title:            "Coder API",
	Description:      "Coderd is the service created by running coder server. It is a thin API that connects workspaces, provisioners and users. coderd stores its state in Postgres and is the only service that communicates with Postgres.",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
	LeftDelim:        "{{",
	RightDelim:       "}}",
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
