/*

Created via (upgrade from v0.7.12):

$ coder-0.8.15 server \
  --address 0.0.0.0:3232 \
  --access-url 'http://192.168.1.146:3232' \
  --postgres-url 'postgres://coder@localhost/coder?sslmode=disable&password=password' \
  --oauth2-github-allow-signups \
  --oauth2-github-allowed-orgs some-org \
  --oauth2-github-client-id some-id \
  --oauth2-github-client-secret some-secret

$ sudo -u postgres pg_dump coder --data-only --inserts --on-conflict-do-nothing >dump_v0.8.15.sql

*/

--
-- PostgreSQL database dump
--

-- Dumped from database version 13.7 (Debian 13.7-0+deb11u1)
-- Dumped by pg_dump version 13.7 (Debian 13.7-0+deb11u1)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
-- Setting search_path breaks fixtures lacking schema (public.) in queries.
-- SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Data for Name: agent_stats; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.agent_stats VALUES ('aeacc0c6-4629-4b1a-918c-d122751e42cd', '2022-11-02 14:01:48.147355+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '8f3204e0-a94d-4bc4-b229-747a867468cd', 'b90547be-8870-4d68-8184-e8b2242b7c01', '4cc1f466-f326-477e-8762-9d0c6781fc56', '{"rx_bytes": 179237, "tx_bytes": 7126107, "num_comms": 13}') ON CONFLICT DO NOTHING;
INSERT INTO public.agent_stats VALUES ('72339dc1-baca-4fea-be0b-64498dccd407', '2022-11-02 14:01:53.007428+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'c3decf02-210e-45ab-a122-9be56db534e0', '759f94c0-2e14-4a48-8d9e-6507a38e156a', '34dcb3ce-ad41-4f52-8cba-3b0197ac7c24', '{"rx_bytes": 1556, "tx_bytes": 1716, "num_comms": 1}') ON CONFLICT DO NOTHING;
INSERT INTO public.agent_stats VALUES ('50bba980-128e-4bdd-b6df-00d632550dea', '2022-11-02 14:02:11.220532+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '3477a0b6-74af-4630-ab51-5e1ff1cf2bee', '9cf0c44c-f931-43fc-bf4e-6d3624eb3037', '4cc1f466-f326-477e-8762-9d0c6781fc56', '{"rx_bytes": 1592, "tx_bytes": 1820, "num_comms": 1}') ON CONFLICT DO NOTHING;


--
-- Data for Name: users; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.users VALUES ('a4da4f5f-222f-45fe-9a00-66128a782bc2', 'suspended@coder.com', 'suspended', '\x2470626b6466322d73686132353624363535333524444751337353533369694742622b5a7961517572534124714872656b584375704231316453516a6937646e356b774958562f664f71456a4131575934596a66616f59416b6a4a79585561547734547a6b4a56626761644c5641536b4875314c3074394a4f6338537939616f6f51', '2022-11-02 13:29:02.658314+02', '2022-11-02 13:29:13.398516+02', 'suspended', '{}', 'password', NULL, false) ON CONFLICT DO NOTHING;
INSERT INTO public.users VALUES ('b495d728-647d-471b-92c4-9de380c61f63', 'auditor@coder.com', 'auditor', '\x2470626b6466322d736861323536243635353335245a5344596d6d546a6938674677456a49314b4a4f4251242f70477a5978343450523657516176722f4e55753573734277524a782f4d79744369386349774656726b5254397861554564314374543759565467424d71562b492b31574d55473373346d7179742b414e6a6a2f7967', '2022-11-02 13:34:29.765423+02', '2022-11-02 13:34:29.765424+02', 'active', '{auditor}', 'password', NULL, false) ON CONFLICT DO NOTHING;
INSERT INTO public.users VALUES ('30095c71-380b-457a-8995-97b8ee6e5307', 'admin@coder.com', 'admin', '\x2470626b6466322d736861323536243635353335247671694c624664385450734355445664376f723653512479686362786c436d485855327965356e616b4a73416e4868316642576447544b48732f2b6a426b4a716377466e2b362f77376f61354632444e35596458584131425639442f43714f7a7541485a652f6f4a4d674d3451', '2022-11-02 13:02:55.13827+02', '2022-11-02 13:02:55.13827+02', 'active', '{owner}', 'password', NULL, false) ON CONFLICT DO NOTHING;
INSERT INTO public.users VALUES ('0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'oauthuser1@coder.com', 'oauthuser1', '\x', '2022-11-02 13:05:21.445455+02', '2022-11-02 13:55:34.032633+02', 'active', '{template-admin}', 'github', 'https://avatars.githubusercontent.com/u/0?v=4', false) ON CONFLICT DO NOTHING;
INSERT INTO public.users VALUES ('f88485bd-4304-43e6-8a12-c0a5b56e683f', 'member@coder.com', 'member', '\x2470626b6466322d7368613235362436353533352430454e644162706a4a4e3772462b6841494463554d672434794a6e3970446b387878546569753370456c6c43343344624d587758337a54764b796e71514d3463704a47565a3661325879544e56695849777635524c59567265527064767131326730546e356567347837453341', '2022-11-02 13:56:28.716538+02', '2022-11-02 13:56:28.716539+02', 'active', '{}', 'password', NULL, false) ON CONFLICT DO NOTHING;
INSERT INTO public.users VALUES ('3ba69e78-27bd-4ccc-a226-317834902a49', 'deleted@coder.com', 'deleted', '\x2470626b6466322d73686132353624363535333524684555364a6b6e7a454b6645767a5a4f6e5132596c77245a5a723652492b386476613945555a3057572b4674484d6f7676706e2b4b7573676f4441316b4f7a432f534662562b476f53426c677242417858686836547a527a37313066745a5a626a526e4e4a3353416933445641', '2022-11-02 14:01:37.922082+02', '2022-11-02 14:01:37.922083+02', 'active', '{}', 'password', NULL, true) ON CONFLICT DO NOTHING;


--
-- Data for Name: api_keys; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.api_keys VALUES ('WEG2T4MNno', '\x50ae3bffeac2d2a30e3a7534ca67400c4190c513f2044b5721954b72a1b66ca0', '30095c71-380b-457a-8995-97b8ee6e5307', '2022-11-02 13:03:25.653862+02', '2022-11-03 13:02:55.340963+02', '2022-11-02 13:02:55.340964+02', '2022-11-02 13:02:55.340964+02', 'password', 86400, '0.0.0.0') ON CONFLICT DO NOTHING;
INSERT INTO public.api_keys VALUES ('peuLZhMXt4', '\x665200a4744e4f318551a7ca6944e070774e8903a680e8a0a592e0f2c328efb3', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '2022-11-02 13:05:21.681575+02', '2022-11-03 13:05:21.449566+02', '2022-11-02 13:05:21.449567+02', '2022-11-02 13:05:21.449567+02', 'github', 86400, '0.0.0.0') ON CONFLICT DO NOTHING;
INSERT INTO public.api_keys VALUES ('MqCoxYlBys', '\xea541b9f3a1e12dc3c2949575f3e7df06469621093d32dee14abd50d24d08afd', '30095c71-380b-457a-8995-97b8ee6e5307', '2022-11-02 13:34:04.037858+02', '2022-11-03 13:34:04.025325+02', '2022-11-02 13:34:04.025328+02', '2022-11-02 13:34:04.025328+02', 'password', 86400, '192.168.1.206') ON CONFLICT DO NOTHING;
INSERT INTO public.api_keys VALUES ('GKPlfbR9vb', '\x81261c5c703cf889cf3fa1fcc545eaf96ba140f1d7db1eccfb68e5373024511e', '30095c71-380b-457a-8995-97b8ee6e5307', '2022-11-02 13:57:12.023263+02', '2022-11-09 13:57:08.733465+02', '2022-11-02 13:57:08.733485+02', '2022-11-02 13:57:08.733485+02', 'password', 604800, '192.168.1.146') ON CONFLICT DO NOTHING;
INSERT INTO public.api_keys VALUES ('JlKh7TLyVb', '\x0b9a3b636176b68970bcb2c7558066dfd94b93595fcc2384e2373bc1c5fe903b', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '2022-11-02 14:00:35.254877+02', '2022-11-03 14:00:35.077147+02', '2022-11-02 14:00:35.077153+02', '2022-11-02 14:00:35.077153+02', 'github', 86400, '192.168.1.206') ON CONFLICT DO NOTHING;
INSERT INTO public.api_keys VALUES ('Vt87rMMD7K', '\xf6efab22deb1b0e1dd114925af88ba2cc13396b17b50a958859d961666bd9ea3', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '2022-11-02 14:02:21.04372+02', '2022-11-09 14:02:16.582412+02', '2022-11-02 14:02:16.582427+02', '2022-11-02 14:02:16.582428+02', 'password', 604800, '192.168.1.146') ON CONFLICT DO NOTHING;


--
-- Data for Name: audit_logs; Type: TABLE DATA; Schema: public; Owner: coder
--



--
-- Data for Name: files; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.files VALUES ('5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', '2022-11-02 13:03:31.667863+02', '30095c71-380b-457a-8995-97b8ee6e5307', 'application/x-tar', '\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') ON CONFLICT DO NOTHING;
INSERT INTO public.files VALUES ('f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', '2022-11-02 13:30:29.721418+02', '30095c71-380b-457a-8995-97b8ee6e5307', 'application/x-tar', '\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') ON CONFLICT DO NOTHING;
INSERT INTO public.files VALUES ('97884d52183af0ad9471cf624c78056541aff43cb5b16f033299cd90c17d185a', '2022-11-02 13:36:23.407378+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'application/x-tar', '\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') ON CONFLICT DO NOTHING;
INSERT INTO public.files VALUES ('bdc01bd9124058306fb4aadbf77006707550e9e37658c70998235f4191dada4d', '2022-11-02 13:57:17.36933+02', '30095c71-380b-457a-8995-97b8ee6e5307', 'application/x-tar', '\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') ON CONFLICT DO NOTHING;


--
-- Data for Name: gitsshkeys; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.gitsshkeys VALUES ('a4da4f5f-222f-45fe-9a00-66128a782bc2', '2022-11-02 13:29:02.770706+02', '2022-11-02 13:29:02.770707+02', '-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAMwAAAAtz
c2gtZWQyNTUxOQAAACDQ4BXUui9PEdYSWWgOnay4oAeqdtLlzFd3nCwxqCgNpwAA
AIhP7dqDT+3agwAAAAtzc2gtZWQyNTUxOQAAACDQ4BXUui9PEdYSWWgOnay4oAeq
dtLlzFd3nCwxqCgNpwAAAEC0JjwjV+63Ro41speNSi/i8pyUSwheOUrQNLLJmMtR
89DgFdS6L08R1hJZaA6drLigB6p20uXMV3ecLDGoKA2nAAAAAAECAwQF
-----END OPENSSH PRIVATE KEY-----
', 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAINDgFdS6L08R1hJZaA6drLigB6p20uXMV3ecLDGoKA2n
') ON CONFLICT DO NOTHING;
INSERT INTO public.gitsshkeys VALUES ('b495d728-647d-471b-92c4-9de380c61f63', '2022-11-02 13:34:29.86574+02', '2022-11-02 13:34:29.86574+02', '-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAMwAAAAtz
c2gtZWQyNTUxOQAAACCHavMgM3qgGsb7R3XnA57Z+ukmGs81A+L4jPq1fBWGLwAA
AIhzErqZcxK6mQAAAAtzc2gtZWQyNTUxOQAAACCHavMgM3qgGsb7R3XnA57Z+ukm
Gs81A+L4jPq1fBWGLwAAAEAqfgIzbNYc/BcogQuIkkpbi4jj3OrP4J2MZy30sGeJ
+4dq8yAzeqAaxvtHdecDntn66SYazzUD4viM+rV8FYYvAAAAAAECAwQF
-----END OPENSSH PRIVATE KEY-----
', 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIIdq8yAzeqAaxvtHdecDntn66SYazzUD4viM+rV8FYYv
') ON CONFLICT DO NOTHING;
INSERT INTO public.gitsshkeys VALUES ('30095c71-380b-457a-8995-97b8ee6e5307', '2022-11-02 13:02:55.237442+02', '2022-11-02 13:34:54.162811+02', '-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAMwAAAAtz
c2gtZWQyNTUxOQAAACDVplyEtV3xLj3DVF2t2o4CL2IU9h4+cFQGBMgBQRK4QwAA
AIiqaicCqmonAgAAAAtzc2gtZWQyNTUxOQAAACDVplyEtV3xLj3DVF2t2o4CL2IU
9h4+cFQGBMgBQRK4QwAAAEA8U0fuLkQl2Oj/0cxPDnNCKt9VaBwCaE3GPmiuIl6e
09WmXIS1XfEuPcNUXa3ajgIvYhT2Hj5wVAYEyAFBErhDAAAAAAECAwQF
-----END OPENSSH PRIVATE KEY-----
', 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAINWmXIS1XfEuPcNUXa3ajgIvYhT2Hj5wVAYEyAFBErhD
') ON CONFLICT DO NOTHING;
INSERT INTO public.gitsshkeys VALUES ('0ed9befc-4911-4ccf-a8e2-559bf72daa94', '2022-11-02 13:05:21.446353+02', '2022-11-02 13:55:37.288423+02', '-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAMwAAAAtz
c2gtZWQyNTUxOQAAACB9f/xgb6zn2jOW2sO8Hxc+pkgsiywJ5V7txjZWOSnvWwAA
AIjiF2kN4hdpDQAAAAtzc2gtZWQyNTUxOQAAACB9f/xgb6zn2jOW2sO8Hxc+pkgs
iywJ5V7txjZWOSnvWwAAAEDwit69sEGCzkc2LNB8GhKdHWvwtUGcwXvTXbeVC8/s
IH1//GBvrOfaM5baw7wfFz6mSCyLLAnlXu3GNlY5Ke9bAAAAAAECAwQF
-----END OPENSSH PRIVATE KEY-----
', 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIH1//GBvrOfaM5baw7wfFz6mSCyLLAnlXu3GNlY5Ke9b
') ON CONFLICT DO NOTHING;
INSERT INTO public.gitsshkeys VALUES ('f88485bd-4304-43e6-8a12-c0a5b56e683f', '2022-11-02 13:56:28.82679+02', '2022-11-02 13:56:28.826792+02', '-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAMwAAAAtz
c2gtZWQyNTUxOQAAACBLRWCbBFd/8tn4ESZz6YuGaKuOyCoQMkrS5dyQaQp1EwAA
AIiY7qcWmO6nFgAAAAtzc2gtZWQyNTUxOQAAACBLRWCbBFd/8tn4ESZz6YuGaKuO
yCoQMkrS5dyQaQp1EwAAAEDADxWY3uHkUXMZ3SCYMnauXin0XxYQVA6zYZr0yzqH
RktFYJsEV3/y2fgRJnPpi4Zoq47IKhAyStLl3JBpCnUTAAAAAAECAwQF
-----END OPENSSH PRIVATE KEY-----
', 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIEtFYJsEV3/y2fgRJnPpi4Zoq47IKhAyStLl3JBpCnUT
') ON CONFLICT DO NOTHING;
INSERT INTO public.gitsshkeys VALUES ('3ba69e78-27bd-4ccc-a226-317834902a49', '2022-11-02 14:01:38.027027+02', '2022-11-02 14:01:38.027028+02', '-----BEGIN OPENSSH PRIVATE KEY-----
b3BlbnNzaC1rZXktdjEAAAAABG5vbmUAAAAEbm9uZQAAAAAAAAABAAAAMwAAAAtz
c2gtZWQyNTUxOQAAACC0o/HGrmqDkiz/C7S58MtUJDnIYTfKutezwRmGlvjIvgAA
AIi9Xa2yvV2tsgAAAAtzc2gtZWQyNTUxOQAAACC0o/HGrmqDkiz/C7S58MtUJDnI
YTfKutezwRmGlvjIvgAAAEAwNVgpBQXXkzvCfzNFTBAq1bAxqdfOoqwwQ3WOJtNc
0LSj8cauaoOSLP8LtLnwy1QkOchhN8q617PBGYaW+Mi+AAAAAAECAwQF
-----END OPENSSH PRIVATE KEY-----
', 'ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAILSj8cauaoOSLP8LtLnwy1QkOchhN8q617PBGYaW+Mi+
') ON CONFLICT DO NOTHING;


--
-- Data for Name: licenses; Type: TABLE DATA; Schema: public; Owner: coder
--



--
-- Data for Name: organizations; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.organizations VALUES ('bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', 'admin', '', '2022-11-02 13:02:55.136653+02', '2022-11-02 13:02:55.136653+02') ON CONFLICT DO NOTHING;


--
-- Data for Name: organization_members; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.organization_members VALUES ('30095c71-380b-457a-8995-97b8ee6e5307', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:02:55.238286+02', '2022-11-02 13:02:55.238286+02', '{organization-admin:bb640d07-ca8a-4869-b6bc-ae61ebb2fda1}') ON CONFLICT DO NOTHING;
INSERT INTO public.organization_members VALUES ('0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:05:21.447595+02', '2022-11-02 13:05:21.447595+02', '{}') ON CONFLICT DO NOTHING;
INSERT INTO public.organization_members VALUES ('a4da4f5f-222f-45fe-9a00-66128a782bc2', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:29:02.77164+02', '2022-11-02 13:29:02.77164+02', '{}') ON CONFLICT DO NOTHING;
INSERT INTO public.organization_members VALUES ('b495d728-647d-471b-92c4-9de380c61f63', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:34:29.866681+02', '2022-11-02 13:34:29.866681+02', '{}') ON CONFLICT DO NOTHING;
INSERT INTO public.organization_members VALUES ('f88485bd-4304-43e6-8a12-c0a5b56e683f', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:56:28.828041+02', '2022-11-02 13:56:28.828043+02', '{}') ON CONFLICT DO NOTHING;
INSERT INTO public.organization_members VALUES ('3ba69e78-27bd-4ccc-a226-317834902a49', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 14:01:38.02877+02', '2022-11-02 14:01:38.028772+02', '{}') ON CONFLICT DO NOTHING;


--
-- Data for Name: provisioner_jobs; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.provisioner_jobs VALUES ('8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:32.811313+02', '2022-11-02 13:31:37.65385+02', '2022-11-02 13:31:33.153757+02', NULL, '2022-11-02 13:31:37.65385+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'template_version_import', '{}', '0f817029-e02b-4b33-9c3f-4bfb76b16c79') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('ef8d15e3-0cab-4e83-b576-9fd27a680217', '2022-11-02 13:30:29.729411+02', '2022-11-02 13:30:30.512977+02', '2022-11-02 13:30:30.154036+02', NULL, '2022-11-02 13:30:30.512977+02', 'missing parameter: docker_host', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'template_version_import', '{}', '52ded48a-2824-469e-bde1-a1d1af3d0f6c') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:45.572924+02', '2022-11-02 13:32:49.48147+02', '2022-11-02 13:32:45.653254+02', NULL, '2022-11-02 13:32:49.48147+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'workspace_build', '{"dry_run": false, "workspace_build_id": "e028bb1f-0ef0-426d-a5f5-0d3c778da061"}', '0f817029-e02b-4b33-9c3f-4bfb76b16c79') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:03.554876+02', '2022-11-02 13:06:08.668806+02', '2022-11-02 13:06:03.928629+02', NULL, '2022-11-02 13:06:08.659881+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'workspace_build', '{"dry_run": false, "workspace_build_id": "a7477610-c69b-46d6-97fb-d6a3425e1ab4"}', '22c3662c-60eb-408b-99e1-85b447c2b7e5') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:51.763412+02', '2022-11-02 13:09:54.75528+02', '2022-11-02 13:09:51.92866+02', NULL, '2022-11-02 13:09:54.750397+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'workspace_build', '{"dry_run": false, "workspace_build_id": "b56215f2-3b5e-406a-ac54-41c284dc9af3"}', 'e70c7dd0-bba3-4ab8-bfe1-f75e42c67e37') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('d6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.223922+02', '2022-11-02 13:04:58.770357+02', '2022-11-02 13:04:55.428757+02', NULL, '2022-11-02 13:04:58.762854+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'workspace_build', '{"dry_run": false, "workspace_build_id": "c1d2c9d5-6f30-4cd0-9ac5-6bf1c6039988"}', 'e70c7dd0-bba3-4ab8-bfe1-f75e42c67e37') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.135318+02', '2022-11-02 13:08:10.808446+02', '2022-11-02 13:08:07.428275+02', NULL, '2022-11-02 13:08:10.801894+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'workspace_build', '{"dry_run": false, "workspace_build_id": "cd6fe03b-d6cf-4d5d-a448-cef52c3ddea2"}', '22c3662c-60eb-408b-99e1-85b447c2b7e5') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.072314+02', '2022-11-02 13:04:51.51136+02', '2022-11-02 13:04:48.428806+02', NULL, '2022-11-02 13:04:51.504973+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'workspace_build', '{"dry_run": false, "workspace_build_id": "ea36844d-8eb6-41a2-a237-e9a8ae3f99ea"}', '22c3662c-60eb-408b-99e1-85b447c2b7e5') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:31.675595+02', '2022-11-02 13:03:45.057747+02', '2022-11-02 13:03:31.928784+02', NULL, '2022-11-02 13:03:45.055613+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'template_version_import', '{}', '22c3662c-60eb-408b-99e1-85b447c2b7e5') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.044082+02', '2022-11-02 13:04:22.830929+02', '2022-11-02 13:04:19.428129+02', NULL, '2022-11-02 13:04:22.821799+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'workspace_build', '{"dry_run": false, "workspace_build_id": "a8c0b8c5-c9a8-4f33-93a4-8142e6858244"}', 'e70c7dd0-bba3-4ab8-bfe1-f75e42c67e37') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:11.3012+02', '2022-11-02 13:04:14.077613+02', '2022-11-02 13:04:11.428743+02', NULL, '2022-11-02 13:04:14.075961+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'template_version_dry_run', '{"workspace_name": "my-workspace", "parameter_values": [], "template_version_id": "920baba5-4c64-4686-8b7d-d1bef5683eae"}', 'e70c7dd0-bba3-4ab8-bfe1-f75e42c67e37') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.181124+02', '2022-11-02 13:05:43.884672+02', '2022-11-02 13:05:40.428424+02', NULL, '2022-11-02 13:05:43.877519+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'workspace_build', '{"dry_run": false, "workspace_build_id": "c7c0a371-db1e-4f10-ab34-6779f573554c"}', 'e70c7dd0-bba3-4ab8-bfe1-f75e42c67e37') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('1fca6797-88f0-4772-9873-b2a6e6a0bf16', '2022-11-02 13:30:44.58249+02', '2022-11-02 13:30:45.002094+02', '2022-11-02 13:30:44.653521+02', NULL, '2022-11-02 13:30:45.002094+02', 'missing parameter: docker_host', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'template_version_import', '{}', '0f817029-e02b-4b33-9c3f-4bfb76b16c79') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:52.489029+02', '2022-11-02 13:07:57.535327+02', '2022-11-02 13:07:52.928569+02', NULL, '2022-11-02 13:07:57.53319+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'template_version_import', '{}', 'e70c7dd0-bba3-4ab8-bfe1-f75e42c67e37') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('d842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.103996+02', '2022-11-02 13:10:45.613609+02', '2022-11-02 13:10:42.428688+02', NULL, '2022-11-02 13:10:45.606436+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', '5cedf49ccf841e2d6a7f84e18c86f38aad8b50495c032d19226118b91addf196', 'workspace_build', '{"dry_run": false, "workspace_build_id": "2bfa1945-e81f-44e4-8f41-394200f6cb30"}', 'e70c7dd0-bba3-4ab8-bfe1-f75e42c67e37') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:26.619423+02', '2022-11-02 13:39:29.58499+02', '2022-11-02 13:39:26.652709+02', NULL, '2022-11-02 13:39:29.58499+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'workspace_build', '{"dry_run": false, "workspace_build_id": "c41de343-458c-4e9e-aa5e-7e73b768d9f8"}', '0f817029-e02b-4b33-9c3f-4bfb76b16c79') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:23.295801+02', '2022-11-02 13:39:25.71102+02', '2022-11-02 13:39:23.654299+02', NULL, '2022-11-02 13:39:25.71102+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'template_version_dry_run', '{"workspace_name": "deleted", "parameter_values": [], "template_version_id": "e5cccf07-4953-48be-85ac-ed35328f1787"}', '52ded48a-2824-469e-bde1-a1d1af3d0f6c') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:04.989908+02', '2022-11-02 13:37:07.224671+02', '2022-11-02 13:37:05.154275+02', NULL, '2022-11-02 13:37:07.224672+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '97884d52183af0ad9471cf624c78056541aff43cb5b16f033299cd90c17d185a', 'template_version_dry_run', '{"workspace_name": "test2", "parameter_values": [{"id": "00000000-0000-0000-0000-000000000000", "name": "docker_image", "scope": "workspace", "scope_id": "00000000-0000-0000-0000-000000000000", "created_at": "0001-01-01T00:00:00Z", "updated_at": "0001-01-01T00:00:00Z", "source_value": "base", "source_scheme": "data", "destination_scheme": "provisioner_variable"}], "template_version_id": "7bd0d105-b085-4a4d-8d04-6778b8f3cb94"}', '52ded48a-2824-469e-bde1-a1d1af3d0f6c') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:08.219391+02', '2022-11-02 13:38:55.829378+02', '2022-11-02 13:37:08.654082+02', NULL, '2022-11-02 13:38:55.829379+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '97884d52183af0ad9471cf624c78056541aff43cb5b16f033299cd90c17d185a', 'workspace_build', '{"dry_run": false, "workspace_build_id": "a6726cfe-778b-4c7b-9667-88bc05483978"}', '52ded48a-2824-469e-bde1-a1d1af3d0f6c') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('391d562a-af1a-4f4c-81d3-244f3006d9c7', '2022-11-02 13:36:23.414478+02', '2022-11-02 13:36:24.024553+02', '2022-11-02 13:36:23.654013+02', NULL, '2022-11-02 13:36:24.024553+02', 'missing parameter: step1_docker_host_warning', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '97884d52183af0ad9471cf624c78056541aff43cb5b16f033299cd90c17d185a', 'template_version_import', '{}', '52ded48a-2824-469e-bde1-a1d1af3d0f6c') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:34.844165+02', '2022-11-02 13:30:41.300663+02', '2022-11-02 13:30:35.153107+02', NULL, '2022-11-02 13:30:41.300662+02', 'template import provision for start: recv import provision: plan terraform: terraform plan: exit status 1', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'template_version_import', '{}', '0f817029-e02b-4b33-9c3f-4bfb76b16c79') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:26.689872+02', '2022-11-02 13:36:31.715332+02', '2022-11-02 13:36:27.153737+02', NULL, '2022-11-02 13:36:31.715332+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '97884d52183af0ad9471cf624c78056541aff43cb5b16f033299cd90c17d185a', 'template_version_import', '{}', '0f817029-e02b-4b33-9c3f-4bfb76b16c79') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.066324+02', '2022-11-02 13:39:49.92592+02', '2022-11-02 13:39:45.152745+02', NULL, '2022-11-02 13:39:49.92592+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'workspace_build', '{"dry_run": false, "workspace_build_id": "43854171-c50b-4d6c-80c7-5c38192a4495"}', '0f817029-e02b-4b33-9c3f-4bfb76b16c79') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:22.772066+02', '2022-11-02 13:40:27.32197+02', '2022-11-02 13:40:23.154201+02', NULL, '2022-11-02 13:40:27.32197+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'workspace_build', '{"dry_run": false, "workspace_build_id": "eb9ab888-6ab7-4ba3-bec7-cdd710db592a"}', '52ded48a-2824-469e-bde1-a1d1af3d0f6c') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:28.944212+02', '2022-11-02 13:40:32.182527+02', '2022-11-02 13:40:29.153294+02', NULL, '2022-11-02 13:40:32.182527+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '97884d52183af0ad9471cf624c78056541aff43cb5b16f033299cd90c17d185a', 'workspace_build', '{"dry_run": false, "workspace_build_id": "5eb675a2-3743-451b-9d8f-e91b532795f8"}', '0f817029-e02b-4b33-9c3f-4bfb76b16c79') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:51:59.252199+02', '2022-11-02 13:52:01.932587+02', '2022-11-02 13:51:59.705974+02', NULL, '2022-11-02 13:52:01.932588+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'template_version_dry_run', '{"workspace_name": "test3", "parameter_values": [], "template_version_id": "e5cccf07-4953-48be-85ac-ed35328f1787"}', '057c4228-c969-44e6-8845-8eff6fefa770') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:43.533587+02', '2022-11-02 13:51:46.98257+02', '2022-11-02 13:51:43.706596+02', NULL, '2022-11-02 13:51:46.982571+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', '97884d52183af0ad9471cf624c78056541aff43cb5b16f033299cd90c17d185a', 'workspace_build', '{"dry_run": false, "workspace_build_id": "231a1fa2-609d-4e02-9887-e211e2f68924"}', 'aa9bfda7-4d26-41dc-8bd9-23ba4a0cad17') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:01.952341+02', '2022-11-02 13:52:05.384761+02', '2022-11-02 13:52:02.206404+02', NULL, '2022-11-02 13:52:05.384761+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'workspace_build', '{"dry_run": false, "workspace_build_id": "5f61d6d1-cad4-4767-8bb6-b509d53a7459"}', 'aa9bfda7-4d26-41dc-8bd9-23ba4a0cad17') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:37.869975+02', '2022-11-02 14:02:41.625015+02', '2022-11-02 14:02:38.206138+02', NULL, '2022-11-02 14:02:41.625016+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'workspace_build', '{"dry_run": false, "workspace_build_id": "d746d8df-578d-42e9-a1a4-f6f51dedb164"}', 'aa9bfda7-4d26-41dc-8bd9-23ba4a0cad17') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:37.953593+02', '2022-11-02 13:51:41.719518+02', '2022-11-02 13:51:38.20558+02', NULL, '2022-11-02 13:51:41.719519+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'terraform', 'file', 'f2745f2a51129773e28bdef38e93371cb8cbddb0fce9e166db50fb212de62e9f', 'workspace_build', '{"dry_run": false, "workspace_build_id": "b59fc5fc-b8ec-41d3-a2ad-f84e6d68c727"}', '057c4228-c969-44e6-8845-8eff6fefa770') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_jobs VALUES ('6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:17.378046+02', '2022-11-02 13:57:25.922178+02', '2022-11-02 13:57:17.70642+02', NULL, '2022-11-02 13:57:25.922178+02', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '30095c71-380b-457a-8995-97b8ee6e5307', 'terraform', 'file', 'bdc01bd9124058306fb4aadbf77006707550e9e37658c70998235f4191dada4d', 'template_version_import', '{}', 'aa9bfda7-4d26-41dc-8bd9-23ba4a0cad17') ON CONFLICT DO NOTHING;


--
-- Data for Name: parameter_schemas; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.parameter_schemas VALUES ('433c2f61-374b-4116-bacb-450fe375c17d', '2022-11-02 13:30:44.890002+02', '1fca6797-88f0-4772-9873-b2a6e6a0bf16', 'docker_arch', 'Specify architecture of docker host (amd64, arm64, or armv7)', 'none', '', false, 'provisioner_variable', false, '', false, 'Value must be amd64, arm64, or armv7.', 'contains(["amd64", "arm64", "armv7"], var.docker_arch)', 'hcl', '', 1) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('b50566af-eedc-4555-bc0b-9f26574995da', '2022-11-02 13:30:44.888998+02', '1fca6797-88f0-4772-9873-b2a6e6a0bf16', 'docker_host', 'Specify location of Docker socket (check `docker context ls` if you''re not sure)', 'none', '', false, 'provisioner_variable', false, '', false, '', '', 'none', '', 2) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('a8defc42-191e-4abc-a3db-96c72c4a269b', '2022-11-02 13:36:23.903926+02', '391d562a-af1a-4f4c-81d3-244f3006d9c7', 'docker_image', 'What Docker image would you like to use for your workspace?', 'data', 'base', true, 'provisioner_variable', false, '', true, 'Invalid Docker image!', 'contains(["base", "java", "node"], var.docker_image)', 'hcl', '', 1) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('bcb5bc32-a7a7-4f28-8d0e-748e20fb9f62', '2022-11-02 13:36:23.906964+02', '391d562a-af1a-4f4c-81d3-244f3006d9c7', 'step1_docker_host_warning', 'Is Docker running on the Coder host?

This template will use the Docker socket present on
the Coder host, which is not necessarily your local machine.

You can specify a different host in the template file and
suppress this warning.
', 'none', '', false, 'provisioner_variable', false, '', false, 'Cancelling template create.', 'contains(["Continue using /var/run/docker.sock on the Coder host"], var.step1_docker_host_warning)', 'hcl', '', 2) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('f239329d-2328-437b-a3e6-470f7e91fd99', '2022-11-02 13:36:23.908523+02', '391d562a-af1a-4f4c-81d3-244f3006d9c7', 'step2_arch', 'arch: What architecture is your Docker host on?', 'none', '', false, 'provisioner_variable', false, '', false, 'Value must be amd64, arm64, or armv7.', 'contains(["amd64", "arm64", "armv7"], var.step2_arch)', 'hcl', '', 3) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('1bbddc70-22ff-4f8b-a423-64a0260f1eda', '2022-11-02 13:36:23.909951+02', '391d562a-af1a-4f4c-81d3-244f3006d9c7', 'step3_OS', 'What operating system is your Coder host on?
', 'none', '', false, 'provisioner_variable', false, '', false, 'Value must be macOS, Windows, or Linux.', 'contains(["macOS", "Windows", "Linux"], var.step3_OS)', 'hcl', '', 4) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('c7ed9a02-6a1c-46e1-925d-51b505599ac2', '2022-11-02 13:36:27.402454+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'docker_image', 'What Docker image would you like to use for your workspace?', 'data', 'base', true, 'provisioner_variable', false, '', true, 'Invalid Docker image!', 'contains(["base", "java", "node"], var.docker_image)', 'hcl', '', 1) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('f8cb7a23-e732-4ee9-a263-8c9383e856d4', '2022-11-02 13:36:27.397704+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'step1_docker_host_warning', 'Is Docker running on the Coder host?

This template will use the Docker socket present on
the Coder host, which is not necessarily your local machine.

You can specify a different host in the template file and
suppress this warning.
', 'none', '', false, 'provisioner_variable', false, '', false, 'Cancelling template create.', 'contains(["Continue using /var/run/docker.sock on the Coder host"], var.step1_docker_host_warning)', 'hcl', '', 2) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('15e99f3d-c60c-4649-9442-c84e8639b9f8', '2022-11-02 13:36:27.399443+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'step2_arch', 'arch: What architecture is your Docker host on?', 'none', '', false, 'provisioner_variable', false, '', false, 'Value must be amd64, arm64, or armv7.', 'contains(["amd64", "arm64", "armv7"], var.step2_arch)', 'hcl', '', 3) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('cdd9dfa6-0550-4a53-9bb7-8465628dedcc', '2022-11-02 13:36:27.40081+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'step3_OS', 'What operating system is your Coder host on?
', 'none', '', false, 'provisioner_variable', false, '', false, 'Value must be macOS, Windows, or Linux.', 'contains(["macOS", "Windows", "Linux"], var.step3_OS)', 'hcl', '', 4) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('8320ac9e-cbb8-4e1e-810b-c78edb19fad4', '2022-11-02 13:31:33.386083+02', '8cff6071-0a97-4c99-9fff-dc3507dd259b', 'docker_arch', 'Specify architecture of docker host (amd64, arm64, or armv7)', 'none', '', false, 'provisioner_variable', false, '', false, 'Value must be amd64, arm64, or armv7.', 'contains(["amd64", "arm64", "armv7"], var.docker_arch)', 'hcl', '', 1) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('a81f23fe-d849-4773-afec-64d332f672a9', '2022-11-02 13:31:33.384416+02', '8cff6071-0a97-4c99-9fff-dc3507dd259b', 'docker_host', 'Specify location of Docker socket (check `docker context ls` if you''re not sure)', 'none', '', false, 'provisioner_variable', false, '', false, '', '', 'none', '', 2) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('47c7b35e-09cd-452f-83fe-d674ffbb645c', '2022-11-02 13:30:35.394671+02', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', 'docker_arch', 'Specify architecture of docker host (amd64, arm64, or armv7)', 'none', '', false, 'provisioner_variable', false, '', false, 'Value must be amd64, arm64, or armv7.', 'contains(["amd64", "arm64", "armv7"], var.docker_arch)', 'hcl', '', 1) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('9e203b66-d4a5-4ad8-8461-5a4e3ed98d67', '2022-11-02 13:30:35.391857+02', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', 'docker_host', 'Specify location of Docker socket (check `docker context ls` if you''re not sure)', 'none', '', false, 'provisioner_variable', false, '', false, '', '', 'none', '', 2) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('9b4d30dd-b715-4853-919c-ba1c7a3e9bf2', '2022-11-02 13:30:30.393958+02', 'ef8d15e3-0cab-4e83-b576-9fd27a680217', 'docker_arch', 'Specify architecture of docker host (amd64, arm64, or armv7)', 'none', '', false, 'provisioner_variable', false, '', false, 'Value must be amd64, arm64, or armv7.', 'contains(["amd64", "arm64", "armv7"], var.docker_arch)', 'hcl', '', 1) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('79d0ad7e-1d0c-45e7-bc17-659449c45832', '2022-11-02 13:30:30.39201+02', 'ef8d15e3-0cab-4e83-b576-9fd27a680217', 'docker_host', 'Specify location of Docker socket (check `docker context ls` if you''re not sure)', 'none', '', false, 'provisioner_variable', false, '', false, '', '', 'none', '', 2) ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_schemas VALUES ('a0e76800-607c-4b06-973f-93c06598b499', '2022-11-02 13:57:17.947453+02', '6f457831-78b1-4bec-ab06-026a554058f5', 'docker_image', 'What Docker image would you like to use for your workspace?', 'data', 'base', true, 'provisioner_variable', false, '', true, 'Invalid Docker image!', 'contains(["base", "java", "node"], var.docker_image)', 'hcl', '', 0) ON CONFLICT DO NOTHING;


--
-- Data for Name: parameter_values; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.parameter_values VALUES ('05982988-594a-4272-9bd4-d8617dbcaa81', '2022-11-02 13:30:34.842175+02', '2022-11-02 13:30:34.842175+02', 'import_job', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', 'docker_arch', 'data', 'amd64', 'provisioner_variable') ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_values VALUES ('1cfe5ce3-3225-4e72-b577-0cf70caaf47c', '2022-11-02 13:30:34.843501+02', '2022-11-02 13:30:34.843501+02', 'import_job', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', 'docker_host', 'data', '', 'provisioner_variable') ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_values VALUES ('88629c3b-0e28-4727-a6a0-3d6070ab59f1', '2022-11-02 13:31:32.81037+02', '2022-11-02 13:31:32.81037+02', 'import_job', '8cff6071-0a97-4c99-9fff-dc3507dd259b', 'docker_arch', 'data', 'amd64', 'provisioner_variable') ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_values VALUES ('ae2de10a-3871-457c-929a-c9fc53b69d59', '2022-11-02 13:31:32.810909+02', '2022-11-02 13:31:32.810909+02', 'import_job', '8cff6071-0a97-4c99-9fff-dc3507dd259b', 'docker_host', 'data', 'unix:///var/run/docker.sock', 'provisioner_variable') ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_values VALUES ('2e0135a0-509c-4abe-a308-893f38ca5cf5', '2022-11-02 13:36:26.687226+02', '2022-11-02 13:36:26.687226+02', 'import_job', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'step1_docker_host_warning', 'data', 'Continue using /var/run/docker.sock on the Coder host', 'provisioner_variable') ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_values VALUES ('71529705-fca3-461e-85eb-d8f4ba56d91b', '2022-11-02 13:36:26.688326+02', '2022-11-02 13:36:26.688326+02', 'import_job', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'step2_arch', 'data', 'amd64', 'provisioner_variable') ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_values VALUES ('48b544b1-b904-4e1d-ae31-5d45f062f281', '2022-11-02 13:36:26.689098+02', '2022-11-02 13:36:26.689098+02', 'import_job', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'step3_OS', 'data', 'Linux', 'provisioner_variable') ON CONFLICT DO NOTHING;
INSERT INTO public.parameter_values VALUES ('3b918edd-dbe5-4f90-a57f-8a0bb05c436b', '2022-11-02 13:37:08.219391+02', '2022-11-02 13:37:08.219391+02', 'workspace', '759f94c0-2e14-4a48-8d9e-6507a38e156a', 'docker_image', 'data', 'base', 'provisioner_variable') ON CONFLICT DO NOTHING;


--
-- Data for Name: provisioner_daemons; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.provisioner_daemons VALUES ('22c3662c-60eb-408b-99e1-85b447c2b7e5', '2022-11-02 13:02:32.925313+02', NULL, 'gallant_mahavira7', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('e70c7dd0-bba3-4ab8-bfe1-f75e42c67e37', '2022-11-02 13:02:32.92604+02', NULL, 'brave_borg8', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('315adce9-adc9-407c-9ff7-905c1c71d020', '2022-11-02 13:02:32.926164+02', NULL, 'lucid_lederberg6', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('a6246fc1-23f3-4206-ad2d-ff6f85b017b4', '2022-11-02 13:10:56.115722+02', NULL, 'trusting_lamport1', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('fc5728a8-e0f9-47a8-a00e-31943fc46b29', '2022-11-02 13:10:56.121368+02', NULL, 'wizardly_lumiere8', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('0a6664b4-07a8-461c-9275-637b1da715bb', '2022-11-02 13:10:56.123247+02', NULL, 'eager_einstein5', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('0f817029-e02b-4b33-9c3f-4bfb76b16c79', '2022-11-02 13:27:50.649612+02', NULL, 'infallible_torvalds9', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('52ded48a-2824-469e-bde1-a1d1af3d0f6c', '2022-11-02 13:27:50.649614+02', NULL, 'nervous_bose6', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('ed0a2462-6ca1-4a9a-becb-a2f8567dc69e', '2022-11-02 13:27:50.649838+02', NULL, 'thirsty_grothendieck0', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('6ece78bb-a2a9-4429-8878-7e395f8729af', '2022-11-02 13:40:40.994349+02', NULL, 'affectionate_ishizaka7', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('fce7ee35-f06b-4cb7-972e-6aa8848f469b', '2022-11-02 13:40:40.994303+02', NULL, 'adoring_driscoll1', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('fbcc634b-9fdd-4cef-bcc9-5fa9a4dfb03f', '2022-11-02 13:40:40.994377+02', NULL, 'exciting_napier8', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('057c4228-c969-44e6-8845-8eff6fefa770', '2022-11-02 13:50:59.702845+02', NULL, 'kind_poitras0', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('aa9bfda7-4d26-41dc-8bd9-23ba4a0cad17', '2022-11-02 13:50:59.703022+02', NULL, 'eager_northcutt0', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('0af18cd5-e531-4eef-b95e-aca5c98e6ae1', '2022-11-02 13:50:59.703819+02', NULL, 'crazy_hopper5', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('dee79977-c700-403f-8f6c-4e8d45008b96', '2022-11-02 14:04:03.423095+02', NULL, 'silly_merkle4', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('6996221a-b454-42bf-a59f-a68850d751e8', '2022-11-02 14:04:03.423152+02', NULL, 'agitated_kowalevski1', '{echo,terraform}') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_daemons VALUES ('ff0004b3-f53b-42c4-be36-f1d23280db19', '2022-11-02 14:04:03.423275+02', NULL, 'adoring_tharp4', '{echo,terraform}') ON CONFLICT DO NOTHING;


--
-- Data for Name: provisioner_job_logs; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.provisioner_job_logs VALUES ('d09b6083-e482-41ac-ad06-3aa731ec4fc6', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:31.936+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fe61a03b-d5b2-4ba4-a437-253ea724d149', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:31.943+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1badda17-67b2-4795-9351-6a2cee04c22a', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:31.949+02', 'provisioner_daemon', 'info', 'Parse parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('80b05e59-1fdb-48cf-99ed-27ed0aba8ecc', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:31.956+02', 'provisioner_daemon', 'info', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4a5c2ec6-c2e2-4136-9423-14cdff1d6f13', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:32.046+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7da3c668-9812-47b7-9d22-43138800a307', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:32.05+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2f752172-65f0-4a43-9378-c5d0997eca76', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:32.054+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f6c293ae-a496-40c2-ab8e-b7d64aca4bdb', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:32.057+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('15948e16-e69b-47c2-821e-6c0b375dccd8', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:32.059+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('62d872e4-9a8c-4cc5-9f21-083bfcb6a03c', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:32.28+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bce64698-1b64-4ef6-94b7-b5fd071b31e8', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:33.826+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Installing coder/coder v0.5.0...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('35c436dd-3beb-4c5d-9f8a-16198d2fbcb7', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:36.186+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Installed coder/coder v0.5.0 (self-signed, key ID 93C75807601AA0EC)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aa80ec91-8b8f-4268-88a4-111e5b368bf9', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:37.718+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Installing kreuzwerker/docker v2.20.3...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e322b727-fddf-4d31-b0ad-fe9fb0532586', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:40.978+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Installed kreuzwerker/docker v2.20.3 (self-signed, key ID BD080C4571C6104C)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('26cac587-a5c7-4691-bab4-0fa1436724c3', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:40.984+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b192bac6-94a0-4e89-8d88-eba6c1028abe', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:40.988+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Partner and community providers are signed by their developers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('57162911-66a9-4597-a289-643724057e2d', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:40.992+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you''d like to know more about provider signing, you can read about it here:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('19227832-c872-4d8d-b610-c649da56984e', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:40.996+02', 'provisioner', 'debug', 'Detecting persistent resources', 'https://www.terraform.io/docs/cli/plugins/signing.html') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dce2aa32-5dbd-4c04-af85-c7ef585dca6a', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6e220907-0654-46dc-bb56-212153032d5e', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.003+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8da2943d-7295-43a6-b560-e946c127b0a0', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.006+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('79b02372-6db4-4cd6-8c69-c94e9ef2fb5b', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.009+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4b810053-fde0-4579-b2fa-f3a80d9f3f5f', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.012+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('76a7934d-b410-4ccc-a57e-1329aefe0203', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.015+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('133aa0b6-4da8-48e4-9428-62f6b7635510', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.018+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a0ed73d5-e07a-4b3a-8046-8fdaefc1dacb', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.027+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8b67db19-e012-461d-a538-d1dea4f91ef4', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.781+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('60637ec5-5231-4407-b62d-13e44074eb7f', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.784+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c3ed554e-b395-4adf-8642-f7596a71c4cc', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.787+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_provisioner.me: Refresh complete after 0s [id=20990c34-2afd-4e54-bfa3-9b7e5beea09e]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8b988379-c1e4-442b-9232-65fd926eecff', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.791+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refresh complete after 0s [id=fc8ca501-3820-427d-92c5-d8ca4fd45362]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9a4e58db-512e-42db-9349-29ebef3c750f', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.816+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('45f82833-a53c-49ca-be8e-1545917d7062', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.82+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5c0eb2ac-825d-4ad8-bed8-63d59266030e', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.823+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9fd0dc4c-e75d-47ac-9676-2e4182da7edd', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.826+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b9a391a5-117f-45e0-9a2c-89b13c32d201', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:41.829+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7470c318-e457-4b2c-b61d-4fbab6f84fc3', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:42.617+02', 'provisioner_daemon', 'info', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('975d23d1-aa43-4efc-b533-55a07e8cc3bf', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:42.705+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f4cad918-2fb0-46a2-b64a-daa899b659fe', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:42.708+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dc6331d7-41a8-4f65-8a89-da54638b5aa0', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:42.846+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ca307075-af47-4fa5-9d3b-4744acc7a0ac', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:42.851+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('61df6634-b81b-4fde-b7cb-13ed3f97b210', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:42.855+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of coder/coder from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9f227da4-3fa0-4d7d-a65e-38ccf06bba2f', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:43.06+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of kreuzwerker/docker from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e79c1b3c-5db1-48fd-ac61-3fb667e3fc97', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:43.319+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed coder/coder v0.5.0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('28ec8811-7aaa-460c-b6e2-a9b85eb46b4b', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:43.405+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed kreuzwerker/docker v2.20.3') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cef26c13-8a06-4ae6-946f-216db5cc0996', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:43.411+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fe2bc9eb-b7ea-4d20-8d7a-b2be1d3c450a', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:43.415+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d49391ed-7b60-459e-8fe5-4dd4783f6629', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:43.45+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('25f8cf7f-4cee-4891-9f14-4e32002e6661', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:44.179+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ca6ad386-5647-49e3-9b05-0f4cdfd35b01', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:44.184+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aece424c-595e-4ad8-a1cc-0938d037a3cb', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:44.187+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_provisioner.me: Refresh complete after 0s [id=ccf0bb8b-fca5-408f-b4a6-93434185c25a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f345b9bd-429e-468f-aea4-8c11709991da', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:44.19+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_workspace.me: Refresh complete after 0s [id=5e7ca627-de78-4542-a964-acda3f038ced]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('31b0cf2d-4a8b-4860-86d7-ec9fc5e58abc', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:44.208+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('602d137a-eaad-4b34-9a5a-e2169adf1b17', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:44.212+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d5cc54cf-0390-4fa7-9ff5-3bcd15cbe351', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:44.216+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a2f6c1a8-05ff-45a8-ac0e-490f7dc0b7b1', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:45.056+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2dbe9812-907b-4344-b602-14c680fd460c', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '2022-11-02 13:03:44.222+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Plan: 3 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('377e167e-4133-40d8-b62b-e33369c5ed55', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:11.437+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6d970dad-4051-42d8-847c-07320fb9b110', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:11.525+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('501f4bab-6eb3-4278-9192-7ae725943418', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:11.528+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('80e17591-51fe-4fda-aa90-18caa59d1b7d', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:11.533+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bdd4192d-9f9d-4300-8b4e-f1f12a8479a8', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:11.536+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b46e6002-1277-4d2b-88a6-97f2f250766e', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:11.542+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b251b96c-368b-4be2-982e-621372dd1f0e', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.072+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('294bdb11-4229-46a0-a926-34590373e945', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.155+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('70eab552-5fe7-491a-a275-22059e959ccb', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.212+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c32727e1-ca44-405a-9419-038107c4bc96', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.285+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9e3ae09c-09bc-4a27-b271-9446198fb60e', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.293+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9d2d3770-f969-4796-9d65-6cc903593d52', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.299+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4fdc748e-938c-4809-9125-caae1c44fd74', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.302+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('57b70064-827e-4763-b8a0-473f99797b48', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.306+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('781a7128-f401-48e3-a752-4f5d3c636ead', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.309+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('71dbe7ee-7537-4cf3-8f33-8c309ebe8b7e', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.313+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('360f1a19-7904-440a-a539-6f035169d093', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.317+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('df6ba6d2-fada-4b68-a8a6-978fdc7b55e2', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.32+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bfc96ab3-fa05-416f-b21e-c58a3ab123f2', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.323+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('44a12cb2-da79-469f-b971-c4bf32fe406e', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.327+02', 'provisioner', 'debug', 'Detecting persistent resources', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('299f3930-0423-4e75-ae4a-526e37f481c5', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.33+02', 'provisioner', 'debug', 'Detecting persistent resources', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b6bffd24-8365-4a00-98ed-1e1f978aca49', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.333+02', 'provisioner', 'debug', 'Detecting persistent resources', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0422f763-da4f-4552-9562-144927bec94d', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.336+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aab83530-7dcd-49bd-b981-5c29cd9674d3', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.339+02', 'provisioner', 'debug', 'Detecting persistent resources', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3089607c-329c-4ee7-88dc-e9f48318e52f', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.342+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a20e18c7-daa9-4e40-9ed9-9c11a2ccf5b1', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.346+02', 'provisioner', 'debug', 'Detecting persistent resources', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('582dbda6-f79c-43d5-b215-2da3b13bd406', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.351+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b6cf795f-35e7-45ee-98d0-8be04d7ad6fe', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.356+02', 'provisioner', 'debug', 'Detecting persistent resources', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f36be7f7-a6c2-40d1-9722-ae8e4d920a08', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.359+02', 'provisioner', 'debug', 'Detecting persistent resources', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3c03dd84-79e1-4abf-9900-05613cc82664', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.363+02', 'provisioner', 'debug', 'Detecting persistent resources', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4cbcab55-cb60-4982-90f7-be05ffac7566', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.366+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3d553c50-de3b-4770-8bed-2792c6981362', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.369+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1137030a-bfda-4391-8b17-6a1c1a5e2749', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:12.373+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bc462919-aa4b-452c-b945-35965cf138c5', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.157+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c76057c5-2191-4336-b7fb-f104d3c4054b', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.162+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5a1771fc-0028-4edb-9bdb-86dcd4c58687', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.165+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refresh complete after 0s [id=13dbb32a-5197-458d-8092-6f00a7df5d19]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f29c2e5d-3392-43c3-ae80-1deeea71f11a', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.169+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_provisioner.me: Refresh complete after 0s [id=2ab63b5c-7d85-43db-ae90-cdcdd27ca4d6]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f3eb65ac-2be8-4b88-9bb8-618bfd70561b', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.201+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('739ec94c-4700-4562-80f7-7f254aa8b129', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.205+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f01666b7-4de4-451f-8710-8aa63d32aa8e', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.209+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('556f3f57-5a46-49da-aac4-66ed5d101e7f', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.213+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('55d5e4f7-e80a-4622-9168-7e412651b91e', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:13.216+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('664fe6c8-1fec-410c-93d8-385e8b65e7d4', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', '2022-11-02 13:04:14.076+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1af37305-2e9f-445d-b3fb-dea1dece403b', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.436+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5da10ab9-a23c-44ea-98bb-865dc706eae2', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.44+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7d8d1b95-2660-4724-a2e5-8c0439eff2e7', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.534+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('89f7bb3f-c495-4567-a188-25c5b41f6e5d', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.538+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('050649c2-fa47-407a-b871-b9f9a8a48b49', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.543+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7d7e19cb-238c-4293-a488-5f61fe83d9d9', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.548+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('daf99de4-753e-4a40-a412-385a97ffe655', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.551+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b10105f1-a4ca-473e-a33d-a6755709ac7d', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.776+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d974959e-0c77-4c38-8302-dbdea5f8b702', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:19.966+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3d0f0030-8fdb-4193-9f71-e7648c0b00ca', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.023+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5e93f614-bd73-4fd7-bf0d-85c61e8294dd', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.095+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('160b7134-0cd1-4c28-b05a-ac7fa6d5d05e', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.098+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7b4b1ca6-fe48-4f1b-bd9b-b6ab54b3cccd', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.086+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8a234d62-5d70-450d-ae9e-fd46186a7717', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.102+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3872d0e7-f5fd-45f9-9027-ec41eacdbc8f', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.106+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('02eb7d16-8513-4ac8-af9b-bd096faccbe0', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.109+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('afefbc98-b47e-4c32-99cc-a2cbe7066d43', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.112+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('785eef1d-66ce-406e-bf12-5e2e95ffdf4a', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.115+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cb782ff3-5ef8-4312-9431-8a44aed28d9d', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.118+02', 'provisioner', 'debug', 'Starting workspace', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('02003fe3-ac96-4cdc-8683-5042aff7ad81', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.122+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2f203901-94d5-4e9d-8988-d06224e9fa0b', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.125+02', 'provisioner', 'debug', 'Starting workspace', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9d53f365-961a-43df-8a0e-b974649183aa', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.129+02', 'provisioner', 'debug', 'Starting workspace', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3dd1ed46-1de4-4362-bfff-784182b44471', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.132+02', 'provisioner', 'debug', 'Starting workspace', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c03469d0-08a9-4378-b538-50d6d1d50c79', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.135+02', 'provisioner', 'debug', 'Starting workspace', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c6166453-3033-4d69-a5f0-4856776c76e4', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.138+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fa7a0d2f-1bd2-46e9-9f25-8bd45860dd98', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.141+02', 'provisioner', 'debug', 'Starting workspace', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a1fd6072-dde6-420c-bf8e-9ebc4d537866', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.145+02', 'provisioner', 'debug', 'Starting workspace', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cae1268e-b797-4e97-83cb-95ff016a5a63', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.147+02', 'provisioner', 'debug', 'Starting workspace', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('938f0d99-4dc6-42a1-b6b9-c9e70b450cd5', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.15+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3d9d2115-f6ea-40c2-9f56-5075cada0c34', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.152+02', 'provisioner', 'debug', 'Starting workspace', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('46e2af39-78f2-4a37-824a-0b4f2dc54764', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.157+02', 'provisioner', 'debug', 'Starting workspace', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1ae80356-6b65-4ff6-8230-7cab8a8cfaf9', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.161+02', 'provisioner', 'debug', 'Starting workspace', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('386b59ce-c30e-4f7d-addc-178e223b1d87', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.164+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b18f40d1-f649-4f34-b332-feb6690482da', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.168+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0747c356-f2ea-49ab-b7ba-292ed9abff7a', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.171+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('da54beff-b031-436d-93f0-67f2ff53be96', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.94+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('78007aad-5614-4d0e-9fa9-ae1307b6240f', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.946+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3159380d-141a-4d2c-9a69-cbc90c5fe71b', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.951+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=3a9a1feb-e89d-457c-9d53-ac751b198ebe]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6e6a0df4-feb4-4339-87ce-ccf48ff873db', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.956+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refresh complete after 0s [id=17cc17af-8bbb-4761-ad39-da62ad512c23]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('88cae505-15e1-4ca8-bcf7-8bd1c3af8030', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.975+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('463ef456-2b86-4c67-bc2b-23079a793142', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.979+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e29a0563-0299-42df-8f3e-38fdb851d743', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.982+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e0756af8-2cce-4246-a589-a4741eee2359', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.985+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7e6f0608-02b9-4523-bdef-5a8cdf63d65b', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:20.987+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1fb337be-0749-4e98-8513-62164696b42e', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.166+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6d785a3a-7864-4cbf-9612-af13c4347f66', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.172+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Creation complete after 0s [id=0907dab9-1909-4d03-bffd-936a2a05a22a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9e3f0f0d-3269-48c8-aa1c-f633360809cc', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.185+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d6bc2b50-2e74-414a-bf13-a43189e86abb', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.192+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0e090bdb-12b2-4959-9230-9b014af2b7ca', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.195+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creation complete after 0s [id=5f1c2ba3-6b26-409c-9790-df56b62efcbc]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4bfa811d-9368-4548-be3e-3f7884d2ba5d', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.198+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creation complete after 0s [id=coder-admin-my-workspace-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('00ef0ca8-439c-4b3f-94a4-cd086d15e9d2', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.21+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('53d6c9b1-8d43-4f0d-963b-8967ee2a3409', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.74+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=a1ff536472e9efdd5ed90d6aafc28669799668007ab93823567ac08066822244]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f29082e9-aad2-46f9-8d4a-bacf3d3618dd', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.749+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 4 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6a3690dc-6e1f-400b-b47f-af64bd007a55', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:21.755+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('473429ac-5ede-48cd-b754-9b3e498aa60c', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 13:04:22.83+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f5303749-4d64-4f3d-ac0e-81e629355e86', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.44+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0812fe54-1b04-4b52-9f43-049fa80467e8', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.444+02', 'provisioner_daemon', 'info', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('31f9020f-3378-4209-a421-7399c86ea76d', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.54+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1110403f-1865-4dca-97a7-4ecb14a97134', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.545+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('955f1a84-1718-4aa7-8022-3ea41d2ba1ba', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.549+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ea27eb37-4934-4bad-bbeb-8a7f0bec0498', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.553+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3525b9d7-69c2-4537-9f47-6290966b4f3d', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.555+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0b83bb69-0b72-4e11-8c13-2b68b90217a9', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.832+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bff36240-532f-44d0-ae0f-2c2faa22ebf3', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.941+02', 'provisioner', 'debug', 'Stopping workspace', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('755ab7f1-8af7-4e73-bdf4-e7d42250f102', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:48.997+02', 'provisioner', 'debug', 'Stopping workspace', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('41af9b10-8823-40ef-9acc-0c7c0aac73aa', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.066+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4eb9c01c-e77c-4509-b1d3-f394383e00dc', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.072+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6baa0b42-517a-4154-804f-50b900a17cb0', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.077+02', 'provisioner', 'debug', 'Stopping workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5ed6a9d9-ce78-41f2-850b-c54354ba85fc', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.081+02', 'provisioner', 'debug', 'Stopping workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f674b8d8-1aca-475d-84d1-74e68caad7c2', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.084+02', 'provisioner', 'debug', 'Stopping workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bf8e0403-bc1f-4200-93cd-d459c5d4eea5', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.089+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9b55efd6-191a-40f6-8e96-c87ce7ddcf95', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:17.713+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('215f7ba3-dcb7-48c0-b43c-07ff5e6a0cc5', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:17.77+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('60266ab8-b8bf-43e1-be84-dc8cf8190ee1', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:17.83+02', 'provisioner_daemon', 'info', 'Parsing template parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('01b68a1a-ffb2-40f1-a4ee-b69d47787e4b', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:17.956+02', 'provisioner_daemon', 'info', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dddd0da6-0d7c-44af-9070-875aacd0f882', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:18.101+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a888fb0a-b99c-4cb2-8a98-b9b727dd72be', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:18.156+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('06eae3de-6be2-4474-9541-2432fce34c23', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.157+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('96a21e86-fab9-40b1-9976-1441a6e74ba5', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.211+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e2a276ef-3882-4849-a4f1-2438fe80e201', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.266+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2a26f80a-f534-4a57-8f60-61b0245b2a28', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.092+02', 'provisioner', 'debug', 'Stopping workspace', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d687a831-e9cf-47f7-8fee-2b971e07110e', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.095+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5f1ea8a9-583f-4613-9cf9-2ae1dada1013', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.098+02', 'provisioner', 'debug', 'Stopping workspace', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('63a97f16-df0c-4064-abb1-fa94edff116b', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.1+02', 'provisioner', 'debug', 'Stopping workspace', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0659c1b7-ba0a-4153-a121-1b707d6dba43', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.103+02', 'provisioner', 'debug', 'Stopping workspace', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5026c663-c180-4880-b27e-831ea7b915e6', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.106+02', 'provisioner', 'debug', 'Stopping workspace', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('11bc6add-90ee-4ef1-8270-2c4b75149666', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.108+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a4ed025f-5228-40fd-97dc-3f581423760c', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.11+02', 'provisioner', 'debug', 'Stopping workspace', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f87eb959-7fa4-4574-b57f-0d25eddb5780', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.113+02', 'provisioner', 'debug', 'Stopping workspace', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('190ce772-4a3e-48d1-82fc-6d2c4406376b', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.115+02', 'provisioner', 'debug', 'Stopping workspace', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('807aa93f-0413-4158-9706-aad0f2bd3472', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.118+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('224ba0e5-1c27-44d9-8dd9-d04843eed695', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.12+02', 'provisioner', 'debug', 'Stopping workspace', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('744e3d76-8b8d-40c2-a3d3-2b2707720a2b', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.123+02', 'provisioner', 'debug', 'Stopping workspace', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('53594c81-a9e6-4ab3-babd-5491157c4de1', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.13+02', 'provisioner', 'debug', 'Stopping workspace', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('86f24df0-9053-4aee-a55e-39186d23dd9c', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.133+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('710b2445-edfe-4b38-956f-f3ee83affebc', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.136+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8e29a006-dbbc-4cc2-8856-70aaddc70627', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.139+02', 'provisioner', 'info', 'Stopping workspace', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bbf4cec8-2edc-47e1-9f18-71c0d0f3229e', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.88+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ad23bec6-86a9-4831-9adc-3ee4d979e49c', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.887+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0a0c2ddc-94f4-4d9a-a403-c0229939ad38', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.89+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_provisioner.me: Refresh complete after 0s [id=69d8c247-a4cc-4de6-86c0-ce073255316a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('992e7b85-8c39-4c79-82c8-d9e616baf3b3', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.894+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=3a9a1feb-e89d-457c-9d53-ac751b198ebe]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5abaec85-0b9a-49a0-a547-e40f68123865', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.898+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Refreshing state... [id=0907dab9-1909-4d03-bffd-936a2a05a22a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('927353ca-a7f2-4604-b7a2-0b1e3c5bd1da', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.902+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Refresh complete [id=0907dab9-1909-4d03-bffd-936a2a05a22a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('94933b2b-bf01-45c8-a0e9-6c82700cd4d4', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.91+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refreshing state... [id=5f1c2ba3-6b26-409c-9790-df56b62efcbc]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5b8fcf47-22e5-4ced-a3b7-aaaef79f8452', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.913+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refresh complete [id=5f1c2ba3-6b26-409c-9790-df56b62efcbc]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2c9cb430-1dc6-4896-a0c8-469947399523', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.917+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-admin-my-workspace-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9cbe3787-1861-4007-8803-f071482fa2fa', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.921+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refresh complete [id=coder-admin-my-workspace-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d8b2a8a8-c653-412e-a70d-dc65a14c2af6', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:49.925+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refreshing state... [id=a1ff536472e9efdd5ed90d6aafc28669799668007ab93823567ac08066822244]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6b22e12c-75e1-4f5a-a571-add29e687bd8', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.043+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refresh complete [id=a1ff536472e9efdd5ed90d6aafc28669799668007ab93823567ac08066822244]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('db7d2cd9-0331-4e1c-9ae2-0cc18cfb1d5e', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.057+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('71455c3a-c6ec-472c-9b6e-e174697c3e93', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.061+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5580b627-218d-43eb-b619-b269c796b158', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.066+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9499f481-527c-46a8-9a9f-f84ab5caf603', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.069+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c245b280-6683-4aea-ab6b-55dd8ccc02dd', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.073+02', 'provisioner', 'info', 'Stopping workspace', 'Plan: 0 to add, 0 to change, 1 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0aa11a57-2d0c-40f9-84e2-793d47db516f', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.174+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destroying... [id=a1ff536472e9efdd5ed90d6aafc28669799668007ab93823567ac08066822244]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('354d0fe5-252d-49eb-a432-3672bd77f421', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.472+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e4cf8c6b-2e24-4db8-bb71-d57c5c88157b', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.485+02', 'provisioner', 'info', 'Stopping workspace', 'Apply complete! Resources: 0 added, 0 changed, 1 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('651e7bf8-eeb1-41fc-acca-d00036fd1dbe', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:50.49+02', 'provisioner', 'info', 'Stopping workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('15a9676b-718b-4461-9e62-81fbd550a897', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 13:04:51.51+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('109203b0-c680-45fe-b470-ab383e7322f7', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.438+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('25618f60-4596-4bb5-9ba4-daa75e885289', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.442+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('53042802-9b70-4933-91ab-b2c0bc444693', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.545+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c9ad724a-5481-44f7-b8a1-b450dc5051f6', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.549+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('71bc590a-a0e5-4268-89a7-d6178304d91c', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.552+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aa7529a0-8020-4268-a106-bfa9d7b8db45', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.555+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4ebfc500-c4ff-4247-a4e8-14e6814d9fac', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.557+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('541853de-e473-486d-b6e1-3b6e78518788', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.82+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2778a009-7045-4773-beb6-4fb7ca574116', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:55.993+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ed060a03-3f5a-4695-97e3-22d7deab8d38', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.053+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3564ae4e-b903-4431-96d9-17d7bac188f7', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.128+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('683bd5c5-0397-4d70-8e5f-7d5995f1f38a', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.136+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('55d3ea8e-5bc0-4aac-aa19-4d4c74146503', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.14+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cbff931a-8b68-4dfa-83a2-40809e7add5d', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.143+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3fff2b02-6fc5-421d-8c2a-1ab8ffbc9fcc', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.146+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9ac3b08f-bb36-4e21-828f-4ae47d2b9719', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.149+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('74d08fc2-27a1-403b-85f8-24ec862dd288', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.152+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d2511df7-1992-4c8d-b5ca-bb60bc638ce4', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.156+02', 'provisioner', 'debug', 'Starting workspace', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('681814dc-5855-4e4b-8907-c9de0d29b119', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.16+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bbbb300a-9a20-4e88-8f12-4de90b82594e', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.163+02', 'provisioner', 'debug', 'Starting workspace', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8bc2492b-fd16-4098-92e9-7d8ece563d3d', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.166+02', 'provisioner', 'debug', 'Starting workspace', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dcdf65fb-c226-4554-8fec-edbb04f1414e', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.17+02', 'provisioner', 'debug', 'Starting workspace', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8820392e-9d9e-4988-9623-ee1af0059d11', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.173+02', 'provisioner', 'debug', 'Starting workspace', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9c64a617-539b-4e57-a750-355c66cf15cb', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.176+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bffd2b77-7f42-4aef-ac19-586998a6f614', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.179+02', 'provisioner', 'debug', 'Starting workspace', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d7fcb4d1-6c30-4777-83c6-015b0f48a970', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.182+02', 'provisioner', 'debug', 'Starting workspace', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cdcb62d9-f347-4654-b5b2-28fd6960a509', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.185+02', 'provisioner', 'debug', 'Starting workspace', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('95ea3beb-90e7-4787-901c-f570df3bd801', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.188+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9797523c-35ee-4ed3-a69f-af357fafc42c', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.19+02', 'provisioner', 'debug', 'Starting workspace', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bb8189ba-82a1-48f1-bf1c-e000659f8697', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.193+02', 'provisioner', 'debug', 'Starting workspace', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7d86f4fa-e8e9-42f7-b1f6-f27822c67292', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.195+02', 'provisioner', 'debug', 'Starting workspace', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('17e19806-b748-4837-9166-0bcae6592ffe', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.198+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('07392a8e-31b3-4e7d-ade1-a09d4c2ee2b6', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.2+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('524bf497-10f8-41d3-960d-ed67df4fa9ec', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.204+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('326c0c94-5c0a-45f8-8a26-1e8639553502', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.954+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8a6b7cd1-f0f5-4972-9364-cdc5eeb61f0c', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.958+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('61b04b23-eca5-4c15-91bb-bb88f00a2021', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.962+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refresh complete after 0s [id=b65a767f-719a-4883-a186-aeb1ac05cb25]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('73e70e26-c6b7-4d8e-a9cc-1acc06022279', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.967+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=3a9a1feb-e89d-457c-9d53-ac751b198ebe]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('74683648-d94f-4d9e-9e6d-bf5fc05fd706', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.972+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Refreshing state... [id=0907dab9-1909-4d03-bffd-936a2a05a22a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0c241c2a-7607-438c-8af2-c3641959f485', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.976+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-admin-my-workspace-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('944880c1-ef75-45b8-a60f-f17800a83023', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.979+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Refresh complete [id=0907dab9-1909-4d03-bffd-936a2a05a22a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7a466591-e523-4fe0-9df3-564a35161f49', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.982+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refresh complete [id=coder-admin-my-workspace-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c4e5c961-e812-40e3-b0a4-bc5bb781751d', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.986+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Refreshing state... [id=5f1c2ba3-6b26-409c-9790-df56b62efcbc]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0b2bdd2e-4c9f-4514-8f42-0650a0be805a', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.989+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Refresh complete [id=5f1c2ba3-6b26-409c-9790-df56b62efcbc]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d3b5a8c6-f038-4147-a074-4603945ed27b', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:56.997+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4f2c80f8-d06b-4670-976e-3b58b5f8200d', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:57.002+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('755914cd-d41e-447e-9343-284fe4c0a9a5', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:57.006+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 1 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dc059e5c-18aa-4d95-b50d-9861ee068be7', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:57.229+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ccbb8238-0a62-4d0d-8269-3709ce02f47a', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.964+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e8fd1570-dfb7-4bdf-9d13-fd1dbf3cb124', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.967+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('76167fa7-9670-430f-9536-176cdc4a9f5c', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.97+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9d1e67b3-6bd8-435e-96b5-c7b012b42604', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.972+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4a8a8443-c6cf-435d-8527-1a782b74b838', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.975+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('45c669a4-88fd-47f0-98a3-e0875d352d7a', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.16+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c48882a8-d865-44ee-b8d0-6fa60a255848', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.165+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dda5b5fe-027d-402a-8852-a4ce2bfe4d71', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.17+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Creation complete after 0s [id=6137599d-4ad6-4e58-b0fa-a3d1a88fa5a9]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ea5f28e9-38b6-4d6a-8ffb-9e48657632ea', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.174+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creation complete after 0s [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('53224434-ead2-4aa3-8c86-177bc4c8fc3b', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.181+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('71ddfedf-d129-495e-bb80-ecf16f789be0', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.186+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f2f59832-212f-466c-92f3-ede2f34fc731', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.189+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creation complete after 0s [id=3a585bc7-75e6-408e-b0bc-dc64e4d3be0a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b10e5078-18f2-4ccc-875f-134d5724667a', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.857+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=eed96dcc159829b9a91ee13a2106b3f8598896f99d7142765276914e628e8109]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('566e4cb4-2828-43f1-af4c-5797a7fd3504', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.868+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 4 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ad17b455-6adc-4f4a-851e-c8fa568c20c7', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:42.871+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ce686662-3fdd-46ec-8961-b22a90ff3064', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:18.212+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('25b95281-bdcc-4a0e-a04d-dce811e53055', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:18.269+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8995cdcc-e329-4b18-a948-c8aea55e0319', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:18.323+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.4.11"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b54579fd-7d58-4896-b7a7-1f1dd0fe0a95', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:18.432+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bbfdc605-8968-48a5-bd5f-aca0bfba600f', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:19.804+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Installing coder/coder v0.4.11...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('16db7ee1-8564-419f-9f37-89611b1095bc', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.202+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Installed coder/coder v0.4.11 (self-signed, key ID 93C75807601AA0EC)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c65e2817-a4a3-4ead-817d-f3762c5f99f6', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.258+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bfe7a100-7f42-471f-a210-b687bda0fc24', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:57.739+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=db4aecde657b126939e8bad412b953314cd1316fe7b3f3d061203d0a71e037e8]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e896bbfe-86a0-4f7b-bf6e-4b848d945cbf', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:57.743+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 1 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('250130a2-19fd-4cce-874f-c74d55aa2f14', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:57.748+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('91616345-1c98-40ba-a4d3-23514865abb8', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 13:04:58.769+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('35036434-b0d7-4d8b-9b2e-2a55fb045bd7', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.44+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('80f1e6fd-8e57-46a9-bcc0-436d9ff34cc2', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.444+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d4aa27c1-8b51-455f-ad37-ef3031e9959d', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.535+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ef4ffdad-1b7c-42e9-9ca4-03a878e8efce', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.54+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('caae1027-94c4-4ce9-a58a-c7629632c763', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.545+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1d890d4d-1b83-4cbc-b4b9-904150e970ae', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.549+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ebe2cf5f-bd32-44e9-95a2-e92fd68e51f4', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.552+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('849e5476-f4d6-42aa-9331-a80a27a12107', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.916+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0c142d37-a1d7-4ba1-b3e3-a2544952099a', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:40.984+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0654054e-9f59-40b2-b899-0b8a8ec3f33a', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.044+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('edc50f19-4bbe-46bf-8f13-292384708095', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.114+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ce618bdf-d2b0-4857-98d4-842d33f0154b', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.12+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('794ea457-7da4-42c0-a960-bf0895541c9c', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.124+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('47d5a9e6-4b36-4129-a746-5611767673cb', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.128+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b23c35f8-a06c-4716-9d6d-1ab79dda11bf', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.131+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('75fc0daa-c636-49da-b635-09bb34b69a20', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.134+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('56702227-afc1-4413-a939-36f521e80d4b', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.137+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('becc9242-efa6-4ed9-a69e-8f4c589529d0', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.141+02', 'provisioner', 'debug', 'Starting workspace', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('37205ac5-6eb1-4773-9def-cfd48cb8ce11', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.146+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b85b9b97-4fad-442f-8662-af1660d73f3f', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.15+02', 'provisioner', 'debug', 'Starting workspace', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('80c19b36-2754-4b72-9b5e-59518b293241', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.153+02', 'provisioner', 'debug', 'Starting workspace', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2dc14d18-0cac-4a18-b7c1-1f3b858db5a3', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.156+02', 'provisioner', 'debug', 'Starting workspace', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d0d6d612-755f-418b-8c2c-d3509a42abd0', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.159+02', 'provisioner', 'debug', 'Starting workspace', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1f466eae-c2b8-4942-a189-07d80f8cd34c', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.162+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cf37bd97-4ae3-404b-8f0a-94a7f2bf9af1', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.165+02', 'provisioner', 'debug', 'Starting workspace', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8000ff14-2939-472d-ae75-ff323d5c02df', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.168+02', 'provisioner', 'debug', 'Starting workspace', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('116ed6f5-9486-45c8-a460-de9491854550', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.171+02', 'provisioner', 'debug', 'Starting workspace', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3e3ba08f-2010-4e24-bbc9-97a0f17ccae5', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.174+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0ebddff5-9fdf-4026-885e-5bfbe81cf837', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.177+02', 'provisioner', 'debug', 'Starting workspace', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1e283699-cc08-47c6-accc-69c1d1579540', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.179+02', 'provisioner', 'debug', 'Starting workspace', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('08c60987-9653-4c60-8d72-60c930581bac', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.182+02', 'provisioner', 'debug', 'Starting workspace', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ad734b46-eb2b-4566-b2d2-b8f5c6a65192', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.185+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ea094a42-52ef-4974-a81d-db49d6dca17a', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.188+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d962bb9b-9ffc-4131-b9e2-4b540a025d20', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.191+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8edcc52f-4242-4c78-b375-eb343d439e2d', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.916+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('33f37088-1e7c-4cfb-b150-5d5e735f6da5', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.924+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('123192aa-9f05-4924-b724-c44928a6034d', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.928+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refresh complete after 0s [id=fe418e81-b8a0-4f69-87ea-a0a597745e29]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('15a7ed53-89f0-43da-af80-9b95649e0697', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:41.931+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=b90547be-8870-4d68-8184-e8b2242b7c01]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3109c750-9158-463e-b1c6-7e8a9d562a54', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-02 13:05:43.883+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('451eda7a-d6a8-464c-893e-78796ef328bd', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:03.941+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6cd03ef3-ca74-4898-b014-3823feef5014', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:03.945+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('be374e41-cf6f-493b-a799-e2f548f940f5', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:04.047+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('351f9dbc-1936-4890-b145-d1644c4a346a', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:04.05+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('040204a2-cdf4-4ee1-9704-7c8ec1fa0374', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:04.053+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('09c75767-3d08-4673-b4f6-eca8fac2058f', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:04.056+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c986858c-c26e-49ea-a011-38e07510dc51', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:04.059+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1e352ba9-9fda-4a5e-9bc6-38baac1ac124', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.453+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('778be809-e832-4518-b63c-b4d4ea9bb24f', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.62+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d2302004-ed2b-4071-bec5-ce9f16446aaa', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.695+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4055c54c-f128-46a1-86f9-ccec28d9cb9f', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.75+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('05cdffde-f37a-4899-97ad-b3954c99fe20', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.754+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('20215593-28a0-4a44-8d23-f990171d6e25', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.758+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('74c22124-ad8c-4c8b-9c38-e074c0a6690b', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.761+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f5df23a6-6461-4b64-bb02-16b4c8a8558c', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.764+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('89564128-9d95-4dbf-bfc9-3e0a3e080f6a', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.766+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e9c32ce3-71f1-4b4c-a269-c8f26b70d2cf', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.769+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9ea0b406-aed4-4dde-978d-0aa184d905ab', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.772+02', 'provisioner', 'debug', 'Starting workspace', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e2c45f9e-f037-41fc-b1a0-3415309a4bc7', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.775+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e70b1f1f-a226-481b-99a7-84ea9df1aeee', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.778+02', 'provisioner', 'debug', 'Starting workspace', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f2724cf1-bbda-40ba-825f-64333171092f', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.78+02', 'provisioner', 'debug', 'Starting workspace', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4727c32b-90e1-4d27-9c52-e782f00aec3c', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.783+02', 'provisioner', 'debug', 'Starting workspace', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('56d15d39-2f3a-4128-9462-109a7c35d3e4', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.785+02', 'provisioner', 'debug', 'Starting workspace', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d2837d78-e7d6-4c6e-a7cf-4083f774a060', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.79+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fd344fbd-5269-4d53-9d24-2f0a3e07b3f5', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.792+02', 'provisioner', 'debug', 'Starting workspace', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('eb228344-c8f8-4ba8-a2f4-b486ff59d8fe', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.796+02', 'provisioner', 'debug', 'Starting workspace', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('192a9ac1-af63-4aca-9dbf-3861ab360ee6', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.804+02', 'provisioner', 'debug', 'Starting workspace', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b6517635-07cc-439a-bca9-a738bae94c53', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.807+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cd3c921e-7929-49e4-b853-7713f7da68aa', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.809+02', 'provisioner', 'debug', 'Starting workspace', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c98500c6-8ce5-4e15-9403-aa97f618141a', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.812+02', 'provisioner', 'debug', 'Starting workspace', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('754568bf-a947-459e-abc5-03e37cb53b5f', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.814+02', 'provisioner', 'debug', 'Starting workspace', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bc0becf0-9184-4fb3-853a-d5e3d6be25f4', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.817+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0b62b0a7-de63-44b1-9a7f-a08210fa8283', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.82+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f3a49bd8-51e1-4a88-8a21-58cec8640e50', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:05.823+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0863b4d2-84aa-43b1-8d52-a13e4ed91902', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.584+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8739d789-e629-4047-9e3a-499eae4c3d8a', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.588+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('790ba241-04b6-4dbc-a703-3aae9f28eae9', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.592+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refresh complete after 0s [id=10c01a50-bec1-446c-b395-5d184fba369d]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1e2e80ff-f1d5-4285-9a4c-6dc918f024a2', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.595+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=2d72d32e-3021-4843-b582-d962fee897e2]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c8c6b94f-4a28-4e85-8c84-df60494cf98b', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.618+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f83f42ae-5671-49b4-9bb0-0fa535fc4d47', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.622+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9725ca37-c56a-4e25-ba87-3eda93cab7cc', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.624+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('73c7ed3c-7753-4823-b7ef-6826edfb7905', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.627+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ed4512d2-c3b6-4368-9291-0be933767557', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.632+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fc3e96db-5178-411a-8282-b8ee8e5db38f', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.836+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b7a50c72-1b48-4c37-833d-76560b60bf4f', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.841+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e87d2c28-3bd0-43ce-8b8a-6aa58264d7ab', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.844+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creation complete after 0s [id=coder-oauthuser1-scheduled-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3741adca-df5c-41fb-9031-7c2e9e8a35bd', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.847+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Creation complete after 0s [id=8841874d-0c5c-49ab-ab10-2c6b8e509433]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1e2bf69c-236a-430d-8824-16b04daaee9b', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.853+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3f6087ff-301b-44c0-a892-88e5523048dc', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.858+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creation complete after 0s [id=86ac90e2-cc81-41dc-a16e-eeca54c8a3c7]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('03e0d14e-d50e-4a91-a845-dd5140cea0b0', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:06.862+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0f701ad8-b85b-4515-aa10-426a9dd532a9', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:07.559+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=031ada2ead4766de08331f05ed2e5f0d674166517757edf1b924886b1359cab5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7dcd63a2-1e80-4927-adca-1b19e6e3f7d4', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:07.57+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 4 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('32909e4c-0dd2-43c2-b231-01314ae83bd8', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:07.578+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ca4907f9-2158-4254-9a70-7366407b0789', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-02 13:06:08.667+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ec5ec4b3-49a7-4400-9085-3dadca04e656', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:52.934+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('97069c13-0085-41f7-b515-144630e3d10c', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:52.945+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bc2dc6d3-e103-454e-a0ea-28e3ee516811', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:52.951+02', 'provisioner_daemon', 'info', 'Parse parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('14bc3811-9fca-427e-8bca-bdf4124c8c42', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:52.965+02', 'provisioner_daemon', 'info', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f38628b1-2b19-4221-9a82-721b4064245a', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.058+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bae7a730-6853-41bf-aec3-df57021ef685', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.062+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2cd32c99-b560-4029-9cfe-eddbb7b169b6', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.066+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('618f2905-ded6-4342-826b-230e3f1b07ac', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.069+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fcd5133c-02a9-45d5-98f8-343c28c192b8', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.072+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('edc4a28a-1a05-4181-b523-3b7866ed47d0', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.214+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3abbd207-79d1-472e-b311-5d12cfa2adf0', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.311+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('055d02e9-70a8-458a-b63f-c9bf055f61b4', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.371+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0d385c88-0c06-4cd1-b69b-23690fa3c6dc', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.443+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('be40524d-3b27-402b-9253-9eb7afd8b3a7', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.447+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('186eacc1-237e-43ea-bf17-747f20277e80', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.45+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('72fea3ac-e12c-4222-9a65-23b303fbde51', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.453+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a51ebdff-8f37-4a2a-9715-139db970054a', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.457+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2ed720c7-8872-46f1-aff2-d637b8ba8f47', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.462+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('72d48510-300f-4155-8ba7-7abeda40e411', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.466+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('234761af-f52a-4b87-9c91-80708bfb57df', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.469+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c1f61684-7229-459f-87d3-52f548675d1e', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.471+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4f76df82-b848-4225-82c1-5e8787258b24', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.475+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('20510fda-a6a1-4999-95db-cc3fb4458f5a', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.478+02', 'provisioner', 'debug', 'Detecting persistent resources', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('577517b0-be37-4fac-b9c8-a91840bfdf13', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.481+02', 'provisioner', 'debug', 'Detecting persistent resources', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('eda778eb-66b5-436a-a576-e6793f41b04b', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.484+02', 'provisioner', 'debug', 'Detecting persistent resources', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b6ba43a9-188a-479c-8200-9dc1771558d3', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.486+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7341e996-a19b-4a5a-a969-f12137c06c99', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.49+02', 'provisioner', 'debug', 'Detecting persistent resources', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3618eb39-3cf5-421c-89be-5f5d8fb18050', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.493+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0c493997-4fea-4e34-9427-66a80b29713f', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.498+02', 'provisioner', 'debug', 'Detecting persistent resources', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8f0eedec-76e5-45a7-96d6-0f6053dd2b7a', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.501+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3bcac134-e265-4cb4-b222-42239602b230', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.504+02', 'provisioner', 'debug', 'Detecting persistent resources', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5baf397f-d719-49e7-9c64-5868ab6867d3', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.507+02', 'provisioner', 'debug', 'Detecting persistent resources', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('11f29f58-7699-4825-9f19-044991e2bd72', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.509+02', 'provisioner', 'debug', 'Detecting persistent resources', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4290e889-0524-4a44-a863-50ca5c995dd6', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.512+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8673bef9-01b6-4012-85f0-405abd2bc018', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.514+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e61d6c01-774f-466f-80c5-d48d9d650659', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:53.517+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5f1cb4d0-6333-40c9-a4f6-35a33707850e', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.242+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9349299d-5e9f-4392-a0a9-bf57b81a486e', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.247+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('03d69f7f-1ba0-4ff3-b165-57644ae74ea0', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.253+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_provisioner.me: Refresh complete after 0s [id=0c2a9b56-6788-426a-b51f-d1020b2f946c]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2b4f8569-69f4-484a-a0ba-274e7c508460', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.257+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refresh complete after 0s [id=f029c2d7-f293-4d65-95e5-fbbec8069da5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2d426394-18e9-4eff-9b3f-7f8ca8212a0e', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.284+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4f281678-1ff4-4a32-83bd-0357f02279dc', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.29+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e0dde379-7983-41fc-ae3f-125adbb7e0a4', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.294+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1359a82f-17d0-46c4-908b-a6623aec532a', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.299+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('46b1948d-b07b-480f-9cb5-94dc56c76414', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:54.303+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c4a04254-ac4e-49b1-9922-18f00beb81f3', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.086+02', 'provisioner_daemon', 'info', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8ac6dfa1-dd6e-48c4-95c9-9d43a3f81fd1', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.169+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e833f596-ecf0-42aa-a4ab-544becc93b2f', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.173+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('53d42646-4d25-4f0a-a90a-2e7344952e04', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.306+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e58bd9b1-03dd-4650-a530-7264f1b77256', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.311+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('13f5bbd4-c399-4896-ad60-3a180a814ee9', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.314+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of coder/coder from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4d5547c9-22e3-4dc2-a13d-ce958cad5d05', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.55+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of kreuzwerker/docker from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fc1acf12-6058-44c9-a7a3-18ec67538272', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.77+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed coder/coder v0.5.0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('04728b40-6184-41fc-833c-e1b1299ce625', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.854+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed kreuzwerker/docker v2.20.3') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('501c8bae-4726-4365-9b94-0e20063d94c5', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.858+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e420f075-e982-4515-b45a-1b6c5aaf79cd', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.863+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6af54ded-f9ed-4bcd-ab31-f5b7d451cbc7', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:55.924+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6c0ffa8a-47ab-4d83-bcc3-63bd9dff7c51', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:56.669+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aa2b789b-f85e-4131-8a31-a8125e4ebaf7', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:56.675+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bf3681f0-adaf-4466-ae0a-4251769947fc', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:56.678+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_workspace.me: Refresh complete after 0s [id=a56ece0a-5fd0-4377-beb4-b863a7b6f643]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('867acd6d-6459-4be3-8b7a-09c912f9a229', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:56.681+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_provisioner.me: Refresh complete after 0s [id=799aeb19-6a6c-4127-bc37-02bd4766cf5f]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5cd3d492-6611-4944-b0b4-87e27dab9376', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:56.704+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bd8ba462-89c9-4a1d-af5a-35d245fe8fc1', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:56.708+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f50d9387-c97e-47a3-9958-2330462d7534', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:56.712+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('44b9aa93-fa16-47f6-92c5-a3e8f6ae2d5b', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:56.716+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Plan: 3 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e267601b-0bab-4dcd-8cf2-01315983e35a', 'f042af17-e3a2-4194-af67-e416302bc860', '2022-11-02 13:07:57.534+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c2f685fa-b49e-46b0-8b49-3499a6c86c54', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.441+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f0b836ba-dd49-42d6-9d2f-c765f676cef7', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.445+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('365e78dd-d03f-413b-9ec2-c254106fc5d4', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.535+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('90b6d5a8-e690-4475-b05e-2c7d599bdb90', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.539+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f7024b37-d4dd-4c4a-9c64-aecff11a47ef', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.544+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('74bf20aa-8f5f-475a-991a-4baa61ac894a', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.547+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c9ef259a-f267-4afb-b401-c247ac3dd3f5', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.55+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6c6de8e1-0bed-4636-8966-502b7adcf530', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.705+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a017a4e0-cbbf-4ea4-bf91-9936ead5d649', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.771+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7f2577aa-cab9-4e9c-82b1-e2b68f1de520', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.845+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5bbb9cf4-69a1-4e9f-87fb-7ddd6bf41323', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.901+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('49732ed2-1526-410a-844a-27fd51afa8b8', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.906+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3ca5f41e-936e-41cf-8ec6-9a322d73102d', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.91+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a11b20a0-5b00-4323-a949-356013d91119', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.913+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8a2e242c-d977-4677-8f6c-e0d264d834e8', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.915+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ad719a38-a50b-4623-a0e1-a47e04d7827f', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.918+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2916ea33-9304-42c9-ae7d-2b965c202eb0', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.923+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('776a479c-8cfa-419d-87c6-9c3ad8a3bd09', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.926+02', 'provisioner', 'debug', 'Starting workspace', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b3a16e4b-86a2-4d4c-8cf4-dc3488c636b9', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.929+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1756b015-3863-46a0-8ce1-756a3db0ab0d', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.932+02', 'provisioner', 'debug', 'Starting workspace', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dfff1eea-4022-4685-8fe9-1dedf12b1bfa', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.935+02', 'provisioner', 'debug', 'Starting workspace', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8bfdd0f9-59f8-452b-a5f0-94cf72ee53dd', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.938+02', 'provisioner', 'debug', 'Starting workspace', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('81e3e47b-bcdc-42f8-9c23-4e3224657961', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.941+02', 'provisioner', 'debug', 'Starting workspace', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0dd5456e-727f-4820-801d-a73196a99db5', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.944+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d1017c48-e1e1-4f6b-85b7-c432ec0c848c', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.947+02', 'provisioner', 'debug', 'Starting workspace', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('32f30546-bb7a-4b25-893a-7740d5028720', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.95+02', 'provisioner', 'debug', 'Starting workspace', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0a9cbe99-0bfc-45a2-a714-91c0fab6959f', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.953+02', 'provisioner', 'debug', 'Starting workspace', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('884b86f8-d32c-4961-a6d2-b74cecc9ef94', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.956+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('07a49cf9-2088-4977-930e-d7019c7fadd8', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.959+02', 'provisioner', 'debug', 'Starting workspace', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0104d747-0c30-40ea-bc37-99d1c5d828b1', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.962+02', 'provisioner', 'debug', 'Starting workspace', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('14d0e06a-920e-48f7-862f-21b26533c2d4', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.964+02', 'provisioner', 'debug', 'Starting workspace', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9327e992-19d6-485f-a783-f069195b39bb', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.966+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e566f0e1-5000-4328-bb26-503933a6cf58', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.969+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a622c794-e3de-4d05-ad21-7d15206a8134', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:07.972+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2c3e911a-0120-4ef9-8bf1-ae38b335f4c7', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.685+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1700402d-473b-4545-ac26-e8c2474ae61e', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.69+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('677e7e30-e7b0-414d-950c-691ece713410', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.698+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_provisioner.me: Refresh complete after 0s [id=ad27e546-76e2-44a1-befc-04e736c7d136]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('de33d989-b4a0-4aca-bdcc-2f709c89badf', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.702+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=b90547be-8870-4d68-8184-e8b2242b7c01]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ae71133b-83ea-4594-938a-619b65a72dbc', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.708+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Refreshing state... [id=6137599d-4ad6-4e58-b0fa-a3d1a88fa5a9]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2c4d3f77-57ab-444e-bcf2-47c0d334071d', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.713+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Refresh complete [id=6137599d-4ad6-4e58-b0fa-a3d1a88fa5a9]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('08e41e5a-92cc-4593-9a76-fe7aedb89136', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.716+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Refreshing state... [id=3a585bc7-75e6-408e-b0bc-dc64e4d3be0a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b6e2db47-d7ba-421b-bb19-8efb34e15041', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.718+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Refresh complete [id=3a585bc7-75e6-408e-b0bc-dc64e4d3be0a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('da66adc5-7955-4efa-ae4e-921d89a0a905', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.721+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('86b81dc3-345e-4032-91ca-e179d2f68426', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.724+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c16e6dd4-8590-4267-8d86-86469c58bd38', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.727+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Refreshing state... [id=eed96dcc159829b9a91ee13a2106b3f8598896f99d7142765276914e628e8109]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f029d62b-fa15-41dd-a55b-56de56aa9d2d', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.845+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Refresh complete [id=eed96dcc159829b9a91ee13a2106b3f8598896f99d7142765276914e628e8109]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d420d06e-a470-491f-b77a-76e9efcfd885', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.88+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f29b2f5a-5b30-4450-808d-57633ec9eee1', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.884+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dd638547-02bd-4f94-8e3a-706d8c4bbb4d', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.887+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9733a541-f554-45fc-b9e6-8449d0a7268d', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.891+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to replace') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1442786e-4ac2-4a31-bf01-62f71ee1c58f', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:08.895+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 1 to add, 0 to change, 1 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b73e9a9c-2a80-4edc-b9c9-caed1f8fb76f', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:09.092+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Destroying... [id=eed96dcc159829b9a91ee13a2106b3f8598896f99d7142765276914e628e8109]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('26bb15bd-55f5-40af-bb5f-68276cdc547c', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:09.315+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e8dd9645-1e6c-4620-a2b4-db13e3591672', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:09.334+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('27a857d3-fae3-4e7b-92f3-ba66651415fd', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:09.838+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=86d859b12b6519160d53b99d4f0155bf6aeeefbd33d88fe93e2eecef22eb65de]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6b755e4e-7e2e-407d-874e-2b9d94636d1f', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:09.846+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 1 added, 0 changed, 1 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d7858aaa-6fa7-4673-9ff2-1b2347088c64', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:09.853+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('43b1ff4e-b1d2-45bf-aced-0d209ae20ae6', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-02 13:08:10.807+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('567776bf-1821-4c52-80ed-3fce709d0c85', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:51.94+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('36b8be4a-a30c-4de0-8896-14406d6cfdb6', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:51.949+02', 'provisioner_daemon', 'info', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('80f21094-54a2-4756-a837-25df3ddc10bd', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.042+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e4a9be07-5e4a-402c-a32c-5d2be759063f', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.047+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9b30655a-31d0-4cb5-a2d1-c55de3a4f7db', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.051+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b66c4596-da28-4f0c-857d-d22ec01a659e', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.054+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f78aef35-c5b0-4ca1-bba3-1ed73c00d2f5', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.057+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5128de3f-c94a-498d-aac0-690fb3a3256c', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.203+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cb707f76-a1ce-4411-998f-492ab315f9de', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.276+02', 'provisioner', 'debug', 'Stopping workspace', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b6ba27e3-22c5-4585-ab89-9a122daa2ed2', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.352+02', 'provisioner', 'debug', 'Stopping workspace', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('155e3a4d-e37a-4443-9609-94ea25793182', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.407+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('803c0af2-6bee-4dd5-bca7-088ccef48d0d', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.411+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b045cf9c-4a31-42df-a157-36799cc1505e', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.415+02', 'provisioner', 'debug', 'Stopping workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('96af3253-66fd-4e6f-8a02-9aaa2ed840e1', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.419+02', 'provisioner', 'debug', 'Stopping workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a577318f-cd80-46e2-9dc2-e96ddb958fb6', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.423+02', 'provisioner', 'debug', 'Stopping workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('918e8d10-6929-43ff-a417-e835a05593b5', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.426+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('82a34d3a-ff5d-42a4-9734-c369e56ce5c8', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.428+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f7cb10b8-9c51-4f23-afbe-33b20842feef', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.434+02', 'provisioner', 'debug', 'Stopping workspace', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('77119d73-aa08-4d6a-b2a9-5a876cc38f10', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.438+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('77ba3339-32b2-4c0c-9dab-347a75457e1b', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.44+02', 'provisioner', 'debug', 'Stopping workspace', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('378e1d98-148e-4ba4-861e-9eba8d7f1f79', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.444+02', 'provisioner', 'debug', 'Stopping workspace', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('305ed411-809f-47e8-b5fc-36ab80d51862', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.446+02', 'provisioner', 'debug', 'Stopping workspace', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b2b3030f-f923-4c11-a0b5-3f88673f174c', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.45+02', 'provisioner', 'debug', 'Stopping workspace', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('72495cac-fb10-4a5b-ba56-e5720fdcbe80', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.452+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aa63292e-da72-4ad2-837b-4b7d09ca8352', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.455+02', 'provisioner', 'debug', 'Stopping workspace', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7d402a33-e901-481a-a4b0-7975bc710884', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.457+02', 'provisioner', 'debug', 'Stopping workspace', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('26f48c94-98cd-4ab4-a7c9-92b51c559e50', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.46+02', 'provisioner', 'debug', 'Stopping workspace', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('425de025-c374-4359-bb84-36d08b1f045f', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.463+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f0a06046-0ed0-4d43-8608-8ede7c923a9f', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.466+02', 'provisioner', 'debug', 'Stopping workspace', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c8eae175-6b93-44d7-86d9-acd10e5d9257', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.469+02', 'provisioner', 'debug', 'Stopping workspace', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a186dc9b-c58c-48ed-90e8-5ff3d4049dac', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.471+02', 'provisioner', 'debug', 'Stopping workspace', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f47f6907-04cd-4ada-b7df-7bb27032d429', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.474+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('237bad3c-59c9-4d7e-9860-922c85106edb', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.476+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0aeca511-4a7b-4151-a806-525e03e842db', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:52.479+02', 'provisioner', 'info', 'Stopping workspace', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('66abfda2-7009-4d13-bb84-24ab857b3404', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.226+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e1073aaf-e53a-4e28-a771-66a273731128', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.231+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d388445e-b43e-4f8f-a866-66639edcb087', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.236+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=b90547be-8870-4d68-8184-e8b2242b7c01]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1726c68b-dad7-4cbc-bf24-6a6578f50edd', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.244+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_provisioner.me: Refresh complete after 0s [id=58ea2d09-993b-4754-8c7d-0c0ec944e2ee]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0331dcb4-8497-4b49-b823-be547e2fb19e', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.248+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Refreshing state... [id=6137599d-4ad6-4e58-b0fa-a3d1a88fa5a9]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('668a90d0-12e9-4aea-af6f-5c50324ebb1d', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.252+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('656ab85b-4184-494e-8a57-891b3343bacb', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.254+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Refresh complete [id=6137599d-4ad6-4e58-b0fa-a3d1a88fa5a9]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e521fb3e-c3d3-4e07-b7d5-d23a14735f3d', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.257+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8b6e20ee-cd76-44f0-a361-24e3b91ca966', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.261+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refreshing state... [id=3a585bc7-75e6-408e-b0bc-dc64e4d3be0a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7a5cb85d-85d5-4e4d-9bac-6b71b17a31a7', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.263+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refresh complete [id=3a585bc7-75e6-408e-b0bc-dc64e4d3be0a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('61a50656-1299-4920-8cfe-a3d496fb7601', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.266+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refreshing state... [id=86d859b12b6519160d53b99d4f0155bf6aeeefbd33d88fe93e2eecef22eb65de]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c748eb20-3d36-4dd1-9d67-94f187845e60', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.377+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refresh complete [id=86d859b12b6519160d53b99d4f0155bf6aeeefbd33d88fe93e2eecef22eb65de]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('11300863-799e-4a8d-9d4e-e816fe59f8d0', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.388+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('148f401b-202f-495d-a00d-3edaf2d98b54', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.392+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('518cc0ce-b6fa-46af-be96-7eb0745832c9', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.395+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('abdc6fea-3ecd-444c-b0b9-a0c5c7b04bd5', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.399+02', 'provisioner', 'info', 'Stopping workspace', 'Plan: 0 to add, 0 to change, 1 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('098266ee-37b3-423b-a915-1eebed4a9382', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.51+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destroying... [id=86d859b12b6519160d53b99d4f0155bf6aeeefbd33d88fe93e2eecef22eb65de]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1dd3c1b5-aee2-4c3c-a43b-98abf577daee', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.752+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('785540dd-ba37-4111-900a-e63fe74c80c3', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.763+02', 'provisioner', 'info', 'Stopping workspace', 'Apply complete! Resources: 0 added, 0 changed, 1 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1dd9d93f-3497-4fd4-acd5-676807a332a6', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:53.769+02', 'provisioner', 'info', 'Stopping workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ae1db4e6-6f61-4e96-86a4-90869cdfd4eb', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-02 13:09:54.754+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5ff779e3-9dd5-48a0-a5f3-a7a80d029807', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.44+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('59a25c28-c558-4571-b853-bee95d5fb22b', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.444+02', 'provisioner_daemon', 'info', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9a497a9b-63aa-4424-bcc8-92ffc1dd1259', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.534+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('672df058-dbd9-4eb2-ab8e-21033b6104c7', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.538+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2c9dccb2-41d0-40bf-bcc4-04d77075474f', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.542+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4168300f-5094-4235-91b4-6b3b4777f3ef', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.546+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('12c537a5-d863-4fe3-8b04-9ba93d749a64', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.55+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding coder/coder versions matching "0.5.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e9be6d15-d900-47a1-a2af-9f1f51b3644c', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.156+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0a588339-f93c-4a54-9655-59e4fd30f49e', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:42.821+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding kreuzwerker/docker versions matching "~> 2.20.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0b21faa5-29a9-4b78-8a5b-2afd05d250eb', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.027+02', 'provisioner', 'debug', 'Stopping workspace', '- Using coder/coder v0.5.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('47176b70-e029-4b88-9ba7-4b19781da315', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.086+02', 'provisioner', 'debug', 'Stopping workspace', '- Using kreuzwerker/docker v2.20.3 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5e4e0615-2c20-43cb-92a4-ae92a29e8281', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.313+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2692d379-7215-4abd-89c4-e26f033256ad', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.421+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Partner and community providers are signed by their developers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('20799ce6-3df7-49fa-97c1-ac425bafd244', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.476+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you''d like to know more about provider signing, you can read about it here:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('274f72b7-6ba6-4d18-9605-7ffcc42d77d8', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.533+02', 'provisioner', 'debug', 'Detecting persistent resources', 'https://www.terraform.io/docs/cli/plugins/signing.html') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('40a8fd15-c9cc-4f39-9cfa-ca14beb39147', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.589+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('025e7a35-8245-4224-9cb7-087b66a79c22', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.644+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9989f0c7-baed-4e6e-b8a3-e0d67a07937a', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.697+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('af6cf6a4-6e73-4c9e-9766-11bb6b3c3f57', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.753+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2d6e1b09-8cc2-4faf-9cf1-c2b61fc984f3', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.806+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a98a888e-e2d3-4aa0-bffa-de6eea780fcf', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.913+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b4719275-e25b-4d6d-a077-12b8e8532f57', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:21.966+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dbce4f85-c1c1-46ba-a70a-afdc89a62bb5', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.021+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f7eead7a-7406-4beb-b6f7-68d0d7f587be', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.077+02', 'provisioner', 'debug', 'Detecting persistent resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e7b9930c-50f1-4bb4-b99b-537f04b198de', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.132+02', 'provisioner', 'debug', 'Detecting persistent resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b428d1b0-b1c6-419f-9a50-de9031f5afd5', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.188+02', 'provisioner', 'debug', 'Detecting persistent resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a5c97e13-23e9-4ca8-8085-0b6bd5e50001', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.242+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c56ca150-b224-4990-875d-46e3fe1cca73', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.298+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dc5c8088-ef28-4447-974a-2cc969ac9888', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.406+02', 'provisioner', 'debug', 'Detecting persistent resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5b389409-506f-4797-b9d2-8ac02d980a7c', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.464+02', 'provisioner', 'debug', 'Detecting persistent resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3edfb84e-5d4d-426e-8f90-c3ec01b6df4a', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.519+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.2.1') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('50304f85-f044-4e6b-9db6-c6aca13cb5d8', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.573+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8a457bb2-0ac6-47cd-b4fa-0d34dee9e4e9', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.626+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3df25906-825b-4bb2-a6ed-c017465fd7a4', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.68+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refresh complete after 0s [id=ded48cd3-3cc9-465d-971b-79f78d282825]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('12886518-3a63-4168-9e29-33a1dba8bdaa', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.734+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_provisioner.me: Refresh complete after 0s [id=508160fd-1540-4d23-b3f5-4c5ae190f197]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('08122d4e-aa21-4854-99c3-67928d05373e', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.789+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('476a13ad-3f22-418d-af1e-7583c9b7d7d4', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.896+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e41eee4c-a37e-410e-ba0e-e9a3a7c1bda5', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:22.951+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7407c0a6-cc4a-4139-9d14-09167c6b9aa2', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.006+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_image.coder_image: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3cb6a883-a682-4819-a639-340836b99f88', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.063+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6cc54eff-098f-4d09-a511-493492eb0151', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.123+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_metadata.container_info[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9da4a076-f332-4cb0-be9a-2d736c97d35d', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.179+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 6 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5a911201-c6dd-4e69-be04-edd908cf4fac', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.236+02', 'provisioner_daemon', 'info', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('12110688-fa67-4717-9f3f-5ab558c9a303', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.431+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('755b7db1-83bc-4180-959f-aa5ce6ca1033', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.487+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9dbdb1c4-bf97-40e3-8466-15922eabcd20', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.56+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3c27d280-154f-42ee-90ed-805f5bd03c1a', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.615+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5b2e4b87-101e-4952-a2cd-9c0ab7792954', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.671+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of coder/coder from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('52e28334-c0ed-4626-b677-15f5eac6770a', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:23.811+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of kreuzwerker/docker from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ff665da5-673f-401e-86aa-8036ad552a72', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.029+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed coder/coder v0.4.11') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('09584bf2-56d0-4cc4-8304-710deb89cab5', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.102+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed kreuzwerker/docker v2.20.3') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9c8f0949-383b-420e-9b4e-db6e24192b02', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.32+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8ad626d7-47b3-4505-99d2-7f37ac4e5390', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.431+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fe62cf44-b5b7-4e70-ab85-2c3b19a3ce2d', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.485+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('326be288-4a0b-4de0-82fe-807a8341e8ff', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.539+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6984d129-7d64-405b-b0f0-92b92d7326c0', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.593+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0261a3ed-3840-4ed3-bb52-485c6fdffd64', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.647+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('584d8ca4-b7ff-43a4-ac68-c143c99f67f3', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.701+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fa65ad97-93cc-42ed-b11b-8e03d4b83830', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.758+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Terraform 1.2.1') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('521abcf3-a9f7-4235-8720-1d919e4bd60f', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:24.975+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('eb7b92a8-fdcc-475b-88da-8b2e1c4c7a57', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.16+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c7b928c0-f6fb-4d4d-836a-8ff389bf8aad', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.163+02', 'provisioner', 'debug', 'Stopping workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ed8116ca-5692-48ba-bc64-359bec1f54a6', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.166+02', 'provisioner', 'debug', 'Stopping workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('19e91c08-0342-4c21-8a23-8690b567a3bd', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.168+02', 'provisioner', 'debug', 'Stopping workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c1144133-37fa-4715-9e1d-4301287ef9e7', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.171+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f454b157-5e4d-45ac-83a6-aaceb242af1c', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.173+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('78ef1dfb-8de7-4c09-9775-9ac2b0c8fccb', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.176+02', 'provisioner', 'debug', 'Stopping workspace', 'Warning: Incomplete lock file information for providers') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e17bda0e-e339-4f28-87ad-af15ff5103c3', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.179+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6ae8b6b5-7817-414d-bf79-dd6f78a9db26', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.182+02', 'provisioner', 'debug', 'Stopping workspace', 'Due to your customized provider installation methods, Terraform was forced to') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e3e90d48-336f-4d41-a90b-cc569633e5d4', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.185+02', 'provisioner', 'debug', 'Stopping workspace', 'calculate lock file checksums locally for the following providers:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('615327b8-8a02-4afc-a6be-a4e2d0758ebf', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.188+02', 'provisioner', 'debug', 'Stopping workspace', '  - coder/coder') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c30bc373-2667-42e7-aed5-bac2907c1813', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.19+02', 'provisioner', 'debug', 'Stopping workspace', '  - kreuzwerker/docker') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c7a73bc4-1d99-4230-89c5-be15c70db5e3', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.195+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fa365813-ac49-4cb7-aaeb-a9344156b73a', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.198+02', 'provisioner', 'debug', 'Stopping workspace', 'The current .terraform.lock.hcl file only includes checksums for linux_amd64,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e501ee90-28bd-4d20-ad99-12a09fe8287e', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.201+02', 'provisioner', 'debug', 'Stopping workspace', 'so Terraform running on another platform will fail to install these') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f4708ad7-013b-4149-ba57-8d30f8198142', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.203+02', 'provisioner', 'debug', 'Stopping workspace', 'providers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fa4f0229-187c-4654-aff8-6cee50c6720e', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.206+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0ccf37bd-877e-464c-9931-97564752f445', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.21+02', 'provisioner', 'debug', 'Stopping workspace', 'To calculate additional checksums for another platform, run:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('64242d19-9374-45e3-a46c-17833470e20d', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.212+02', 'provisioner', 'debug', 'Stopping workspace', '  terraform providers lock -platform=linux_amd64') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('027cb177-34fd-4137-91a8-f0b63c0ae8f1', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.216+02', 'provisioner', 'debug', 'Stopping workspace', '(where linux_amd64 is the platform to generate)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fd28c560-d002-4f4d-947e-75a9dd98ae71', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.218+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('35ad66c7-fd53-49a8-8a08-993abb9dc471', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.22+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2d4d5e8c-2eea-42ba-8aea-2f250af13f8f', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.222+02', 'provisioner', 'info', 'Stopping workspace', 'Terraform 1.2.8') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cf9cb3ab-8af9-4b34-8500-02979c138c4e', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.952+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8537a20e-b447-423e-8f68-24b53582c88c', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.957+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('989116f5-b114-4df4-9b4f-62417b12cdd5', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.962+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=2d72d32e-3021-4843-b582-d962fee897e2]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('33440676-d562-4284-8496-e9be767976de', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.965+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_provisioner.me: Refresh complete after 0s [id=a9bb9c27-a53b-4524-821b-64d3bf2da47c]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3ea2e134-018b-4291-b9ca-d7db05a6a127', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.969+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-scheduled-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('45d2a1e5-73a5-423f-a0bb-43a4fc49f457', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.972+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Refreshing state... [id=8841874d-0c5c-49ab-ab10-2c6b8e509433]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('71910cc2-83f8-4507-856b-7a95de0ec6f8', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.975+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-scheduled-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('96f27f81-0b5c-49b0-9b69-18ab9bd71d74', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.978+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Refresh complete [id=8841874d-0c5c-49ab-ab10-2c6b8e509433]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6f7ec6ad-1f57-44b9-b1d3-d23e26ceca6e', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.982+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refreshing state... [id=86ac90e2-cc81-41dc-a16e-eeca54c8a3c7]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('13d86e02-e7ab-4390-a80b-dadee7fa8146', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.985+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refresh complete [id=86ac90e2-cc81-41dc-a16e-eeca54c8a3c7]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('214603da-529f-42e5-964d-77e91c92940f', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:43.99+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refreshing state... [id=031ada2ead4766de08331f05ed2e5f0d674166517757edf1b924886b1359cab5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('52409cc8-c6ce-4d8d-8c53-dc3e3734ae17', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.11+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refresh complete [id=031ada2ead4766de08331f05ed2e5f0d674166517757edf1b924886b1359cab5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('957979e1-7611-49f0-8756-d7e2a4eaffee', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.125+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.main: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d364a7e6-249c-4fd9-a041-3854b03388f9', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.13+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('27daf314-7f00-435d-8fad-f037882392bb', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.134+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('736b42be-7b2a-4f91-8676-37e12f2ca6f3', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.137+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0bcd3cbc-916b-417e-96c2-afb5e83c9f3c', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.14+02', 'provisioner', 'info', 'Stopping workspace', 'Plan: 0 to add, 0 to change, 1 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('deba29f1-462d-4e70-a6e7-ca2cb8ac5b70', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.257+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destroying... [id=031ada2ead4766de08331f05ed2e5f0d674166517757edf1b924886b1359cab5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('118af4d6-67f3-4906-9585-4b4f1cdefc57', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.579+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destruction complete after 1s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c257a4c2-83f7-45b4-ae42-652a93547b51', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.592+02', 'provisioner', 'info', 'Stopping workspace', 'Apply complete! Resources: 0 added, 0 changed, 1 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('825b93e0-a4fb-4807-9570-2190eec03ba7', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:44.595+02', 'provisioner', 'info', 'Stopping workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7ebd786a-4c6b-4d81-b66e-c70912ac2036', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-02 13:10:45.612+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('08aaf111-e1b9-4578-a295-0659a00ce4e4', 'ef8d15e3-0cab-4e83-b576-9fd27a680217', '2022-11-02 13:30:30.161+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c16148df-ab4d-41cd-b733-8e1170715fa1', 'ef8d15e3-0cab-4e83-b576-9fd27a680217', '2022-11-02 13:30:30.219+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('17ac067b-20a8-4911-97ec-a583b53f074b', 'ef8d15e3-0cab-4e83-b576-9fd27a680217', '2022-11-02 13:30:30.281+02', 'provisioner_daemon', 'info', 'Parsing template parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2105d809-1538-42db-a156-4344cffcc9db', 'ef8d15e3-0cab-4e83-b576-9fd27a680217', '2022-11-02 13:30:30.399+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('309501bc-b8be-4127-a2a0-1425aa815ff7', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:35.157+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f77f1eb0-ddde-4111-9311-fa48b72bffd4', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:35.215+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('89419a54-0b28-4eeb-af92-ed8a8cdc54a0', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:35.274+02', 'provisioner_daemon', 'info', 'Parsing template parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('84fd87e3-a8ba-43df-af7d-e22575f6bf84', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:35.4+02', 'provisioner_daemon', 'info', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('714e1c53-566a-4217-bec4-7153e139b422', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:36.351+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8f24c724-5f62-4ddb-a889-f8a589b5ca47', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:36.407+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('655b9d17-2a33-4f5e-a735-f321a5ab30fc', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:36.462+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1e0cec81-714c-4060-a9a6-7e97e3f91f5d', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:36.518+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e9720649-c22b-4d9a-b572-c6e93f793a01', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:36.575+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9b8ef3db-8042-45ea-90bd-ca93a73e678c', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:36.631+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aa63f6ab-20e2-4e3f-923c-dd84dcea1bd4', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:38.129+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Installing coder/coder v0.4.2...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e612efb2-3963-4450-bbac-93dbad0008f7', '1fca6797-88f0-4772-9873-b2a6e6a0bf16', '2022-11-02 13:30:44.657+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bfe77826-5dba-47cc-8db6-5c0b7f1e3098', '1fca6797-88f0-4772-9873-b2a6e6a0bf16', '2022-11-02 13:30:44.715+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fbbab363-f785-4233-978f-5d0ef44a360c', '1fca6797-88f0-4772-9873-b2a6e6a0bf16', '2022-11-02 13:30:44.77+02', 'provisioner_daemon', 'info', 'Parsing template parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f8b61b54-4306-401b-83f6-a62caa916198', '1fca6797-88f0-4772-9873-b2a6e6a0bf16', '2022-11-02 13:30:44.892+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3dfede83-3935-460e-8ef6-5b62f6a9e896', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.157+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('db5fbb84-16ff-4c5d-abd2-d47490b48655', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.216+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5059eef8-da48-48b8-a287-2c3a2f226d40', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.272+02', 'provisioner_daemon', 'info', 'Parsing template parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0da96469-f574-44af-a09d-ef90f6f6d69e', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.389+02', 'provisioner_daemon', 'info', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8f34d0ea-b976-4ec0-8fda-18abfdd8fa73', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.527+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('389b22ed-fe21-4969-aef2-0ac956a830d8', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.583+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d24cda2c-79c9-4ede-9bce-4475a848494e', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.641+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('32d35097-1e41-4381-ac87-a7fdfda6daa2', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.699+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b8c72846-53f9-4769-9545-5b081ab38fae', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.809+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a3998678-c746-4de8-af4a-7dd92a6e8507', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.866+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3e31f6e5-98f7-48b0-be5c-edafe25951f9', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.922+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('082f653a-09ad-4481-8595-92cdcef546ea', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:33.977+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('343bb796-1517-44aa-9097-4747cc01458e', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.032+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('22eb1097-3051-43f7-94ac-68e38571dd9d', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.089+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('440c7cfa-d7e6-4a48-b999-2b555af02ed2', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.144+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7cf0cf1d-60c3-47fd-b1fd-9cfb1386ca4e', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.2+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e3a3bf1d-ff68-4b66-b346-222d0db1a104', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.255+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c2aeb3c8-d56d-4e7f-bdab-e0fcb3348b9c', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.365+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('feea5c7c-df1f-49e6-a715-7a09b16686b5', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.419+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2b18f95d-a341-4543-984b-d78648a7deb3', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.475+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0142940e-0cfc-462f-8941-4f78256912c3', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.53+02', 'provisioner', 'debug', 'Detecting persistent resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('83e8aeed-6ee5-4314-91d4-d598338e1595', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.587+02', 'provisioner', 'debug', 'Detecting persistent resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7e5f9220-211b-43e8-8c82-d8198bad66ae', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.644+02', 'provisioner', 'debug', 'Detecting persistent resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f0871504-2506-4a08-9472-7be9298c336d', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:45.663+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('020a4c92-e6fc-490c-b53b-a1c394962a0b', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:45.72+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7bfa0b1c-89b0-4712-b51d-452d27cd5510', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:45.87+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('16526bb5-ec63-48e8-b1b3-82c201688b3c', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:45.926+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3fb86eba-da02-4016-87ae-f7cb252098d6', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:45.982+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d124e74f-6ebe-44f3-a310-eaa3a31a3866', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.037+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('12f7f35a-55d3-43e9-bed6-706f756c7f25', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.093+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3fe516c4-610f-4bae-923d-199989e5f933', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.156+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a444f736-e314-435a-97cd-b6503e632510', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.22+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2778b4ec-48fe-444c-be29-c081b45a653e', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.322+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6a57b888-7ad2-44b4-aa17-7902c4159ba5', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.376+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('efaf4783-84d7-46cb-92cb-d1a741115e2d', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.432+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8e270c35-b098-4dea-89d9-cba881cca6b4', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.491+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7ff50755-c48b-4ab6-8787-e6e245ad83bf', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.545+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('efb438be-4775-496e-9321-66712c6e1b0f', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.6+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6c866136-8635-4347-bceb-b014f52c3c93', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.657+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('366be1d9-caf8-4bcb-9b9b-b4429fbcd443', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.713+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6c773648-484b-43ac-9167-c2d36ec803f2', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.82+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0ad20b3e-380b-49aa-b5b4-570f1833abac', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.876+02', 'provisioner', 'debug', 'Starting workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7c4b48ce-310c-4c5c-8940-0b708ed343e5', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.932+02', 'provisioner', 'debug', 'Starting workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6855f047-e6c5-47f1-8584-5f0842c097c6', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:46.987+02', 'provisioner', 'debug', 'Starting workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('352ebcb0-1862-47c6-9ba7-3ae666be4854', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.041+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('07fced5b-e7ec-4dc5-be83-f27455b96775', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.097+02', 'provisioner', 'debug', 'Starting workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6ac87ca7-9ee8-46ef-906e-ec684d76099c', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.153+02', 'provisioner', 'debug', 'Starting workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6871a5af-b4b6-4ac4-8e26-b02e4c68f843', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.207+02', 'provisioner', 'debug', 'Starting workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b38b264d-4b34-4bbc-9bd4-0fba8acf1b03', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.264+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('711ecc1c-e579-49bd-862f-3a44ef70212e', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.402+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Refreshing state... [id=6137599d-4ad6-4e58-b0fa-a3d1a88fa5a9]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3d68953d-959b-4ddb-afe7-a1cfc3a63d2e', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.458+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Refresh complete [id=6137599d-4ad6-4e58-b0fa-a3d1a88fa5a9]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('925fe64b-55d2-4d52-83cb-2dff9f58b937', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:39.616+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Installed coder/coder v0.4.2 (self-signed, key ID 93C75807601AA0EC)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1bafc5d0-a7fe-4220-8ed8-6a58fccac41c', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:39.672+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ce81a420-50a9-41bd-a22b-46d855fd409e', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:39.729+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('07288c46-7e9b-4eda-b3ee-3c1ba96f9efa', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:39.838+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Partner and community providers are signed by their developers.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2bcf0747-0907-41d6-b32a-e20477755d47', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:39.894+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you''d like to know more about provider signing, you can read about it here:') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('52ebdd20-6e94-405b-94b7-d5ca080df91f', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:39.948+02', 'provisioner', 'debug', 'Detecting persistent resources', 'https://www.terraform.io/docs/cli/plugins/signing.html') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('87c2972f-0131-496f-b842-98c2d215f570', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.004+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b889ef70-1c76-4f11-b3f0-6a8a7b31fe56', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.059+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('62b5485a-21f1-4ffc-889d-08e4456eb2ef', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.114+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c13f785d-514d-44ee-8e58-7874d53b28c1', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.168+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7966af02-dbce-4557-bab6-eee688eef84d', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.279+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4a186600-10b9-4706-97cd-98e5971bd388', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.336+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9237d40e-d814-467d-9e39-286dc8b78645', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.391+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b48a02cd-baad-48a2-8ee2-445ec38de707', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.448+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('12b75a29-9509-44d2-8700-26d03a16d703', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.506+02', 'provisioner', 'debug', 'Detecting persistent resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('91d0e0bc-46ed-411a-bc69-3eb479df07a9', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.564+02', 'provisioner', 'debug', 'Detecting persistent resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1ed20603-8f3d-42bc-9177-f5805c2f8fab', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.625+02', 'provisioner', 'debug', 'Detecting persistent resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6758e387-6975-4794-b145-328b52ce57b4', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.682+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5637ecc3-936c-4d23-bce5-4ced0227a5a1', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.739+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c16b104e-1cfa-4440-be6c-c657e28bbe42', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.85+02', 'provisioner', 'debug', 'Detecting persistent resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a16c3335-dde5-4646-bec5-3d6743d60566', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.907+02', 'provisioner', 'debug', 'Detecting persistent resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('15d7a94c-283b-4c51-a543-2bd2003eba90', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:40.965+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e8ef77cf-45a2-4a7c-9247-81ef62391b64', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:41.022+02', 'provisioner', 'error', 'Detecting persistent resources', 'Error: Error initializing Docker client: unable to parse docker host ``') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('569105ae-781b-421d-8a11-81b4de0390c3', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:41.079+02', 'provisioner', 'error', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('58d57997-45a9-4080-9d5f-1e6383fd8ea2', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '2022-11-02 13:30:41.136+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4eba9a81-a337-462f-920b-8cde54bac2e4', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.703+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('39868a43-1b0c-4749-a1bc-6d2dad2c4680', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.811+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('50fb67d5-553e-403d-b62a-123db2c23359', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.865+02', 'provisioner', 'debug', 'Detecting persistent resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('357dd1fd-0115-49d8-b131-9b42a2cb3b44', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.922+02', 'provisioner', 'debug', 'Detecting persistent resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b17fa07d-21ce-450f-801b-63cb0f8c1bad', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:34.978+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('867d43d9-edb8-4722-86b7-f9e1864b07fb', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.034+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4189786c-10e3-4dea-8714-999f593c1a2a', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.089+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c4c31b0b-5744-4777-b247-9f9da08b9b87', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.145+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('67045d21-2290-4631-b5cd-c144c57d851b', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.201+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0ff838e6-bb7c-428f-83d2-9b50d4d8590f', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.309+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1663deb0-a30a-4d88-b2ac-6ea43ae9914e', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.369+02', 'provisioner_daemon', 'info', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bdee16bc-ac06-43c9-824a-8c3e1c853116', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.52+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4a7e8785-b580-47af-a02d-43e5ba591adf', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.576+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2ac15fe9-3a86-4b3b-8dcc-1e5d68437c72', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.636+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('baed8fad-c0e7-42ab-a7c9-a3c06820a30b', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.694+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('46bddf62-beda-4307-81a0-414bbc83415f', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.749+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of coder/coder from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('85d43314-6751-4967-9818-948e04250bb9', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:35.887+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of kreuzwerker/docker from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0244fc03-2a4d-4b68-bd1c-74da7c3b036c', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.137+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed coder/coder v0.4.2') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c46c13bc-7a46-4b24-8be8-1e26e62e7991', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.202+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed kreuzwerker/docker v2.16.0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0b0005bd-ce82-44b7-8301-788629052467', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.302+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2a117d61-a93a-4044-b6e3-9888b93e27e8', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.357+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('25974505-1e88-430d-ac26-b5bb66f149c1', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.412+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5a1f9bdf-1750-442e-9723-3f43566c06ff', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.468+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('63a02398-0a09-4d7c-a450-6efe1b4217c2', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.522+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c8cd997b-1a2c-48aa-b1b1-2f6a4d1888f0', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.577+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0775464e-faf2-47dd-9e70-fc51819401df', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.632+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('34c5d383-cb47-417b-b238-972b14042118', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.689+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('94393998-1d09-44d5-9326-564803b12f7b', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.745+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9ad15399-fd71-4d81-80eb-2eb22d901b89', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.404+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f3c3e88e-011d-40db-82e5-20ad6ac770fe', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.854+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c480479b-8b2c-491e-94f1-8760c7ce47a1', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.908+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c3db56fa-5cdc-4983-83db-219a17e5a8e9', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:36.964+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bdcd4f9b-437e-457f-abbe-628f129b50c8', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:37.019+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('daffe0b8-cfbd-4071-b760-bc28f836d1c7', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:37.075+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('49373393-9df7-4b4f-b8aa-d2add083d544', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:37.13+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Plan: 3 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d02ac9c3-b8a0-491e-9381-7f6c3e054f48', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '2022-11-02 13:31:37.533+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b314e40a-f246-4151-88e3-84c7dcfd2e07', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.108+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Destroying... [id=3a585bc7-75e6-408e-b0bc-dc64e4d3be0a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ddaf4f4b-8210-4467-9257-046513e938a3', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.162+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2b156516-07e6-410c-8b4e-1d174f5a0054', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.226+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Destroying... [id=6137599d-4ad6-4e58-b0fa-a3d1a88fa5a9]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('790299ac-8364-45e1-ac64-dcdbcf3b8521', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.283+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1926b12e-055c-458c-b9a4-37c708fb1762', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.394+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('831a76e1-35b6-4b63-bcdf-767f9c9ba1b8', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.451+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Creation complete after 0s [id=3e6b9490-1b41-4939-9b01-895076085bb5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a31fbca9-debb-47d8-b101-658459ef4d98', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.507+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('11a0df14-1860-4f2e-8457-19f6c10b447d', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.564+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creation complete after 0s [id=0c1e02cf-43be-47cf-a012-0b98168dfd48]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0d8fd8da-7045-4008-868f-858c8ac7cbb8', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.625+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5a67b713-e5ac-4c99-ae14-4c505ec6a1c1', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.031+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_provisioner.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ef1798fb-adfb-4fc5-a7cc-d60583e3c445', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.087+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_workspace.me: Refresh complete after 0s [id=d2fe6a33-e87c-4c0b-95f8-854ba0546287]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('102bed64-064a-453a-b6eb-dc2965ab5539', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.143+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'data.coder_provisioner.me: Refresh complete after 0s [id=74c1cdd2-c7f3-45a5-8ca6-45ec90676254]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3fd3f1e0-cc42-4ec8-8521-722f3576fde7', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.198+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1f99d65a-7ed9-4580-8164-62d54e6a8a0b', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.255+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'docker_image.coder_image: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('74f56a37-a2b1-4409-b046-f6b1759aa037', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.31+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_agent.main: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3d5bab93-e5ca-4fe2-99bc-78521e9a1aa0', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.419+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('df371938-165b-4345-b2d3-cbfaa5497a25', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.474+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5ad684d7-72be-4152-b128-72b3bfcfb291', '6f457831-78b1-4bec-ab06-026a554058f5', '2022-11-02 13:57:25.797+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('33889fd5-36dd-40a8-8615-fc0c18104108', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.512+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Refreshing state... [id=3a585bc7-75e6-408e-b0bc-dc64e4d3be0a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4ef80f66-d881-41b9-816c-ad2d4c744539', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.565+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('83e476f9-4aec-4499-bfab-a92e4177823d', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.619+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Refresh complete [id=3a585bc7-75e6-408e-b0bc-dc64e4d3be0a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('db464759-cbc8-4376-9380-5600ef99df94', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.673+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8ff64cfa-a204-4231-9d2f-44ce4328f26e', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.727+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c329a689-84a1-4cb0-ad21-1bc0b6f55316', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.834+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a82e5fff-863f-43bc-ba7f-eb3148474f0f', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.887+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.main: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6956a14f-abaa-488b-8562-82b3b2a41d37', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.944+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Plan to replace') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d11c471d-199b-42fd-9d92-1b7e0baeb585', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:47.997+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6ba27b32-7049-4732-a977-f8c67c965844', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.053+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 3 to add, 0 to change, 2 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('01a609cb-3b79-401f-893c-0762cde283a5', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:48.683+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=35b2042267c2715fe87fdd0f7ca9fa421f2c7dadb2e68c9299e10663d397fa9e]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b5ad9cad-e9d1-4edf-8aca-13231da074ff', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:49.21+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 3 added, 0 changed, 2 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a5cb1738-3763-48bf-a068-85232dbb9c00', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:49.264+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('506cb762-0c41-4c27-ae53-a446753bfcfc', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-02 13:32:49.374+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8c1898a6-bd85-49d7-9080-91936f204039', '391d562a-af1a-4f4c-81d3-244f3006d9c7', '2022-11-02 13:36:23.66+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('82e3886a-8592-4d6c-aa2a-bea0af4b46eb', '391d562a-af1a-4f4c-81d3-244f3006d9c7', '2022-11-02 13:36:23.72+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f47bebb9-96c2-4b9f-be57-07232f02fdee', '391d562a-af1a-4f4c-81d3-244f3006d9c7', '2022-11-02 13:36:23.785+02', 'provisioner_daemon', 'info', 'Parsing template parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9ef0d665-15c3-420c-a49a-85104b4338df', '391d562a-af1a-4f4c-81d3-244f3006d9c7', '2022-11-02 13:36:23.914+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bf5b011d-cf11-4ae3-95c9-5af058d39752', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.16+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9e4829f6-393d-4f16-be8e-1f7f9df1bdfe', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.219+02', 'provisioner_daemon', 'info', 'Adding README.md...', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5692a65b-5af5-4935-ab73-01e884e4e932', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.278+02', 'provisioner_daemon', 'info', 'Parsing template parameters', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1e83bf3b-093f-4d6c-a3b2-ff44ac77e494', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.406+02', 'provisioner_daemon', 'info', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('06fc5e85-e796-46f1-a6a4-b692996e4ab9', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.558+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5efd9420-f9da-4595-ace8-fbd3659d03b8', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.615+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d49559c1-4965-47e4-a2fb-81d8ae5561b0', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.669+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('57faa684-5941-43a6-8be9-55c6bb67009d', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.723+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d5be78fe-bcbf-43bd-bd9c-6366633ecd4f', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.834+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d1b8b55a-b411-4a87-ad02-c681d80c12c9', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.892+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('00bccbd4-bbf1-4eb4-bba8-169641a37dd1', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:27.947+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('09370c0a-eea0-4881-9649-42e67320d44a', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.003+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f7cbcd00-2cff-4a30-96a1-2d6608f0a1c5', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.06+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f16b53cf-64a8-4fea-bab3-28f10bfb1ef2', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.115+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b5625b5d-e631-4fd4-aad9-2e2bd0fea025', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.168+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7eef58f1-ea0b-4601-85c4-045439d42685', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.222+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cd398ad3-3aca-4e51-b3f2-df3d998782e8', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.332+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a19c0d9e-a012-40ac-91b8-10cc2d53377c', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.386+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5deb15d7-78fd-4b1d-9420-f58c83965cb8', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.439+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('78cf9e6b-9cbf-4669-8da1-a0de61b367ef', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.495+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4e1ce2af-d585-4035-8466-4b2fa0ce5aa1', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.554+02', 'provisioner', 'debug', 'Detecting persistent resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('19d95770-cf4d-447b-8024-e6d346258bb8', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.609+02', 'provisioner', 'debug', 'Detecting persistent resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('791f00c6-fe92-427b-bf92-33122d472e88', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.665+02', 'provisioner', 'debug', 'Detecting persistent resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('045a9c8b-4e2b-4f6a-97df-a6c1a6b9e697', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.722+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('06b404c5-deb8-4a37-919e-6b4e82acc5b4', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.83+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d3addd90-d575-464d-978e-72d82d793c1f', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.888+02', 'provisioner', 'debug', 'Detecting persistent resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9d4935c7-af01-4f36-99c2-a40eef4c2f92', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.942+02', 'provisioner', 'debug', 'Detecting persistent resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('afc34800-dfb0-472e-8e22-fde92b4144ec', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:28.997+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('274b70c6-adc1-42dc-9e38-fb00445802d6', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.052+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('91db60a5-f890-44fe-bb9c-25b6247ae667', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.108+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('46c72eae-069b-4ec1-b39e-6e8a64ed98f6', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.164+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_image.coder_image: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('030280d4-63fa-4df6-a426-dfe5becd0541', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.218+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6b7cb952-bc9e-4a88-b353-1a72a16e52a8', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.324+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ea62705d-fb51-497f-b49c-2dd72af58f47', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.424+02', 'provisioner_daemon', 'info', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('320d1746-8869-4748-8ad8-8aad9a45a49b', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.579+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6b9f3012-8ff7-4bec-baf9-4a5ec0f48db1', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.636+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4de14cbf-ce15-4dc2-afce-6646049b26bf', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.693+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0f062097-b45b-4d97-b79a-04ba6d1da1a9', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.802+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9118a8a5-68e6-4e18-8be8-12f7545e6ba9', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.858+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of coder/coder from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('29068370-364c-484d-85b9-0db37be07be8', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:29.961+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Reusing previous version of kreuzwerker/docker from the dependency lock file') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b26f3edb-d76d-468c-ae4d-19c86d95ca30', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.185+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed coder/coder v0.4.2') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1220f4c9-bc0a-4377-b848-c4851273c269', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.269+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '- Using previously-installed kreuzwerker/docker v2.16.0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fa34b6e2-6cab-45c4-9c4c-8540d4518269', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.328+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e3127bf1-9d73-4682-8242-c5ac534cf900', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.384+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4e0ae984-3b82-4bbe-ae91-4c05e9da1ce6', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.439+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('39fd07f4-a9c8-4d25-a750-94cbe32572ef', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.495+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9dd3e87b-690e-4765-bb37-4bf1824cde4d', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.551+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0e1f72d6-c8c6-4371-89a6-3c8359c13d2c', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.604+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4a32119b-c575-4165-9953-e5a1d0617012', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.659+02', 'provisioner', 'debug', 'Detecting ephemeral resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('981494f2-682c-4206-8d42-c16ed8f60348', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.714+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cd1e285f-599c-4908-b863-b8f9a46eb1f7', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.77+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bea9e044-ec21-4c97-aa12-85fb8bc710a6', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.878+02', 'provisioner', 'debug', 'Detecting ephemeral resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9e1c2a67-a73d-4273-8ca1-fd7ab40666c9', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.931+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('555286e6-390c-41ec-b34e-0917644a961b', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:30.987+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a05e2708-11c7-4eeb-9ac9-e24ae3d8f443', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:31.041+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3e65cab1-e8af-4f1e-b8c7-db7963f38a0d', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:31.096+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'docker_image.coder_image: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ba885e4f-1c5e-4f81-b81a-3ea4196ad946', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:31.153+02', 'provisioner', 'info', 'Detecting ephemeral resources', 'Plan: 3 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a84a5f4a-d1d7-4ad2-9d14-06a1a8417e51', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '2022-11-02 13:36:31.587+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c9eb0482-d29f-467c-938d-2198ae073cf9', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.164+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('25f6512d-8acc-41d7-b1ec-439cd1b9d89d', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.31+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('87711ff5-e581-4ca9-bc95-648b5d411eb5', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.365+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ced7ef54-e1b5-40fe-99a9-5c397e581299', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.422+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('705d374a-0edb-43e2-a674-59104b0f2cce', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.478+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fccd2a46-6a82-4b67-9b1e-e7de891086a7', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.533+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6e16f336-a8d7-466f-b948-712d52b0211c', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.588+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bf4c6bb5-a967-4ff8-afc8-ce7223a6523a', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.643+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('94b8b5bc-768e-4566-9b68-4d29f225c861', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.698+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bad35ab4-1861-41cf-81dc-ec63c55ffb6c', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.808+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bfd7e893-0eb7-437d-bef6-06b9084e3085', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.862+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('02e1fe72-f8c2-4f1b-ab5d-6180327567f4', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.918+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c03b29f1-61a2-4072-a55b-f2a6fff85528', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:05.973+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a4d27cf3-4d43-4931-8ee3-c461a2e93078', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.028+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('12a1165b-4132-4379-afba-3fd7e47a4dae', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.083+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a9f9e469-fc9b-448d-9bc7-dafdade9c842', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.14+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('65741a30-c295-42fe-a94f-4bf1d67d4f84', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.203+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('df7d8feb-2932-4e03-8bd6-c7b64c5752dd', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.257+02', 'provisioner', 'debug', 'Detecting persistent resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('14130e7b-273e-482c-90f1-d46148775026', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.37+02', 'provisioner', 'debug', 'Detecting persistent resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d56a0969-81c3-47cf-b12f-4867b0b6d71d', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.425+02', 'provisioner', 'debug', 'Detecting persistent resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3111a1e7-17d1-4676-ab1a-de5e1d20ba21', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.481+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('32618618-95ef-471e-a301-994189a411cc', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.536+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('27538470-0ada-42e7-99a5-b1458f092c71', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.59+02', 'provisioner', 'debug', 'Detecting persistent resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0b28ac27-3577-4008-9429-0e3debb0172c', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.645+02', 'provisioner', 'debug', 'Detecting persistent resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7ddf291d-bf28-4838-9df7-79cffd3b7b18', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.702+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9740c5b7-3daf-46fe-8dee-4045577b8b35', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.772+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0e511616-8e34-43c8-9de8-175b1db0b2ac', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.88+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e36b0a0b-f12f-454c-b52b-a4826cf8b88e', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.936+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_image.coder_image: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a78269a1-ca3d-4327-af36-4b3a737ed56f', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:06.989+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c5377dfa-72bb-417c-9a91-71fd1475f037', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:07.045+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('11ac95e3-b5d2-4e7b-89cd-0e8808214409', 'a122c783-ae3a-493a-8c26-f29cf791fb98', '2022-11-02 13:37:07.103+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('99e9ef81-48d4-4d2d-a634-451866303649', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:08.664+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4c81293a-43ae-4527-9d22-a8256c7e4b34', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:08.722+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1ca9e042-2bbf-4cde-b6d8-dd2448fba5f1', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:08.873+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b103c926-2169-411a-9025-4990eaec857b', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:08.928+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e09768db-db30-44dc-9941-2b0b0c7092cf', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:08.984+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4c581952-c9e2-428d-8987-5f424cc08586', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.041+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a7706c0a-632f-43e7-8a4f-68931781213c', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.097+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8cb7ece7-dc85-494f-ac90-4cba3aa5949e', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.154+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4630ee16-6a45-449b-bafd-000bb13f048a', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.216+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('85f53834-2c0a-4e10-9743-c777e94a3c48', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.32+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('346fdcb2-9f59-480a-a2bf-67e046d71cbb', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.377+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c1c6db42-8ae8-4ba0-a73c-d4874164ea4d', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.43+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('99fe1e2f-b089-4d6b-8331-306b7bd6a8c2', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.486+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('913894bc-af15-4d2a-8fb3-52ee21fd90dc', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.541+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('060bbd4b-db18-4a66-9d64-2a9edc1a214a', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.595+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d326059a-3383-4594-9452-6dd15b782027', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.651+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5a7322c8-6ee1-428b-affd-81e1acc7552b', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.706+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c82e200d-207f-43e5-9821-40484191f047', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.815+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('78b718a5-0f88-4d06-abc3-4f756c7b14a5', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.871+02', 'provisioner', 'debug', 'Starting workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ffc032d2-48cd-4a29-b8ce-53a7d3091a86', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.925+02', 'provisioner', 'debug', 'Starting workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a156ca1c-c47d-40fb-820e-3c1e50864978', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:09.98+02', 'provisioner', 'debug', 'Starting workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('606f4f90-2975-49f6-a539-3667d853f955', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.034+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1f041511-05a5-4f5a-82b2-cf4d7186d844', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.089+02', 'provisioner', 'debug', 'Starting workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e8cce8bf-5a5b-4701-8d99-ad8f1f09d606', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.144+02', 'provisioner', 'debug', 'Starting workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('759f2dec-80d9-4240-8968-e3665117a1a7', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.2+02', 'provisioner', 'debug', 'Starting workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2fc7969d-9ed0-4cf0-9171-dc00baf6ea05', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.256+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('91195407-b3cf-4a7a-8508-311a4b620391', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.365+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('48e2c8e8-8273-4658-b3b2-87b7de849ce4', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.422+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1338fb79-fe7c-4f6f-a402-575370f85a4d', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.478+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6d195c3d-0300-4b32-aefb-3cb1df08459e', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.535+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5e2aa941-7529-4bf0-99c0-73455c3d4124', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.593+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ee8529bb-0709-49e0-a00d-7ef132a60eaf', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.65+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ecca69c0-9b5d-4022-a65d-611103a98951', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.707+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Creation complete after 0s [id=417c5589-acba-45fb-9cf0-c2ccb5453084]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0ac5c8c1-cf88-4022-9ac9-6a89fbf5cd08', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.763+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d8c6ab30-ff8a-4c53-89e9-aba610e6bd60', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.873+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creation complete after 0s [id=coder-oauthuser1-test2-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fcf65a12-ddea-4385-a56a-d8d8442dbb1d', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:10.929+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('579f6dbf-1a45-415c-8a12-0b5770d2f8f4', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:20.226+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [10s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7af8e1c6-c8d6-4b3f-9cef-d7e4a9145571', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:30.227+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [20s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d1f94939-4925-4269-af50-278b7f19437d', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:38.218+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f4ffbe78-817a-47bd-afa5-0fd5db983bb1', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:38.275+02', 'provisioner_daemon', 'info', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('928491e8-afff-4605-8d94-d92743dc57e7', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:38.421+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('874d13f2-36df-463e-8650-4fcff83fcd0e', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:38.476+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6d776f0b-e76b-43b3-8846-f495e9b12415', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:38.534+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3ec10108-f4da-42e9-8789-a928ce799442', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:38.59+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f598bd0c-a0a5-4d18-83a4-948632f182e6', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:38.645+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f59c1046-f534-41ad-9fdc-21b6e528fd36', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:38.701+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('50257a33-08a9-423e-b5fe-c49ef2b12882', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.186+02', 'provisioner', 'debug', 'Stopping workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('179f20d9-e74d-4f60-8f62-4ffa840a0c86', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.271+02', 'provisioner', 'debug', 'Stopping workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f2f09778-b816-4e8f-86c5-386e9834071f', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.35+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3efacf30-9464-4baa-82a4-efe2024eb8f4', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.407+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('235ee4c8-90fd-4a6a-aa9c-7583561cc41f', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.464+02', 'provisioner', 'debug', 'Stopping workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e248c2dd-c686-4809-935a-9b5987f0efbe', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:40.227+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [30s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8b88e3ae-1af3-4f27-bcd8-3eb8ade6c99b', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:37:50.229+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [40s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('471f1644-446b-4a0c-b523-8e268e85a1b9', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:00.229+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [50s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5c1d6342-7f77-43ec-bc9a-237ddbcfefe6', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:10.231+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [1m0s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5b0eb2df-4e96-48fa-974f-638872598107', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:20.231+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [1m10s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bb7cebe3-018e-4dae-a341-2808a85753d6', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:30.232+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [1m20s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('412e8406-4e92-4fd8-8b91-729ae4698b84', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:40.234+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [1m30s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7e533c5a-8ba6-4621-8bfa-6c93cee4e241', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:50.234+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Still creating... [1m40s elapsed]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('64eb39ca-e42d-43ad-8de4-d0bf6c68b7fb', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:54.497+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Creation complete after 1m44s [id=sha256:b142766280c01c7fd7c4904061ecd7ee720c508b83ef5b8ca0793267e779b446coder-base-oauthuser1-test2]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7d68966f-5651-48aa-9e3f-05d466e8cc27', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:54.552+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('90ba3b76-b178-48c8-ac0d-4fdde826fcd1', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:54.961+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 0s [id=ac6246e245cd13f504e2329deb065eb770d991094f046d9bff27152321a2c4c0]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('60d9003b-45ff-4f0d-a05f-5a30849075bc', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:55.016+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 4 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0124719e-47b9-4482-aba4-ba94c48cc0bf', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:55.071+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9203abc5-e564-4a0b-8e91-ba4954006a4f', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 13:38:55.705+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('377f87d6-6fe7-472e-93e1-6ce6193a5d44', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:23.665+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('10ed865a-37f8-4811-873b-60da658b0e35', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:23.816+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9de11876-7fa9-48bc-8952-227a849f5947', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:23.872+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('03c75f18-359b-4f64-928f-12c1a7c77e89', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:23.93+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('373168e9-7589-49b8-a274-06546d28f38c', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:23.987+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f1a9f2a3-b99c-4625-b8c9-991557cf70e4', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.043+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f025be30-1266-4ad5-8786-63beafebde2a', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.098+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('75c0fb6b-ee2e-4645-a2f2-548f9acf3923', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.152+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6436217d-e42e-4567-9b7d-635c6d0e38e4', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.207+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ba33a834-2256-424e-8377-b9daf1602c8d', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.318+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f09142f1-d680-4013-9ef5-0db5c75698ce', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.372+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5bccf33e-8033-4572-a857-b3fc2f17f6eb', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.427+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9fafbf6e-ff59-48e5-997e-8456ee67e040', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.482+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('478273c6-fe00-4e28-af99-896a5bfcd28a', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.536+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('157c1aa1-69a6-4c61-8728-33f42b4e77c3', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.591+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1b13bf5d-d302-41c0-afe1-574d5714288e', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.646+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8d2f9ca6-d3b2-4e31-a875-ae9dd7e9f1de', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.701+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6141ffff-ab47-4b72-b79f-f1e97a4c6f56', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.808+02', 'provisioner', 'debug', 'Detecting persistent resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c372e73f-ff02-4a07-a3ed-3b5bed204237', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.864+02', 'provisioner', 'debug', 'Detecting persistent resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('377e3002-8b6d-4de4-aa4f-2355850b5c95', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.922+02', 'provisioner', 'debug', 'Detecting persistent resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9e065ad6-543b-4447-8891-d2f711de6656', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:24.978+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('55627349-c7f2-4127-93c4-a448234040bd', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.032+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a610107a-b805-4a08-9308-41114c0855a5', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.087+02', 'provisioner', 'debug', 'Detecting persistent resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('16c4d489-255f-4806-9ec1-745359621794', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.141+02', 'provisioner', 'debug', 'Detecting persistent resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('627f71ba-2b02-410c-aa20-e160a82d3458', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.197+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1ae58f29-dd8b-48fb-b054-50b5c6a9ef3f', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.254+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fc9f9c98-c261-43b1-b43f-db13e2f61b87', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.364+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3de08446-94f4-480c-916e-60d42340d107', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.42+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5af26126-898e-438c-8ef2-d30e9befb0d6', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.476+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d975150a-f0be-4287-a1e4-389705057392', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.533+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('faa1e1ae-6621-46e7-856a-df2ae89ca918', 'a2487cf9-1199-4304-9fa1-96e5d593482c', '2022-11-02 13:39:25.59+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cbbefbf7-eedc-4feb-886d-13fb304a9fdb', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:26.664+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cdbb23dd-4572-46a8-8071-037a50e210dc', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:26.723+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0537a9d7-4b93-4d32-b9f4-00349940fe07', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:26.869+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('df38509c-5173-4430-96f3-f4c1a5198288', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:26.926+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('850714b1-9749-4848-ad4e-bc79b8b7b72b', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:26.982+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('04ee283f-2d62-4338-93bd-3ded69b82334', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.037+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c32a3a8c-8b0c-4dba-9881-548c6900343b', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.093+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3b301036-79de-4da1-810a-ebf5940cf2b3', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.15+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('094d82e5-cf66-4fef-ac11-5fd06ccacdb2', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.284+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('65dbb2a3-4f54-4305-a162-284011f060ba', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.341+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('07ca0b10-c16d-48f4-b008-cd0616b7643e', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.46+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('89ac7533-a516-4f9c-a27b-6d09d28ee8c6', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.516+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bf16680a-2129-405e-b70f-60bea74f7027', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.572+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c8bf4272-4656-4d02-8d4f-9c578d2c5ef4', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.627+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4b86bc1a-ee7c-4627-aa6a-b8a29a91a529', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.681+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('47bf258a-9487-4900-993e-221edcf2ce2e', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.736+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7024c7d1-03b1-4fb2-9b13-c8765cc726c8', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.846+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('359dd4ca-5c63-4a0b-b10d-a03fa514e183', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.899+02', 'provisioner', 'debug', 'Starting workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('06aed2bc-b99f-48c4-a766-60bb43c1bcb7', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:27.955+02', 'provisioner', 'debug', 'Starting workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0ef10135-6843-4564-98be-d0f92626b9fa', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.008+02', 'provisioner', 'debug', 'Starting workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('50cf502c-2286-49bd-ad2b-29b4e1a06201', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.065+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('446d0f94-b16a-4256-9184-59cc169de329', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.119+02', 'provisioner', 'debug', 'Starting workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7dd5d3bf-6a4e-4632-b9a2-2b8c4d58331e', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.173+02', 'provisioner', 'debug', 'Starting workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f0a14e66-8690-4dfb-af6d-fcdb499aefec', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.289+02', 'provisioner', 'debug', 'Starting workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8054ec53-0c68-4c9d-97ce-3110fa551ac3', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.343+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8e651d3c-7244-43c4-8106-836fbf6ac520', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.398+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e7923c8c-e204-4109-a141-0ebb5f71d78f', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.454+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('febaf747-8e19-4cde-ac94-ca9c0e71e684', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.51+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('611be213-1312-4c5d-a332-485ff41ce2c8', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.565+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('188cba09-5866-4de0-bfd9-7d8163845c8b', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.619+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5eb5830b-7a47-4f38-a49f-d0edbb30d255', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.674+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f6165730-b178-498a-81b5-f5d99d24ec70', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.73+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Creation complete after 0s [id=866422ad-e84f-482d-897e-f0895959ffa5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d53f6e47-9e2b-448d-9230-f6c2184529ac', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.838+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5defb7cb-d335-4263-b609-69a1385d3986', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.891+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creation complete after 0s [id=fcb8f261-20f0-4013-b2c8-5cefc217c953]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7b0a902b-f938-4ebb-b6aa-349cb666ce66', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:28.946+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1aa62188-0df9-45bb-b281-ee4ff03fcbf9', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:29+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creation complete after 0s [id=coder-oauthuser1-deleted-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ecac637b-f0e6-43d8-8711-6ed98b656803', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:29.055+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c56ef61f-d618-4dae-a999-639c69a198fd', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:29.11+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=965ae90deecd106a0eb5528c08e0ba5df96b902c262864fef3af93bb31b06ce1]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('01a1b9e0-e10e-4263-be88-83e177d20185', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:29.165+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 4 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ba5cdc25-daf3-4585-abf8-4c4a55084b87', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:29.22+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9d338c9d-c195-4c90-bc89-0c38364b9301', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 13:39:29.473+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e2d61121-b062-4eee-b2bf-0b71f7a9ab0c', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.167+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c89af49b-1382-4a9d-a750-8279039547ee', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.226+02', 'provisioner_daemon', 'info', 'Destroying workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('633f34b2-c079-48aa-b472-e47dde7baf45', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.38+02', 'provisioner', 'debug', 'Destroying workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('555af308-85ad-4f0f-a3b8-5a9ee3fce23f', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.435+02', 'provisioner', 'debug', 'Destroying workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('baa9bc96-02fb-43bf-bfd3-5d02a106f1f5', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.492+02', 'provisioner', 'debug', 'Destroying workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f608715c-5bc9-4091-b453-2a624b988ba0', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.548+02', 'provisioner', 'debug', 'Destroying workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fd590765-7e6b-456a-ab56-017af7f9e7c1', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.606+02', 'provisioner', 'debug', 'Destroying workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('80b2bcc0-978f-43b2-a98d-ce40db2d092a', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.662+02', 'provisioner', 'debug', 'Destroying workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('62c252b7-3e88-40bb-b323-88a7023f2247', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.718+02', 'provisioner', 'debug', 'Destroying workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cc678300-328a-48a4-bc0e-abf8f65289a0', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.774+02', 'provisioner', 'debug', 'Destroying workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c87b275f-d65e-4b43-b518-61aec1453919', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.882+02', 'provisioner', 'debug', 'Destroying workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0daf313c-23b4-4e4b-83d9-91e3af6a5bac', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.936+02', 'provisioner', 'debug', 'Destroying workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c84960a7-90dd-49aa-bbfc-1341484f373b', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:45.989+02', 'provisioner', 'debug', 'Destroying workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('892edfcf-13f4-495e-953f-dfe6c154d5b5', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.044+02', 'provisioner', 'debug', 'Destroying workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d655f9e4-3cc6-4f8c-b341-8d15fef6e439', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.101+02', 'provisioner', 'debug', 'Destroying workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('58ae28a1-aed1-42b5-92af-cc4495b3d493', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.158+02', 'provisioner', 'debug', 'Destroying workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('620acc45-db1c-4bf4-9550-6bbcda94fef0', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.214+02', 'provisioner', 'debug', 'Destroying workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c836fdd9-5c8b-4b91-9d8c-eb9a5a783b3c', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.27+02', 'provisioner', 'debug', 'Destroying workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('76bfb33c-2634-451b-8934-60552702b85d', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.379+02', 'provisioner', 'debug', 'Destroying workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('864e470f-b9f5-4fb5-8812-b3470d98cad2', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.433+02', 'provisioner', 'debug', 'Destroying workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ca953cfd-29d0-4ded-b170-8016bcd70811', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.49+02', 'provisioner', 'debug', 'Destroying workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5e0e8bd1-d136-4fe1-8a5e-8d6d0f8657b7', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.545+02', 'provisioner', 'debug', 'Destroying workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7ee91783-9319-4b69-a599-5d1520c57f23', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.601+02', 'provisioner', 'debug', 'Destroying workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a305a6c8-8281-41c0-b07c-fdd8f0c8dcd8', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.658+02', 'provisioner', 'debug', 'Destroying workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b27a5b4e-967f-4575-8a06-64a374694f6c', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.715+02', 'provisioner', 'debug', 'Destroying workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4926e473-fb18-4ed3-a16f-5832a5284f9c', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.77+02', 'provisioner', 'info', 'Destroying workspace', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a8b79ec7-a63e-43ba-ba8b-fb55acb501dd', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.882+02', 'provisioner', 'info', 'Destroying workspace', 'coder_agent.dev: Refreshing state... [id=866422ad-e84f-482d-897e-f0895959ffa5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('870a81cb-d409-4729-b0f9-881026a9b6bf', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.939+02', 'provisioner', 'info', 'Destroying workspace', 'coder_agent.dev: Refresh complete [id=866422ad-e84f-482d-897e-f0895959ffa5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8cc932d8-64b3-4b12-96e0-4650aac23b25', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:46.993+02', 'provisioner', 'info', 'Destroying workspace', 'coder_app.code-server: Refreshing state... [id=fcb8f261-20f0-4013-b2c8-5cefc217c953]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cac80fe2-b206-46c6-a06e-de13bafb391f', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.05+02', 'provisioner', 'info', 'Destroying workspace', 'coder_app.code-server: Refresh complete [id=fcb8f261-20f0-4013-b2c8-5cefc217c953]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1aac693e-8a24-4d3a-9df4-e9ac1e09a8d9', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.113+02', 'provisioner', 'info', 'Destroying workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-deleted-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('013ce4ab-bd1b-4afa-970c-d7ae73c5f2ec', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.169+02', 'provisioner', 'info', 'Destroying workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-deleted-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('811425a0-aaa3-46f9-ba12-70ffdc8fe227', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.227+02', 'provisioner', 'info', 'Destroying workspace', 'docker_container.workspace[0]: Refreshing state... [id=965ae90deecd106a0eb5528c08e0ba5df96b902c262864fef3af93bb31b06ce1]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ed19828f-caa7-4747-ad71-732c3fa101d4', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.337+02', 'provisioner', 'info', 'Destroying workspace', 'docker_container.workspace[0]: Refresh complete [id=965ae90deecd106a0eb5528c08e0ba5df96b902c262864fef3af93bb31b06ce1]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('988b74a7-c4fc-4abd-aff9-0c9ad7ad0093', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.394+02', 'provisioner', 'info', 'Destroying workspace', 'coder_app.code-server: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('49dedcf5-2a5c-4cf3-991e-2538567437fe', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.449+02', 'provisioner', 'info', 'Destroying workspace', 'docker_container.workspace[0]: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('abf17353-0eb8-44dd-93ff-ff2f39d88ce7', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.506+02', 'provisioner', 'info', 'Destroying workspace', 'docker_volume.home_volume: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('459c4bb8-ca69-45b2-953a-e7eb40a2c728', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.563+02', 'provisioner', 'info', 'Destroying workspace', 'coder_agent.dev: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a97d6730-e5ae-4c67-b418-edcfc139a7b8', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.62+02', 'provisioner', 'info', 'Destroying workspace', 'Plan: 0 to add, 0 to change, 4 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('691d3e02-f290-48f1-b664-3bbf88270f6b', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.676+02', 'provisioner', 'info', 'Destroying workspace', 'coder_app.code-server: Destroying... [id=fcb8f261-20f0-4013-b2c8-5cefc217c953]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('45c446d2-5bca-4eeb-bb32-c0982995c5fe', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.789+02', 'provisioner', 'info', 'Destroying workspace', 'coder_app.code-server: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1c81970b-2ed6-4250-a5c6-f865f6172392', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.844+02', 'provisioner', 'info', 'Destroying workspace', 'docker_container.workspace[0]: Destroying... [id=965ae90deecd106a0eb5528c08e0ba5df96b902c262864fef3af93bb31b06ce1]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('981aeef3-8be2-45b5-95b1-db12e87b1b88', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.901+02', 'provisioner', 'info', 'Destroying workspace', 'docker_container.workspace[0]: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5f56c5ce-4a2c-4a1a-a975-02b5faf05aab', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:47.958+02', 'provisioner', 'info', 'Destroying workspace', 'docker_volume.home_volume: Destroying... [id=coder-oauthuser1-deleted-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('23eaf74e-b0fc-428c-9d48-d4d727d6e6fd', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:48.016+02', 'provisioner', 'info', 'Destroying workspace', 'coder_agent.dev: Destroying... [id=866422ad-e84f-482d-897e-f0895959ffa5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5559a8ab-22a0-448f-b70c-068a48b298cf', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:48.072+02', 'provisioner', 'info', 'Destroying workspace', 'coder_agent.dev: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('af82a5e0-e080-46ee-82b4-f0deaa76778d', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.528+02', 'provisioner', 'debug', 'Stopping workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('21e460ff-16e6-4d71-9c12-421ce44008a2', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.584+02', 'provisioner', 'debug', 'Stopping workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ca57d4d9-0b9d-480a-a137-847f6d748c36', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.638+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6c66f4c5-190c-4e85-a6dd-0a7952c73ea9', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.693+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0fa71c61-5ef8-4a56-a077-57654568cc94', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.747+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('90eed549-fe7e-4ab8-a21b-712dc8da3574', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.801+02', 'provisioner', 'debug', 'Stopping workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f635079a-bfdf-4b41-bf4a-acd51360cfe6', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.91+02', 'provisioner', 'debug', 'Stopping workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ef0eb73e-47fc-44ab-807d-0fdce365aba8', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:39.964+02', 'provisioner', 'debug', 'Stopping workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8929bea2-b985-4750-b07d-6ff7adf46ced', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.023+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8351e9c2-44c0-4130-accd-19cbb5ed994c', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.076+02', 'provisioner', 'debug', 'Stopping workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8f906d3a-71a0-494e-b035-2337232885e8', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.131+02', 'provisioner', 'debug', 'Stopping workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6e40e6d5-501a-4fe9-b6f4-e55146fa2682', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.185+02', 'provisioner', 'debug', 'Stopping workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a4018e60-4706-46ad-9d8e-249e2663b790', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.242+02', 'provisioner', 'info', 'Stopping workspace', 'Terraform 1.2.1') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0ec1d8ec-d257-4131-9d7f-d79187df27ed', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.298+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c12c68b4-fbb7-4e1b-9fb3-4990b7b47614', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.412+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.dev: Refreshing state... [id=c64f6ae8-d97d-49f9-b9b6-aab5fdcfb5d7]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('68b404a8-9ef0-4e6e-a8e2-c6a5a227ab21', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.467+02', 'provisioner', 'info', 'Stopping workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=9cf0c44c-f931-43fc-bf4e-6d3624eb3037]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bc414810-aa08-42d7-9967-b966525698b5', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.521+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.dev: Refresh complete [id=c64f6ae8-d97d-49f9-b9b6-aab5fdcfb5d7]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a9ac7343-84dd-46b2-b097-1d4799fcee52', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.576+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refreshing state... [id=1202a4b0-79a4-45fd-9504-9306939eb300]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7eaaecd2-cbe5-4385-bfc5-398bc299d1b2', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.631+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refresh complete [id=1202a4b0-79a4-45fd-9504-9306939eb300]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3223f632-82bf-4fd6-8168-44355f258ad0', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.686+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-test3-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8ad6183a-d886-430a-b013-281fd46ed28c', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.743+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-test3-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1dfd0ee5-d56d-4db8-a213-4dba9b98e93c', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.804+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refreshing state... [id=9e3d8de3ea812697c4696531e889022339f478f9ea9212d0e04723f2a4121cb1]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6a7bec26-b3de-4adf-ae35-3dcadbba6cf2', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.914+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refresh complete [id=9e3d8de3ea812697c4696531e889022339f478f9ea9212d0e04723f2a4121cb1]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8982f123-30f2-4d7d-a974-97f169ba048e', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:40.969+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5198b72e-5745-48d5-8b61-50bfc8aacb91', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:41.025+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fd14c27e-443f-43d6-ac93-35fd57f9f54b', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:41.08+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('840250dc-9405-493c-97f7-96a7c67ecdbe', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:41.135+02', 'provisioner', 'info', 'Stopping workspace', 'Plan: 0 to add, 0 to change, 1 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e70c2a38-ad4d-4b89-b956-5cda45bf5e8d', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:41.188+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destroying... [id=9e3d8de3ea812697c4696531e889022339f478f9ea9212d0e04723f2a4121cb1]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5cf5d29f-77cc-46bc-944f-0666b8d6c318', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:49.156+02', 'provisioner', 'info', 'Destroying workspace', 'docker_volume.home_volume: Destruction complete after 2s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aa7b5e45-6d0a-4d4f-9a5e-bd58a5a273fc', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:49.212+02', 'provisioner', 'info', 'Destroying workspace', 'Apply complete! Resources: 0 added, 0 changed, 4 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('59378af9-3d71-4b59-80f3-bc93af0255eb', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:49.267+02', 'provisioner', 'info', 'Destroying workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7110a629-af6e-41fb-bc4b-84e8ac44fe56', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 13:39:49.813+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ee06561f-11bb-441e-adc9-cb463d70921c', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:23.168+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('488be7db-1192-4266-8229-5eccaeeaa1d3', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:23.227+02', 'provisioner_daemon', 'info', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c95d4a68-f7f2-4872-8f48-77da01abb77f', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:23.381+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('adadaef3-729c-4ba9-aee4-eaa29ebe9a4f', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:23.437+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('54448000-983a-4bed-9dbc-cd450b66baa2', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:23.493+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1fef045a-9458-47aa-8a2a-f249b02bc7a0', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:23.551+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b60e47f5-cdb6-4191-bdcf-ebdb56589aac', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:23.609+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a0a2ee4e-c71c-4e6c-8ac8-0fe8c17b4cc4', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:24.052+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3aebcb7e-0254-46ce-b53e-22e9528d3c17', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.097+02', 'provisioner', 'debug', 'Stopping workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0b8e89a3-a66c-4913-9659-b815025e0e2f', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.165+02', 'provisioner', 'debug', 'Stopping workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6a5fd8b8-1a24-4ecc-824f-68949c405cc0', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.22+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1bdb6a60-3612-4783-98ed-f802fefaf13c', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.326+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('330a9ca2-a9e7-4e81-a4e1-74d853f1d775', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.381+02', 'provisioner', 'debug', 'Stopping workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9bbdc18c-b550-4de7-956d-9383e6fdb18a', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.434+02', 'provisioner', 'debug', 'Stopping workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9cc4c050-2603-4b13-8b81-fbe6007b2d18', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.491+02', 'provisioner', 'debug', 'Stopping workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('22c6f089-8360-4351-8529-c80b4b91cac6', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.544+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a9b9e199-4de9-4071-abb4-e464d8014257', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.599+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('37868dc1-1bf2-4e19-86b7-364c6943a6cd', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.652+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3a8e3cae-f3ac-47c3-a023-8babfddc32fe', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.706+02', 'provisioner', 'debug', 'Stopping workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7b19aa3a-461c-4b9b-89a3-1b83b5ca5a3a', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.76+02', 'provisioner', 'debug', 'Stopping workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('54e06ae5-696f-4c75-90a4-a23f9c1d4925', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.869+02', 'provisioner', 'debug', 'Stopping workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('35e9dce4-1481-4410-b57c-0bb942c996e7', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.925+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1bf648a0-7b71-4690-bfd8-9e768319abc9', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:25.981+02', 'provisioner', 'debug', 'Stopping workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5658cc67-f9fc-4ec7-91f9-aa275d217c6f', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.036+02', 'provisioner', 'debug', 'Stopping workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7a9105d9-98e6-47d7-91ef-7e6f075b0106', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.091+02', 'provisioner', 'debug', 'Stopping workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('26f7b7eb-ed69-41cb-a329-d5e17733ba8b', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.147+02', 'provisioner', 'info', 'Stopping workspace', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('57a4630a-a184-4b2f-864e-b8dbc658504c', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.203+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.dev: Refreshing state... [id=3e6b9490-1b41-4939-9b01-895076085bb5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('deb4e555-1685-4152-a30b-4330914b9841', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.313+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.dev: Refresh complete [id=3e6b9490-1b41-4939-9b01-895076085bb5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('caf173cb-1ad2-4fb9-b38e-bdd11c39a982', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.368+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('adc92c2f-ad61-4c8b-a6b2-7c6ea36a3614', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.424+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2f1f6a27-f080-4a46-890b-c66f3f9c6044', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.479+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refreshing state... [id=0c1e02cf-43be-47cf-a012-0b98168dfd48]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c76f4b19-be68-4c83-958e-2637b2cd3f79', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.547+02', 'provisioner', 'info', 'Stopping workspace', 'coder_app.code-server: Refresh complete [id=0c1e02cf-43be-47cf-a012-0b98168dfd48]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9746f23f-34e4-49ed-9542-45627e5b2a9f', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.601+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refreshing state... [id=35b2042267c2715fe87fdd0f7ca9fa421f2c7dadb2e68c9299e10663d397fa9e]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('df330445-8344-4476-b0c6-9b80cc0c96a3', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.657+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refresh complete [id=35b2042267c2715fe87fdd0f7ca9fa421f2c7dadb2e68c9299e10663d397fa9e]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('090fbcde-52d1-438b-b370-c15e7e55eb97', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.712+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c21dc4c3-4e97-4656-aa35-6d947bc946e6', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.768+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('22a4b53e-0a3f-4e90-8247-f96f86171199', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.877+02', 'provisioner', 'info', 'Stopping workspace', 'Plan: 0 to add, 0 to change, 1 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ddd91b29-98ed-4623-856e-f7ef90ec6c94', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.932+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destroying... [id=35b2042267c2715fe87fdd0f7ca9fa421f2c7dadb2e68c9299e10663d397fa9e]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b404aacc-e540-4849-8332-b68225ee8538', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:26.986+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ee87fd75-c1c0-4c1b-97ac-526df5077d28', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:27.04+02', 'provisioner', 'info', 'Stopping workspace', 'Apply complete! Resources: 0 added, 0 changed, 1 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e9b2bbee-b364-4e51-926b-0ed5d709e6db', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:27.097+02', 'provisioner', 'info', 'Stopping workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('77cf7c2e-005a-45b7-a00a-1775ca0cc308', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-02 13:40:27.156+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fc0518b1-a223-40e2-8101-3c30097501de', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.171+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cc429c7a-538c-49a4-8359-86b4f0159249', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.232+02', 'provisioner_daemon', 'info', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7e1d907e-9f1c-4b20-a9a8-03f64917def1', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.381+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5fa9618f-a30b-45f4-bc20-42b2320c38d6', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.437+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ee3e266a-47a8-41f1-aa10-0161039eb14e', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.494+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('824c79f1-5df7-40f0-a535-a5e41b8414ad', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.55+02', 'provisioner', 'debug', 'Stopping workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('84b50f01-61b3-450c-b792-5bd3bf45062a', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.608+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3930b942-7aca-48ab-b198-dd2776817a07', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.801+02', 'provisioner', 'debug', 'Stopping workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('79e91b70-ea2f-4c5e-bdff-a7925bf4bc92', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.867+02', 'provisioner', 'debug', 'Stopping workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('acdc863b-931d-49ae-851b-a32ec3e44376', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.923+02', 'provisioner', 'debug', 'Stopping workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6b1cce77-f5cc-4b7c-9d16-251edf7ba43f', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:29.988+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a91c7820-d3f4-413d-bcbf-edd14ed130fe', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.045+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('404ae7ea-f004-4984-9bcf-7c3e7711a7f7', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.099+02', 'provisioner', 'debug', 'Stopping workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fd1397a4-59c8-4d7a-a0ee-81af546b3be5', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.153+02', 'provisioner', 'debug', 'Stopping workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fae72c78-7e9d-4557-8522-586de38d2ddd', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.208+02', 'provisioner', 'debug', 'Stopping workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('28e2114a-1baf-4929-9e28-0d8ba8501b3d', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.262+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6fc3f2cf-dc29-4a5a-9577-d4989b470295', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.371+02', 'provisioner', 'debug', 'Stopping workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d4f6f344-cf56-45e6-bdc0-5d2f7b5fd613', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.426+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fd106c76-5a83-4159-8498-80c6e9c58b43', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.481+02', 'provisioner', 'debug', 'Stopping workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('277826f0-3f25-4862-abaa-cc7f8c3c6875', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.536+02', 'provisioner', 'debug', 'Stopping workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('955c1fbe-e9bf-49c9-b4b1-5c1318c707b7', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.591+02', 'provisioner', 'debug', 'Stopping workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('eacbd156-595f-4404-9aa4-763c7f0fd28f', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.647+02', 'provisioner', 'debug', 'Stopping workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f7c17005-be91-4ed8-8136-e6ae5e47f5e1', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.702+02', 'provisioner', 'debug', 'Stopping workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('15671ae7-4727-4821-b031-edcd55adb917', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.757+02', 'provisioner', 'debug', 'Stopping workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('960aedf0-9fd1-4710-82a1-2ab1e6fc4d01', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.866+02', 'provisioner', 'debug', 'Stopping workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('96fd33a6-5af4-4f32-8347-b95306b1bb4f', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.92+02', 'provisioner', 'info', 'Stopping workspace', 'Terraform 1.1.9') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3a3dde0e-0d6f-4283-ba6b-8795be7ddf66', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:30.977+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.dev: Refreshing state... [id=417c5589-acba-45fb-9cf0-c2ccb5453084]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('060c5237-9e1d-4a6d-a8be-27c60c9b749d', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.034+02', 'provisioner', 'info', 'Stopping workspace', 'coder_agent.dev: Refresh complete [id=417c5589-acba-45fb-9cf0-c2ccb5453084]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('af5de332-f14d-4a3c-9172-4aef056dc15c', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.088+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-test2-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6e5a9154-b4ed-420e-b149-56321694742c', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.143+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-test2-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0e9d8d50-3c56-44a2-9991-5bcd74834a10', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.197+02', 'provisioner', 'info', 'Stopping workspace', 'docker_image.coder_image: Refreshing state... [id=sha256:b142766280c01c7fd7c4904061ecd7ee720c508b83ef5b8ca0793267e779b446coder-base-oauthuser1-test2]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('399d0d3e-2561-4d73-8247-68a0ec39628e', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.256+02', 'provisioner', 'info', 'Stopping workspace', 'docker_image.coder_image: Refresh complete [id=sha256:b142766280c01c7fd7c4904061ecd7ee720c508b83ef5b8ca0793267e779b446coder-base-oauthuser1-test2]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dab32d9d-8291-4365-9b52-b4c5dd63c530', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.365+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refreshing state... [id=ac6246e245cd13f504e2329deb065eb770d991094f046d9bff27152321a2c4c0]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0057c08e-b1a2-41e8-b5f2-5f5784c008b7', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.42+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Refresh complete [id=ac6246e245cd13f504e2329deb065eb770d991094f046d9bff27152321a2c4c0]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8785dfb8-7655-488c-9875-ec95e94c7f95', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.474+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a3d2aad6-088a-43d9-abd4-d5dd7f8f0ffc', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.528+02', 'provisioner', 'info', 'Stopping workspace', 'docker_image.coder_image: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('028a1cc7-2973-424b-8bb1-6ca540efa53b', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.585+02', 'provisioner', 'info', 'Stopping workspace', 'docker_volume.home_volume: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9024c014-1485-4898-bf29-ff6571b97df1', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.641+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Plan to delete') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e036d9e1-242f-4897-a359-c36c23289290', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.697+02', 'provisioner', 'info', 'Stopping workspace', 'Plan: 0 to add, 0 to change, 1 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('40dc26c3-26a7-45e6-a2da-f4edf2342786', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.781+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destroying... [id=ac6246e245cd13f504e2329deb065eb770d991094f046d9bff27152321a2c4c0]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1ff4318f-2bc4-40ec-93b6-9358b2fca74d', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.893+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destruction complete after 0s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f541be42-b16d-4680-9cff-da1949c264a8', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:31.949+02', 'provisioner', 'info', 'Stopping workspace', 'Apply complete! Resources: 0 added, 0 changed, 1 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d67dac84-c6fd-4cab-b722-77b69d5545ea', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:32.007+02', 'provisioner', 'info', 'Stopping workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a4e34646-f0fb-4721-a032-dcbe52359207', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 13:40:32.066+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('433a18bd-030e-4bff-9f1e-f0225d14a856', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:38.219+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f82412fb-358f-4b2d-b573-e667dc54556a', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:38.277+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cd4619df-066f-47c1-a0f8-43120e743296', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:38.676+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('56da4bd2-55fe-46e8-85ec-597809187b3e', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:38.734+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e598fe69-c2d6-4383-8e29-65e26c71fd85', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:38.791+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6e6bfc11-5de8-4e9e-9aa4-6a815f9e347e', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:38.905+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('21bd8c3a-830c-4905-8b16-8af1b2494cb1', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:38.961+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0d0a0b1a-6451-460c-b4c7-a2b724881c68', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.019+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ba426acd-eaaa-4ceb-92fb-8ca8a903d4eb', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.101+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('34d30a90-63da-4453-b1ef-4909a6bdc0b4', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.158+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b192b0b2-8928-4200-a955-ba1652a95e86', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.218+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('94448a3b-c1ac-4d5a-b33e-2100ec86ca03', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.272+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4c8ed058-f5a0-48e8-b4c1-60b1929ff27f', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.329+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9aebd61e-1f60-477d-962c-7ca02af08b56', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.437+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3b194290-40bb-4ea8-8c82-a82078705f80', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.493+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('14a24d28-d269-447c-be72-8cba846a9c74', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.549+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f31600e5-3afa-4bfb-bdd2-52612589d79e', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.604+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bff65850-8b2f-4c8c-a7ee-31237e814d83', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.661+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f28cf170-1369-4c4b-a9fe-904f71522c90', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.716+02', 'provisioner', 'debug', 'Starting workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('7fefe7a4-4ec5-405e-986d-79c60c797640', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:51:59.861+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bb5f18d8-d84b-403c-b044-da0f6c107f96', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.773+02', 'provisioner', 'debug', 'Starting workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2ef7fb05-03b7-4f79-a7b3-65d7695d151d', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.831+02', 'provisioner', 'debug', 'Starting workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fff358a3-3dc7-4c79-9b74-e487cfd86ab7', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.94+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('efbb1402-b70e-4178-8d92-305b65cd7724', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:39.995+02', 'provisioner', 'debug', 'Starting workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('21fba8d4-6f6b-4f1d-aa04-3778462e6509', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.049+02', 'provisioner', 'debug', 'Starting workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('afe38838-eacc-4c31-9dda-4112d5fc7a47', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.106+02', 'provisioner', 'debug', 'Starting workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e8d77ad5-b199-4496-806f-47ab00025af4', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.161+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.2.1') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('78672262-097f-4be9-a727-d821a0e5caed', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.216+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0d46f9f8-a438-40cb-ac62-750dca7c9cf4', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.272+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Refreshing state... [id=3e6b9490-1b41-4939-9b01-895076085bb5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('81ccd5fb-0862-453e-b189-e57c0ac1e651', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.331+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=b90547be-8870-4d68-8184-e8b2242b7c01]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('dca31189-15e0-49ba-b9dd-904c3c68efe5', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.439+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Refresh complete [id=3e6b9490-1b41-4939-9b01-895076085bb5]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8b557a7f-13e9-4db5-aac5-4562e08dc59b', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.496+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Refreshing state... [id=0c1e02cf-43be-47cf-a012-0b98168dfd48]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('66e994a7-43c3-4286-a16e-cd8eb7f9708c', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.554+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Refresh complete [id=0c1e02cf-43be-47cf-a012-0b98168dfd48]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('aa87ffe3-1f15-4dd9-afe8-6076d7d7c1d1', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.609+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('48cc2ed7-680c-49e1-9824-c9771e89f379', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.668+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-test1-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('417a7710-9fdd-4193-adac-0f6c7eeccc62', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.723+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f9cbdb13-77b5-4fa3-a7df-e0e5a6b3aee9', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.835+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ea8d8135-9b18-411e-8e3d-2f2aaaa35b06', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.892+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 1 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('373911d4-92c4-4f7f-b0e0-7d307c90a43b', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:40.947+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('92d37c54-5b54-4e25-8c8c-a0d9cc7e60d2', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:41.01+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=5c59cbbfcab900833dd9e3d232ddcce9916f6c194f526bac5811bdc1c7d17193]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0304f9ca-b37d-463b-aca9-970287265bb5', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:41.067+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 1 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e86bee49-c6c6-4b86-bf41-22d15fd7c110', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:41.122+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3de0bb6c-ddee-4ab7-afd0-9ec88e019231', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-02 13:51:41.61+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bc262c73-c3dc-4cb5-a9e9-49d1a0b1f005', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:43.715+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9867bebc-f99d-4f85-a7a3-2a0d174c1810', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:43.772+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('60df5d1b-984e-4160-8b81-b11274426d3c', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:43.913+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('95d3767e-eca8-4c9a-b5db-0fb01acfadd2', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:43.968+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('24fe0c9e-43b4-483a-bf0b-202232a1e63c', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.024+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('579e60bf-6a9e-4bab-a120-3b77ff53ba9e', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.079+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b635b0e1-7530-4ae1-8b61-0d70f7a0a5b8', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.134+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('420e2250-d0c9-4db0-9ea2-b03b6c726de4', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.188+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2ec256d5-b793-4b9f-8b4c-3280cc7f1d80', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.244+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('07562f80-ad85-4323-8193-ea831b4c457d', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.306+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('652d7b78-632b-4989-99b8-3742c362ddc6', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.408+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e30b513a-eec3-467e-8c7a-e2f50f977109', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.464+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d6c6afce-fe21-4db0-86a8-8ab5ce17e5b6', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.52+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a4f69e93-c42d-490a-90b1-d4bdcd10cfd3', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.574+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0a0cf74f-fe71-4fa7-848b-392cbfb741a2', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.628+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('40ef90f5-e5fb-4e2f-b495-195cb61047cb', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.682+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('912fe0ec-1aba-4d71-847c-3c6d4f1f0b25', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.736+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4b488b80-68c2-40a0-a23e-86924af77861', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.791+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c9b8c3fa-bd93-49e7-bf11-0fe94995845a', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.897+02', 'provisioner', 'debug', 'Starting workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b06eb620-c5d4-4383-bb7b-b69812d31836', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:44.951+02', 'provisioner', 'debug', 'Starting workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9117b4a8-8e97-49a9-89d7-dc4248eaa066', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.004+02', 'provisioner', 'debug', 'Starting workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9842d549-76f0-4a08-8be0-90a988cda1d8', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.058+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9c03807b-2741-4054-9b4b-ad6bd5c07884', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.112+02', 'provisioner', 'debug', 'Starting workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('da262a7f-4496-40ac-934c-cf11e7cc8e09', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.169+02', 'provisioner', 'debug', 'Starting workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ce2be81e-e45e-49f7-b6eb-4c2f9580d6a7', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.224+02', 'provisioner', 'debug', 'Starting workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('11f3f3aa-7ebc-4fbc-b741-edfb62615355', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.333+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.2.1') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f409dc62-6dc4-4e32-9c66-e5dde7540729', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.388+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Refreshing state... [id=417c5589-acba-45fb-9cf0-c2ccb5453084]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('656c2df5-925c-4ff5-b33f-4df4e8aeb564', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.443+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f4784a6c-52d0-4444-944f-963132d6559a', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.498+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Refresh complete [id=417c5589-acba-45fb-9cf0-c2ccb5453084]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('37886c01-ef81-487d-ba94-ece24531c546', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.552+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=759f94c0-2e14-4a48-8d9e-6507a38e156a]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cd26e54f-b19c-4c47-bd62-0e8d33a58afa', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.605+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refreshing state... [id=coder-oauthuser1-test2-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e6b7dfc6-7bac-4f06-ac17-ba7f4e0ddbe6', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:51:59.715+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3b6b56f1-494d-4c05-a44c-7ba83d57ff38', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.66+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Refresh complete [id=coder-oauthuser1-test2-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('69d88c94-7f32-4e97-b988-db725e12bc66', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.715+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Refreshing state... [id=sha256:b142766280c01c7fd7c4904061ecd7ee720c508b83ef5b8ca0793267e779b446coder-base-oauthuser1-test2]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4b4b133c-0341-4cc1-a101-c31307a3c184', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.769+02', 'provisioner', 'info', 'Starting workspace', 'docker_image.coder_image: Refresh complete [id=sha256:b142766280c01c7fd7c4904061ecd7ee720c508b83ef5b8ca0793267e779b446coder-base-oauthuser1-test2]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('372dc5a9-0be3-4e42-8dc7-568770639ba6', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.877+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Drift detected (update)') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cdf6d977-50b3-4e15-b97c-330d92ee1f30', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.932+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bd7c1717-f6af-4331-8dde-3577ace8996e', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:45.986+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 1 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a5c5335c-6694-41c1-973b-6cfa035d99e3', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:46.04+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a07da401-30cd-40ca-8a27-67e907052f21', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:46.094+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 1s [id=0158e10a9d461ee6fe1ade0cdf994acc8cf1048c83edae83d42bbb4d083cbbd3]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('07ac4b30-eff2-4dc0-adda-c0b028829c47', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:46.148+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 1 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('34e499fe-a5ed-4e36-ae6c-ee360262b7ff', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:46.204+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ed95b5b1-7394-4d67-9dc4-8c8b8e1d0f36', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 13:51:46.869+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e23f038b-7f48-4b74-9882-cbae0b31f286', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.216+02', 'provisioner_daemon', 'info', 'Setting up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('34347f74-ba67-4e73-b189-c836d90560eb', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.272+02', 'provisioner_daemon', 'info', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d5798809-953f-4c0c-83c7-2b50bc100ed6', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.415+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a941bded-ca33-445e-ab3b-9b1236bc4041', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.469+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9da1d88c-9441-45c1-be8c-344bc9de524f', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.525+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fa9d4d33-112c-4c2e-8c19-753fe1c2b8f7', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.58+02', 'provisioner', 'debug', 'Starting workspace', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bfb86b61-dadc-4728-8b60-7cb0b5c3570d', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.636+02', 'provisioner', 'debug', 'Starting workspace', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b31086e6-4131-4d3a-b9ba-7ef8a46fe15e', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.692+02', 'provisioner', 'debug', 'Starting workspace', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a9ee23a4-836d-4bb0-9c2b-3f3b1d2149d0', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.747+02', 'provisioner', 'debug', 'Starting workspace', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('83f19b1e-9d10-43a8-a103-ca97d36f09e8', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.8+02', 'provisioner', 'debug', 'Starting workspace', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1bb2abf4-fc6f-443b-9a3a-cf77964f85f9', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.912+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ba00d05c-aeb6-4866-90f6-eb1562c79fcc', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:02.967+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('4a86d635-a087-49fd-bf9c-23588f0907bb', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.022+02', 'provisioner', 'debug', 'Starting workspace', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2f7d8fe0-6b26-4219-b1a2-0a71a7451b15', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.077+02', 'provisioner', 'debug', 'Starting workspace', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('43b0c6ee-e74d-4d7d-938e-a8ef390bf295', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.132+02', 'provisioner', 'debug', 'Starting workspace', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c9147ba1-6f53-4e38-b742-51892fcd2974', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.186+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('08190cc3-e096-4d1f-8410-0fdb57b8f3f6', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.241+02', 'provisioner', 'debug', 'Starting workspace', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fa6ad3fc-f4f6-46a7-a5bf-313d9312e569', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.356+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9d8424a0-9ad9-4e1b-b597-20da44b582cf', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.414+02', 'provisioner', 'debug', 'Starting workspace', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3e667a19-4b91-4087-9897-fbfe1d7421f8', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.471+02', 'provisioner', 'debug', 'Starting workspace', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b8874d52-4281-44f9-aa7d-30bff01ff107', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.525+02', 'provisioner', 'debug', 'Starting workspace', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c0cb08a9-eae4-4cce-b89a-6904fcfe0f3c', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.581+02', 'provisioner', 'debug', 'Starting workspace', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0df6ee4a-db83-46d7-a1b1-67b916127e07', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.635+02', 'provisioner', 'debug', 'Starting workspace', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('635c16c8-62f5-47a5-a1ba-ab259bac7ab8', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.691+02', 'provisioner', 'debug', 'Starting workspace', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b5dac7a4-dcbc-4dd6-83f9-bc5daaa33651', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.751+02', 'provisioner', 'debug', 'Starting workspace', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c0bb87df-5b16-4a09-a665-d18bf08fe644', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.808+02', 'provisioner', 'info', 'Starting workspace', 'Terraform 1.2.1') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('35af7048-1a2f-45f7-92de-de499d1f4833', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.915+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cdff3cd5-65cb-41e5-a582-45814dc7dc61', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:05.244+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('49746b88-e5f8-402e-91ad-9a6f02c9e5c3', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:41.246+02', 'provisioner', 'info', 'Stopping workspace', 'docker_container.workspace[0]: Destruction complete after 1s') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('0f648cb0-45a9-4470-8d26-2686bdff4cb5', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:41.354+02', 'provisioner', 'info', 'Stopping workspace', 'Apply complete! Resources: 0 added, 0 changed, 1 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('5bcdf72e-657d-4d6c-b1c4-3b7d911f8797', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:41.408+02', 'provisioner', 'info', 'Stopping workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('01c6a195-242c-47a8-baae-9b2e229b97b4', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 14:02:41.514+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8ea74886-d58f-412d-9f93-cbff6270dff3', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:51:59.917+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing the backend...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cd88d48b-ea18-4dd9-b7fd-dae817c3b309', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:51:59.974+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('9a0f36f7-0ba8-468b-90e3-4f882a98d7f6', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.031+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Initializing provider plugins...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f83427a8-85fc-4711-b721-f495324cdf74', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.086+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding coder/coder versions matching "0.4.2"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('cea90418-bf7f-4787-ae6c-99924c88b036', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.144+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Finding kreuzwerker/docker versions matching "~> 2.16.0"...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8e8fd932-78c2-4fb1-9f50-b7006e47fb13', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.198+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using coder/coder v0.4.2 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a7a96d3c-33d1-483d-aa0e-39d291ac9658', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.256+02', 'provisioner', 'debug', 'Detecting persistent resources', '- Using kreuzwerker/docker v2.16.0 from the shared cache directory') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e803bcd3-7f17-433d-966e-110e82722ea2', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.312+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f2378cff-273f-49ad-a8e5-9e3a2e3a065c', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.42+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has created a lock file .terraform.lock.hcl to record the provider') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('e70fa3e6-7769-43fe-8acb-126f21479031', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.476+02', 'provisioner', 'debug', 'Detecting persistent resources', 'selections it made above. Include this file in your version control repository') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d2e3fd86-cfd9-423d-8f66-b374dc8a02cd', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.532+02', 'provisioner', 'debug', 'Detecting persistent resources', 'so that Terraform can guarantee to make the same selections by default when') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fccee4e4-0edd-4458-8e1d-f3d6bf831035', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.589+02', 'provisioner', 'debug', 'Detecting persistent resources', 'you run "terraform init" in the future.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8dce9262-3137-4a29-a793-9ee19c73d738', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.645+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('fbadca16-0f09-40d8-a224-8c4b528dacb7', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.701+02', 'provisioner', 'debug', 'Detecting persistent resources', 'Terraform has been successfully initialized!') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('69b49092-f28c-406e-a164-05098591aea4', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.758+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b068508f-ed24-47d6-928b-e9a61ce3dfde', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.813+02', 'provisioner', 'debug', 'Detecting persistent resources', 'You may now begin working with Terraform. Try running "terraform plan" to see') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8979a1ef-bcff-443e-acde-c269c9a7acdf', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.924+02', 'provisioner', 'debug', 'Detecting persistent resources', 'any changes that are required for your infrastructure. All Terraform commands') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('f79e995e-bedd-49c0-864f-1059594b3cfa', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:00.979+02', 'provisioner', 'debug', 'Detecting persistent resources', 'should now work.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2fb000ce-2417-4923-9ddf-343122039321', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.034+02', 'provisioner', 'debug', 'Detecting persistent resources', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2799772b-f3e1-4053-80e9-6dce2f33485a', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.09+02', 'provisioner', 'debug', 'Detecting persistent resources', 'If you ever set or change modules or backend configuration for Terraform,') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d261ecc3-ce6e-4547-9732-0041e6e96eb5', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.147+02', 'provisioner', 'debug', 'Detecting persistent resources', 'rerun this command to reinitialize your working directory. If you forget, other') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1ec1676b-09e2-4475-80af-894786102450', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.204+02', 'provisioner', 'debug', 'Detecting persistent resources', 'commands will detect it and remind you to do so if necessary.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('050e3e4f-ab05-438e-a864-9beb0af6d0cd', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.259+02', 'provisioner', 'info', 'Detecting persistent resources', 'Terraform 1.2.1') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('257a893e-16f0-402b-8916-df4c18faf490', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.367+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refreshing...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('05a9ebad-d347-49ad-96cc-3a1e510ea901', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.436+02', 'provisioner', 'info', 'Detecting persistent resources', 'data.coder_workspace.me: Refresh complete after 0s [id=01138385-1152-4c7c-a06e-fe08518f6160]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('53299d0d-cb3b-462d-800b-415b60a4006f', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.491+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2bec57ca-5897-4581-9667-2c8d5a0d5d75', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.545+02', 'provisioner', 'info', 'Detecting persistent resources', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c5f4028a-e379-4296-b786-b860b4876208', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.6+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('2609f3e8-9a4b-4336-a183-bc002334af20', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.654+02', 'provisioner', 'info', 'Detecting persistent resources', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('53223d06-4523-40cc-a47b-7010d88edbf1', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.708+02', 'provisioner', 'info', 'Detecting persistent resources', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ee11992d-332f-4912-a517-0ac217003918', '618c230b-cac0-4cf5-b801-900ca7540362', '2022-11-02 13:52:01.763+02', 'provisioner_daemon', 'info', 'Cleaning Up', '') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('c6e54c0d-52a4-4c9a-868a-3491b19d0c0d', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:03.969+02', 'provisioner', 'info', 'Starting workspace', 'data.coder_workspace.me: Refresh complete after 0s [id=9cf0c44c-f931-43fc-bf4e-6d3624eb3037]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('ea1bce81-1d05-47ed-b672-5d8597e5c872', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.024+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('66ef2642-a3be-44fb-8d03-d332bca42e86', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.081+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6a1d74f5-f3e2-43d2-baa3-a0e7d0827849', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.137+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('d2832719-d30c-4cd2-984b-9ced12606b54', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.194+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Plan to create') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('b3e2940b-7975-4509-8879-d2200aa41f9e', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.251+02', 'provisioner', 'info', 'Starting workspace', 'Plan: 4 to add, 0 to change, 0 to destroy.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3e3543aa-d0ed-46c7-981d-0d4593191e5f', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.305+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('8723c9db-8984-4902-9ef1-91bf74d402a6', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.415+02', 'provisioner', 'info', 'Starting workspace', 'coder_agent.dev: Creation complete after 0s [id=c64f6ae8-d97d-49f9-b9b6-aab5fdcfb5d7]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('a35d3627-af8e-43c2-8dc1-a745f2c66d9a', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.471+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('6c677721-9e6d-4499-a68d-8f2dc762ea1e', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.527+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('1dcdf0a1-52e1-4b70-bee5-015a1886b3dc', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.582+02', 'provisioner', 'info', 'Starting workspace', 'coder_app.code-server: Creation complete after 0s [id=1202a4b0-79a4-45fd-9504-9306939eb300]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('db6c58d8-656c-499e-9c2b-0d0d5281ca81', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.636+02', 'provisioner', 'info', 'Starting workspace', 'docker_volume.home_volume: Creation complete after 0s [id=coder-oauthuser1-test3-root]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('3d81b241-36e7-468b-848c-c734d43f88a0', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.692+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creating...') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('15255b40-0b4b-44fb-a108-2cab89ae6bde', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.747+02', 'provisioner', 'info', 'Starting workspace', 'docker_container.workspace[0]: Creation complete after 0s [id=9e3d8de3ea812697c4696531e889022339f478f9ea9212d0e04723f2a4121cb1]') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('48720766-af8a-4b9c-a69c-9bbe06c391e6', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.803+02', 'provisioner', 'info', 'Starting workspace', 'Apply complete! Resources: 4 added, 0 changed, 0 destroyed.') ON CONFLICT DO NOTHING;
INSERT INTO public.provisioner_job_logs VALUES ('bf8ab758-566f-447b-af50-4e399bf29446', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 13:52:04.915+02', 'provisioner', 'info', 'Starting workspace', 'Outputs: 0') ON CONFLICT DO NOTHING;


--
-- Data for Name: schema_migrations; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.schema_migrations VALUES (49, false) ON CONFLICT DO NOTHING;


--
-- Data for Name: site_configs; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.site_configs VALUES ('deployment_id', '28e7e7b9-8fea-4fab-9106-57352863a6be') ON CONFLICT DO NOTHING;


--
-- Data for Name: templates; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.templates VALUES ('4cc1f466-f326-477e-8762-9d0c6781fc56', '2022-11-02 13:03:56.718393+02', '2022-11-02 13:31:37.692785+02', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', false, 'docker-code-server', 'terraform', 'e5cccf07-4953-48be-85ac-ed35328f1787', '', 604800000000000, 3600000000000, '30095c71-380b-457a-8995-97b8ee6e5307', '') ON CONFLICT DO NOTHING;
INSERT INTO public.templates VALUES ('34dcb3ce-ad41-4f52-8cba-3b0197ac7c24', '2022-11-02 13:36:33.481962+02', '2022-11-02 13:58:34.43998+02', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', false, 'docker-image-builds', 'terraform', '9d654133-cddb-4ca4-9de1-b1363f8fc853', 'Images of the Docker!', 72000000000000, 3600000000000, '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '/emojis/1fae0.png') ON CONFLICT DO NOTHING;


--
-- Data for Name: template_versions; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.template_versions VALUES ('7bd0d105-b085-4a4d-8d04-6778b8f3cb94', '34dcb3ce-ad41-4f52-8cba-3b0197ac7c24', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:36:26.691085+02', '0001-01-01 01:39:49+01:39:49', 'hopeful_kalam6', '---
name: Develop in Docker with custom image builds
description: Build images and run workspaces on the Docker host with no image registry required
tags: [local, docker]
---

# docker-image-builds

This example bundles Dockerfiles with the Coder template, allowing the Docker host to build images itself instead of relying on an external registry.

For large use cases, we recommend building images using CI/CD pipelines and registries instead of at workspace runtime. However, this example is practical for tinkering and iterating on Dockerfiles.

## Getting started

Run `coder templates init`. When prompted, select this template, and follow the
on-screen instructions to proceed.

## Adding images

Create a Dockerfile (e.g `images/golang.Dockerfile`):

```sh
vim images/golang.Dockerfile
```

```Dockerfile
# Start from base image (built on Docker host)
FROM coder-base:latest

# Install everything as root
USER root

# Install go
RUN curl -L "https://dl.google.com/go/go1.18.1.linux-amd64.tar.gz" | tar -C /usr/local -xzvf -

# Setup go env vars
ENV GOROOT /usr/local/go
ENV PATH $PATH:$GOROOT/bin

ENV GOPATH /home/coder/go
ENV GOBIN $GOPATH/bin
ENV PATH $PATH:$GOBIN

# Set back to coder user
USER coder
```

Edit the Terraform template (`main.tf`):

```sh
vim main.tf
```

Edit the validation to include the new image:

```diff
variable "docker_image" {
    description = "What Docker image would you like to use for your workspace?"
    default     = "base"

    # List of images available for the user to choose from.
    # Delete this condition to give users free text input.
    validation {
-       condition     = contains(["base", "java", "node"], var.docker_image)
+       condition     = contains(["base", "java", "node", "golang], var.docker_image)
        error_message = "Invalid Docker image!"
    }
}
```

Bump the image tag to a new version:

```diff
resource "docker_image" "coder_image" {
    name = "coder-base-${data.coder_workspace.me.owner}-${lower(data.coder_workspace.me.name)}"
    build {
        path       = "./images/"
        dockerfile = "${var.docker_image}.Dockerfile"
-        tag        = ["coder-${var.docker_image}:v0.1"]
+        tag        = ["coder-${var.docker_image}:v0.2"]
    }

    # Keep alive for other workspaces to use upon deletion
    keep_locally = true
}
```

Update the template:

```sh
coder template update docker-image-builds
```

You can also remove images from the validation list. Workspaces using older template versions will continue using
the removed image until you update the workspace to the latest version.

## Updating images

Edit the Dockerfile (or related assets):

```sh
vim images/node.Dockerfile
```

```diff
# Install Node
- RUN curl -sL https://deb.nodesource.com/setup_14.x | bash -
+ RUN curl -sL https://deb.nodesource.com/setup_16.x | bash -
RUN DEBIAN_FRONTEND="noninteractive" apt-get update -y && \
    apt-get install -y nodejs
```

1. Edit the Terraform template (`main.tf`)

```sh
vim main.tf
```

Bump the image tag to a new version:

```diff
resource "docker_image" "coder_image" {
    name = "coder-base-${data.coder_workspace.me.owner}-${lower(data.coder_workspace.me.name)}"
    build {
        path       = "./images/"
        dockerfile = "${var.docker_image}.Dockerfile"
-        tag        = ["coder-${var.docker_image}:v0.1"]
+        tag        = ["coder-${var.docker_image}:v0.2"]
    }

    # Keep alive for other workspaces to use upon deletion
    keep_locally = true
}
```

Update the template:

```sh
coder template update docker-image-builds
```

Optional: Update workspaces to the latest template version

```sh
coder ls
coder update [workspace name]
```

## Extending this template

See the [kreuzwerker/docker](https://registry.terraform.io/providers/kreuzwerker/docker) Terraform provider documentation to
add the following features to your Coder template:

- SSH/TCP docker host
- Build args
- Volume mounts
- Custom container spec
- More

We also welcome all contributions!
', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', '0ed9befc-4911-4ccf-a8e2-559bf72daa94') ON CONFLICT DO NOTHING;
INSERT INTO public.template_versions VALUES ('920baba5-4c64-4686-8b7d-d1bef5683eae', '4cc1f466-f326-477e-8762-9d0c6781fc56', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:03:31.676657+02', '0001-01-01 01:39:49+01:39:49', 'trusting_lamport1', '---
name: Develop code-server in Docker
description: Run code-server in a Docker development environment
tags: [local, docker]
---

# code-server in Docker

## Getting started

Run `coder templates init` and select this template. Follow the instructions that appear.

## Supported Parameters

You can create a file containing parameters and pass the argument
`--parameter-file` to `coder templates create`.
See `params.sample.yaml` for more information.

This template has the following predefined parameters:

- `docker_host`: Path to (or address of) the Docker socket.
  > You can determine the correct value for this by running
  > `docker context ls`.
- `docker_arch`: Architecture of the host running Docker.
  This can be `amd64`, `arm64`, or `armv7`.
', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', '30095c71-380b-457a-8995-97b8ee6e5307') ON CONFLICT DO NOTHING;
INSERT INTO public.template_versions VALUES ('4e681a60-83da-42c2-902e-6535376ebb77', '4cc1f466-f326-477e-8762-9d0c6781fc56', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:07:52.490041+02', '2022-11-02 13:07:52.950734+02', 'thirsty_williamson6', '---
name: Develop code-server in Docker
description: Run code-server in a Docker development environment
tags: [local, docker]
---

# code-server in Docker

## Getting started

Run `coder templates init` and select this template. Follow the instructions that appear.

## Supported Parameters

You can create a file containing parameters and pass the argument
`--parameter-file` to `coder templates create`.
See `params.sample.yaml` for more information.

This template has the following predefined parameters:

- `docker_host`: Path to (or address of) the Docker socket.
  > You can determine the correct value for this by running
  > `docker context ls`.
- `docker_arch`: Architecture of the host running Docker.
  This can be `amd64`, `arm64`, or `armv7`.
', 'f042af17-e3a2-4194-af67-e416302bc860', '30095c71-380b-457a-8995-97b8ee6e5307') ON CONFLICT DO NOTHING;
INSERT INTO public.template_versions VALUES ('2ad7ab14-be7e-4f55-bc87-9fb6a43b9968', NULL, 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:36:23.415146+02', '2022-11-02 13:36:23.783425+02', 'lucid_ardinghelli9', '---
name: Develop in Docker with custom image builds
description: Build images and run workspaces on the Docker host with no image registry required
tags: [local, docker]
---

# docker-image-builds

This example bundles Dockerfiles with the Coder template, allowing the Docker host to build images itself instead of relying on an external registry.

For large use cases, we recommend building images using CI/CD pipelines and registries instead of at workspace runtime. However, this example is practical for tinkering and iterating on Dockerfiles.

## Getting started

Run `coder templates init`. When prompted, select this template, and follow the
on-screen instructions to proceed.

## Adding images

Create a Dockerfile (e.g `images/golang.Dockerfile`):

```sh
vim images/golang.Dockerfile
```

```Dockerfile
# Start from base image (built on Docker host)
FROM coder-base:latest

# Install everything as root
USER root

# Install go
RUN curl -L "https://dl.google.com/go/go1.18.1.linux-amd64.tar.gz" | tar -C /usr/local -xzvf -

# Setup go env vars
ENV GOROOT /usr/local/go
ENV PATH $PATH:$GOROOT/bin

ENV GOPATH /home/coder/go
ENV GOBIN $GOPATH/bin
ENV PATH $PATH:$GOBIN

# Set back to coder user
USER coder
```

Edit the Terraform template (`main.tf`):

```sh
vim main.tf
```

Edit the validation to include the new image:

```diff
variable "docker_image" {
    description = "What Docker image would you like to use for your workspace?"
    default     = "base"

    # List of images available for the user to choose from.
    # Delete this condition to give users free text input.
    validation {
-       condition     = contains(["base", "java", "node"], var.docker_image)
+       condition     = contains(["base", "java", "node", "golang], var.docker_image)
        error_message = "Invalid Docker image!"
    }
}
```

Bump the image tag to a new version:

```diff
resource "docker_image" "coder_image" {
    name = "coder-base-${data.coder_workspace.me.owner}-${lower(data.coder_workspace.me.name)}"
    build {
        path       = "./images/"
        dockerfile = "${var.docker_image}.Dockerfile"
-        tag        = ["coder-${var.docker_image}:v0.1"]
+        tag        = ["coder-${var.docker_image}:v0.2"]
    }

    # Keep alive for other workspaces to use upon deletion
    keep_locally = true
}
```

Update the template:

```sh
coder template update docker-image-builds
```

You can also remove images from the validation list. Workspaces using older template versions will continue using
the removed image until you update the workspace to the latest version.

## Updating images

Edit the Dockerfile (or related assets):

```sh
vim images/node.Dockerfile
```

```diff
# Install Node
- RUN curl -sL https://deb.nodesource.com/setup_14.x | bash -
+ RUN curl -sL https://deb.nodesource.com/setup_16.x | bash -
RUN DEBIAN_FRONTEND="noninteractive" apt-get update -y && \
    apt-get install -y nodejs
```

1. Edit the Terraform template (`main.tf`)

```sh
vim main.tf
```

Bump the image tag to a new version:

```diff
resource "docker_image" "coder_image" {
    name = "coder-base-${data.coder_workspace.me.owner}-${lower(data.coder_workspace.me.name)}"
    build {
        path       = "./images/"
        dockerfile = "${var.docker_image}.Dockerfile"
-        tag        = ["coder-${var.docker_image}:v0.1"]
+        tag        = ["coder-${var.docker_image}:v0.2"]
    }

    # Keep alive for other workspaces to use upon deletion
    keep_locally = true
}
```

Update the template:

```sh
coder template update docker-image-builds
```

Optional: Update workspaces to the latest template version

```sh
coder ls
coder update [workspace name]
```

## Extending this template

See the [kreuzwerker/docker](https://registry.terraform.io/providers/kreuzwerker/docker) Terraform provider documentation to
add the following features to your Coder template:

- SSH/TCP docker host
- Build args
- Volume mounts
- Custom container spec
- More

We also welcome all contributions!
', '391d562a-af1a-4f4c-81d3-244f3006d9c7', NULL) ON CONFLICT DO NOTHING;
INSERT INTO public.template_versions VALUES ('aae091e3-6c40-4996-a35c-ca6c4614de26', '4cc1f466-f326-477e-8762-9d0c6781fc56', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:30:29.730524+02', '2022-11-02 13:30:30.277421+02', 'sad_hawking5', '---
name: Develop code-server in Docker
description: Run code-server in a Docker development environment
tags: [local, docker]
---

# code-server in Docker

## Getting started

Run `coder templates init` and select this template. Follow the instructions that appear.

## Supported Parameters

You can create a file containing parameters and pass the argument
`--parameter-file` to `coder templates create`.
See `params.sample.yaml` for more information.

This template has the following predefined parameters:

- `docker_host`: Path to (or address of) the Docker socket.
  > You can determine the correct value for this by running
  > `docker context ls`.
- `docker_arch`: Architecture of the host running Docker.
  This can be `amd64`, `arm64`, or `armv7`.
', 'ef8d15e3-0cab-4e83-b576-9fd27a680217', '30095c71-380b-457a-8995-97b8ee6e5307') ON CONFLICT DO NOTHING;
INSERT INTO public.template_versions VALUES ('5237169c-ca6c-4de0-8803-221dc1ed65f0', '4cc1f466-f326-477e-8762-9d0c6781fc56', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:30:34.845128+02', '2022-11-02 13:30:35.272313+02', 'stupefied_curie3', '---
name: Develop code-server in Docker
description: Run code-server in a Docker development environment
tags: [local, docker]
---

# code-server in Docker

## Getting started

Run `coder templates init` and select this template. Follow the instructions that appear.

## Supported Parameters

You can create a file containing parameters and pass the argument
`--parameter-file` to `coder templates create`.
See `params.sample.yaml` for more information.

This template has the following predefined parameters:

- `docker_host`: Path to (or address of) the Docker socket.
  > You can determine the correct value for this by running
  > `docker context ls`.
- `docker_arch`: Architecture of the host running Docker.
  This can be `amd64`, `arm64`, or `armv7`.
', 'ba1deb9c-0e65-4849-9ac8-c1652bffd2a0', '30095c71-380b-457a-8995-97b8ee6e5307') ON CONFLICT DO NOTHING;
INSERT INTO public.template_versions VALUES ('ed79177a-3e97-4915-94e8-1a29d3d6edab', '4cc1f466-f326-477e-8762-9d0c6781fc56', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:30:44.583354+02', '2022-11-02 13:30:44.769519+02', 'bold_ellis1', '---
name: Develop code-server in Docker
description: Run code-server in a Docker development environment
tags: [local, docker]
---

# code-server in Docker

## Getting started

Run `coder templates init` and select this template. Follow the instructions that appear.

## Supported Parameters

You can create a file containing parameters and pass the argument
`--parameter-file` to `coder templates create`.
See `params.sample.yaml` for more information.

This template has the following predefined parameters:

- `docker_host`: Path to (or address of) the Docker socket.
  > You can determine the correct value for this by running
  > `docker context ls`.
- `docker_arch`: Architecture of the host running Docker.
  This can be `amd64`, `arm64`, or `armv7`.
', '1fca6797-88f0-4772-9873-b2a6e6a0bf16', '30095c71-380b-457a-8995-97b8ee6e5307') ON CONFLICT DO NOTHING;
INSERT INTO public.template_versions VALUES ('e5cccf07-4953-48be-85ac-ed35328f1787', '4cc1f466-f326-477e-8762-9d0c6781fc56', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:31:32.812102+02', '2022-11-02 13:31:33.270724+02', 'pedantic_satoshi9', '---
name: Develop code-server in Docker
description: Run code-server in a Docker development environment
tags: [local, docker]
---

# code-server in Docker

## Getting started

Run `coder templates init` and select this template. Follow the instructions that appear.

## Supported Parameters

You can create a file containing parameters and pass the argument
`--parameter-file` to `coder templates create`.
See `params.sample.yaml` for more information.

This template has the following predefined parameters:

- `docker_host`: Path to (or address of) the Docker socket.
  > You can determine the correct value for this by running
  > `docker context ls`.
- `docker_arch`: Architecture of the host running Docker.
  This can be `amd64`, `arm64`, or `armv7`.
', '8cff6071-0a97-4c99-9fff-dc3507dd259b', '30095c71-380b-457a-8995-97b8ee6e5307') ON CONFLICT DO NOTHING;
INSERT INTO public.template_versions VALUES ('9d654133-cddb-4ca4-9de1-b1363f8fc853', '34dcb3ce-ad41-4f52-8cba-3b0197ac7c24', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '2022-11-02 13:57:17.378824+02', '2022-11-02 13:57:17.827975+02', 'eager_booth3', '---
name: Develop in Docker with custom image builds
description: Build images and run workspaces on the Docker host with no image registry required
tags: [local, docker]
---

# docker-image-builds

This example bundles Dockerfiles with the Coder template, allowing the Docker host to build images itself instead of relying on an external registry.

For large use cases, we recommend building images using CI/CD pipelines and registries instead of at workspace runtime. However, this example is practical for tinkering and iterating on Dockerfiles.

## Getting started

Run `coder templates init`. When prompted, select this template, and follow the
on-screen instructions to proceed.

## Adding images

Create a Dockerfile (e.g `images/golang.Dockerfile`):

```sh
vim images/golang.Dockerfile
```

```Dockerfile
# Start from base image (built on Docker host)
FROM coder-base:latest

# Install everything as root
USER root

# Install go
RUN curl -L "https://dl.google.com/go/go1.18.1.linux-amd64.tar.gz" | tar -C /usr/local -xzvf -

# Setup go env vars
ENV GOROOT /usr/local/go
ENV PATH $PATH:$GOROOT/bin

ENV GOPATH /home/coder/go
ENV GOBIN $GOPATH/bin
ENV PATH $PATH:$GOBIN

# Set back to coder user
USER coder
```

Edit the Terraform template (`main.tf`):

```sh
vim main.tf
```

Edit the validation to include the new image:

```diff
variable "docker_image" {
    description = "What Docker image would you like to use for your workspace?"
    default     = "base"

    # List of images available for the user to choose from.
    # Delete this condition to give users free text input.
    validation {
-       condition     = contains(["base", "java", "node"], var.docker_image)
+       condition     = contains(["base", "java", "node", "golang], var.docker_image)
        error_message = "Invalid Docker image!"
    }
}
```

Bump the image tag to a new version:

```diff
resource "docker_image" "coder_image" {
    name = "coder-base-${data.coder_workspace.me.owner}-${lower(data.coder_workspace.me.name)}"
    build {
        path       = "./images/"
        dockerfile = "${var.docker_image}.Dockerfile"
-        tag        = ["coder-${var.docker_image}:v0.1"]
+        tag        = ["coder-${var.docker_image}:v0.2"]
    }

    # Keep alive for other workspaces to use upon deletion
    keep_locally = true
}
```

Update the template:

```sh
coder template push docker-image-builds
```

You can also remove images from the validation list. Workspaces using older template versions will continue using
the removed image until you update the workspace to the latest version.

## Updating images

Edit the Dockerfile (or related assets):

```sh
vim images/node.Dockerfile
```

```diff
# Install Node
- RUN curl -sL https://deb.nodesource.com/setup_14.x | bash -
+ RUN curl -sL https://deb.nodesource.com/setup_16.x | bash -
RUN DEBIAN_FRONTEND="noninteractive" apt-get update -y && \
    apt-get install -y nodejs
```

1. Edit the Terraform template (`main.tf`)

```sh
vim main.tf
```

Bump the image tag to a new version:

```diff
resource "docker_image" "coder_image" {
    name = "coder-base-${data.coder_workspace.me.owner}-${lower(data.coder_workspace.me.name)}"
    build {
        path       = "./images/"
        dockerfile = "${var.docker_image}.Dockerfile"
-        tag        = ["coder-${var.docker_image}:v0.1"]
+        tag        = ["coder-${var.docker_image}:v0.2"]
    }

    # Keep alive for other workspaces to use upon deletion
    keep_locally = true
}
```

Update the template:

```sh
coder template push docker-image-builds
```

Optional: Update workspaces to the latest template version

```sh
coder ls
coder update [workspace name]
```

## code-server

`code-server` is installed via the `startup_script` argument in the `coder_agent`
resource block. The `coder_app` resource is defined to access `code-server` through
the dashboard UI over `localhost:13337`.

## Extending this template

See the [kreuzwerker/docker](https://registry.terraform.io/providers/kreuzwerker/docker) Terraform provider documentation to
add the following features to your Coder template:

- SSH/TCP docker host
- Build args
- Volume mounts
- Custom container spec
- More

We also welcome all contributions!
', '6f457831-78b1-4bec-ab06-026a554058f5', '30095c71-380b-457a-8995-97b8ee6e5307') ON CONFLICT DO NOTHING;


--
-- Data for Name: user_links; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.user_links VALUES ('0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'github', '115565016', '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', '', '0001-01-01 01:39:49+01:39:49') ON CONFLICT DO NOTHING;


--
-- Data for Name: workspace_resources; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.workspace_resources VALUES ('0ff953c0-92a6-4fe6-a415-eb0139a36ad1', '2022-11-02 13:03:45.043403+02', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('82d290df-0aa7-4514-9db8-e4e573442c6e', '2022-11-02 13:03:45.050988+02', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('1188c596-990b-4754-9e36-aaa013b9ea9a', '2022-11-02 13:03:45.053839+02', 'f1392ef5-2502-4474-9f0c-98b5cad6edf0', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('de5e9eeb-f2d1-4fae-a0f4-3966f1a15554', '2022-11-02 13:04:14.068501+02', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('46b830e7-0b13-44f4-90ef-0e29e8f948e3', '2022-11-02 13:04:14.074875+02', '3013ee6d-3c8f-4dcf-8271-01fd1e88aba6', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('e1dde2c9-bfff-485b-9b85-9ce53a59b3ee', '2022-11-02 13:04:22.824216+02', '52a90399-a53d-4644-be3c-47ee18a5716e', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('9f9b17b8-a7eb-491b-adee-4224f1dca047', '2022-11-02 13:04:22.826459+02', '52a90399-a53d-4644-be3c-47ee18a5716e', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('d14ad764-3385-4276-8201-0d70935e4e50', '2022-11-02 13:04:51.507424+02', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('578765bb-bf7c-49b6-9d3e-5d089d68180d', '2022-11-02 13:04:58.764535+02', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('c192783d-bbdf-4a52-bd30-3da3321da46b', '2022-11-02 13:04:58.76647+02', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('93609df1-39ab-46e8-8fba-4d207cdbe461', '2022-11-02 13:05:43.879156+02', '4de9c41c-eb10-435a-8742-e8725e926a9d', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('03e8a6e1-4ec2-4115-9595-b0b6a0cbba82', '2022-11-02 13:05:43.881237+02', '4de9c41c-eb10-435a-8742-e8725e926a9d', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('e670ea5b-8a4e-4e5f-92e7-a46901474f26', '2022-11-02 13:06:08.661894+02', '424a58cb-61d6-4627-9907-613c396c4a38', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('4888064d-263c-4022-abdb-8816ac433c36', '2022-11-02 13:06:08.662461+02', '424a58cb-61d6-4627-9907-613c396c4a38', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('f8e41551-2add-4243-b174-ba5525ef3468', '2022-11-02 13:07:57.523213+02', 'f042af17-e3a2-4194-af67-e416302bc860', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('0405ee7f-ac1f-4ef3-839b-56476f9fc724', '2022-11-02 13:07:57.529989+02', 'f042af17-e3a2-4194-af67-e416302bc860', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('566883fd-d61f-427a-bbc7-16566923e613', '2022-11-02 13:07:57.531917+02', 'f042af17-e3a2-4194-af67-e416302bc860', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('35a7cc19-0816-40bd-930b-1afe28dfc656', '2022-11-02 13:08:10.803507+02', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('63d5f2c3-232f-4b83-b7c1-c148b773df23', '2022-11-02 13:08:10.80546+02', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('82efa58b-dafc-4cbd-b3d5-47229e151720', '2022-11-02 13:09:54.752163+02', '52874f66-89cc-4e6b-8066-80ba21ad9e57', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('8090fa9e-bc58-4dc4-ab96-053ea4e6fb62', '2022-11-02 13:10:45.608721+02', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('2c65c2ca-4009-4454-b1d5-b1ae7e64f04e', '2022-11-02 13:31:37.645936+02', '8cff6071-0a97-4c99-9fff-dc3507dd259b', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('9bbf2284-e7d3-4b2a-ac72-02af8b7a86c0', '2022-11-02 13:31:37.649084+02', '8cff6071-0a97-4c99-9fff-dc3507dd259b', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('cda50cf6-4a31-4abb-9c40-bfb2b940110e', '2022-11-02 13:31:37.652917+02', '8cff6071-0a97-4c99-9fff-dc3507dd259b', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('a5c9453b-c54e-4fde-949a-1fa0aa15c161', '2022-11-02 13:32:49.482965+02', '1a792c66-6721-4edf-91f7-cad106fa59be', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('06a3118a-7fc0-47ae-824d-d30721e6b22a', '2022-11-02 13:32:49.483648+02', '1a792c66-6721-4edf-91f7-cad106fa59be', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('6c6db170-40cc-44d0-8cc1-3d7fbd38c9e9', '2022-11-02 13:36:31.700087+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('80a30102-3b41-4a33-b34d-acf769591564', '2022-11-02 13:36:31.705739+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'start', 'docker_image', 'coder_image', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('28bf2b7f-d051-48d2-abc2-edd94bea0cc7', '2022-11-02 13:36:31.709249+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('daf76b44-539e-4c79-a285-634d4d703456', '2022-11-02 13:36:31.711715+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'stop', 'docker_image', 'coder_image', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('99043b72-ef27-46eb-9753-7e42da32ada1', '2022-11-02 13:36:31.713324+02', '8cbdb824-fe5d-4496-8f87-e2c31d24d442', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('75ccccf5-a4d4-4db3-8fb1-5227918ec820', '2022-11-02 13:37:07.215965+02', 'a122c783-ae3a-493a-8c26-f29cf791fb98', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('87203600-12f5-4790-bec6-ec34a10b102a', '2022-11-02 13:37:07.220495+02', 'a122c783-ae3a-493a-8c26-f29cf791fb98', 'start', 'docker_image', 'coder_image', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('f2c503c1-2dbf-49e4-b317-38f23e77a278', '2022-11-02 13:37:07.222929+02', 'a122c783-ae3a-493a-8c26-f29cf791fb98', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('de164a7d-aee7-4096-a3fe-436487011ce9', '2022-11-02 13:38:55.831805+02', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('45127244-d2fc-4e53-961b-7435f9877386', '2022-11-02 13:38:55.833771+02', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', 'start', 'docker_image', 'coder_image', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('db8f6601-5a1f-4c1f-88fd-c7e84741deac', '2022-11-02 13:38:55.834642+02', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('087e09f3-8593-40e9-833a-e2907128ed84', '2022-11-02 13:39:25.702645+02', 'a2487cf9-1199-4304-9fa1-96e5d593482c', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('2fda48bb-fe19-4033-b5b0-c645d99183e1', '2022-11-02 13:39:25.709045+02', 'a2487cf9-1199-4304-9fa1-96e5d593482c', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('2bf7ffe2-a06d-42c5-b7cd-cb8be1b5a98e', '2022-11-02 13:39:29.585978+02', '98095cd7-567d-4925-a447-646669dd8b92', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('96801b4b-3641-4c96-94b0-0e0853d7a6af', '2022-11-02 13:39:29.587334+02', '98095cd7-567d-4925-a447-646669dd8b92', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('86bef0c3-f70c-481b-bdf0-adade8017dbe', '2022-11-02 13:40:27.324041+02', '549537f9-6c99-478c-9c7c-faa1382af4be', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('fb00cf0e-7513-4295-98f4-a83ac5136f17', '2022-11-02 13:40:32.183974+02', 'dce50249-2e82-4652-8bef-d6be0761c5f2', 'stop', 'docker_image', 'coder_image', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('98370502-0de4-4179-8181-d9d42e6a5d80', '2022-11-02 13:40:32.184497+02', 'dce50249-2e82-4652-8bef-d6be0761c5f2', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('6e7bb1a1-d8ce-4c8f-98b6-89b2bb30127a', '2022-11-02 13:51:41.72068+02', '160a355d-dc14-419c-86f7-d3fc4a1aa150', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('1840656b-e464-4625-9323-c359d0b96e22', '2022-11-02 13:51:41.721351+02', '160a355d-dc14-419c-86f7-d3fc4a1aa150', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('b98c7b45-1ebc-4c5d-b337-7c2f705a5613', '2022-11-02 13:51:46.984975+02', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('40e336e6-ad14-4191-933d-152092b9c697', '2022-11-02 13:51:46.986793+02', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', 'start', 'docker_image', 'coder_image', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('08e51e41-a497-486b-97fd-70f5d1f30dd2', '2022-11-02 13:51:46.987503+02', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('867b5f9f-80ed-4409-8647-2388dfa04ac3', '2022-11-02 13:52:01.926551+02', '618c230b-cac0-4cf5-b801-900ca7540362', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('cb96bcb9-0eff-4a9b-a3a8-6ac1ccb32650', '2022-11-02 13:52:01.931453+02', '618c230b-cac0-4cf5-b801-900ca7540362', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('b22992bf-9280-4144-ad3a-c904e75b951a', '2022-11-02 13:52:05.386723+02', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('04a17047-08ec-43d1-9fb7-1371aa82d5cc', '2022-11-02 13:52:05.389255+02', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('6e37b16f-c7f1-4903-80a8-4bbce053fa5d', '2022-11-02 13:57:25.908775+02', '6f457831-78b1-4bec-ab06-026a554058f5', 'stop', 'docker_image', 'coder_image', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('f9fc7ab6-fb91-4e68-b28e-052dfe011115', '2022-11-02 13:57:25.911886+02', '6f457831-78b1-4bec-ab06-026a554058f5', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('e3a27917-3acd-4c2d-b222-ce47df030b58', '2022-11-02 13:57:25.914208+02', '6f457831-78b1-4bec-ab06-026a554058f5', 'start', 'docker_container', 'workspace', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('5aee1841-664a-4da7-92dc-19e40f8b8e55', '2022-11-02 13:57:25.919775+02', '6f457831-78b1-4bec-ab06-026a554058f5', 'start', 'docker_image', 'coder_image', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('441abf5d-0b15-472f-ab12-e5664261dab2', '2022-11-02 13:57:25.921134+02', '6f457831-78b1-4bec-ab06-026a554058f5', 'start', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_resources VALUES ('3ea4bfb6-335e-4bd8-a78a-c8d9a59c3be2', '2022-11-02 14:02:41.626641+02', '7c033919-59cc-4b4d-9261-38bb6cb848d9', 'stop', 'docker_volume', 'home_volume', false, '') ON CONFLICT DO NOTHING;


--
-- Data for Name: workspace_agents; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.workspace_agents VALUES ('45e89705-e09d-4850-bcec-f9a937f5d78d', '2022-11-02 13:03:45.046432+02', '2022-11-02 13:03:45.046432+02', 'main', NULL, NULL, NULL, '0ff953c0-92a6-4fe6-a415-eb0139a36ad1', 'ffc107ef-7ded-4d80-b1a9-0c1d0bf7ccbf', NULL, 'amd64', '{"GIT_AUTHOR_NAME": "default", "GIT_AUTHOR_EMAIL": "", "GIT_COMMITTER_NAME": "default", "GIT_COMMITTER_EMAIL": ""}', 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('a90934b3-34da-400a-a583-fa4dcb3b4668', '2022-11-02 13:04:14.070745+02', '2022-11-02 13:04:14.070745+02', 'main', NULL, NULL, NULL, 'de5e9eeb-f2d1-4fae-a0f4-3966f1a15554', '7703f4f1-210d-4c8f-a298-5803661cd7a7', NULL, 'amd64', '{"GIT_AUTHOR_NAME": "admin", "GIT_AUTHOR_EMAIL": "", "GIT_COMMITTER_NAME": "admin", "GIT_COMMITTER_EMAIL": ""}', 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('49ea7c9b-83b8-4d0e-b440-82a2df63ff91', '2022-11-02 13:31:37.650734+02', '2022-11-02 13:31:37.650734+02', 'dev', NULL, NULL, NULL, '9bbf2284-e7d3-4b2a-ac72-02af8b7a86c0', '251fbf7a-a4cc-43e0-955c-3a299d6e2ea4', NULL, 'amd64', NULL, 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('cd570f72-a5cf-4348-a044-a9cb8a6406f2', '2022-11-02 13:32:49.484198+02', '2022-11-02 13:40:23.573382+02', 'dev', '2022-11-02 13:32:53.56975+02', '2022-11-02 13:40:23.573381+02', NULL, '06a3118a-7fc0-47ae-824d-d30721e6b22a', 'f0f12418-e19b-45e5-85a7-53e93ffb0173', NULL, 'amd64', NULL, 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('f1395dc0-8905-4287-9bb9-14878c0bd500', '2022-11-02 13:39:25.705077+02', '2022-11-02 13:39:25.705077+02', 'dev', NULL, NULL, NULL, '087e09f3-8593-40e9-833a-e2907128ed84', '51181562-a38f-410b-8489-57e124f0b5ef', NULL, 'amd64', NULL, 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('42a22c7c-4878-4e9e-8dda-acda95b5243f', '2022-11-02 13:39:29.586382+02', '2022-11-02 13:39:45.968846+02', 'dev', '2022-11-02 13:39:33.964373+02', '2022-11-02 13:39:45.968845+02', NULL, '2bf7ffe2-a06d-42c5-b7cd-cb8be1b5a98e', '6215366c-a88c-45d2-964d-f18261149e25', NULL, 'amd64', NULL, 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('8fa17bbd-c48c-44c7-91ae-d4acbc755fad', '2022-11-02 13:04:22.825169+02', '2022-11-02 13:04:22.825169+02', 'main', '2022-11-02 13:04:23.19467+02', '2022-11-02 13:04:50.199604+02', NULL, 'e1dde2c9-bfff-485b-9b85-9ce53a59b3ee', '769edba1-bfcf-46bf-a5e8-0f2533d54f71', NULL, 'amd64', '{"GIT_AUTHOR_NAME": "admin", "GIT_AUTHOR_EMAIL": "", "GIT_COMMITTER_NAME": "admin", "GIT_COMMITTER_EMAIL": ""}', 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('ef095280-d76a-422d-812f-0991ad06f2de', '2022-11-02 13:07:57.525832+02', '2022-11-02 13:07:57.525832+02', 'main', NULL, NULL, NULL, 'f8e41551-2add-4243-b174-ba5525ef3468', '73b3a1d3-7f78-43d6-8c97-4ccb70bb5cc2', NULL, 'amd64', '{"GIT_AUTHOR_NAME": "default", "GIT_AUTHOR_EMAIL": "", "GIT_COMMITTER_NAME": "default", "GIT_COMMITTER_EMAIL": ""}', 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('8f3204e0-a94d-4bc4-b229-747a867468cd', '2022-11-02 13:51:41.721823+02', '2022-11-02 14:04:03.332894+02', 'dev', '2022-11-02 13:51:46.350451+02', '2022-11-02 14:04:03.332893+02', NULL, '1840656b-e464-4625-9323-c359d0b96e22', 'f0f12418-e19b-45e5-85a7-53e93ffb0173', NULL, 'amd64', NULL, 'linux', 'code-server --auth none', NULL, NULL, '', 'v0.8.15+9e9a9e0') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('6de68556-d23e-4b28-8004-08cec52a07e4', '2022-11-02 13:36:31.70245+02', '2022-11-02 13:36:31.70245+02', 'dev', NULL, NULL, NULL, '6c6db170-40cc-44d0-8cc1-3d7fbd38c9e9', '94add058-4a8b-40dd-86b3-cf09d04d5b1b', NULL, 'amd64', NULL, 'linux', NULL, NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('a349bc99-3a9f-490f-b096-5c4c26c1e079', '2022-11-02 13:38:55.832751+02', '2022-11-02 13:40:29.82673+02', 'dev', '2022-11-02 13:38:59.822992+02', '2022-11-02 13:40:29.826729+02', NULL, 'de164a7d-aee7-4096-a3fe-436487011ce9', '584d594a-f5a8-4f7f-a5dc-f740376d8541', NULL, 'amd64', NULL, 'linux', NULL, NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('a000d66f-e24e-4d40-9d2c-ec3809da3a55', '2022-11-02 13:06:08.662927+02', '2022-11-02 13:06:08.662927+02', 'main', '2022-11-02 13:06:08.700926+02', '2022-11-02 13:10:41.705193+02', NULL, '4888064d-263c-4022-abdb-8816ac433c36', '90cc130e-9f39-410a-a574-741e397877c1', NULL, 'amd64', '{"GIT_AUTHOR_NAME": "oauthuser1", "GIT_AUTHOR_EMAIL": "", "GIT_COMMITTER_NAME": "oauthuser1", "GIT_COMMITTER_EMAIL": ""}', 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('00e77e4e-b79c-4077-aef2-f6dbaf1c1b57', '2022-11-02 13:37:07.218002+02', '2022-11-02 13:37:07.218002+02', 'dev', NULL, NULL, NULL, '75ccccf5-a4d4-4db3-8fb1-5227918ec820', 'ea1bc499-5e77-4c54-a27e-46ba8b644f32', NULL, 'amd64', NULL, 'linux', NULL, NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('7bb646eb-7baa-4300-a580-addb3fe89529', '2022-11-02 13:08:10.804142+02', '2022-11-02 13:08:10.804142+02', 'main', '2022-11-02 13:08:10.813078+02', '2022-11-02 13:09:52.819083+02', NULL, '35a7cc19-0816-40bd-930b-1afe28dfc656', 'e82e7cf1-9cfc-4c47-b591-22439f6c00cc', NULL, 'amd64', '{"GIT_AUTHOR_NAME": "oauthuser1", "GIT_AUTHOR_EMAIL": "", "GIT_COMMITTER_NAME": "oauthuser1", "GIT_COMMITTER_EMAIL": ""}', 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('3477a0b6-74af-4630-ab51-5e1ff1cf2bee', '2022-11-02 13:52:05.387522+02', '2022-11-02 14:02:39.423525+02', 'dev', '2022-11-02 13:52:09.419547+02', '2022-11-02 14:02:39.423524+02', NULL, 'b22992bf-9280-4144-ad3a-c904e75b951a', '9c475332-d35c-472d-9bcc-6e737489c42b', NULL, 'amd64', NULL, 'linux', 'code-server --auth none', NULL, NULL, '', 'v0.8.15+9e9a9e0') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('f8c273e3-9dfc-4931-a47d-fba902da6bc6', '2022-11-02 13:57:25.916069+02', '2022-11-02 13:57:25.91607+02', 'main', NULL, NULL, NULL, 'e3a27917-3acd-4c2d-b222-ce47df030b58', '3bf25a26-4f04-4c23-867c-89cd663744d8', NULL, 'amd64', NULL, 'linux', '    #!/bin/bash

    # install and start code-server
    curl -fsSL https://code-server.dev/install.sh | sh  | tee code-server-install.log
    code-server --auth none --port 13337 | tee code-server-install.log &
', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('cae99ef5-1f9b-472e-9ce2-f9ed9d701698', '2022-11-02 13:52:01.928422+02', '2022-11-02 13:52:01.928423+02', 'dev', NULL, NULL, NULL, '867b5f9f-80ed-4409-8647-2388dfa04ac3', '3296e560-a238-4a51-b8c4-9490c953bccb', NULL, 'amd64', NULL, 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('c3decf02-210e-45ab-a122-9be56db534e0', '2022-11-02 13:51:46.985897+02', '2022-11-02 14:04:03.341145+02', 'dev', '2022-11-02 13:51:51.213381+02', '2022-11-02 14:04:03.341143+02', NULL, 'b98c7b45-1ebc-4c5d-b337-7c2f705a5613', '584d594a-f5a8-4f7f-a5dc-f740376d8541', NULL, 'amd64', NULL, 'linux', NULL, NULL, NULL, '', 'v0.8.15+9e9a9e0') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('7a1ce5f8-8d00-431c-ad1b-97a846512804', '2022-11-02 13:05:43.879791+02', '2022-11-02 13:05:43.879791+02', 'main', '2022-11-02 13:05:43.891545+02', '2022-11-02 13:08:07.898132+02', NULL, '93609df1-39ab-46e8-8fba-4d207cdbe461', 'c427d112-23d8-4634-994e-d65a79e718fc', NULL, 'amd64', '{"GIT_AUTHOR_NAME": "oauthuser1", "GIT_AUTHOR_EMAIL": "", "GIT_COMMITTER_NAME": "oauthuser1", "GIT_COMMITTER_EMAIL": ""}', 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_agents VALUES ('5f8e48e4-1304-45bd-b91a-ab12c8bfc20f', '2022-11-02 13:04:58.765211+02', '2022-11-02 14:04:03.366118+02', 'main', '2022-11-02 13:04:58.931953+02', '2022-11-02 14:04:03.366117+02', NULL, '578765bb-bf7c-49b6-9d3e-5d089d68180d', 'ea71c16a-cf93-4c45-a1fd-100fc034528f', NULL, 'amd64', '{"GIT_AUTHOR_NAME": "admin", "GIT_AUTHOR_EMAIL": "", "GIT_COMMITTER_NAME": "admin", "GIT_COMMITTER_EMAIL": ""}', 'linux', 'code-server --auth none', NULL, NULL, '', '') ON CONFLICT DO NOTHING;


--
-- Data for Name: workspace_apps; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.workspace_apps VALUES ('36b65d0c-042b-4653-863a-655ee739861c', '2022-11-02 13:03:45.048584+02', '45e89705-e09d-4850-bcec-f9a937f5d78d', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('347909cf-e3a9-4548-a800-73b4d166305a', '2022-11-02 13:04:14.072762+02', 'a90934b3-34da-400a-a583-fa4dcb3b4668', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('a47965a2-0a25-4810-8cc9-d283c86ab34c', '2022-11-02 13:04:22.825963+02', '8fa17bbd-c48c-44c7-91ae-d4acbc755fad', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('6ee01bda-a857-413a-8755-93365a955ece', '2022-11-02 13:04:58.765877+02', '5f8e48e4-1304-45bd-b91a-ab12c8bfc20f', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('ed0b4a8b-9cb3-45f9-ac86-31038d192b66', '2022-11-02 13:05:43.8806+02', '7a1ce5f8-8d00-431c-ad1b-97a846512804', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('9a5bf95c-dc6d-4780-9a62-6cb5ffe8d2a6', '2022-11-02 13:06:08.663494+02', 'a000d66f-e24e-4d40-9d2c-ec3809da3a55', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('7e5670b0-0643-4622-a6f2-3986b39ee260', '2022-11-02 13:07:57.52769+02', 'ef095280-d76a-422d-812f-0991ad06f2de', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('69bbcdf0-c193-4e91-b998-8bfa97425d27', '2022-11-02 13:08:10.804861+02', '7bb646eb-7baa-4300-a580-addb3fe89529', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('43a4177d-381e-4a6f-8184-a04561733fd6', '2022-11-02 13:31:37.651774+02', '49ea7c9b-83b8-4d0e-b440-82a2df63ff91', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('8d0251a1-d269-44b6-833b-aeef25d4c8d9', '2022-11-02 13:32:49.485019+02', 'cd570f72-a5cf-4348-a044-a9cb8a6406f2', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('b32b68bd-366b-4b43-a1dd-3a9907e4492a', '2022-11-02 13:39:25.706962+02', 'f1395dc0-8905-4287-9bb9-14878c0bd500', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('911e5026-533b-4f06-b8f7-bb794185a56d', '2022-11-02 13:39:29.586917+02', '42a22c7c-4878-4e9e-8dda-acda95b5243f', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('3c3c357c-eb8e-4079-8fcd-b4e1110e9255', '2022-11-02 13:51:41.722464+02', '8f3204e0-a94d-4bc4-b229-747a867468cd', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('7b0e404b-913f-4c43-ae80-ae0974e2c978', '2022-11-02 13:52:01.929657+02', 'cae99ef5-1f9b-472e-9ce2-f9ed9d701698', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('195bc3ef-3702-4578-bc08-c7ee958cf1d3', '2022-11-02 13:52:05.388251+02', '3477a0b6-74af-4630-ab51-5e1ff1cf2bee', 'code-server', '/icon/code.svg', NULL, 'http://localhost:8080/?folder=/home/coder', false) ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_apps VALUES ('a467b9fb-4d9b-4ed3-b8f0-0eba957b95f5', '2022-11-02 13:57:25.917134+02', 'f8c273e3-9dfc-4931-a47d-fba902da6bc6', 'code-server', '/icon/code.svg', NULL, 'http://localhost:13337/?folder=/home/coder', false) ON CONFLICT DO NOTHING;


--
-- Data for Name: workspaces; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.workspaces VALUES ('3a9a1feb-e89d-457c-9d53-ac751b198ebe', '2022-11-02 13:04:19.044082+02', '2022-11-02 13:04:19.044082+02', '30095c71-380b-457a-8995-97b8ee6e5307', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '4cc1f466-f326-477e-8762-9d0c6781fc56', false, 'my-workspace', 'CRON_TZ=UTC 0 9 * * MON-FRI', 28800000000000, '0001-01-01 00:00:00') ON CONFLICT DO NOTHING;
INSERT INTO public.workspaces VALUES ('2d72d32e-3021-4843-b582-d962fee897e2', '2022-11-02 13:06:03.554876+02', '2022-11-02 13:06:03.554876+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '4cc1f466-f326-477e-8762-9d0c6781fc56', false, 'scheduled', 'CRON_TZ=Europe/Helsinki 30 09 * * *', 288000000000000, '0001-01-01 00:00:00') ON CONFLICT DO NOTHING;
INSERT INTO public.workspaces VALUES ('2a84cef8-f569-4d3c-87a7-12a68a077fb7', '2022-11-02 13:39:26.619423+02', '2022-11-02 13:39:26.619423+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '4cc1f466-f326-477e-8762-9d0c6781fc56', true, 'deleted', NULL, 28800000000000, '0001-01-01 00:00:00') ON CONFLICT DO NOTHING;
INSERT INTO public.workspaces VALUES ('b90547be-8870-4d68-8184-e8b2242b7c01', '2022-11-02 13:05:40.181124+02', '2022-11-02 13:05:40.181124+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '4cc1f466-f326-477e-8762-9d0c6781fc56', false, 'test1', NULL, 604800000000000, '2022-11-02 12:01:48.150621') ON CONFLICT DO NOTHING;
INSERT INTO public.workspaces VALUES ('759f94c0-2e14-4a48-8d9e-6507a38e156a', '2022-11-02 13:37:08.219391+02', '2022-11-02 13:37:08.219391+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '34dcb3ce-ad41-4f52-8cba-3b0197ac7c24', false, 'test2', NULL, 28800000000000, '2022-11-02 12:01:53.01033') ON CONFLICT DO NOTHING;
INSERT INTO public.workspaces VALUES ('9cf0c44c-f931-43fc-bf4e-6d3624eb3037', '2022-11-02 13:52:01.952341+02', '2022-11-02 13:52:01.952341+02', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', 'bb640d07-ca8a-4869-b6bc-ae61ebb2fda1', '4cc1f466-f326-477e-8762-9d0c6781fc56', false, 'test3', NULL, 28800000000000, '2022-11-02 12:02:11.221734') ON CONFLICT DO NOTHING;


--
-- Data for Name: workspace_builds; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.workspace_builds VALUES ('a8c0b8c5-c9a8-4f33-93a4-8142e6858244', '2022-11-02 13:04:19.044082+02', '2022-11-02 13:04:22.82111+02', '3a9a1feb-e89d-457c-9d53-ac751b198ebe', '920baba5-4c64-4686-8b7d-d1bef5683eae', 1, 'start', '30095c71-380b-457a-8995-97b8ee6e5307', '\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', '52a90399-a53d-4644-be3c-47ee18a5716e', '2022-11-02 21:04:22.82111+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('ea36844d-8eb6-41a2-a237-e9a8ae3f99ea', '2022-11-02 13:04:48.073344+02', '2022-11-02 13:04:51.504141+02', '3a9a1feb-e89d-457c-9d53-ac751b198ebe', '920baba5-4c64-4686-8b7d-d1bef5683eae', 2, 'stop', '30095c71-380b-457a-8995-97b8ee6e5307', '\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', '104c5815-7bd2-4d09-b76c-00c61b95f0a6', '2022-11-02 21:04:51.504141+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('c1d2c9d5-6f30-4cd0-9ac5-6bf1c6039988', '2022-11-02 13:04:55.224578+02', '2022-11-02 13:04:58.762449+02', '3a9a1feb-e89d-457c-9d53-ac751b198ebe', '920baba5-4c64-4686-8b7d-d1bef5683eae', 3, 'start', '30095c71-380b-457a-8995-97b8ee6e5307', '\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', 'd6ec4737-feaa-446e-aa14-8b2b98b59bf9', '2022-11-02 21:04:58.762449+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('c7c0a371-db1e-4f10-ab34-6779f573554c', '2022-11-02 13:05:40.181124+02', '2022-11-02 13:05:43.876957+02', 'b90547be-8870-4d68-8184-e8b2242b7c01', '920baba5-4c64-4686-8b7d-d1bef5683eae', 1, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '4de9c41c-eb10-435a-8742-e8725e926a9d', '2022-11-09 13:05:43.876957+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('a7477610-c69b-46d6-97fb-d6a3425e1ab4', '2022-11-02 13:06:03.554876+02', '2022-11-02 13:06:08.659241+02', '2d72d32e-3021-4843-b582-d962fee897e2', '920baba5-4c64-4686-8b7d-d1bef5683eae', 1, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '424a58cb-61d6-4627-9907-613c396c4a38', '2022-11-05 21:06:08.659241+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('cd6fe03b-d6cf-4d5d-a448-cef52c3ddea2', '2022-11-02 13:08:07.136084+02', '2022-11-02 13:08:10.801094+02', 'b90547be-8870-4d68-8184-e8b2242b7c01', '4e681a60-83da-42c2-902e-6535376ebb77', 2, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '452e84e3-6847-4fcc-b8b2-ee43cd1f37fc', '2022-11-09 13:08:10.801094+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('b56215f2-3b5e-406a-ac54-41c284dc9af3', '2022-11-02 13:09:51.764313+02', '2022-11-02 13:09:54.749685+02', 'b90547be-8870-4d68-8184-e8b2242b7c01', '4e681a60-83da-42c2-902e-6535376ebb77', 3, 'stop', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '52874f66-89cc-4e6b-8066-80ba21ad9e57', '2022-11-09 13:09:54.749685+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('2bfa1945-e81f-44e4-8f41-394200f6cb30', '2022-11-02 13:10:42.104687+02', '2022-11-02 13:10:45.60543+02', '2d72d32e-3021-4843-b582-d962fee897e2', '920baba5-4c64-4686-8b7d-d1bef5683eae', 2, 'stop', '30095c71-380b-457a-8995-97b8ee6e5307', '\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', 'd842dc52-93b9-46ed-842d-d1569b50ddfc', '2022-11-05 21:10:45.60543+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('b59fc5fc-b8ec-41d3-a2ad-f84e6d68c727', '2022-11-02 13:51:37.954431+02', '2022-11-02 13:51:41.719157+02', 'b90547be-8870-4d68-8184-e8b2242b7c01', 'e5cccf07-4953-48be-85ac-ed35328f1787', 6, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '160a355d-dc14-419c-86f7-d3fc4a1aa150', '2022-11-09 13:51:41.719157+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('e028bb1f-0ef0-426d-a5f5-0d3c778da061', '2022-11-02 13:32:45.573701+02', '2022-11-02 13:32:49.481116+02', 'b90547be-8870-4d68-8184-e8b2242b7c01', 'e5cccf07-4953-48be-85ac-ed35328f1787', 4, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '1a792c66-6721-4edf-91f7-cad106fa59be', '2022-11-03 13:33:45.586+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('a6726cfe-778b-4c7b-9667-88bc05483978', '2022-11-02 13:37:08.219391+02', '2022-11-02 13:38:55.828872+02', '759f94c0-2e14-4a48-8d9e-6507a38e156a', '7bd0d105-b085-4a4d-8d04-6778b8f3cb94', 1, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '893a2e7e-4c2c-4fa5-9af1-4a5839bf69f0', '2022-11-02 21:38:55.828872+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('c41de343-458c-4e9e-aa5e-7e73b768d9f8', '2022-11-02 13:39:26.619423+02', '2022-11-02 13:39:29.584667+02', '2a84cef8-f569-4d3c-87a7-12a68a077fb7', 'e5cccf07-4953-48be-85ac-ed35328f1787', 1, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '98095cd7-567d-4925-a447-646669dd8b92', '2022-11-02 21:39:29.584667+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('43854171-c50b-4d6c-80c7-5c38192a4495', '2022-11-02 13:39:45.06694+02', '2022-11-02 13:39:49.924852+02', '2a84cef8-f569-4d3c-87a7-12a68a077fb7', 'e5cccf07-4953-48be-85ac-ed35328f1787', 2, 'delete', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\x7b0a20202276657273696f6e223a20342c0a2020227465727261666f726d5f76657273696f6e223a2022312e312e39222c0a20202273657269616c223a2031312c0a2020226c696e65616765223a202261646366356436312d633362612d613261332d306461662d613232653366353130613831222c0a2020226f757470757473223a207b7d2c0a2020227265736f7572636573223a205b5d0a7d0a', 'bc4fa377-4c06-4140-b494-c7d5b9f2102c', '2022-11-02 21:39:49.924852+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('eb9ab888-6ab7-4ba3-bec7-cdd710db592a', '2022-11-02 13:40:22.773103+02', '2022-11-02 13:40:27.321269+02', 'b90547be-8870-4d68-8184-e8b2242b7c01', 'e5cccf07-4953-48be-85ac-ed35328f1787', 5, 'stop', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '549537f9-6c99-478c-9c7c-faa1382af4be', '2022-11-09 13:40:27.321269+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('5eb675a2-3743-451b-9d8f-e91b532795f8', '2022-11-02 13:40:28.945183+02', '2022-11-02 13:40:32.178853+02', '759f94c0-2e14-4a48-8d9e-6507a38e156a', '7bd0d105-b085-4a4d-8d04-6778b8f3cb94', 2, 'stop', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\x7b0a20202276657273696f6e223a20342c0a2020227465727261666f726d5f76657273696f6e223a2022312e312e39222c0a20202273657269616c223a20372c0a2020226c696e65616765223a202238323861336162302d653738342d396264352d323034632d646163626366653535633034222c0a2020226f757470757473223a207b7d2c0a2020227265736f7572636573223a205b0a202020207b0a202020202020226d6f6465223a202264617461222c0a2020202020202274797065223a2022636f6465725f776f726b7370616365222c0a202020202020226e616d65223a20226d65222c0a2020202020202270726f7669646572223a202270726f76696465725b5c2272656769737472792e7465727261666f726d2e696f2f636f6465722f636f6465725c225d222c0a20202020202022696e7374616e636573223a205b0a20202020202020207b0a2020202020202020202022736368656d615f76657273696f6e223a20302c0a202020202020202020202261747472696275746573223a207b0a202020202020202020202020226163636573735f75726c223a2022687474703a2f2f3139322e3136382e312e3134363a33323332222c0a202020202020202020202020226964223a202237353966393463302d326531342d346134382d386439652d363530376133386531353661222c0a202020202020202020202020226e616d65223a20227465737432222c0a202020202020202020202020226f776e6572223a2022696d746865737570657276697a72222c0a202020202020202020202020226f776e65725f6964223a202230656439626566632d343931312d346363662d613865322d353539626637326461613934222c0a2020202020202020202020202273746172745f636f756e74223a20302c0a202020202020202020202020227472616e736974696f6e223a202273746f70220a202020202020202020207d2c0a202020202020202020202273656e7369746976655f61747472696275746573223a205b5d0a20202020202020207d0a2020202020205d0a202020207d2c0a202020207b0a202020202020226d6f6465223a20226d616e61676564222c0a2020202020202274797065223a2022636f6465725f6167656e74222c0a202020202020226e616d65223a2022646576222c0a2020202020202270726f7669646572223a202270726f76696465725b5c2272656769737472792e7465727261666f726d2e696f2f636f6465722f636f6465725c225d222c0a20202020202022696e7374616e636573223a205b0a20202020202020207b0a2020202020202020202022736368656d615f76657273696f6e223a20302c0a202020202020202020202261747472696275746573223a207b0a2020202020202020202020202261726368223a2022616d643634222c0a2020202020202020202020202261757468223a2022746f6b656e222c0a20202020202020202020202022646972223a206e756c6c2c0a20202020202020202020202022656e76223a206e756c6c2c0a202020202020202020202020226964223a202234313763353538392d616362612d343566622d396366302d633263636235343533303834222c0a20202020202020202020202022696e69745f736372697074223a202223212f7573722f62696e2f656e762073685c6e736574202d65757820706970656661696c5c6e23204e6f7420616c6c20696e7374616e636573206f66205c22747261705c2220737570706f727420455252205349474e414c5f535045432e205365653a2068747470733a2f2f6769746875622e636f6d2f626d697a6572616e792f726f756e6475702f6973737565732f32355c6e7472617020276563686f203d3d3d204167656e7420736372697074206578697465642077697468206e6f6e2d7a65726f20636f64652e20536c656570696e672032346820746f207072657365727665206c6f67732e2e2e205c75303032365c753030323620736c656570203836343030272045584954207c7c20747275655c6e42494e4152595f4449523d24286d6b74656d70202d64202d7420636f6465722e585858585858295c6e42494e4152595f4e414d453d636f6465725c6e42494e4152595f55524c3d687474703a2f2f3139322e3136382e312e3134363a333233322f62696e2f636f6465722d6c696e75782d616d6436345c6e6364205c222442494e4152595f4449525c225c6e696620636f6d6d616e64202d76206375726c205c75303033652f6465762f6e756c6c20325c75303033655c7530303236313b207468656e5c6e5c746375726c202d6673534c202d2d636f6d70726573736564205c22247b42494e4152595f55524c7d5c22202d6f205c22247b42494e4152595f4e414d457d5c225c6e656c696620636f6d6d616e64202d762077676574205c75303033652f6465762f6e756c6c20325c75303033655c7530303236313b207468656e5c6e5c7477676574202d71205c22247b42494e4152595f55524c7d5c22202d4f205c22247b42494e4152595f4e414d457d5c225c6e656c696620636f6d6d616e64202d762062757379626f78205c75303033652f6465762f6e756c6c20325c75303033655c7530303236313b207468656e5c6e5c7462757379626f782077676574202d71205c22247b42494e4152595f55524c7d5c22202d4f205c22247b42494e4152595f4e414d457d5c225c6e656c73655c6e5c746563686f205c226572726f723a206e6f20646f776e6c6f616420746f6f6c20666f756e642c20706c6561736520696e7374616c6c206375726c2c2077676574206f722062757379626f7820776765745c225c6e5c746578697420315c6e66695c6e63686d6f64202b78202442494e4152595f4e414d455c6e6578706f727420434f4445525f4147454e545f415554483d5c22746f6b656e5c225c6e6578706f727420434f4445525f4147454e545f55524c3d5c22687474703a2f2f3139322e3136382e312e3134363a333233322f5c225c6e65786563202e2f2442494e4152595f4e414d45206167656e745c6e222c0a202020202020202020202020226f73223a20226c696e7578222c0a20202020202020202020202022737461727475705f736372697074223a206e756c6c2c0a20202020202020202020202022746f6b656e223a202235383464353934612d663561382d346637662d613564632d663734303337366438353431220a202020202020202020207d2c0a202020202020202020202273656e7369746976655f61747472696275746573223a205b0a2020202020202020202020205b0a20202020202020202020202020207b0a202020202020202020202020202020202274797065223a20226765745f61747472222c0a202020202020202020202020202020202276616c7565223a202261726368220a20202020202020202020202020207d0a2020202020202020202020205d0a202020202020202020205d2c0a202020202020202020202270726976617465223a2022626e567362413d3d220a20202020202020207d0a2020202020205d0a202020207d2c0a202020207b0a202020202020226d6f6465223a20226d616e61676564222c0a2020202020202274797065223a2022646f636b65725f696d616765222c0a202020202020226e616d65223a2022636f6465725f696d616765222c0a2020202020202270726f7669646572223a202270726f76696465725b5c2272656769737472792e7465727261666f726d2e696f2f6b7265757a7765726b65722f646f636b65725c225d222c0a20202020202022696e7374616e636573223a205b0a20202020202020207b0a2020202020202020202022736368656d615f76657273696f6e223a20302c0a202020202020202020202261747472696275746573223a207b0a202020202020202020202020226275696c64223a205b0a20202020202020202020202020207b0a20202020202020202020202020202020226275696c645f617267223a207b7d2c0a2020202020202020202020202020202022646f636b657266696c65223a2022626173652e446f636b657266696c65222c0a2020202020202020202020202020202022666f7263655f72656d6f7665223a2066616c73652c0a20202020202020202020202020202020226c6162656c223a207b7d2c0a20202020202020202020202020202020226e6f5f6361636865223a2066616c73652c0a202020202020202020202020202020202270617468223a20222e2f696d616765732f222c0a202020202020202020202020202020202272656d6f7665223a20747275652c0a2020202020202020202020202020202022746167223a205b0a20202020202020202020202020202020202022636f6465722d626173653a76302e31220a202020202020202020202020202020205d2c0a2020202020202020202020202020202022746172676574223a2022220a20202020202020202020202020207d0a2020202020202020202020205d2c0a20202020202020202020202022666f7263655f72656d6f7665223a206e756c6c2c0a202020202020202020202020226964223a20227368613235363a62313432373636323830633031633766643763343930343036316563643765653732306335303862383365663562386361303739333236376537373962343436636f6465722d626173652d696d746865737570657276697a722d7465737432222c0a202020202020202020202020226b6565705f6c6f63616c6c79223a20747275652c0a202020202020202020202020226c6174657374223a20227368613235363a62313432373636323830633031633766643763343930343036316563643765653732306335303862383365663562386361303739333236376537373962343436222c0a202020202020202020202020226e616d65223a2022636f6465722d626173652d696d746865737570657276697a722d7465737432222c0a202020202020202020202020226f7574707574223a206e756c6c2c0a2020202020202020202020202270756c6c5f74726967676572223a206e756c6c2c0a2020202020202020202020202270756c6c5f7472696767657273223a206e756c6c2c0a202020202020202020202020227265706f5f646967657374223a2022220a202020202020202020207d2c0a202020202020202020202273656e7369746976655f61747472696275746573223a205b5d2c0a202020202020202020202270726976617465223a2022626e567362413d3d222c0a2020202020202020202022646570656e64656e63696573223a205b0a20202020202020202020202022646174612e636f6465725f776f726b73706163652e6d65220a202020202020202020205d0a20202020202020207d0a2020202020205d0a202020207d2c0a202020207b0a202020202020226d6f6465223a20226d616e61676564222c0a2020202020202274797065223a2022646f636b65725f766f6c756d65222c0a202020202020226e616d65223a2022686f6d655f766f6c756d65222c0a2020202020202270726f7669646572223a202270726f76696465725b5c2272656769737472792e7465727261666f726d2e696f2f6b7265757a7765726b65722f646f636b65725c225d222c0a20202020202022696e7374616e636573223a205b0a20202020202020207b0a2020202020202020202022736368656d615f76657273696f6e223a20312c0a202020202020202020202261747472696275746573223a207b0a20202020202020202020202022647269766572223a20226c6f63616c222c0a202020202020202020202020226472697665725f6f707473223a207b7d2c0a202020202020202020202020226964223a2022636f6465722d696d746865737570657276697a722d74657374322d726f6f74222c0a202020202020202020202020226c6162656c73223a205b5d2c0a202020202020202020202020226d6f756e74706f696e74223a20222f7661722f6c69622f646f636b65722f766f6c756d65732f636f6465722d696d746865737570657276697a722d74657374322d726f6f742f5f64617461222c0a202020202020202020202020226e616d65223a2022636f6465722d696d746865737570657276697a722d74657374322d726f6f74220a202020202020202020207d2c0a202020202020202020202273656e7369746976655f61747472696275746573223a205b5d2c0a202020202020202020202270726976617465223a202265794a7a5932686c62574666646d567963326c7662694936496a456966513d3d222c0a2020202020202020202022646570656e64656e63696573223a205b0a20202020202020202020202022646174612e636f6465725f776f726b73706163652e6d65220a202020202020202020205d0a20202020202020207d0a2020202020205d0a202020207d0a20205d0a7d0a', 'dce50249-2e82-4652-8bef-d6be0761c5f2', '2022-11-02 21:40:32.178853+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('231a1fa2-609d-4e02-9887-e211e2f68924', '2022-11-02 13:51:43.534255+02', '2022-11-02 13:51:46.982055+02', '759f94c0-2e14-4a48-8d9e-6507a38e156a', '7bd0d105-b085-4a4d-8d04-6778b8f3cb94', 3, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '1c5c3f78-f23b-4897-916c-9caedd8fb3eb', '2022-11-02 21:51:46.982055+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('5f61d6d1-cad4-4767-8bb6-b509d53a7459', '2022-11-02 13:52:01.952341+02', '2022-11-02 13:52:05.384162+02', '9cf0c44c-f931-43fc-bf4e-6d3624eb3037', 'e5cccf07-4953-48be-85ac-ed35328f1787', 1, 'start', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '1eb184b4-1d0f-4416-952b-47b5eb9fae5e', '2022-11-02 21:52:05.384162+02', 'initiator') ON CONFLICT DO NOTHING;
INSERT INTO public.workspace_builds VALUES ('d746d8df-578d-42e9-a1a4-f6f51dedb164', '2022-11-02 14:02:37.870682+02', '2022-11-02 14:02:41.624527+02', '9cf0c44c-f931-43fc-bf4e-6d3624eb3037', 'e5cccf07-4953-48be-85ac-ed35328f1787', 2, 'stop', '0ed9befc-4911-4ccf-a8e2-559bf72daa94', '\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', '7c033919-59cc-4b4d-9261-38bb6cb848d9', '2022-11-02 22:02:41.624527+02', 'initiator') ON CONFLICT DO NOTHING;


--
-- Data for Name: workspace_resource_metadata; Type: TABLE DATA; Schema: public; Owner: coder
--

INSERT INTO public.workspace_resource_metadata VALUES ('e3a27917-3acd-4c2d-b222-ce47df030b58', 'image', 'base', false) ON CONFLICT DO NOTHING;


--
-- Name: licenses_id_seq; Type: SEQUENCE SET; Schema: public; Owner: coder
--

SELECT pg_catalog.setval('public.licenses_id_seq', 1, false);


--
-- PostgreSQL database dump complete
--

