// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0

package database

import (
	"database/sql"
	"database/sql/driver"
	"encoding/json"
	"fmt"
	"time"

	"github.com/google/uuid"
	"github.com/lib/pq"
	"github.com/sqlc-dev/pqtype"
)

type APIKeyScope string

const (
	ApiKeyScopeCoderAll                            APIKeyScope = "coder:all"
	ApiKeyScopeCoderApplicationConnect             APIKeyScope = "coder:application_connect"
	ApiKeyScopeAibridgeInterceptionCreate          APIKeyScope = "aibridge_interception:create"
	ApiKeyScopeAibridgeInterceptionRead            APIKeyScope = "aibridge_interception:read"
	ApiKeyScopeAibridgeInterceptionUpdate          APIKeyScope = "aibridge_interception:update"
	ApiKeyScopeApiKeyCreate                        APIKeyScope = "api_key:create"
	ApiKeyScopeApiKeyDelete                        APIKeyScope = "api_key:delete"
	ApiKeyScopeApiKeyRead                          APIKeyScope = "api_key:read"
	ApiKeyScopeApiKeyUpdate                        APIKeyScope = "api_key:update"
	ApiKeyScopeAssignOrgRoleAssign                 APIKeyScope = "assign_org_role:assign"
	ApiKeyScopeAssignOrgRoleCreate                 APIKeyScope = "assign_org_role:create"
	ApiKeyScopeAssignOrgRoleDelete                 APIKeyScope = "assign_org_role:delete"
	ApiKeyScopeAssignOrgRoleRead                   APIKeyScope = "assign_org_role:read"
	ApiKeyScopeAssignOrgRoleUnassign               APIKeyScope = "assign_org_role:unassign"
	ApiKeyScopeAssignOrgRoleUpdate                 APIKeyScope = "assign_org_role:update"
	ApiKeyScopeAssignRoleAssign                    APIKeyScope = "assign_role:assign"
	ApiKeyScopeAssignRoleRead                      APIKeyScope = "assign_role:read"
	ApiKeyScopeAssignRoleUnassign                  APIKeyScope = "assign_role:unassign"
	ApiKeyScopeAuditLogCreate                      APIKeyScope = "audit_log:create"
	ApiKeyScopeAuditLogRead                        APIKeyScope = "audit_log:read"
	ApiKeyScopeConnectionLogRead                   APIKeyScope = "connection_log:read"
	ApiKeyScopeConnectionLogUpdate                 APIKeyScope = "connection_log:update"
	ApiKeyScopeCryptoKeyCreate                     APIKeyScope = "crypto_key:create"
	ApiKeyScopeCryptoKeyDelete                     APIKeyScope = "crypto_key:delete"
	ApiKeyScopeCryptoKeyRead                       APIKeyScope = "crypto_key:read"
	ApiKeyScopeCryptoKeyUpdate                     APIKeyScope = "crypto_key:update"
	ApiKeyScopeDebugInfoRead                       APIKeyScope = "debug_info:read"
	ApiKeyScopeDeploymentConfigRead                APIKeyScope = "deployment_config:read"
	ApiKeyScopeDeploymentConfigUpdate              APIKeyScope = "deployment_config:update"
	ApiKeyScopeDeploymentStatsRead                 APIKeyScope = "deployment_stats:read"
	ApiKeyScopeFileCreate                          APIKeyScope = "file:create"
	ApiKeyScopeFileRead                            APIKeyScope = "file:read"
	ApiKeyScopeGroupCreate                         APIKeyScope = "group:create"
	ApiKeyScopeGroupDelete                         APIKeyScope = "group:delete"
	ApiKeyScopeGroupRead                           APIKeyScope = "group:read"
	ApiKeyScopeGroupUpdate                         APIKeyScope = "group:update"
	ApiKeyScopeGroupMemberRead                     APIKeyScope = "group_member:read"
	ApiKeyScopeIdpsyncSettingsRead                 APIKeyScope = "idpsync_settings:read"
	ApiKeyScopeIdpsyncSettingsUpdate               APIKeyScope = "idpsync_settings:update"
	ApiKeyScopeInboxNotificationCreate             APIKeyScope = "inbox_notification:create"
	ApiKeyScopeInboxNotificationRead               APIKeyScope = "inbox_notification:read"
	ApiKeyScopeInboxNotificationUpdate             APIKeyScope = "inbox_notification:update"
	ApiKeyScopeLicenseCreate                       APIKeyScope = "license:create"
	ApiKeyScopeLicenseDelete                       APIKeyScope = "license:delete"
	ApiKeyScopeLicenseRead                         APIKeyScope = "license:read"
	ApiKeyScopeNotificationMessageCreate           APIKeyScope = "notification_message:create"
	ApiKeyScopeNotificationMessageDelete           APIKeyScope = "notification_message:delete"
	ApiKeyScopeNotificationMessageRead             APIKeyScope = "notification_message:read"
	ApiKeyScopeNotificationMessageUpdate           APIKeyScope = "notification_message:update"
	ApiKeyScopeNotificationPreferenceRead          APIKeyScope = "notification_preference:read"
	ApiKeyScopeNotificationPreferenceUpdate        APIKeyScope = "notification_preference:update"
	ApiKeyScopeNotificationTemplateRead            APIKeyScope = "notification_template:read"
	ApiKeyScopeNotificationTemplateUpdate          APIKeyScope = "notification_template:update"
	ApiKeyScopeOauth2AppCreate                     APIKeyScope = "oauth2_app:create"
	ApiKeyScopeOauth2AppDelete                     APIKeyScope = "oauth2_app:delete"
	ApiKeyScopeOauth2AppRead                       APIKeyScope = "oauth2_app:read"
	ApiKeyScopeOauth2AppUpdate                     APIKeyScope = "oauth2_app:update"
	ApiKeyScopeOauth2AppCodeTokenCreate            APIKeyScope = "oauth2_app_code_token:create"
	ApiKeyScopeOauth2AppCodeTokenDelete            APIKeyScope = "oauth2_app_code_token:delete"
	ApiKeyScopeOauth2AppCodeTokenRead              APIKeyScope = "oauth2_app_code_token:read"
	ApiKeyScopeOauth2AppSecretCreate               APIKeyScope = "oauth2_app_secret:create"
	ApiKeyScopeOauth2AppSecretDelete               APIKeyScope = "oauth2_app_secret:delete"
	ApiKeyScopeOauth2AppSecretRead                 APIKeyScope = "oauth2_app_secret:read"
	ApiKeyScopeOauth2AppSecretUpdate               APIKeyScope = "oauth2_app_secret:update"
	ApiKeyScopeOrganizationCreate                  APIKeyScope = "organization:create"
	ApiKeyScopeOrganizationDelete                  APIKeyScope = "organization:delete"
	ApiKeyScopeOrganizationRead                    APIKeyScope = "organization:read"
	ApiKeyScopeOrganizationUpdate                  APIKeyScope = "organization:update"
	ApiKeyScopeOrganizationMemberCreate            APIKeyScope = "organization_member:create"
	ApiKeyScopeOrganizationMemberDelete            APIKeyScope = "organization_member:delete"
	ApiKeyScopeOrganizationMemberRead              APIKeyScope = "organization_member:read"
	ApiKeyScopeOrganizationMemberUpdate            APIKeyScope = "organization_member:update"
	ApiKeyScopePrebuiltWorkspaceDelete             APIKeyScope = "prebuilt_workspace:delete"
	ApiKeyScopePrebuiltWorkspaceUpdate             APIKeyScope = "prebuilt_workspace:update"
	ApiKeyScopeProvisionerDaemonCreate             APIKeyScope = "provisioner_daemon:create"
	ApiKeyScopeProvisionerDaemonDelete             APIKeyScope = "provisioner_daemon:delete"
	ApiKeyScopeProvisionerDaemonRead               APIKeyScope = "provisioner_daemon:read"
	ApiKeyScopeProvisionerDaemonUpdate             APIKeyScope = "provisioner_daemon:update"
	ApiKeyScopeProvisionerJobsCreate               APIKeyScope = "provisioner_jobs:create"
	ApiKeyScopeProvisionerJobsRead                 APIKeyScope = "provisioner_jobs:read"
	ApiKeyScopeProvisionerJobsUpdate               APIKeyScope = "provisioner_jobs:update"
	ApiKeyScopeReplicasRead                        APIKeyScope = "replicas:read"
	ApiKeyScopeSystemCreate                        APIKeyScope = "system:create"
	ApiKeyScopeSystemDelete                        APIKeyScope = "system:delete"
	ApiKeyScopeSystemRead                          APIKeyScope = "system:read"
	ApiKeyScopeSystemUpdate                        APIKeyScope = "system:update"
	ApiKeyScopeTailnetCoordinatorCreate            APIKeyScope = "tailnet_coordinator:create"
	ApiKeyScopeTailnetCoordinatorDelete            APIKeyScope = "tailnet_coordinator:delete"
	ApiKeyScopeTailnetCoordinatorRead              APIKeyScope = "tailnet_coordinator:read"
	ApiKeyScopeTailnetCoordinatorUpdate            APIKeyScope = "tailnet_coordinator:update"
	ApiKeyScopeTemplateCreate                      APIKeyScope = "template:create"
	ApiKeyScopeTemplateDelete                      APIKeyScope = "template:delete"
	ApiKeyScopeTemplateRead                        APIKeyScope = "template:read"
	ApiKeyScopeTemplateUpdate                      APIKeyScope = "template:update"
	ApiKeyScopeTemplateUse                         APIKeyScope = "template:use"
	ApiKeyScopeTemplateViewInsights                APIKeyScope = "template:view_insights"
	ApiKeyScopeUsageEventCreate                    APIKeyScope = "usage_event:create"
	ApiKeyScopeUsageEventRead                      APIKeyScope = "usage_event:read"
	ApiKeyScopeUsageEventUpdate                    APIKeyScope = "usage_event:update"
	ApiKeyScopeUserCreate                          APIKeyScope = "user:create"
	ApiKeyScopeUserDelete                          APIKeyScope = "user:delete"
	ApiKeyScopeUserRead                            APIKeyScope = "user:read"
	ApiKeyScopeUserReadPersonal                    APIKeyScope = "user:read_personal"
	ApiKeyScopeUserUpdate                          APIKeyScope = "user:update"
	ApiKeyScopeUserUpdatePersonal                  APIKeyScope = "user:update_personal"
	ApiKeyScopeUserSecretCreate                    APIKeyScope = "user_secret:create"
	ApiKeyScopeUserSecretDelete                    APIKeyScope = "user_secret:delete"
	ApiKeyScopeUserSecretRead                      APIKeyScope = "user_secret:read"
	ApiKeyScopeUserSecretUpdate                    APIKeyScope = "user_secret:update"
	ApiKeyScopeWebpushSubscriptionCreate           APIKeyScope = "webpush_subscription:create"
	ApiKeyScopeWebpushSubscriptionDelete           APIKeyScope = "webpush_subscription:delete"
	ApiKeyScopeWebpushSubscriptionRead             APIKeyScope = "webpush_subscription:read"
	ApiKeyScopeWorkspaceApplicationConnect         APIKeyScope = "workspace:application_connect"
	ApiKeyScopeWorkspaceCreate                     APIKeyScope = "workspace:create"
	ApiKeyScopeWorkspaceCreateAgent                APIKeyScope = "workspace:create_agent"
	ApiKeyScopeWorkspaceDelete                     APIKeyScope = "workspace:delete"
	ApiKeyScopeWorkspaceDeleteAgent                APIKeyScope = "workspace:delete_agent"
	ApiKeyScopeWorkspaceRead                       APIKeyScope = "workspace:read"
	ApiKeyScopeWorkspaceSsh                        APIKeyScope = "workspace:ssh"
	ApiKeyScopeWorkspaceStart                      APIKeyScope = "workspace:start"
	ApiKeyScopeWorkspaceStop                       APIKeyScope = "workspace:stop"
	ApiKeyScopeWorkspaceUpdate                     APIKeyScope = "workspace:update"
	ApiKeyScopeWorkspaceAgentDevcontainersCreate   APIKeyScope = "workspace_agent_devcontainers:create"
	ApiKeyScopeWorkspaceAgentResourceMonitorCreate APIKeyScope = "workspace_agent_resource_monitor:create"
	ApiKeyScopeWorkspaceAgentResourceMonitorRead   APIKeyScope = "workspace_agent_resource_monitor:read"
	ApiKeyScopeWorkspaceAgentResourceMonitorUpdate APIKeyScope = "workspace_agent_resource_monitor:update"
	ApiKeyScopeWorkspaceDormantApplicationConnect  APIKeyScope = "workspace_dormant:application_connect"
	ApiKeyScopeWorkspaceDormantCreate              APIKeyScope = "workspace_dormant:create"
	ApiKeyScopeWorkspaceDormantCreateAgent         APIKeyScope = "workspace_dormant:create_agent"
	ApiKeyScopeWorkspaceDormantDelete              APIKeyScope = "workspace_dormant:delete"
	ApiKeyScopeWorkspaceDormantDeleteAgent         APIKeyScope = "workspace_dormant:delete_agent"
	ApiKeyScopeWorkspaceDormantRead                APIKeyScope = "workspace_dormant:read"
	ApiKeyScopeWorkspaceDormantSsh                 APIKeyScope = "workspace_dormant:ssh"
	ApiKeyScopeWorkspaceDormantStart               APIKeyScope = "workspace_dormant:start"
	ApiKeyScopeWorkspaceDormantStop                APIKeyScope = "workspace_dormant:stop"
	ApiKeyScopeWorkspaceDormantUpdate              APIKeyScope = "workspace_dormant:update"
	ApiKeyScopeWorkspaceProxyCreate                APIKeyScope = "workspace_proxy:create"
	ApiKeyScopeWorkspaceProxyDelete                APIKeyScope = "workspace_proxy:delete"
	ApiKeyScopeWorkspaceProxyRead                  APIKeyScope = "workspace_proxy:read"
	ApiKeyScopeWorkspaceProxyUpdate                APIKeyScope = "workspace_proxy:update"
	ApiKeyScopeCoderWorkspacescreate               APIKeyScope = "coder:workspaces.create"
	ApiKeyScopeCoderWorkspacesoperate              APIKeyScope = "coder:workspaces.operate"
	ApiKeyScopeCoderWorkspacesdelete               APIKeyScope = "coder:workspaces.delete"
	ApiKeyScopeCoderWorkspacesaccess               APIKeyScope = "coder:workspaces.access"
	ApiKeyScopeCoderTemplatesbuild                 APIKeyScope = "coder:templates.build"
	ApiKeyScopeCoderTemplatesauthor                APIKeyScope = "coder:templates.author"
	ApiKeyScopeCoderApikeysmanageSelf              APIKeyScope = "coder:apikeys.manage_self"
	ApiKeyScopeAibridgeInterception                APIKeyScope = "aibridge_interception:*"
	ApiKeyScopeApiKey                              APIKeyScope = "api_key:*"
	ApiKeyScopeAssignOrgRole                       APIKeyScope = "assign_org_role:*"
	ApiKeyScopeAssignRole                          APIKeyScope = "assign_role:*"
	ApiKeyScopeAuditLog                            APIKeyScope = "audit_log:*"
	ApiKeyScopeConnectionLog                       APIKeyScope = "connection_log:*"
	ApiKeyScopeCryptoKey                           APIKeyScope = "crypto_key:*"
	ApiKeyScopeDebugInfo                           APIKeyScope = "debug_info:*"
	ApiKeyScopeDeploymentConfig                    APIKeyScope = "deployment_config:*"
	ApiKeyScopeDeploymentStats                     APIKeyScope = "deployment_stats:*"
	ApiKeyScopeFile                                APIKeyScope = "file:*"
	ApiKeyScopeGroup                               APIKeyScope = "group:*"
	ApiKeyScopeGroupMember                         APIKeyScope = "group_member:*"
	ApiKeyScopeIdpsyncSettings                     APIKeyScope = "idpsync_settings:*"
	ApiKeyScopeInboxNotification                   APIKeyScope = "inbox_notification:*"
	ApiKeyScopeLicense                             APIKeyScope = "license:*"
	ApiKeyScopeNotificationMessage                 APIKeyScope = "notification_message:*"
	ApiKeyScopeNotificationPreference              APIKeyScope = "notification_preference:*"
	ApiKeyScopeNotificationTemplate                APIKeyScope = "notification_template:*"
	ApiKeyScopeOauth2App                           APIKeyScope = "oauth2_app:*"
	ApiKeyScopeOauth2AppCodeToken                  APIKeyScope = "oauth2_app_code_token:*"
	ApiKeyScopeOauth2AppSecret                     APIKeyScope = "oauth2_app_secret:*"
	ApiKeyScopeOrganization                        APIKeyScope = "organization:*"
	ApiKeyScopeOrganizationMember                  APIKeyScope = "organization_member:*"
	ApiKeyScopePrebuiltWorkspace                   APIKeyScope = "prebuilt_workspace:*"
	ApiKeyScopeProvisionerDaemon                   APIKeyScope = "provisioner_daemon:*"
	ApiKeyScopeProvisionerJobs                     APIKeyScope = "provisioner_jobs:*"
	ApiKeyScopeReplicas                            APIKeyScope = "replicas:*"
	ApiKeyScopeSystem                              APIKeyScope = "system:*"
	ApiKeyScopeTailnetCoordinator                  APIKeyScope = "tailnet_coordinator:*"
	ApiKeyScopeTemplate                            APIKeyScope = "template:*"
	ApiKeyScopeUsageEvent                          APIKeyScope = "usage_event:*"
	ApiKeyScopeUser                                APIKeyScope = "user:*"
	ApiKeyScopeUserSecret                          APIKeyScope = "user_secret:*"
	ApiKeyScopeWebpushSubscription                 APIKeyScope = "webpush_subscription:*"
	ApiKeyScopeWorkspace                           APIKeyScope = "workspace:*"
	ApiKeyScopeWorkspaceAgentDevcontainers         APIKeyScope = "workspace_agent_devcontainers:*"
	ApiKeyScopeWorkspaceAgentResourceMonitor       APIKeyScope = "workspace_agent_resource_monitor:*"
	ApiKeyScopeWorkspaceDormant                    APIKeyScope = "workspace_dormant:*"
	ApiKeyScopeWorkspaceProxy                      APIKeyScope = "workspace_proxy:*"
	ApiKeyScopeTaskCreate                          APIKeyScope = "task:create"
	ApiKeyScopeTaskRead                            APIKeyScope = "task:read"
	ApiKeyScopeTaskUpdate                          APIKeyScope = "task:update"
	ApiKeyScopeTaskDelete                          APIKeyScope = "task:delete"
	ApiKeyScopeTask                                APIKeyScope = "task:*"
	ApiKeyScopeWorkspaceShare                      APIKeyScope = "workspace:share"
	ApiKeyScopeWorkspaceDormantShare               APIKeyScope = "workspace_dormant:share"
	ApiKeyScopeBoundaryUsage                       APIKeyScope = "boundary_usage:*"
	ApiKeyScopeBoundaryUsageDelete                 APIKeyScope = "boundary_usage:delete"
	ApiKeyScopeBoundaryUsageRead                   APIKeyScope = "boundary_usage:read"
	ApiKeyScopeBoundaryUsageUpdate                 APIKeyScope = "boundary_usage:update"
)

func (e *APIKeyScope) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = APIKeyScope(s)
	case string:
		*e = APIKeyScope(s)
	default:
		return fmt.Errorf("unsupported scan type for APIKeyScope: %T", src)
	}
	return nil
}

type NullAPIKeyScope struct {
	APIKeyScope APIKeyScope `json:"api_key_scope"`
	Valid       bool        `json:"valid"` // Valid is true if APIKeyScope is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullAPIKeyScope) Scan(value interface{}) error {
	if value == nil {
		ns.APIKeyScope, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.APIKeyScope.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullAPIKeyScope) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.APIKeyScope), nil
}

func (e APIKeyScope) Valid() bool {
	switch e {
	case ApiKeyScopeCoderAll,
		ApiKeyScopeCoderApplicationConnect,
		ApiKeyScopeAibridgeInterceptionCreate,
		ApiKeyScopeAibridgeInterceptionRead,
		ApiKeyScopeAibridgeInterceptionUpdate,
		ApiKeyScopeApiKeyCreate,
		ApiKeyScopeApiKeyDelete,
		ApiKeyScopeApiKeyRead,
		ApiKeyScopeApiKeyUpdate,
		ApiKeyScopeAssignOrgRoleAssign,
		ApiKeyScopeAssignOrgRoleCreate,
		ApiKeyScopeAssignOrgRoleDelete,
		ApiKeyScopeAssignOrgRoleRead,
		ApiKeyScopeAssignOrgRoleUnassign,
		ApiKeyScopeAssignOrgRoleUpdate,
		ApiKeyScopeAssignRoleAssign,
		ApiKeyScopeAssignRoleRead,
		ApiKeyScopeAssignRoleUnassign,
		ApiKeyScopeAuditLogCreate,
		ApiKeyScopeAuditLogRead,
		ApiKeyScopeConnectionLogRead,
		ApiKeyScopeConnectionLogUpdate,
		ApiKeyScopeCryptoKeyCreate,
		ApiKeyScopeCryptoKeyDelete,
		ApiKeyScopeCryptoKeyRead,
		ApiKeyScopeCryptoKeyUpdate,
		ApiKeyScopeDebugInfoRead,
		ApiKeyScopeDeploymentConfigRead,
		ApiKeyScopeDeploymentConfigUpdate,
		ApiKeyScopeDeploymentStatsRead,
		ApiKeyScopeFileCreate,
		ApiKeyScopeFileRead,
		ApiKeyScopeGroupCreate,
		ApiKeyScopeGroupDelete,
		ApiKeyScopeGroupRead,
		ApiKeyScopeGroupUpdate,
		ApiKeyScopeGroupMemberRead,
		ApiKeyScopeIdpsyncSettingsRead,
		ApiKeyScopeIdpsyncSettingsUpdate,
		ApiKeyScopeInboxNotificationCreate,
		ApiKeyScopeInboxNotificationRead,
		ApiKeyScopeInboxNotificationUpdate,
		ApiKeyScopeLicenseCreate,
		ApiKeyScopeLicenseDelete,
		ApiKeyScopeLicenseRead,
		ApiKeyScopeNotificationMessageCreate,
		ApiKeyScopeNotificationMessageDelete,
		ApiKeyScopeNotificationMessageRead,
		ApiKeyScopeNotificationMessageUpdate,
		ApiKeyScopeNotificationPreferenceRead,
		ApiKeyScopeNotificationPreferenceUpdate,
		ApiKeyScopeNotificationTemplateRead,
		ApiKeyScopeNotificationTemplateUpdate,
		ApiKeyScopeOauth2AppCreate,
		ApiKeyScopeOauth2AppDelete,
		ApiKeyScopeOauth2AppRead,
		ApiKeyScopeOauth2AppUpdate,
		ApiKeyScopeOauth2AppCodeTokenCreate,
		ApiKeyScopeOauth2AppCodeTokenDelete,
		ApiKeyScopeOauth2AppCodeTokenRead,
		ApiKeyScopeOauth2AppSecretCreate,
		ApiKeyScopeOauth2AppSecretDelete,
		ApiKeyScopeOauth2AppSecretRead,
		ApiKeyScopeOauth2AppSecretUpdate,
		ApiKeyScopeOrganizationCreate,
		ApiKeyScopeOrganizationDelete,
		ApiKeyScopeOrganizationRead,
		ApiKeyScopeOrganizationUpdate,
		ApiKeyScopeOrganizationMemberCreate,
		ApiKeyScopeOrganizationMemberDelete,
		ApiKeyScopeOrganizationMemberRead,
		ApiKeyScopeOrganizationMemberUpdate,
		ApiKeyScopePrebuiltWorkspaceDelete,
		ApiKeyScopePrebuiltWorkspaceUpdate,
		ApiKeyScopeProvisionerDaemonCreate,
		ApiKeyScopeProvisionerDaemonDelete,
		ApiKeyScopeProvisionerDaemonRead,
		ApiKeyScopeProvisionerDaemonUpdate,
		ApiKeyScopeProvisionerJobsCreate,
		ApiKeyScopeProvisionerJobsRead,
		ApiKeyScopeProvisionerJobsUpdate,
		ApiKeyScopeReplicasRead,
		ApiKeyScopeSystemCreate,
		ApiKeyScopeSystemDelete,
		ApiKeyScopeSystemRead,
		ApiKeyScopeSystemUpdate,
		ApiKeyScopeTailnetCoordinatorCreate,
		ApiKeyScopeTailnetCoordinatorDelete,
		ApiKeyScopeTailnetCoordinatorRead,
		ApiKeyScopeTailnetCoordinatorUpdate,
		ApiKeyScopeTemplateCreate,
		ApiKeyScopeTemplateDelete,
		ApiKeyScopeTemplateRead,
		ApiKeyScopeTemplateUpdate,
		ApiKeyScopeTemplateUse,
		ApiKeyScopeTemplateViewInsights,
		ApiKeyScopeUsageEventCreate,
		ApiKeyScopeUsageEventRead,
		ApiKeyScopeUsageEventUpdate,
		ApiKeyScopeUserCreate,
		ApiKeyScopeUserDelete,
		ApiKeyScopeUserRead,
		ApiKeyScopeUserReadPersonal,
		ApiKeyScopeUserUpdate,
		ApiKeyScopeUserUpdatePersonal,
		ApiKeyScopeUserSecretCreate,
		ApiKeyScopeUserSecretDelete,
		ApiKeyScopeUserSecretRead,
		ApiKeyScopeUserSecretUpdate,
		ApiKeyScopeWebpushSubscriptionCreate,
		ApiKeyScopeWebpushSubscriptionDelete,
		ApiKeyScopeWebpushSubscriptionRead,
		ApiKeyScopeWorkspaceApplicationConnect,
		ApiKeyScopeWorkspaceCreate,
		ApiKeyScopeWorkspaceCreateAgent,
		ApiKeyScopeWorkspaceDelete,
		ApiKeyScopeWorkspaceDeleteAgent,
		ApiKeyScopeWorkspaceRead,
		ApiKeyScopeWorkspaceSsh,
		ApiKeyScopeWorkspaceStart,
		ApiKeyScopeWorkspaceStop,
		ApiKeyScopeWorkspaceUpdate,
		ApiKeyScopeWorkspaceAgentDevcontainersCreate,
		ApiKeyScopeWorkspaceAgentResourceMonitorCreate,
		ApiKeyScopeWorkspaceAgentResourceMonitorRead,
		ApiKeyScopeWorkspaceAgentResourceMonitorUpdate,
		ApiKeyScopeWorkspaceDormantApplicationConnect,
		ApiKeyScopeWorkspaceDormantCreate,
		ApiKeyScopeWorkspaceDormantCreateAgent,
		ApiKeyScopeWorkspaceDormantDelete,
		ApiKeyScopeWorkspaceDormantDeleteAgent,
		ApiKeyScopeWorkspaceDormantRead,
		ApiKeyScopeWorkspaceDormantSsh,
		ApiKeyScopeWorkspaceDormantStart,
		ApiKeyScopeWorkspaceDormantStop,
		ApiKeyScopeWorkspaceDormantUpdate,
		ApiKeyScopeWorkspaceProxyCreate,
		ApiKeyScopeWorkspaceProxyDelete,
		ApiKeyScopeWorkspaceProxyRead,
		ApiKeyScopeWorkspaceProxyUpdate,
		ApiKeyScopeCoderWorkspacescreate,
		ApiKeyScopeCoderWorkspacesoperate,
		ApiKeyScopeCoderWorkspacesdelete,
		ApiKeyScopeCoderWorkspacesaccess,
		ApiKeyScopeCoderTemplatesbuild,
		ApiKeyScopeCoderTemplatesauthor,
		ApiKeyScopeCoderApikeysmanageSelf,
		ApiKeyScopeAibridgeInterception,
		ApiKeyScopeApiKey,
		ApiKeyScopeAssignOrgRole,
		ApiKeyScopeAssignRole,
		ApiKeyScopeAuditLog,
		ApiKeyScopeConnectionLog,
		ApiKeyScopeCryptoKey,
		ApiKeyScopeDebugInfo,
		ApiKeyScopeDeploymentConfig,
		ApiKeyScopeDeploymentStats,
		ApiKeyScopeFile,
		ApiKeyScopeGroup,
		ApiKeyScopeGroupMember,
		ApiKeyScopeIdpsyncSettings,
		ApiKeyScopeInboxNotification,
		ApiKeyScopeLicense,
		ApiKeyScopeNotificationMessage,
		ApiKeyScopeNotificationPreference,
		ApiKeyScopeNotificationTemplate,
		ApiKeyScopeOauth2App,
		ApiKeyScopeOauth2AppCodeToken,
		ApiKeyScopeOauth2AppSecret,
		ApiKeyScopeOrganization,
		ApiKeyScopeOrganizationMember,
		ApiKeyScopePrebuiltWorkspace,
		ApiKeyScopeProvisionerDaemon,
		ApiKeyScopeProvisionerJobs,
		ApiKeyScopeReplicas,
		ApiKeyScopeSystem,
		ApiKeyScopeTailnetCoordinator,
		ApiKeyScopeTemplate,
		ApiKeyScopeUsageEvent,
		ApiKeyScopeUser,
		ApiKeyScopeUserSecret,
		ApiKeyScopeWebpushSubscription,
		ApiKeyScopeWorkspace,
		ApiKeyScopeWorkspaceAgentDevcontainers,
		ApiKeyScopeWorkspaceAgentResourceMonitor,
		ApiKeyScopeWorkspaceDormant,
		ApiKeyScopeWorkspaceProxy,
		ApiKeyScopeTaskCreate,
		ApiKeyScopeTaskRead,
		ApiKeyScopeTaskUpdate,
		ApiKeyScopeTaskDelete,
		ApiKeyScopeTask,
		ApiKeyScopeWorkspaceShare,
		ApiKeyScopeWorkspaceDormantShare,
		ApiKeyScopeBoundaryUsage,
		ApiKeyScopeBoundaryUsageDelete,
		ApiKeyScopeBoundaryUsageRead,
		ApiKeyScopeBoundaryUsageUpdate:
		return true
	}
	return false
}

func AllAPIKeyScopeValues() []APIKeyScope {
	return []APIKeyScope{
		ApiKeyScopeCoderAll,
		ApiKeyScopeCoderApplicationConnect,
		ApiKeyScopeAibridgeInterceptionCreate,
		ApiKeyScopeAibridgeInterceptionRead,
		ApiKeyScopeAibridgeInterceptionUpdate,
		ApiKeyScopeApiKeyCreate,
		ApiKeyScopeApiKeyDelete,
		ApiKeyScopeApiKeyRead,
		ApiKeyScopeApiKeyUpdate,
		ApiKeyScopeAssignOrgRoleAssign,
		ApiKeyScopeAssignOrgRoleCreate,
		ApiKeyScopeAssignOrgRoleDelete,
		ApiKeyScopeAssignOrgRoleRead,
		ApiKeyScopeAssignOrgRoleUnassign,
		ApiKeyScopeAssignOrgRoleUpdate,
		ApiKeyScopeAssignRoleAssign,
		ApiKeyScopeAssignRoleRead,
		ApiKeyScopeAssignRoleUnassign,
		ApiKeyScopeAuditLogCreate,
		ApiKeyScopeAuditLogRead,
		ApiKeyScopeConnectionLogRead,
		ApiKeyScopeConnectionLogUpdate,
		ApiKeyScopeCryptoKeyCreate,
		ApiKeyScopeCryptoKeyDelete,
		ApiKeyScopeCryptoKeyRead,
		ApiKeyScopeCryptoKeyUpdate,
		ApiKeyScopeDebugInfoRead,
		ApiKeyScopeDeploymentConfigRead,
		ApiKeyScopeDeploymentConfigUpdate,
		ApiKeyScopeDeploymentStatsRead,
		ApiKeyScopeFileCreate,
		ApiKeyScopeFileRead,
		ApiKeyScopeGroupCreate,
		ApiKeyScopeGroupDelete,
		ApiKeyScopeGroupRead,
		ApiKeyScopeGroupUpdate,
		ApiKeyScopeGroupMemberRead,
		ApiKeyScopeIdpsyncSettingsRead,
		ApiKeyScopeIdpsyncSettingsUpdate,
		ApiKeyScopeInboxNotificationCreate,
		ApiKeyScopeInboxNotificationRead,
		ApiKeyScopeInboxNotificationUpdate,
		ApiKeyScopeLicenseCreate,
		ApiKeyScopeLicenseDelete,
		ApiKeyScopeLicenseRead,
		ApiKeyScopeNotificationMessageCreate,
		ApiKeyScopeNotificationMessageDelete,
		ApiKeyScopeNotificationMessageRead,
		ApiKeyScopeNotificationMessageUpdate,
		ApiKeyScopeNotificationPreferenceRead,
		ApiKeyScopeNotificationPreferenceUpdate,
		ApiKeyScopeNotificationTemplateRead,
		ApiKeyScopeNotificationTemplateUpdate,
		ApiKeyScopeOauth2AppCreate,
		ApiKeyScopeOauth2AppDelete,
		ApiKeyScopeOauth2AppRead,
		ApiKeyScopeOauth2AppUpdate,
		ApiKeyScopeOauth2AppCodeTokenCreate,
		ApiKeyScopeOauth2AppCodeTokenDelete,
		ApiKeyScopeOauth2AppCodeTokenRead,
		ApiKeyScopeOauth2AppSecretCreate,
		ApiKeyScopeOauth2AppSecretDelete,
		ApiKeyScopeOauth2AppSecretRead,
		ApiKeyScopeOauth2AppSecretUpdate,
		ApiKeyScopeOrganizationCreate,
		ApiKeyScopeOrganizationDelete,
		ApiKeyScopeOrganizationRead,
		ApiKeyScopeOrganizationUpdate,
		ApiKeyScopeOrganizationMemberCreate,
		ApiKeyScopeOrganizationMemberDelete,
		ApiKeyScopeOrganizationMemberRead,
		ApiKeyScopeOrganizationMemberUpdate,
		ApiKeyScopePrebuiltWorkspaceDelete,
		ApiKeyScopePrebuiltWorkspaceUpdate,
		ApiKeyScopeProvisionerDaemonCreate,
		ApiKeyScopeProvisionerDaemonDelete,
		ApiKeyScopeProvisionerDaemonRead,
		ApiKeyScopeProvisionerDaemonUpdate,
		ApiKeyScopeProvisionerJobsCreate,
		ApiKeyScopeProvisionerJobsRead,
		ApiKeyScopeProvisionerJobsUpdate,
		ApiKeyScopeReplicasRead,
		ApiKeyScopeSystemCreate,
		ApiKeyScopeSystemDelete,
		ApiKeyScopeSystemRead,
		ApiKeyScopeSystemUpdate,
		ApiKeyScopeTailnetCoordinatorCreate,
		ApiKeyScopeTailnetCoordinatorDelete,
		ApiKeyScopeTailnetCoordinatorRead,
		ApiKeyScopeTailnetCoordinatorUpdate,
		ApiKeyScopeTemplateCreate,
		ApiKeyScopeTemplateDelete,
		ApiKeyScopeTemplateRead,
		ApiKeyScopeTemplateUpdate,
		ApiKeyScopeTemplateUse,
		ApiKeyScopeTemplateViewInsights,
		ApiKeyScopeUsageEventCreate,
		ApiKeyScopeUsageEventRead,
		ApiKeyScopeUsageEventUpdate,
		ApiKeyScopeUserCreate,
		ApiKeyScopeUserDelete,
		ApiKeyScopeUserRead,
		ApiKeyScopeUserReadPersonal,
		ApiKeyScopeUserUpdate,
		ApiKeyScopeUserUpdatePersonal,
		ApiKeyScopeUserSecretCreate,
		ApiKeyScopeUserSecretDelete,
		ApiKeyScopeUserSecretRead,
		ApiKeyScopeUserSecretUpdate,
		ApiKeyScopeWebpushSubscriptionCreate,
		ApiKeyScopeWebpushSubscriptionDelete,
		ApiKeyScopeWebpushSubscriptionRead,
		ApiKeyScopeWorkspaceApplicationConnect,
		ApiKeyScopeWorkspaceCreate,
		ApiKeyScopeWorkspaceCreateAgent,
		ApiKeyScopeWorkspaceDelete,
		ApiKeyScopeWorkspaceDeleteAgent,
		ApiKeyScopeWorkspaceRead,
		ApiKeyScopeWorkspaceSsh,
		ApiKeyScopeWorkspaceStart,
		ApiKeyScopeWorkspaceStop,
		ApiKeyScopeWorkspaceUpdate,
		ApiKeyScopeWorkspaceAgentDevcontainersCreate,
		ApiKeyScopeWorkspaceAgentResourceMonitorCreate,
		ApiKeyScopeWorkspaceAgentResourceMonitorRead,
		ApiKeyScopeWorkspaceAgentResourceMonitorUpdate,
		ApiKeyScopeWorkspaceDormantApplicationConnect,
		ApiKeyScopeWorkspaceDormantCreate,
		ApiKeyScopeWorkspaceDormantCreateAgent,
		ApiKeyScopeWorkspaceDormantDelete,
		ApiKeyScopeWorkspaceDormantDeleteAgent,
		ApiKeyScopeWorkspaceDormantRead,
		ApiKeyScopeWorkspaceDormantSsh,
		ApiKeyScopeWorkspaceDormantStart,
		ApiKeyScopeWorkspaceDormantStop,
		ApiKeyScopeWorkspaceDormantUpdate,
		ApiKeyScopeWorkspaceProxyCreate,
		ApiKeyScopeWorkspaceProxyDelete,
		ApiKeyScopeWorkspaceProxyRead,
		ApiKeyScopeWorkspaceProxyUpdate,
		ApiKeyScopeCoderWorkspacescreate,
		ApiKeyScopeCoderWorkspacesoperate,
		ApiKeyScopeCoderWorkspacesdelete,
		ApiKeyScopeCoderWorkspacesaccess,
		ApiKeyScopeCoderTemplatesbuild,
		ApiKeyScopeCoderTemplatesauthor,
		ApiKeyScopeCoderApikeysmanageSelf,
		ApiKeyScopeAibridgeInterception,
		ApiKeyScopeApiKey,
		ApiKeyScopeAssignOrgRole,
		ApiKeyScopeAssignRole,
		ApiKeyScopeAuditLog,
		ApiKeyScopeConnectionLog,
		ApiKeyScopeCryptoKey,
		ApiKeyScopeDebugInfo,
		ApiKeyScopeDeploymentConfig,
		ApiKeyScopeDeploymentStats,
		ApiKeyScopeFile,
		ApiKeyScopeGroup,
		ApiKeyScopeGroupMember,
		ApiKeyScopeIdpsyncSettings,
		ApiKeyScopeInboxNotification,
		ApiKeyScopeLicense,
		ApiKeyScopeNotificationMessage,
		ApiKeyScopeNotificationPreference,
		ApiKeyScopeNotificationTemplate,
		ApiKeyScopeOauth2App,
		ApiKeyScopeOauth2AppCodeToken,
		ApiKeyScopeOauth2AppSecret,
		ApiKeyScopeOrganization,
		ApiKeyScopeOrganizationMember,
		ApiKeyScopePrebuiltWorkspace,
		ApiKeyScopeProvisionerDaemon,
		ApiKeyScopeProvisionerJobs,
		ApiKeyScopeReplicas,
		ApiKeyScopeSystem,
		ApiKeyScopeTailnetCoordinator,
		ApiKeyScopeTemplate,
		ApiKeyScopeUsageEvent,
		ApiKeyScopeUser,
		ApiKeyScopeUserSecret,
		ApiKeyScopeWebpushSubscription,
		ApiKeyScopeWorkspace,
		ApiKeyScopeWorkspaceAgentDevcontainers,
		ApiKeyScopeWorkspaceAgentResourceMonitor,
		ApiKeyScopeWorkspaceDormant,
		ApiKeyScopeWorkspaceProxy,
		ApiKeyScopeTaskCreate,
		ApiKeyScopeTaskRead,
		ApiKeyScopeTaskUpdate,
		ApiKeyScopeTaskDelete,
		ApiKeyScopeTask,
		ApiKeyScopeWorkspaceShare,
		ApiKeyScopeWorkspaceDormantShare,
		ApiKeyScopeBoundaryUsage,
		ApiKeyScopeBoundaryUsageDelete,
		ApiKeyScopeBoundaryUsageRead,
		ApiKeyScopeBoundaryUsageUpdate,
	}
}

type AgentKeyScopeEnum string

const (
	AgentKeyScopeEnumAll        AgentKeyScopeEnum = "all"
	AgentKeyScopeEnumNoUserData AgentKeyScopeEnum = "no_user_data"
)

func (e *AgentKeyScopeEnum) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = AgentKeyScopeEnum(s)
	case string:
		*e = AgentKeyScopeEnum(s)
	default:
		return fmt.Errorf("unsupported scan type for AgentKeyScopeEnum: %T", src)
	}
	return nil
}

type NullAgentKeyScopeEnum struct {
	AgentKeyScopeEnum AgentKeyScopeEnum `json:"agent_key_scope_enum"`
	Valid             bool              `json:"valid"` // Valid is true if AgentKeyScopeEnum is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullAgentKeyScopeEnum) Scan(value interface{}) error {
	if value == nil {
		ns.AgentKeyScopeEnum, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.AgentKeyScopeEnum.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullAgentKeyScopeEnum) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.AgentKeyScopeEnum), nil
}

func (e AgentKeyScopeEnum) Valid() bool {
	switch e {
	case AgentKeyScopeEnumAll,
		AgentKeyScopeEnumNoUserData:
		return true
	}
	return false
}

func AllAgentKeyScopeEnumValues() []AgentKeyScopeEnum {
	return []AgentKeyScopeEnum{
		AgentKeyScopeEnumAll,
		AgentKeyScopeEnumNoUserData,
	}
}

type AppSharingLevel string

const (
	AppSharingLevelOwner         AppSharingLevel = "owner"
	AppSharingLevelAuthenticated AppSharingLevel = "authenticated"
	AppSharingLevelOrganization  AppSharingLevel = "organization"
	AppSharingLevelPublic        AppSharingLevel = "public"
)

func (e *AppSharingLevel) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = AppSharingLevel(s)
	case string:
		*e = AppSharingLevel(s)
	default:
		return fmt.Errorf("unsupported scan type for AppSharingLevel: %T", src)
	}
	return nil
}

type NullAppSharingLevel struct {
	AppSharingLevel AppSharingLevel `json:"app_sharing_level"`
	Valid           bool            `json:"valid"` // Valid is true if AppSharingLevel is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullAppSharingLevel) Scan(value interface{}) error {
	if value == nil {
		ns.AppSharingLevel, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.AppSharingLevel.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullAppSharingLevel) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.AppSharingLevel), nil
}

func (e AppSharingLevel) Valid() bool {
	switch e {
	case AppSharingLevelOwner,
		AppSharingLevelAuthenticated,
		AppSharingLevelOrganization,
		AppSharingLevelPublic:
		return true
	}
	return false
}

func AllAppSharingLevelValues() []AppSharingLevel {
	return []AppSharingLevel{
		AppSharingLevelOwner,
		AppSharingLevelAuthenticated,
		AppSharingLevelOrganization,
		AppSharingLevelPublic,
	}
}

// NOTE: `connect`, `disconnect`, `open`, and `close` are deprecated and no longer used - these events are now tracked in the connection_logs table.
type AuditAction string

const (
	AuditActionCreate               AuditAction = "create"
	AuditActionWrite                AuditAction = "write"
	AuditActionDelete               AuditAction = "delete"
	AuditActionStart                AuditAction = "start"
	AuditActionStop                 AuditAction = "stop"
	AuditActionLogin                AuditAction = "login"
	AuditActionLogout               AuditAction = "logout"
	AuditActionRegister             AuditAction = "register"
	AuditActionRequestPasswordReset AuditAction = "request_password_reset"
	AuditActionConnect              AuditAction = "connect"
	AuditActionDisconnect           AuditAction = "disconnect"
	AuditActionOpen                 AuditAction = "open"
	AuditActionClose                AuditAction = "close"
)

func (e *AuditAction) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = AuditAction(s)
	case string:
		*e = AuditAction(s)
	default:
		return fmt.Errorf("unsupported scan type for AuditAction: %T", src)
	}
	return nil
}

type NullAuditAction struct {
	AuditAction AuditAction `json:"audit_action"`
	Valid       bool        `json:"valid"` // Valid is true if AuditAction is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullAuditAction) Scan(value interface{}) error {
	if value == nil {
		ns.AuditAction, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.AuditAction.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullAuditAction) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.AuditAction), nil
}

func (e AuditAction) Valid() bool {
	switch e {
	case AuditActionCreate,
		AuditActionWrite,
		AuditActionDelete,
		AuditActionStart,
		AuditActionStop,
		AuditActionLogin,
		AuditActionLogout,
		AuditActionRegister,
		AuditActionRequestPasswordReset,
		AuditActionConnect,
		AuditActionDisconnect,
		AuditActionOpen,
		AuditActionClose:
		return true
	}
	return false
}

func AllAuditActionValues() []AuditAction {
	return []AuditAction{
		AuditActionCreate,
		AuditActionWrite,
		AuditActionDelete,
		AuditActionStart,
		AuditActionStop,
		AuditActionLogin,
		AuditActionLogout,
		AuditActionRegister,
		AuditActionRequestPasswordReset,
		AuditActionConnect,
		AuditActionDisconnect,
		AuditActionOpen,
		AuditActionClose,
	}
}

type AutomaticUpdates string

const (
	AutomaticUpdatesAlways AutomaticUpdates = "always"
	AutomaticUpdatesNever  AutomaticUpdates = "never"
)

func (e *AutomaticUpdates) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = AutomaticUpdates(s)
	case string:
		*e = AutomaticUpdates(s)
	default:
		return fmt.Errorf("unsupported scan type for AutomaticUpdates: %T", src)
	}
	return nil
}

type NullAutomaticUpdates struct {
	AutomaticUpdates AutomaticUpdates `json:"automatic_updates"`
	Valid            bool             `json:"valid"` // Valid is true if AutomaticUpdates is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullAutomaticUpdates) Scan(value interface{}) error {
	if value == nil {
		ns.AutomaticUpdates, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.AutomaticUpdates.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullAutomaticUpdates) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.AutomaticUpdates), nil
}

func (e AutomaticUpdates) Valid() bool {
	switch e {
	case AutomaticUpdatesAlways,
		AutomaticUpdatesNever:
		return true
	}
	return false
}

func AllAutomaticUpdatesValues() []AutomaticUpdates {
	return []AutomaticUpdates{
		AutomaticUpdatesAlways,
		AutomaticUpdatesNever,
	}
}

type BuildReason string

const (
	BuildReasonInitiator           BuildReason = "initiator"
	BuildReasonAutostart           BuildReason = "autostart"
	BuildReasonAutostop            BuildReason = "autostop"
	BuildReasonDormancy            BuildReason = "dormancy"
	BuildReasonFailedstop          BuildReason = "failedstop"
	BuildReasonAutodelete          BuildReason = "autodelete"
	BuildReasonDashboard           BuildReason = "dashboard"
	BuildReasonCli                 BuildReason = "cli"
	BuildReasonSshConnection       BuildReason = "ssh_connection"
	BuildReasonVscodeConnection    BuildReason = "vscode_connection"
	BuildReasonJetbrainsConnection BuildReason = "jetbrains_connection"
	BuildReasonTaskAutoPause       BuildReason = "task_auto_pause"
	BuildReasonTaskManualPause     BuildReason = "task_manual_pause"
	BuildReasonTaskResume          BuildReason = "task_resume"
)

func (e *BuildReason) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = BuildReason(s)
	case string:
		*e = BuildReason(s)
	default:
		return fmt.Errorf("unsupported scan type for BuildReason: %T", src)
	}
	return nil
}

type NullBuildReason struct {
	BuildReason BuildReason `json:"build_reason"`
	Valid       bool        `json:"valid"` // Valid is true if BuildReason is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullBuildReason) Scan(value interface{}) error {
	if value == nil {
		ns.BuildReason, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.BuildReason.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullBuildReason) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.BuildReason), nil
}

func (e BuildReason) Valid() bool {
	switch e {
	case BuildReasonInitiator,
		BuildReasonAutostart,
		BuildReasonAutostop,
		BuildReasonDormancy,
		BuildReasonFailedstop,
		BuildReasonAutodelete,
		BuildReasonDashboard,
		BuildReasonCli,
		BuildReasonSshConnection,
		BuildReasonVscodeConnection,
		BuildReasonJetbrainsConnection,
		BuildReasonTaskAutoPause,
		BuildReasonTaskManualPause,
		BuildReasonTaskResume:
		return true
	}
	return false
}

func AllBuildReasonValues() []BuildReason {
	return []BuildReason{
		BuildReasonInitiator,
		BuildReasonAutostart,
		BuildReasonAutostop,
		BuildReasonDormancy,
		BuildReasonFailedstop,
		BuildReasonAutodelete,
		BuildReasonDashboard,
		BuildReasonCli,
		BuildReasonSshConnection,
		BuildReasonVscodeConnection,
		BuildReasonJetbrainsConnection,
		BuildReasonTaskAutoPause,
		BuildReasonTaskManualPause,
		BuildReasonTaskResume,
	}
}

type ConnectionStatus string

const (
	ConnectionStatusConnected    ConnectionStatus = "connected"
	ConnectionStatusDisconnected ConnectionStatus = "disconnected"
)

func (e *ConnectionStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ConnectionStatus(s)
	case string:
		*e = ConnectionStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for ConnectionStatus: %T", src)
	}
	return nil
}

type NullConnectionStatus struct {
	ConnectionStatus ConnectionStatus `json:"connection_status"`
	Valid            bool             `json:"valid"` // Valid is true if ConnectionStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullConnectionStatus) Scan(value interface{}) error {
	if value == nil {
		ns.ConnectionStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ConnectionStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullConnectionStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ConnectionStatus), nil
}

func (e ConnectionStatus) Valid() bool {
	switch e {
	case ConnectionStatusConnected,
		ConnectionStatusDisconnected:
		return true
	}
	return false
}

func AllConnectionStatusValues() []ConnectionStatus {
	return []ConnectionStatus{
		ConnectionStatusConnected,
		ConnectionStatusDisconnected,
	}
}

type ConnectionType string

const (
	ConnectionTypeSsh             ConnectionType = "ssh"
	ConnectionTypeVscode          ConnectionType = "vscode"
	ConnectionTypeJetbrains       ConnectionType = "jetbrains"
	ConnectionTypeReconnectingPty ConnectionType = "reconnecting_pty"
	ConnectionTypeWorkspaceApp    ConnectionType = "workspace_app"
	ConnectionTypePortForwarding  ConnectionType = "port_forwarding"
)

func (e *ConnectionType) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ConnectionType(s)
	case string:
		*e = ConnectionType(s)
	default:
		return fmt.Errorf("unsupported scan type for ConnectionType: %T", src)
	}
	return nil
}

type NullConnectionType struct {
	ConnectionType ConnectionType `json:"connection_type"`
	Valid          bool           `json:"valid"` // Valid is true if ConnectionType is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullConnectionType) Scan(value interface{}) error {
	if value == nil {
		ns.ConnectionType, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ConnectionType.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullConnectionType) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ConnectionType), nil
}

func (e ConnectionType) Valid() bool {
	switch e {
	case ConnectionTypeSsh,
		ConnectionTypeVscode,
		ConnectionTypeJetbrains,
		ConnectionTypeReconnectingPty,
		ConnectionTypeWorkspaceApp,
		ConnectionTypePortForwarding:
		return true
	}
	return false
}

func AllConnectionTypeValues() []ConnectionType {
	return []ConnectionType{
		ConnectionTypeSsh,
		ConnectionTypeVscode,
		ConnectionTypeJetbrains,
		ConnectionTypeReconnectingPty,
		ConnectionTypeWorkspaceApp,
		ConnectionTypePortForwarding,
	}
}

type CorsBehavior string

const (
	CorsBehaviorSimple   CorsBehavior = "simple"
	CorsBehaviorPassthru CorsBehavior = "passthru"
)

func (e *CorsBehavior) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = CorsBehavior(s)
	case string:
		*e = CorsBehavior(s)
	default:
		return fmt.Errorf("unsupported scan type for CorsBehavior: %T", src)
	}
	return nil
}

type NullCorsBehavior struct {
	CorsBehavior CorsBehavior `json:"cors_behavior"`
	Valid        bool         `json:"valid"` // Valid is true if CorsBehavior is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullCorsBehavior) Scan(value interface{}) error {
	if value == nil {
		ns.CorsBehavior, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.CorsBehavior.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullCorsBehavior) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.CorsBehavior), nil
}

func (e CorsBehavior) Valid() bool {
	switch e {
	case CorsBehaviorSimple,
		CorsBehaviorPassthru:
		return true
	}
	return false
}

func AllCorsBehaviorValues() []CorsBehavior {
	return []CorsBehavior{
		CorsBehaviorSimple,
		CorsBehaviorPassthru,
	}
}

type CryptoKeyFeature string

const (
	CryptoKeyFeatureWorkspaceAppsToken  CryptoKeyFeature = "workspace_apps_token"
	CryptoKeyFeatureWorkspaceAppsAPIKey CryptoKeyFeature = "workspace_apps_api_key"
	CryptoKeyFeatureOIDCConvert         CryptoKeyFeature = "oidc_convert"
	CryptoKeyFeatureTailnetResume       CryptoKeyFeature = "tailnet_resume"
)

func (e *CryptoKeyFeature) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = CryptoKeyFeature(s)
	case string:
		*e = CryptoKeyFeature(s)
	default:
		return fmt.Errorf("unsupported scan type for CryptoKeyFeature: %T", src)
	}
	return nil
}

type NullCryptoKeyFeature struct {
	CryptoKeyFeature CryptoKeyFeature `json:"crypto_key_feature"`
	Valid            bool             `json:"valid"` // Valid is true if CryptoKeyFeature is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullCryptoKeyFeature) Scan(value interface{}) error {
	if value == nil {
		ns.CryptoKeyFeature, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.CryptoKeyFeature.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullCryptoKeyFeature) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.CryptoKeyFeature), nil
}

func (e CryptoKeyFeature) Valid() bool {
	switch e {
	case CryptoKeyFeatureWorkspaceAppsToken,
		CryptoKeyFeatureWorkspaceAppsAPIKey,
		CryptoKeyFeatureOIDCConvert,
		CryptoKeyFeatureTailnetResume:
		return true
	}
	return false
}

func AllCryptoKeyFeatureValues() []CryptoKeyFeature {
	return []CryptoKeyFeature{
		CryptoKeyFeatureWorkspaceAppsToken,
		CryptoKeyFeatureWorkspaceAppsAPIKey,
		CryptoKeyFeatureOIDCConvert,
		CryptoKeyFeatureTailnetResume,
	}
}

type DisplayApp string

const (
	DisplayAppVscode               DisplayApp = "vscode"
	DisplayAppVscodeInsiders       DisplayApp = "vscode_insiders"
	DisplayAppWebTerminal          DisplayApp = "web_terminal"
	DisplayAppSSHHelper            DisplayApp = "ssh_helper"
	DisplayAppPortForwardingHelper DisplayApp = "port_forwarding_helper"
)

func (e *DisplayApp) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = DisplayApp(s)
	case string:
		*e = DisplayApp(s)
	default:
		return fmt.Errorf("unsupported scan type for DisplayApp: %T", src)
	}
	return nil
}

type NullDisplayApp struct {
	DisplayApp DisplayApp `json:"display_app"`
	Valid      bool       `json:"valid"` // Valid is true if DisplayApp is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullDisplayApp) Scan(value interface{}) error {
	if value == nil {
		ns.DisplayApp, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.DisplayApp.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullDisplayApp) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.DisplayApp), nil
}

func (e DisplayApp) Valid() bool {
	switch e {
	case DisplayAppVscode,
		DisplayAppVscodeInsiders,
		DisplayAppWebTerminal,
		DisplayAppSSHHelper,
		DisplayAppPortForwardingHelper:
		return true
	}
	return false
}

func AllDisplayAppValues() []DisplayApp {
	return []DisplayApp{
		DisplayAppVscode,
		DisplayAppVscodeInsiders,
		DisplayAppWebTerminal,
		DisplayAppSSHHelper,
		DisplayAppPortForwardingHelper,
	}
}

type GroupSource string

const (
	GroupSourceUser GroupSource = "user"
	GroupSourceOidc GroupSource = "oidc"
)

func (e *GroupSource) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = GroupSource(s)
	case string:
		*e = GroupSource(s)
	default:
		return fmt.Errorf("unsupported scan type for GroupSource: %T", src)
	}
	return nil
}

type NullGroupSource struct {
	GroupSource GroupSource `json:"group_source"`
	Valid       bool        `json:"valid"` // Valid is true if GroupSource is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullGroupSource) Scan(value interface{}) error {
	if value == nil {
		ns.GroupSource, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.GroupSource.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullGroupSource) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.GroupSource), nil
}

func (e GroupSource) Valid() bool {
	switch e {
	case GroupSourceUser,
		GroupSourceOidc:
		return true
	}
	return false
}

func AllGroupSourceValues() []GroupSource {
	return []GroupSource{
		GroupSourceUser,
		GroupSourceOidc,
	}
}

type InboxNotificationReadStatus string

const (
	InboxNotificationReadStatusAll    InboxNotificationReadStatus = "all"
	InboxNotificationReadStatusUnread InboxNotificationReadStatus = "unread"
	InboxNotificationReadStatusRead   InboxNotificationReadStatus = "read"
)

func (e *InboxNotificationReadStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = InboxNotificationReadStatus(s)
	case string:
		*e = InboxNotificationReadStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for InboxNotificationReadStatus: %T", src)
	}
	return nil
}

type NullInboxNotificationReadStatus struct {
	InboxNotificationReadStatus InboxNotificationReadStatus `json:"inbox_notification_read_status"`
	Valid                       bool                        `json:"valid"` // Valid is true if InboxNotificationReadStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullInboxNotificationReadStatus) Scan(value interface{}) error {
	if value == nil {
		ns.InboxNotificationReadStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.InboxNotificationReadStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullInboxNotificationReadStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.InboxNotificationReadStatus), nil
}

func (e InboxNotificationReadStatus) Valid() bool {
	switch e {
	case InboxNotificationReadStatusAll,
		InboxNotificationReadStatusUnread,
		InboxNotificationReadStatusRead:
		return true
	}
	return false
}

func AllInboxNotificationReadStatusValues() []InboxNotificationReadStatus {
	return []InboxNotificationReadStatus{
		InboxNotificationReadStatusAll,
		InboxNotificationReadStatusUnread,
		InboxNotificationReadStatusRead,
	}
}

type LogLevel string

const (
	LogLevelTrace LogLevel = "trace"
	LogLevelDebug LogLevel = "debug"
	LogLevelInfo  LogLevel = "info"
	LogLevelWarn  LogLevel = "warn"
	LogLevelError LogLevel = "error"
)

func (e *LogLevel) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = LogLevel(s)
	case string:
		*e = LogLevel(s)
	default:
		return fmt.Errorf("unsupported scan type for LogLevel: %T", src)
	}
	return nil
}

type NullLogLevel struct {
	LogLevel LogLevel `json:"log_level"`
	Valid    bool     `json:"valid"` // Valid is true if LogLevel is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullLogLevel) Scan(value interface{}) error {
	if value == nil {
		ns.LogLevel, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.LogLevel.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullLogLevel) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.LogLevel), nil
}

func (e LogLevel) Valid() bool {
	switch e {
	case LogLevelTrace,
		LogLevelDebug,
		LogLevelInfo,
		LogLevelWarn,
		LogLevelError:
		return true
	}
	return false
}

func AllLogLevelValues() []LogLevel {
	return []LogLevel{
		LogLevelTrace,
		LogLevelDebug,
		LogLevelInfo,
		LogLevelWarn,
		LogLevelError,
	}
}

type LogSource string

const (
	LogSourceProvisionerDaemon LogSource = "provisioner_daemon"
	LogSourceProvisioner       LogSource = "provisioner"
)

func (e *LogSource) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = LogSource(s)
	case string:
		*e = LogSource(s)
	default:
		return fmt.Errorf("unsupported scan type for LogSource: %T", src)
	}
	return nil
}

type NullLogSource struct {
	LogSource LogSource `json:"log_source"`
	Valid     bool      `json:"valid"` // Valid is true if LogSource is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullLogSource) Scan(value interface{}) error {
	if value == nil {
		ns.LogSource, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.LogSource.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullLogSource) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.LogSource), nil
}

func (e LogSource) Valid() bool {
	switch e {
	case LogSourceProvisionerDaemon,
		LogSourceProvisioner:
		return true
	}
	return false
}

func AllLogSourceValues() []LogSource {
	return []LogSource{
		LogSourceProvisionerDaemon,
		LogSourceProvisioner,
	}
}

// Specifies the method of authentication. "none" is a special case in which no authentication method is allowed.
type LoginType string

const (
	LoginTypePassword          LoginType = "password"
	LoginTypeGithub            LoginType = "github"
	LoginTypeOIDC              LoginType = "oidc"
	LoginTypeToken             LoginType = "token"
	LoginTypeNone              LoginType = "none"
	LoginTypeOAuth2ProviderApp LoginType = "oauth2_provider_app"
)

func (e *LoginType) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = LoginType(s)
	case string:
		*e = LoginType(s)
	default:
		return fmt.Errorf("unsupported scan type for LoginType: %T", src)
	}
	return nil
}

type NullLoginType struct {
	LoginType LoginType `json:"login_type"`
	Valid     bool      `json:"valid"` // Valid is true if LoginType is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullLoginType) Scan(value interface{}) error {
	if value == nil {
		ns.LoginType, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.LoginType.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullLoginType) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.LoginType), nil
}

func (e LoginType) Valid() bool {
	switch e {
	case LoginTypePassword,
		LoginTypeGithub,
		LoginTypeOIDC,
		LoginTypeToken,
		LoginTypeNone,
		LoginTypeOAuth2ProviderApp:
		return true
	}
	return false
}

func AllLoginTypeValues() []LoginType {
	return []LoginType{
		LoginTypePassword,
		LoginTypeGithub,
		LoginTypeOIDC,
		LoginTypeToken,
		LoginTypeNone,
		LoginTypeOAuth2ProviderApp,
	}
}

type NotificationMessageStatus string

const (
	NotificationMessageStatusPending          NotificationMessageStatus = "pending"
	NotificationMessageStatusLeased           NotificationMessageStatus = "leased"
	NotificationMessageStatusSent             NotificationMessageStatus = "sent"
	NotificationMessageStatusPermanentFailure NotificationMessageStatus = "permanent_failure"
	NotificationMessageStatusTemporaryFailure NotificationMessageStatus = "temporary_failure"
	NotificationMessageStatusUnknown          NotificationMessageStatus = "unknown"
	NotificationMessageStatusInhibited        NotificationMessageStatus = "inhibited"
)

func (e *NotificationMessageStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = NotificationMessageStatus(s)
	case string:
		*e = NotificationMessageStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for NotificationMessageStatus: %T", src)
	}
	return nil
}

type NullNotificationMessageStatus struct {
	NotificationMessageStatus NotificationMessageStatus `json:"notification_message_status"`
	Valid                     bool                      `json:"valid"` // Valid is true if NotificationMessageStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullNotificationMessageStatus) Scan(value interface{}) error {
	if value == nil {
		ns.NotificationMessageStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.NotificationMessageStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullNotificationMessageStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.NotificationMessageStatus), nil
}

func (e NotificationMessageStatus) Valid() bool {
	switch e {
	case NotificationMessageStatusPending,
		NotificationMessageStatusLeased,
		NotificationMessageStatusSent,
		NotificationMessageStatusPermanentFailure,
		NotificationMessageStatusTemporaryFailure,
		NotificationMessageStatusUnknown,
		NotificationMessageStatusInhibited:
		return true
	}
	return false
}

func AllNotificationMessageStatusValues() []NotificationMessageStatus {
	return []NotificationMessageStatus{
		NotificationMessageStatusPending,
		NotificationMessageStatusLeased,
		NotificationMessageStatusSent,
		NotificationMessageStatusPermanentFailure,
		NotificationMessageStatusTemporaryFailure,
		NotificationMessageStatusUnknown,
		NotificationMessageStatusInhibited,
	}
}

type NotificationMethod string

const (
	NotificationMethodSmtp    NotificationMethod = "smtp"
	NotificationMethodWebhook NotificationMethod = "webhook"
	NotificationMethodInbox   NotificationMethod = "inbox"
)

func (e *NotificationMethod) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = NotificationMethod(s)
	case string:
		*e = NotificationMethod(s)
	default:
		return fmt.Errorf("unsupported scan type for NotificationMethod: %T", src)
	}
	return nil
}

type NullNotificationMethod struct {
	NotificationMethod NotificationMethod `json:"notification_method"`
	Valid              bool               `json:"valid"` // Valid is true if NotificationMethod is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullNotificationMethod) Scan(value interface{}) error {
	if value == nil {
		ns.NotificationMethod, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.NotificationMethod.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullNotificationMethod) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.NotificationMethod), nil
}

func (e NotificationMethod) Valid() bool {
	switch e {
	case NotificationMethodSmtp,
		NotificationMethodWebhook,
		NotificationMethodInbox:
		return true
	}
	return false
}

func AllNotificationMethodValues() []NotificationMethod {
	return []NotificationMethod{
		NotificationMethodSmtp,
		NotificationMethodWebhook,
		NotificationMethodInbox,
	}
}

type NotificationTemplateKind string

const (
	NotificationTemplateKindSystem NotificationTemplateKind = "system"
	NotificationTemplateKindCustom NotificationTemplateKind = "custom"
)

func (e *NotificationTemplateKind) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = NotificationTemplateKind(s)
	case string:
		*e = NotificationTemplateKind(s)
	default:
		return fmt.Errorf("unsupported scan type for NotificationTemplateKind: %T", src)
	}
	return nil
}

type NullNotificationTemplateKind struct {
	NotificationTemplateKind NotificationTemplateKind `json:"notification_template_kind"`
	Valid                    bool                     `json:"valid"` // Valid is true if NotificationTemplateKind is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullNotificationTemplateKind) Scan(value interface{}) error {
	if value == nil {
		ns.NotificationTemplateKind, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.NotificationTemplateKind.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullNotificationTemplateKind) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.NotificationTemplateKind), nil
}

func (e NotificationTemplateKind) Valid() bool {
	switch e {
	case NotificationTemplateKindSystem,
		NotificationTemplateKindCustom:
		return true
	}
	return false
}

func AllNotificationTemplateKindValues() []NotificationTemplateKind {
	return []NotificationTemplateKind{
		NotificationTemplateKindSystem,
		NotificationTemplateKindCustom,
	}
}

type ParameterDestinationScheme string

const (
	ParameterDestinationSchemeNone                ParameterDestinationScheme = "none"
	ParameterDestinationSchemeEnvironmentVariable ParameterDestinationScheme = "environment_variable"
	ParameterDestinationSchemeProvisionerVariable ParameterDestinationScheme = "provisioner_variable"
)

func (e *ParameterDestinationScheme) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ParameterDestinationScheme(s)
	case string:
		*e = ParameterDestinationScheme(s)
	default:
		return fmt.Errorf("unsupported scan type for ParameterDestinationScheme: %T", src)
	}
	return nil
}

type NullParameterDestinationScheme struct {
	ParameterDestinationScheme ParameterDestinationScheme `json:"parameter_destination_scheme"`
	Valid                      bool                       `json:"valid"` // Valid is true if ParameterDestinationScheme is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullParameterDestinationScheme) Scan(value interface{}) error {
	if value == nil {
		ns.ParameterDestinationScheme, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ParameterDestinationScheme.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullParameterDestinationScheme) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ParameterDestinationScheme), nil
}

func (e ParameterDestinationScheme) Valid() bool {
	switch e {
	case ParameterDestinationSchemeNone,
		ParameterDestinationSchemeEnvironmentVariable,
		ParameterDestinationSchemeProvisionerVariable:
		return true
	}
	return false
}

func AllParameterDestinationSchemeValues() []ParameterDestinationScheme {
	return []ParameterDestinationScheme{
		ParameterDestinationSchemeNone,
		ParameterDestinationSchemeEnvironmentVariable,
		ParameterDestinationSchemeProvisionerVariable,
	}
}

// Enum set should match the terraform provider set. This is defined as future form_types are not supported, and should be rejected. Always include the empty string for using the default form type.
type ParameterFormType string

const (
	ParameterFormTypeValue0      ParameterFormType = ""
	ParameterFormTypeError       ParameterFormType = "error"
	ParameterFormTypeRadio       ParameterFormType = "radio"
	ParameterFormTypeDropdown    ParameterFormType = "dropdown"
	ParameterFormTypeInput       ParameterFormType = "input"
	ParameterFormTypeTextarea    ParameterFormType = "textarea"
	ParameterFormTypeSlider      ParameterFormType = "slider"
	ParameterFormTypeCheckbox    ParameterFormType = "checkbox"
	ParameterFormTypeSwitch      ParameterFormType = "switch"
	ParameterFormTypeTagSelect   ParameterFormType = "tag-select"
	ParameterFormTypeMultiSelect ParameterFormType = "multi-select"
)

func (e *ParameterFormType) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ParameterFormType(s)
	case string:
		*e = ParameterFormType(s)
	default:
		return fmt.Errorf("unsupported scan type for ParameterFormType: %T", src)
	}
	return nil
}

type NullParameterFormType struct {
	ParameterFormType ParameterFormType `json:"parameter_form_type"`
	Valid             bool              `json:"valid"` // Valid is true if ParameterFormType is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullParameterFormType) Scan(value interface{}) error {
	if value == nil {
		ns.ParameterFormType, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ParameterFormType.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullParameterFormType) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ParameterFormType), nil
}

func (e ParameterFormType) Valid() bool {
	switch e {
	case ParameterFormTypeValue0,
		ParameterFormTypeError,
		ParameterFormTypeRadio,
		ParameterFormTypeDropdown,
		ParameterFormTypeInput,
		ParameterFormTypeTextarea,
		ParameterFormTypeSlider,
		ParameterFormTypeCheckbox,
		ParameterFormTypeSwitch,
		ParameterFormTypeTagSelect,
		ParameterFormTypeMultiSelect:
		return true
	}
	return false
}

func AllParameterFormTypeValues() []ParameterFormType {
	return []ParameterFormType{
		ParameterFormTypeValue0,
		ParameterFormTypeError,
		ParameterFormTypeRadio,
		ParameterFormTypeDropdown,
		ParameterFormTypeInput,
		ParameterFormTypeTextarea,
		ParameterFormTypeSlider,
		ParameterFormTypeCheckbox,
		ParameterFormTypeSwitch,
		ParameterFormTypeTagSelect,
		ParameterFormTypeMultiSelect,
	}
}

type ParameterScope string

const (
	ParameterScopeTemplate  ParameterScope = "template"
	ParameterScopeImportJob ParameterScope = "import_job"
	ParameterScopeWorkspace ParameterScope = "workspace"
)

func (e *ParameterScope) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ParameterScope(s)
	case string:
		*e = ParameterScope(s)
	default:
		return fmt.Errorf("unsupported scan type for ParameterScope: %T", src)
	}
	return nil
}

type NullParameterScope struct {
	ParameterScope ParameterScope `json:"parameter_scope"`
	Valid          bool           `json:"valid"` // Valid is true if ParameterScope is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullParameterScope) Scan(value interface{}) error {
	if value == nil {
		ns.ParameterScope, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ParameterScope.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullParameterScope) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ParameterScope), nil
}

func (e ParameterScope) Valid() bool {
	switch e {
	case ParameterScopeTemplate,
		ParameterScopeImportJob,
		ParameterScopeWorkspace:
		return true
	}
	return false
}

func AllParameterScopeValues() []ParameterScope {
	return []ParameterScope{
		ParameterScopeTemplate,
		ParameterScopeImportJob,
		ParameterScopeWorkspace,
	}
}

type ParameterSourceScheme string

const (
	ParameterSourceSchemeNone ParameterSourceScheme = "none"
	ParameterSourceSchemeData ParameterSourceScheme = "data"
)

func (e *ParameterSourceScheme) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ParameterSourceScheme(s)
	case string:
		*e = ParameterSourceScheme(s)
	default:
		return fmt.Errorf("unsupported scan type for ParameterSourceScheme: %T", src)
	}
	return nil
}

type NullParameterSourceScheme struct {
	ParameterSourceScheme ParameterSourceScheme `json:"parameter_source_scheme"`
	Valid                 bool                  `json:"valid"` // Valid is true if ParameterSourceScheme is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullParameterSourceScheme) Scan(value interface{}) error {
	if value == nil {
		ns.ParameterSourceScheme, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ParameterSourceScheme.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullParameterSourceScheme) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ParameterSourceScheme), nil
}

func (e ParameterSourceScheme) Valid() bool {
	switch e {
	case ParameterSourceSchemeNone,
		ParameterSourceSchemeData:
		return true
	}
	return false
}

func AllParameterSourceSchemeValues() []ParameterSourceScheme {
	return []ParameterSourceScheme{
		ParameterSourceSchemeNone,
		ParameterSourceSchemeData,
	}
}

type ParameterTypeSystem string

const (
	ParameterTypeSystemNone ParameterTypeSystem = "none"
	ParameterTypeSystemHCL  ParameterTypeSystem = "hcl"
)

func (e *ParameterTypeSystem) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ParameterTypeSystem(s)
	case string:
		*e = ParameterTypeSystem(s)
	default:
		return fmt.Errorf("unsupported scan type for ParameterTypeSystem: %T", src)
	}
	return nil
}

type NullParameterTypeSystem struct {
	ParameterTypeSystem ParameterTypeSystem `json:"parameter_type_system"`
	Valid               bool                `json:"valid"` // Valid is true if ParameterTypeSystem is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullParameterTypeSystem) Scan(value interface{}) error {
	if value == nil {
		ns.ParameterTypeSystem, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ParameterTypeSystem.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullParameterTypeSystem) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ParameterTypeSystem), nil
}

func (e ParameterTypeSystem) Valid() bool {
	switch e {
	case ParameterTypeSystemNone,
		ParameterTypeSystemHCL:
		return true
	}
	return false
}

func AllParameterTypeSystemValues() []ParameterTypeSystem {
	return []ParameterTypeSystem{
		ParameterTypeSystemNone,
		ParameterTypeSystemHCL,
	}
}

type PortShareProtocol string

const (
	PortShareProtocolHttp  PortShareProtocol = "http"
	PortShareProtocolHttps PortShareProtocol = "https"
)

func (e *PortShareProtocol) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = PortShareProtocol(s)
	case string:
		*e = PortShareProtocol(s)
	default:
		return fmt.Errorf("unsupported scan type for PortShareProtocol: %T", src)
	}
	return nil
}

type NullPortShareProtocol struct {
	PortShareProtocol PortShareProtocol `json:"port_share_protocol"`
	Valid             bool              `json:"valid"` // Valid is true if PortShareProtocol is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullPortShareProtocol) Scan(value interface{}) error {
	if value == nil {
		ns.PortShareProtocol, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.PortShareProtocol.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullPortShareProtocol) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.PortShareProtocol), nil
}

func (e PortShareProtocol) Valid() bool {
	switch e {
	case PortShareProtocolHttp,
		PortShareProtocolHttps:
		return true
	}
	return false
}

func AllPortShareProtocolValues() []PortShareProtocol {
	return []PortShareProtocol{
		PortShareProtocolHttp,
		PortShareProtocolHttps,
	}
}

type PrebuildStatus string

const (
	PrebuildStatusHealthy          PrebuildStatus = "healthy"
	PrebuildStatusHardLimited      PrebuildStatus = "hard_limited"
	PrebuildStatusValidationFailed PrebuildStatus = "validation_failed"
)

func (e *PrebuildStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = PrebuildStatus(s)
	case string:
		*e = PrebuildStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for PrebuildStatus: %T", src)
	}
	return nil
}

type NullPrebuildStatus struct {
	PrebuildStatus PrebuildStatus `json:"prebuild_status"`
	Valid          bool           `json:"valid"` // Valid is true if PrebuildStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullPrebuildStatus) Scan(value interface{}) error {
	if value == nil {
		ns.PrebuildStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.PrebuildStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullPrebuildStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.PrebuildStatus), nil
}

func (e PrebuildStatus) Valid() bool {
	switch e {
	case PrebuildStatusHealthy,
		PrebuildStatusHardLimited,
		PrebuildStatusValidationFailed:
		return true
	}
	return false
}

func AllPrebuildStatusValues() []PrebuildStatus {
	return []PrebuildStatus{
		PrebuildStatusHealthy,
		PrebuildStatusHardLimited,
		PrebuildStatusValidationFailed,
	}
}

// The status of a provisioner daemon.
type ProvisionerDaemonStatus string

const (
	ProvisionerDaemonStatusOffline ProvisionerDaemonStatus = "offline"
	ProvisionerDaemonStatusIdle    ProvisionerDaemonStatus = "idle"
	ProvisionerDaemonStatusBusy    ProvisionerDaemonStatus = "busy"
)

func (e *ProvisionerDaemonStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ProvisionerDaemonStatus(s)
	case string:
		*e = ProvisionerDaemonStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for ProvisionerDaemonStatus: %T", src)
	}
	return nil
}

type NullProvisionerDaemonStatus struct {
	ProvisionerDaemonStatus ProvisionerDaemonStatus `json:"provisioner_daemon_status"`
	Valid                   bool                    `json:"valid"` // Valid is true if ProvisionerDaemonStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullProvisionerDaemonStatus) Scan(value interface{}) error {
	if value == nil {
		ns.ProvisionerDaemonStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ProvisionerDaemonStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullProvisionerDaemonStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ProvisionerDaemonStatus), nil
}

func (e ProvisionerDaemonStatus) Valid() bool {
	switch e {
	case ProvisionerDaemonStatusOffline,
		ProvisionerDaemonStatusIdle,
		ProvisionerDaemonStatusBusy:
		return true
	}
	return false
}

func AllProvisionerDaemonStatusValues() []ProvisionerDaemonStatus {
	return []ProvisionerDaemonStatus{
		ProvisionerDaemonStatusOffline,
		ProvisionerDaemonStatusIdle,
		ProvisionerDaemonStatusBusy,
	}
}

// Computed status of a provisioner job. Jobs could be stuck in a hung state, these states do not guarantee any transition to another state.
type ProvisionerJobStatus string

const (
	ProvisionerJobStatusPending   ProvisionerJobStatus = "pending"
	ProvisionerJobStatusRunning   ProvisionerJobStatus = "running"
	ProvisionerJobStatusSucceeded ProvisionerJobStatus = "succeeded"
	ProvisionerJobStatusCanceling ProvisionerJobStatus = "canceling"
	ProvisionerJobStatusCanceled  ProvisionerJobStatus = "canceled"
	ProvisionerJobStatusFailed    ProvisionerJobStatus = "failed"
	ProvisionerJobStatusUnknown   ProvisionerJobStatus = "unknown"
)

func (e *ProvisionerJobStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ProvisionerJobStatus(s)
	case string:
		*e = ProvisionerJobStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for ProvisionerJobStatus: %T", src)
	}
	return nil
}

type NullProvisionerJobStatus struct {
	ProvisionerJobStatus ProvisionerJobStatus `json:"provisioner_job_status"`
	Valid                bool                 `json:"valid"` // Valid is true if ProvisionerJobStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullProvisionerJobStatus) Scan(value interface{}) error {
	if value == nil {
		ns.ProvisionerJobStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ProvisionerJobStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullProvisionerJobStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ProvisionerJobStatus), nil
}

func (e ProvisionerJobStatus) Valid() bool {
	switch e {
	case ProvisionerJobStatusPending,
		ProvisionerJobStatusRunning,
		ProvisionerJobStatusSucceeded,
		ProvisionerJobStatusCanceling,
		ProvisionerJobStatusCanceled,
		ProvisionerJobStatusFailed,
		ProvisionerJobStatusUnknown:
		return true
	}
	return false
}

func AllProvisionerJobStatusValues() []ProvisionerJobStatus {
	return []ProvisionerJobStatus{
		ProvisionerJobStatusPending,
		ProvisionerJobStatusRunning,
		ProvisionerJobStatusSucceeded,
		ProvisionerJobStatusCanceling,
		ProvisionerJobStatusCanceled,
		ProvisionerJobStatusFailed,
		ProvisionerJobStatusUnknown,
	}
}

type ProvisionerJobTimingStage string

const (
	ProvisionerJobTimingStageInit  ProvisionerJobTimingStage = "init"
	ProvisionerJobTimingStagePlan  ProvisionerJobTimingStage = "plan"
	ProvisionerJobTimingStageGraph ProvisionerJobTimingStage = "graph"
	ProvisionerJobTimingStageApply ProvisionerJobTimingStage = "apply"
)

func (e *ProvisionerJobTimingStage) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ProvisionerJobTimingStage(s)
	case string:
		*e = ProvisionerJobTimingStage(s)
	default:
		return fmt.Errorf("unsupported scan type for ProvisionerJobTimingStage: %T", src)
	}
	return nil
}

type NullProvisionerJobTimingStage struct {
	ProvisionerJobTimingStage ProvisionerJobTimingStage `json:"provisioner_job_timing_stage"`
	Valid                     bool                      `json:"valid"` // Valid is true if ProvisionerJobTimingStage is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullProvisionerJobTimingStage) Scan(value interface{}) error {
	if value == nil {
		ns.ProvisionerJobTimingStage, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ProvisionerJobTimingStage.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullProvisionerJobTimingStage) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ProvisionerJobTimingStage), nil
}

func (e ProvisionerJobTimingStage) Valid() bool {
	switch e {
	case ProvisionerJobTimingStageInit,
		ProvisionerJobTimingStagePlan,
		ProvisionerJobTimingStageGraph,
		ProvisionerJobTimingStageApply:
		return true
	}
	return false
}

func AllProvisionerJobTimingStageValues() []ProvisionerJobTimingStage {
	return []ProvisionerJobTimingStage{
		ProvisionerJobTimingStageInit,
		ProvisionerJobTimingStagePlan,
		ProvisionerJobTimingStageGraph,
		ProvisionerJobTimingStageApply,
	}
}

type ProvisionerJobType string

const (
	ProvisionerJobTypeTemplateVersionImport ProvisionerJobType = "template_version_import"
	ProvisionerJobTypeWorkspaceBuild        ProvisionerJobType = "workspace_build"
	ProvisionerJobTypeTemplateVersionDryRun ProvisionerJobType = "template_version_dry_run"
)

func (e *ProvisionerJobType) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ProvisionerJobType(s)
	case string:
		*e = ProvisionerJobType(s)
	default:
		return fmt.Errorf("unsupported scan type for ProvisionerJobType: %T", src)
	}
	return nil
}

type NullProvisionerJobType struct {
	ProvisionerJobType ProvisionerJobType `json:"provisioner_job_type"`
	Valid              bool               `json:"valid"` // Valid is true if ProvisionerJobType is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullProvisionerJobType) Scan(value interface{}) error {
	if value == nil {
		ns.ProvisionerJobType, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ProvisionerJobType.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullProvisionerJobType) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ProvisionerJobType), nil
}

func (e ProvisionerJobType) Valid() bool {
	switch e {
	case ProvisionerJobTypeTemplateVersionImport,
		ProvisionerJobTypeWorkspaceBuild,
		ProvisionerJobTypeTemplateVersionDryRun:
		return true
	}
	return false
}

func AllProvisionerJobTypeValues() []ProvisionerJobType {
	return []ProvisionerJobType{
		ProvisionerJobTypeTemplateVersionImport,
		ProvisionerJobTypeWorkspaceBuild,
		ProvisionerJobTypeTemplateVersionDryRun,
	}
}

type ProvisionerStorageMethod string

const (
	ProvisionerStorageMethodFile ProvisionerStorageMethod = "file"
)

func (e *ProvisionerStorageMethod) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ProvisionerStorageMethod(s)
	case string:
		*e = ProvisionerStorageMethod(s)
	default:
		return fmt.Errorf("unsupported scan type for ProvisionerStorageMethod: %T", src)
	}
	return nil
}

type NullProvisionerStorageMethod struct {
	ProvisionerStorageMethod ProvisionerStorageMethod `json:"provisioner_storage_method"`
	Valid                    bool                     `json:"valid"` // Valid is true if ProvisionerStorageMethod is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullProvisionerStorageMethod) Scan(value interface{}) error {
	if value == nil {
		ns.ProvisionerStorageMethod, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ProvisionerStorageMethod.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullProvisionerStorageMethod) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ProvisionerStorageMethod), nil
}

func (e ProvisionerStorageMethod) Valid() bool {
	switch e {
	case ProvisionerStorageMethodFile:
		return true
	}
	return false
}

func AllProvisionerStorageMethodValues() []ProvisionerStorageMethod {
	return []ProvisionerStorageMethod{
		ProvisionerStorageMethodFile,
	}
}

type ProvisionerType string

const (
	ProvisionerTypeEcho      ProvisionerType = "echo"
	ProvisionerTypeTerraform ProvisionerType = "terraform"
)

func (e *ProvisionerType) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ProvisionerType(s)
	case string:
		*e = ProvisionerType(s)
	default:
		return fmt.Errorf("unsupported scan type for ProvisionerType: %T", src)
	}
	return nil
}

type NullProvisionerType struct {
	ProvisionerType ProvisionerType `json:"provisioner_type"`
	Valid           bool            `json:"valid"` // Valid is true if ProvisionerType is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullProvisionerType) Scan(value interface{}) error {
	if value == nil {
		ns.ProvisionerType, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ProvisionerType.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullProvisionerType) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ProvisionerType), nil
}

func (e ProvisionerType) Valid() bool {
	switch e {
	case ProvisionerTypeEcho,
		ProvisionerTypeTerraform:
		return true
	}
	return false
}

func AllProvisionerTypeValues() []ProvisionerType {
	return []ProvisionerType{
		ProvisionerTypeEcho,
		ProvisionerTypeTerraform,
	}
}

type ResourceType string

const (
	ResourceTypeOrganization                ResourceType = "organization"
	ResourceTypeTemplate                    ResourceType = "template"
	ResourceTypeTemplateVersion             ResourceType = "template_version"
	ResourceTypeUser                        ResourceType = "user"
	ResourceTypeWorkspace                   ResourceType = "workspace"
	ResourceTypeGitSshKey                   ResourceType = "git_ssh_key"
	ResourceTypeApiKey                      ResourceType = "api_key"
	ResourceTypeGroup                       ResourceType = "group"
	ResourceTypeWorkspaceBuild              ResourceType = "workspace_build"
	ResourceTypeLicense                     ResourceType = "license"
	ResourceTypeWorkspaceProxy              ResourceType = "workspace_proxy"
	ResourceTypeConvertLogin                ResourceType = "convert_login"
	ResourceTypeHealthSettings              ResourceType = "health_settings"
	ResourceTypeOauth2ProviderApp           ResourceType = "oauth2_provider_app"
	ResourceTypeOauth2ProviderAppSecret     ResourceType = "oauth2_provider_app_secret"
	ResourceTypeCustomRole                  ResourceType = "custom_role"
	ResourceTypeOrganizationMember          ResourceType = "organization_member"
	ResourceTypeNotificationsSettings       ResourceType = "notifications_settings"
	ResourceTypeNotificationTemplate        ResourceType = "notification_template"
	ResourceTypeIdpSyncSettingsOrganization ResourceType = "idp_sync_settings_organization"
	ResourceTypeIdpSyncSettingsGroup        ResourceType = "idp_sync_settings_group"
	ResourceTypeIdpSyncSettingsRole         ResourceType = "idp_sync_settings_role"
	ResourceTypeWorkspaceAgent              ResourceType = "workspace_agent"
	ResourceTypeWorkspaceApp                ResourceType = "workspace_app"
	ResourceTypePrebuildsSettings           ResourceType = "prebuilds_settings"
	ResourceTypeTask                        ResourceType = "task"
)

func (e *ResourceType) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = ResourceType(s)
	case string:
		*e = ResourceType(s)
	default:
		return fmt.Errorf("unsupported scan type for ResourceType: %T", src)
	}
	return nil
}

type NullResourceType struct {
	ResourceType ResourceType `json:"resource_type"`
	Valid        bool         `json:"valid"` // Valid is true if ResourceType is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullResourceType) Scan(value interface{}) error {
	if value == nil {
		ns.ResourceType, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.ResourceType.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullResourceType) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.ResourceType), nil
}

func (e ResourceType) Valid() bool {
	switch e {
	case ResourceTypeOrganization,
		ResourceTypeTemplate,
		ResourceTypeTemplateVersion,
		ResourceTypeUser,
		ResourceTypeWorkspace,
		ResourceTypeGitSshKey,
		ResourceTypeApiKey,
		ResourceTypeGroup,
		ResourceTypeWorkspaceBuild,
		ResourceTypeLicense,
		ResourceTypeWorkspaceProxy,
		ResourceTypeConvertLogin,
		ResourceTypeHealthSettings,
		ResourceTypeOauth2ProviderApp,
		ResourceTypeOauth2ProviderAppSecret,
		ResourceTypeCustomRole,
		ResourceTypeOrganizationMember,
		ResourceTypeNotificationsSettings,
		ResourceTypeNotificationTemplate,
		ResourceTypeIdpSyncSettingsOrganization,
		ResourceTypeIdpSyncSettingsGroup,
		ResourceTypeIdpSyncSettingsRole,
		ResourceTypeWorkspaceAgent,
		ResourceTypeWorkspaceApp,
		ResourceTypePrebuildsSettings,
		ResourceTypeTask:
		return true
	}
	return false
}

func AllResourceTypeValues() []ResourceType {
	return []ResourceType{
		ResourceTypeOrganization,
		ResourceTypeTemplate,
		ResourceTypeTemplateVersion,
		ResourceTypeUser,
		ResourceTypeWorkspace,
		ResourceTypeGitSshKey,
		ResourceTypeApiKey,
		ResourceTypeGroup,
		ResourceTypeWorkspaceBuild,
		ResourceTypeLicense,
		ResourceTypeWorkspaceProxy,
		ResourceTypeConvertLogin,
		ResourceTypeHealthSettings,
		ResourceTypeOauth2ProviderApp,
		ResourceTypeOauth2ProviderAppSecret,
		ResourceTypeCustomRole,
		ResourceTypeOrganizationMember,
		ResourceTypeNotificationsSettings,
		ResourceTypeNotificationTemplate,
		ResourceTypeIdpSyncSettingsOrganization,
		ResourceTypeIdpSyncSettingsGroup,
		ResourceTypeIdpSyncSettingsRole,
		ResourceTypeWorkspaceAgent,
		ResourceTypeWorkspaceApp,
		ResourceTypePrebuildsSettings,
		ResourceTypeTask,
	}
}

type StartupScriptBehavior string

const (
	StartupScriptBehaviorBlocking    StartupScriptBehavior = "blocking"
	StartupScriptBehaviorNonBlocking StartupScriptBehavior = "non-blocking"
)

func (e *StartupScriptBehavior) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = StartupScriptBehavior(s)
	case string:
		*e = StartupScriptBehavior(s)
	default:
		return fmt.Errorf("unsupported scan type for StartupScriptBehavior: %T", src)
	}
	return nil
}

type NullStartupScriptBehavior struct {
	StartupScriptBehavior StartupScriptBehavior `json:"startup_script_behavior"`
	Valid                 bool                  `json:"valid"` // Valid is true if StartupScriptBehavior is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullStartupScriptBehavior) Scan(value interface{}) error {
	if value == nil {
		ns.StartupScriptBehavior, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.StartupScriptBehavior.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullStartupScriptBehavior) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.StartupScriptBehavior), nil
}

func (e StartupScriptBehavior) Valid() bool {
	switch e {
	case StartupScriptBehaviorBlocking,
		StartupScriptBehaviorNonBlocking:
		return true
	}
	return false
}

func AllStartupScriptBehaviorValues() []StartupScriptBehavior {
	return []StartupScriptBehavior{
		StartupScriptBehaviorBlocking,
		StartupScriptBehaviorNonBlocking,
	}
}

type TailnetStatus string

const (
	TailnetStatusOk   TailnetStatus = "ok"
	TailnetStatusLost TailnetStatus = "lost"
)

func (e *TailnetStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = TailnetStatus(s)
	case string:
		*e = TailnetStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for TailnetStatus: %T", src)
	}
	return nil
}

type NullTailnetStatus struct {
	TailnetStatus TailnetStatus `json:"tailnet_status"`
	Valid         bool          `json:"valid"` // Valid is true if TailnetStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullTailnetStatus) Scan(value interface{}) error {
	if value == nil {
		ns.TailnetStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.TailnetStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullTailnetStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.TailnetStatus), nil
}

func (e TailnetStatus) Valid() bool {
	switch e {
	case TailnetStatusOk,
		TailnetStatusLost:
		return true
	}
	return false
}

func AllTailnetStatusValues() []TailnetStatus {
	return []TailnetStatus{
		TailnetStatusOk,
		TailnetStatusLost,
	}
}

type TaskStatus string

const (
	TaskStatusPending      TaskStatus = "pending"
	TaskStatusInitializing TaskStatus = "initializing"
	TaskStatusActive       TaskStatus = "active"
	TaskStatusPaused       TaskStatus = "paused"
	TaskStatusUnknown      TaskStatus = "unknown"
	TaskStatusError        TaskStatus = "error"
)

func (e *TaskStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = TaskStatus(s)
	case string:
		*e = TaskStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for TaskStatus: %T", src)
	}
	return nil
}

type NullTaskStatus struct {
	TaskStatus TaskStatus `json:"task_status"`
	Valid      bool       `json:"valid"` // Valid is true if TaskStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullTaskStatus) Scan(value interface{}) error {
	if value == nil {
		ns.TaskStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.TaskStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullTaskStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.TaskStatus), nil
}

func (e TaskStatus) Valid() bool {
	switch e {
	case TaskStatusPending,
		TaskStatusInitializing,
		TaskStatusActive,
		TaskStatusPaused,
		TaskStatusUnknown,
		TaskStatusError:
		return true
	}
	return false
}

func AllTaskStatusValues() []TaskStatus {
	return []TaskStatus{
		TaskStatusPending,
		TaskStatusInitializing,
		TaskStatusActive,
		TaskStatusPaused,
		TaskStatusUnknown,
		TaskStatusError,
	}
}

// Defines the users status: active, dormant, or suspended.
type UserStatus string

const (
	UserStatusActive    UserStatus = "active"
	UserStatusSuspended UserStatus = "suspended"
	UserStatusDormant   UserStatus = "dormant"
)

func (e *UserStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = UserStatus(s)
	case string:
		*e = UserStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for UserStatus: %T", src)
	}
	return nil
}

type NullUserStatus struct {
	UserStatus UserStatus `json:"user_status"`
	Valid      bool       `json:"valid"` // Valid is true if UserStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullUserStatus) Scan(value interface{}) error {
	if value == nil {
		ns.UserStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.UserStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullUserStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.UserStatus), nil
}

func (e UserStatus) Valid() bool {
	switch e {
	case UserStatusActive,
		UserStatusSuspended,
		UserStatusDormant:
		return true
	}
	return false
}

func AllUserStatusValues() []UserStatus {
	return []UserStatus{
		UserStatusActive,
		UserStatusSuspended,
		UserStatusDormant,
	}
}

type WorkspaceAgentLifecycleState string

const (
	WorkspaceAgentLifecycleStateCreated         WorkspaceAgentLifecycleState = "created"
	WorkspaceAgentLifecycleStateStarting        WorkspaceAgentLifecycleState = "starting"
	WorkspaceAgentLifecycleStateStartTimeout    WorkspaceAgentLifecycleState = "start_timeout"
	WorkspaceAgentLifecycleStateStartError      WorkspaceAgentLifecycleState = "start_error"
	WorkspaceAgentLifecycleStateReady           WorkspaceAgentLifecycleState = "ready"
	WorkspaceAgentLifecycleStateShuttingDown    WorkspaceAgentLifecycleState = "shutting_down"
	WorkspaceAgentLifecycleStateShutdownTimeout WorkspaceAgentLifecycleState = "shutdown_timeout"
	WorkspaceAgentLifecycleStateShutdownError   WorkspaceAgentLifecycleState = "shutdown_error"
	WorkspaceAgentLifecycleStateOff             WorkspaceAgentLifecycleState = "off"
)

func (e *WorkspaceAgentLifecycleState) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceAgentLifecycleState(s)
	case string:
		*e = WorkspaceAgentLifecycleState(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceAgentLifecycleState: %T", src)
	}
	return nil
}

type NullWorkspaceAgentLifecycleState struct {
	WorkspaceAgentLifecycleState WorkspaceAgentLifecycleState `json:"workspace_agent_lifecycle_state"`
	Valid                        bool                         `json:"valid"` // Valid is true if WorkspaceAgentLifecycleState is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceAgentLifecycleState) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceAgentLifecycleState, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceAgentLifecycleState.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceAgentLifecycleState) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceAgentLifecycleState), nil
}

func (e WorkspaceAgentLifecycleState) Valid() bool {
	switch e {
	case WorkspaceAgentLifecycleStateCreated,
		WorkspaceAgentLifecycleStateStarting,
		WorkspaceAgentLifecycleStateStartTimeout,
		WorkspaceAgentLifecycleStateStartError,
		WorkspaceAgentLifecycleStateReady,
		WorkspaceAgentLifecycleStateShuttingDown,
		WorkspaceAgentLifecycleStateShutdownTimeout,
		WorkspaceAgentLifecycleStateShutdownError,
		WorkspaceAgentLifecycleStateOff:
		return true
	}
	return false
}

func AllWorkspaceAgentLifecycleStateValues() []WorkspaceAgentLifecycleState {
	return []WorkspaceAgentLifecycleState{
		WorkspaceAgentLifecycleStateCreated,
		WorkspaceAgentLifecycleStateStarting,
		WorkspaceAgentLifecycleStateStartTimeout,
		WorkspaceAgentLifecycleStateStartError,
		WorkspaceAgentLifecycleStateReady,
		WorkspaceAgentLifecycleStateShuttingDown,
		WorkspaceAgentLifecycleStateShutdownTimeout,
		WorkspaceAgentLifecycleStateShutdownError,
		WorkspaceAgentLifecycleStateOff,
	}
}

type WorkspaceAgentMonitorState string

const (
	WorkspaceAgentMonitorStateOK  WorkspaceAgentMonitorState = "OK"
	WorkspaceAgentMonitorStateNOK WorkspaceAgentMonitorState = "NOK"
)

func (e *WorkspaceAgentMonitorState) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceAgentMonitorState(s)
	case string:
		*e = WorkspaceAgentMonitorState(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceAgentMonitorState: %T", src)
	}
	return nil
}

type NullWorkspaceAgentMonitorState struct {
	WorkspaceAgentMonitorState WorkspaceAgentMonitorState `json:"workspace_agent_monitor_state"`
	Valid                      bool                       `json:"valid"` // Valid is true if WorkspaceAgentMonitorState is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceAgentMonitorState) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceAgentMonitorState, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceAgentMonitorState.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceAgentMonitorState) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceAgentMonitorState), nil
}

func (e WorkspaceAgentMonitorState) Valid() bool {
	switch e {
	case WorkspaceAgentMonitorStateOK,
		WorkspaceAgentMonitorStateNOK:
		return true
	}
	return false
}

func AllWorkspaceAgentMonitorStateValues() []WorkspaceAgentMonitorState {
	return []WorkspaceAgentMonitorState{
		WorkspaceAgentMonitorStateOK,
		WorkspaceAgentMonitorStateNOK,
	}
}

// What stage the script was ran in.
type WorkspaceAgentScriptTimingStage string

const (
	WorkspaceAgentScriptTimingStageStart WorkspaceAgentScriptTimingStage = "start"
	WorkspaceAgentScriptTimingStageStop  WorkspaceAgentScriptTimingStage = "stop"
	WorkspaceAgentScriptTimingStageCron  WorkspaceAgentScriptTimingStage = "cron"
)

func (e *WorkspaceAgentScriptTimingStage) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceAgentScriptTimingStage(s)
	case string:
		*e = WorkspaceAgentScriptTimingStage(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceAgentScriptTimingStage: %T", src)
	}
	return nil
}

type NullWorkspaceAgentScriptTimingStage struct {
	WorkspaceAgentScriptTimingStage WorkspaceAgentScriptTimingStage `json:"workspace_agent_script_timing_stage"`
	Valid                           bool                            `json:"valid"` // Valid is true if WorkspaceAgentScriptTimingStage is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceAgentScriptTimingStage) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceAgentScriptTimingStage, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceAgentScriptTimingStage.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceAgentScriptTimingStage) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceAgentScriptTimingStage), nil
}

func (e WorkspaceAgentScriptTimingStage) Valid() bool {
	switch e {
	case WorkspaceAgentScriptTimingStageStart,
		WorkspaceAgentScriptTimingStageStop,
		WorkspaceAgentScriptTimingStageCron:
		return true
	}
	return false
}

func AllWorkspaceAgentScriptTimingStageValues() []WorkspaceAgentScriptTimingStage {
	return []WorkspaceAgentScriptTimingStage{
		WorkspaceAgentScriptTimingStageStart,
		WorkspaceAgentScriptTimingStageStop,
		WorkspaceAgentScriptTimingStageCron,
	}
}

// What the exit status of the script is.
type WorkspaceAgentScriptTimingStatus string

const (
	WorkspaceAgentScriptTimingStatusOk            WorkspaceAgentScriptTimingStatus = "ok"
	WorkspaceAgentScriptTimingStatusExitFailure   WorkspaceAgentScriptTimingStatus = "exit_failure"
	WorkspaceAgentScriptTimingStatusTimedOut      WorkspaceAgentScriptTimingStatus = "timed_out"
	WorkspaceAgentScriptTimingStatusPipesLeftOpen WorkspaceAgentScriptTimingStatus = "pipes_left_open"
)

func (e *WorkspaceAgentScriptTimingStatus) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceAgentScriptTimingStatus(s)
	case string:
		*e = WorkspaceAgentScriptTimingStatus(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceAgentScriptTimingStatus: %T", src)
	}
	return nil
}

type NullWorkspaceAgentScriptTimingStatus struct {
	WorkspaceAgentScriptTimingStatus WorkspaceAgentScriptTimingStatus `json:"workspace_agent_script_timing_status"`
	Valid                            bool                             `json:"valid"` // Valid is true if WorkspaceAgentScriptTimingStatus is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceAgentScriptTimingStatus) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceAgentScriptTimingStatus, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceAgentScriptTimingStatus.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceAgentScriptTimingStatus) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceAgentScriptTimingStatus), nil
}

func (e WorkspaceAgentScriptTimingStatus) Valid() bool {
	switch e {
	case WorkspaceAgentScriptTimingStatusOk,
		WorkspaceAgentScriptTimingStatusExitFailure,
		WorkspaceAgentScriptTimingStatusTimedOut,
		WorkspaceAgentScriptTimingStatusPipesLeftOpen:
		return true
	}
	return false
}

func AllWorkspaceAgentScriptTimingStatusValues() []WorkspaceAgentScriptTimingStatus {
	return []WorkspaceAgentScriptTimingStatus{
		WorkspaceAgentScriptTimingStatusOk,
		WorkspaceAgentScriptTimingStatusExitFailure,
		WorkspaceAgentScriptTimingStatusTimedOut,
		WorkspaceAgentScriptTimingStatusPipesLeftOpen,
	}
}

type WorkspaceAgentSubsystem string

const (
	WorkspaceAgentSubsystemEnvbuilder WorkspaceAgentSubsystem = "envbuilder"
	WorkspaceAgentSubsystemEnvbox     WorkspaceAgentSubsystem = "envbox"
	WorkspaceAgentSubsystemNone       WorkspaceAgentSubsystem = "none"
	WorkspaceAgentSubsystemExectrace  WorkspaceAgentSubsystem = "exectrace"
)

func (e *WorkspaceAgentSubsystem) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceAgentSubsystem(s)
	case string:
		*e = WorkspaceAgentSubsystem(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceAgentSubsystem: %T", src)
	}
	return nil
}

type NullWorkspaceAgentSubsystem struct {
	WorkspaceAgentSubsystem WorkspaceAgentSubsystem `json:"workspace_agent_subsystem"`
	Valid                   bool                    `json:"valid"` // Valid is true if WorkspaceAgentSubsystem is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceAgentSubsystem) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceAgentSubsystem, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceAgentSubsystem.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceAgentSubsystem) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceAgentSubsystem), nil
}

func (e WorkspaceAgentSubsystem) Valid() bool {
	switch e {
	case WorkspaceAgentSubsystemEnvbuilder,
		WorkspaceAgentSubsystemEnvbox,
		WorkspaceAgentSubsystemNone,
		WorkspaceAgentSubsystemExectrace:
		return true
	}
	return false
}

func AllWorkspaceAgentSubsystemValues() []WorkspaceAgentSubsystem {
	return []WorkspaceAgentSubsystem{
		WorkspaceAgentSubsystemEnvbuilder,
		WorkspaceAgentSubsystemEnvbox,
		WorkspaceAgentSubsystemNone,
		WorkspaceAgentSubsystemExectrace,
	}
}

type WorkspaceAppHealth string

const (
	WorkspaceAppHealthDisabled     WorkspaceAppHealth = "disabled"
	WorkspaceAppHealthInitializing WorkspaceAppHealth = "initializing"
	WorkspaceAppHealthHealthy      WorkspaceAppHealth = "healthy"
	WorkspaceAppHealthUnhealthy    WorkspaceAppHealth = "unhealthy"
)

func (e *WorkspaceAppHealth) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceAppHealth(s)
	case string:
		*e = WorkspaceAppHealth(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceAppHealth: %T", src)
	}
	return nil
}

type NullWorkspaceAppHealth struct {
	WorkspaceAppHealth WorkspaceAppHealth `json:"workspace_app_health"`
	Valid              bool               `json:"valid"` // Valid is true if WorkspaceAppHealth is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceAppHealth) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceAppHealth, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceAppHealth.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceAppHealth) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceAppHealth), nil
}

func (e WorkspaceAppHealth) Valid() bool {
	switch e {
	case WorkspaceAppHealthDisabled,
		WorkspaceAppHealthInitializing,
		WorkspaceAppHealthHealthy,
		WorkspaceAppHealthUnhealthy:
		return true
	}
	return false
}

func AllWorkspaceAppHealthValues() []WorkspaceAppHealth {
	return []WorkspaceAppHealth{
		WorkspaceAppHealthDisabled,
		WorkspaceAppHealthInitializing,
		WorkspaceAppHealthHealthy,
		WorkspaceAppHealthUnhealthy,
	}
}

type WorkspaceAppOpenIn string

const (
	WorkspaceAppOpenInTab        WorkspaceAppOpenIn = "tab"
	WorkspaceAppOpenInWindow     WorkspaceAppOpenIn = "window"
	WorkspaceAppOpenInSlimWindow WorkspaceAppOpenIn = "slim-window"
)

func (e *WorkspaceAppOpenIn) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceAppOpenIn(s)
	case string:
		*e = WorkspaceAppOpenIn(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceAppOpenIn: %T", src)
	}
	return nil
}

type NullWorkspaceAppOpenIn struct {
	WorkspaceAppOpenIn WorkspaceAppOpenIn `json:"workspace_app_open_in"`
	Valid              bool               `json:"valid"` // Valid is true if WorkspaceAppOpenIn is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceAppOpenIn) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceAppOpenIn, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceAppOpenIn.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceAppOpenIn) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceAppOpenIn), nil
}

func (e WorkspaceAppOpenIn) Valid() bool {
	switch e {
	case WorkspaceAppOpenInTab,
		WorkspaceAppOpenInWindow,
		WorkspaceAppOpenInSlimWindow:
		return true
	}
	return false
}

func AllWorkspaceAppOpenInValues() []WorkspaceAppOpenIn {
	return []WorkspaceAppOpenIn{
		WorkspaceAppOpenInTab,
		WorkspaceAppOpenInWindow,
		WorkspaceAppOpenInSlimWindow,
	}
}

type WorkspaceAppStatusState string

const (
	WorkspaceAppStatusStateWorking  WorkspaceAppStatusState = "working"
	WorkspaceAppStatusStateComplete WorkspaceAppStatusState = "complete"
	WorkspaceAppStatusStateFailure  WorkspaceAppStatusState = "failure"
	WorkspaceAppStatusStateIdle     WorkspaceAppStatusState = "idle"
)

func (e *WorkspaceAppStatusState) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceAppStatusState(s)
	case string:
		*e = WorkspaceAppStatusState(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceAppStatusState: %T", src)
	}
	return nil
}

type NullWorkspaceAppStatusState struct {
	WorkspaceAppStatusState WorkspaceAppStatusState `json:"workspace_app_status_state"`
	Valid                   bool                    `json:"valid"` // Valid is true if WorkspaceAppStatusState is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceAppStatusState) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceAppStatusState, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceAppStatusState.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceAppStatusState) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceAppStatusState), nil
}

func (e WorkspaceAppStatusState) Valid() bool {
	switch e {
	case WorkspaceAppStatusStateWorking,
		WorkspaceAppStatusStateComplete,
		WorkspaceAppStatusStateFailure,
		WorkspaceAppStatusStateIdle:
		return true
	}
	return false
}

func AllWorkspaceAppStatusStateValues() []WorkspaceAppStatusState {
	return []WorkspaceAppStatusState{
		WorkspaceAppStatusStateWorking,
		WorkspaceAppStatusStateComplete,
		WorkspaceAppStatusStateFailure,
		WorkspaceAppStatusStateIdle,
	}
}

type WorkspaceTransition string

const (
	WorkspaceTransitionStart  WorkspaceTransition = "start"
	WorkspaceTransitionStop   WorkspaceTransition = "stop"
	WorkspaceTransitionDelete WorkspaceTransition = "delete"
)

func (e *WorkspaceTransition) Scan(src interface{}) error {
	switch s := src.(type) {
	case []byte:
		*e = WorkspaceTransition(s)
	case string:
		*e = WorkspaceTransition(s)
	default:
		return fmt.Errorf("unsupported scan type for WorkspaceTransition: %T", src)
	}
	return nil
}

type NullWorkspaceTransition struct {
	WorkspaceTransition WorkspaceTransition `json:"workspace_transition"`
	Valid               bool                `json:"valid"` // Valid is true if WorkspaceTransition is not NULL
}

// Scan implements the Scanner interface.
func (ns *NullWorkspaceTransition) Scan(value interface{}) error {
	if value == nil {
		ns.WorkspaceTransition, ns.Valid = "", false
		return nil
	}
	ns.Valid = true
	return ns.WorkspaceTransition.Scan(value)
}

// Value implements the driver Valuer interface.
func (ns NullWorkspaceTransition) Value() (driver.Value, error) {
	if !ns.Valid {
		return nil, nil
	}
	return string(ns.WorkspaceTransition), nil
}

func (e WorkspaceTransition) Valid() bool {
	switch e {
	case WorkspaceTransitionStart,
		WorkspaceTransitionStop,
		WorkspaceTransitionDelete:
		return true
	}
	return false
}

func AllWorkspaceTransitionValues() []WorkspaceTransition {
	return []WorkspaceTransition{
		WorkspaceTransitionStart,
		WorkspaceTransitionStop,
		WorkspaceTransitionDelete,
	}
}

// Audit log of requests intercepted by AI Bridge
type AIBridgeInterception struct {
	ID uuid.UUID `db:"id" json:"id"`
	// Relates to a users record, but FK is elided for performance.
	InitiatorID uuid.UUID             `db:"initiator_id" json:"initiator_id"`
	Provider    string                `db:"provider" json:"provider"`
	Model       string                `db:"model" json:"model"`
	StartedAt   time.Time             `db:"started_at" json:"started_at"`
	Metadata    pqtype.NullRawMessage `db:"metadata" json:"metadata"`
	EndedAt     sql.NullTime          `db:"ended_at" json:"ended_at"`
	APIKeyID    sql.NullString        `db:"api_key_id" json:"api_key_id"`
}

// Audit log of tokens used by intercepted requests in AI Bridge
type AIBridgeTokenUsage struct {
	ID             uuid.UUID `db:"id" json:"id"`
	InterceptionID uuid.UUID `db:"interception_id" json:"interception_id"`
	// The ID for the response in which the tokens were used, produced by the provider.
	ProviderResponseID string                `db:"provider_response_id" json:"provider_response_id"`
	InputTokens        int64                 `db:"input_tokens" json:"input_tokens"`
	OutputTokens       int64                 `db:"output_tokens" json:"output_tokens"`
	Metadata           pqtype.NullRawMessage `db:"metadata" json:"metadata"`
	CreatedAt          time.Time             `db:"created_at" json:"created_at"`
}

// Audit log of tool calls in intercepted requests in AI Bridge
type AIBridgeToolUsage struct {
	ID             uuid.UUID `db:"id" json:"id"`
	InterceptionID uuid.UUID `db:"interception_id" json:"interception_id"`
	// The ID for the response in which the tools were used, produced by the provider.
	ProviderResponseID string `db:"provider_response_id" json:"provider_response_id"`
	// The name of the MCP server against which this tool was invoked. May be NULL, in which case the tool was defined by the client, not injected.
	ServerUrl sql.NullString `db:"server_url" json:"server_url"`
	Tool      string         `db:"tool" json:"tool"`
	Input     string         `db:"input" json:"input"`
	// Whether this tool was injected; i.e. Bridge injected these tools into the request from an MCP server. If false it means a tool was defined by the client and already existed in the request (MCP or built-in).
	Injected bool `db:"injected" json:"injected"`
	// Only injected tools are invoked.
	InvocationError sql.NullString        `db:"invocation_error" json:"invocation_error"`
	Metadata        pqtype.NullRawMessage `db:"metadata" json:"metadata"`
	CreatedAt       time.Time             `db:"created_at" json:"created_at"`
}

// Audit log of prompts used by intercepted requests in AI Bridge
type AIBridgeUserPrompt struct {
	ID             uuid.UUID `db:"id" json:"id"`
	InterceptionID uuid.UUID `db:"interception_id" json:"interception_id"`
	// The ID for the response to the given prompt, produced by the provider.
	ProviderResponseID string                `db:"provider_response_id" json:"provider_response_id"`
	Prompt             string                `db:"prompt" json:"prompt"`
	Metadata           pqtype.NullRawMessage `db:"metadata" json:"metadata"`
	CreatedAt          time.Time             `db:"created_at" json:"created_at"`
}

type APIKey struct {
	ID string `db:"id" json:"id"`
	// hashed_secret contains a SHA256 hash of the key secret. This is considered a secret and MUST NOT be returned from the API as it is used for API key encryption in app proxying code.
	HashedSecret    []byte       `db:"hashed_secret" json:"hashed_secret"`
	UserID          uuid.UUID    `db:"user_id" json:"user_id"`
	LastUsed        time.Time    `db:"last_used" json:"last_used"`
	ExpiresAt       time.Time    `db:"expires_at" json:"expires_at"`
	CreatedAt       time.Time    `db:"created_at" json:"created_at"`
	UpdatedAt       time.Time    `db:"updated_at" json:"updated_at"`
	LoginType       LoginType    `db:"login_type" json:"login_type"`
	LifetimeSeconds int64        `db:"lifetime_seconds" json:"lifetime_seconds"`
	IPAddress       pqtype.Inet  `db:"ip_address" json:"ip_address"`
	TokenName       string       `db:"token_name" json:"token_name"`
	Scopes          APIKeyScopes `db:"scopes" json:"scopes"`
	AllowList       AllowList    `db:"allow_list" json:"allow_list"`
}

type AuditLog struct {
	ID               uuid.UUID       `db:"id" json:"id"`
	Time             time.Time       `db:"time" json:"time"`
	UserID           uuid.UUID       `db:"user_id" json:"user_id"`
	OrganizationID   uuid.UUID       `db:"organization_id" json:"organization_id"`
	Ip               pqtype.Inet     `db:"ip" json:"ip"`
	UserAgent        sql.NullString  `db:"user_agent" json:"user_agent"`
	ResourceType     ResourceType    `db:"resource_type" json:"resource_type"`
	ResourceID       uuid.UUID       `db:"resource_id" json:"resource_id"`
	ResourceTarget   string          `db:"resource_target" json:"resource_target"`
	Action           AuditAction     `db:"action" json:"action"`
	Diff             json.RawMessage `db:"diff" json:"diff"`
	StatusCode       int32           `db:"status_code" json:"status_code"`
	AdditionalFields json.RawMessage `db:"additional_fields" json:"additional_fields"`
	RequestID        uuid.UUID       `db:"request_id" json:"request_id"`
	ResourceIcon     string          `db:"resource_icon" json:"resource_icon"`
}

// Per-replica boundary usage statistics for telemetry aggregation.
type BoundaryUsageStat struct {
	// The unique identifier of the replica reporting stats.
	ReplicaID uuid.UUID `db:"replica_id" json:"replica_id"`
	// Count of unique workspaces that used boundary on this replica.
	UniqueWorkspacesCount int64 `db:"unique_workspaces_count" json:"unique_workspaces_count"`
	// Count of unique users that used boundary on this replica.
	UniqueUsersCount int64 `db:"unique_users_count" json:"unique_users_count"`
	// Total allowed requests through boundary on this replica.
	AllowedRequests int64 `db:"allowed_requests" json:"allowed_requests"`
	// Total denied requests through boundary on this replica.
	DeniedRequests int64 `db:"denied_requests" json:"denied_requests"`
	// Start of the time window for these stats, set on first flush after reset.
	WindowStart time.Time `db:"window_start" json:"window_start"`
	// Timestamp of the last update to this row.
	UpdatedAt time.Time `db:"updated_at" json:"updated_at"`
}

type ConnectionLog struct {
	ID               uuid.UUID      `db:"id" json:"id"`
	ConnectTime      time.Time      `db:"connect_time" json:"connect_time"`
	OrganizationID   uuid.UUID      `db:"organization_id" json:"organization_id"`
	WorkspaceOwnerID uuid.UUID      `db:"workspace_owner_id" json:"workspace_owner_id"`
	WorkspaceID      uuid.UUID      `db:"workspace_id" json:"workspace_id"`
	WorkspaceName    string         `db:"workspace_name" json:"workspace_name"`
	AgentName        string         `db:"agent_name" json:"agent_name"`
	Type             ConnectionType `db:"type" json:"type"`
	Ip               pqtype.Inet    `db:"ip" json:"ip"`
	// Either the HTTP status code of the web request, or the exit code of an SSH connection. For non-web connections, this is Null until we receive a disconnect event for the same connection_id.
	Code sql.NullInt32 `db:"code" json:"code"`
	// Null for SSH events. For web connections, this is the User-Agent header from the request.
	UserAgent sql.NullString `db:"user_agent" json:"user_agent"`
	// Null for SSH events. For web connections, this is the ID of the user that made the request.
	UserID uuid.NullUUID `db:"user_id" json:"user_id"`
	// Null for SSH events. For web connections, this is the slug of the app or the port number being forwarded.
	SlugOrPort sql.NullString `db:"slug_or_port" json:"slug_or_port"`
	// The SSH connection ID. Used to correlate connections and disconnections. As it originates from the agent, it is not guaranteed to be unique.
	ConnectionID uuid.NullUUID `db:"connection_id" json:"connection_id"`
	// The time the connection was closed. Null for web connections. For other connections, this is null until we receive a disconnect event for the same connection_id.
	DisconnectTime sql.NullTime `db:"disconnect_time" json:"disconnect_time"`
	// The reason the connection was closed. Null for web connections. For other connections, this is null until we receive a disconnect event for the same connection_id.
	DisconnectReason sql.NullString `db:"disconnect_reason" json:"disconnect_reason"`
}

type CryptoKey struct {
	Feature     CryptoKeyFeature `db:"feature" json:"feature"`
	Sequence    int32            `db:"sequence" json:"sequence"`
	Secret      sql.NullString   `db:"secret" json:"secret"`
	SecretKeyID sql.NullString   `db:"secret_key_id" json:"secret_key_id"`
	StartsAt    time.Time        `db:"starts_at" json:"starts_at"`
	DeletesAt   sql.NullTime     `db:"deletes_at" json:"deletes_at"`
}

// Custom roles allow dynamic roles expanded at runtime
type CustomRole struct {
	Name            string                `db:"name" json:"name"`
	DisplayName     string                `db:"display_name" json:"display_name"`
	SitePermissions CustomRolePermissions `db:"site_permissions" json:"site_permissions"`
	OrgPermissions  CustomRolePermissions `db:"org_permissions" json:"org_permissions"`
	UserPermissions CustomRolePermissions `db:"user_permissions" json:"user_permissions"`
	CreatedAt       time.Time             `db:"created_at" json:"created_at"`
	UpdatedAt       time.Time             `db:"updated_at" json:"updated_at"`
	// Roles can optionally be scoped to an organization
	OrganizationID uuid.NullUUID `db:"organization_id" json:"organization_id"`
	// Custom roles ID is used purely for auditing purposes. Name is a better unique identifier.
	ID uuid.UUID `db:"id" json:"id"`
	// System roles are managed by Coder and cannot be modified or deleted by users.
	IsSystem          bool                  `db:"is_system" json:"is_system"`
	MemberPermissions CustomRolePermissions `db:"member_permissions" json:"member_permissions"`
}

// A table used to store the keys used to encrypt the database.
type DBCryptKey struct {
	// An integer used to identify the key.
	Number int32 `db:"number" json:"number"`
	// If the key is active, the digest of the active key.
	ActiveKeyDigest sql.NullString `db:"active_key_digest" json:"active_key_digest"`
	// If the key has been revoked, the digest of the revoked key.
	RevokedKeyDigest sql.NullString `db:"revoked_key_digest" json:"revoked_key_digest"`
	// The time at which the key was created.
	CreatedAt sql.NullTime `db:"created_at" json:"created_at"`
	// The time at which the key was revoked.
	RevokedAt sql.NullTime `db:"revoked_at" json:"revoked_at"`
	// A column used to test the encryption.
	Test string `db:"test" json:"test"`
}

type ExternalAuthLink struct {
	ProviderID        string    `db:"provider_id" json:"provider_id"`
	UserID            uuid.UUID `db:"user_id" json:"user_id"`
	CreatedAt         time.Time `db:"created_at" json:"created_at"`
	UpdatedAt         time.Time `db:"updated_at" json:"updated_at"`
	OAuthAccessToken  string    `db:"oauth_access_token" json:"oauth_access_token"`
	OAuthRefreshToken string    `db:"oauth_refresh_token" json:"oauth_refresh_token"`
	OAuthExpiry       time.Time `db:"oauth_expiry" json:"oauth_expiry"`
	// The ID of the key used to encrypt the OAuth access token. If this is NULL, the access token is not encrypted
	OAuthAccessTokenKeyID sql.NullString `db:"oauth_access_token_key_id" json:"oauth_access_token_key_id"`
	// The ID of the key used to encrypt the OAuth refresh token. If this is NULL, the refresh token is not encrypted
	OAuthRefreshTokenKeyID sql.NullString        `db:"oauth_refresh_token_key_id" json:"oauth_refresh_token_key_id"`
	OAuthExtra             pqtype.NullRawMessage `db:"oauth_extra" json:"oauth_extra"`
	// This error means the refresh token is invalid. Cached so we can avoid calling the external provider again for the same error.
	OauthRefreshFailureReason string `db:"oauth_refresh_failure_reason" json:"oauth_refresh_failure_reason"`
}

type File struct {
	Hash      string    `db:"hash" json:"hash"`
	CreatedAt time.Time `db:"created_at" json:"created_at"`
	CreatedBy uuid.UUID `db:"created_by" json:"created_by"`
	Mimetype  string    `db:"mimetype" json:"mimetype"`
	Data      []byte    `db:"data" json:"data"`
	ID        uuid.UUID `db:"id" json:"id"`
}

type GitSSHKey struct {
	UserID     uuid.UUID `db:"user_id" json:"user_id"`
	CreatedAt  time.Time `db:"created_at" json:"created_at"`
	UpdatedAt  time.Time `db:"updated_at" json:"updated_at"`
	PrivateKey string    `db:"private_key" json:"private_key"`
	PublicKey  string    `db:"public_key" json:"public_key"`
}

type Group struct {
	ID             uuid.UUID `db:"id" json:"id"`
	Name           string    `db:"name" json:"name"`
	OrganizationID uuid.UUID `db:"organization_id" json:"organization_id"`
	AvatarURL      string    `db:"avatar_url" json:"avatar_url"`
	QuotaAllowance int32     `db:"quota_allowance" json:"quota_allowance"`
	// Display name is a custom, human-friendly group name that user can set. This is not required to be unique and can be the empty string.
	DisplayName string `db:"display_name" json:"display_name"`
	// Source indicates how the group was created. It can be created by a user manually, or through some system process like OIDC group sync.
	Source GroupSource `db:"source" json:"source"`
}

// Joins group members with user information, organization ID, group name. Includes both regular group members and organization members (as part of the "Everyone" group).
type GroupMember struct {
	UserID                 uuid.UUID     `db:"user_id" json:"user_id"`
	UserEmail              string        `db:"user_email" json:"user_email"`
	UserUsername           string        `db:"user_username" json:"user_username"`
	UserHashedPassword     []byte        `db:"user_hashed_password" json:"user_hashed_password"`
	UserCreatedAt          time.Time     `db:"user_created_at" json:"user_created_at"`
	UserUpdatedAt          time.Time     `db:"user_updated_at" json:"user_updated_at"`
	UserStatus             UserStatus    `db:"user_status" json:"user_status"`
	UserRbacRoles          []string      `db:"user_rbac_roles" json:"user_rbac_roles"`
	UserLoginType          LoginType     `db:"user_login_type" json:"user_login_type"`
	UserAvatarUrl          string        `db:"user_avatar_url" json:"user_avatar_url"`
	UserDeleted            bool          `db:"user_deleted" json:"user_deleted"`
	UserLastSeenAt         time.Time     `db:"user_last_seen_at" json:"user_last_seen_at"`
	UserQuietHoursSchedule string        `db:"user_quiet_hours_schedule" json:"user_quiet_hours_schedule"`
	UserName               string        `db:"user_name" json:"user_name"`
	UserGithubComUserID    sql.NullInt64 `db:"user_github_com_user_id" json:"user_github_com_user_id"`
	UserIsSystem           bool          `db:"user_is_system" json:"user_is_system"`
	OrganizationID         uuid.UUID     `db:"organization_id" json:"organization_id"`
	GroupName              string        `db:"group_name" json:"group_name"`
	GroupID                uuid.UUID     `db:"group_id" json:"group_id"`
}

type GroupMemberTable struct {
	UserID  uuid.UUID `db:"user_id" json:"user_id"`
	GroupID uuid.UUID `db:"group_id" json:"group_id"`
}

type InboxNotification struct {
	ID         uuid.UUID       `db:"id" json:"id"`
	UserID     uuid.UUID       `db:"user_id" json:"user_id"`
	TemplateID uuid.UUID       `db:"template_id" json:"template_id"`
	Targets    []uuid.UUID     `db:"targets" json:"targets"`
	Title      string          `db:"title" json:"title"`
	Content    string          `db:"content" json:"content"`
	Icon       string          `db:"icon" json:"icon"`
	Actions    json.RawMessage `db:"actions" json:"actions"`
	ReadAt     sql.NullTime    `db:"read_at" json:"read_at"`
	CreatedAt  time.Time       `db:"created_at" json:"created_at"`
}

type JfrogXrayScan struct {
	AgentID     uuid.UUID `db:"agent_id" json:"agent_id"`
	WorkspaceID uuid.UUID `db:"workspace_id" json:"workspace_id"`
	Critical    int32     `db:"critical" json:"critical"`
	High        int32     `db:"high" json:"high"`
	Medium      int32     `db:"medium" json:"medium"`
	ResultsUrl  string    `db:"results_url" json:"results_url"`
}

type License struct {
	ID         int32     `db:"id" json:"id"`
	UploadedAt time.Time `db:"uploaded_at" json:"uploaded_at"`
	JWT        string    `db:"jwt" json:"jwt"`
	// exp tracks the claim of the same name in the JWT, and we include it here so that we can easily query for licenses that have not yet expired.
	Exp  time.Time `db:"exp" json:"exp"`
	UUID uuid.UUID `db:"uuid" json:"uuid"`
}

type NotificationMessage struct {
	ID                     uuid.UUID                 `db:"id" json:"id"`
	NotificationTemplateID uuid.UUID                 `db:"notification_template_id" json:"notification_template_id"`
	UserID                 uuid.UUID                 `db:"user_id" json:"user_id"`
	Method                 NotificationMethod        `db:"method" json:"method"`
	Status                 NotificationMessageStatus `db:"status" json:"status"`
	StatusReason           sql.NullString            `db:"status_reason" json:"status_reason"`
	CreatedBy              string                    `db:"created_by" json:"created_by"`
	Payload                []byte                    `db:"payload" json:"payload"`
	AttemptCount           sql.NullInt32             `db:"attempt_count" json:"attempt_count"`
	Targets                []uuid.UUID               `db:"targets" json:"targets"`
	CreatedAt              time.Time                 `db:"created_at" json:"created_at"`
	UpdatedAt              sql.NullTime              `db:"updated_at" json:"updated_at"`
	LeasedUntil            sql.NullTime              `db:"leased_until" json:"leased_until"`
	NextRetryAfter         sql.NullTime              `db:"next_retry_after" json:"next_retry_after"`
	QueuedSeconds          sql.NullFloat64           `db:"queued_seconds" json:"queued_seconds"`
	// Auto-generated by insert/update trigger, used to prevent duplicate notifications from being enqueued on the same day
	DedupeHash sql.NullString `db:"dedupe_hash" json:"dedupe_hash"`
}

type NotificationPreference struct {
	UserID                 uuid.UUID `db:"user_id" json:"user_id"`
	NotificationTemplateID uuid.UUID `db:"notification_template_id" json:"notification_template_id"`
	Disabled               bool      `db:"disabled" json:"disabled"`
	CreatedAt              time.Time `db:"created_at" json:"created_at"`
	UpdatedAt              time.Time `db:"updated_at" json:"updated_at"`
}

// Log of generated reports for users.
type NotificationReportGeneratorLog struct {
	NotificationTemplateID uuid.UUID `db:"notification_template_id" json:"notification_template_id"`
	LastGeneratedAt        time.Time `db:"last_generated_at" json:"last_generated_at"`
}

// Templates from which to create notification messages.
type NotificationTemplate struct {
	ID            uuid.UUID      `db:"id" json:"id"`
	Name          string         `db:"name" json:"name"`
	TitleTemplate string         `db:"title_template" json:"title_template"`
	BodyTemplate  string         `db:"body_template" json:"body_template"`
	Actions       []byte         `db:"actions" json:"actions"`
	Group         sql.NullString `db:"group" json:"group"`
	// NULL defers to the deployment-level method
	Method           NullNotificationMethod   `db:"method" json:"method"`
	Kind             NotificationTemplateKind `db:"kind" json:"kind"`
	EnabledByDefault bool                     `db:"enabled_by_default" json:"enabled_by_default"`
}

// A table used to configure apps that can use Coder as an OAuth2 provider, the reverse of what we are calling external authentication.
type OAuth2ProviderApp struct {
	ID          uuid.UUID `db:"id" json:"id"`
	CreatedAt   time.Time `db:"created_at" json:"created_at"`
	UpdatedAt   time.Time `db:"updated_at" json:"updated_at"`
	Name        string    `db:"name" json:"name"`
	Icon        string    `db:"icon" json:"icon"`
	CallbackURL string    `db:"callback_url" json:"callback_url"`
	// List of valid redirect URIs for the application
	RedirectUris []string `db:"redirect_uris" json:"redirect_uris"`
	// OAuth2 client type: confidential or public
	ClientType sql.NullString `db:"client_type" json:"client_type"`
	// Whether this app was created via dynamic client registration
	DynamicallyRegistered sql.NullBool `db:"dynamically_registered" json:"dynamically_registered"`
	// RFC 7591: Timestamp when client_id was issued
	ClientIDIssuedAt sql.NullTime `db:"client_id_issued_at" json:"client_id_issued_at"`
	// RFC 7591: Timestamp when client_secret expires (null for non-expiring)
	ClientSecretExpiresAt sql.NullTime `db:"client_secret_expires_at" json:"client_secret_expires_at"`
	// RFC 7591: Array of grant types the client is allowed to use
	GrantTypes []string `db:"grant_types" json:"grant_types"`
	// RFC 7591: Array of response types the client supports
	ResponseTypes []string `db:"response_types" json:"response_types"`
	// RFC 7591: Authentication method for token endpoint
	TokenEndpointAuthMethod sql.NullString `db:"token_endpoint_auth_method" json:"token_endpoint_auth_method"`
	// RFC 7591: Space-delimited scope values the client can request
	Scope sql.NullString `db:"scope" json:"scope"`
	// RFC 7591: Array of email addresses for responsible parties
	Contacts []string `db:"contacts" json:"contacts"`
	// RFC 7591: URL of the client home page
	ClientUri sql.NullString `db:"client_uri" json:"client_uri"`
	// RFC 7591: URL of the client logo image
	LogoUri sql.NullString `db:"logo_uri" json:"logo_uri"`
	// RFC 7591: URL of the client terms of service
	TosUri sql.NullString `db:"tos_uri" json:"tos_uri"`
	// RFC 7591: URL of the client privacy policy
	PolicyUri sql.NullString `db:"policy_uri" json:"policy_uri"`
	// RFC 7591: URL of the client JSON Web Key Set
	JwksUri sql.NullString `db:"jwks_uri" json:"jwks_uri"`
	// RFC 7591: JSON Web Key Set document value
	Jwks pqtype.NullRawMessage `db:"jwks" json:"jwks"`
	// RFC 7591: Identifier for the client software
	SoftwareID sql.NullString `db:"software_id" json:"software_id"`
	// RFC 7591: Version of the client software
	SoftwareVersion sql.NullString `db:"software_version" json:"software_version"`
	// RFC 7592: Hashed registration access token for client management
	RegistrationAccessToken []byte `db:"registration_access_token" json:"registration_access_token"`
	// RFC 7592: URI for client configuration endpoint
	RegistrationClientUri sql.NullString `db:"registration_client_uri" json:"registration_client_uri"`
}

// Codes are meant to be exchanged for access tokens.
type OAuth2ProviderAppCode struct {
	ID           uuid.UUID `db:"id" json:"id"`
	CreatedAt    time.Time `db:"created_at" json:"created_at"`
	ExpiresAt    time.Time `db:"expires_at" json:"expires_at"`
	SecretPrefix []byte    `db:"secret_prefix" json:"secret_prefix"`
	HashedSecret []byte    `db:"hashed_secret" json:"hashed_secret"`
	UserID       uuid.UUID `db:"user_id" json:"user_id"`
	AppID        uuid.UUID `db:"app_id" json:"app_id"`
	// RFC 8707 resource parameter for audience restriction
	ResourceUri sql.NullString `db:"resource_uri" json:"resource_uri"`
	// PKCE code challenge for public clients
	CodeChallenge sql.NullString `db:"code_challenge" json:"code_challenge"`
	// PKCE challenge method (S256)
	CodeChallengeMethod sql.NullString `db:"code_challenge_method" json:"code_challenge_method"`
}

type OAuth2ProviderAppSecret struct {
	ID           uuid.UUID    `db:"id" json:"id"`
	CreatedAt    time.Time    `db:"created_at" json:"created_at"`
	LastUsedAt   sql.NullTime `db:"last_used_at" json:"last_used_at"`
	HashedSecret []byte       `db:"hashed_secret" json:"hashed_secret"`
	// The tail end of the original secret so secrets can be differentiated.
	DisplaySecret string    `db:"display_secret" json:"display_secret"`
	AppID         uuid.UUID `db:"app_id" json:"app_id"`
	SecretPrefix  []byte    `db:"secret_prefix" json:"secret_prefix"`
}

type OAuth2ProviderAppToken struct {
	ID         uuid.UUID `db:"id" json:"id"`
	CreatedAt  time.Time `db:"created_at" json:"created_at"`
	ExpiresAt  time.Time `db:"expires_at" json:"expires_at"`
	HashPrefix []byte    `db:"hash_prefix" json:"hash_prefix"`
	// Refresh tokens provide a way to refresh an access token (API key). An expired API key can be refreshed if this token is not yet expired, meaning this expiry can outlive an API key.
	RefreshHash []byte    `db:"refresh_hash" json:"refresh_hash"`
	AppSecretID uuid.UUID `db:"app_secret_id" json:"app_secret_id"`
	APIKeyID    string    `db:"api_key_id" json:"api_key_id"`
	// Token audience binding from resource parameter
	Audience sql.NullString `db:"audience" json:"audience"`
	// Denormalized user ID for performance optimization in authorization checks
	UserID uuid.UUID `db:"user_id" json:"user_id"`
}

type Organization struct {
	ID                       uuid.UUID `db:"id" json:"id"`
	Name                     string    `db:"name" json:"name"`
	Description              string    `db:"description" json:"description"`
	CreatedAt                time.Time `db:"created_at" json:"created_at"`
	UpdatedAt                time.Time `db:"updated_at" json:"updated_at"`
	IsDefault                bool      `db:"is_default" json:"is_default"`
	DisplayName              string    `db:"display_name" json:"display_name"`
	Icon                     string    `db:"icon" json:"icon"`
	Deleted                  bool      `db:"deleted" json:"deleted"`
	WorkspaceSharingDisabled bool      `db:"workspace_sharing_disabled" json:"workspace_sharing_disabled"`
}

type OrganizationMember struct {
	UserID         uuid.UUID `db:"user_id" json:"user_id"`
	OrganizationID uuid.UUID `db:"organization_id" json:"organization_id"`
	CreatedAt      time.Time `db:"created_at" json:"created_at"`
	UpdatedAt      time.Time `db:"updated_at" json:"updated_at"`
	Roles          []string  `db:"roles" json:"roles"`
}

type ParameterSchema struct {
	ID                       uuid.UUID                  `db:"id" json:"id"`
	CreatedAt                time.Time                  `db:"created_at" json:"created_at"`
	JobID                    uuid.UUID                  `db:"job_id" json:"job_id"`
	Name                     string                     `db:"name" json:"name"`
	Description              string                     `db:"description" json:"description"`
	DefaultSourceScheme      ParameterSourceScheme      `db:"default_source_scheme" json:"default_source_scheme"`
	DefaultSourceValue       string                     `db:"default_source_value" json:"default_source_value"`
	AllowOverrideSource      bool                       `db:"allow_override_source" json:"allow_override_source"`
	DefaultDestinationScheme ParameterDestinationScheme `db:"default_destination_scheme" json:"default_destination_scheme"`
	AllowOverrideDestination bool                       `db:"allow_override_destination" json:"allow_override_destination"`
	DefaultRefresh           string                     `db:"default_refresh" json:"default_refresh"`
	RedisplayValue           bool                       `db:"redisplay_value" json:"redisplay_value"`
	ValidationError          string                     `db:"validation_error" json:"validation_error"`
	ValidationCondition      string                     `db:"validation_condition" json:"validation_condition"`
	ValidationTypeSystem     ParameterTypeSystem        `db:"validation_type_system" json:"validation_type_system"`
	ValidationValueType      string                     `db:"validation_value_type" json:"validation_value_type"`
	Index                    int32                      `db:"index" json:"index"`
}

type ParameterValue struct {
	ID                uuid.UUID                  `db:"id" json:"id"`
	CreatedAt         time.Time                  `db:"created_at" json:"created_at"`
	UpdatedAt         time.Time                  `db:"updated_at" json:"updated_at"`
	Scope             ParameterScope             `db:"scope" json:"scope"`
	ScopeID           uuid.UUID                  `db:"scope_id" json:"scope_id"`
	Name              string                     `db:"name" json:"name"`
	SourceScheme      ParameterSourceScheme      `db:"source_scheme" json:"source_scheme"`
	SourceValue       string                     `db:"source_value" json:"source_value"`
	DestinationScheme ParameterDestinationScheme `db:"destination_scheme" json:"destination_scheme"`
}

type ProvisionerDaemon struct {
	ID           uuid.UUID         `db:"id" json:"id"`
	CreatedAt    time.Time         `db:"created_at" json:"created_at"`
	Name         string            `db:"name" json:"name"`
	Provisioners []ProvisionerType `db:"provisioners" json:"provisioners"`
	ReplicaID    uuid.NullUUID     `db:"replica_id" json:"replica_id"`
	Tags         StringMap         `db:"tags" json:"tags"`
	LastSeenAt   sql.NullTime      `db:"last_seen_at" json:"last_seen_at"`
	Version      string            `db:"version" json:"version"`
	// The API version of the provisioner daemon
	APIVersion     string    `db:"api_version" json:"api_version"`
	OrganizationID uuid.UUID `db:"organization_id" json:"organization_id"`
	KeyID          uuid.UUID `db:"key_id" json:"key_id"`
}

type ProvisionerJob struct {
	ID             uuid.UUID                `db:"id" json:"id"`
	CreatedAt      time.Time                `db:"created_at" json:"created_at"`
	UpdatedAt      time.Time                `db:"updated_at" json:"updated_at"`
	StartedAt      sql.NullTime             `db:"started_at" json:"started_at"`
	CanceledAt     sql.NullTime             `db:"canceled_at" json:"canceled_at"`
	CompletedAt    sql.NullTime             `db:"completed_at" json:"completed_at"`
	Error          sql.NullString           `db:"error" json:"error"`
	OrganizationID uuid.UUID                `db:"organization_id" json:"organization_id"`
	InitiatorID    uuid.UUID                `db:"initiator_id" json:"initiator_id"`
	Provisioner    ProvisionerType          `db:"provisioner" json:"provisioner"`
	StorageMethod  ProvisionerStorageMethod `db:"storage_method" json:"storage_method"`
	Type           ProvisionerJobType       `db:"type" json:"type"`
	Input          json.RawMessage          `db:"input" json:"input"`
	WorkerID       uuid.NullUUID            `db:"worker_id" json:"worker_id"`
	FileID         uuid.UUID                `db:"file_id" json:"file_id"`
	Tags           StringMap                `db:"tags" json:"tags"`
	ErrorCode      sql.NullString           `db:"error_code" json:"error_code"`
	TraceMetadata  pqtype.NullRawMessage    `db:"trace_metadata" json:"trace_metadata"`
	// Computed column to track the status of the job.
	JobStatus ProvisionerJobStatus `db:"job_status" json:"job_status"`
	// Total length of provisioner logs
	LogsLength int32 `db:"logs_length" json:"logs_length"`
	// Whether the provisioner logs overflowed in length
	LogsOverflowed bool `db:"logs_overflowed" json:"logs_overflowed"`
}

type ProvisionerJobLog struct {
	JobID     uuid.UUID `db:"job_id" json:"job_id"`
	CreatedAt time.Time `db:"created_at" json:"created_at"`
	Source    LogSource `db:"source" json:"source"`
	Level     LogLevel  `db:"level" json:"level"`
	Stage     string    `db:"stage" json:"stage"`
	Output    string    `db:"output" json:"output"`
	ID        int64     `db:"id" json:"id"`
}

type ProvisionerJobStat struct {
	JobID          uuid.UUID            `db:"job_id" json:"job_id"`
	JobStatus      ProvisionerJobStatus `db:"job_status" json:"job_status"`
	WorkspaceID    uuid.UUID            `db:"workspace_id" json:"workspace_id"`
	WorkerID       uuid.NullUUID        `db:"worker_id" json:"worker_id"`
	Error          sql.NullString       `db:"error" json:"error"`
	ErrorCode      sql.NullString       `db:"error_code" json:"error_code"`
	UpdatedAt      time.Time            `db:"updated_at" json:"updated_at"`
	QueuedSecs     float64              `db:"queued_secs" json:"queued_secs"`
	CompletionSecs float64              `db:"completion_secs" json:"completion_secs"`
	CanceledSecs   float64              `db:"canceled_secs" json:"canceled_secs"`
	InitSecs       float64              `db:"init_secs" json:"init_secs"`
	PlanSecs       float64              `db:"plan_secs" json:"plan_secs"`
	GraphSecs      float64              `db:"graph_secs" json:"graph_secs"`
	ApplySecs      float64              `db:"apply_secs" json:"apply_secs"`
}

type ProvisionerJobTiming struct {
	JobID     uuid.UUID                 `db:"job_id" json:"job_id"`
	StartedAt time.Time                 `db:"started_at" json:"started_at"`
	EndedAt   time.Time                 `db:"ended_at" json:"ended_at"`
	Stage     ProvisionerJobTimingStage `db:"stage" json:"stage"`
	Source    string                    `db:"source" json:"source"`
	Action    string                    `db:"action" json:"action"`
	Resource  string                    `db:"resource" json:"resource"`
}

type ProvisionerKey struct {
	ID             uuid.UUID `db:"id" json:"id"`
	CreatedAt      time.Time `db:"created_at" json:"created_at"`
	OrganizationID uuid.UUID `db:"organization_id" json:"organization_id"`
	Name           string    `db:"name" json:"name"`
	HashedSecret   []byte    `db:"hashed_secret" json:"hashed_secret"`
	Tags           StringMap `db:"tags" json:"tags"`
}

type Replica struct {
	ID              uuid.UUID    `db:"id" json:"id"`
	CreatedAt       time.Time    `db:"created_at" json:"created_at"`
	StartedAt       time.Time    `db:"started_at" json:"started_at"`
	StoppedAt       sql.NullTime `db:"stopped_at" json:"stopped_at"`
	UpdatedAt       time.Time    `db:"updated_at" json:"updated_at"`
	Hostname        string       `db:"hostname" json:"hostname"`
	RegionID        int32        `db:"region_id" json:"region_id"`
	RelayAddress    string       `db:"relay_address" json:"relay_address"`
	DatabaseLatency int32        `db:"database_latency" json:"database_latency"`
	Version         string       `db:"version" json:"version"`
	Error           string       `db:"error" json:"error"`
	Primary         bool         `db:"primary" json:"primary"`
}

type SiteConfig struct {
	Key   string `db:"key" json:"key"`
	Value string `db:"value" json:"value"`
}

// We keep this separate from replicas in case we need to break the coordinator out into its own service
type TailnetCoordinator struct {
	ID          uuid.UUID `db:"id" json:"id"`
	HeartbeatAt time.Time `db:"heartbeat_at" json:"heartbeat_at"`
}

type TailnetPeer struct {
	ID            uuid.UUID     `db:"id" json:"id"`
	CoordinatorID uuid.UUID     `db:"coordinator_id" json:"coordinator_id"`
	UpdatedAt     time.Time     `db:"updated_at" json:"updated_at"`
	Node          []byte        `db:"node" json:"node"`
	Status        TailnetStatus `db:"status" json:"status"`
}

type TailnetTunnel struct {
	CoordinatorID uuid.UUID `db:"coordinator_id" json:"coordinator_id"`
	SrcID         uuid.UUID `db:"src_id" json:"src_id"`
	DstID         uuid.UUID `db:"dst_id" json:"dst_id"`
	UpdatedAt     time.Time `db:"updated_at" json:"updated_at"`
}

type Task struct {
	ID                           uuid.UUID                        `db:"id" json:"id"`
	OrganizationID               uuid.UUID                        `db:"organization_id" json:"organization_id"`
	OwnerID                      uuid.UUID                        `db:"owner_id" json:"owner_id"`
	Name                         string                           `db:"name" json:"name"`
	WorkspaceID                  uuid.NullUUID                    `db:"workspace_id" json:"workspace_id"`
	TemplateVersionID            uuid.UUID                        `db:"template_version_id" json:"template_version_id"`
	TemplateParameters           json.RawMessage                  `db:"template_parameters" json:"template_parameters"`
	Prompt                       string                           `db:"prompt" json:"prompt"`
	CreatedAt                    time.Time                        `db:"created_at" json:"created_at"`
	DeletedAt                    sql.NullTime                     `db:"deleted_at" json:"deleted_at"`
	DisplayName                  string                           `db:"display_name" json:"display_name"`
	Status                       TaskStatus                       `db:"status" json:"status"`
	StatusDebug                  json.RawMessage                  `db:"status_debug" json:"status_debug"`
	WorkspaceBuildNumber         sql.NullInt32                    `db:"workspace_build_number" json:"workspace_build_number"`
	WorkspaceAgentID             uuid.NullUUID                    `db:"workspace_agent_id" json:"workspace_agent_id"`
	WorkspaceAppID               uuid.NullUUID                    `db:"workspace_app_id" json:"workspace_app_id"`
	WorkspaceAgentLifecycleState NullWorkspaceAgentLifecycleState `db:"workspace_agent_lifecycle_state" json:"workspace_agent_lifecycle_state"`
	WorkspaceAppHealth           NullWorkspaceAppHealth           `db:"workspace_app_health" json:"workspace_app_health"`
	OwnerUsername                string                           `db:"owner_username" json:"owner_username"`
	OwnerName                    string                           `db:"owner_name" json:"owner_name"`
	OwnerAvatarUrl               string                           `db:"owner_avatar_url" json:"owner_avatar_url"`
}

// Stores snapshots of task state when paused, currently limited to conversation history.
type TaskSnapshot struct {
	// The task this snapshot belongs to.
	TaskID uuid.UUID `db:"task_id" json:"task_id"`
	// Task conversation history in JSON format, allowing users to view logs when the workspace is stopped.
	LogSnapshot json.RawMessage `db:"log_snapshot" json:"log_snapshot"`
	// When this log snapshot was captured.
	LogSnapshotCreatedAt time.Time `db:"log_snapshot_created_at" json:"log_snapshot_created_at"`
}

type TaskTable struct {
	ID                 uuid.UUID       `db:"id" json:"id"`
	OrganizationID     uuid.UUID       `db:"organization_id" json:"organization_id"`
	OwnerID            uuid.UUID       `db:"owner_id" json:"owner_id"`
	Name               string          `db:"name" json:"name"`
	WorkspaceID        uuid.NullUUID   `db:"workspace_id" json:"workspace_id"`
	TemplateVersionID  uuid.UUID       `db:"template_version_id" json:"template_version_id"`
	TemplateParameters json.RawMessage `db:"template_parameters" json:"template_parameters"`
	Prompt             string          `db:"prompt" json:"prompt"`
	CreatedAt          time.Time       `db:"created_at" json:"created_at"`
	DeletedAt          sql.NullTime    `db:"deleted_at" json:"deleted_at"`
	// Display name is a custom, human-friendly task name.
	DisplayName string `db:"display_name" json:"display_name"`
}

type TaskWorkspaceApp struct {
	TaskID               uuid.UUID     `db:"task_id" json:"task_id"`
	WorkspaceAgentID     uuid.NullUUID `db:"workspace_agent_id" json:"workspace_agent_id"`
	WorkspaceAppID       uuid.NullUUID `db:"workspace_app_id" json:"workspace_app_id"`
	WorkspaceBuildNumber int32         `db:"workspace_build_number" json:"workspace_build_number"`
}

type TelemetryItem struct {
	Key       string    `db:"key" json:"key"`
	Value     string    `db:"value" json:"value"`
	CreatedAt time.Time `db:"created_at" json:"created_at"`
	UpdatedAt time.Time `db:"updated_at" json:"updated_at"`
}

// Telemetry lock tracking table for deduplication of heartbeat events across replicas.
type TelemetryLock struct {
	// The type of event that was sent.
	EventType string `db:"event_type" json:"event_type"`
	// The heartbeat period end timestamp.
	PeriodEndingAt time.Time `db:"period_ending_at" json:"period_ending_at"`
}

// Joins in the display name information such as username, avatar, and organization name.
type Template struct {
	ID                            uuid.UUID       `db:"id" json:"id"`
	CreatedAt                     time.Time       `db:"created_at" json:"created_at"`
	UpdatedAt                     time.Time       `db:"updated_at" json:"updated_at"`
	OrganizationID                uuid.UUID       `db:"organization_id" json:"organization_id"`
	Deleted                       bool            `db:"deleted" json:"deleted"`
	Name                          string          `db:"name" json:"name"`
	Provisioner                   ProvisionerType `db:"provisioner" json:"provisioner"`
	ActiveVersionID               uuid.UUID       `db:"active_version_id" json:"active_version_id"`
	Description                   string          `db:"description" json:"description"`
	DefaultTTL                    int64           `db:"default_ttl" json:"default_ttl"`
	CreatedBy                     uuid.UUID       `db:"created_by" json:"created_by"`
	Icon                          string          `db:"icon" json:"icon"`
	UserACL                       TemplateACL     `db:"user_acl" json:"user_acl"`
	GroupACL                      TemplateACL     `db:"group_acl" json:"group_acl"`
	DisplayName                   string          `db:"display_name" json:"display_name"`
	AllowUserCancelWorkspaceJobs  bool            `db:"allow_user_cancel_workspace_jobs" json:"allow_user_cancel_workspace_jobs"`
	AllowUserAutostart            bool            `db:"allow_user_autostart" json:"allow_user_autostart"`
	AllowUserAutostop             bool            `db:"allow_user_autostop" json:"allow_user_autostop"`
	FailureTTL                    int64           `db:"failure_ttl" json:"failure_ttl"`
	TimeTilDormant                int64           `db:"time_til_dormant" json:"time_til_dormant"`
	TimeTilDormantAutoDelete      int64           `db:"time_til_dormant_autodelete" json:"time_til_dormant_autodelete"`
	AutostopRequirementDaysOfWeek int16           `db:"autostop_requirement_days_of_week" json:"autostop_requirement_days_of_week"`
	AutostopRequirementWeeks      int64           `db:"autostop_requirement_weeks" json:"autostop_requirement_weeks"`
	AutostartBlockDaysOfWeek      int16           `db:"autostart_block_days_of_week" json:"autostart_block_days_of_week"`
	RequireActiveVersion          bool            `db:"require_active_version" json:"require_active_version"`
	Deprecated                    string          `db:"deprecated" json:"deprecated"`
	ActivityBump                  int64           `db:"activity_bump" json:"activity_bump"`
	MaxPortSharingLevel           AppSharingLevel `db:"max_port_sharing_level" json:"max_port_sharing_level"`
	UseClassicParameterFlow       bool            `db:"use_classic_parameter_flow" json:"use_classic_parameter_flow"`
	CorsBehavior                  CorsBehavior    `db:"cors_behavior" json:"cors_behavior"`
	CreatedByAvatarURL            string          `db:"created_by_avatar_url" json:"created_by_avatar_url"`
	CreatedByUsername             string          `db:"created_by_username" json:"created_by_username"`
	CreatedByName                 string          `db:"created_by_name" json:"created_by_name"`
	OrganizationName              string          `db:"organization_name" json:"organization_name"`
	OrganizationDisplayName       string          `db:"organization_display_name" json:"organization_display_name"`
	OrganizationIcon              string          `db:"organization_icon" json:"organization_icon"`
}

type TemplateTable struct {
	ID              uuid.UUID       `db:"id" json:"id"`
	CreatedAt       time.Time       `db:"created_at" json:"created_at"`
	UpdatedAt       time.Time       `db:"updated_at" json:"updated_at"`
	OrganizationID  uuid.UUID       `db:"organization_id" json:"organization_id"`
	Deleted         bool            `db:"deleted" json:"deleted"`
	Name            string          `db:"name" json:"name"`
	Provisioner     ProvisionerType `db:"provisioner" json:"provisioner"`
	ActiveVersionID uuid.UUID       `db:"active_version_id" json:"active_version_id"`
	Description     string          `db:"description" json:"description"`
	// The default duration for autostop for workspaces created from this template.
	DefaultTTL int64       `db:"default_ttl" json:"default_ttl"`
	CreatedBy  uuid.UUID   `db:"created_by" json:"created_by"`
	Icon       string      `db:"icon" json:"icon"`
	UserACL    TemplateACL `db:"user_acl" json:"user_acl"`
	GroupACL   TemplateACL `db:"group_acl" json:"group_acl"`
	// Display name is a custom, human-friendly template name that user can set.
	DisplayName string `db:"display_name" json:"display_name"`
	// Allow users to cancel in-progress workspace jobs.
	AllowUserCancelWorkspaceJobs bool `db:"allow_user_cancel_workspace_jobs" json:"allow_user_cancel_workspace_jobs"`
	// Allow users to specify an autostart schedule for workspaces (enterprise).
	AllowUserAutostart bool `db:"allow_user_autostart" json:"allow_user_autostart"`
	// Allow users to specify custom autostop values for workspaces (enterprise).
	AllowUserAutostop        bool  `db:"allow_user_autostop" json:"allow_user_autostop"`
	FailureTTL               int64 `db:"failure_ttl" json:"failure_ttl"`
	TimeTilDormant           int64 `db:"time_til_dormant" json:"time_til_dormant"`
	TimeTilDormantAutoDelete int64 `db:"time_til_dormant_autodelete" json:"time_til_dormant_autodelete"`
	// A bitmap of days of week to restart the workspace on, starting with Monday as the 0th bit, and Sunday as the 6th bit. The 7th bit is unused.
	AutostopRequirementDaysOfWeek int16 `db:"autostop_requirement_days_of_week" json:"autostop_requirement_days_of_week"`
	// The number of weeks between restarts. 0 or 1 weeks means "every week", 2 week means "every second week", etc. Weeks are counted from January 2, 2023, which is the first Monday of 2023. This is to ensure workspaces are started consistently for all customers on the same n-week cycles.
	AutostopRequirementWeeks int64 `db:"autostop_requirement_weeks" json:"autostop_requirement_weeks"`
	// A bitmap of days of week that autostart of a workspace is not allowed. Default allows all days. This is intended as a cost savings measure to prevent auto start on weekends (for example).
	AutostartBlockDaysOfWeek int16 `db:"autostart_block_days_of_week" json:"autostart_block_days_of_week"`
	RequireActiveVersion     bool  `db:"require_active_version" json:"require_active_version"`
	// If set to a non empty string, the template will no longer be able to be used. The message will be displayed to the user.
	Deprecated          string          `db:"deprecated" json:"deprecated"`
	ActivityBump        int64           `db:"activity_bump" json:"activity_bump"`
	MaxPortSharingLevel AppSharingLevel `db:"max_port_sharing_level" json:"max_port_sharing_level"`
	// Determines whether to default to the dynamic parameter creation flow for this template or continue using the legacy classic parameter creation flow.This is a template wide setting, the template admin can revert to the classic flow if there are any issues. An escape hatch is required, as workspace creation is a core workflow and cannot break. This column will be removed when the dynamic parameter creation flow is stable.
	UseClassicParameterFlow bool         `db:"use_classic_parameter_flow" json:"use_classic_parameter_flow"`
	CorsBehavior            CorsBehavior `db:"cors_behavior" json:"cors_behavior"`
}

// Records aggregated usage statistics for templates/users. All usage is rounded up to the nearest minute.
type TemplateUsageStat struct {
	// Start time of the usage period.
	StartTime time.Time `db:"start_time" json:"start_time"`
	// End time of the usage period.
	EndTime time.Time `db:"end_time" json:"end_time"`
	// ID of the template being used.
	TemplateID uuid.UUID `db:"template_id" json:"template_id"`
	// ID of the user using the template.
	UserID uuid.UUID `db:"user_id" json:"user_id"`
	// Median latency the user is experiencing, in milliseconds. Null means no value was recorded.
	MedianLatencyMs sql.NullFloat64 `db:"median_latency_ms" json:"median_latency_ms"`
	// Total minutes the user has been using the template.
	UsageMins int16 `db:"usage_mins" json:"usage_mins"`
	// Total minutes the user has been using SSH.
	SshMins int16 `db:"ssh_mins" json:"ssh_mins"`
	// Total minutes the user has been using SFTP.
	SftpMins int16 `db:"sftp_mins" json:"sftp_mins"`
	// Total minutes the user has been using the reconnecting PTY.
	ReconnectingPtyMins int16 `db:"reconnecting_pty_mins" json:"reconnecting_pty_mins"`
	// Total minutes the user has been using VSCode.
	VscodeMins int16 `db:"vscode_mins" json:"vscode_mins"`
	// Total minutes the user has been using JetBrains.
	JetbrainsMins int16 `db:"jetbrains_mins" json:"jetbrains_mins"`
	// Object with app names as keys and total minutes used as values. Null means no app usage was recorded.
	AppUsageMins StringMapOfInt `db:"app_usage_mins" json:"app_usage_mins"`
}

// Joins in the username + avatar url of the created by user.
type TemplateVersion struct {
	ID                    uuid.UUID       `db:"id" json:"id"`
	TemplateID            uuid.NullUUID   `db:"template_id" json:"template_id"`
	OrganizationID        uuid.UUID       `db:"organization_id" json:"organization_id"`
	CreatedAt             time.Time       `db:"created_at" json:"created_at"`
	UpdatedAt             time.Time       `db:"updated_at" json:"updated_at"`
	Name                  string          `db:"name" json:"name"`
	Readme                string          `db:"readme" json:"readme"`
	JobID                 uuid.UUID       `db:"job_id" json:"job_id"`
	CreatedBy             uuid.UUID       `db:"created_by" json:"created_by"`
	ExternalAuthProviders json.RawMessage `db:"external_auth_providers" json:"external_auth_providers"`
	Message               string          `db:"message" json:"message"`
	Archived              bool            `db:"archived" json:"archived"`
	SourceExampleID       sql.NullString  `db:"source_example_id" json:"source_example_id"`
	HasAITask             sql.NullBool    `db:"has_ai_task" json:"has_ai_task"`
	HasExternalAgent      sql.NullBool    `db:"has_external_agent" json:"has_external_agent"`
	CreatedByAvatarURL    string          `db:"created_by_avatar_url" json:"created_by_avatar_url"`
	CreatedByUsername     string          `db:"created_by_username" json:"created_by_username"`
	CreatedByName         string          `db:"created_by_name" json:"created_by_name"`
}

type TemplateVersionParameter struct {
	TemplateVersionID uuid.UUID `db:"template_version_id" json:"template_version_id"`
	// Parameter name
	Name string `db:"name" json:"name"`
	// Parameter description
	Description string `db:"description" json:"description"`
	// Parameter type
	Type string `db:"type" json:"type"`
	// Is parameter mutable?
	Mutable bool `db:"mutable" json:"mutable"`
	// Default value
	DefaultValue string `db:"default_value" json:"default_value"`
	// Icon
	Icon string `db:"icon" json:"icon"`
	// Additional options
	Options json.RawMessage `db:"options" json:"options"`
	// Validation: regex pattern
	ValidationRegex string `db:"validation_regex" json:"validation_regex"`
	// Validation: minimum length of value
	ValidationMin sql.NullInt32 `db:"validation_min" json:"validation_min"`
	// Validation: maximum length of value
	ValidationMax sql.NullInt32 `db:"validation_max" json:"validation_max"`
	// Validation: error displayed when the regex does not match.
	ValidationError string `db:"validation_error" json:"validation_error"`
	// Validation: consecutive values preserve the monotonic order
	ValidationMonotonic string `db:"validation_monotonic" json:"validation_monotonic"`
	// Is parameter required?
	Required bool `db:"required" json:"required"`
	// Display name of the rich parameter
	DisplayName string `db:"display_name" json:"display_name"`
	// Specifies the order in which to display parameters in user interfaces.
	DisplayOrder int32 `db:"display_order" json:"display_order"`
	// The value of an ephemeral parameter will not be preserved between consecutive workspace builds.
	Ephemeral bool `db:"ephemeral" json:"ephemeral"`
	// Specify what form_type should be used to render the parameter in the UI. Unsupported values are rejected.
	FormType ParameterFormType `db:"form_type" json:"form_type"`
}

type TemplateVersionPreset struct {
	ID                  uuid.UUID      `db:"id" json:"id"`
	TemplateVersionID   uuid.UUID      `db:"template_version_id" json:"template_version_id"`
	Name                string         `db:"name" json:"name"`
	CreatedAt           time.Time      `db:"created_at" json:"created_at"`
	DesiredInstances    sql.NullInt32  `db:"desired_instances" json:"desired_instances"`
	InvalidateAfterSecs sql.NullInt32  `db:"invalidate_after_secs" json:"invalidate_after_secs"`
	PrebuildStatus      PrebuildStatus `db:"prebuild_status" json:"prebuild_status"`
	SchedulingTimezone  string         `db:"scheduling_timezone" json:"scheduling_timezone"`
	IsDefault           bool           `db:"is_default" json:"is_default"`
	// Short text describing the preset (max 128 characters).
	Description string `db:"description" json:"description"`
	// URL or path to an icon representing the preset (max 256 characters).
	Icon              string       `db:"icon" json:"icon"`
	LastInvalidatedAt sql.NullTime `db:"last_invalidated_at" json:"last_invalidated_at"`
}

type TemplateVersionPresetParameter struct {
	ID                      uuid.UUID `db:"id" json:"id"`
	TemplateVersionPresetID uuid.UUID `db:"template_version_preset_id" json:"template_version_preset_id"`
	Name                    string    `db:"name" json:"name"`
	Value                   string    `db:"value" json:"value"`
}

type TemplateVersionPresetPrebuildSchedule struct {
	ID               uuid.UUID `db:"id" json:"id"`
	PresetID         uuid.UUID `db:"preset_id" json:"preset_id"`
	CronExpression   string    `db:"cron_expression" json:"cron_expression"`
	DesiredInstances int32     `db:"desired_instances" json:"desired_instances"`
}

type TemplateVersionTable struct {
	ID             uuid.UUID     `db:"id" json:"id"`
	TemplateID     uuid.NullUUID `db:"template_id" json:"template_id"`
	OrganizationID uuid.UUID     `db:"organization_id" json:"organization_id"`
	CreatedAt      time.Time     `db:"created_at" json:"created_at"`
	UpdatedAt      time.Time     `db:"updated_at" json:"updated_at"`
	Name           string        `db:"name" json:"name"`
	Readme         string        `db:"readme" json:"readme"`
	JobID          uuid.UUID     `db:"job_id" json:"job_id"`
	CreatedBy      uuid.UUID     `db:"created_by" json:"created_by"`
	// IDs of External auth providers for a specific template version
	ExternalAuthProviders json.RawMessage `db:"external_auth_providers" json:"external_auth_providers"`
	// Message describing the changes in this version of the template, similar to a Git commit message. Like a commit message, this should be a short, high-level description of the changes in this version of the template. This message is immutable and should not be updated after the fact.
	Message          string         `db:"message" json:"message"`
	Archived         bool           `db:"archived" json:"archived"`
	SourceExampleID  sql.NullString `db:"source_example_id" json:"source_example_id"`
	HasAITask        sql.NullBool   `db:"has_ai_task" json:"has_ai_task"`
	HasExternalAgent sql.NullBool   `db:"has_external_agent" json:"has_external_agent"`
}

type TemplateVersionTerraformValue struct {
	TemplateVersionID uuid.UUID       `db:"template_version_id" json:"template_version_id"`
	UpdatedAt         time.Time       `db:"updated_at" json:"updated_at"`
	CachedPlan        json.RawMessage `db:"cached_plan" json:"cached_plan"`
	CachedModuleFiles uuid.NullUUID   `db:"cached_module_files" json:"cached_module_files"`
	// What version of the provisioning engine was used to generate the cached plan and module files.
	ProvisionerdVersion string `db:"provisionerd_version" json:"provisionerd_version"`
}

type TemplateVersionVariable struct {
	TemplateVersionID uuid.UUID `db:"template_version_id" json:"template_version_id"`
	// Variable name
	Name string `db:"name" json:"name"`
	// Variable description
	Description string `db:"description" json:"description"`
	// Variable type
	Type string `db:"type" json:"type"`
	// Variable value
	Value string `db:"value" json:"value"`
	// Variable default value
	DefaultValue string `db:"default_value" json:"default_value"`
	// Required variables needs a default value or a value provided by template admin
	Required bool `db:"required" json:"required"`
	// Sensitive variables have their values redacted in logs or site UI
	Sensitive bool `db:"sensitive" json:"sensitive"`
}

type TemplateVersionWorkspaceTag struct {
	TemplateVersionID uuid.UUID `db:"template_version_id" json:"template_version_id"`
	Key               string    `db:"key" json:"key"`
	Value             string    `db:"value" json:"value"`
}

// usage_events contains usage data that is collected from the product and potentially shipped to the usage collector service.
type UsageEvent struct {
	// For "discrete" event types, this is a random UUID. For "heartbeat" event types, this is a combination of the event type and a truncated timestamp.
	ID string `db:"id" json:"id"`
	// The usage event type with version. "dc" means "discrete" (e.g. a single event, for counters), "hb" means "heartbeat" (e.g. a recurring event that contains a total count of usage generated from the database, for gauges).
	EventType string `db:"event_type" json:"event_type"`
	// Event payload. Determined by the matching usage struct for this event type.
	EventData json.RawMessage `db:"event_data" json:"event_data"`
	CreatedAt time.Time       `db:"created_at" json:"created_at"`
	// Set to a timestamp while the event is being published by a Coder replica to the usage collector service. Used to avoid duplicate publishes by multiple replicas. Timestamps older than 1 hour are considered expired.
	PublishStartedAt sql.NullTime `db:"publish_started_at" json:"publish_started_at"`
	// Set to a timestamp when the event is successfully (or permanently unsuccessfully) published to the usage collector service. If set, the event should never be attempted to be published again.
	PublishedAt sql.NullTime `db:"published_at" json:"published_at"`
	// Set to an error message when the event is temporarily or permanently unsuccessfully published to the usage collector service.
	FailureMessage sql.NullString `db:"failure_message" json:"failure_message"`
}

// usage_events_daily is a daily rollup of usage events. It stores the total usage for each event type by day.
type UsageEventsDaily struct {
	// The date of the summed usage events, always in UTC.
	Day       time.Time       `db:"day" json:"day"`
	EventType string          `db:"event_type" json:"event_type"`
	UsageData json.RawMessage `db:"usage_data" json:"usage_data"`
}

type User struct {
	ID             uuid.UUID      `db:"id" json:"id"`
	Email          string         `db:"email" json:"email"`
	Username       string         `db:"username" json:"username"`
	HashedPassword []byte         `db:"hashed_password" json:"hashed_password"`
	CreatedAt      time.Time      `db:"created_at" json:"created_at"`
	UpdatedAt      time.Time      `db:"updated_at" json:"updated_at"`
	Status         UserStatus     `db:"status" json:"status"`
	RBACRoles      pq.StringArray `db:"rbac_roles" json:"rbac_roles"`
	LoginType      LoginType      `db:"login_type" json:"login_type"`
	AvatarURL      string         `db:"avatar_url" json:"avatar_url"`
	Deleted        bool           `db:"deleted" json:"deleted"`
	LastSeenAt     time.Time      `db:"last_seen_at" json:"last_seen_at"`
	// Daily (!) cron schedule (with optional CRON_TZ) signifying the start of the user's quiet hours. If empty, the default quiet hours on the instance is used instead.
	QuietHoursSchedule string `db:"quiet_hours_schedule" json:"quiet_hours_schedule"`
	// Name of the Coder user
	Name string `db:"name" json:"name"`
	// The GitHub.com numerical user ID. It is used to check if the user has starred the Coder repository. It is also used for filtering users in the users list CLI command, and may become more widely used in the future.
	GithubComUserID sql.NullInt64 `db:"github_com_user_id" json:"github_com_user_id"`
	// A hash of the one-time-passcode given to the user.
	HashedOneTimePasscode []byte `db:"hashed_one_time_passcode" json:"hashed_one_time_passcode"`
	// The time when the one-time-passcode expires.
	OneTimePasscodeExpiresAt sql.NullTime `db:"one_time_passcode_expires_at" json:"one_time_passcode_expires_at"`
	// Determines if a user is a system user, and therefore cannot login or perform normal actions
	IsSystem bool `db:"is_system" json:"is_system"`
}

type UserConfig struct {
	UserID uuid.UUID `db:"user_id" json:"user_id"`
	Key    string    `db:"key" json:"key"`
	Value  string    `db:"value" json:"value"`
}

// Tracks when users were deleted
type UserDeleted struct {
	ID        uuid.UUID `db:"id" json:"id"`
	UserID    uuid.UUID `db:"user_id" json:"user_id"`
	DeletedAt time.Time `db:"deleted_at" json:"deleted_at"`
}

type UserLink struct {
	UserID            uuid.UUID `db:"user_id" json:"user_id"`
	LoginType         LoginType `db:"login_type" json:"login_type"`
	LinkedID          string    `db:"linked_id" json:"linked_id"`
	OAuthAccessToken  string    `db:"oauth_access_token" json:"oauth_access_token"`
	OAuthRefreshToken string    `db:"oauth_refresh_token" json:"oauth_refresh_token"`
	OAuthExpiry       time.Time `db:"oauth_expiry" json:"oauth_expiry"`
	// The ID of the key used to encrypt the OAuth access token. If this is NULL, the access token is not encrypted
	OAuthAccessTokenKeyID sql.NullString `db:"oauth_access_token_key_id" json:"oauth_access_token_key_id"`
	// The ID of the key used to encrypt the OAuth refresh token. If this is NULL, the refresh token is not encrypted
	OAuthRefreshTokenKeyID sql.NullString `db:"oauth_refresh_token_key_id" json:"oauth_refresh_token_key_id"`
	// Claims from the IDP for the linked user. Includes both id_token and userinfo claims.
	Claims UserLinkClaims `db:"claims" json:"claims"`
}

type UserSecret struct {
	ID          uuid.UUID `db:"id" json:"id"`
	UserID      uuid.UUID `db:"user_id" json:"user_id"`
	Name        string    `db:"name" json:"name"`
	Description string    `db:"description" json:"description"`
	Value       string    `db:"value" json:"value"`
	EnvName     string    `db:"env_name" json:"env_name"`
	FilePath    string    `db:"file_path" json:"file_path"`
	CreatedAt   time.Time `db:"created_at" json:"created_at"`
	UpdatedAt   time.Time `db:"updated_at" json:"updated_at"`
}

// Tracks the history of user status changes
type UserStatusChange struct {
	ID        uuid.UUID  `db:"id" json:"id"`
	UserID    uuid.UUID  `db:"user_id" json:"user_id"`
	NewStatus UserStatus `db:"new_status" json:"new_status"`
	ChangedAt time.Time  `db:"changed_at" json:"changed_at"`
}

// Visible fields of users are allowed to be joined with other tables for including context of other resources.
type VisibleUser struct {
	ID        uuid.UUID `db:"id" json:"id"`
	Username  string    `db:"username" json:"username"`
	Name      string    `db:"name" json:"name"`
	AvatarURL string    `db:"avatar_url" json:"avatar_url"`
}

type WebpushSubscription struct {
	ID                uuid.UUID `db:"id" json:"id"`
	UserID            uuid.UUID `db:"user_id" json:"user_id"`
	CreatedAt         time.Time `db:"created_at" json:"created_at"`
	Endpoint          string    `db:"endpoint" json:"endpoint"`
	EndpointP256dhKey string    `db:"endpoint_p256dh_key" json:"endpoint_p256dh_key"`
	EndpointAuthKey   string    `db:"endpoint_auth_key" json:"endpoint_auth_key"`
}

// Joins in the display name information such as username, avatar, and organization name.
type Workspace struct {
	ID                      uuid.UUID               `db:"id" json:"id"`
	CreatedAt               time.Time               `db:"created_at" json:"created_at"`
	UpdatedAt               time.Time               `db:"updated_at" json:"updated_at"`
	OwnerID                 uuid.UUID               `db:"owner_id" json:"owner_id"`
	OrganizationID          uuid.UUID               `db:"organization_id" json:"organization_id"`
	TemplateID              uuid.UUID               `db:"template_id" json:"template_id"`
	Deleted                 bool                    `db:"deleted" json:"deleted"`
	Name                    string                  `db:"name" json:"name"`
	AutostartSchedule       sql.NullString          `db:"autostart_schedule" json:"autostart_schedule"`
	Ttl                     sql.NullInt64           `db:"ttl" json:"ttl"`
	LastUsedAt              time.Time               `db:"last_used_at" json:"last_used_at"`
	DormantAt               sql.NullTime            `db:"dormant_at" json:"dormant_at"`
	DeletingAt              sql.NullTime            `db:"deleting_at" json:"deleting_at"`
	AutomaticUpdates        AutomaticUpdates        `db:"automatic_updates" json:"automatic_updates"`
	Favorite                bool                    `db:"favorite" json:"favorite"`
	NextStartAt             sql.NullTime            `db:"next_start_at" json:"next_start_at"`
	GroupACL                WorkspaceACL            `db:"group_acl" json:"group_acl"`
	UserACL                 WorkspaceACL            `db:"user_acl" json:"user_acl"`
	OwnerAvatarUrl          string                  `db:"owner_avatar_url" json:"owner_avatar_url"`
	OwnerUsername           string                  `db:"owner_username" json:"owner_username"`
	OwnerName               string                  `db:"owner_name" json:"owner_name"`
	OrganizationName        string                  `db:"organization_name" json:"organization_name"`
	OrganizationDisplayName string                  `db:"organization_display_name" json:"organization_display_name"`
	OrganizationIcon        string                  `db:"organization_icon" json:"organization_icon"`
	OrganizationDescription string                  `db:"organization_description" json:"organization_description"`
	TemplateName            string                  `db:"template_name" json:"template_name"`
	TemplateDisplayName     string                  `db:"template_display_name" json:"template_display_name"`
	TemplateIcon            string                  `db:"template_icon" json:"template_icon"`
	TemplateDescription     string                  `db:"template_description" json:"template_description"`
	TaskID                  uuid.NullUUID           `db:"task_id" json:"task_id"`
	GroupACLDisplayInfo     WorkspaceACLDisplayInfo `db:"group_acl_display_info" json:"group_acl_display_info"`
	UserACLDisplayInfo      WorkspaceACLDisplayInfo `db:"user_acl_display_info" json:"user_acl_display_info"`
}

type WorkspaceAgent struct {
	ID                   uuid.UUID             `db:"id" json:"id"`
	CreatedAt            time.Time             `db:"created_at" json:"created_at"`
	UpdatedAt            time.Time             `db:"updated_at" json:"updated_at"`
	Name                 string                `db:"name" json:"name"`
	FirstConnectedAt     sql.NullTime          `db:"first_connected_at" json:"first_connected_at"`
	LastConnectedAt      sql.NullTime          `db:"last_connected_at" json:"last_connected_at"`
	DisconnectedAt       sql.NullTime          `db:"disconnected_at" json:"disconnected_at"`
	ResourceID           uuid.UUID             `db:"resource_id" json:"resource_id"`
	AuthToken            uuid.UUID             `db:"auth_token" json:"auth_token"`
	AuthInstanceID       sql.NullString        `db:"auth_instance_id" json:"auth_instance_id"`
	Architecture         string                `db:"architecture" json:"architecture"`
	EnvironmentVariables pqtype.NullRawMessage `db:"environment_variables" json:"environment_variables"`
	OperatingSystem      string                `db:"operating_system" json:"operating_system"`
	InstanceMetadata     pqtype.NullRawMessage `db:"instance_metadata" json:"instance_metadata"`
	ResourceMetadata     pqtype.NullRawMessage `db:"resource_metadata" json:"resource_metadata"`
	Directory            string                `db:"directory" json:"directory"`
	// Version tracks the version of the currently running workspace agent. Workspace agents register their version upon start.
	Version                string        `db:"version" json:"version"`
	LastConnectedReplicaID uuid.NullUUID `db:"last_connected_replica_id" json:"last_connected_replica_id"`
	// Connection timeout in seconds, 0 means disabled.
	ConnectionTimeoutSeconds int32 `db:"connection_timeout_seconds" json:"connection_timeout_seconds"`
	// URL for troubleshooting the agent.
	TroubleshootingURL string `db:"troubleshooting_url" json:"troubleshooting_url"`
	// Path to file inside workspace containing the message of the day (MOTD) to show to the user when logging in via SSH.
	MOTDFile string `db:"motd_file" json:"motd_file"`
	// The current lifecycle state reported by the workspace agent.
	LifecycleState WorkspaceAgentLifecycleState `db:"lifecycle_state" json:"lifecycle_state"`
	// The resolved path of a user-specified directory. e.g. ~/coder -> /home/coder/coder
	ExpandedDirectory string `db:"expanded_directory" json:"expanded_directory"`
	// Total length of startup logs
	LogsLength int32 `db:"logs_length" json:"logs_length"`
	// Whether the startup logs overflowed in length
	LogsOverflowed bool `db:"logs_overflowed" json:"logs_overflowed"`
	// The time the agent entered the starting lifecycle state
	StartedAt sql.NullTime `db:"started_at" json:"started_at"`
	// The time the agent entered the ready or start_error lifecycle state
	ReadyAt     sql.NullTime              `db:"ready_at" json:"ready_at"`
	Subsystems  []WorkspaceAgentSubsystem `db:"subsystems" json:"subsystems"`
	DisplayApps []DisplayApp              `db:"display_apps" json:"display_apps"`
	APIVersion  string                    `db:"api_version" json:"api_version"`
	// Specifies the order in which to display agents in user interfaces.
	DisplayOrder int32         `db:"display_order" json:"display_order"`
	ParentID     uuid.NullUUID `db:"parent_id" json:"parent_id"`
	// Defines the scope of the API key associated with the agent. 'all' allows access to everything, 'no_user_data' restricts it to exclude user data.
	APIKeyScope AgentKeyScopeEnum `db:"api_key_scope" json:"api_key_scope"`
	// Indicates whether or not the agent has been deleted. This is currently only applicable to sub agents.
	Deleted bool `db:"deleted" json:"deleted"`
}

// Workspace agent devcontainer configuration
type WorkspaceAgentDevcontainer struct {
	// Unique identifier
	ID uuid.UUID `db:"id" json:"id"`
	// Workspace agent foreign key
	WorkspaceAgentID uuid.UUID `db:"workspace_agent_id" json:"workspace_agent_id"`
	// Creation timestamp
	CreatedAt time.Time `db:"created_at" json:"created_at"`
	// Workspace folder
	WorkspaceFolder string `db:"workspace_folder" json:"workspace_folder"`
	// Path to devcontainer.json.
	ConfigPath string `db:"config_path" json:"config_path"`
	// The name of the Dev Container.
	Name string `db:"name" json:"name"`
}

type WorkspaceAgentLog struct {
	AgentID     uuid.UUID `db:"agent_id" json:"agent_id"`
	CreatedAt   time.Time `db:"created_at" json:"created_at"`
	Output      string    `db:"output" json:"output"`
	ID          int64     `db:"id" json:"id"`
	Level       LogLevel  `db:"level" json:"level"`
	LogSourceID uuid.UUID `db:"log_source_id" json:"log_source_id"`
}

type WorkspaceAgentLogSource struct {
	WorkspaceAgentID uuid.UUID `db:"workspace_agent_id" json:"workspace_agent_id"`
	ID               uuid.UUID `db:"id" json:"id"`
	CreatedAt        time.Time `db:"created_at" json:"created_at"`
	DisplayName      string    `db:"display_name" json:"display_name"`
	Icon             string    `db:"icon" json:"icon"`
}

type WorkspaceAgentMemoryResourceMonitor struct {
	AgentID        uuid.UUID                  `db:"agent_id" json:"agent_id"`
	Enabled        bool                       `db:"enabled" json:"enabled"`
	Threshold      int32                      `db:"threshold" json:"threshold"`
	CreatedAt      time.Time                  `db:"created_at" json:"created_at"`
	UpdatedAt      time.Time                  `db:"updated_at" json:"updated_at"`
	State          WorkspaceAgentMonitorState `db:"state" json:"state"`
	DebouncedUntil time.Time                  `db:"debounced_until" json:"debounced_until"`
}

type WorkspaceAgentMetadatum struct {
	WorkspaceAgentID uuid.UUID `db:"workspace_agent_id" json:"workspace_agent_id"`
	DisplayName      string    `db:"display_name" json:"display_name"`
	Key              string    `db:"key" json:"key"`
	Script           string    `db:"script" json:"script"`
	Value            string    `db:"value" json:"value"`
	Error            string    `db:"error" json:"error"`
	Timeout          int64     `db:"timeout" json:"timeout"`
	Interval         int64     `db:"interval" json:"interval"`
	CollectedAt      time.Time `db:"collected_at" json:"collected_at"`
	// Specifies the order in which to display agent metadata in user interfaces.
	DisplayOrder int32 `db:"display_order" json:"display_order"`
}

type WorkspaceAgentPortShare struct {
	WorkspaceID uuid.UUID         `db:"workspace_id" json:"workspace_id"`
	AgentName   string            `db:"agent_name" json:"agent_name"`
	Port        int32             `db:"port" json:"port"`
	ShareLevel  AppSharingLevel   `db:"share_level" json:"share_level"`
	Protocol    PortShareProtocol `db:"protocol" json:"protocol"`
}

type WorkspaceAgentScript struct {
	WorkspaceAgentID uuid.UUID `db:"workspace_agent_id" json:"workspace_agent_id"`
	LogSourceID      uuid.UUID `db:"log_source_id" json:"log_source_id"`
	LogPath          string    `db:"log_path" json:"log_path"`
	CreatedAt        time.Time `db:"created_at" json:"created_at"`
	Script           string    `db:"script" json:"script"`
	Cron             string    `db:"cron" json:"cron"`
	StartBlocksLogin bool      `db:"start_blocks_login" json:"start_blocks_login"`
	RunOnStart       bool      `db:"run_on_start" json:"run_on_start"`
	RunOnStop        bool      `db:"run_on_stop" json:"run_on_stop"`
	TimeoutSeconds   int32     `db:"timeout_seconds" json:"timeout_seconds"`
	DisplayName      string    `db:"display_name" json:"display_name"`
	ID               uuid.UUID `db:"id" json:"id"`
}

type WorkspaceAgentScriptTiming struct {
	ScriptID  uuid.UUID                        `db:"script_id" json:"script_id"`
	StartedAt time.Time                        `db:"started_at" json:"started_at"`
	EndedAt   time.Time                        `db:"ended_at" json:"ended_at"`
	ExitCode  int32                            `db:"exit_code" json:"exit_code"`
	Stage     WorkspaceAgentScriptTimingStage  `db:"stage" json:"stage"`
	Status    WorkspaceAgentScriptTimingStatus `db:"status" json:"status"`
}

type WorkspaceAgentStat struct {
	ID                          uuid.UUID       `db:"id" json:"id"`
	CreatedAt                   time.Time       `db:"created_at" json:"created_at"`
	UserID                      uuid.UUID       `db:"user_id" json:"user_id"`
	AgentID                     uuid.UUID       `db:"agent_id" json:"agent_id"`
	WorkspaceID                 uuid.UUID       `db:"workspace_id" json:"workspace_id"`
	TemplateID                  uuid.UUID       `db:"template_id" json:"template_id"`
	ConnectionsByProto          json.RawMessage `db:"connections_by_proto" json:"connections_by_proto"`
	ConnectionCount             int64           `db:"connection_count" json:"connection_count"`
	RxPackets                   int64           `db:"rx_packets" json:"rx_packets"`
	RxBytes                     int64           `db:"rx_bytes" json:"rx_bytes"`
	TxPackets                   int64           `db:"tx_packets" json:"tx_packets"`
	TxBytes                     int64           `db:"tx_bytes" json:"tx_bytes"`
	ConnectionMedianLatencyMS   float64         `db:"connection_median_latency_ms" json:"connection_median_latency_ms"`
	SessionCountVSCode          int64           `db:"session_count_vscode" json:"session_count_vscode"`
	SessionCountJetBrains       int64           `db:"session_count_jetbrains" json:"session_count_jetbrains"`
	SessionCountReconnectingPTY int64           `db:"session_count_reconnecting_pty" json:"session_count_reconnecting_pty"`
	SessionCountSSH             int64           `db:"session_count_ssh" json:"session_count_ssh"`
	Usage                       bool            `db:"usage" json:"usage"`
}

type WorkspaceAgentVolumeResourceMonitor struct {
	AgentID        uuid.UUID                  `db:"agent_id" json:"agent_id"`
	Enabled        bool                       `db:"enabled" json:"enabled"`
	Threshold      int32                      `db:"threshold" json:"threshold"`
	Path           string                     `db:"path" json:"path"`
	CreatedAt      time.Time                  `db:"created_at" json:"created_at"`
	UpdatedAt      time.Time                  `db:"updated_at" json:"updated_at"`
	State          WorkspaceAgentMonitorState `db:"state" json:"state"`
	DebouncedUntil time.Time                  `db:"debounced_until" json:"debounced_until"`
}

type WorkspaceApp struct {
	ID                   uuid.UUID          `db:"id" json:"id"`
	CreatedAt            time.Time          `db:"created_at" json:"created_at"`
	AgentID              uuid.UUID          `db:"agent_id" json:"agent_id"`
	DisplayName          string             `db:"display_name" json:"display_name"`
	Icon                 string             `db:"icon" json:"icon"`
	Command              sql.NullString     `db:"command" json:"command"`
	Url                  sql.NullString     `db:"url" json:"url"`
	HealthcheckUrl       string             `db:"healthcheck_url" json:"healthcheck_url"`
	HealthcheckInterval  int32              `db:"healthcheck_interval" json:"healthcheck_interval"`
	HealthcheckThreshold int32              `db:"healthcheck_threshold" json:"healthcheck_threshold"`
	Health               WorkspaceAppHealth `db:"health" json:"health"`
	Subdomain            bool               `db:"subdomain" json:"subdomain"`
	SharingLevel         AppSharingLevel    `db:"sharing_level" json:"sharing_level"`
	Slug                 string             `db:"slug" json:"slug"`
	External             bool               `db:"external" json:"external"`
	// Specifies the order in which to display agent app in user interfaces.
	DisplayOrder int32 `db:"display_order" json:"display_order"`
	// Determines if the app is not shown in user interfaces.
	Hidden       bool               `db:"hidden" json:"hidden"`
	OpenIn       WorkspaceAppOpenIn `db:"open_in" json:"open_in"`
	DisplayGroup sql.NullString     `db:"display_group" json:"display_group"`
	// Markdown text that is displayed when hovering over workspace apps.
	Tooltip string `db:"tooltip" json:"tooltip"`
}

// Audit sessions for workspace apps, the data in this table is ephemeral and is used to deduplicate audit log entries for workspace apps. While a session is active, the same data will not be logged again. This table does not store historical data.
type WorkspaceAppAuditSession struct {
	// The agent that the workspace app or port forward belongs to.
	AgentID uuid.UUID `db:"agent_id" json:"agent_id"`
	// The app that is currently in the workspace app. This is may be uuid.Nil because ports are not associated with an app.
	AppID uuid.UUID `db:"app_id" json:"app_id"`
	// The user that is currently using the workspace app. This is may be uuid.Nil if we cannot determine the user.
	UserID uuid.UUID `db:"user_id" json:"user_id"`
	// The IP address of the user that is currently using the workspace app.
	Ip string `db:"ip" json:"ip"`
	// The user agent of the user that is currently using the workspace app.
	UserAgent string `db:"user_agent" json:"user_agent"`
	// The slug or port of the workspace app that the user is currently using.
	SlugOrPort string `db:"slug_or_port" json:"slug_or_port"`
	// The HTTP status produced by the token authorization. Defaults to 200 if no status is provided.
	StatusCode int32 `db:"status_code" json:"status_code"`
	// The time the user started the session.
	StartedAt time.Time `db:"started_at" json:"started_at"`
	// The time the session was last updated.
	UpdatedAt time.Time `db:"updated_at" json:"updated_at"`
	ID        uuid.UUID `db:"id" json:"id"`
}

// A record of workspace app usage statistics
type WorkspaceAppStat struct {
	// The ID of the record
	ID int64 `db:"id" json:"id"`
	// The user who used the workspace app
	UserID uuid.UUID `db:"user_id" json:"user_id"`
	// The workspace that the workspace app was used in
	WorkspaceID uuid.UUID `db:"workspace_id" json:"workspace_id"`
	// The workspace agent that was used
	AgentID uuid.UUID `db:"agent_id" json:"agent_id"`
	// The method used to access the workspace app
	AccessMethod string `db:"access_method" json:"access_method"`
	// The slug or port used to to identify the app
	SlugOrPort string `db:"slug_or_port" json:"slug_or_port"`
	// The unique identifier for the session
	SessionID uuid.UUID `db:"session_id" json:"session_id"`
	// The time the session started
	SessionStartedAt time.Time `db:"session_started_at" json:"session_started_at"`
	// The time the session ended
	SessionEndedAt time.Time `db:"session_ended_at" json:"session_ended_at"`
	// The number of requests made during the session, a number larger than 1 indicates that multiple sessions were rolled up into one
	Requests int32 `db:"requests" json:"requests"`
}

type WorkspaceAppStatus struct {
	ID          uuid.UUID               `db:"id" json:"id"`
	CreatedAt   time.Time               `db:"created_at" json:"created_at"`
	AgentID     uuid.UUID               `db:"agent_id" json:"agent_id"`
	AppID       uuid.UUID               `db:"app_id" json:"app_id"`
	WorkspaceID uuid.UUID               `db:"workspace_id" json:"workspace_id"`
	State       WorkspaceAppStatusState `db:"state" json:"state"`
	Message     string                  `db:"message" json:"message"`
	Uri         sql.NullString          `db:"uri" json:"uri"`
}

// Joins in the username + avatar url of the initiated by user.
type WorkspaceBuild struct {
	ID                      uuid.UUID           `db:"id" json:"id"`
	CreatedAt               time.Time           `db:"created_at" json:"created_at"`
	UpdatedAt               time.Time           `db:"updated_at" json:"updated_at"`
	WorkspaceID             uuid.UUID           `db:"workspace_id" json:"workspace_id"`
	TemplateVersionID       uuid.UUID           `db:"template_version_id" json:"template_version_id"`
	BuildNumber             int32               `db:"build_number" json:"build_number"`
	Transition              WorkspaceTransition `db:"transition" json:"transition"`
	InitiatorID             uuid.UUID           `db:"initiator_id" json:"initiator_id"`
	ProvisionerState        []byte              `db:"provisioner_state" json:"provisioner_state"`
	JobID                   uuid.UUID           `db:"job_id" json:"job_id"`
	Deadline                time.Time           `db:"deadline" json:"deadline"`
	Reason                  BuildReason         `db:"reason" json:"reason"`
	DailyCost               int32               `db:"daily_cost" json:"daily_cost"`
	MaxDeadline             time.Time           `db:"max_deadline" json:"max_deadline"`
	TemplateVersionPresetID uuid.NullUUID       `db:"template_version_preset_id" json:"template_version_preset_id"`
	HasAITask               sql.NullBool        `db:"has_ai_task" json:"has_ai_task"`
	HasExternalAgent        sql.NullBool        `db:"has_external_agent" json:"has_external_agent"`
	InitiatorByAvatarUrl    string              `db:"initiator_by_avatar_url" json:"initiator_by_avatar_url"`
	InitiatorByUsername     string              `db:"initiator_by_username" json:"initiator_by_username"`
	InitiatorByName         string              `db:"initiator_by_name" json:"initiator_by_name"`
}

type WorkspaceBuildParameter struct {
	WorkspaceBuildID uuid.UUID `db:"workspace_build_id" json:"workspace_build_id"`
	// Parameter name
	Name string `db:"name" json:"name"`
	// Parameter value
	Value string `db:"value" json:"value"`
}

type WorkspaceBuildTable struct {
	ID                      uuid.UUID           `db:"id" json:"id"`
	CreatedAt               time.Time           `db:"created_at" json:"created_at"`
	UpdatedAt               time.Time           `db:"updated_at" json:"updated_at"`
	WorkspaceID             uuid.UUID           `db:"workspace_id" json:"workspace_id"`
	TemplateVersionID       uuid.UUID           `db:"template_version_id" json:"template_version_id"`
	BuildNumber             int32               `db:"build_number" json:"build_number"`
	Transition              WorkspaceTransition `db:"transition" json:"transition"`
	InitiatorID             uuid.UUID           `db:"initiator_id" json:"initiator_id"`
	ProvisionerState        []byte              `db:"provisioner_state" json:"provisioner_state"`
	JobID                   uuid.UUID           `db:"job_id" json:"job_id"`
	Deadline                time.Time           `db:"deadline" json:"deadline"`
	Reason                  BuildReason         `db:"reason" json:"reason"`
	DailyCost               int32               `db:"daily_cost" json:"daily_cost"`
	MaxDeadline             time.Time           `db:"max_deadline" json:"max_deadline"`
	TemplateVersionPresetID uuid.NullUUID       `db:"template_version_preset_id" json:"template_version_preset_id"`
	HasAITask               sql.NullBool        `db:"has_ai_task" json:"has_ai_task"`
	HasExternalAgent        sql.NullBool        `db:"has_external_agent" json:"has_external_agent"`
}

type WorkspaceLatestBuild struct {
	ID                      uuid.UUID            `db:"id" json:"id"`
	WorkspaceID             uuid.UUID            `db:"workspace_id" json:"workspace_id"`
	TemplateVersionID       uuid.UUID            `db:"template_version_id" json:"template_version_id"`
	JobID                   uuid.UUID            `db:"job_id" json:"job_id"`
	TemplateVersionPresetID uuid.NullUUID        `db:"template_version_preset_id" json:"template_version_preset_id"`
	Transition              WorkspaceTransition  `db:"transition" json:"transition"`
	CreatedAt               time.Time            `db:"created_at" json:"created_at"`
	JobStatus               ProvisionerJobStatus `db:"job_status" json:"job_status"`
}

type WorkspaceModule struct {
	ID         uuid.UUID           `db:"id" json:"id"`
	JobID      uuid.UUID           `db:"job_id" json:"job_id"`
	Transition WorkspaceTransition `db:"transition" json:"transition"`
	Source     string              `db:"source" json:"source"`
	Version    string              `db:"version" json:"version"`
	Key        string              `db:"key" json:"key"`
	CreatedAt  time.Time           `db:"created_at" json:"created_at"`
}

type WorkspacePrebuild struct {
	ID              uuid.UUID     `db:"id" json:"id"`
	Name            string        `db:"name" json:"name"`
	TemplateID      uuid.UUID     `db:"template_id" json:"template_id"`
	CreatedAt       time.Time     `db:"created_at" json:"created_at"`
	Ready           bool          `db:"ready" json:"ready"`
	CurrentPresetID uuid.NullUUID `db:"current_preset_id" json:"current_preset_id"`
}

type WorkspacePrebuildBuild struct {
	ID                      uuid.UUID           `db:"id" json:"id"`
	WorkspaceID             uuid.UUID           `db:"workspace_id" json:"workspace_id"`
	TemplateVersionID       uuid.UUID           `db:"template_version_id" json:"template_version_id"`
	Transition              WorkspaceTransition `db:"transition" json:"transition"`
	JobID                   uuid.UUID           `db:"job_id" json:"job_id"`
	TemplateVersionPresetID uuid.NullUUID       `db:"template_version_preset_id" json:"template_version_preset_id"`
	BuildNumber             int32               `db:"build_number" json:"build_number"`
}

type WorkspaceProxy struct {
	ID          uuid.UUID `db:"id" json:"id"`
	Name        string    `db:"name" json:"name"`
	DisplayName string    `db:"display_name" json:"display_name"`
	// Expects an emoji character. (/emojis/1f1fa-1f1f8.png)
	Icon string `db:"icon" json:"icon"`
	// Full url including scheme of the proxy api url: https://us.example.com
	Url string `db:"url" json:"url"`
	// Hostname with the wildcard for subdomain based app hosting: *.us.example.com
	WildcardHostname string    `db:"wildcard_hostname" json:"wildcard_hostname"`
	CreatedAt        time.Time `db:"created_at" json:"created_at"`
	UpdatedAt        time.Time `db:"updated_at" json:"updated_at"`
	// Boolean indicator of a deleted workspace proxy. Proxies are soft-deleted.
	Deleted bool `db:"deleted" json:"deleted"`
	// Hashed secret is used to authenticate the workspace proxy using a session token.
	TokenHashedSecret []byte `db:"token_hashed_secret" json:"token_hashed_secret"`
	RegionID          int32  `db:"region_id" json:"region_id"`
	DerpEnabled       bool   `db:"derp_enabled" json:"derp_enabled"`
	// Disables app/terminal proxying for this proxy and only acts as a DERP relay.
	DerpOnly bool   `db:"derp_only" json:"derp_only"`
	Version  string `db:"version" json:"version"`
}

type WorkspaceResource struct {
	ID           uuid.UUID           `db:"id" json:"id"`
	CreatedAt    time.Time           `db:"created_at" json:"created_at"`
	JobID        uuid.UUID           `db:"job_id" json:"job_id"`
	Transition   WorkspaceTransition `db:"transition" json:"transition"`
	Type         string              `db:"type" json:"type"`
	Name         string              `db:"name" json:"name"`
	Hide         bool                `db:"hide" json:"hide"`
	Icon         string              `db:"icon" json:"icon"`
	InstanceType sql.NullString      `db:"instance_type" json:"instance_type"`
	DailyCost    int32               `db:"daily_cost" json:"daily_cost"`
	ModulePath   sql.NullString      `db:"module_path" json:"module_path"`
}

type WorkspaceResourceMetadatum struct {
	WorkspaceResourceID uuid.UUID      `db:"workspace_resource_id" json:"workspace_resource_id"`
	Key                 string         `db:"key" json:"key"`
	Value               sql.NullString `db:"value" json:"value"`
	Sensitive           bool           `db:"sensitive" json:"sensitive"`
	ID                  int64          `db:"id" json:"id"`
}

type WorkspaceTable struct {
	ID                uuid.UUID        `db:"id" json:"id"`
	CreatedAt         time.Time        `db:"created_at" json:"created_at"`
	UpdatedAt         time.Time        `db:"updated_at" json:"updated_at"`
	OwnerID           uuid.UUID        `db:"owner_id" json:"owner_id"`
	OrganizationID    uuid.UUID        `db:"organization_id" json:"organization_id"`
	TemplateID        uuid.UUID        `db:"template_id" json:"template_id"`
	Deleted           bool             `db:"deleted" json:"deleted"`
	Name              string           `db:"name" json:"name"`
	AutostartSchedule sql.NullString   `db:"autostart_schedule" json:"autostart_schedule"`
	Ttl               sql.NullInt64    `db:"ttl" json:"ttl"`
	LastUsedAt        time.Time        `db:"last_used_at" json:"last_used_at"`
	DormantAt         sql.NullTime     `db:"dormant_at" json:"dormant_at"`
	DeletingAt        sql.NullTime     `db:"deleting_at" json:"deleting_at"`
	AutomaticUpdates  AutomaticUpdates `db:"automatic_updates" json:"automatic_updates"`
	// Favorite is true if the workspace owner has favorited the workspace.
	Favorite    bool         `db:"favorite" json:"favorite"`
	NextStartAt sql.NullTime `db:"next_start_at" json:"next_start_at"`
	GroupACL    WorkspaceACL `db:"group_acl" json:"group_acl"`
	UserACL     WorkspaceACL `db:"user_acl" json:"user_acl"`
}
