// Code generated by sqlc. DO NOT EDIT.
// versions:
//   sqlc v1.30.0

package database

import (
	"context"
	"time"

	"github.com/google/uuid"
)

type sqlcQuerier interface {
	// Blocks until the lock is acquired.
	//
	// This must be called from within a transaction. The lock will be automatically
	// released when the transaction ends.
	AcquireLock(ctx context.Context, pgAdvisoryXactLock int64) error
	// Acquires the lease for a given count of notification messages, to enable concurrent dequeuing and subsequent sending.
	// Only rows that aren't already leased (or ones which are leased but have exceeded their lease period) are returned.
	//
	// A "lease" here refers to a notifier taking ownership of a notification_messages row. A lease survives for the duration
	// of CODER_NOTIFICATIONS_LEASE_PERIOD. Once a message is delivered, its status is updated and the lease expires (set to NULL).
	// If a message exceeds its lease, that implies the notifier did not shutdown cleanly, or the table update failed somehow,
	// and the row will then be eligible to be dequeued by another notifier.
	//
	// SKIP LOCKED is used to jump over locked rows. This prevents multiple notifiers from acquiring the same messages.
	// See: https://www.postgresql.org/docs/9.5/sql-select.html#SQL-FOR-UPDATE-SHARE
	//
	AcquireNotificationMessages(ctx context.Context, arg AcquireNotificationMessagesParams) ([]AcquireNotificationMessagesRow, error)
	// Acquires the lock for a single job that isn't started, completed,
	// canceled, and that matches an array of provisioner types.
	//
	// SKIP LOCKED is used to jump over locked rows. This prevents
	// multiple provisioners from acquiring the same jobs. See:
	// https://www.postgresql.org/docs/9.5/sql-select.html#SQL-FOR-UPDATE-SHARE
	AcquireProvisionerJob(ctx context.Context, arg AcquireProvisionerJobParams) (ProvisionerJob, error)
	// Bumps the workspace deadline by the template's configured "activity_bump"
	// duration (default 1h). If the workspace bump will cross an autostart
	// threshold, then the bump is autostart + TTL. This is the deadline behavior if
	// the workspace was to autostart from a stopped state.
	//
	// Max deadline is respected, and the deadline will never be bumped past it.
	// The deadline will never decrease.
	// We only bump if the template has an activity bump duration set.
	// We only bump if the raw interval is positive and non-zero.
	// We only bump if workspace shutdown is manual.
	// We only bump when 5% of the deadline has elapsed.
	ActivityBumpWorkspace(ctx context.Context, arg ActivityBumpWorkspaceParams) error
	// AllUserIDs returns all UserIDs regardless of user status or deletion.
	AllUserIDs(ctx context.Context, includeSystem bool) ([]uuid.UUID, error)
	// Archiving templates is a soft delete action, so is reversible.
	// Archiving prevents the version from being used and discovered
	// by listing.
	// Only unused template versions will be archived, which are any versions not
	// referenced by the latest build of a workspace.
	ArchiveUnusedTemplateVersions(ctx context.Context, arg ArchiveUnusedTemplateVersionsParams) ([]uuid.UUID, error)
	BatchUpdateWorkspaceAgentMetadata(ctx context.Context, arg BatchUpdateWorkspaceAgentMetadataParams) error
	BatchUpdateWorkspaceLastUsedAt(ctx context.Context, arg BatchUpdateWorkspaceLastUsedAtParams) error
	BatchUpdateWorkspaceNextStartAt(ctx context.Context, arg BatchUpdateWorkspaceNextStartAtParams) error
	BulkMarkNotificationMessagesFailed(ctx context.Context, arg BulkMarkNotificationMessagesFailedParams) (int64, error)
	BulkMarkNotificationMessagesSent(ctx context.Context, arg BulkMarkNotificationMessagesSentParams) (int64, error)
	// Calculates the telemetry summary for a given provider, model, and client
	// combination for telemetry reporting.
	CalculateAIBridgeInterceptionsTelemetrySummary(ctx context.Context, arg CalculateAIBridgeInterceptionsTelemetrySummaryParams) (CalculateAIBridgeInterceptionsTelemetrySummaryRow, error)
	ClaimPrebuiltWorkspace(ctx context.Context, arg ClaimPrebuiltWorkspaceParams) (ClaimPrebuiltWorkspaceRow, error)
	CleanTailnetCoordinators(ctx context.Context) error
	CleanTailnetLostPeers(ctx context.Context) error
	CleanTailnetTunnels(ctx context.Context) error
	CountAIBridgeInterceptions(ctx context.Context, arg CountAIBridgeInterceptionsParams) (int64, error)
	CountAuditLogs(ctx context.Context, arg CountAuditLogsParams) (int64, error)
	CountConnectionLogs(ctx context.Context, arg CountConnectionLogsParams) (int64, error)
	// CountInProgressPrebuilds returns the number of in-progress prebuilds, grouped by preset ID and transition.
	// Prebuild considered in-progress if it's in the "pending", "starting", "stopping", or "deleting" state.
	CountInProgressPrebuilds(ctx context.Context) ([]CountInProgressPrebuildsRow, error)
	// CountPendingNonActivePrebuilds returns the number of pending prebuilds for non-active template versions
	CountPendingNonActivePrebuilds(ctx context.Context) ([]CountPendingNonActivePrebuildsRow, error)
	CountUnreadInboxNotificationsByUserID(ctx context.Context, userID uuid.UUID) (int64, error)
	CreateUserSecret(ctx context.Context, arg CreateUserSecretParams) (UserSecret, error)
	CustomRoles(ctx context.Context, arg CustomRolesParams) ([]CustomRole, error)
	DeleteAPIKeyByID(ctx context.Context, id string) error
	DeleteAPIKeysByUserID(ctx context.Context, userID uuid.UUID) error
	DeleteAllTailnetTunnels(ctx context.Context, arg DeleteAllTailnetTunnelsParams) error
	// Deletes all existing webpush subscriptions.
	// This should be called when the VAPID keypair is regenerated, as the old
	// keypair will no longer be valid and all existing subscriptions will need to
	// be recreated.
	DeleteAllWebpushSubscriptions(ctx context.Context) error
	DeleteApplicationConnectAPIKeysByUserID(ctx context.Context, userID uuid.UUID) error
	// Deletes boundary usage statistics for a specific replica.
	DeleteBoundaryUsageStatsByReplicaID(ctx context.Context, replicaID uuid.UUID) error
	DeleteCryptoKey(ctx context.Context, arg DeleteCryptoKeyParams) (CryptoKey, error)
	DeleteCustomRole(ctx context.Context, arg DeleteCustomRoleParams) error
	DeleteExpiredAPIKeys(ctx context.Context, arg DeleteExpiredAPIKeysParams) (int64, error)
	DeleteExternalAuthLink(ctx context.Context, arg DeleteExternalAuthLinkParams) error
	DeleteGitSSHKey(ctx context.Context, userID uuid.UUID) error
	DeleteGroupByID(ctx context.Context, id uuid.UUID) error
	DeleteGroupMemberFromGroup(ctx context.Context, arg DeleteGroupMemberFromGroupParams) error
	DeleteLicense(ctx context.Context, id int32) (int32, error)
	DeleteOAuth2ProviderAppByClientID(ctx context.Context, id uuid.UUID) error
	DeleteOAuth2ProviderAppByID(ctx context.Context, id uuid.UUID) error
	DeleteOAuth2ProviderAppCodeByID(ctx context.Context, id uuid.UUID) error
	DeleteOAuth2ProviderAppCodesByAppAndUserID(ctx context.Context, arg DeleteOAuth2ProviderAppCodesByAppAndUserIDParams) error
	DeleteOAuth2ProviderAppSecretByID(ctx context.Context, id uuid.UUID) error
	DeleteOAuth2ProviderAppTokensByAppAndUserID(ctx context.Context, arg DeleteOAuth2ProviderAppTokensByAppAndUserIDParams) error
	// Cumulative count.
	DeleteOldAIBridgeRecords(ctx context.Context, beforeTime time.Time) (int64, error)
	DeleteOldAuditLogConnectionEvents(ctx context.Context, arg DeleteOldAuditLogConnectionEventsParams) error
	// Deletes old audit logs based on retention policy, excluding deprecated
	// connection events (connect, disconnect, open, close) which are handled
	// separately by DeleteOldAuditLogConnectionEvents.
	DeleteOldAuditLogs(ctx context.Context, arg DeleteOldAuditLogsParams) (int64, error)
	DeleteOldConnectionLogs(ctx context.Context, arg DeleteOldConnectionLogsParams) (int64, error)
	// Delete all notification messages which have not been updated for over a week.
	DeleteOldNotificationMessages(ctx context.Context) error
	// Delete provisioner daemons that have been created at least a week ago
	// and have not connected to coderd since a week.
	// A provisioner daemon with "zeroed" last_seen_at column indicates possible
	// connectivity issues (no provisioner daemon activity since registration).
	DeleteOldProvisionerDaemons(ctx context.Context) error
	// Deletes old telemetry locks from the telemetry_locks table.
	DeleteOldTelemetryLocks(ctx context.Context, periodEndingAtBefore time.Time) error
	// If an agent hasn't connected within the retention period, we purge its logs.
	// Exception: if the logs are related to the latest build, we keep those around.
	// Logs can take up a lot of space, so it's important we clean up frequently.
	DeleteOldWorkspaceAgentLogs(ctx context.Context, threshold time.Time) (int64, error)
	DeleteOldWorkspaceAgentStats(ctx context.Context) error
	DeleteOrganizationMember(ctx context.Context, arg DeleteOrganizationMemberParams) error
	DeleteProvisionerKey(ctx context.Context, id uuid.UUID) error
	DeleteReplicasUpdatedBefore(ctx context.Context, updatedAt time.Time) error
	DeleteRuntimeConfig(ctx context.Context, key string) error
	DeleteTailnetPeer(ctx context.Context, arg DeleteTailnetPeerParams) (DeleteTailnetPeerRow, error)
	DeleteTailnetTunnel(ctx context.Context, arg DeleteTailnetTunnelParams) (DeleteTailnetTunnelRow, error)
	DeleteTask(ctx context.Context, arg DeleteTaskParams) (TaskTable, error)
	DeleteUserSecret(ctx context.Context, id uuid.UUID) error
	DeleteWebpushSubscriptionByUserIDAndEndpoint(ctx context.Context, arg DeleteWebpushSubscriptionByUserIDAndEndpointParams) error
	DeleteWebpushSubscriptions(ctx context.Context, ids []uuid.UUID) error
	DeleteWorkspaceACLByID(ctx context.Context, id uuid.UUID) error
	DeleteWorkspaceACLsByOrganization(ctx context.Context, organizationID uuid.UUID) error
	DeleteWorkspaceAgentPortShare(ctx context.Context, arg DeleteWorkspaceAgentPortShareParams) error
	DeleteWorkspaceAgentPortSharesByTemplate(ctx context.Context, templateID uuid.UUID) error
	DeleteWorkspaceSubAgentByID(ctx context.Context, id uuid.UUID) error
	// Disable foreign keys and triggers for all tables.
	// Deprecated: disable foreign keys was created to aid in migrating off
	// of the test-only in-memory database. Do not use this in new code.
	DisableForeignKeysAndTriggers(ctx context.Context) error
	EnqueueNotificationMessage(ctx context.Context, arg EnqueueNotificationMessageParams) error
	// Firstly, collect api_keys owned by the prebuilds user that correlate
	// to workspaces no longer owned by the prebuilds user.
	// Next, collect api_keys that belong to the prebuilds user but have no token name.
	// These were most likely created via 'coder login' as the prebuilds user.
	ExpirePrebuildsAPIKeys(ctx context.Context, now time.Time) error
	FavoriteWorkspace(ctx context.Context, id uuid.UUID) error
	FetchMemoryResourceMonitorsByAgentID(ctx context.Context, agentID uuid.UUID) (WorkspaceAgentMemoryResourceMonitor, error)
	FetchMemoryResourceMonitorsUpdatedAfter(ctx context.Context, updatedAt time.Time) ([]WorkspaceAgentMemoryResourceMonitor, error)
	// This is used to build up the notification_message's JSON payload.
	FetchNewMessageMetadata(ctx context.Context, arg FetchNewMessageMetadataParams) (FetchNewMessageMetadataRow, error)
	FetchVolumesResourceMonitorsByAgentID(ctx context.Context, agentID uuid.UUID) ([]WorkspaceAgentVolumeResourceMonitor, error)
	FetchVolumesResourceMonitorsUpdatedAfter(ctx context.Context, updatedAt time.Time) ([]WorkspaceAgentVolumeResourceMonitor, error)
	// FindMatchingPresetID finds a preset ID that is the largest exact subset of the provided parameters.
	// It returns the preset ID if a match is found, or NULL if no match is found.
	// The query finds presets where all preset parameters are present in the provided parameters,
	// and returns the preset with the most parameters (largest subset).
	FindMatchingPresetID(ctx context.Context, arg FindMatchingPresetIDParams) (uuid.UUID, error)
	GetAIBridgeInterceptionByID(ctx context.Context, id uuid.UUID) (AIBridgeInterception, error)
	GetAIBridgeInterceptions(ctx context.Context) ([]AIBridgeInterception, error)
	GetAIBridgeTokenUsagesByInterceptionID(ctx context.Context, interceptionID uuid.UUID) ([]AIBridgeTokenUsage, error)
	GetAIBridgeToolUsagesByInterceptionID(ctx context.Context, interceptionID uuid.UUID) ([]AIBridgeToolUsage, error)
	GetAIBridgeUserPromptsByInterceptionID(ctx context.Context, interceptionID uuid.UUID) ([]AIBridgeUserPrompt, error)
	GetAPIKeyByID(ctx context.Context, id string) (APIKey, error)
	// there is no unique constraint on empty token names
	GetAPIKeyByName(ctx context.Context, arg GetAPIKeyByNameParams) (APIKey, error)
	GetAPIKeysByLoginType(ctx context.Context, loginType LoginType) ([]APIKey, error)
	GetAPIKeysByUserID(ctx context.Context, arg GetAPIKeysByUserIDParams) ([]APIKey, error)
	GetAPIKeysLastUsedAfter(ctx context.Context, lastUsed time.Time) ([]APIKey, error)
	GetActivePresetPrebuildSchedules(ctx context.Context) ([]TemplateVersionPresetPrebuildSchedule, error)
	GetActiveUserCount(ctx context.Context, includeSystem bool) (int64, error)
	GetActiveWorkspaceBuildsByTemplateID(ctx context.Context, templateID uuid.UUID) ([]WorkspaceBuild, error)
	// For PG Coordinator HTMLDebug
	GetAllTailnetCoordinators(ctx context.Context) ([]TailnetCoordinator, error)
	GetAllTailnetPeers(ctx context.Context) ([]TailnetPeer, error)
	GetAllTailnetTunnels(ctx context.Context) ([]TailnetTunnel, error)
	GetAnnouncementBanners(ctx context.Context) (string, error)
	GetAppSecurityKey(ctx context.Context) (string, error)
	GetApplicationName(ctx context.Context) (string, error)
	// GetAuditLogsBefore retrieves `row_limit` number of audit logs before the provided
	// ID.
	GetAuditLogsOffset(ctx context.Context, arg GetAuditLogsOffsetParams) ([]GetAuditLogsOffsetRow, error)
	// GetAuthenticatedWorkspaceAgentAndBuildByAuthToken returns an authenticated
	// workspace agent and its associated build. During normal operation, this is
	// the latest build. During shutdown, this may be the previous START build while
	// the STOP build is executing, allowing shutdown scripts to authenticate (see
	// issue #19467).
	GetAuthenticatedWorkspaceAgentAndBuildByAuthToken(ctx context.Context, authToken uuid.UUID) (GetAuthenticatedWorkspaceAgentAndBuildByAuthTokenRow, error)
	// This function returns roles for authorization purposes. Implied member roles
	// are included.
	GetAuthorizationUserRoles(ctx context.Context, userID uuid.UUID) (GetAuthorizationUserRolesRow, error)
	// Aggregates boundary usage statistics across all replicas. Filters to only
	// include data where window_start is within the given interval to exclude
	// stale data.
	GetBoundaryUsageSummary(ctx context.Context, maxStalenessMs int64) (GetBoundaryUsageSummaryRow, error)
	GetConnectionLogsOffset(ctx context.Context, arg GetConnectionLogsOffsetParams) ([]GetConnectionLogsOffsetRow, error)
	GetCoordinatorResumeTokenSigningKey(ctx context.Context) (string, error)
	GetCryptoKeyByFeatureAndSequence(ctx context.Context, arg GetCryptoKeyByFeatureAndSequenceParams) (CryptoKey, error)
	GetCryptoKeys(ctx context.Context) ([]CryptoKey, error)
	GetCryptoKeysByFeature(ctx context.Context, feature CryptoKeyFeature) ([]CryptoKey, error)
	GetDBCryptKeys(ctx context.Context) ([]DBCryptKey, error)
	GetDERPMeshKey(ctx context.Context) (string, error)
	GetDefaultOrganization(ctx context.Context) (Organization, error)
	GetDefaultProxyConfig(ctx context.Context) (GetDefaultProxyConfigRow, error)
	GetDeploymentDAUs(ctx context.Context, tzOffset int32) ([]GetDeploymentDAUsRow, error)
	GetDeploymentID(ctx context.Context) (string, error)
	GetDeploymentWorkspaceAgentStats(ctx context.Context, createdAt time.Time) (GetDeploymentWorkspaceAgentStatsRow, error)
	GetDeploymentWorkspaceAgentUsageStats(ctx context.Context, createdAt time.Time) (GetDeploymentWorkspaceAgentUsageStatsRow, error)
	GetDeploymentWorkspaceStats(ctx context.Context) (GetDeploymentWorkspaceStatsRow, error)
	GetEligibleProvisionerDaemonsByProvisionerJobIDs(ctx context.Context, provisionerJobIds []uuid.UUID) ([]GetEligibleProvisionerDaemonsByProvisionerJobIDsRow, error)
	GetExternalAuthLink(ctx context.Context, arg GetExternalAuthLinkParams) (ExternalAuthLink, error)
	GetExternalAuthLinksByUserID(ctx context.Context, userID uuid.UUID) ([]ExternalAuthLink, error)
	GetFailedWorkspaceBuildsByTemplateID(ctx context.Context, arg GetFailedWorkspaceBuildsByTemplateIDParams) ([]GetFailedWorkspaceBuildsByTemplateIDRow, error)
	GetFileByHashAndCreator(ctx context.Context, arg GetFileByHashAndCreatorParams) (File, error)
	GetFileByID(ctx context.Context, id uuid.UUID) (File, error)
	GetFileIDByTemplateVersionID(ctx context.Context, templateVersionID uuid.UUID) (uuid.UUID, error)
	// Get all templates that use a file.
	GetFileTemplates(ctx context.Context, fileID uuid.UUID) ([]GetFileTemplatesRow, error)
	// Fetches inbox notifications for a user filtered by templates and targets
	// param user_id: The user ID
	// param templates: The template IDs to filter by - the template_id = ANY(@templates::UUID[]) condition checks if the template_id is in the @templates array
	// param targets: The target IDs to filter by - the targets @> COALESCE(@targets, ARRAY[]::UUID[]) condition checks if the targets array (from the DB) contains all the elements in the @targets array
	// param read_status: The read status to filter by - can be any of 'ALL', 'UNREAD', 'READ'
	// param created_at_opt: The created_at timestamp to filter by. This parameter is usd for pagination - it fetches notifications created before the specified timestamp if it is not the zero value
	// param limit_opt: The limit of notifications to fetch. If the limit is not specified, it defaults to 25
	GetFilteredInboxNotificationsByUserID(ctx context.Context, arg GetFilteredInboxNotificationsByUserIDParams) ([]InboxNotification, error)
	GetGitSSHKey(ctx context.Context, userID uuid.UUID) (GitSSHKey, error)
	GetGroupByID(ctx context.Context, id uuid.UUID) (Group, error)
	GetGroupByOrgAndName(ctx context.Context, arg GetGroupByOrgAndNameParams) (Group, error)
	GetGroupMembers(ctx context.Context, includeSystem bool) ([]GroupMember, error)
	GetGroupMembersByGroupID(ctx context.Context, arg GetGroupMembersByGroupIDParams) ([]GroupMember, error)
	// Returns the total count of members in a group. Shows the total
	// count even if the caller does not have read access to ResourceGroupMember.
	// They only need ResourceGroup read access.
	GetGroupMembersCountByGroupID(ctx context.Context, arg GetGroupMembersCountByGroupIDParams) (int64, error)
	GetGroups(ctx context.Context, arg GetGroupsParams) ([]GetGroupsRow, error)
	GetHealthSettings(ctx context.Context) (string, error)
	GetInboxNotificationByID(ctx context.Context, id uuid.UUID) (InboxNotification, error)
	// Fetches inbox notifications for a user filtered by templates and targets
	// param user_id: The user ID
	// param read_status: The read status to filter by - can be any of 'ALL', 'UNREAD', 'READ'
	// param created_at_opt: The created_at timestamp to filter by. This parameter is usd for pagination - it fetches notifications created before the specified timestamp if it is not the zero value
	// param limit_opt: The limit of notifications to fetch. If the limit is not specified, it defaults to 25
	GetInboxNotificationsByUserID(ctx context.Context, arg GetInboxNotificationsByUserIDParams) ([]InboxNotification, error)
	GetLastUpdateCheck(ctx context.Context) (string, error)
	GetLatestCryptoKeyByFeature(ctx context.Context, feature CryptoKeyFeature) (CryptoKey, error)
	GetLatestWorkspaceAppStatusByAppID(ctx context.Context, appID uuid.UUID) (WorkspaceAppStatus, error)
	GetLatestWorkspaceAppStatusesByWorkspaceIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceAppStatus, error)
	GetLatestWorkspaceBuildByWorkspaceID(ctx context.Context, workspaceID uuid.UUID) (WorkspaceBuild, error)
	GetLatestWorkspaceBuildsByWorkspaceIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceBuild, error)
	GetLicenseByID(ctx context.Context, id int32) (License, error)
	GetLicenses(ctx context.Context) ([]License, error)
	GetLogoURL(ctx context.Context) (string, error)
	GetNotificationMessagesByStatus(ctx context.Context, arg GetNotificationMessagesByStatusParams) ([]NotificationMessage, error)
	// Fetch the notification report generator log indicating recent activity.
	GetNotificationReportGeneratorLogByTemplate(ctx context.Context, templateID uuid.UUID) (NotificationReportGeneratorLog, error)
	GetNotificationTemplateByID(ctx context.Context, id uuid.UUID) (NotificationTemplate, error)
	GetNotificationTemplatesByKind(ctx context.Context, kind NotificationTemplateKind) ([]NotificationTemplate, error)
	GetNotificationsSettings(ctx context.Context) (string, error)
	GetOAuth2GithubDefaultEligible(ctx context.Context) (bool, error)
	// RFC 7591/7592 Dynamic Client Registration queries
	GetOAuth2ProviderAppByClientID(ctx context.Context, id uuid.UUID) (OAuth2ProviderApp, error)
	GetOAuth2ProviderAppByID(ctx context.Context, id uuid.UUID) (OAuth2ProviderApp, error)
	GetOAuth2ProviderAppByRegistrationToken(ctx context.Context, registrationAccessToken []byte) (OAuth2ProviderApp, error)
	GetOAuth2ProviderAppCodeByID(ctx context.Context, id uuid.UUID) (OAuth2ProviderAppCode, error)
	GetOAuth2ProviderAppCodeByPrefix(ctx context.Context, secretPrefix []byte) (OAuth2ProviderAppCode, error)
	GetOAuth2ProviderAppSecretByID(ctx context.Context, id uuid.UUID) (OAuth2ProviderAppSecret, error)
	GetOAuth2ProviderAppSecretByPrefix(ctx context.Context, secretPrefix []byte) (OAuth2ProviderAppSecret, error)
	GetOAuth2ProviderAppSecretsByAppID(ctx context.Context, appID uuid.UUID) ([]OAuth2ProviderAppSecret, error)
	GetOAuth2ProviderAppTokenByAPIKeyID(ctx context.Context, apiKeyID string) (OAuth2ProviderAppToken, error)
	GetOAuth2ProviderAppTokenByPrefix(ctx context.Context, hashPrefix []byte) (OAuth2ProviderAppToken, error)
	GetOAuth2ProviderApps(ctx context.Context) ([]OAuth2ProviderApp, error)
	GetOAuth2ProviderAppsByUserID(ctx context.Context, userID uuid.UUID) ([]GetOAuth2ProviderAppsByUserIDRow, error)
	GetOAuthSigningKey(ctx context.Context) (string, error)
	GetOrganizationByID(ctx context.Context, id uuid.UUID) (Organization, error)
	GetOrganizationByName(ctx context.Context, arg GetOrganizationByNameParams) (Organization, error)
	GetOrganizationIDsByMemberIDs(ctx context.Context, ids []uuid.UUID) ([]GetOrganizationIDsByMemberIDsRow, error)
	GetOrganizationResourceCountByID(ctx context.Context, organizationID uuid.UUID) (GetOrganizationResourceCountByIDRow, error)
	GetOrganizations(ctx context.Context, arg GetOrganizationsParams) ([]Organization, error)
	GetOrganizationsByUserID(ctx context.Context, arg GetOrganizationsByUserIDParams) ([]Organization, error)
	// GetOrganizationsWithPrebuildStatus returns organizations with prebuilds configured and their
	// membership status for the prebuilds system user (org membership, group existence, group membership).
	GetOrganizationsWithPrebuildStatus(ctx context.Context, arg GetOrganizationsWithPrebuildStatusParams) ([]GetOrganizationsWithPrebuildStatusRow, error)
	GetParameterSchemasByJobID(ctx context.Context, jobID uuid.UUID) ([]ParameterSchema, error)
	GetPrebuildMetrics(ctx context.Context) ([]GetPrebuildMetricsRow, error)
	GetPrebuildsSettings(ctx context.Context) (string, error)
	GetPresetByID(ctx context.Context, presetID uuid.UUID) (GetPresetByIDRow, error)
	GetPresetByWorkspaceBuildID(ctx context.Context, workspaceBuildID uuid.UUID) (TemplateVersionPreset, error)
	GetPresetParametersByPresetID(ctx context.Context, presetID uuid.UUID) ([]TemplateVersionPresetParameter, error)
	GetPresetParametersByTemplateVersionID(ctx context.Context, templateVersionID uuid.UUID) ([]TemplateVersionPresetParameter, error)
	// GetPresetsAtFailureLimit groups workspace builds by preset ID.
	// Each preset is associated with exactly one template version ID.
	// For each preset, the query checks the last hard_limit builds.
	// If all of them failed, the preset is considered to have hit the hard failure limit.
	// The query returns a list of preset IDs that have reached this failure threshold.
	// Only active template versions with configured presets are considered.
	// For each preset, check the last hard_limit builds.
	// If all of them failed, the preset is considered to have hit the hard failure limit.
	GetPresetsAtFailureLimit(ctx context.Context, hardLimit int64) ([]GetPresetsAtFailureLimitRow, error)
	// GetPresetsBackoff groups workspace builds by preset ID.
	// Each preset is associated with exactly one template version ID.
	// For each group, the query checks up to N of the most recent jobs that occurred within the
	// lookback period, where N equals the number of desired instances for the corresponding preset.
	// If at least one of the job within a group has failed, we should backoff on the corresponding preset ID.
	// Query returns a list of preset IDs for which we should backoff.
	// Only active template versions with configured presets are considered.
	// We also return the number of failed workspace builds that occurred during the lookback period.
	//
	// NOTE:
	// - To **decide whether to back off**, we look at up to the N most recent builds (within the defined lookback period).
	// - To **calculate the number of failed builds**, we consider all builds within the defined lookback period.
	//
	// The number of failed builds is used downstream to determine the backoff duration.
	GetPresetsBackoff(ctx context.Context, lookback time.Time) ([]GetPresetsBackoffRow, error)
	GetPresetsByTemplateVersionID(ctx context.Context, templateVersionID uuid.UUID) ([]TemplateVersionPreset, error)
	GetPreviousTemplateVersion(ctx context.Context, arg GetPreviousTemplateVersionParams) (TemplateVersion, error)
	GetProvisionerDaemons(ctx context.Context) ([]ProvisionerDaemon, error)
	GetProvisionerDaemonsByOrganization(ctx context.Context, arg GetProvisionerDaemonsByOrganizationParams) ([]ProvisionerDaemon, error)
	// Current job information.
	// Previous job information.
	GetProvisionerDaemonsWithStatusByOrganization(ctx context.Context, arg GetProvisionerDaemonsWithStatusByOrganizationParams) ([]GetProvisionerDaemonsWithStatusByOrganizationRow, error)
	GetProvisionerJobByID(ctx context.Context, id uuid.UUID) (ProvisionerJob, error)
	// Gets a single provisioner job by ID for update.
	// This is used to securely reap jobs that have been hung/pending for a long time.
	GetProvisionerJobByIDForUpdate(ctx context.Context, id uuid.UUID) (ProvisionerJob, error)
	// Gets a provisioner job by ID with exclusive lock.
	// Blocks until the row is available for update.
	GetProvisionerJobByIDWithLock(ctx context.Context, id uuid.UUID) (ProvisionerJob, error)
	GetProvisionerJobTimingsByJobID(ctx context.Context, jobID uuid.UUID) ([]ProvisionerJobTiming, error)
	GetProvisionerJobsByIDs(ctx context.Context, ids []uuid.UUID) ([]ProvisionerJob, error)
	GetProvisionerJobsByIDsWithQueuePosition(ctx context.Context, arg GetProvisionerJobsByIDsWithQueuePositionParams) ([]GetProvisionerJobsByIDsWithQueuePositionRow, error)
	GetProvisionerJobsByOrganizationAndStatusWithQueuePositionAndProvisioner(ctx context.Context, arg GetProvisionerJobsByOrganizationAndStatusWithQueuePositionAndProvisionerParams) ([]GetProvisionerJobsByOrganizationAndStatusWithQueuePositionAndProvisionerRow, error)
	GetProvisionerJobsCreatedAfter(ctx context.Context, createdAt time.Time) ([]ProvisionerJob, error)
	// To avoid repeatedly attempting to reap the same jobs, we randomly order and limit to @max_jobs.
	GetProvisionerJobsToBeReaped(ctx context.Context, arg GetProvisionerJobsToBeReapedParams) ([]ProvisionerJob, error)
	GetProvisionerKeyByHashedSecret(ctx context.Context, hashedSecret []byte) (ProvisionerKey, error)
	GetProvisionerKeyByID(ctx context.Context, id uuid.UUID) (ProvisionerKey, error)
	GetProvisionerKeyByName(ctx context.Context, arg GetProvisionerKeyByNameParams) (ProvisionerKey, error)
	GetProvisionerLogsAfterID(ctx context.Context, arg GetProvisionerLogsAfterIDParams) ([]ProvisionerJobLog, error)
	GetQuotaAllowanceForUser(ctx context.Context, arg GetQuotaAllowanceForUserParams) (int64, error)
	GetQuotaConsumedForUser(ctx context.Context, arg GetQuotaConsumedForUserParams) (int64, error)
	// Count regular workspaces: only those whose first successful 'start' build
	// was not initiated by the prebuild system user.
	GetRegularWorkspaceCreateMetrics(ctx context.Context) ([]GetRegularWorkspaceCreateMetricsRow, error)
	GetReplicaByID(ctx context.Context, id uuid.UUID) (Replica, error)
	GetReplicasUpdatedAfter(ctx context.Context, updatedAt time.Time) ([]Replica, error)
	GetRunningPrebuiltWorkspaces(ctx context.Context) ([]GetRunningPrebuiltWorkspacesRow, error)
	GetRuntimeConfig(ctx context.Context, key string) (string, error)
	GetTailnetPeers(ctx context.Context, id uuid.UUID) ([]TailnetPeer, error)
	GetTailnetTunnelPeerBindings(ctx context.Context, srcID uuid.UUID) ([]GetTailnetTunnelPeerBindingsRow, error)
	GetTailnetTunnelPeerIDs(ctx context.Context, srcID uuid.UUID) ([]GetTailnetTunnelPeerIDsRow, error)
	GetTaskByID(ctx context.Context, id uuid.UUID) (Task, error)
	GetTaskByOwnerIDAndName(ctx context.Context, arg GetTaskByOwnerIDAndNameParams) (Task, error)
	GetTaskByWorkspaceID(ctx context.Context, workspaceID uuid.UUID) (Task, error)
	GetTaskSnapshot(ctx context.Context, taskID uuid.UUID) (TaskSnapshot, error)
	GetTelemetryItem(ctx context.Context, key string) (TelemetryItem, error)
	GetTelemetryItems(ctx context.Context) ([]TelemetryItem, error)
	// GetTemplateAppInsights returns the aggregate usage of each app in a given
	// timeframe. The result can be filtered on template_ids, meaning only user data
	// from workspaces based on those templates will be included.
	GetTemplateAppInsights(ctx context.Context, arg GetTemplateAppInsightsParams) ([]GetTemplateAppInsightsRow, error)
	// GetTemplateAppInsightsByTemplate is used for Prometheus metrics. Keep
	// in sync with GetTemplateAppInsights and UpsertTemplateUsageStats.
	GetTemplateAppInsightsByTemplate(ctx context.Context, arg GetTemplateAppInsightsByTemplateParams) ([]GetTemplateAppInsightsByTemplateRow, error)
	GetTemplateAverageBuildTime(ctx context.Context, templateID uuid.NullUUID) (GetTemplateAverageBuildTimeRow, error)
	GetTemplateByID(ctx context.Context, id uuid.UUID) (Template, error)
	GetTemplateByOrganizationAndName(ctx context.Context, arg GetTemplateByOrganizationAndNameParams) (Template, error)
	GetTemplateDAUs(ctx context.Context, arg GetTemplateDAUsParams) ([]GetTemplateDAUsRow, error)
	// GetTemplateInsights returns the aggregate user-produced usage of all
	// workspaces in a given timeframe. The template IDs, active users, and
	// usage_seconds all reflect any usage in the template, including apps.
	//
	// When combining data from multiple templates, we must make a guess at
	// how the user behaved for the 30 minute interval. In this case we make
	// the assumption that if the user used two workspaces for 15 minutes,
	// they did so sequentially, thus we sum the usage up to a maximum of
	// 30 minutes with LEAST(SUM(n), 30).
	GetTemplateInsights(ctx context.Context, arg GetTemplateInsightsParams) (GetTemplateInsightsRow, error)
	// GetTemplateInsightsByInterval returns all intervals between start and end
	// time, if end time is a partial interval, it will be included in the results and
	// that interval will be shorter than a full one. If there is no data for a selected
	// interval/template, it will be included in the results with 0 active users.
	GetTemplateInsightsByInterval(ctx context.Context, arg GetTemplateInsightsByIntervalParams) ([]GetTemplateInsightsByIntervalRow, error)
	// GetTemplateInsightsByTemplate is used for Prometheus metrics. Keep
	// in sync with GetTemplateInsights and UpsertTemplateUsageStats.
	GetTemplateInsightsByTemplate(ctx context.Context, arg GetTemplateInsightsByTemplateParams) ([]GetTemplateInsightsByTemplateRow, error)
	// GetTemplateParameterInsights does for each template in a given timeframe,
	// look for the latest workspace build (for every workspace) that has been
	// created in the timeframe and return the aggregate usage counts of parameter
	// values.
	GetTemplateParameterInsights(ctx context.Context, arg GetTemplateParameterInsightsParams) ([]GetTemplateParameterInsightsRow, error)
	// GetTemplatePresetsWithPrebuilds retrieves template versions with configured presets and prebuilds.
	// It also returns the number of desired instances for each preset.
	// If template_id is specified, only template versions associated with that template will be returned.
	GetTemplatePresetsWithPrebuilds(ctx context.Context, templateID uuid.NullUUID) ([]GetTemplatePresetsWithPrebuildsRow, error)
	GetTemplateUsageStats(ctx context.Context, arg GetTemplateUsageStatsParams) ([]TemplateUsageStat, error)
	GetTemplateVersionByID(ctx context.Context, id uuid.UUID) (TemplateVersion, error)
	GetTemplateVersionByJobID(ctx context.Context, jobID uuid.UUID) (TemplateVersion, error)
	GetTemplateVersionByTemplateIDAndName(ctx context.Context, arg GetTemplateVersionByTemplateIDAndNameParams) (TemplateVersion, error)
	GetTemplateVersionHasAITask(ctx context.Context, id uuid.UUID) (bool, error)
	GetTemplateVersionParameters(ctx context.Context, templateVersionID uuid.UUID) ([]TemplateVersionParameter, error)
	GetTemplateVersionTerraformValues(ctx context.Context, templateVersionID uuid.UUID) (TemplateVersionTerraformValue, error)
	GetTemplateVersionVariables(ctx context.Context, templateVersionID uuid.UUID) ([]TemplateVersionVariable, error)
	GetTemplateVersionWorkspaceTags(ctx context.Context, templateVersionID uuid.UUID) ([]TemplateVersionWorkspaceTag, error)
	GetTemplateVersionsByIDs(ctx context.Context, ids []uuid.UUID) ([]TemplateVersion, error)
	GetTemplateVersionsByTemplateID(ctx context.Context, arg GetTemplateVersionsByTemplateIDParams) ([]TemplateVersion, error)
	GetTemplateVersionsCreatedAfter(ctx context.Context, createdAt time.Time) ([]TemplateVersion, error)
	GetTemplates(ctx context.Context) ([]Template, error)
	GetTemplatesWithFilter(ctx context.Context, arg GetTemplatesWithFilterParams) ([]Template, error)
	// Gets the total number of managed agents created between two dates. Uses the
	// aggregate table to avoid large scans or a complex index on the usage_events
	// table.
	//
	// This has the trade off that we can't count accurately between two exact
	// timestamps. The provided timestamps will be converted to UTC and truncated to
	// the events that happened on and between the two dates. Both dates are
	// inclusive.
	GetTotalUsageDCManagedAgentsV1(ctx context.Context, arg GetTotalUsageDCManagedAgentsV1Params) (int64, error)
	GetUnexpiredLicenses(ctx context.Context) ([]License, error)
	// GetUserActivityInsights returns the ranking with top active users.
	// The result can be filtered on template_ids, meaning only user data
	// from workspaces based on those templates will be included.
	// Note: The usage_seconds and usage_seconds_cumulative differ only when
	// requesting deployment-wide (or multiple template) data. Cumulative
	// produces a bloated value if a user has used multiple templates
	// simultaneously.
	GetUserActivityInsights(ctx context.Context, arg GetUserActivityInsightsParams) ([]GetUserActivityInsightsRow, error)
	GetUserByEmailOrUsername(ctx context.Context, arg GetUserByEmailOrUsernameParams) (User, error)
	GetUserByID(ctx context.Context, id uuid.UUID) (User, error)
	GetUserCount(ctx context.Context, includeSystem bool) (int64, error)
	// GetUserLatencyInsights returns the median and 95th percentile connection
	// latency that users have experienced. The result can be filtered on
	// template_ids, meaning only user data from workspaces based on those templates
	// will be included.
	GetUserLatencyInsights(ctx context.Context, arg GetUserLatencyInsightsParams) ([]GetUserLatencyInsightsRow, error)
	GetUserLinkByLinkedID(ctx context.Context, linkedID string) (UserLink, error)
	GetUserLinkByUserIDLoginType(ctx context.Context, arg GetUserLinkByUserIDLoginTypeParams) (UserLink, error)
	GetUserLinksByUserID(ctx context.Context, userID uuid.UUID) ([]UserLink, error)
	GetUserNotificationPreferences(ctx context.Context, userID uuid.UUID) ([]NotificationPreference, error)
	GetUserSecret(ctx context.Context, id uuid.UUID) (UserSecret, error)
	GetUserSecretByUserIDAndName(ctx context.Context, arg GetUserSecretByUserIDAndNameParams) (UserSecret, error)
	// GetUserStatusCounts returns the count of users in each status over time.
	// The time range is inclusively defined by the start_time and end_time parameters.
	//
	// Bucketing:
	// Between the start_time and end_time, we include each timestamp where a user's status changed or they were deleted.
	// We do not bucket these results by day or some other time unit. This is because such bucketing would hide potentially
	// important patterns. If a user was active for 23 hours and 59 minutes, and then suspended, a daily bucket would hide this.
	// A daily bucket would also have required us to carefully manage the timezone of the bucket based on the timezone of the user.
	//
	// Accumulation:
	// We do not start counting from 0 at the start_time. We check the last status change before the start_time for each user. As such,
	// the result shows the total number of users in each status on any particular day.
	GetUserStatusCounts(ctx context.Context, arg GetUserStatusCountsParams) ([]GetUserStatusCountsRow, error)
	GetUserTaskNotificationAlertDismissed(ctx context.Context, userID uuid.UUID) (bool, error)
	GetUserTerminalFont(ctx context.Context, userID uuid.UUID) (string, error)
	GetUserThemePreference(ctx context.Context, userID uuid.UUID) (string, error)
	GetUserWorkspaceBuildParameters(ctx context.Context, arg GetUserWorkspaceBuildParametersParams) ([]GetUserWorkspaceBuildParametersRow, error)
	// This will never return deleted users.
	GetUsers(ctx context.Context, arg GetUsersParams) ([]GetUsersRow, error)
	// This shouldn't check for deleted, because it's frequently used
	// to look up references to actions. eg. a user could build a workspace
	// for another user, then be deleted... we still want them to appear!
	GetUsersByIDs(ctx context.Context, ids []uuid.UUID) ([]User, error)
	GetWebpushSubscriptionsByUserID(ctx context.Context, userID uuid.UUID) ([]WebpushSubscription, error)
	GetWebpushVAPIDKeys(ctx context.Context) (GetWebpushVAPIDKeysRow, error)
	GetWorkspaceACLByID(ctx context.Context, id uuid.UUID) (GetWorkspaceACLByIDRow, error)
	GetWorkspaceAgentAndWorkspaceByID(ctx context.Context, id uuid.UUID) (GetWorkspaceAgentAndWorkspaceByIDRow, error)
	GetWorkspaceAgentByID(ctx context.Context, id uuid.UUID) (WorkspaceAgent, error)
	GetWorkspaceAgentByInstanceID(ctx context.Context, authInstanceID string) (WorkspaceAgent, error)
	GetWorkspaceAgentDevcontainersByAgentID(ctx context.Context, workspaceAgentID uuid.UUID) ([]WorkspaceAgentDevcontainer, error)
	GetWorkspaceAgentLifecycleStateByID(ctx context.Context, id uuid.UUID) (GetWorkspaceAgentLifecycleStateByIDRow, error)
	GetWorkspaceAgentLogSourcesByAgentIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceAgentLogSource, error)
	GetWorkspaceAgentLogsAfter(ctx context.Context, arg GetWorkspaceAgentLogsAfterParams) ([]WorkspaceAgentLog, error)
	GetWorkspaceAgentMetadata(ctx context.Context, arg GetWorkspaceAgentMetadataParams) ([]WorkspaceAgentMetadatum, error)
	GetWorkspaceAgentPortShare(ctx context.Context, arg GetWorkspaceAgentPortShareParams) (WorkspaceAgentPortShare, error)
	GetWorkspaceAgentScriptTimingsByBuildID(ctx context.Context, id uuid.UUID) ([]GetWorkspaceAgentScriptTimingsByBuildIDRow, error)
	GetWorkspaceAgentScriptsByAgentIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceAgentScript, error)
	GetWorkspaceAgentStats(ctx context.Context, createdAt time.Time) ([]GetWorkspaceAgentStatsRow, error)
	GetWorkspaceAgentStatsAndLabels(ctx context.Context, createdAt time.Time) ([]GetWorkspaceAgentStatsAndLabelsRow, error)
	// `minute_buckets` could return 0 rows if there are no usage stats since `created_at`.
	GetWorkspaceAgentUsageStats(ctx context.Context, createdAt time.Time) ([]GetWorkspaceAgentUsageStatsRow, error)
	GetWorkspaceAgentUsageStatsAndLabels(ctx context.Context, createdAt time.Time) ([]GetWorkspaceAgentUsageStatsAndLabelsRow, error)
	GetWorkspaceAgentsByParentID(ctx context.Context, parentID uuid.UUID) ([]WorkspaceAgent, error)
	GetWorkspaceAgentsByResourceIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceAgent, error)
	GetWorkspaceAgentsByWorkspaceAndBuildNumber(ctx context.Context, arg GetWorkspaceAgentsByWorkspaceAndBuildNumberParams) ([]WorkspaceAgent, error)
	GetWorkspaceAgentsCreatedAfter(ctx context.Context, createdAt time.Time) ([]WorkspaceAgent, error)
	GetWorkspaceAgentsForMetrics(ctx context.Context) ([]GetWorkspaceAgentsForMetricsRow, error)
	GetWorkspaceAgentsInLatestBuildByWorkspaceID(ctx context.Context, workspaceID uuid.UUID) ([]WorkspaceAgent, error)
	GetWorkspaceAppByAgentIDAndSlug(ctx context.Context, arg GetWorkspaceAppByAgentIDAndSlugParams) (WorkspaceApp, error)
	GetWorkspaceAppStatusesByAppIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceAppStatus, error)
	GetWorkspaceAppsByAgentID(ctx context.Context, agentID uuid.UUID) ([]WorkspaceApp, error)
	GetWorkspaceAppsByAgentIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceApp, error)
	GetWorkspaceAppsCreatedAfter(ctx context.Context, createdAt time.Time) ([]WorkspaceApp, error)
	GetWorkspaceBuildByID(ctx context.Context, id uuid.UUID) (WorkspaceBuild, error)
	GetWorkspaceBuildByJobID(ctx context.Context, jobID uuid.UUID) (WorkspaceBuild, error)
	GetWorkspaceBuildByWorkspaceIDAndBuildNumber(ctx context.Context, arg GetWorkspaceBuildByWorkspaceIDAndBuildNumberParams) (WorkspaceBuild, error)
	GetWorkspaceBuildParameters(ctx context.Context, workspaceBuildID uuid.UUID) ([]WorkspaceBuildParameter, error)
	GetWorkspaceBuildParametersByBuildIDs(ctx context.Context, workspaceBuildIds []uuid.UUID) ([]WorkspaceBuildParameter, error)
	GetWorkspaceBuildStatsByTemplates(ctx context.Context, since time.Time) ([]GetWorkspaceBuildStatsByTemplatesRow, error)
	GetWorkspaceBuildsByWorkspaceID(ctx context.Context, arg GetWorkspaceBuildsByWorkspaceIDParams) ([]WorkspaceBuild, error)
	GetWorkspaceBuildsCreatedAfter(ctx context.Context, createdAt time.Time) ([]WorkspaceBuild, error)
	GetWorkspaceByAgentID(ctx context.Context, agentID uuid.UUID) (Workspace, error)
	GetWorkspaceByID(ctx context.Context, id uuid.UUID) (Workspace, error)
	GetWorkspaceByOwnerIDAndName(ctx context.Context, arg GetWorkspaceByOwnerIDAndNameParams) (Workspace, error)
	GetWorkspaceByResourceID(ctx context.Context, resourceID uuid.UUID) (Workspace, error)
	GetWorkspaceByWorkspaceAppID(ctx context.Context, workspaceAppID uuid.UUID) (Workspace, error)
	GetWorkspaceModulesByJobID(ctx context.Context, jobID uuid.UUID) ([]WorkspaceModule, error)
	GetWorkspaceModulesCreatedAfter(ctx context.Context, createdAt time.Time) ([]WorkspaceModule, error)
	GetWorkspaceProxies(ctx context.Context) ([]WorkspaceProxy, error)
	// Finds a workspace proxy that has an access URL or app hostname that matches
	// the provided hostname. This is to check if a hostname matches any workspace
	// proxy.
	//
	// The hostname must be sanitized to only contain [a-zA-Z0-9.-] before calling
	// this query. The scheme, port and path should be stripped.
	//
	GetWorkspaceProxyByHostname(ctx context.Context, arg GetWorkspaceProxyByHostnameParams) (WorkspaceProxy, error)
	GetWorkspaceProxyByID(ctx context.Context, id uuid.UUID) (WorkspaceProxy, error)
	GetWorkspaceProxyByName(ctx context.Context, name string) (WorkspaceProxy, error)
	GetWorkspaceResourceByID(ctx context.Context, id uuid.UUID) (WorkspaceResource, error)
	GetWorkspaceResourceMetadataByResourceIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceResourceMetadatum, error)
	GetWorkspaceResourceMetadataCreatedAfter(ctx context.Context, createdAt time.Time) ([]WorkspaceResourceMetadatum, error)
	GetWorkspaceResourcesByJobID(ctx context.Context, jobID uuid.UUID) ([]WorkspaceResource, error)
	GetWorkspaceResourcesByJobIDs(ctx context.Context, ids []uuid.UUID) ([]WorkspaceResource, error)
	GetWorkspaceResourcesCreatedAfter(ctx context.Context, createdAt time.Time) ([]WorkspaceResource, error)
	GetWorkspaceUniqueOwnerCountByTemplateIDs(ctx context.Context, templateIds []uuid.UUID) ([]GetWorkspaceUniqueOwnerCountByTemplateIDsRow, error)
	// build_params is used to filter by build parameters if present.
	// It has to be a CTE because the set returning function 'unnest' cannot
	// be used in a WHERE clause.
	GetWorkspaces(ctx context.Context, arg GetWorkspacesParams) ([]GetWorkspacesRow, error)
	GetWorkspacesAndAgentsByOwnerID(ctx context.Context, ownerID uuid.UUID) ([]GetWorkspacesAndAgentsByOwnerIDRow, error)
	GetWorkspacesByTemplateID(ctx context.Context, templateID uuid.UUID) ([]WorkspaceTable, error)
	GetWorkspacesEligibleForTransition(ctx context.Context, now time.Time) ([]GetWorkspacesEligibleForTransitionRow, error)
	GetWorkspacesForWorkspaceMetrics(ctx context.Context) ([]GetWorkspacesForWorkspaceMetricsRow, error)
	InsertAIBridgeInterception(ctx context.Context, arg InsertAIBridgeInterceptionParams) (AIBridgeInterception, error)
	InsertAIBridgeTokenUsage(ctx context.Context, arg InsertAIBridgeTokenUsageParams) (AIBridgeTokenUsage, error)
	InsertAIBridgeToolUsage(ctx context.Context, arg InsertAIBridgeToolUsageParams) (AIBridgeToolUsage, error)
	InsertAIBridgeUserPrompt(ctx context.Context, arg InsertAIBridgeUserPromptParams) (AIBridgeUserPrompt, error)
	InsertAPIKey(ctx context.Context, arg InsertAPIKeyParams) (APIKey, error)
	// We use the organization_id as the id
	// for simplicity since all users is
	// every member of the org.
	InsertAllUsersGroup(ctx context.Context, organizationID uuid.UUID) (Group, error)
	InsertAuditLog(ctx context.Context, arg InsertAuditLogParams) (AuditLog, error)
	InsertCryptoKey(ctx context.Context, arg InsertCryptoKeyParams) (CryptoKey, error)
	InsertCustomRole(ctx context.Context, arg InsertCustomRoleParams) (CustomRole, error)
	InsertDBCryptKey(ctx context.Context, arg InsertDBCryptKeyParams) error
	InsertDERPMeshKey(ctx context.Context, value string) error
	InsertDeploymentID(ctx context.Context, value string) error
	InsertExternalAuthLink(ctx context.Context, arg InsertExternalAuthLinkParams) (ExternalAuthLink, error)
	InsertFile(ctx context.Context, arg InsertFileParams) (File, error)
	InsertGitSSHKey(ctx context.Context, arg InsertGitSSHKeyParams) (GitSSHKey, error)
	InsertGroup(ctx context.Context, arg InsertGroupParams) (Group, error)
	InsertGroupMember(ctx context.Context, arg InsertGroupMemberParams) error
	InsertInboxNotification(ctx context.Context, arg InsertInboxNotificationParams) (InboxNotification, error)
	InsertLicense(ctx context.Context, arg InsertLicenseParams) (License, error)
	InsertMemoryResourceMonitor(ctx context.Context, arg InsertMemoryResourceMonitorParams) (WorkspaceAgentMemoryResourceMonitor, error)
	// Inserts any group by name that does not exist. All new groups are given
	// a random uuid, are inserted into the same organization. They have the default
	// values for avatar, display name, and quota allowance (all zero values).
	// If the name conflicts, do nothing.
	InsertMissingGroups(ctx context.Context, arg InsertMissingGroupsParams) ([]Group, error)
	InsertOAuth2ProviderApp(ctx context.Context, arg InsertOAuth2ProviderAppParams) (OAuth2ProviderApp, error)
	InsertOAuth2ProviderAppCode(ctx context.Context, arg InsertOAuth2ProviderAppCodeParams) (OAuth2ProviderAppCode, error)
	InsertOAuth2ProviderAppSecret(ctx context.Context, arg InsertOAuth2ProviderAppSecretParams) (OAuth2ProviderAppSecret, error)
	InsertOAuth2ProviderAppToken(ctx context.Context, arg InsertOAuth2ProviderAppTokenParams) (OAuth2ProviderAppToken, error)
	InsertOrganization(ctx context.Context, arg InsertOrganizationParams) (Organization, error)
	InsertOrganizationMember(ctx context.Context, arg InsertOrganizationMemberParams) (OrganizationMember, error)
	InsertPreset(ctx context.Context, arg InsertPresetParams) (TemplateVersionPreset, error)
	InsertPresetParameters(ctx context.Context, arg InsertPresetParametersParams) ([]TemplateVersionPresetParameter, error)
	InsertPresetPrebuildSchedule(ctx context.Context, arg InsertPresetPrebuildScheduleParams) (TemplateVersionPresetPrebuildSchedule, error)
	InsertProvisionerJob(ctx context.Context, arg InsertProvisionerJobParams) (ProvisionerJob, error)
	InsertProvisionerJobLogs(ctx context.Context, arg InsertProvisionerJobLogsParams) ([]ProvisionerJobLog, error)
	InsertProvisionerJobTimings(ctx context.Context, arg InsertProvisionerJobTimingsParams) ([]ProvisionerJobTiming, error)
	InsertProvisionerKey(ctx context.Context, arg InsertProvisionerKeyParams) (ProvisionerKey, error)
	InsertReplica(ctx context.Context, arg InsertReplicaParams) (Replica, error)
	InsertTask(ctx context.Context, arg InsertTaskParams) (TaskTable, error)
	InsertTelemetryItemIfNotExists(ctx context.Context, arg InsertTelemetryItemIfNotExistsParams) error
	// Inserts a new lock row into the telemetry_locks table. Replicas should call
	// this function prior to attempting to generate or publish a heartbeat event to
	// the telemetry service.
	// If the query returns a duplicate primary key error, the replica should not
	// attempt to generate or publish the event to the telemetry service.
	InsertTelemetryLock(ctx context.Context, arg InsertTelemetryLockParams) error
	InsertTemplate(ctx context.Context, arg InsertTemplateParams) error
	InsertTemplateVersion(ctx context.Context, arg InsertTemplateVersionParams) error
	InsertTemplateVersionParameter(ctx context.Context, arg InsertTemplateVersionParameterParams) (TemplateVersionParameter, error)
	InsertTemplateVersionTerraformValuesByJobID(ctx context.Context, arg InsertTemplateVersionTerraformValuesByJobIDParams) error
	InsertTemplateVersionVariable(ctx context.Context, arg InsertTemplateVersionVariableParams) (TemplateVersionVariable, error)
	InsertTemplateVersionWorkspaceTag(ctx context.Context, arg InsertTemplateVersionWorkspaceTagParams) (TemplateVersionWorkspaceTag, error)
	// Duplicate events are ignored intentionally to allow for multiple replicas to
	// publish heartbeat events.
	InsertUsageEvent(ctx context.Context, arg InsertUsageEventParams) error
	InsertUser(ctx context.Context, arg InsertUserParams) (User, error)
	// InsertUserGroupsByID adds a user to all provided groups, if they exist.
	// If there is a conflict, the user is already a member
	InsertUserGroupsByID(ctx context.Context, arg InsertUserGroupsByIDParams) ([]uuid.UUID, error)
	// InsertUserGroupsByName adds a user to all provided groups, if they exist.
	InsertUserGroupsByName(ctx context.Context, arg InsertUserGroupsByNameParams) error
	InsertUserLink(ctx context.Context, arg InsertUserLinkParams) (UserLink, error)
	InsertVolumeResourceMonitor(ctx context.Context, arg InsertVolumeResourceMonitorParams) (WorkspaceAgentVolumeResourceMonitor, error)
	InsertWebpushSubscription(ctx context.Context, arg InsertWebpushSubscriptionParams) (WebpushSubscription, error)
	InsertWorkspace(ctx context.Context, arg InsertWorkspaceParams) (WorkspaceTable, error)
	InsertWorkspaceAgent(ctx context.Context, arg InsertWorkspaceAgentParams) (WorkspaceAgent, error)
	InsertWorkspaceAgentDevcontainers(ctx context.Context, arg InsertWorkspaceAgentDevcontainersParams) ([]WorkspaceAgentDevcontainer, error)
	InsertWorkspaceAgentLogSources(ctx context.Context, arg InsertWorkspaceAgentLogSourcesParams) ([]WorkspaceAgentLogSource, error)
	InsertWorkspaceAgentLogs(ctx context.Context, arg InsertWorkspaceAgentLogsParams) ([]WorkspaceAgentLog, error)
	InsertWorkspaceAgentMetadata(ctx context.Context, arg InsertWorkspaceAgentMetadataParams) error
	InsertWorkspaceAgentScriptTimings(ctx context.Context, arg InsertWorkspaceAgentScriptTimingsParams) (WorkspaceAgentScriptTiming, error)
	InsertWorkspaceAgentScripts(ctx context.Context, arg InsertWorkspaceAgentScriptsParams) ([]WorkspaceAgentScript, error)
	InsertWorkspaceAgentStats(ctx context.Context, arg InsertWorkspaceAgentStatsParams) error
	InsertWorkspaceAppStats(ctx context.Context, arg InsertWorkspaceAppStatsParams) error
	InsertWorkspaceAppStatus(ctx context.Context, arg InsertWorkspaceAppStatusParams) (WorkspaceAppStatus, error)
	InsertWorkspaceBuild(ctx context.Context, arg InsertWorkspaceBuildParams) error
	InsertWorkspaceBuildParameters(ctx context.Context, arg InsertWorkspaceBuildParametersParams) error
	InsertWorkspaceModule(ctx context.Context, arg InsertWorkspaceModuleParams) (WorkspaceModule, error)
	InsertWorkspaceProxy(ctx context.Context, arg InsertWorkspaceProxyParams) (WorkspaceProxy, error)
	InsertWorkspaceResource(ctx context.Context, arg InsertWorkspaceResourceParams) (WorkspaceResource, error)
	InsertWorkspaceResourceMetadata(ctx context.Context, arg InsertWorkspaceResourceMetadataParams) ([]WorkspaceResourceMetadatum, error)
	ListAIBridgeInterceptions(ctx context.Context, arg ListAIBridgeInterceptionsParams) ([]ListAIBridgeInterceptionsRow, error)
	// Finds all unique AI Bridge interception telemetry summaries combinations
	// (provider, model, client) in the given timeframe for telemetry reporting.
	ListAIBridgeInterceptionsTelemetrySummaries(ctx context.Context, arg ListAIBridgeInterceptionsTelemetrySummariesParams) ([]ListAIBridgeInterceptionsTelemetrySummariesRow, error)
	ListAIBridgeTokenUsagesByInterceptionIDs(ctx context.Context, interceptionIds []uuid.UUID) ([]AIBridgeTokenUsage, error)
	ListAIBridgeToolUsagesByInterceptionIDs(ctx context.Context, interceptionIds []uuid.UUID) ([]AIBridgeToolUsage, error)
	ListAIBridgeUserPromptsByInterceptionIDs(ctx context.Context, interceptionIds []uuid.UUID) ([]AIBridgeUserPrompt, error)
	ListProvisionerKeysByOrganization(ctx context.Context, organizationID uuid.UUID) ([]ProvisionerKey, error)
	ListProvisionerKeysByOrganizationExcludeReserved(ctx context.Context, organizationID uuid.UUID) ([]ProvisionerKey, error)
	ListTasks(ctx context.Context, arg ListTasksParams) ([]Task, error)
	ListUserSecrets(ctx context.Context, userID uuid.UUID) ([]UserSecret, error)
	ListWorkspaceAgentPortShares(ctx context.Context, workspaceID uuid.UUID) ([]WorkspaceAgentPortShare, error)
	MarkAllInboxNotificationsAsRead(ctx context.Context, arg MarkAllInboxNotificationsAsReadParams) error
	OIDCClaimFieldValues(ctx context.Context, arg OIDCClaimFieldValuesParams) ([]string, error)
	// OIDCClaimFields returns a list of distinct keys in the the merged_claims fields.
	// This query is used to generate the list of available sync fields for idp sync settings.
	OIDCClaimFields(ctx context.Context, organizationID uuid.UUID) ([]string, error)
	// Arguments are optional with uuid.Nil to ignore.
	//  - Use just 'organization_id' to get all members of an org
	//  - Use just 'user_id' to get all orgs a user is a member of
	//  - Use both to get a specific org member row
	OrganizationMembers(ctx context.Context, arg OrganizationMembersParams) ([]OrganizationMembersRow, error)
	PaginatedOrganizationMembers(ctx context.Context, arg PaginatedOrganizationMembersParams) ([]PaginatedOrganizationMembersRow, error)
	ReduceWorkspaceAgentShareLevelToAuthenticatedByTemplate(ctx context.Context, templateID uuid.UUID) error
	RegisterWorkspaceProxy(ctx context.Context, arg RegisterWorkspaceProxyParams) (WorkspaceProxy, error)
	RemoveUserFromAllGroups(ctx context.Context, userID uuid.UUID) error
	RemoveUserFromGroups(ctx context.Context, arg RemoveUserFromGroupsParams) ([]uuid.UUID, error)
	// Deletes all boundary usage statistics. Called after telemetry reports the
	// aggregated stats. Each replica will insert a fresh row on its next flush.
	ResetBoundaryUsageStats(ctx context.Context) error
	RevokeDBCryptKey(ctx context.Context, activeKeyDigest string) error
	// Note that this selects from the CTE, not the original table. The CTE is named
	// the same as the original table to trick sqlc into reusing the existing struct
	// for the table.
	// The CTE and the reorder is required because UPDATE doesn't guarantee order.
	SelectUsageEventsForPublishing(ctx context.Context, now time.Time) ([]UsageEvent, error)
	// Non blocking lock. Returns true if the lock was acquired, false otherwise.
	//
	// This must be called from within a transaction. The lock will be automatically
	// released when the transaction ends.
	TryAcquireLock(ctx context.Context, pgTryAdvisoryXactLock int64) (bool, error)
	// This will always work regardless of the current state of the template version.
	UnarchiveTemplateVersion(ctx context.Context, arg UnarchiveTemplateVersionParams) error
	UnfavoriteWorkspace(ctx context.Context, id uuid.UUID) error
	UpdateAIBridgeInterceptionEnded(ctx context.Context, arg UpdateAIBridgeInterceptionEndedParams) (AIBridgeInterception, error)
	UpdateAPIKeyByID(ctx context.Context, arg UpdateAPIKeyByIDParams) error
	UpdateCryptoKeyDeletesAt(ctx context.Context, arg UpdateCryptoKeyDeletesAtParams) (CryptoKey, error)
	UpdateCustomRole(ctx context.Context, arg UpdateCustomRoleParams) (CustomRole, error)
	UpdateExternalAuthLink(ctx context.Context, arg UpdateExternalAuthLinkParams) (ExternalAuthLink, error)
	UpdateExternalAuthLinkRefreshToken(ctx context.Context, arg UpdateExternalAuthLinkRefreshTokenParams) error
	UpdateGitSSHKey(ctx context.Context, arg UpdateGitSSHKeyParams) (GitSSHKey, error)
	UpdateGroupByID(ctx context.Context, arg UpdateGroupByIDParams) (Group, error)
	UpdateInactiveUsersToDormant(ctx context.Context, arg UpdateInactiveUsersToDormantParams) ([]UpdateInactiveUsersToDormantRow, error)
	UpdateInboxNotificationReadStatus(ctx context.Context, arg UpdateInboxNotificationReadStatusParams) error
	UpdateMemberRoles(ctx context.Context, arg UpdateMemberRolesParams) (OrganizationMember, error)
	UpdateMemoryResourceMonitor(ctx context.Context, arg UpdateMemoryResourceMonitorParams) error
	UpdateNotificationTemplateMethodByID(ctx context.Context, arg UpdateNotificationTemplateMethodByIDParams) (NotificationTemplate, error)
	UpdateOAuth2ProviderAppByClientID(ctx context.Context, arg UpdateOAuth2ProviderAppByClientIDParams) (OAuth2ProviderApp, error)
	UpdateOAuth2ProviderAppByID(ctx context.Context, arg UpdateOAuth2ProviderAppByIDParams) (OAuth2ProviderApp, error)
	UpdateOAuth2ProviderAppSecretByID(ctx context.Context, arg UpdateOAuth2ProviderAppSecretByIDParams) (OAuth2ProviderAppSecret, error)
	UpdateOrganization(ctx context.Context, arg UpdateOrganizationParams) (Organization, error)
	UpdateOrganizationDeletedByID(ctx context.Context, arg UpdateOrganizationDeletedByIDParams) error
	UpdateOrganizationWorkspaceSharingSettings(ctx context.Context, arg UpdateOrganizationWorkspaceSharingSettingsParams) (Organization, error)
	// Cancels all pending provisioner jobs for prebuilt workspaces on a specific preset from an
	// inactive template version.
	// This is an optimization to clean up stale pending jobs.
	UpdatePrebuildProvisionerJobWithCancel(ctx context.Context, arg UpdatePrebuildProvisionerJobWithCancelParams) ([]UpdatePrebuildProvisionerJobWithCancelRow, error)
	UpdatePresetPrebuildStatus(ctx context.Context, arg UpdatePresetPrebuildStatusParams) error
	UpdatePresetsLastInvalidatedAt(ctx context.Context, arg UpdatePresetsLastInvalidatedAtParams) ([]UpdatePresetsLastInvalidatedAtRow, error)
	UpdateProvisionerDaemonLastSeenAt(ctx context.Context, arg UpdateProvisionerDaemonLastSeenAtParams) error
	UpdateProvisionerJobByID(ctx context.Context, arg UpdateProvisionerJobByIDParams) error
	UpdateProvisionerJobLogsLength(ctx context.Context, arg UpdateProvisionerJobLogsLengthParams) error
	UpdateProvisionerJobLogsOverflowed(ctx context.Context, arg UpdateProvisionerJobLogsOverflowedParams) error
	UpdateProvisionerJobWithCancelByID(ctx context.Context, arg UpdateProvisionerJobWithCancelByIDParams) error
	UpdateProvisionerJobWithCompleteByID(ctx context.Context, arg UpdateProvisionerJobWithCompleteByIDParams) error
	UpdateProvisionerJobWithCompleteWithStartedAtByID(ctx context.Context, arg UpdateProvisionerJobWithCompleteWithStartedAtByIDParams) error
	UpdateReplica(ctx context.Context, arg UpdateReplicaParams) (Replica, error)
	UpdateTailnetPeerStatusByCoordinator(ctx context.Context, arg UpdateTailnetPeerStatusByCoordinatorParams) error
	UpdateTaskPrompt(ctx context.Context, arg UpdateTaskPromptParams) (TaskTable, error)
	UpdateTaskWorkspaceID(ctx context.Context, arg UpdateTaskWorkspaceIDParams) (TaskTable, error)
	UpdateTemplateACLByID(ctx context.Context, arg UpdateTemplateACLByIDParams) error
	UpdateTemplateAccessControlByID(ctx context.Context, arg UpdateTemplateAccessControlByIDParams) error
	UpdateTemplateActiveVersionByID(ctx context.Context, arg UpdateTemplateActiveVersionByIDParams) error
	UpdateTemplateDeletedByID(ctx context.Context, arg UpdateTemplateDeletedByIDParams) error
	UpdateTemplateMetaByID(ctx context.Context, arg UpdateTemplateMetaByIDParams) error
	UpdateTemplateScheduleByID(ctx context.Context, arg UpdateTemplateScheduleByIDParams) error
	UpdateTemplateVersionByID(ctx context.Context, arg UpdateTemplateVersionByIDParams) error
	UpdateTemplateVersionDescriptionByJobID(ctx context.Context, arg UpdateTemplateVersionDescriptionByJobIDParams) error
	UpdateTemplateVersionExternalAuthProvidersByJobID(ctx context.Context, arg UpdateTemplateVersionExternalAuthProvidersByJobIDParams) error
	UpdateTemplateVersionFlagsByJobID(ctx context.Context, arg UpdateTemplateVersionFlagsByJobIDParams) error
	UpdateTemplateWorkspacesLastUsedAt(ctx context.Context, arg UpdateTemplateWorkspacesLastUsedAtParams) error
	UpdateUsageEventsPostPublish(ctx context.Context, arg UpdateUsageEventsPostPublishParams) error
	UpdateUserDeletedByID(ctx context.Context, id uuid.UUID) error
	UpdateUserGithubComUserID(ctx context.Context, arg UpdateUserGithubComUserIDParams) error
	UpdateUserHashedOneTimePasscode(ctx context.Context, arg UpdateUserHashedOneTimePasscodeParams) error
	UpdateUserHashedPassword(ctx context.Context, arg UpdateUserHashedPasswordParams) error
	UpdateUserLastSeenAt(ctx context.Context, arg UpdateUserLastSeenAtParams) (User, error)
	UpdateUserLink(ctx context.Context, arg UpdateUserLinkParams) (UserLink, error)
	UpdateUserLinkedID(ctx context.Context, arg UpdateUserLinkedIDParams) (UserLink, error)
	UpdateUserLoginType(ctx context.Context, arg UpdateUserLoginTypeParams) (User, error)
	UpdateUserNotificationPreferences(ctx context.Context, arg UpdateUserNotificationPreferencesParams) (int64, error)
	UpdateUserProfile(ctx context.Context, arg UpdateUserProfileParams) (User, error)
	UpdateUserQuietHoursSchedule(ctx context.Context, arg UpdateUserQuietHoursScheduleParams) (User, error)
	UpdateUserRoles(ctx context.Context, arg UpdateUserRolesParams) (User, error)
	UpdateUserSecret(ctx context.Context, arg UpdateUserSecretParams) (UserSecret, error)
	UpdateUserStatus(ctx context.Context, arg UpdateUserStatusParams) (User, error)
	UpdateUserTaskNotificationAlertDismissed(ctx context.Context, arg UpdateUserTaskNotificationAlertDismissedParams) (bool, error)
	UpdateUserTerminalFont(ctx context.Context, arg UpdateUserTerminalFontParams) (UserConfig, error)
	UpdateUserThemePreference(ctx context.Context, arg UpdateUserThemePreferenceParams) (UserConfig, error)
	UpdateVolumeResourceMonitor(ctx context.Context, arg UpdateVolumeResourceMonitorParams) error
	UpdateWorkspace(ctx context.Context, arg UpdateWorkspaceParams) (WorkspaceTable, error)
	UpdateWorkspaceACLByID(ctx context.Context, arg UpdateWorkspaceACLByIDParams) error
	UpdateWorkspaceAgentConnectionByID(ctx context.Context, arg UpdateWorkspaceAgentConnectionByIDParams) error
	UpdateWorkspaceAgentLifecycleStateByID(ctx context.Context, arg UpdateWorkspaceAgentLifecycleStateByIDParams) error
	UpdateWorkspaceAgentLogOverflowByID(ctx context.Context, arg UpdateWorkspaceAgentLogOverflowByIDParams) error
	UpdateWorkspaceAgentMetadata(ctx context.Context, arg UpdateWorkspaceAgentMetadataParams) error
	UpdateWorkspaceAgentStartupByID(ctx context.Context, arg UpdateWorkspaceAgentStartupByIDParams) error
	UpdateWorkspaceAppHealthByID(ctx context.Context, arg UpdateWorkspaceAppHealthByIDParams) error
	UpdateWorkspaceAutomaticUpdates(ctx context.Context, arg UpdateWorkspaceAutomaticUpdatesParams) error
	UpdateWorkspaceAutostart(ctx context.Context, arg UpdateWorkspaceAutostartParams) error
	UpdateWorkspaceBuildCostByID(ctx context.Context, arg UpdateWorkspaceBuildCostByIDParams) error
	UpdateWorkspaceBuildDeadlineByID(ctx context.Context, arg UpdateWorkspaceBuildDeadlineByIDParams) error
	UpdateWorkspaceBuildFlagsByID(ctx context.Context, arg UpdateWorkspaceBuildFlagsByIDParams) error
	UpdateWorkspaceBuildProvisionerStateByID(ctx context.Context, arg UpdateWorkspaceBuildProvisionerStateByIDParams) error
	UpdateWorkspaceDeletedByID(ctx context.Context, arg UpdateWorkspaceDeletedByIDParams) error
	UpdateWorkspaceDormantDeletingAt(ctx context.Context, arg UpdateWorkspaceDormantDeletingAtParams) (WorkspaceTable, error)
	UpdateWorkspaceLastUsedAt(ctx context.Context, arg UpdateWorkspaceLastUsedAtParams) error
	UpdateWorkspaceNextStartAt(ctx context.Context, arg UpdateWorkspaceNextStartAtParams) error
	// This allows editing the properties of a workspace proxy.
	UpdateWorkspaceProxy(ctx context.Context, arg UpdateWorkspaceProxyParams) (WorkspaceProxy, error)
	UpdateWorkspaceProxyDeleted(ctx context.Context, arg UpdateWorkspaceProxyDeletedParams) error
	UpdateWorkspaceTTL(ctx context.Context, arg UpdateWorkspaceTTLParams) error
	UpdateWorkspacesDormantDeletingAtByTemplateID(ctx context.Context, arg UpdateWorkspacesDormantDeletingAtByTemplateIDParams) ([]WorkspaceTable, error)
	UpdateWorkspacesTTLByTemplateID(ctx context.Context, arg UpdateWorkspacesTTLByTemplateIDParams) error
	UpsertAnnouncementBanners(ctx context.Context, value string) error
	UpsertAppSecurityKey(ctx context.Context, value string) error
	UpsertApplicationName(ctx context.Context, value string) error
	// Upserts boundary usage statistics for a replica. On INSERT (new period), uses
	// delta values for unique counts (only data since last flush). On UPDATE, uses
	// cumulative values for unique counts (accurate period totals). Request counts
	// are always deltas, accumulated in DB. Returns true if insert, false if update.
	UpsertBoundaryUsageStats(ctx context.Context, arg UpsertBoundaryUsageStatsParams) (bool, error)
	UpsertConnectionLog(ctx context.Context, arg UpsertConnectionLogParams) (ConnectionLog, error)
	UpsertCoordinatorResumeTokenSigningKey(ctx context.Context, value string) error
	// The default proxy is implied and not actually stored in the database.
	// So we need to store it's configuration here for display purposes.
	// The functional values are immutable and controlled implicitly.
	UpsertDefaultProxy(ctx context.Context, arg UpsertDefaultProxyParams) error
	UpsertHealthSettings(ctx context.Context, value string) error
	UpsertLastUpdateCheck(ctx context.Context, value string) error
	UpsertLogoURL(ctx context.Context, value string) error
	// Insert or update notification report generator logs with recent activity.
	UpsertNotificationReportGeneratorLog(ctx context.Context, arg UpsertNotificationReportGeneratorLogParams) error
	UpsertNotificationsSettings(ctx context.Context, value string) error
	UpsertOAuth2GithubDefaultEligible(ctx context.Context, eligible bool) error
	UpsertOAuthSigningKey(ctx context.Context, value string) error
	UpsertPrebuildsSettings(ctx context.Context, value string) error
	UpsertProvisionerDaemon(ctx context.Context, arg UpsertProvisionerDaemonParams) (ProvisionerDaemon, error)
	UpsertRuntimeConfig(ctx context.Context, arg UpsertRuntimeConfigParams) error
	UpsertTailnetCoordinator(ctx context.Context, id uuid.UUID) (TailnetCoordinator, error)
	UpsertTailnetPeer(ctx context.Context, arg UpsertTailnetPeerParams) (TailnetPeer, error)
	UpsertTailnetTunnel(ctx context.Context, arg UpsertTailnetTunnelParams) (TailnetTunnel, error)
	UpsertTaskSnapshot(ctx context.Context, arg UpsertTaskSnapshotParams) error
	UpsertTaskWorkspaceApp(ctx context.Context, arg UpsertTaskWorkspaceAppParams) (TaskWorkspaceApp, error)
	UpsertTelemetryItem(ctx context.Context, arg UpsertTelemetryItemParams) error
	// This query aggregates the workspace_agent_stats and workspace_app_stats data
	// into a single table for efficient storage and querying. Half-hour buckets are
	// used to store the data, and the minutes are summed for each user and template
	// combination. The result is stored in the template_usage_stats table.
	UpsertTemplateUsageStats(ctx context.Context) error
	UpsertWebpushVAPIDKeys(ctx context.Context, arg UpsertWebpushVAPIDKeysParams) error
	UpsertWorkspaceAgentPortShare(ctx context.Context, arg UpsertWorkspaceAgentPortShareParams) (WorkspaceAgentPortShare, error)
	UpsertWorkspaceApp(ctx context.Context, arg UpsertWorkspaceAppParams) (WorkspaceApp, error)
	//
	// The returned boolean, new_or_stale, can be used to deduce if a new session
	// was started. This means that a new row was inserted (no previous session) or
	// the updated_at is older than stale interval.
	UpsertWorkspaceAppAuditSession(ctx context.Context, arg UpsertWorkspaceAppAuditSessionParams) (bool, error)
	ValidateGroupIDs(ctx context.Context, groupIds []uuid.UUID) (ValidateGroupIDsRow, error)
	ValidateUserIDs(ctx context.Context, userIds []uuid.UUID) (ValidateUserIDsRow, error)
}

var _ sqlcQuerier = (*sqlQuerier)(nil)
