package prebuilds

import (
	"context"
	"database/sql"
	"time"

	"github.com/google/uuid"

	"github.com/coder/coder/v2/coderd/database"
	sdkproto "github.com/coder/coder/v2/provisionersdk/proto"
)

type NoopReconciler struct{}

func (NoopReconciler) Run(context.Context)         {}
func (NoopReconciler) Stop(context.Context, error) {}
func (NoopReconciler) TrackResourceReplacement(context.Context, uuid.UUID, uuid.UUID, []*sdkproto.ResourceReplacement) {
}

func (NoopReconciler) ReconcileAll(context.Context) (ReconcileStats, error) {
	return ReconcileStats{}, nil
}

func (NoopReconciler) SnapshotState(context.Context, database.Store) (*GlobalSnapshot, error) {
	return &GlobalSnapshot{}, nil
}
func (NoopReconciler) ReconcilePreset(context.Context, PresetSnapshot) error { return nil }
func (NoopReconciler) CalculateActions(context.Context, PresetSnapshot) (*ReconciliationActions, error) {
	return &ReconciliationActions{}, nil
}

var DefaultReconciler ReconciliationOrchestrator = NoopReconciler{}

type NoopClaimer struct{}

func (NoopClaimer) Claim(context.Context, database.Store, time.Time, uuid.UUID, string, uuid.UUID, sql.NullString, sql.NullTime, sql.NullInt64) (*uuid.UUID, error) {
	// Not entitled to claim prebuilds in AGPL version.
	return nil, ErrAGPLDoesNotSupportPrebuiltWorkspaces
}

var DefaultClaimer Claimer = NoopClaimer{}
