package usage

import (
	"context"

	"github.com/coder/coder/v2/coderd/database"
	"github.com/coder/coder/v2/coderd/usage/usagetypes"
)

// Inserter accepts usage events generated by the product.
type Inserter interface {
	// InsertDiscreteUsageEvent writes a discrete usage event to the database
	// within the given transaction.
	// The caller context must be authorized to create usage events in the
	// database.
	InsertDiscreteUsageEvent(ctx context.Context, tx database.Store, event usagetypes.DiscreteEvent) error
}

// AGPLInserter is a no-op implementation of Inserter.
type AGPLInserter struct{}

var _ Inserter = AGPLInserter{}

func NewAGPLInserter() Inserter {
	return AGPLInserter{}
}

// InsertDiscreteUsageEvent is a no-op implementation of
// InsertDiscreteUsageEvent.
func (AGPLInserter) InsertDiscreteUsageEvent(_ context.Context, _ database.Store, _ usagetypes.DiscreteEvent) error {
	return nil
}
