// Code generated by typegen/main.go. DO NOT EDIT.
package codersdk

type RBACResource string

const (
	ResourceWildcard                      RBACResource = "*"
	ResourceAibridgeInterception          RBACResource = "aibridge_interception"
	ResourceApiKey                        RBACResource = "api_key"
	ResourceAssignOrgRole                 RBACResource = "assign_org_role"
	ResourceAssignRole                    RBACResource = "assign_role"
	ResourceAuditLog                      RBACResource = "audit_log"
	ResourceBoundaryUsage                 RBACResource = "boundary_usage"
	ResourceConnectionLog                 RBACResource = "connection_log"
	ResourceCryptoKey                     RBACResource = "crypto_key"
	ResourceDebugInfo                     RBACResource = "debug_info"
	ResourceDeploymentConfig              RBACResource = "deployment_config"
	ResourceDeploymentStats               RBACResource = "deployment_stats"
	ResourceFile                          RBACResource = "file"
	ResourceGroup                         RBACResource = "group"
	ResourceGroupMember                   RBACResource = "group_member"
	ResourceIdpsyncSettings               RBACResource = "idpsync_settings"
	ResourceInboxNotification             RBACResource = "inbox_notification"
	ResourceLicense                       RBACResource = "license"
	ResourceNotificationMessage           RBACResource = "notification_message"
	ResourceNotificationPreference        RBACResource = "notification_preference"
	ResourceNotificationTemplate          RBACResource = "notification_template"
	ResourceOauth2App                     RBACResource = "oauth2_app"
	ResourceOauth2AppCodeToken            RBACResource = "oauth2_app_code_token"
	ResourceOauth2AppSecret               RBACResource = "oauth2_app_secret"
	ResourceOrganization                  RBACResource = "organization"
	ResourceOrganizationMember            RBACResource = "organization_member"
	ResourcePrebuiltWorkspace             RBACResource = "prebuilt_workspace"
	ResourceProvisionerDaemon             RBACResource = "provisioner_daemon"
	ResourceProvisionerJobs               RBACResource = "provisioner_jobs"
	ResourceReplicas                      RBACResource = "replicas"
	ResourceSystem                        RBACResource = "system"
	ResourceTailnetCoordinator            RBACResource = "tailnet_coordinator"
	ResourceTask                          RBACResource = "task"
	ResourceTemplate                      RBACResource = "template"
	ResourceUsageEvent                    RBACResource = "usage_event"
	ResourceUser                          RBACResource = "user"
	ResourceUserSecret                    RBACResource = "user_secret"
	ResourceWebpushSubscription           RBACResource = "webpush_subscription"
	ResourceWorkspace                     RBACResource = "workspace"
	ResourceWorkspaceAgentDevcontainers   RBACResource = "workspace_agent_devcontainers"
	ResourceWorkspaceAgentResourceMonitor RBACResource = "workspace_agent_resource_monitor"
	ResourceWorkspaceDormant              RBACResource = "workspace_dormant"
	ResourceWorkspaceProxy                RBACResource = "workspace_proxy"
)

type RBACAction string

const (
	ActionApplicationConnect RBACAction = "application_connect"
	ActionAssign             RBACAction = "assign"
	ActionCreate             RBACAction = "create"
	ActionCreateAgent        RBACAction = "create_agent"
	ActionDelete             RBACAction = "delete"
	ActionDeleteAgent        RBACAction = "delete_agent"
	ActionRead               RBACAction = "read"
	ActionReadPersonal       RBACAction = "read_personal"
	ActionSSH                RBACAction = "ssh"
	ActionShare              RBACAction = "share"
	ActionUnassign           RBACAction = "unassign"
	ActionUpdate             RBACAction = "update"
	ActionUpdatePersonal     RBACAction = "update_personal"
	ActionUse                RBACAction = "use"
	ActionViewInsights       RBACAction = "view_insights"
	ActionWorkspaceStart     RBACAction = "start"
	ActionWorkspaceStop      RBACAction = "stop"
)

// RBACResourceActions is the mapping of resources to which actions are valid for
// said resource type.
var RBACResourceActions = map[RBACResource][]RBACAction{
	ResourceWildcard:                      {},
	ResourceAibridgeInterception:          {ActionCreate, ActionRead, ActionUpdate},
	ResourceApiKey:                        {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceAssignOrgRole:                 {ActionAssign, ActionCreate, ActionDelete, ActionRead, ActionUnassign, ActionUpdate},
	ResourceAssignRole:                    {ActionAssign, ActionRead, ActionUnassign},
	ResourceAuditLog:                      {ActionCreate, ActionRead},
	ResourceBoundaryUsage:                 {ActionDelete, ActionRead, ActionUpdate},
	ResourceConnectionLog:                 {ActionRead, ActionUpdate},
	ResourceCryptoKey:                     {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceDebugInfo:                     {ActionRead},
	ResourceDeploymentConfig:              {ActionRead, ActionUpdate},
	ResourceDeploymentStats:               {ActionRead},
	ResourceFile:                          {ActionCreate, ActionRead},
	ResourceGroup:                         {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceGroupMember:                   {ActionRead},
	ResourceIdpsyncSettings:               {ActionRead, ActionUpdate},
	ResourceInboxNotification:             {ActionCreate, ActionRead, ActionUpdate},
	ResourceLicense:                       {ActionCreate, ActionDelete, ActionRead},
	ResourceNotificationMessage:           {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceNotificationPreference:        {ActionRead, ActionUpdate},
	ResourceNotificationTemplate:          {ActionRead, ActionUpdate},
	ResourceOauth2App:                     {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceOauth2AppCodeToken:            {ActionCreate, ActionDelete, ActionRead},
	ResourceOauth2AppSecret:               {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceOrganization:                  {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceOrganizationMember:            {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourcePrebuiltWorkspace:             {ActionDelete, ActionUpdate},
	ResourceProvisionerDaemon:             {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceProvisionerJobs:               {ActionCreate, ActionRead, ActionUpdate},
	ResourceReplicas:                      {ActionRead},
	ResourceSystem:                        {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceTailnetCoordinator:            {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceTask:                          {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceTemplate:                      {ActionCreate, ActionDelete, ActionRead, ActionUpdate, ActionUse, ActionViewInsights},
	ResourceUsageEvent:                    {ActionCreate, ActionRead, ActionUpdate},
	ResourceUser:                          {ActionCreate, ActionDelete, ActionRead, ActionReadPersonal, ActionUpdate, ActionUpdatePersonal},
	ResourceUserSecret:                    {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
	ResourceWebpushSubscription:           {ActionCreate, ActionDelete, ActionRead},
	ResourceWorkspace:                     {ActionApplicationConnect, ActionCreate, ActionCreateAgent, ActionDelete, ActionDeleteAgent, ActionRead, ActionShare, ActionSSH, ActionWorkspaceStart, ActionWorkspaceStop, ActionUpdate},
	ResourceWorkspaceAgentDevcontainers:   {ActionCreate},
	ResourceWorkspaceAgentResourceMonitor: {ActionCreate, ActionRead, ActionUpdate},
	ResourceWorkspaceDormant:              {ActionApplicationConnect, ActionCreate, ActionCreateAgent, ActionDelete, ActionDeleteAgent, ActionRead, ActionShare, ActionSSH, ActionWorkspaceStart, ActionWorkspaceStop, ActionUpdate},
	ResourceWorkspaceProxy:                {ActionCreate, ActionDelete, ActionRead, ActionUpdate},
}
