# AI Contribution Guidelines

This document defines rules for contributions where an AI system is the primary author of the code (i.e., most of the pull request was generated by AI).
It applies to all Coder repositories and is a supplement to the [existing contributing guidelines](./CONTRIBUTING.md), not a replacement.

For minor AI-assisted edits, suggestions, or completions where the human contributor is clearly the primary author, these rules do not apply — standard contributing guidelines are sufficient.

## Disclosure

Contributors must **disclose AI involvement** in the pull request description whenever these guidelines apply.

## Human Ownership & Attribution

- All pull requests must be opened under **user accounts linked to a human**, and not an application ("bot account").
- Contributors are personally accountable for the content of their PRs, regardless of how it was generated.

## Verification & Evidence

All AI-assisted contributions require **manual verification**.
Contributions without verification evidence will be rejected.

- Test your changes yourself. Don’t assume AI is correct.
- Provide screenshots showing that the change works as intended.
  - For visual/UI changes: include before/after screenshots.
  - For CLI or backend changes: include terminal or api output.

## Why These Rules Exist

Traditionally, maintainers assumed that producing a pull request required more effort than reviewing it.
With AI-assisted tools, the balance has shifted: generating code is often faster than reviewing it.

Our guidelines exist to safeguard maintainers’ time, uphold contributor accountability, and preserve the overall quality of the project.
