# Usage Data Reporting

The [AI Governance Add-On](./ai-governance.md) requires reporting usage data to Tallyman, a Coder-managed server for billing and reporting purposes. Coder only captures and sends the following information, related to your deployment ID:

- number of agent workspace builds consumed
- number of AI governance seats consumed

No user-identifiable information or additional metrics are sent to Tallyman. This information is also shared with [Metronome](https://metronome.com), a Stripe product and Coder partner for usage-based and reporting.

To send usage data, your Coder deployment must be able to make outbound HTTPS requests to `https://tallyman-prod.coder.com`. Usage data is sent approximately every 17 minutes and can be monitored via `coderd` logs.

Example of a successful request (requires debug logging enabled [`CODER_LOG_FILTER=.*`](../reference/cli/server.md#-l---log-filter)):

```sh
[debu] published usage events to tallyman accepted=5 rejected=0
```

Example of a request payload:

```sh
POST /api/v1/events/ingest HTTP/1.1
Host: tallyman-prod.coder.com
Content-Type: application/json
Coder-License-Key: <license-jwt> # your license JWT for verification
Coder-Deployment-ID: 8a4e92f1-3b7c-4d5e-9f12-abc123def456 # your deployment ID

{
  "events": [
    {
      "id": "550e8400-e29b-41d4-a716-446655440000", # unique event ID generated by Coder
      "event_type": "dc_managed_agents_v1", # aka. agent workspace builds
      "event_data": {
        "count": 1
      },
      "created_at": "2025-01-15T14:30:00Z"
    }
  ]
}
```

Example of a failed request (e.g. Tallyman Server is blocked by your network):

```sh
[warn] failed to send publish request to tallyman count=5 error="Post \"https://tallyman-prod.coder.com/api/v1/events/ingest\": dial tcp: lookup tallyman-prod.coder.com: no such host"
```

> [!NOTE]
> Air-gapped deployments and/or those with legal restrictions around usage reporting can [contact us](https://coder.com/contact) to discuss alternative methods.
