# Cloud Platforms

We provide install guides and example templates for deploying Coder to your
cloud of choice.

<div class="tabs">

## AWS

We publish an EC2 image with Coder pre-installed. Follow the tutorial here:

- [Install Coder on AWS EC2](./ec2.md)
- [Install Coder on AWS EKS](../kubernetes.md#aws)

Alternatively, install the [CLI binary](../cli.md) on any Linux machine or
follow our [Kubernetes](../kubernetes.md) documentation to install Coder on an
existing Kubernetes cluster.

For EKS-specific installation guidance, see the [AWS section in Kubernetes installation docs](../kubernetes.md#aws).

## GCP

We publish a GCP Marketplace listing with Coder pre-installed. Follow the
tutorial here:

- [Install Coder on GCP Compute Engine](./compute-engine.md)

Alternatively, install the [CLI binary](../cli.md) on any Linux machine or
follow our [Kubernetes](../kubernetes.md) documentation to install Coder on an
existing GKE cluster.

## Azure

Use the following guide to run Coder on an Azure VM:

- [Install Coder on an Azure VM](./azure-vm.md)

Alternatively, install the [CLI binary](../cli.md) on any Linux machine or
follow our [Kubernetes](../kubernetes.md) documentation to install Coder on an
existing GKE cluster.

## Other

Is your cloud missing? Check [unofficial](../other/index.md) install methods or
install the [standalone binary](../cli.md).

</div>
