# Releases

Coder releases are cut directly from main in our
[GitHub](https://github.com/coder/coder) on the first Tuesday of each month.

We recommend enterprise customers test the compatibility of new releases with
their infrastructure on a staging environment before upgrading a production
deployment.

## Release channels

We support four release channels:

- **Mainline:** The bleeding edge version of Coder
- **Stable:** N-1 of the mainline release
- **Security Support:** N-2 of the mainline release
- **Extended Support Release:** Biannually released version of Coder

We field our mainline releases publicly for one month before promoting them to stable. The security support version, so n-2 from mainline, receives patches
only for security issues or CVEs.

### Mainline releases

- Intended for customers with a staging environment
- Gives earliest access to new features
- May include minor bugs
- All bugfixes and security patches are supported

### Stable releases

- Safest upgrade/installation path
- May not include the latest features
- All bugfixes and security patches are supported

### Security Support

- In-product security vulnerabilities and CVEs are supported

For more information on feature rollout, see our
[feature stages documentation](../releases/feature-stages.md).

### Extended Support Release

- Designed for organizations that prioritize long-term stability
- Receives only critical bugfixes and security patches
- Ideal for regulated environments or large deployments with strict upgrade cycles

ESR releases will be updated with critical bugfixes and security patches that are available to paying customers. This extended support model provides predictable, long-term maintenance for organizations that require enhanced stability. Because ESR forgoes new features in favor of maintenance and stability, it is best suited for teams with strict upgrade constraints. The latest ESR version is [Coder 2.29](https://github.com/coder/coder/releases/tag/v2.29.0).

For more information, see the [Coder ESR announcement](https://coder.com/blog/esr) or our [ESR Upgrade Guide](./esr-2.24-2.29-upgrade.md).

## Installing stable

When installing Coder, we generally advise specifying the desired version from
our GitHub [releases page](https://github.com/coder/coder/releases).

You can also use our `install.sh` script with the `stable` flag to install the
latest stable release:

```shell
curl -fsSL https://coder.com/install.sh | sh -s -- --stable
```

Best practices for installing Coder can be found on our [install](../index.md)
pages.

## Release schedule
<!-- Autogenerated release calendar from scripts/update-release-calendar.sh -->
<!-- RELEASE_CALENDAR_START -->
| Release name                                   | Release Date       | Status                   | Latest Release                                                 |
|------------------------------------------------|--------------------|--------------------------|----------------------------------------------------------------|
| [2.24](https://coder.com/changelog/coder-2-24) | July 01, 2025      | Extended Support Release | [v2.24.4](https://github.com/coder/coder/releases/tag/v2.24.4) |
| [2.25](https://coder.com/changelog/coder-2-25) | August 05, 2025    | Not Supported            | [v2.25.3](https://github.com/coder/coder/releases/tag/v2.25.3) |
| [2.26](https://coder.com/changelog/coder-2-26) | September 03, 2025 | Not Supported            | [v2.26.6](https://github.com/coder/coder/releases/tag/v2.26.6) |
| [2.27](https://coder.com/changelog/coder-2-27) | October 02, 2025   | Security Support         | [v2.27.9](https://github.com/coder/coder/releases/tag/v2.27.9) |
| [2.28](https://coder.com/changelog/coder-2-28) | November 04, 2025  | Stable                   | [v2.28.6](https://github.com/coder/coder/releases/tag/v2.28.6) |
| [2.29](https://coder.com/changelog/coder-2-29) | December 02, 2025  | Mainline + ESR           | [v2.29.1](https://github.com/coder/coder/releases/tag/v2.29.1) |
| 2.30                                           |                    | Not Released             | N/A                                                            |
<!-- RELEASE_CALENDAR_END -->

> [!TIP]
> We publish a
> [`preview`](https://github.com/coder/coder/pkgs/container/coder-preview) image
> `ghcr.io/coder/coder-preview` on each commit to the `main` branch. This can be
> used to test under-development features and bug fixes that have not yet been
> released to [`mainline`](#mainline-releases) or [`stable`](#stable-releases).
>
> The `preview` image is not intended for production use.

### January Releases

Releases on the first Tuesday of January **are not guaranteed to occur** because most of our team is out for the December holiday period. That being said, an ad-hoc release might still occur. We advise not relying on a January release, or reaching out to Coder directly to determine if one will be occurring closer to the release date.
