import { ChakraProvider, extendTheme } from "@chakra-ui/react";
import type { AppProps } from "next/app";
import Head from "next/head";

const theme = extendTheme({
	styles: {
		global: {
			body: {
				bg: "gray.50",
			},
		},
	},
});

const MyApp: React.FC<AppProps> = ({ Component, pageProps }) => {
	return (
		<>
			<Head>
				<link rel="mask-icon" href="/favicon.svg" color="#000000" />
				<link rel="alternate icon" type="image/png" href="/favicon.png" />
			</Head>
			<ChakraProvider theme={theme}>
				<Component {...pageProps} />
			</ChakraProvider>
		</>
	);
};

export default MyApp;
