package proto

import "github.com/coder/coder/v2/apiversion"

// Version history:
//
// API v1.2:
//   - Add support for `open_in` parameters in the workspace apps.
//
// API v1.3:
//   - Add new field named `resources_monitoring` in the Agent with resources monitoring.
//
// API v1.4:
//   - Add new field named `devcontainers` in the Agent.
//
// API v1.5:
//   - Add new field named `prebuilt_workspace_build_stage` enum in the Metadata message.
//   - Add new field named `running_agent_auth_tokens` to provisioner job metadata
//   - Add new field named `resource_replacements` in PlanComplete & CompletedJob.WorkspaceBuild.
//   - Add new field named `api_key_scope` to WorkspaceAgent to support running without user data access.
//   - Add `plan` field to `CompletedJob.TemplateImport`.
//
// API v1.6:
//   - Add `module_files` field to `CompletedJob.TemplateImport`.
//   - Add previous parameter values to 'WorkspaceBuild' jobs. Provisioner passes
//     the previous values for the `terraform apply` to enforce monotonicity
//     in the terraform provider.
//   - Add new field named `expiration_policy` to `Prebuild`, with a field named
//     `ttl` to define TTL-based expiration for unclaimed prebuilds.
//   - Add `group` field to `App`
//   - Add `form_type` field to parameters
//
// API v1.7:
//   - Added DataUpload and ChunkPiece messages to support uploading large files
//     back to Coderd. Used for uploading module files in support of dynamic
//     parameters.
//   - Add new field named `scheduling` to `Prebuild`, with fields for timezone
//     and schedule rules to define cron-based scaling of prebuilt workspace
//     instances based on time patterns.
//   - Added new field named `id` to `App`, which transports the ID generated by the coder_app provider to be persisted.
//   - Added new field named `default` to `Preset`.
//   - Added various fields in support of AI Tasks:
//     -> `ai_tasks` in `CompleteJob.WorkspaceBuild`
//     -> `has_ai_tasks` in `CompleteJob.TemplateImport`
//     -> `has_ai_tasks` and `ai_tasks` in `PlanComplete`
//     -> new message types `AITaskSidebarApp` and `AITask`
//
// API v1.8:
//   - Add new fields `description` and `icon` to `Preset`.
//
// API v1.9:
//   - Added new field named 'has_external_agent' in 'CompleteJob.TemplateImport'
//
// API v1.10:
//   - Added new field `tooltip` in `App`
//
// API v1.11:
//   - Added new fields `task_id` and `task_prompt` to `Manifest`.
//   - Added new field `app_id` to `AITask`
//
// API v1.12:
//   - Added new field `template_version_id` to `provisioner.Metadata`
//   - Added new field `exp_reuse_terraform_workspace` to `provisioner.Job.WorkspaceBuild`
//   - Added fields `template_version_id`, `template_id`, and `exp_reuse_terraform_workspace` to `provisioner.Config`
//
// API v1.13:
//   - Removed experimental fields `exp_reuse_terraform_workspace`. Caching moved into Coderd
//
// API v1.14:
//   - Added new field `template_version_modules_file` to Metadata
//   - Added `FailedFile` type for file upload failures.
//   - Add `DownloadFile` capability for provisioner daemons to fetch files from coderd.
//   - Moved type `UploadFileRequest` -> `provisioner.FileUpload`
const (
	CurrentMajor = 1
	CurrentMinor = 14
)

// CurrentVersion is the current provisionerd API version.
// Breaking changes to the provisionerd API **MUST** increment
// CurrentMajor above.
// Non-breaking changes to the provisionerd API **MUST** increment
// CurrentMinor above.
var CurrentVersion = apiversion.New(CurrentMajor, CurrentMinor)
