// Code generated by protoc-gen-ts_proto. DO NOT EDIT.
// versions:
//   protoc-gen-ts_proto  v1.181.2
//   protoc               v4.23.4
// source: provisioner.proto

/* eslint-disable */
import * as _m0 from "protobufjs/minimal";
import { Observable } from "rxjs";
import { Timestamp } from "./google/protobuf/timestampGenerated";

export const protobufPackage = "provisioner";

export enum ParameterFormType {
  DEFAULT = 0,
  FORM_ERROR = 1,
  RADIO = 2,
  DROPDOWN = 3,
  INPUT = 4,
  TEXTAREA = 5,
  SLIDER = 6,
  CHECKBOX = 7,
  SWITCH = 8,
  TAGSELECT = 9,
  MULTISELECT = 10,
  UNRECOGNIZED = -1,
}

/** LogLevel represents severity of the log. */
export enum LogLevel {
  TRACE = 0,
  DEBUG = 1,
  INFO = 2,
  WARN = 3,
  ERROR = 4,
  UNRECOGNIZED = -1,
}

export enum AppSharingLevel {
  OWNER = 0,
  AUTHENTICATED = 1,
  PUBLIC = 2,
  UNRECOGNIZED = -1,
}

export enum AppOpenIn {
  /** @deprecated */
  WINDOW = 0,
  SLIM_WINDOW = 1,
  TAB = 2,
  UNRECOGNIZED = -1,
}

/** WorkspaceTransition is the desired outcome of a build */
export enum WorkspaceTransition {
  START = 0,
  STOP = 1,
  DESTROY = 2,
  UNRECOGNIZED = -1,
}

export enum PrebuiltWorkspaceBuildStage {
  /** NONE - Default value for builds unrelated to prebuilds. */
  NONE = 0,
  /** CREATE - A prebuilt workspace is being provisioned. */
  CREATE = 1,
  /** CLAIM - A prebuilt workspace is being claimed. */
  CLAIM = 2,
  UNRECOGNIZED = -1,
}

export enum GraphSource {
  SOURCE_UNKNOWN = 0,
  SOURCE_PLAN = 1,
  SOURCE_STATE = 2,
  UNRECOGNIZED = -1,
}

export enum TimingState {
  STARTED = 0,
  COMPLETED = 1,
  FAILED = 2,
  UNRECOGNIZED = -1,
}

export enum DataUploadType {
  UPLOAD_TYPE_UNKNOWN = 0,
  /**
   * UPLOAD_TYPE_MODULE_FILES - UPLOAD_TYPE_MODULE_FILES is used to stream over terraform module files.
   * These files are located in `.terraform/modules` and are used for dynamic
   * parameters.
   */
  UPLOAD_TYPE_MODULE_FILES = 1,
  UNRECOGNIZED = -1,
}

/** Empty indicates a successful request/response. */
export interface Empty {
}

/** TemplateVariable represents a Terraform variable. */
export interface TemplateVariable {
  name: string;
  description: string;
  type: string;
  defaultValue: string;
  required: boolean;
  sensitive: boolean;
}

/** RichParameterOption represents a singular option that a parameter may expose. */
export interface RichParameterOption {
  name: string;
  description: string;
  value: string;
  icon: string;
}

/** RichParameter represents a variable that is exposed. */
export interface RichParameter {
  name: string;
  description: string;
  type: string;
  mutable: boolean;
  defaultValue: string;
  icon: string;
  options: RichParameterOption[];
  validationRegex: string;
  validationError: string;
  validationMin?: number | undefined;
  validationMax?: number | undefined;
  validationMonotonic: string;
  required: boolean;
  /** legacy_variable_name was removed (= 14) */
  displayName: string;
  order: number;
  ephemeral: boolean;
  formType: ParameterFormType;
}

/** RichParameterValue holds the key/value mapping of a parameter. */
export interface RichParameterValue {
  name: string;
  value: string;
}

/**
 * ExpirationPolicy defines the policy for expiring unclaimed prebuilds.
 * If a prebuild remains unclaimed for longer than ttl seconds, it is deleted and
 * recreated to prevent staleness.
 */
export interface ExpirationPolicy {
  ttl: number;
}

export interface Schedule {
  cron: string;
  instances: number;
}

export interface Scheduling {
  timezone: string;
  schedule: Schedule[];
}

export interface Prebuild {
  instances: number;
  expirationPolicy: ExpirationPolicy | undefined;
  scheduling: Scheduling | undefined;
}

/** Preset represents a set of preset parameters for a template version. */
export interface Preset {
  name: string;
  parameters: PresetParameter[];
  prebuild: Prebuild | undefined;
  default: boolean;
  description: string;
  icon: string;
}

export interface PresetParameter {
  name: string;
  value: string;
}

export interface ResourceReplacement {
  resource: string;
  paths: string[];
}

/** VariableValue holds the key/value mapping of a Terraform variable. */
export interface VariableValue {
  name: string;
  value: string;
  sensitive: boolean;
}

/** Log represents output from a request. */
export interface Log {
  level: LogLevel;
  output: string;
}

export interface InstanceIdentityAuth {
  instanceId: string;
}

export interface ExternalAuthProviderResource {
  id: string;
  optional: boolean;
}

export interface ExternalAuthProvider {
  id: string;
  accessToken: string;
}

/** Agent represents a running agent on the workspace. */
export interface Agent {
  id: string;
  name: string;
  env: { [key: string]: string };
  /** Field 4 was startup_script, now removed. */
  operatingSystem: string;
  architecture: string;
  directory: string;
  apps: App[];
  token?: string | undefined;
  instanceId?: string | undefined;
  connectionTimeoutSeconds: number;
  troubleshootingUrl: string;
  motdFile: string;
  /**
   * Field 14 was bool login_before_ready = 14, now removed.
   * Field 15, 16, 17 were related to scripts, which are now removed.
   */
  metadata: Agent_Metadata[];
  /** Field 19 was startup_script_behavior, now removed. */
  displayApps: DisplayApps | undefined;
  scripts: Script[];
  extraEnvs: Env[];
  order: number;
  resourcesMonitoring: ResourcesMonitoring | undefined;
  devcontainers: Devcontainer[];
  apiKeyScope: string;
}

export interface Agent_Metadata {
  key: string;
  displayName: string;
  script: string;
  interval: number;
  timeout: number;
  order: number;
}

export interface Agent_EnvEntry {
  key: string;
  value: string;
}

export interface ResourcesMonitoring {
  memory: MemoryResourceMonitor | undefined;
  volumes: VolumeResourceMonitor[];
}

export interface MemoryResourceMonitor {
  enabled: boolean;
  threshold: number;
}

export interface VolumeResourceMonitor {
  path: string;
  enabled: boolean;
  threshold: number;
}

export interface DisplayApps {
  vscode: boolean;
  vscodeInsiders: boolean;
  webTerminal: boolean;
  sshHelper: boolean;
  portForwardingHelper: boolean;
}

export interface Env {
  name: string;
  value: string;
}

/** Script represents a script to be run on the workspace. */
export interface Script {
  displayName: string;
  icon: string;
  script: string;
  cron: string;
  startBlocksLogin: boolean;
  runOnStart: boolean;
  runOnStop: boolean;
  timeoutSeconds: number;
  logPath: string;
}

export interface Devcontainer {
  workspaceFolder: string;
  configPath: string;
  name: string;
}

/** App represents a dev-accessible application on the workspace. */
export interface App {
  /**
   * slug is the unique identifier for the app, usually the name from the
   * template. It must be URL-safe and hostname-safe.
   */
  slug: string;
  displayName: string;
  command: string;
  url: string;
  icon: string;
  subdomain: boolean;
  healthcheck: Healthcheck | undefined;
  sharingLevel: AppSharingLevel;
  external: boolean;
  order: number;
  hidden: boolean;
  openIn: AppOpenIn;
  group: string;
  /** If nil, new UUID will be generated. */
  id: string;
  tooltip: string;
}

/** Healthcheck represents configuration for checking for app readiness. */
export interface Healthcheck {
  url: string;
  interval: number;
  threshold: number;
}

/** Resource represents created infrastructure. */
export interface Resource {
  name: string;
  type: string;
  agents: Agent[];
  metadata: Resource_Metadata[];
  hide: boolean;
  icon: string;
  instanceType: string;
  dailyCost: number;
  modulePath: string;
}

export interface Resource_Metadata {
  key: string;
  value: string;
  sensitive: boolean;
  isNull: boolean;
}

export interface Module {
  source: string;
  version: string;
  key: string;
  dir: string;
}

export interface Role {
  name: string;
  orgId: string;
}

export interface RunningAgentAuthToken {
  agentId: string;
  token: string;
}

export interface AITaskSidebarApp {
  id: string;
}

export interface AITask {
  id: string;
  sidebarApp?: AITaskSidebarApp | undefined;
  appId: string;
}

/** Metadata is information about a workspace used in the execution of a build */
export interface Metadata {
  coderUrl: string;
  workspaceTransition: WorkspaceTransition;
  workspaceName: string;
  workspaceOwner: string;
  workspaceId: string;
  workspaceOwnerId: string;
  workspaceOwnerEmail: string;
  templateName: string;
  templateVersion: string;
  workspaceOwnerOidcAccessToken: string;
  workspaceOwnerSessionToken: string;
  templateId: string;
  workspaceOwnerName: string;
  workspaceOwnerGroups: string[];
  workspaceOwnerSshPublicKey: string;
  workspaceOwnerSshPrivateKey: string;
  workspaceBuildId: string;
  workspaceOwnerLoginType: string;
  workspaceOwnerRbacRoles: Role[];
  /** Indicates that a prebuilt workspace is being built. */
  prebuiltWorkspaceBuildStage: PrebuiltWorkspaceBuildStage;
  runningAgentAuthTokens: RunningAgentAuthToken[];
  taskId: string;
  taskPrompt: string;
  templateVersionId: string;
  templateVersionModulesFile: string;
}

/** Config represents execution configuration shared by all subsequent requests in the Session */
export interface Config {
  provisionerLogLevel: string;
  /** Template imports can omit template id */
  templateId?:
    | string
    | undefined;
  /** Dry runs omit version id */
  templateVersionId?: string | undefined;
}

/** ParseRequest consumes source-code to produce inputs. */
export interface ParseRequest {
}

/** ParseComplete indicates a request to parse completed. */
export interface ParseComplete {
  error: string;
  templateVariables: TemplateVariable[];
  readme: Uint8Array;
  workspaceTags: { [key: string]: string };
}

export interface ParseComplete_WorkspaceTagsEntry {
  key: string;
  value: string;
}

export interface InitRequest {
  /** template_source_archive is a tar of the template source files */
  templateSourceArchive: Uint8Array;
  /**
   * If true, the provisioner can safely assume the caller does not need the
   * module files downloaded by the `terraform init` command.
   * Ideally this boolean would be flipped in its truthy value, however since
   * this is costly, the zero value omitting the module files is preferred.
   */
  omitModuleFiles: boolean;
  /** initial_module_tar is the hash of the tar of the terraform module files located in .terraform/modules */
  initialModuleTarHash: Uint8Array;
}

export interface InitComplete {
  error: string;
  timings: Timing[];
  modules: Module[];
  moduleFiles: Uint8Array;
  moduleFilesHash: Uint8Array;
}

/** PlanRequest asks the provisioner to plan what resources & parameters it will create */
export interface PlanRequest {
  metadata: Metadata | undefined;
  richParameterValues: RichParameterValue[];
  variableValues: VariableValue[];
  externalAuthProviders: ExternalAuthProvider[];
  previousParameterValues: RichParameterValue[];
  /** state is the provisioner state (if any) */
  state: Uint8Array;
}

/** PlanComplete indicates a request to plan completed. */
export interface PlanComplete {
  error: string;
  timings: Timing[];
  plan: Uint8Array;
  dailyCost: number;
  resourceReplacements: ResourceReplacement[];
  aiTaskCount: number;
}

/**
 * ApplyRequest asks the provisioner to apply the changes.  Apply MUST be preceded by a successful plan request/response
 * in the same Session.  The plan data is not transmitted over the wire and is cached by the provisioner in the Session.
 */
export interface ApplyRequest {
  metadata: Metadata | undefined;
}

/** ApplyComplete indicates a request to apply completed. */
export interface ApplyComplete {
  state: Uint8Array;
  error: string;
  timings: Timing[];
}

export interface GraphRequest {
  metadata: Metadata | undefined;
  source: GraphSource;
}

export interface GraphComplete {
  error: string;
  timings: Timing[];
  resources: Resource[];
  parameters: RichParameter[];
  externalAuthProviders: ExternalAuthProviderResource[];
  presets: Preset[];
  /**
   * Whether a template has any `coder_ai_task` resources defined, even if not planned for creation.
   * During a template import, a plan is run which may not yield in any `coder_ai_task` resources, but nonetheless we
   * still need to know that such resources are defined.
   *
   * See `hasAITaskResources` in provisioner/terraform/resources.go for more details.
   */
  hasAiTasks: boolean;
  aiTasks: AITask[];
  hasExternalAgents: boolean;
}

export interface Timing {
  start: Date | undefined;
  end: Date | undefined;
  action: string;
  source: string;
  resource: string;
  stage: string;
  state: TimingState;
}

/** CancelRequest requests that the previous request be canceled gracefully. */
export interface CancelRequest {
}

export interface Request {
  config?: Config | undefined;
  parse?: ParseRequest | undefined;
  init?: InitRequest | undefined;
  plan?: PlanRequest | undefined;
  apply?: ApplyRequest | undefined;
  graph?: GraphRequest | undefined;
  cancel?:
    | CancelRequest
    | undefined;
  /**
   * The file upload is used to send over cached modules during the
   * init step.
   * This is kept intentionally generic if another step wants to reuse
   * this.
   */
  file?: FileUpload | undefined;
}

export interface Response {
  log?: Log | undefined;
  parse?: ParseComplete | undefined;
  init?: InitComplete | undefined;
  plan?: PlanComplete | undefined;
  apply?: ApplyComplete | undefined;
  graph?: GraphComplete | undefined;
  dataUpload?: DataUpload | undefined;
  chunkPiece?: ChunkPiece | undefined;
}

export interface FileUpload {
  dataUpload?: DataUpload | undefined;
  chunkPiece?: ChunkPiece | undefined;
  error?: FailedFile | undefined;
}

export interface FailedFile {
  error: string;
}

export interface DataUpload {
  uploadType: DataUploadType;
  /**
   * data_hash is the sha256 of the payload to be uploaded.
   * This is also used to uniquely identify the upload.
   */
  dataHash: Uint8Array;
  /** file_size is the total size of the data being uploaded. */
  fileSize: number;
  /** Number of chunks to be uploaded. */
  chunks: number;
}

/** ChunkPiece is used to stream over large files (over the 4mb limit). */
export interface ChunkPiece {
  data: Uint8Array;
  /**
   * full_data_hash should match the hash from the original
   * DataUpload message
   */
  fullDataHash: Uint8Array;
  pieceIndex: number;
}

export const Empty = {
  encode(_: Empty, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    return writer;
  },
};

export const TemplateVariable = {
  encode(message: TemplateVariable, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(18).string(message.description);
    }
    if (message.type !== "") {
      writer.uint32(26).string(message.type);
    }
    if (message.defaultValue !== "") {
      writer.uint32(34).string(message.defaultValue);
    }
    if (message.required !== false) {
      writer.uint32(40).bool(message.required);
    }
    if (message.sensitive !== false) {
      writer.uint32(48).bool(message.sensitive);
    }
    return writer;
  },
};

export const RichParameterOption = {
  encode(message: RichParameterOption, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(18).string(message.description);
    }
    if (message.value !== "") {
      writer.uint32(26).string(message.value);
    }
    if (message.icon !== "") {
      writer.uint32(34).string(message.icon);
    }
    return writer;
  },
};

export const RichParameter = {
  encode(message: RichParameter, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.description !== "") {
      writer.uint32(18).string(message.description);
    }
    if (message.type !== "") {
      writer.uint32(26).string(message.type);
    }
    if (message.mutable !== false) {
      writer.uint32(32).bool(message.mutable);
    }
    if (message.defaultValue !== "") {
      writer.uint32(42).string(message.defaultValue);
    }
    if (message.icon !== "") {
      writer.uint32(50).string(message.icon);
    }
    for (const v of message.options) {
      RichParameterOption.encode(v!, writer.uint32(58).fork()).ldelim();
    }
    if (message.validationRegex !== "") {
      writer.uint32(66).string(message.validationRegex);
    }
    if (message.validationError !== "") {
      writer.uint32(74).string(message.validationError);
    }
    if (message.validationMin !== undefined) {
      writer.uint32(80).int32(message.validationMin);
    }
    if (message.validationMax !== undefined) {
      writer.uint32(88).int32(message.validationMax);
    }
    if (message.validationMonotonic !== "") {
      writer.uint32(98).string(message.validationMonotonic);
    }
    if (message.required !== false) {
      writer.uint32(104).bool(message.required);
    }
    if (message.displayName !== "") {
      writer.uint32(122).string(message.displayName);
    }
    if (message.order !== 0) {
      writer.uint32(128).int32(message.order);
    }
    if (message.ephemeral !== false) {
      writer.uint32(136).bool(message.ephemeral);
    }
    if (message.formType !== 0) {
      writer.uint32(144).int32(message.formType);
    }
    return writer;
  },
};

export const RichParameterValue = {
  encode(message: RichParameterValue, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
};

export const ExpirationPolicy = {
  encode(message: ExpirationPolicy, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.ttl !== 0) {
      writer.uint32(8).int32(message.ttl);
    }
    return writer;
  },
};

export const Schedule = {
  encode(message: Schedule, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.cron !== "") {
      writer.uint32(10).string(message.cron);
    }
    if (message.instances !== 0) {
      writer.uint32(16).int32(message.instances);
    }
    return writer;
  },
};

export const Scheduling = {
  encode(message: Scheduling, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.timezone !== "") {
      writer.uint32(10).string(message.timezone);
    }
    for (const v of message.schedule) {
      Schedule.encode(v!, writer.uint32(18).fork()).ldelim();
    }
    return writer;
  },
};

export const Prebuild = {
  encode(message: Prebuild, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.instances !== 0) {
      writer.uint32(8).int32(message.instances);
    }
    if (message.expirationPolicy !== undefined) {
      ExpirationPolicy.encode(message.expirationPolicy, writer.uint32(18).fork()).ldelim();
    }
    if (message.scheduling !== undefined) {
      Scheduling.encode(message.scheduling, writer.uint32(26).fork()).ldelim();
    }
    return writer;
  },
};

export const Preset = {
  encode(message: Preset, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    for (const v of message.parameters) {
      PresetParameter.encode(v!, writer.uint32(18).fork()).ldelim();
    }
    if (message.prebuild !== undefined) {
      Prebuild.encode(message.prebuild, writer.uint32(26).fork()).ldelim();
    }
    if (message.default !== false) {
      writer.uint32(32).bool(message.default);
    }
    if (message.description !== "") {
      writer.uint32(42).string(message.description);
    }
    if (message.icon !== "") {
      writer.uint32(50).string(message.icon);
    }
    return writer;
  },
};

export const PresetParameter = {
  encode(message: PresetParameter, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
};

export const ResourceReplacement = {
  encode(message: ResourceReplacement, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.resource !== "") {
      writer.uint32(10).string(message.resource);
    }
    for (const v of message.paths) {
      writer.uint32(18).string(v!);
    }
    return writer;
  },
};

export const VariableValue = {
  encode(message: VariableValue, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    if (message.sensitive !== false) {
      writer.uint32(24).bool(message.sensitive);
    }
    return writer;
  },
};

export const Log = {
  encode(message: Log, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.level !== 0) {
      writer.uint32(8).int32(message.level);
    }
    if (message.output !== "") {
      writer.uint32(18).string(message.output);
    }
    return writer;
  },
};

export const InstanceIdentityAuth = {
  encode(message: InstanceIdentityAuth, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.instanceId !== "") {
      writer.uint32(10).string(message.instanceId);
    }
    return writer;
  },
};

export const ExternalAuthProviderResource = {
  encode(message: ExternalAuthProviderResource, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.optional !== false) {
      writer.uint32(16).bool(message.optional);
    }
    return writer;
  },
};

export const ExternalAuthProvider = {
  encode(message: ExternalAuthProvider, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.accessToken !== "") {
      writer.uint32(18).string(message.accessToken);
    }
    return writer;
  },
};

export const Agent = {
  encode(message: Agent, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.name !== "") {
      writer.uint32(18).string(message.name);
    }
    Object.entries(message.env).forEach(([key, value]) => {
      Agent_EnvEntry.encode({ key: key as any, value }, writer.uint32(26).fork()).ldelim();
    });
    if (message.operatingSystem !== "") {
      writer.uint32(42).string(message.operatingSystem);
    }
    if (message.architecture !== "") {
      writer.uint32(50).string(message.architecture);
    }
    if (message.directory !== "") {
      writer.uint32(58).string(message.directory);
    }
    for (const v of message.apps) {
      App.encode(v!, writer.uint32(66).fork()).ldelim();
    }
    if (message.token !== undefined) {
      writer.uint32(74).string(message.token);
    }
    if (message.instanceId !== undefined) {
      writer.uint32(82).string(message.instanceId);
    }
    if (message.connectionTimeoutSeconds !== 0) {
      writer.uint32(88).int32(message.connectionTimeoutSeconds);
    }
    if (message.troubleshootingUrl !== "") {
      writer.uint32(98).string(message.troubleshootingUrl);
    }
    if (message.motdFile !== "") {
      writer.uint32(106).string(message.motdFile);
    }
    for (const v of message.metadata) {
      Agent_Metadata.encode(v!, writer.uint32(146).fork()).ldelim();
    }
    if (message.displayApps !== undefined) {
      DisplayApps.encode(message.displayApps, writer.uint32(162).fork()).ldelim();
    }
    for (const v of message.scripts) {
      Script.encode(v!, writer.uint32(170).fork()).ldelim();
    }
    for (const v of message.extraEnvs) {
      Env.encode(v!, writer.uint32(178).fork()).ldelim();
    }
    if (message.order !== 0) {
      writer.uint32(184).int64(message.order);
    }
    if (message.resourcesMonitoring !== undefined) {
      ResourcesMonitoring.encode(message.resourcesMonitoring, writer.uint32(194).fork()).ldelim();
    }
    for (const v of message.devcontainers) {
      Devcontainer.encode(v!, writer.uint32(202).fork()).ldelim();
    }
    if (message.apiKeyScope !== "") {
      writer.uint32(210).string(message.apiKeyScope);
    }
    return writer;
  },
};

export const Agent_Metadata = {
  encode(message: Agent_Metadata, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.displayName !== "") {
      writer.uint32(18).string(message.displayName);
    }
    if (message.script !== "") {
      writer.uint32(26).string(message.script);
    }
    if (message.interval !== 0) {
      writer.uint32(32).int64(message.interval);
    }
    if (message.timeout !== 0) {
      writer.uint32(40).int64(message.timeout);
    }
    if (message.order !== 0) {
      writer.uint32(48).int64(message.order);
    }
    return writer;
  },
};

export const Agent_EnvEntry = {
  encode(message: Agent_EnvEntry, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
};

export const ResourcesMonitoring = {
  encode(message: ResourcesMonitoring, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.memory !== undefined) {
      MemoryResourceMonitor.encode(message.memory, writer.uint32(10).fork()).ldelim();
    }
    for (const v of message.volumes) {
      VolumeResourceMonitor.encode(v!, writer.uint32(18).fork()).ldelim();
    }
    return writer;
  },
};

export const MemoryResourceMonitor = {
  encode(message: MemoryResourceMonitor, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.enabled !== false) {
      writer.uint32(8).bool(message.enabled);
    }
    if (message.threshold !== 0) {
      writer.uint32(16).int32(message.threshold);
    }
    return writer;
  },
};

export const VolumeResourceMonitor = {
  encode(message: VolumeResourceMonitor, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.path !== "") {
      writer.uint32(10).string(message.path);
    }
    if (message.enabled !== false) {
      writer.uint32(16).bool(message.enabled);
    }
    if (message.threshold !== 0) {
      writer.uint32(24).int32(message.threshold);
    }
    return writer;
  },
};

export const DisplayApps = {
  encode(message: DisplayApps, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.vscode !== false) {
      writer.uint32(8).bool(message.vscode);
    }
    if (message.vscodeInsiders !== false) {
      writer.uint32(16).bool(message.vscodeInsiders);
    }
    if (message.webTerminal !== false) {
      writer.uint32(24).bool(message.webTerminal);
    }
    if (message.sshHelper !== false) {
      writer.uint32(32).bool(message.sshHelper);
    }
    if (message.portForwardingHelper !== false) {
      writer.uint32(40).bool(message.portForwardingHelper);
    }
    return writer;
  },
};

export const Env = {
  encode(message: Env, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
};

export const Script = {
  encode(message: Script, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.displayName !== "") {
      writer.uint32(10).string(message.displayName);
    }
    if (message.icon !== "") {
      writer.uint32(18).string(message.icon);
    }
    if (message.script !== "") {
      writer.uint32(26).string(message.script);
    }
    if (message.cron !== "") {
      writer.uint32(34).string(message.cron);
    }
    if (message.startBlocksLogin !== false) {
      writer.uint32(40).bool(message.startBlocksLogin);
    }
    if (message.runOnStart !== false) {
      writer.uint32(48).bool(message.runOnStart);
    }
    if (message.runOnStop !== false) {
      writer.uint32(56).bool(message.runOnStop);
    }
    if (message.timeoutSeconds !== 0) {
      writer.uint32(64).int32(message.timeoutSeconds);
    }
    if (message.logPath !== "") {
      writer.uint32(74).string(message.logPath);
    }
    return writer;
  },
};

export const Devcontainer = {
  encode(message: Devcontainer, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.workspaceFolder !== "") {
      writer.uint32(10).string(message.workspaceFolder);
    }
    if (message.configPath !== "") {
      writer.uint32(18).string(message.configPath);
    }
    if (message.name !== "") {
      writer.uint32(26).string(message.name);
    }
    return writer;
  },
};

export const App = {
  encode(message: App, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.slug !== "") {
      writer.uint32(10).string(message.slug);
    }
    if (message.displayName !== "") {
      writer.uint32(18).string(message.displayName);
    }
    if (message.command !== "") {
      writer.uint32(26).string(message.command);
    }
    if (message.url !== "") {
      writer.uint32(34).string(message.url);
    }
    if (message.icon !== "") {
      writer.uint32(42).string(message.icon);
    }
    if (message.subdomain !== false) {
      writer.uint32(48).bool(message.subdomain);
    }
    if (message.healthcheck !== undefined) {
      Healthcheck.encode(message.healthcheck, writer.uint32(58).fork()).ldelim();
    }
    if (message.sharingLevel !== 0) {
      writer.uint32(64).int32(message.sharingLevel);
    }
    if (message.external !== false) {
      writer.uint32(72).bool(message.external);
    }
    if (message.order !== 0) {
      writer.uint32(80).int64(message.order);
    }
    if (message.hidden !== false) {
      writer.uint32(88).bool(message.hidden);
    }
    if (message.openIn !== 0) {
      writer.uint32(96).int32(message.openIn);
    }
    if (message.group !== "") {
      writer.uint32(106).string(message.group);
    }
    if (message.id !== "") {
      writer.uint32(114).string(message.id);
    }
    if (message.tooltip !== "") {
      writer.uint32(122).string(message.tooltip);
    }
    return writer;
  },
};

export const Healthcheck = {
  encode(message: Healthcheck, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.url !== "") {
      writer.uint32(10).string(message.url);
    }
    if (message.interval !== 0) {
      writer.uint32(16).int32(message.interval);
    }
    if (message.threshold !== 0) {
      writer.uint32(24).int32(message.threshold);
    }
    return writer;
  },
};

export const Resource = {
  encode(message: Resource, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.type !== "") {
      writer.uint32(18).string(message.type);
    }
    for (const v of message.agents) {
      Agent.encode(v!, writer.uint32(26).fork()).ldelim();
    }
    for (const v of message.metadata) {
      Resource_Metadata.encode(v!, writer.uint32(34).fork()).ldelim();
    }
    if (message.hide !== false) {
      writer.uint32(40).bool(message.hide);
    }
    if (message.icon !== "") {
      writer.uint32(50).string(message.icon);
    }
    if (message.instanceType !== "") {
      writer.uint32(58).string(message.instanceType);
    }
    if (message.dailyCost !== 0) {
      writer.uint32(64).int32(message.dailyCost);
    }
    if (message.modulePath !== "") {
      writer.uint32(74).string(message.modulePath);
    }
    return writer;
  },
};

export const Resource_Metadata = {
  encode(message: Resource_Metadata, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    if (message.sensitive !== false) {
      writer.uint32(24).bool(message.sensitive);
    }
    if (message.isNull !== false) {
      writer.uint32(32).bool(message.isNull);
    }
    return writer;
  },
};

export const Module = {
  encode(message: Module, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.source !== "") {
      writer.uint32(10).string(message.source);
    }
    if (message.version !== "") {
      writer.uint32(18).string(message.version);
    }
    if (message.key !== "") {
      writer.uint32(26).string(message.key);
    }
    if (message.dir !== "") {
      writer.uint32(34).string(message.dir);
    }
    return writer;
  },
};

export const Role = {
  encode(message: Role, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.name !== "") {
      writer.uint32(10).string(message.name);
    }
    if (message.orgId !== "") {
      writer.uint32(18).string(message.orgId);
    }
    return writer;
  },
};

export const RunningAgentAuthToken = {
  encode(message: RunningAgentAuthToken, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.agentId !== "") {
      writer.uint32(10).string(message.agentId);
    }
    if (message.token !== "") {
      writer.uint32(18).string(message.token);
    }
    return writer;
  },
};

export const AITaskSidebarApp = {
  encode(message: AITaskSidebarApp, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    return writer;
  },
};

export const AITask = {
  encode(message: AITask, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.id !== "") {
      writer.uint32(10).string(message.id);
    }
    if (message.sidebarApp !== undefined) {
      AITaskSidebarApp.encode(message.sidebarApp, writer.uint32(18).fork()).ldelim();
    }
    if (message.appId !== "") {
      writer.uint32(26).string(message.appId);
    }
    return writer;
  },
};

export const Metadata = {
  encode(message: Metadata, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.coderUrl !== "") {
      writer.uint32(10).string(message.coderUrl);
    }
    if (message.workspaceTransition !== 0) {
      writer.uint32(16).int32(message.workspaceTransition);
    }
    if (message.workspaceName !== "") {
      writer.uint32(26).string(message.workspaceName);
    }
    if (message.workspaceOwner !== "") {
      writer.uint32(34).string(message.workspaceOwner);
    }
    if (message.workspaceId !== "") {
      writer.uint32(42).string(message.workspaceId);
    }
    if (message.workspaceOwnerId !== "") {
      writer.uint32(50).string(message.workspaceOwnerId);
    }
    if (message.workspaceOwnerEmail !== "") {
      writer.uint32(58).string(message.workspaceOwnerEmail);
    }
    if (message.templateName !== "") {
      writer.uint32(66).string(message.templateName);
    }
    if (message.templateVersion !== "") {
      writer.uint32(74).string(message.templateVersion);
    }
    if (message.workspaceOwnerOidcAccessToken !== "") {
      writer.uint32(82).string(message.workspaceOwnerOidcAccessToken);
    }
    if (message.workspaceOwnerSessionToken !== "") {
      writer.uint32(90).string(message.workspaceOwnerSessionToken);
    }
    if (message.templateId !== "") {
      writer.uint32(98).string(message.templateId);
    }
    if (message.workspaceOwnerName !== "") {
      writer.uint32(106).string(message.workspaceOwnerName);
    }
    for (const v of message.workspaceOwnerGroups) {
      writer.uint32(114).string(v!);
    }
    if (message.workspaceOwnerSshPublicKey !== "") {
      writer.uint32(122).string(message.workspaceOwnerSshPublicKey);
    }
    if (message.workspaceOwnerSshPrivateKey !== "") {
      writer.uint32(130).string(message.workspaceOwnerSshPrivateKey);
    }
    if (message.workspaceBuildId !== "") {
      writer.uint32(138).string(message.workspaceBuildId);
    }
    if (message.workspaceOwnerLoginType !== "") {
      writer.uint32(146).string(message.workspaceOwnerLoginType);
    }
    for (const v of message.workspaceOwnerRbacRoles) {
      Role.encode(v!, writer.uint32(154).fork()).ldelim();
    }
    if (message.prebuiltWorkspaceBuildStage !== 0) {
      writer.uint32(160).int32(message.prebuiltWorkspaceBuildStage);
    }
    for (const v of message.runningAgentAuthTokens) {
      RunningAgentAuthToken.encode(v!, writer.uint32(170).fork()).ldelim();
    }
    if (message.taskId !== "") {
      writer.uint32(178).string(message.taskId);
    }
    if (message.taskPrompt !== "") {
      writer.uint32(186).string(message.taskPrompt);
    }
    if (message.templateVersionId !== "") {
      writer.uint32(194).string(message.templateVersionId);
    }
    if (message.templateVersionModulesFile !== "") {
      writer.uint32(202).string(message.templateVersionModulesFile);
    }
    return writer;
  },
};

export const Config = {
  encode(message: Config, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.provisionerLogLevel !== "") {
      writer.uint32(10).string(message.provisionerLogLevel);
    }
    if (message.templateId !== undefined) {
      writer.uint32(18).string(message.templateId);
    }
    if (message.templateVersionId !== undefined) {
      writer.uint32(26).string(message.templateVersionId);
    }
    return writer;
  },
};

export const ParseRequest = {
  encode(_: ParseRequest, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    return writer;
  },
};

export const ParseComplete = {
  encode(message: ParseComplete, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.error !== "") {
      writer.uint32(10).string(message.error);
    }
    for (const v of message.templateVariables) {
      TemplateVariable.encode(v!, writer.uint32(18).fork()).ldelim();
    }
    if (message.readme.length !== 0) {
      writer.uint32(26).bytes(message.readme);
    }
    Object.entries(message.workspaceTags).forEach(([key, value]) => {
      ParseComplete_WorkspaceTagsEntry.encode({ key: key as any, value }, writer.uint32(34).fork()).ldelim();
    });
    return writer;
  },
};

export const ParseComplete_WorkspaceTagsEntry = {
  encode(message: ParseComplete_WorkspaceTagsEntry, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.key !== "") {
      writer.uint32(10).string(message.key);
    }
    if (message.value !== "") {
      writer.uint32(18).string(message.value);
    }
    return writer;
  },
};

export const InitRequest = {
  encode(message: InitRequest, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.templateSourceArchive.length !== 0) {
      writer.uint32(10).bytes(message.templateSourceArchive);
    }
    if (message.omitModuleFiles !== false) {
      writer.uint32(24).bool(message.omitModuleFiles);
    }
    if (message.initialModuleTarHash.length !== 0) {
      writer.uint32(34).bytes(message.initialModuleTarHash);
    }
    return writer;
  },
};

export const InitComplete = {
  encode(message: InitComplete, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.error !== "") {
      writer.uint32(10).string(message.error);
    }
    for (const v of message.timings) {
      Timing.encode(v!, writer.uint32(18).fork()).ldelim();
    }
    for (const v of message.modules) {
      Module.encode(v!, writer.uint32(26).fork()).ldelim();
    }
    if (message.moduleFiles.length !== 0) {
      writer.uint32(34).bytes(message.moduleFiles);
    }
    if (message.moduleFilesHash.length !== 0) {
      writer.uint32(42).bytes(message.moduleFilesHash);
    }
    return writer;
  },
};

export const PlanRequest = {
  encode(message: PlanRequest, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.metadata !== undefined) {
      Metadata.encode(message.metadata, writer.uint32(10).fork()).ldelim();
    }
    for (const v of message.richParameterValues) {
      RichParameterValue.encode(v!, writer.uint32(18).fork()).ldelim();
    }
    for (const v of message.variableValues) {
      VariableValue.encode(v!, writer.uint32(26).fork()).ldelim();
    }
    for (const v of message.externalAuthProviders) {
      ExternalAuthProvider.encode(v!, writer.uint32(34).fork()).ldelim();
    }
    for (const v of message.previousParameterValues) {
      RichParameterValue.encode(v!, writer.uint32(42).fork()).ldelim();
    }
    if (message.state.length !== 0) {
      writer.uint32(50).bytes(message.state);
    }
    return writer;
  },
};

export const PlanComplete = {
  encode(message: PlanComplete, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.error !== "") {
      writer.uint32(10).string(message.error);
    }
    for (const v of message.timings) {
      Timing.encode(v!, writer.uint32(18).fork()).ldelim();
    }
    if (message.plan.length !== 0) {
      writer.uint32(26).bytes(message.plan);
    }
    if (message.dailyCost !== 0) {
      writer.uint32(32).int32(message.dailyCost);
    }
    for (const v of message.resourceReplacements) {
      ResourceReplacement.encode(v!, writer.uint32(42).fork()).ldelim();
    }
    if (message.aiTaskCount !== 0) {
      writer.uint32(48).int32(message.aiTaskCount);
    }
    return writer;
  },
};

export const ApplyRequest = {
  encode(message: ApplyRequest, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.metadata !== undefined) {
      Metadata.encode(message.metadata, writer.uint32(10).fork()).ldelim();
    }
    return writer;
  },
};

export const ApplyComplete = {
  encode(message: ApplyComplete, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.state.length !== 0) {
      writer.uint32(10).bytes(message.state);
    }
    if (message.error !== "") {
      writer.uint32(18).string(message.error);
    }
    for (const v of message.timings) {
      Timing.encode(v!, writer.uint32(26).fork()).ldelim();
    }
    return writer;
  },
};

export const GraphRequest = {
  encode(message: GraphRequest, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.metadata !== undefined) {
      Metadata.encode(message.metadata, writer.uint32(10).fork()).ldelim();
    }
    if (message.source !== 0) {
      writer.uint32(16).int32(message.source);
    }
    return writer;
  },
};

export const GraphComplete = {
  encode(message: GraphComplete, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.error !== "") {
      writer.uint32(10).string(message.error);
    }
    for (const v of message.timings) {
      Timing.encode(v!, writer.uint32(18).fork()).ldelim();
    }
    for (const v of message.resources) {
      Resource.encode(v!, writer.uint32(26).fork()).ldelim();
    }
    for (const v of message.parameters) {
      RichParameter.encode(v!, writer.uint32(34).fork()).ldelim();
    }
    for (const v of message.externalAuthProviders) {
      ExternalAuthProviderResource.encode(v!, writer.uint32(42).fork()).ldelim();
    }
    for (const v of message.presets) {
      Preset.encode(v!, writer.uint32(50).fork()).ldelim();
    }
    if (message.hasAiTasks !== false) {
      writer.uint32(56).bool(message.hasAiTasks);
    }
    for (const v of message.aiTasks) {
      AITask.encode(v!, writer.uint32(66).fork()).ldelim();
    }
    if (message.hasExternalAgents !== false) {
      writer.uint32(72).bool(message.hasExternalAgents);
    }
    return writer;
  },
};

export const Timing = {
  encode(message: Timing, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.start !== undefined) {
      Timestamp.encode(toTimestamp(message.start), writer.uint32(10).fork()).ldelim();
    }
    if (message.end !== undefined) {
      Timestamp.encode(toTimestamp(message.end), writer.uint32(18).fork()).ldelim();
    }
    if (message.action !== "") {
      writer.uint32(26).string(message.action);
    }
    if (message.source !== "") {
      writer.uint32(34).string(message.source);
    }
    if (message.resource !== "") {
      writer.uint32(42).string(message.resource);
    }
    if (message.stage !== "") {
      writer.uint32(50).string(message.stage);
    }
    if (message.state !== 0) {
      writer.uint32(56).int32(message.state);
    }
    return writer;
  },
};

export const CancelRequest = {
  encode(_: CancelRequest, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    return writer;
  },
};

export const Request = {
  encode(message: Request, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.config !== undefined) {
      Config.encode(message.config, writer.uint32(10).fork()).ldelim();
    }
    if (message.parse !== undefined) {
      ParseRequest.encode(message.parse, writer.uint32(18).fork()).ldelim();
    }
    if (message.init !== undefined) {
      InitRequest.encode(message.init, writer.uint32(26).fork()).ldelim();
    }
    if (message.plan !== undefined) {
      PlanRequest.encode(message.plan, writer.uint32(34).fork()).ldelim();
    }
    if (message.apply !== undefined) {
      ApplyRequest.encode(message.apply, writer.uint32(42).fork()).ldelim();
    }
    if (message.graph !== undefined) {
      GraphRequest.encode(message.graph, writer.uint32(50).fork()).ldelim();
    }
    if (message.cancel !== undefined) {
      CancelRequest.encode(message.cancel, writer.uint32(58).fork()).ldelim();
    }
    if (message.file !== undefined) {
      FileUpload.encode(message.file, writer.uint32(66).fork()).ldelim();
    }
    return writer;
  },
};

export const Response = {
  encode(message: Response, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.log !== undefined) {
      Log.encode(message.log, writer.uint32(10).fork()).ldelim();
    }
    if (message.parse !== undefined) {
      ParseComplete.encode(message.parse, writer.uint32(18).fork()).ldelim();
    }
    if (message.init !== undefined) {
      InitComplete.encode(message.init, writer.uint32(26).fork()).ldelim();
    }
    if (message.plan !== undefined) {
      PlanComplete.encode(message.plan, writer.uint32(34).fork()).ldelim();
    }
    if (message.apply !== undefined) {
      ApplyComplete.encode(message.apply, writer.uint32(42).fork()).ldelim();
    }
    if (message.graph !== undefined) {
      GraphComplete.encode(message.graph, writer.uint32(50).fork()).ldelim();
    }
    if (message.dataUpload !== undefined) {
      DataUpload.encode(message.dataUpload, writer.uint32(58).fork()).ldelim();
    }
    if (message.chunkPiece !== undefined) {
      ChunkPiece.encode(message.chunkPiece, writer.uint32(66).fork()).ldelim();
    }
    return writer;
  },
};

export const FileUpload = {
  encode(message: FileUpload, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.dataUpload !== undefined) {
      DataUpload.encode(message.dataUpload, writer.uint32(10).fork()).ldelim();
    }
    if (message.chunkPiece !== undefined) {
      ChunkPiece.encode(message.chunkPiece, writer.uint32(18).fork()).ldelim();
    }
    if (message.error !== undefined) {
      FailedFile.encode(message.error, writer.uint32(26).fork()).ldelim();
    }
    return writer;
  },
};

export const FailedFile = {
  encode(message: FailedFile, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.error !== "") {
      writer.uint32(10).string(message.error);
    }
    return writer;
  },
};

export const DataUpload = {
  encode(message: DataUpload, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.uploadType !== 0) {
      writer.uint32(8).int32(message.uploadType);
    }
    if (message.dataHash.length !== 0) {
      writer.uint32(18).bytes(message.dataHash);
    }
    if (message.fileSize !== 0) {
      writer.uint32(24).int64(message.fileSize);
    }
    if (message.chunks !== 0) {
      writer.uint32(32).int32(message.chunks);
    }
    return writer;
  },
};

export const ChunkPiece = {
  encode(message: ChunkPiece, writer: _m0.Writer = _m0.Writer.create()): _m0.Writer {
    if (message.data.length !== 0) {
      writer.uint32(10).bytes(message.data);
    }
    if (message.fullDataHash.length !== 0) {
      writer.uint32(18).bytes(message.fullDataHash);
    }
    if (message.pieceIndex !== 0) {
      writer.uint32(24).int32(message.pieceIndex);
    }
    return writer;
  },
};

export interface Provisioner {
  /**
   * Session represents provisioning a single template import or workspace.  The daemon always sends Config followed
   * by one of the requests (InitRequest, ParseRequest, PlanRequest, ApplyRequest, GraphRequest).  The provisioner
   * should respond with a stream of zero or more Logs, followed by the corresponding complete message
   * (InitComplete, ParseComplete, PlanComplete, ApplyComplete, GraphComplete).
   * The daemon may then send a new request.
   *
   * A request to Parse or Plan MUST be preceded by a request init. The provisioner should store the init data on
   * the session after a successful init. If the daemon closes the session, the init data may be safely discarded.
   *
   * A request to apply MUST be preceded by a request plan, and the provisioner should store the plan data on the
   * Session after a successful plan, so that the daemon may request an apply.  If the daemon closes
   * the Session without an apply, the plan data may be safely discarded.
   *
   * A request to graph MUST be preceded by a plan or an apply.
   *
   * The order of requests is then one of the following:
   * 1. Init -> Parse
   * 2. Init -> Plan -> Graph
   * 3. Init -> Plan -> Apply -> Graph
   *
   * The daemon may send a CancelRequest, asynchronously to ask the provisioner to cancel the previous InitRequest,
   * ParseRequest, PlanRequest, ApplyRequest, or GraphRequest.  The provisioner MUST reply with a complete message
   * corresponding to the request that was canceled.  If the provisioner has already completed the request,
   * it may ignore the CancelRequest.
   */
  Session(request: Observable<Request>): Observable<Response>;
}

function toTimestamp(date: Date): Timestamp {
  const seconds = Math.trunc(date.getTime() / 1_000);
  const nanos = (date.getTime() % 1_000) * 1_000_000;
  return { seconds, nanos };
}
